/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisIdentifierOps;
import oracle.sysman.oii.oiis.OiisInvalidValueException;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisFileSizeInfo
implements Serializable,
Cloneable {
    static final long serialVersionUID = 4567299637806197564L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    private Vector m_plats;
    private Vector m_platSets;
    private Vector m_platToSetsMapping;
    private OiisPlatIndexMapping m_platIndMap = null;
    private Vector m_langSets;
    private Vector m_langToSetsMapping;
    private OiisLangIndexMapping m_langIndMap = null;
    private transient OiisDestinationIndexMapping m_destIndMap = null;
    private transient OiisCompContext m_oCompContext;
    private transient Hashtable m_oFileSizeRollupTable;
    private int[][] m_sizes;
    private long[] m_lLGroupJar;
    private long[][] m_lSizes;
    private long[][][] m_alSizes;
    private Object[] m_aoOffsets;
    private int[] m_aiOffsetType;
    private Object[] m_aoTempOffsets;
    private int[] m_aiTempOffsetType;
    private Object[] m_aoNonInstallOffsets;
    private int[] m_aiNonInstallOffsetType;
    public static final int S_OFFSET_TYPE_NUMBER = 1;
    public static final int S_OFFSET_TYPE_CONSTANT = 2;
    public static final int S_OFFSET_TYPE_VARIABLE = 6;
    private static final int FILESIZEINFO_OPT_PLATLANG_INFO = 1;
    private int m_iFileSizeInfoType = 0;
    private static final int S_VARIABLE_SIZE = 122;
    private static final int S_CONST_SIZE = 122;
    private static final int S_TEXT_INV_SIZE = 1500;
    private static final int S_BIN_INV_SIZE = 2000;
    private static final int S_SIZE_AVG_ACTION = 533;
    public static final String S_DEFAULT_DESTN = "%ORACLE_HOME%";
    public static final String S_CENTRAL_INVENTORY = "%INVENTORY_LOCATION%";
    public static final String S_ORACLE_HOME_INVENTORY = "%ORACLE_HOME%";
    public static final String S_APPLTOP_INVENTORY = "%APPLTOP%";
    public static final int DESTINATION_OFFSET = 1;
    public static final int TEMP_OFFSET = 2;
    public static final int NONINSTALL_OFFSET = 4;

    public OiisFileSizeInfo(OiisPlatIndexMapping platIndMap, OiisLangIndexMapping langIndMap, OiisDestinationIndexMapping destIndMap) {
        this.m_platIndMap = platIndMap;
        this.m_langIndMap = langIndMap;
        this.m_destIndMap = destIndMap;
        this.m_iFileSizeInfoType = 1;
        this.m_platSets = null;
        this.m_langSets = null;
        this.m_lSizes = null;
        this.m_sizes = null;
        this.m_plats = null;
        this.initSizesArray();
    }

    public OiisFileSizeInfo(OiisPlatIndexMapping platIndMap, OiisLangIndexMapping langIndMap) {
        this.m_platSets = new Vector();
        this.m_platIndMap = platIndMap;
        this.m_langSets = new Vector();
        this.m_langIndMap = langIndMap;
        this.m_lSizes = null;
        this.m_sizes = null;
        this.m_plats = null;
    }

    public OiisFileSizeInfo(OiisPlatIndexMapping platIndMap, OiisLangIndexMapping langIndMap, Vector plats) {
        this(platIndMap, langIndMap);
        this.m_plats = plats;
    }

    public void setCompContext(OiisCompContext oCompContext) {
        this.m_oCompContext = oCompContext;
    }

    public Vector getLangSets() {
        return this.m_langSets;
    }

    public Vector getPlatSets() {
        return this.m_platSets;
    }

    public static String[] getDefaultDestVars() {
        String[] retDests = new String[]{"%ORACLE_HOME%"};
        return retDests;
    }

    public void addFileGroupSetsInfo(OiisFileGroup fGroup) {
        this.addFileGroupSetsInfo(fGroup, null);
    }

    public void addFileGroupSetsInfo(OiisFileGroup fGroup, Vector plats) {
        if (this.m_iFileSizeInfoType != 1) {
            this.getSizesArrayEx();
            if (this.m_lSizes != null) {
                return;
            }
            Vector gLSets = fGroup.getLangSets();
            int numGLSets = gLSets.size();
            for (int i = 0; i < numGLSets; ++i) {
                BitSet bs = (BitSet)gLSets.elementAt(i);
                if (this.indexOfLangBitSet(bs) != -1) continue;
                this.m_langSets.addElement(bs);
            }
            Vector gPSets = plats == null ? fGroup.getPlatSets() : fGroup.getRelevantPlatSets(plats);
            int numGPSets = gPSets.size();
            for (int i = 0; i < numGPSets; ++i) {
                BitSet bs = (BitSet)gPSets.elementAt(i);
                if (this.indexOfPlatBitSet(bs) != -1) continue;
                this.m_platSets.addElement(bs);
            }
        }
    }

    public void initSizesArray() {
        if (this.m_iFileSizeInfoType == 1) {
            int numLangs = this.m_langIndMap.getLangSets().size();
            int numPlats = this.m_platIndMap.getPlatSets().size();
            int numDest = this.m_destIndMap.size();
            this.m_alSizes = new long[numDest][numLangs + 1][numPlats];
            this.m_aoOffsets = new Object[numDest];
            this.m_aiOffsetType = new int[numDest];
            this.m_aoTempOffsets = new Object[numDest];
            this.m_aiTempOffsetType = new int[numDest];
            this.m_aoNonInstallOffsets = new Object[numDest];
            this.m_aiNonInstallOffsetType = new int[numDest];
            int numPlatsInPtSt = this.m_platIndMap.getPlats().length;
            this.m_lLGroupJar = new long[numPlatsInPtSt];
            Integer zero = new Integer(0);
            for (int i = 0; i < numDest; ++i) {
                for (int j = 0; j < numLangs; ++j) {
                    for (int k = 0; k < numPlats; ++k) {
                        this.m_alSizes[i][j][k] = 0L;
                    }
                }
                for (int k = 0; k < numPlats; ++k) {
                    this.m_alSizes[i][numLangs][k] = 0L;
                }
                this.m_aoOffsets[i] = zero;
                this.m_aiOffsetType[i] = 1;
                this.m_aoTempOffsets[i] = zero;
                this.m_aiTempOffsetType[i] = 1;
                this.m_aoNonInstallOffsets[i] = zero;
                this.m_aiNonInstallOffsetType[i] = 1;
            }
            for (int l = 0; l < numPlatsInPtSt; ++l) {
                this.m_lLGroupJar[l] = 0L;
            }
        } else {
            this.initSizesArray2x();
        }
    }

    private void initSizesArray2x() {
        int numLangs = this.m_langSets.size();
        int numPlats = this.m_platSets.size();
        this.m_lSizes = new long[numLangs][numPlats];
        this.m_sizes = new int[numLangs][numPlats];
        for (int i = 0; i < numLangs; ++i) {
            for (int j = 0; j < numPlats; ++j) {
                this.m_lSizes[i][j] = 0L;
                this.m_sizes[i][j] = 0;
            }
        }
    }

    private long getInstallActionsSize() {
        int nActions = 0;
        if (this.m_oCompContext != null) {
            int ip1 = this.m_oCompContext.getIP1FlowCount();
            int ip2 = this.m_oCompContext.getIP2FlowCount();
            int lkp = this.m_oCompContext.getLKPFlowCount();
            nActions = ip1 + ip2 + lkp;
        }
        return nActions * 533;
    }

    public long getLargestFileGroupJar(int iPlat) {
        int idx = this.m_platIndMap.indexOfPlat(iPlat);
        if (idx != -1 && this.m_lLGroupJar != null) {
            return this.m_lLGroupJar[this.m_platIndMap.indexOfPlat(iPlat)];
        }
        return 0L;
    }

    public void setLargestFileGroupJar(int iPlat, long lJarSz) {
        int idx = this.m_platIndMap.indexOfPlat(iPlat);
        if (idx != -1) {
            this.m_lLGroupJar[this.m_platIndMap.indexOfPlat((int)iPlat)] = lJarSz;
        }
    }

    public void computeFileSizesForRollup() {
        if (this.m_oFileSizeRollupTable == null) {
            if (this.m_iFileSizeInfoType == 1) {
                OiisCompConstants oCompConsts;
                this.m_oFileSizeRollupTable = this.initFileSizeRollupTable();
                int[] aiPlats = this.m_platIndMap.getPlats();
                if (this.m_alSizes.length > 0) {
                    for (int k = 0; k < this.m_alSizes[0][0].length; ++k) {
                        int[] aiPlatsList = this.m_platIndMap.getPlatsForPlatSetIndex(k);
                        for (int l = 0; l < aiPlatsList.length; ++l) {
                            Integer iPlatform = new Integer(aiPlatsList[l]);
                            long[] alSizes = (long[])this.m_oFileSizeRollupTable.get(iPlatform);
                            for (int j = 0; j < this.m_alSizes[0].length; ++j) {
                                for (int i = 0; i < this.m_alSizes.length; ++i) {
                                    int n = j;
                                    alSizes[n] = alSizes[n] + this.m_alSizes[i][j][k];
                                }
                            }
                        }
                    }
                }
                int iIndexForAllLangs = this.m_langIndMap.indexOfLangBitSet(this.m_langIndMap.genLangAllBitSet());
                Enumeration platKeys = this.m_oFileSizeRollupTable.keys();
                OiisCompConstants oiisCompConstants = oCompConsts = this.m_oCompContext != null ? this.m_oCompContext.getCompConstants() : null;
                while (platKeys.hasMoreElements()) {
                    Integer oPlat = (Integer)platKeys.nextElement();
                    int iPlat = oPlat;
                    long[] lSizes = (long[])this.m_oFileSizeRollupTable.get(oPlat);
                    Vector<Object[]> vAllOffsets = new Vector<Object[]>(2);
                    Vector<int[]> vAllOffsetTypes = new Vector<int[]>(2);
                    vAllOffsets.addElement(this.m_aoOffsets);
                    vAllOffsetTypes.addElement(this.m_aiOffsetType);
                    if (this.m_aoNonInstallOffsets != null) {
                        vAllOffsets.addElement(this.m_aoNonInstallOffsets);
                        vAllOffsetTypes.addElement(this.m_aiNonInstallOffsetType);
                    }
                    for (int l = 0; l < vAllOffsets.size(); ++l) {
                        Object[] aoOffsets = (Object[])vAllOffsets.elementAt(l);
                        int[] aiOffsetsType = (int[])vAllOffsetTypes.elementAt(l);
                        block10: for (int m = 0; m < aoOffsets.length; ++m) {
                            switch (aiOffsetsType[m]) {
                                case 1: {
                                    int n = iIndexForAllLangs;
                                    lSizes[n] = lSizes[n] + (long)((Integer)aoOffsets[m]).intValue();
                                    continue block10;
                                }
                                case 2: {
                                    if (oCompConsts == null) continue block10;
                                    String sConst = (String)aoOffsets[m];
                                    OiisGenericConstant oConst = oCompConsts.getConstant(sConst);
                                    int iOffset = (Integer)oConst.getValue(iPlat);
                                    int n = iIndexForAllLangs;
                                    lSizes[n] = lSizes[n] + (long)iOffset;
                                    continue block10;
                                }
                            }
                        }
                    }
                    int n = iIndexForAllLangs;
                    lSizes[n] = lSizes[n] + this.getInvSizesAggregate();
                    int n2 = iIndexForAllLangs;
                    lSizes[n2] = lSizes[n2] + this.getSizeOfBinaryInv();
                }
            } else {
                this.computeFileSizesForRollup2x();
            }
        }
    }

    private void computeFileSizesForRollup2x() {
        this.m_oFileSizeRollupTable = this.initFileSizeRollupTable2x();
        int[] aiPlats = OiixVectorOps.vect2IntArr(this.m_plats);
        if (this.m_lSizes.length > 0) {
            for (int k = 0; k < this.m_lSizes[0].length; ++k) {
                int[] aiPlatsList = this.getPlatformsForPlatSet(k);
                for (int l = 0; l < aiPlatsList.length; ++l) {
                    Integer iPlatform = new Integer(aiPlatsList[l]);
                    long[] alSizes = (long[])this.m_oFileSizeRollupTable.get(iPlatform);
                    if (alSizes == null) continue;
                    for (int j = 0; j < this.m_lSizes.length; ++j) {
                        int n = j;
                        alSizes[n] = alSizes[n] + this.m_lSizes[j][k];
                    }
                    int iIndexForAllLangs = this.indexOfLangBitSet(null);
                    if (iIndexForAllLangs == -1) continue;
                    int n = iIndexForAllLangs;
                    alSizes[n] = alSizes[n] + this.getInvSizesAggregate();
                    int n2 = iIndexForAllLangs;
                    alSizes[n2] = alSizes[n2] + this.getSizeOfBinaryInv();
                }
            }
        }
    }

    private Hashtable initFileSizeRollupTable() {
        int[] aiPlats = this.m_platIndMap.getPlats();
        int nLangSets = this.m_langIndMap.getLangSets().size();
        Hashtable<Integer, long[]> oTable = new Hashtable<Integer, long[]>(aiPlats.length);
        for (int i = 0; i < aiPlats.length; ++i) {
            long[] alSizes = new long[nLangSets + 1];
            for (int j = 0; j < nLangSets + 1; ++j) {
                alSizes[j] = 0L;
            }
            oTable.put(new Integer(aiPlats[i]), alSizes);
        }
        return oTable;
    }

    private Hashtable initFileSizeRollupTable2x() {
        int[] aiPlats = OiixVectorOps.vect2IntArr(this.m_plats);
        Hashtable<Integer, long[]> oTable = new Hashtable<Integer, long[]>(aiPlats.length);
        int nLangSets = 0;
        nLangSets = this.m_langSets == null ? 1 : this.m_langSets.size();
        for (int i = 0; i < aiPlats.length; ++i) {
            long[] alSizes = new long[nLangSets];
            for (int j = 0; j < alSizes.length; ++j) {
                alSizes[j] = 0L;
            }
            oTable.put(new Integer(aiPlats[i]), alSizes);
        }
        return oTable;
    }

    public long[] getSizesForRollup(Integer iPlat) {
        if (this.m_oFileSizeRollupTable == null) {
            return null;
        }
        return (long[])this.m_oFileSizeRollupTable.get(iPlat);
    }

    public int getOffsetType(String dest) throws OiisInvalidValueException {
        int idx = this.m_destIndMap.getDestinationIndex(dest);
        return this.getOffsetType(idx);
    }

    public int getOffsetType(int idx) throws OiisInvalidValueException {
        if (idx == -1) {
            throw new OiisInvalidValueException(OiixResourceBundle.getString("S_INVALID_DESTINATION"));
        }
        return this.m_aiOffsetType[idx];
    }

    public Object getOffset(String dest) throws OiisInvalidValueException {
        int idx = this.m_destIndMap.getDestinationIndex(dest);
        return this.getOffset(idx);
    }

    public Object getOffset(int idx) throws OiisInvalidValueException {
        return this.getOffset(idx, 1);
    }

    public Object getOffset(int idx, int typeofOffset) throws OiisInvalidValueException {
        if (idx == -1) {
            throw new OiisInvalidValueException(OiixResourceBundle.getString("S_INVALID_DESTINATION"));
        }
        if (typeofOffset == 1) {
            return this.m_aoOffsets[idx];
        }
        if (typeofOffset == 2) {
            if (this.m_aoTempOffsets != null) {
                return this.m_aoTempOffsets[idx];
            }
        } else if (typeofOffset == 4 && this.m_aoNonInstallOffsets != null) {
            return this.m_aoNonInstallOffsets[idx];
        }
        return new Integer(0);
    }

    public void setOffset(String dest, int typeOfOffset, String identifier, int type) throws OiisInvalidValueException {
        int idx = this.m_destIndMap.getDestinationIndex(dest);
        if (idx == -1) {
            throw new OiisInvalidValueException(OiixResourceBundle.getString("S_INVALID_DESTINATION"));
        }
        if (type != 2 && type != 6) {
            throw new OiisInvalidValueException(OiixResourceBundle.getString("S_INVALID_OFFSET_TYPE"));
        }
        if (typeOfOffset == 1) {
            this.m_aoOffsets[idx] = identifier;
            this.m_aiOffsetType[idx] = type;
        } else if (typeOfOffset == 2) {
            this.m_aoTempOffsets[idx] = identifier;
            this.m_aiTempOffsetType[idx] = type;
        } else if (typeOfOffset == 4) {
            this.m_aoNonInstallOffsets[idx] = identifier;
            this.m_aiNonInstallOffsetType[idx] = type;
        }
    }

    public void setOffset(String dest, int typeOfOffset, int offset) throws OiisInvalidValueException {
        int idx = this.m_destIndMap.getDestinationIndex(dest);
        if (idx == -1) {
            throw new OiisInvalidValueException(OiixResourceBundle.getString("S_INVALID_DESTINATION"));
        }
        if (typeOfOffset == 1) {
            this.m_aoOffsets[idx] = new Integer(offset);
            this.m_aiOffsetType[idx] = 1;
        } else if (typeOfOffset == 2) {
            this.m_aoTempOffsets[idx] = new Integer(offset);
            this.m_aiTempOffsetType[idx] = 1;
        } else if (typeOfOffset == 4) {
            this.m_aoNonInstallOffsets[idx] = new Integer(offset);
            this.m_aiNonInstallOffsetType[idx] = 1;
        }
    }

    public void addFileGroupSizeInfo(OiisFileGroup fGroup) {
        this.addFileGroupSizeInfo(fGroup, null);
    }

    public void updateSize(int exlPos, int expPos, String dest, long size) {
        int exdPos = this.m_destIndMap.getDestinationIndex(dest);
        this.updateSize(exlPos, expPos, exdPos, size);
    }

    public void updateSize(int exlPos, int expPos, int exdPos, long size) {
        if (exdPos >= 0) {
            if (exlPos == -554696704) {
                int numLangSets = this.m_alSizes[0].length - 1;
                long[] lArray = this.m_alSizes[exdPos][numLangSets];
                int n = expPos;
                lArray[n] = lArray[n] + size;
            } else {
                long[] lArray = this.m_alSizes[exdPos][exlPos];
                int n = expPos;
                lArray[n] = lArray[n] + size;
            }
        }
    }

    public void addFileGroupSizeInfo(OiisFileGroup fGroup, Vector plats) {
        if (this.m_iFileSizeInfoType != 1) {
            this.getSizesArrayEx();
            if (this.m_lSizes == null) {
                return;
            }
            Vector gLSets = fGroup.getLangSets();
            int numGLSets = gLSets.size();
            Vector gPSets = fGroup.getPlatSets();
            int numGPSets = gPSets.size();
            Vector gsPSets = null;
            if (plats != null) {
                gsPSets = fGroup.getRelevantPlatSetList(plats);
                numGPSets = gsPSets.size();
            }
            for (int i = 0; i < numGLSets; ++i) {
                BitSet lbs = (BitSet)gLSets.elementAt(i);
                int lbsInd = this.indexOfLangBitSet(lbs);
                for (int j = 0; j < numGPSets; ++j) {
                    int k = j;
                    if (plats != null) {
                        k = (Integer)gsPSets.elementAt(j);
                    }
                    BitSet pbs = (BitSet)gPSets.elementAt(k);
                    int pbsInd = this.indexOfPlatBitSet(pbs);
                    long size = fGroup.getSizeForLPSetVals(i, k);
                    long[] lArray = this.m_lSizes[lbsInd];
                    int n = pbsInd;
                    lArray[n] = lArray[n] + size;
                    int[] nArray = this.m_sizes[lbsInd];
                    int n2 = pbsInd;
                    nArray[n2] = nArray[n2] + (int)size;
                }
            }
        }
    }

    public void initMappings() {
        if (this.m_iFileSizeInfoType != 1) {
            this.computePlatToSetsMapping();
            this.computeLangToSetsMapping();
        }
    }

    public int[] getPlatformsForPlatSet(int bspPos) {
        if (this.m_iFileSizeInfoType == 1) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            return pim.getPlatsForPlatSetIndex(bspPos);
        }
        return this.getPlatformsForPlatSet2x(bspPos);
    }

    private int[] getPlatformsForPlatSet2x(int bspPos) {
        int[] retPlatArr = null;
        OiisPlatIndexMapping pim = this.getPlatIndexMapping();
        if (pim != null && bspPos < this.m_platSets.size()) {
            BitSet psbsp = (BitSet)this.m_platSets.elementAt(bspPos);
            int[] knownPlats = pim.getPlats();
            if (OiisPlatIndexMapping.isPlatAllBitSet(psbsp)) {
                retPlatArr = knownPlats;
            } else {
                int i;
                int numSetPlats = 0;
                int psCntr = 0;
                int bsSize = psbsp.size();
                for (i = 0; i < bsSize; ++i) {
                    if (!psbsp.get(i)) continue;
                    ++numSetPlats;
                }
                retPlatArr = new int[numSetPlats];
                for (i = 0; i < bsSize; ++i) {
                    if (!psbsp.get(i)) continue;
                    retPlatArr[psCntr++] = knownPlats[i];
                }
            }
        }
        return retPlatArr;
    }

    public Locale[] getLanguagesForLangSet(int bslPos) {
        if (this.m_iFileSizeInfoType == 1) {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            Vector langs = lim.getLangsForLangSetIndex(bslPos);
            int sz = langs.size();
            Locale[] x = new Locale[sz];
            for (int i = 0; i < sz; ++i) {
                x[i] = (Locale)langs.elementAt(i);
            }
            return x;
        }
        return this.getLanguagesForLangSet2x(bslPos);
    }

    private Locale[] getLanguagesForLangSet2x(int bslPos) {
        Locale[] retLangArr = null;
        OiisLangIndexMapping lim = this.getLangIndexMapping();
        if (lim != null && bslPos < this.m_langSets.size()) {
            BitSet psbsl = (BitSet)this.m_langSets.elementAt(bslPos);
            Locale[] knownLangs = lim.getLangs();
            if (OiisLangIndexMapping.isLangAllBitSet(psbsl)) {
                retLangArr = knownLangs;
            } else {
                int i;
                int numSetLangs = 0;
                int psCntr = 0;
                int bsSize = psbsl.size();
                for (i = 0; i < bsSize; ++i) {
                    if (!psbsl.get(i)) continue;
                    ++numSetLangs;
                }
                retLangArr = new Locale[numSetLangs];
                for (i = 0; i < bsSize; ++i) {
                    if (!psbsl.get(i)) continue;
                    retLangArr[psCntr++] = knownLangs[i];
                }
            }
        }
        return retLangArr;
    }

    public Vector getRelevantPlatSetList() {
        return this.getRelevantPlatSetList(OiixPlatform.getCurrentPlatform());
    }

    public Vector getRelevantPlatSetList(Vector plats) {
        if (this.m_iFileSizeInfoType == 1) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            return OiixVectorOps.intArr2Vect(pim.getRelevantPlatSetList(plats));
        }
        return this.getRelevantPlatSetList2x(plats);
    }

    private Vector getRelevantPlatSetList2x(Vector plats) {
        int i;
        Vector platSets = new Vector();
        if (plats == null) {
            int[] allPlats = OiixPlatform.getPlatforms();
            plats = new Vector<Integer>();
            for (i = 0; i < allPlats.length; ++i) {
                plats.addElement(new Integer(allPlats[i]));
            }
        }
        int numPlats = plats.size();
        for (i = 0; i < numPlats; ++i) {
            int plat = (Integer)plats.elementAt(i);
            platSets = OiixVectorOps.union(platSets, this.getRelevantPlatSetList(plat));
        }
        return platSets;
    }

    public Vector getRelevantPlatSetList(int platform) {
        if (this.m_iFileSizeInfoType == 1) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            return OiixVectorOps.intArr2Vect(pim.getRelevantPlatSetList(platform));
        }
        return this.getRelevantPlatSetList2x(platform);
    }

    private Vector getRelevantPlatSetList2x(int platform) {
        int curPlatInd;
        Vector platSets = new Vector();
        OiisPlatIndexMapping pim = this.getPlatIndexMapping();
        if (pim != null && (curPlatInd = pim.indexOfPlat(platform)) != -1) {
            platSets = (Vector)this.m_platToSetsMapping.elementAt(curPlatInd);
        }
        return platSets;
    }

    public Vector getRelevantLangSetList(Vector locales) {
        if (this.m_iFileSizeInfoType == 1) {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            return OiixVectorOps.intArr2Vect(lim.getRelevantLangSetList(locales, false));
        }
        return this.getRelevantLangSetList2x(locales);
    }

    private Vector getRelevantLangSetList2x(Vector locales) {
        int i;
        Vector langSets = new Vector();
        if (locales == null) {
            Locale[] allLangs = OiixLanguage.getLanguages();
            locales = new Vector<Locale>();
            for (i = 0; i < allLangs.length; ++i) {
                locales.addElement(allLangs[i]);
            }
        }
        int numLocs = locales.size();
        for (i = 0; i < numLocs; ++i) {
            Locale loc = (Locale)locales.elementAt(i);
            langSets = OiixVectorOps.union(langSets, this.getRelevantLangSetList(loc));
        }
        return langSets;
    }

    public Vector getRelevantLangSetList(Locale locale) {
        if (this.m_iFileSizeInfoType == 1) {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            return OiixVectorOps.intArr2Vect(lim.getRelevantLangSetList(locale));
        }
        return this.getRelevantLangSetList2x(locale);
    }

    private Vector getRelevantLangSetList2x(Locale locale) {
        int curLangInd;
        Vector langSets = new Vector();
        OiisLangIndexMapping lim = this.getLangIndexMapping();
        if (lim != null && (curLangInd = lim.indexOfLang(locale)) != -1) {
            langSets = (Vector)this.m_langToSetsMapping.elementAt(curLangInd);
        }
        return langSets;
    }

    private void computePlatToSetsMapping() {
        if (this.m_iFileSizeInfoType != 1) {
            this.m_platToSetsMapping = new Vector();
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            if (pim != null) {
                int[] pimPlats = pim.getPlats();
                for (int platInd = 0; platInd < pimPlats.length; ++platInd) {
                    Vector<Integer> indVect = new Vector<Integer>();
                    int numSets = this.m_platSets.size();
                    for (int i = 0; i < numSets; ++i) {
                        Integer addInd;
                        BitSet pebs = (BitSet)this.m_platSets.elementAt(i);
                        if (!OiisPlatIndexMapping.isPlatAllBitSet(pebs) && !pebs.get(platInd) || indVect.contains(addInd = new Integer(i))) continue;
                        indVect.addElement(addInd);
                    }
                    this.m_platToSetsMapping.addElement(indVect);
                }
            }
        }
    }

    private void computeLangToSetsMapping() {
        if (this.m_iFileSizeInfoType != 1) {
            this.m_langToSetsMapping = new Vector();
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            if (lim != null) {
                Locale[] limLangs = lim.getLangs();
                for (int langInd = 0; langInd < limLangs.length; ++langInd) {
                    Vector<Integer> indVect = new Vector<Integer>();
                    int numSets = this.m_langSets.size();
                    for (int i = 0; i < numSets; ++i) {
                        Integer addInd;
                        BitSet pebs = (BitSet)this.m_langSets.elementAt(i);
                        if (!OiisLangIndexMapping.isLangAllBitSet(pebs) && !pebs.get(langInd) || indVect.contains(addInd = new Integer(i))) continue;
                        indVect.addElement(addInd);
                    }
                    this.m_langToSetsMapping.addElement(indVect);
                }
            }
        }
    }

    public OiisDestinationIndexMapping getDestIndexMapping() {
        return this.m_destIndMap;
    }

    public OiisPlatIndexMapping getPlatIndexMapping() {
        return this.m_platIndMap;
    }

    public OiisLangIndexMapping getLangIndexMapping() {
        return this.m_langIndMap;
    }

    public void setDestIndexMapping(OiisDestinationIndexMapping destIndMap) {
        this.m_destIndMap = destIndMap;
    }

    public void setPlatIndexMapping(OiisPlatIndexMapping platIndMap) {
        this.m_platIndMap = platIndMap;
    }

    public void setLangIndexMapping(OiisLangIndexMapping langIndMap) {
        this.m_langIndMap = langIndMap;
    }

    private int indexOfPlatBitSet(BitSet bs) {
        int exPos = -1;
        if (OiisPlatIndexMapping.isPlatAllBitSet(bs)) {
            int numPS = this.m_platSets.size();
            for (int i = 0; i < numPS; ++i) {
                BitSet exBS = (BitSet)this.m_platSets.elementAt(i);
                if (!OiisPlatIndexMapping.isPlatAllBitSet(exBS)) continue;
                exPos = i;
                break;
            }
        } else {
            exPos = this.m_platSets.indexOf(bs);
        }
        return exPos;
    }

    private int indexOfLangBitSet(BitSet bs) {
        int exPos = -1;
        if (OiisLangIndexMapping.isLangAllBitSet(bs)) {
            int numPS = this.m_langSets.size();
            for (int i = 0; i < numPS; ++i) {
                BitSet exBS = (BitSet)this.m_langSets.elementAt(i);
                if (!OiisLangIndexMapping.isLangAllBitSet(exBS)) continue;
                exPos = i;
                break;
            }
        } else {
            exPos = this.m_langSets.indexOf(bs);
        }
        return exPos;
    }

    public long[][] getSizesArrayEx() {
        if (this.m_lSizes == null && this.m_sizes != null) {
            int numLangs = this.m_langSets.size();
            int numPlats = this.m_platSets.size();
            this.m_lSizes = new long[numLangs][numPlats];
            for (int i = 0; i < numLangs; ++i) {
                for (int j = 0; j < numPlats; ++j) {
                    this.m_lSizes[i][j] = this.m_sizes[i][j];
                }
            }
        }
        return this.m_lSizes;
    }

    public int getSize() {
        return this.getSize(null);
    }

    public int getSize(Vector langs) {
        return this.getSize(langs, null);
    }

    public int getSize(Vector langs, Vector plats) {
        return (int)this.getSizeEx(langs, plats);
    }

    public long getSizeEx() {
        return this.getSizeEx(null);
    }

    public long getSizeEx(Vector langs) {
        return this.getSizeEx(langs, null);
    }

    public long getSizeEx(Vector langs, Vector plats, String sDest) {
        return this.getSizeEx(langs, null, plats, sDest);
    }

    public long getSizeEx(Vector langs, Vector uLangs, Vector plats, String sDest) {
        long size = 0L;
        if (this.m_iFileSizeInfoType == 1) {
            int dind = this.m_destIndMap.getDestinationIndex(sDest);
            return this.getSizeEx(langs, uLangs, plats, dind);
        }
        if (sDest.equalsIgnoreCase("%ORACLE_HOME%")) {
            return this.getSizeEx2x(langs, plats);
        }
        return 0L;
    }

    public long getSizeEx(Vector langs, Vector plats, int dind) {
        return this.getSizeEx(langs, null, plats, dind, 1);
    }

    public long getSizeEx(Vector langs, Vector uLangs, Vector plats, int dind) {
        return this.getSizeEx(langs, uLangs, plats, dind, 1);
    }

    public long getSizeEx(Vector langs, Vector plats, int dind, int offType) {
        return this.getSizeEx(langs, null, plats, dind, offType);
    }

    public long getSizeEx(Vector langs, Vector uLangs, Vector plats, int dind, int offType) {
        long size = 0L;
        if (this.m_iFileSizeInfoType == 1) {
            if ((offType & 1) == 1) {
                Vector langSets = null;
                if (uLangs == null) {
                    langSets = this.getRelevantLangSetList(langs);
                } else {
                    Vector vInstalledLangSet = this.getRelevantLangSetList(langs);
                    Vector vUpgradedLangSet = this.getRelevantLangSetList(uLangs);
                    langSets = (Vector)vUpgradedLangSet.clone();
                    langSets.removeAll(vInstalledLangSet);
                }
                Vector platSets = this.getRelevantPlatSetList(plats);
                int numLSets = langSets.size();
                int numPSets = platSets.size();
                for (int lind = 0; lind < numLSets; ++lind) {
                    int langSetInd = (Integer)langSets.elementAt(lind);
                    if (langSetInd >= this.m_alSizes[0].length - 1) continue;
                    for (int pind = 0; pind < numPSets; ++pind) {
                        int platSetInd = (Integer)platSets.elementAt(pind);
                        if (platSetInd >= this.m_alSizes[0][0].length) continue;
                        size += this.m_alSizes[dind][langSetInd][platSetInd];
                    }
                }
                for (int pind = 0; pind < numPSets; ++pind) {
                    int platSetInd = (Integer)platSets.elementAt(pind);
                    if (platSetInd >= this.m_alSizes[0][0].length || uLangs != null) continue;
                    size += this.m_alSizes[dind][this.m_alSizes[0].length - 1][platSetInd];
                }
            }
            return size += this.getOffsetSize(dind, offType);
        }
        if (this.m_destIndMap.getDestinationIndex("%ORACLE_HOME%") == dind) {
            return this.getSizeEx2x(langs, plats);
        }
        return 0L;
    }

    private long getOffsetSize(int dind, int offType) {
        long size = 0L;
        if ((offType & 1) == 1 && this.m_aoOffsets != null) {
            size += this.getOffsetSize(dind, this.m_aoOffsets, this.m_aiOffsetType);
        }
        if ((offType & 4) == 4 && this.m_aoNonInstallOffsets != null) {
            size += this.getOffsetSize(dind, this.m_aoNonInstallOffsets, this.m_aiNonInstallOffsetType);
        }
        if ((offType & 2) == 2 && this.m_aoTempOffsets != null) {
            size += this.getOffsetSize(dind, this.m_aoTempOffsets, this.m_aiTempOffsetType);
        }
        return size;
    }

    private long getOffsetSize(int dind, Object[] aiOffsets, int[] aiOffsetsType) {
        OiisVariable oVar;
        Object val;
        long size = 0L;
        if (aiOffsetsType[dind] == 1) {
            size += (long)((Integer)aiOffsets[dind]).intValue();
        } else if (aiOffsetsType[dind] == 2) {
            if (this.m_oCompContext != null) {
                OiisCompConstants oCompConsts = this.m_oCompContext.getCompConstants();
                OiisGenericConstant oConst = oCompConsts.getConstant((String)aiOffsets[dind]);
                size += (long)((Integer)oConst.getValue()).intValue();
            }
        } else if (aiOffsetsType[dind] == 6 && this.m_oCompContext != null && (val = (oVar = this.m_oCompContext.getVariable((String)aiOffsets[dind])).getValue()) != null) {
            size += (long)((Integer)val).intValue();
        }
        return size;
    }

    public long getSizeEx(Vector langs, Vector plats) {
        return this.getSizeEx(langs, null, plats);
    }

    public long getSizeEx(Vector langs, Vector uLangs, Vector plats) {
        long size = 0L;
        if (this.m_iFileSizeInfoType == 1) {
            int dind;
            Vector langSets = null;
            if (uLangs == null) {
                langSets = this.getRelevantLangSetList(langs);
            } else {
                Vector vInstalledLangSet = this.getRelevantLangSetList(langs);
                Vector vUpgradedLangSet = this.getRelevantLangSetList(uLangs);
                langSets = (Vector)vUpgradedLangSet.clone();
                langSets.removeAll(vInstalledLangSet);
            }
            Vector platSets = this.getRelevantPlatSetList(plats);
            int numLSets = langSets.size();
            int numPSets = platSets.size();
            for (dind = 0; dind < this.m_alSizes.length; ++dind) {
                for (int lind = 0; lind < numLSets; ++lind) {
                    int langSetInd = (Integer)langSets.elementAt(lind);
                    if (langSetInd >= this.m_alSizes[0].length - 1) continue;
                    for (int pind = 0; pind < numPSets; ++pind) {
                        int platSetInd = (Integer)platSets.elementAt(pind);
                        if (platSetInd >= this.m_alSizes[0][0].length) continue;
                        size += this.m_alSizes[dind][langSetInd][platSetInd];
                    }
                }
                size += this.getOffsetSize(dind, 1);
            }
            for (dind = 0; dind < this.m_alSizes.length; ++dind) {
                for (int pind = 0; pind < numPSets; ++pind) {
                    int platSetInd = (Integer)platSets.elementAt(pind);
                    if (platSetInd >= this.m_alSizes[0][0].length || uLangs != null) continue;
                    size += this.m_alSizes[dind][this.m_alSizes[0].length - 1][platSetInd];
                }
            }
            size += this.getInvSizesAggregate();
            return size += this.getSizeOfBinaryInv();
        }
        return this.getSizeEx2x(langs, plats);
    }

    private long getSizeEx2x(Vector langs, Vector plats) {
        return this.getSizeEx2x(langs, null, plats);
    }

    private long getSizeEx2x(Vector langs, Vector uLangs, Vector plats) {
        long size = 0L;
        this.getSizesArrayEx();
        Vector langSets = null;
        if (uLangs == null) {
            langSets = this.getRelevantLangSetList(langs);
        } else {
            Vector vInstalledLangSet = this.getRelevantLangSetList(langs);
            Vector vUpgradedLangSet = this.getRelevantLangSetList(uLangs);
            langSets = (Vector)vUpgradedLangSet.clone();
            langSets.removeAll(vInstalledLangSet);
        }
        Vector platSets = this.getRelevantPlatSetList(plats);
        int numLSets = langSets.size();
        int numPSets = platSets.size();
        for (int lind = 0; lind < numLSets; ++lind) {
            int langSetInd = (Integer)langSets.elementAt(lind);
            for (int pind = 0; pind < numPSets; ++pind) {
                int platSetInd = (Integer)platSets.elementAt(pind);
                size += this.m_lSizes[langSetInd][platSetInd];
            }
        }
        size += this.getInvSizesAggregate();
        return size += this.getSizeOfBinaryInv();
    }

    public Hashtable getDestinationSizesTable(Vector vLangs, Vector vPlats) {
        return this.getDestinationSizesTable(vLangs, vPlats, 1);
    }

    public Hashtable getDestinationSizesTable(Vector vLangs, Vector uLangs, Vector vPlats) {
        return this.getDestinationSizesTable(vLangs, uLangs, vPlats, 1);
    }

    public Hashtable getDestinationSizesTable(Vector vLangs, Vector vPlats, int offType) {
        return this.getDestinationSizesTable(vLangs, null, vPlats, offType);
    }

    public Hashtable getDestinationSizesTable(Vector vLangs, Vector uLangs, Vector vPlats, int offType) {
        Hashtable htDestinationSizes = new Hashtable();
        long lSize = 0L;
        String sVolume = null;
        if (this.m_iFileSizeInfoType == 1) {
            int iSize = this.m_destIndMap.size();
            for (int i = 0; i < iSize; ++i) {
                String sDest = this.m_destIndMap.getDestination(i);
                lSize = this.getSizeEx(vLangs, uLangs, vPlats, i, offType);
                try {
                    sVolume = OiisIdentifierOps.instantiateString(sDest, this.m_oCompContext);
                    OiisFileSizeInfo.updateSizesTable(sVolume, lSize, htDestinationSizes);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        } else {
            if ((offType & 1) == 1) {
                lSize = this.getSizeEx(vLangs, uLangs, vPlats, "%ORACLE_HOME%");
            }
            try {
                sVolume = OiisIdentifierOps.instantiateString("%ORACLE_HOME%", this.m_oCompContext);
                OiisFileSizeInfo.updateSizesTable(sVolume, lSize, htDestinationSizes);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return htDestinationSizes;
    }

    public Hashtable getSizesTable(Vector vLangs, Vector vPlats, OiicSessionContext oSessContext) {
        return this.getSizesTable(vLangs, vPlats, oSessContext, 1);
    }

    public Hashtable getSizesTable(Vector vLangs, Vector uLangs, Vector vPlats, OiicSessionContext oSessContext) {
        return this.getSizesTable(vLangs, uLangs, vPlats, oSessContext, 1);
    }

    public Hashtable getSizesTable(Vector vLangs, Vector vPlats, OiicSessionContext oSessContext, int offType) {
        return this.getSizesTable(vLangs, null, vPlats, oSessContext, offType);
    }

    public Hashtable getSizesTable(Vector vLangs, Vector uLangs, Vector vPlats, OiicSessionContext oSessContext, int offType) {
        Hashtable htVolumesSizes = this.getDestinationSizesTable(vLangs, uLangs, vPlats, offType);
        long lInvTotal = 0L;
        long lBinInv = 0L;
        if ((offType & 1) == 1) {
            lInvTotal = this.getInvSizesAggregate();
            lBinInv = this.getSizeOfBinaryInv();
        }
        String sLocInv = this.getInvToUpdate(oSessContext);
        String sInvVol = OiisIdentifierOps.instantiateString(sLocInv, this.m_oCompContext);
        OiisFileSizeInfo.updateSizesTable(sInvVol, lInvTotal, htVolumesSizes);
        OiisVariable sInvLoc = oSessContext.getVariable("INVENTORY_LOCATION");
        sInvVol = (String)sInvLoc.getValue();
        OiisFileSizeInfo.updateSizesTable(sInvVol, lBinInv, htVolumesSizes);
        return htVolumesSizes;
    }

    public static void updateSizesTable(String sDest, long lSize, Hashtable htVolumesSizes) {
        if (htVolumesSizes.containsKey(sDest)) {
            Long lSizeCurr = (Long)htVolumesSizes.get(sDest);
            long lSizeTemp = lSizeCurr;
            lSize += lSizeTemp;
        }
        htVolumesSizes.put(sDest, new Long(lSize));
    }

    private long getSizeOfConstants() {
        int iConsts = this.m_oCompContext != null ? this.m_oCompContext.getConstantsCount() : 0;
        long lConstantsTotalSize = iConsts * 122;
        return lConstantsTotalSize;
    }

    private long getSizeofVariables() {
        int iVars = this.m_oCompContext != null ? this.m_oCompContext.getVariablesCount() : 0;
        long lVarsTotalSize = iVars * 122;
        return lVarsTotalSize;
    }

    private long getSizeOfTextInv() {
        return 1500L;
    }

    private long getSizeOfBinaryInv() {
        return 2000L;
    }

    private String getInvToUpdate(OiicSessionContext oSessContext) {
        OiiiCompInstallID oCompID = this.m_oCompContext.getCompInstallID();
        String sLocForInv = "";
        if (oCompID.isOracleHomeComp()) {
            sLocForInv = (String)oSessContext.getVariable("ORACLE_HOME").getValue();
        } else if (oCompID.isNOHComp()) {
            sLocForInv = (String)oSessContext.getVariable("INVENTORY_LOCATION").getValue();
        } else if (oCompID.isAppltopComponent()) {
            sLocForInv = (String)oSessContext.getVariable("APPLTOP").getValue();
        }
        return sLocForInv;
    }

    private String getXMLInvVariable() {
        OiiiCompInstallID oCompID = this.m_oCompContext.getCompInstallID();
        return OiisFileSizeInfo.getXMLInvVariable(oCompID);
    }

    public static String getXMLInvVariable(OiiiCompInstallID oCompID) {
        String sLocForInv = "";
        if (oCompID.isOracleHomeComp()) {
            return "%ORACLE_HOME%";
        }
        if (oCompID.isNOHComp()) {
            return S_CENTRAL_INVENTORY;
        }
        if (oCompID.isAppltopComponent()) {
            return S_APPLTOP_INVENTORY;
        }
        return null;
    }

    private long getInvSizesAggregate() {
        long lSizeOfActions = this.getInstallActionsSize();
        long lSizeOfVars = this.getSizeofVariables();
        long lSizeOfConstants = this.getSizeOfConstants();
        long lSizeOfTextInv = this.getSizeOfTextInv();
        long lInvTotal = lSizeOfActions + lSizeOfVars + lSizeOfConstants + lSizeOfTextInv;
        return lInvTotal;
    }

    public void optimizePlatList() {
        OiisPlatIndexMapping pim;
        if (this.m_iFileSizeInfoType != 1 && this.m_platToSetsMapping != null && (pim = this.getPlatIndexMapping()) != null) {
            int curPlatInd = pim.indexOfPlat(OiixPlatform.getCurrentPlatform());
            int nSize = this.m_platToSetsMapping.size();
            for (int i = 0; i < nSize; ++i) {
                Vector v = (Vector)this.m_platToSetsMapping.elementAt(i);
                if (i == curPlatInd && curPlatInd != -1) continue;
                this.m_platToSetsMapping.setElementAt(null, i);
            }
        }
    }

    public void optimizeLangList() {
        if (this.m_iFileSizeInfoType != 1) {
            if (this.m_langToSetsMapping != null) {
                int nSize = this.m_langToSetsMapping.size();
                for (int j = 0; j < nSize; ++j) {
                    Vector elem = (Vector)this.m_langToSetsMapping.elementAt(j);
                    if (elem == null || elem.size() != 0) continue;
                    this.m_langToSetsMapping.setElementAt(null, j);
                }
            }
            if (this.m_langIndMap != null) {
                this.m_langIndMap.optimizeLangList();
            }
        }
    }

    public String toString() {
        if (this.m_iFileSizeInfoType == 1) {
            int j;
            int i;
            StringBuffer sbuf = new StringBuffer();
            int numLangs = this.m_langIndMap.getLangSets().size();
            int numPlats = this.m_platIndMap.getPlatSets().size();
            int numDest = this.m_destIndMap.size();
            sbuf.append("Sizes on a per dest, per lang set, per plat set basis:\n");
            for (i = 0; i < numDest; ++i) {
                for (j = 0; j < numLangs; ++j) {
                    for (int k = 0; k < numPlats; ++k) {
                        sbuf.append("[" + i + "," + j + "," + k + "]=" + this.m_alSizes[i][j][k]);
                    }
                }
            }
            sbuf.append("Sizes for \"default\" files on a per dest, per plat set basis:\n");
            for (i = 0; i < numDest; ++i) {
                for (j = 0; j < numPlats; ++j) {
                    sbuf.append("[" + i + "," + j + "]=" + this.m_alSizes[i][numLangs][j]);
                }
            }
            sbuf.append("\n");
            sbuf.append("Offsets on a per dest basis:\n");
            block10: for (i = 0; i < numDest; ++i) {
                switch (this.m_aiOffsetType[i]) {
                    case 1: {
                        sbuf.append("[NUMBER:" + i + "]=" + this.m_aoOffsets[i]);
                        continue block10;
                    }
                    case 2: {
                        sbuf.append("[CONSTANT:" + i + "]=" + this.m_aoOffsets[i]);
                        continue block10;
                    }
                    case 6: {
                        sbuf.append("[VARIABLE:" + i + "]=" + this.m_aoOffsets[i]);
                    }
                }
            }
            return sbuf.toString();
        }
        return this.toString2x();
    }

    private String toString2x() {
        StringBuffer sbuf = new StringBuffer();
        this.getSizesArrayEx();
        int numLangSets = this.m_langSets.size();
        int numPlatSets = this.m_platSets.size();
        for (int i = 0; i < numLangSets; ++i) {
            for (int j = 0; j < numPlatSets; ++j) {
                sbuf.append("[" + i + "," + j + "]=" + this.m_lSizes[i][j]);
            }
        }
        return sbuf.toString() + "\n" + OiixResourceBundle.getString("S_LOG_PLATSETS") + OiixVectorOps.objToString(this.m_platSets) + "\n" + OiixResourceBundle.getString("S_LOG_LANGSETS") + OiixVectorOps.objToString(this.m_langSets) + "]";
    }

    public Object clone() {
        OiisFileSizeInfo oClone = null;
        try {
            oClone = (OiisFileSizeInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return oClone;
    }

    public OiisFileSizeInfo getFileSizeInfoForInstall(Vector vLangs, Vector vPlats) {
        OiisFileSizeInfo fsi = null;
        OiisDestinationIndexMapping destIndMap = null;
        if (this.m_iFileSizeInfoType == 1) {
            destIndMap = this.m_destIndMap;
            fsi = new OiisFileSizeInfo(new OiisPlatIndexMapping(), new OiisLangIndexMapping(), this.m_destIndMap);
            int nCnt = this.m_destIndMap.size();
            for (int i = 0; i < nCnt; ++i) {
                long lSize = this.getSizeEx(vLangs, vPlats, i);
                fsi.updateSize(0, 0, i, lSize);
            }
        } else {
            destIndMap = new OiisDestinationIndexMapping();
            destIndMap.addDestination("%ORACLE_HOME%");
            destIndMap.addDestination(S_CENTRAL_INVENTORY);
            destIndMap.addDestination(this.getXMLInvVariable());
            fsi = new OiisFileSizeInfo(new OiisPlatIndexMapping(), new OiisLangIndexMapping(), destIndMap);
            long lSize = this.getSizeEx2x(vLangs, vPlats);
            fsi.updateSize(0, 0, "%ORACLE_HOME%", lSize);
        }
        fsi.updateSize(0, 0, S_CENTRAL_INVENTORY, this.getSizeOfBinaryInv());
        fsi.updateSize(0, 0, this.getXMLInvVariable(), this.getInvSizesAggregate());
        return fsi;
    }

    public void dispose() {
        if (this.m_iFileSizeInfoType == 1) {
            this.m_platIndMap = null;
            this.m_langIndMap = null;
        }
        this.m_destIndMap = null;
        this.m_oCompContext = null;
        this.m_oFileSizeRollupTable = null;
    }

    public long[][][] get3DSizesArray() {
        return this.m_alSizes;
    }

    public long[][] get2DSizesArray2x() {
        return this.m_lSizes;
    }

    public Object[] getOffsetArr(int type) {
        if (type == 1) {
            return this.m_aoOffsets;
        }
        if (type == 4) {
            return this.m_aoNonInstallOffsets;
        }
        return this.m_aoTempOffsets;
    }

    public int[] getOffsetTypeArr(int type) {
        if (type == 1) {
            return this.m_aiOffsetType;
        }
        if (type == 4) {
            return this.m_aiNonInstallOffsetType;
        }
        return this.m_aiTempOffsetType;
    }

    public static void main(String[] args) {
        String filemapLoc = null;
        if (args.length != 1 || !new File(filemapLoc = args[0]).exists()) {
            System.out.println("Usage : java oracle.sysman.oii.oiis.OiisFileSizeInfo <filemap.ser location>");
        } else {
            try {
                FileInputStream fis = new FileInputStream(filemapLoc);
                ObjectInputStream ois = new ObjectInputStream(fis);
                OiisFileMap fm = (OiisFileMap)ois.readObject();
                ois.close();
                fis.close();
                System.out.println(fm.toString());
                Vector[] platVects = new Vector[7];
                OiisFileSizeInfo[] fsiArr = new OiisFileSizeInfo[7];
                platVects[0] = new Vector();
                platVects[0].addElement(new Integer(912));
                platVects[1] = new Vector();
                platVects[1].addElement(new Integer(615));
                platVects[2] = new Vector();
                platVects[2].addElement(new Integer(453));
                platVects[3] = new Vector();
                platVects[3].addElement(new Integer(912));
                platVects[3].addElement(new Integer(615));
                platVects[4] = new Vector();
                platVects[4].addElement(new Integer(912));
                platVects[4].addElement(new Integer(453));
                platVects[5] = new Vector();
                platVects[5].addElement(new Integer(615));
                platVects[5].addElement(new Integer(453));
                platVects[6] = new Vector();
                platVects[6].addElement(new Integer(912));
                platVects[6].addElement(new Integer(615));
                platVects[6].addElement(new Integer(453));
                for (int i = 0; i < 7; ++i) {
                    fsiArr[i] = fm.computeFileSizeInfo(platVects[i]);
                    System.out.println("");
                    System.out.println("[" + i + "]For the vector : " + platVects[i]);
                    System.out.println(fsiArr[i].toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

