/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisFileEntry;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiisFileMapXMLWriter {
    private OiisFileMap m_oFileMap;
    private String m_sLocation;
    private Hashtable m_oEntriesTable;

    public OiisFileMapXMLWriter(OiisFileMap filemap, String sLocation) {
        this.m_oFileMap = filemap;
        this.m_sLocation = sLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector writeFileMapXML() throws IOException {
        Enumeration enum_1 = this.m_oFileMap.getFileGroupNames();
        String path = this.m_sLocation + File.separator + "filemap.xml";
        Vector fileNames = new Vector();
        FileWriter fWriter = new FileWriter(path);
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter(bWriter);
        try {
            XMLElement fileMap = new XMLElement("FILEMAP");
            XMLElement fileGroup = new XMLElement("FILEGROUP");
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
            fileMap.setAttribute("TYPE", String.valueOf(this.m_oFileMap.getType()));
            while (enum_1.hasMoreElements()) {
                OiisFileGroup fGroups = this.m_oFileMap.getFileGroup(enum_1.nextElement().toString());
                Vector fNames = this.writeEntriesXML(fGroups);
                int nNames = fNames.size();
                for (int j = 0; j < nNames; ++j) {
                    fileNames.addElement(fNames.elementAt(j));
                }
                fileMap.appendChild((Node)this.getFileMapXMLElement(fGroups));
            }
            fileNames.addElement(path);
            fileMap.print(pWriter);
        }
        finally {
            pWriter.close();
            bWriter.close();
            fWriter.close();
        }
        return fileNames;
    }

    private Vector writeEntriesXML(OiisFileGroup fileGroup) throws IOException {
        this.m_oEntriesTable = fileGroup.getEntriesTable();
        Enumeration enum_1 = this.m_oEntriesTable.keys();
        String m_sEntryFileName = fileGroup.getEntriesFileName();
        Vector<String> vEntryNames = new Vector<String>(this.m_oEntriesTable.size(), 5);
        while (enum_1.hasMoreElements()) {
            Vector vEntries;
            String sKey = (String)enum_1.nextElement();
            Object oEntries = this.m_oEntriesTable.get(sKey);
            if (oEntries != null && !(oEntries instanceof Vector) || (vEntries = (Vector)oEntries) == null || vEntries.size() <= 0) continue;
            if (m_sEntryFileName == null) {
                fileGroup.setEntriesFileName(fileGroup.formDefaultFileName());
            }
            String path = this.m_sLocation + File.separator + fileGroup.getEntriesFileName() + fileGroup.getEntriesFileNameThunk(sKey) + ".xml";
            vEntryNames.addElement(path);
            FileWriter fWriter = new FileWriter(path);
            BufferedWriter bWriter = new BufferedWriter(fWriter);
            PrintWriter pWriter = new PrintWriter(bWriter);
            XMLElement entries = new XMLElement("ENTRIES");
            pWriter.println(OixsXMLOps.createXMLDirective(true));
            pWriter.println(OixsXMLOps.getStandardHeader());
            for (int i = 0; i < vEntries.size(); ++i) {
                entries.appendChild((Node)this.getFileEntryXMLElement((OiisFileEntry)vEntries.elementAt(i)));
            }
            entries.print(pWriter);
            pWriter.close();
            bWriter.close();
            fWriter.close();
        }
        return vEntryNames;
    }

    private XMLElement getFileEntryXMLElement(OiisFileEntry fileEntry) {
        XMLElement xmlEntry = new XMLElement("FILE");
        xmlEntry.setAttribute("SOURCE", fileEntry.getSource());
        xmlEntry.setAttribute("DST", fileEntry.getDestination());
        xmlEntry.setAttribute("TARGET_VOLUME", fileEntry.getTargetVolume());
        xmlEntry.setAttribute("EMPTY_DIR", fileEntry.isDirectoryEntry() ? "T" : "F");
        xmlEntry.setAttribute("SIZE", String.valueOf(fileEntry.getSize()));
        xmlEntry.setAttribute("PLAT_BITSET_POS", String.valueOf(fileEntry.getPlatBitSetRefPos()));
        xmlEntry.setAttribute("LANG_BITSET_POS", String.valueOf(fileEntry.getLangBitSetRefPos()));
        String sPerm = fileEntry.getPermissions();
        if (sPerm != null && !sPerm.equals("")) {
            xmlEntry.setAttribute("PERMISSION", sPerm);
        }
        return xmlEntry;
    }

    private XMLElement getFileMapXMLElement(OiisFileGroup fileGroup) {
        XMLElement xmlFileGroup = new XMLElement("FILEGROUP");
        xmlFileGroup.setAttribute("NAME", fileGroup.getName());
        xmlFileGroup.setAttribute("ARCHIVE", fileGroup.isGroupArchived() ? "T" : "F");
        xmlFileGroup.setAttribute("ENTRY_FILE_NAME", fileGroup.getEntriesFileName());
        xmlFileGroup.setAttribute("TYPE", String.valueOf(5));
        xmlFileGroup.setAttribute("NEW_STYLE_GROUP", fileGroup.isNewStyleGroup() ? "T" : "F");
        xmlFileGroup.setAttribute("LOC", fileGroup.getGroupLocation());
        xmlFileGroup.setAttribute("FILEGROUP_PLATSET", String.valueOf(fileGroup.getPlatSetIndex()));
        xmlFileGroup.setAttribute("FILEGROUP_LANGSET", String.valueOf(fileGroup.getLangSetIndex()));
        return xmlFileGroup;
    }
}

