/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiis.OiisDestinationIndexMapping;
import oracle.sysman.oii.oiis.OiisFileEntry;
import oracle.sysman.oii.oiis.OiisFileMap;
import oracle.sysman.oii.oiis.OiisFileMapXMLReader;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;
import oracle.sysman.oii.oiis.OiisPathEntry;
import oracle.sysman.oii.oiis.OiisPlatIndexMapping;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisFileGroup
implements Serializable {
    public static final String S_DEFAULT_ENTRIES_KEY = "default";
    private transient BitSet m_EngBitSet = null;
    static final long serialVersionUID = -8800567281839697409L;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    private boolean m_bUnarchive = false;
    private String m_sLocation;
    private Vector m_platSets;
    private Vector m_platToSetsMapping;
    private transient OiisPlatIndexMapping m_platIndMap = null;
    private Vector m_langSets;
    private Vector m_langToSetsMapping;
    private transient OiisLangIndexMapping m_langIndMap = null;
    private int m_iFileGroupPlatSetIndex;
    private transient BitSet m_oFileGroupPlatSet;
    private int m_iFileGroupLangSetIndex;
    private transient BitSet m_oFileGroupLangSet;
    private transient OiisDestinationIndexMapping m_destIndMap = null;
    private String m_name;
    private String m_jarName;
    private Vector m_entries;
    private transient Hashtable m_oEntriesTable = null;
    private transient Hashtable m_oRevEntriesTable = null;
    private String[] m_asEntryKeys = null;
    private static final String S_NOT_LOADED = "not loaded";
    public static final String S_ORACLE_HOME_VAR = "%ORACLE_HOME%";
    public static final int FAST_MODE_FILEGROUP = 0;
    public static final int NORMAL_MODE_FILEGROUP = 1;
    private transient OiisFileMap m_fileMapRef;
    private boolean m_bNewStyleGroup;
    private String m_sEntryFileName;
    private static final String s_sExtn = "entries";
    private static final String s_sXMLExtn = "xml";
    static final int SINGLE_FILE_MAP_OBJECT = 1;
    static final int MULTIPLE_FILE_GROUP_OBJECTS = 2;
    static final int MULTIPLE_FILE_ENTRIES_OBJECTS = 3;
    static final int MULTIPLE_FILE_ENTRIES_OBJECTS_OPT_PLATLANG_INFO = 4;
    static final int MULTIPLE_FILE_ENTRIES_OBJECTS_OPT_PLATLANG_XML = 5;
    private int iFileGroupType = 1;
    private boolean m_bShouldDefaultify = false;

    public OiisFileGroup(String name) {
        this(name, true, "");
    }

    public OiisFileGroup(String name, boolean archive, String location) {
        this.m_name = name;
        this.m_fileMapRef = null;
        this.m_oEntriesTable = new Hashtable();
        this.m_oFileGroupPlatSet = new BitSet();
        this.m_oFileGroupLangSet = new BitSet();
        this.m_bNewStyleGroup = true;
        this.m_bUnarchive = !archive;
        this.m_sLocation = location;
        this.m_jarName = null;
        this.iFileGroupType = 5;
    }

    int getType() {
        return this.iFileGroupType;
    }

    void setType(int iType) {
        this.iFileGroupType = iType;
    }

    public Vector getLangSets() {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            return this.m_langIndMap.getLangSets();
        }
        return this.m_langSets;
    }

    public Vector getPlatSets() {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            return this.m_platIndMap.getPlatSets();
        }
        return this.m_platSets;
    }

    public Vector getLanguages() {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            return lim.getLangsForLangSetIndex(this.m_iFileGroupLangSetIndex);
        }
        return this.getLanguages2x();
    }

    private Vector getLanguages2x() {
        Vector<Object> vLangs = new Vector<Object>(5, 5);
        int nLangs = this.m_langSets.size();
        if (nLangs == 0) {
            vLangs.copyInto(OiixLanguage.getLanguages());
        } else {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            if (lim != null) {
                Object[] knownLangs = lim.getLangs();
                for (int i = 0; i < nLangs; ++i) {
                    BitSet psbsl = (BitSet)this.m_langSets.elementAt(i);
                    if (OiisLangIndexMapping.isLangAllBitSet(psbsl)) {
                        vLangs.removeAllElements();
                        vLangs.copyInto(knownLangs);
                        break;
                    }
                    int bsSize = psbsl.size();
                    for (int j = 0; j < bsSize; ++j) {
                        if (!psbsl.get(j) || vLangs.indexOf(knownLangs[j]) != -1) continue;
                        vLangs.addElement(knownLangs[j]);
                    }
                }
            }
        }
        return vLangs;
    }

    public Vector getPlatforms() {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            int[] plats = pim.getPlatsForPlatSetIndex(this.m_iFileGroupPlatSetIndex);
            return OiixVectorOps.intArr2Vect(plats);
        }
        return this.getPlatforms2x();
    }

    private Vector getPlatforms2x() {
        Vector<Integer> vPlatforms;
        block5: {
            int nPlats;
            block6: {
                vPlatforms = new Vector<Integer>(5, 5);
                nPlats = this.m_platSets.size();
                if (nPlats != 0) break block6;
                int[] allPlats = OiixPlatform.getPlatforms();
                for (int i = 0; i < allPlats.length; ++i) {
                    vPlatforms.addElement(new Integer(allPlats[i]));
                }
                break block5;
            }
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            if (pim == null) break block5;
            int[] knownPlats = pim.getPlats();
            for (int i = 0; i < nPlats; ++i) {
                BitSet psbsp = (BitSet)this.m_platSets.elementAt(i);
                if (OiisPlatIndexMapping.isPlatAllBitSet(psbsp)) {
                    vPlatforms.removeAllElements();
                    for (int j = 0; j < knownPlats.length; ++j) {
                        vPlatforms.addElement(new Integer(knownPlats[j]));
                    }
                    break;
                }
                int bsSize = psbsp.size();
                for (int j = 0; j < bsSize; ++j) {
                    Integer oPlat;
                    if (!psbsp.get(j) || vPlatforms.indexOf(oPlat = new Integer(knownPlats[j])) != -1) continue;
                    vPlatforms.addElement(oPlat);
                }
            }
        }
        return vPlatforms;
    }

    public void setEntriesFileName(String name) {
        this.m_sEntryFileName = name;
    }

    String getEntriesFileName() {
        return this.m_sEntryFileName;
    }

    public boolean isNewStyleGroup() {
        return this.m_bNewStyleGroup;
    }

    public void setNewStyleGroup(boolean bNewStyle) {
        this.m_bNewStyleGroup = bNewStyle;
    }

    public void setFileMapRef(OiisFileMap fileMapRef) {
        this.m_fileMapRef = fileMapRef;
    }

    public OiisFileMap getFileMapRef() {
        return this.m_fileMapRef;
    }

    public void addEntry(OiisPathEntry entry) {
        this.addEntry((OiisFileEntry)entry, null, null);
    }

    public void addEntry(OiisFileEntry entry, Vector langs, Vector plats) {
        if (langs != null || plats != null) {
            this.m_bNewStyleGroup = true;
        }
        BitSet genlBs = this.genLangsBitSet(langs);
        BitSet genpBs = this.genPlatsBitSet(plats);
        this.addEntry(entry, genlBs, -1, genpBs, -1);
    }

    public void addEntry(OiisFileEntry entry, BitSet lbs, int exlPos, BitSet pbs, int expPos) {
        this.addEntry(entry, lbs, exlPos, pbs, expPos, -1);
    }

    public void addEntry(OiisFileEntry entry, BitSet lbs, int exlPos, BitSet pbs, int expPos, int iDestIdx) {
        if (entry != null) {
            BitSet tmp;
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            if (expPos < 0) {
                expPos = pim.addPlatSet(pbs);
            }
            if (this.m_oFileGroupPlatSet != null) {
                pbs = pim.getPlatSetForIndex(expPos);
                if (pbs == null) {
                    this.m_oFileGroupPlatSet = null;
                } else {
                    tmp = new BitSet(Math.max(pbs.size(), this.m_oFileGroupPlatSet.size()));
                    tmp.or(pbs);
                    tmp.or(this.m_oFileGroupPlatSet);
                    this.m_oFileGroupPlatSet = tmp;
                }
            }
            entry.setPlatBitSetRefPos(expPos);
            if (exlPos < 0) {
                exlPos = lim.addLangSet(lbs);
            }
            if (this.m_oFileGroupLangSet != null) {
                lbs = lim.getLangSetForIndex(exlPos);
                if (lbs == null) {
                    this.m_oFileGroupLangSet = null;
                } else {
                    tmp = new BitSet(Math.max(lbs.size(), this.m_oFileGroupLangSet.size()));
                    tmp.or(lbs);
                    tmp.or(this.m_oFileGroupLangSet);
                    this.m_oFileGroupLangSet = tmp;
                }
            }
            if (this.m_bShouldDefaultify && this.isDefaultFileEntry(entry, lbs)) {
                exlPos = -554696704;
            }
            entry.setLangBitSetRefPos(exlPos);
            if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
                this.getFileEntries(exlPos, expPos).addElement(entry);
            } else {
                this.getFileEntries().addElement(entry);
            }
            if ((this.iFileGroupType == 4 || this.iFileGroupType == 5) && iDestIdx < 0) {
                OiisDestinationIndexMapping dim = this.getDestIndexMapping();
                String sVolume = entry.getTargetVolume();
                if (sVolume != null && sVolume.trim().length() != 0) {
                    dim.addDestination(sVolume);
                }
            }
            entry.setGroupRef(this);
        }
    }

    private String getKey(int exlPos, int expPos) {
        if (exlPos == -554696704) {
            return S_DEFAULT_ENTRIES_KEY;
        }
        return "" + exlPos + "." + expPos;
    }

    public Vector getDefaultEntries() {
        return this.getEntriesForLangPlatSet(-554696704, 0);
    }

    public Vector getEntriesForLangPlatSet(int bslPos, int bspPos) {
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            Vector vEntries = this.getFileEntries(bslPos, bspPos);
            if (vEntries != null) {
                vEntries = (Vector)vEntries.clone();
            }
            return vEntries;
        }
        return this.getEntriesForLangPlatSet1x(bslPos, bspPos);
    }

    private Vector getEntriesForLangPlatSet1x(int bslPos, int bspPos) {
        Vector<OiisPathEntry> retEntries = new Vector<OiisPathEntry>(5, 5);
        if (bspPos < this.m_platSets.size() && bslPos < this.m_langSets.size()) {
            Vector allEntries = this.getEntries();
            int numAllEntries = allEntries.size();
            for (int i = 0; i < numAllEntries; ++i) {
                OiisPathEntry pe = (OiisPathEntry)allEntries.elementAt(i);
                if (pe instanceof OiisFileEntry) {
                    OiisFileEntry fpe = (OiisFileEntry)pe;
                    int pebspPos = fpe.getPlatBitSetRefPos();
                    int pebslPos = fpe.getLangBitSetRefPos();
                    if (pebspPos != bspPos || pebslPos != bslPos) continue;
                    retEntries.addElement(pe);
                    continue;
                }
                retEntries.addElement(pe);
            }
        }
        return retEntries;
    }

    int[] getPlatformsForPlatSet(int bspPos) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            return pim.getPlatsForPlatSetIndex(bspPos);
        }
        return this.getPlatformsForPlatSet2x(bspPos);
    }

    private int[] getPlatformsForPlatSet2x(int bspPos) {
        int[] retPlatArr = null;
        OiisPlatIndexMapping pim = this.getPlatIndexMapping();
        if (pim != null && bspPos < this.m_platSets.size()) {
            BitSet psbsp = (BitSet)this.m_platSets.elementAt(bspPos);
            int[] knownPlats = pim.getPlats();
            if (OiisPlatIndexMapping.isPlatAllBitSet(psbsp)) {
                retPlatArr = knownPlats;
            } else {
                int i;
                int numSetPlats = 0;
                int psCntr = 0;
                int bsSize = psbsp.size();
                for (i = 0; i < bsSize; ++i) {
                    if (!psbsp.get(i)) continue;
                    ++numSetPlats;
                }
                retPlatArr = new int[numSetPlats];
                for (i = 0; i < bsSize; ++i) {
                    if (!psbsp.get(i)) continue;
                    retPlatArr[psCntr++] = knownPlats[i];
                }
            }
        }
        return retPlatArr;
    }

    public Locale[] getLanguagesForLangSet(int bslPos) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            Vector vLangs = lim.getLangsForLangSetIndex(bslPos);
            Object[] aoLocales = new Locale[vLangs.size()];
            vLangs.copyInto(aoLocales);
            return aoLocales;
        }
        return this.getLanguagesForLangSet2x(bslPos);
    }

    private Locale[] getLanguagesForLangSet2x(int bslPos) {
        Locale[] retLangArr = null;
        OiisLangIndexMapping lim = this.getLangIndexMapping();
        if (lim != null && bslPos < this.m_langSets.size()) {
            BitSet psbsl = (BitSet)this.m_langSets.elementAt(bslPos);
            Locale[] knownLangs = lim.getLangs();
            if (OiisLangIndexMapping.isLangAllBitSet(psbsl)) {
                retLangArr = knownLangs;
            } else {
                int i;
                int numSetLangs = 0;
                int psCntr = 0;
                int bsSize = psbsl.size();
                for (i = 0; i < bsSize; ++i) {
                    if (!psbsl.get(i)) continue;
                    ++numSetLangs;
                }
                retLangArr = new Locale[numSetLangs];
                for (i = 0; i < bsSize; ++i) {
                    if (!psbsl.get(i)) continue;
                    retLangArr[psCntr++] = knownLangs[i];
                }
            }
        }
        return retLangArr;
    }

    public Vector getRelevantPlatSetList() {
        return this.getRelevantPlatSetList(OiixPlatform.getCurrentPlatform());
    }

    public Vector getRelevantPlatSetList(Vector plats) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            return OiixVectorOps.intArr2Vect(pim.getRelevantPlatSetList(plats));
        }
        return this.getRelevantPlatSetList2x(plats);
    }

    private Vector getRelevantPlatSetList2x(Vector plats) {
        int i;
        Vector platSets = new Vector(5, 5);
        if (plats == null) {
            int[] allPlats = OiixPlatform.getPlatforms();
            plats = new Vector<Integer>(allPlats.length, 5);
            for (i = 0; i < allPlats.length; ++i) {
                plats.addElement(new Integer(allPlats[i]));
            }
        }
        int numPlats = plats.size();
        for (i = 0; i < numPlats; ++i) {
            int plat = (Integer)plats.elementAt(i);
            platSets = OiixVectorOps.union(platSets, this.getRelevantPlatSetList(plat));
        }
        return platSets;
    }

    public Vector getRelevantPlatSetList(int platform) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            return OiixVectorOps.intArr2Vect(pim.getRelevantPlatSetList(platform));
        }
        return this.getRelevantPlatSetList2x(platform);
    }

    private Vector getRelevantPlatSetList2x(int platform) {
        int curPlatInd;
        Vector platSets = new Vector(5, 5);
        OiisPlatIndexMapping pim = this.getPlatIndexMapping();
        if (pim != null && (curPlatInd = pim.indexOfPlat(platform)) != -1) {
            platSets = (Vector)this.m_platToSetsMapping.elementAt(curPlatInd);
        }
        return platSets;
    }

    public Vector getRelevantPlatSets(Vector plats) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            return pim.getRelevantPlatSets(plats);
        }
        return this.getRelevantPlatSets2x(plats);
    }

    private Vector getRelevantPlatSets2x(Vector plats) {
        Vector setList = this.getRelevantPlatSetList(plats);
        int numPSets = setList.size();
        Vector retSets = new Vector(numPSets);
        for (int i = 0; i < numPSets; ++i) {
            int psInd = (Integer)setList.elementAt(i);
            retSets.addElement(this.m_platSets.elementAt(psInd));
        }
        return retSets;
    }

    public Vector getRelevantLangSetList(Vector locales) {
        return this.getRelevantLangSetList(locales, false);
    }

    public Vector getRelevantLangSetList(Vector locales, boolean bAllLangs) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            int[] aiLangSetIdx = lim.getRelevantLangSetList(locales, bAllLangs);
            return OiixVectorOps.intArr2Vect(aiLangSetIdx);
        }
        return this.getRelevantLangSetList2x(locales, bAllLangs);
    }

    private Vector getRelevantLangSetList2x(Vector locales, boolean bAllLAngs) {
        int i;
        Vector langSets = new Vector(5, 5);
        if (locales == null || bAllLAngs) {
            Locale[] allLangs = OiixLanguage.getLanguages();
            locales = new Vector<Locale>(allLangs.length, 5);
            for (i = 0; i < allLangs.length; ++i) {
                locales.addElement(allLangs[i]);
            }
        }
        int numLocs = locales.size();
        for (i = 0; i < numLocs; ++i) {
            Locale loc = (Locale)locales.elementAt(i);
            langSets = OiixVectorOps.union(langSets, this.getRelevantLangSetList2x(loc));
        }
        return langSets;
    }

    public Vector getRelevantLangSetList(Locale locale) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            int[] aiLangSetIdx = lim.getRelevantLangSetList(locale);
            return OiixVectorOps.intArr2Vect(aiLangSetIdx);
        }
        return this.getRelevantLangSetList2x(locale);
    }

    private Vector getRelevantLangSetList2x(Locale locale) {
        int curLangInd;
        Vector langSets = new Vector(5, 5);
        OiisLangIndexMapping lim = this.getLangIndexMapping();
        if (lim != null && (curLangInd = lim.indexOfLang(locale)) != -1) {
            langSets = (Vector)this.m_langToSetsMapping.elementAt(curLangInd);
        }
        return langSets;
    }

    public void updateFileGroupPlatLangInfo() {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            this.m_iFileGroupPlatSetIndex = pim.addPlatSet(this.m_oFileGroupPlatSet);
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            this.m_iFileGroupLangSetIndex = lim.addLangSet(this.m_oFileGroupLangSet);
        }
    }

    public void computePlatToSetsMapping() {
        if (this.iFileGroupType != 4 && this.iFileGroupType != 5) {
            this.m_platToSetsMapping = new Vector(5, 5);
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            if (pim != null) {
                int[] pimPlats = pim.getPlats();
                for (int platInd = 0; platInd < pimPlats.length; ++platInd) {
                    int numSets = this.m_platSets.size();
                    Vector<Integer> indVect = new Vector<Integer>(numSets, 5);
                    for (int i = 0; i < numSets; ++i) {
                        Integer addInd;
                        BitSet pebs = (BitSet)this.m_platSets.elementAt(i);
                        if (!OiisPlatIndexMapping.isPlatAllBitSet(pebs) && !pebs.get(platInd) || indVect.contains(addInd = new Integer(i))) continue;
                        indVect.addElement(addInd);
                    }
                    this.m_platToSetsMapping.addElement(indVect);
                }
            }
        }
    }

    public void computeLangToSetsMapping() {
        if (this.iFileGroupType != 4 && this.iFileGroupType != 5) {
            this.m_langToSetsMapping = new Vector(5, 5);
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            if (lim != null) {
                Locale[] limLangs = lim.getLangs();
                for (int langInd = 0; langInd < limLangs.length; ++langInd) {
                    int numSets = this.m_langSets.size();
                    Vector<Integer> indVect = new Vector<Integer>(numSets, 5);
                    for (int i = 0; i < numSets; ++i) {
                        Integer addInd;
                        BitSet pebs = (BitSet)this.m_langSets.elementAt(i);
                        if (!OiisLangIndexMapping.isLangAllBitSet(pebs) && !pebs.get(langInd) || indVect.contains(addInd = new Integer(i))) continue;
                        indVect.addElement(addInd);
                    }
                    this.m_langToSetsMapping.addElement(indVect);
                }
            }
        }
    }

    public OiisDestinationIndexMapping getDestIndexMapping() {
        if (this.m_destIndMap == null) {
            this.m_destIndMap = this.getFileMapRef().getDestIndexMapping();
        }
        return this.m_destIndMap;
    }

    private OiisPlatIndexMapping getPlatIndexMapping() {
        if (this.m_platIndMap == null) {
            this.m_platIndMap = this.getFileMapRef().getPlatIndexMapping();
        }
        return this.m_platIndMap;
    }

    private OiisLangIndexMapping getLangIndexMapping() {
        if (this.m_langIndMap == null) {
            this.m_langIndMap = this.getFileMapRef().getLangIndexMapping();
        }
        return this.m_langIndMap;
    }

    public BitSet genPlatsBitSet(Vector plats) {
        OiisPlatIndexMapping pim = this.getPlatIndexMapping();
        return pim.genPlatsBitSet(plats);
    }

    public BitSet genPlatAllBitSet() {
        OiisPlatIndexMapping pim = this.getPlatIndexMapping();
        return pim.genPlatAllBitSet();
    }

    public int indexOfPlatBitSet(BitSet bs) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisPlatIndexMapping pim = this.getPlatIndexMapping();
            return pim.indexOfPlatBitSet(bs);
        }
        int exPos = -1;
        if (OiisPlatIndexMapping.isPlatAllBitSet(bs)) {
            int numPS = this.m_platSets.size();
            for (int i = 0; i < numPS; ++i) {
                BitSet exBS = (BitSet)this.m_platSets.elementAt(i);
                if (!OiisPlatIndexMapping.isPlatAllBitSet(exBS)) continue;
                exPos = i;
                break;
            }
        } else {
            exPos = this.m_platSets.indexOf(bs);
        }
        return exPos;
    }

    public BitSet genLangsBitSet(Vector langs) {
        OiisLangIndexMapping lim = this.getLangIndexMapping();
        return lim.genLangsBitSet(langs);
    }

    public BitSet genLangAllBitSet() {
        OiisLangIndexMapping lim = this.getLangIndexMapping();
        return lim.genLangAllBitSet();
    }

    public int indexOfLangBitSet(BitSet bs) {
        if (this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            OiisLangIndexMapping lim = this.getLangIndexMapping();
            return lim.indexOfLangBitSet(bs);
        }
        int exPos = -1;
        if (OiisLangIndexMapping.isLangAllBitSet(bs)) {
            int numPS = this.m_langSets.size();
            for (int i = 0; i < numPS; ++i) {
                BitSet exBS = (BitSet)this.m_langSets.elementAt(i);
                if (!OiisLangIndexMapping.isLangAllBitSet(exBS)) continue;
                exPos = i;
                break;
            }
        } else {
            exPos = this.m_langSets.indexOf(bs);
        }
        return exPos;
    }

    public void removeEntry(OiisPathEntry entry) {
        if (entry != null) {
            if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
                Hashtable oTable = this.getEntriesTable();
                Enumeration enum_1 = oTable.keys();
                boolean bRemoved = false;
                while (!bRemoved && enum_1.hasMoreElements()) {
                    Vector vEntries = (Vector)oTable.get(enum_1.nextElement());
                    if (vEntries == null) continue;
                    bRemoved = vEntries.removeElement(entry);
                }
            } else {
                this.getFileEntries().removeElement(entry);
            }
        }
    }

    public Vector getEntries() {
        return this.getFileEntries();
    }

    public String getName() {
        return this.m_name;
    }

    public void setJarName(String jarName) {
        this.m_jarName = jarName;
    }

    public String getJarName() {
        String retName = this.m_jarName;
        if (retName == null) {
            retName = this.m_name;
        }
        return retName;
    }

    void setPlatSetIndex(int iPlatSetIndex) {
        this.m_iFileGroupPlatSetIndex = iPlatSetIndex;
    }

    public int getPlatSetIndex() {
        return this.m_iFileGroupPlatSetIndex;
    }

    void setLangSetIndex(int iLangSetIndex) {
        this.m_iFileGroupLangSetIndex = iLangSetIndex;
    }

    int getLangSetIndex() {
        return this.m_iFileGroupLangSetIndex;
    }

    public long getSize() {
        return this.getSize(null, null);
    }

    public long getSize(Vector langs) {
        return this.getSize(langs, null);
    }

    public long getSize(Vector langs, Vector plats) {
        Vector langSets = this.getRelevantLangSetList(langs);
        Vector platSets = this.getRelevantPlatSetList(plats);
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            return this.getSize2x(langSets, platSets);
        }
        return this.getSize1x(langSets, platSets);
    }

    private long getSize2x(Vector langSets, Vector platSets) {
        long size = 0L;
        int nLangSets = langSets.size();
        int nPlatSets = platSets.size();
        for (int i = 0; i < nLangSets; ++i) {
            int iLangIndex = (Integer)langSets.elementAt(i);
            for (int j = 0; j < nPlatSets; ++j) {
                int iPlatIndex = (Integer)platSets.elementAt(j);
                Vector vEntries = this.getFileEntries(i, j);
                if (vEntries == null) continue;
                int nCnt = vEntries.size();
                for (int k = 0; k < nCnt; ++k) {
                    OiisPathEntry pe = (OiisPathEntry)vEntries.elementAt(k);
                    if (!(pe instanceof OiisFileEntry)) continue;
                    OiisFileEntry fpe = (OiisFileEntry)pe;
                    size += fpe.getSizeEx();
                }
            }
        }
        return size;
    }

    private long getSize1x(Vector langSets, Vector platSets) {
        long size = 0L;
        Vector vEntries = this.getFileEntries();
        int nCnt = vEntries.size();
        for (int i = 0; i < nCnt; ++i) {
            OiisPathEntry pe = (OiisPathEntry)vEntries.elementAt(i);
            if (!(pe instanceof OiisFileEntry)) continue;
            OiisFileEntry fpe = (OiisFileEntry)pe;
            int lbsrp = fpe.getLangBitSetRefPos();
            int pbsrp = fpe.getPlatBitSetRefPos();
            if (!langSets.contains(new Integer(lbsrp)) || !platSets.contains(new Integer(pbsrp))) continue;
            size += fpe.getSizeEx();
        }
        return size;
    }

    void updateFileSizeInfo(OiisFileSizeInfo fsi) {
        Hashtable oEntriesTable = this.getEntriesTable();
        Enumeration entrySets = oEntriesTable.elements();
        while (entrySets.hasMoreElements()) {
            Vector vEntries = (Vector)entrySets.nextElement();
            if (vEntries == null) continue;
            int nCnt = vEntries.size();
            for (int i = 0; i < nCnt; ++i) {
                OiisFileEntry fe = (OiisFileEntry)vEntries.elementAt(i);
                fe.updateFileSizeInfo(fsi);
            }
        }
    }

    public long getSizeForLPSetVals(int lbsInd, int pbsInd) {
        Vector<Integer> langSets = new Vector<Integer>(1, 1);
        langSets.addElement(new Integer(lbsInd));
        Vector<Integer> platSets = new Vector<Integer>(1, 1);
        platSets.addElement(new Integer(pbsInd));
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            return this.getSize2x(langSets, platSets);
        }
        return this.getSize1x(langSets, platSets);
    }

    public boolean equals(String name) {
        return this.m_name.equals(name);
    }

    public boolean equals(OiisFileGroup fgroup) {
        if (fgroup != null && this.m_name.equals(fgroup.getName())) {
            return OiixVectorOps.vectorsEqual(this.getFileEntries(), fgroup.getEntries());
        }
        return false;
    }

    public String toString() {
        return "[" + this.m_name + "::" + this.getFileEntries().toString() + "\n" + this.iFileGroupType + "]";
    }

    public boolean isGroupArchived() {
        return !this.m_bUnarchive;
    }

    public void setGroupArchived(boolean archive) {
        this.m_bUnarchive = !archive;
    }

    public String getGroupLocation() {
        return this.m_sLocation;
    }

    public void setGroupLocation(String location) {
        this.m_sLocation = location;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setGroupRefs(this.m_entries);
    }

    public String formDefaultFileName() {
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            return this.getName();
        }
        return this.getName() + ".entries";
    }

    protected Vector writeFileEntries(String sLocation) throws IOException {
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            return this.writeFileEntries2x(sLocation);
        }
        return this.writeFileEntries1x(sLocation);
    }

    protected Vector writeFileEntries2x(String sLocation) throws IOException {
        Vector<String> vEntryNames = new Vector<String>(this.m_oEntriesTable.size(), 5);
        Enumeration enum_1 = this.m_oEntriesTable.keys();
        while (enum_1.hasMoreElements()) {
            Vector vEntries;
            String sKey = (String)enum_1.nextElement();
            Object oEntries = this.m_oEntriesTable.get(sKey);
            if (oEntries != null && !(oEntries instanceof Vector) || (vEntries = (Vector)oEntries) == null || vEntries.size() <= 0) continue;
            if (this.m_sEntryFileName == null) {
                this.setEntriesFileName(this.formDefaultFileName());
            }
            String path = sLocation + File.separator + this.m_sEntryFileName + this.getEntriesFileNameThunk(sKey) + "." + s_sExtn;
            vEntryNames.addElement(path);
            this.writeFileEntries(path, vEntries);
        }
        return vEntryNames;
    }

    protected Vector writeFileEntries1x(String sLocation) throws IOException {
        Vector<String> vEntries = new Vector<String>(1, 1);
        if (this.m_sEntryFileName == null) {
            this.setEntriesFileName(this.formDefaultFileName());
        }
        String path = sLocation + File.separator + this.m_sEntryFileName;
        vEntries.addElement(path);
        this.writeFileEntries(path, this.m_entries);
        return vEntries;
    }

    private void writeFileEntries(String sLocation, Vector vEntries) throws IOException {
        FileOutputStream fileOut = new FileOutputStream(sLocation);
        BufferedOutputStream bFileOut = new BufferedOutputStream(fileOut);
        ObjectOutputStream outStream = new ObjectOutputStream(bFileOut);
        outStream.writeObject(vEntries);
        outStream.close();
        bFileOut.close();
        fileOut.close();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Vector savEntries = this.m_entries;
        Vector savPlatSets = this.m_platSets;
        Vector savPlatToSetsMapping = this.m_platToSetsMapping;
        Vector savLangSets = this.m_langSets;
        Vector savLangToSetsMapping = this.m_langToSetsMapping;
        if (this.iFileGroupType != 1) {
            this.m_entries = null;
        }
        if (this.iFileGroupType == 4) {
            this.m_platSets = null;
            this.m_platToSetsMapping = null;
            this.m_langSets = null;
            this.m_langToSetsMapping = null;
        }
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4) {
            Vector<String> vEntryKeys = new Vector<String>(this.m_oEntriesTable.size());
            Enumeration enum_1 = this.m_oEntriesTable.keys();
            while (enum_1.hasMoreElements()) {
                String key = (String)enum_1.nextElement();
                Object val = this.m_oEntriesTable.get(key);
                if (!(val instanceof Vector) || ((Vector)val).size() <= 0) continue;
                vEntryKeys.addElement(key);
            }
            this.m_asEntryKeys = new String[vEntryKeys.size()];
            vEntryKeys.copyInto(this.m_asEntryKeys);
        }
        out.defaultWriteObject();
        this.m_entries = savEntries;
        this.m_platSets = savPlatSets;
        this.m_platToSetsMapping = savPlatToSetsMapping;
        this.m_langSets = savLangSets;
        this.m_langToSetsMapping = savLangToSetsMapping;
    }

    private void setGroupRefs(Vector vEntries) {
        if (vEntries == null) {
            return;
        }
        int numEntries = vEntries.size();
        for (int i = 0; i < numEntries; ++i) {
            OiisPathEntry pe = (OiisPathEntry)vEntries.elementAt(i);
            if (!(pe instanceof OiisFileEntry)) continue;
            ((OiisFileEntry)pe).setGroupRef(this);
        }
        if (this.iFileGroupType != 4 && this.iFileGroupType != 5) {
            if (this.m_platSets == null) {
                this.m_platSets = new Vector(5, 5);
                this.m_platSets.addElement(this.genPlatAllBitSet());
            }
            if (this.m_langSets == null) {
                this.m_langSets = new Vector(5, 5);
                this.m_langSets.addElement(this.genLangAllBitSet());
            }
        }
        if (this.m_sLocation == null) {
            this.m_sLocation = "";
        }
    }

    Hashtable getEntriesTable() {
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            Vector relLangSets = this.getRelevantLangSetList(null, true);
            Vector relPlatSets = this.getRelevantPlatSetList(null);
            int numLS = relLangSets.size();
            int numPS = relPlatSets.size();
            for (int i = 0; i < numLS; ++i) {
                int lsInd = (Integer)relLangSets.elementAt(i);
                for (int j = 0; j < numPS; ++j) {
                    int psInd = (Integer)relPlatSets.elementAt(j);
                    this.getFileEntries(lsInd, psInd);
                }
            }
            this.getFileEntries(-554696704, 0);
        }
        return this.m_oEntriesTable;
    }

    private Hashtable createEntriesTable() {
        int nCnt = 0;
        if (this.m_asEntryKeys != null) {
            nCnt = this.m_asEntryKeys.length;
        }
        Hashtable<String, String> oEntriesTable = nCnt != 0 ? new Hashtable(nCnt) : new Hashtable<String, String>();
        for (int i = 0; i < nCnt; ++i) {
            oEntriesTable.put(this.m_asEntryKeys[i], S_NOT_LOADED);
        }
        return oEntriesTable;
    }

    public boolean containsFileEntriesForLangPlat(int lsInd, int psInd) {
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            String sKey = this.getKey(lsInd, psInd);
            if (this.m_asEntryKeys != null) {
                for (int i = 0; i < this.m_asEntryKeys.length; ++i) {
                    if (!this.m_asEntryKeys[i].equalsIgnoreCase(sKey)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public boolean hasFileEntries(int exlPos, int expPos) {
        if (this.m_oEntriesTable == null) {
            this.m_oEntriesTable = this.createEntriesTable();
        }
        String sKey = this.getKey(exlPos, expPos);
        return this.m_oEntriesTable.containsKey(sKey);
    }

    public int getFileGroupStyle() {
        if (this.m_bShouldDefaultify) {
            return 0;
        }
        return 1;
    }

    private Vector getFileEntries(int exlPos, int expPos) {
        if (this.m_oEntriesTable == null) {
            this.m_oEntriesTable = this.createEntriesTable();
        }
        Object oEntries = S_NOT_LOADED;
        Vector vEntries = null;
        boolean bFileLoaded = true;
        String sKey = this.getKey(exlPos, expPos);
        bFileLoaded = this.m_oEntriesTable.containsKey(sKey) ? ((oEntries = this.m_oEntriesTable.get(sKey)) == null || oEntries instanceof Vector ? (vEntries = (Vector)this.m_oEntriesTable.get(sKey)) != null : false) : false;
        if (!bFileLoaded) {
            try {
                String sExtn = this.iFileGroupType == 5 ? s_sXMLExtn : s_sExtn;
                String sFileEntriesLoc = this.getFileMapRef().getFileMapPath() + this.m_sEntryFileName + this.getEntriesFileNameThunk(sKey) + "." + sExtn;
                vEntries = this.getFileEntriesInternal(sFileEntriesLoc);
                oEntries = vEntries;
            }
            catch (Exception e) {
                e.printStackTrace();
                vEntries = new Vector(5, 5);
                oEntries = vEntries;
            }
            if (oEntries != null) {
                if (oEntries.equals(S_NOT_LOADED)) {
                    this.m_oEntriesTable.remove(sKey);
                }
                this.m_oEntriesTable.put(sKey, oEntries);
            }
        }
        return vEntries;
    }

    private Vector getFileEntries() {
        Vector vEntries = this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5 ? this.getFileEntries2x() : this.getFileEntries1x();
        return vEntries;
    }

    private Vector getFileEntries2x() {
        Vector vEntries = null;
        Hashtable oTable = this.getEntriesTable();
        if (oTable != null) {
            Enumeration enum_1 = oTable.keys();
            vEntries = new Vector(10 * oTable.size(), 10);
            while (enum_1.hasMoreElements()) {
                Vector vEntriesInTable;
                String sKey = (String)enum_1.nextElement();
                Object obj = oTable.get(sKey);
                if (!(obj instanceof Vector) || (vEntriesInTable = (Vector)obj) == null) continue;
                OiixVectorOps.unionInPlace(vEntries, vEntriesInTable);
            }
        }
        return vEntries;
    }

    private Vector getFileEntries1x() {
        if (this.m_entries == null) {
            try {
                String sFileEntriesLoc = this.getFileMapRef().getFileMapPath() + this.m_sEntryFileName;
                this.m_entries = this.getFileEntriesInternal(sFileEntriesLoc);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_entries = new Vector(5, 5);
            }
        }
        return this.m_entries;
    }

    private Vector getFileEntriesInternal(String sLocation) throws IOException, ClassNotFoundException, NullPointerException {
        Vector vEntries = null;
        OiixJarClassLoader oJcl = this.getLoader();
        if (oJcl != null) {
            if (oJcl.entryExists(sLocation)) {
                InputStream is = oJcl.getLocalResourceAsStream(sLocation);
                if (this.iFileGroupType == 5) {
                    OiisFileMapXMLReader reader = OiisFileMapXMLReader.getReader();
                    vEntries = reader.readFileEntriesXML(is);
                } else {
                    ObjectInputStream ois = new ObjectInputStream(is);
                    vEntries = (Vector)ois.readObject();
                    ois.close();
                }
                is.close();
                this.setGroupRefs(vEntries);
            }
        } else {
            return new Vector(5, 5);
        }
        return vEntries;
    }

    private OiixJarClassLoader getLoader() {
        return this.m_fileMapRef.getClassLoader();
    }

    public void unloadFileEntries(int exlPos, int expPos) {
        Object oEntries;
        String sKey;
        if ((this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) && this.m_oEntriesTable != null && this.m_oEntriesTable.containsKey(sKey = this.getKey(exlPos, expPos)) && (oEntries = this.m_oEntriesTable.get(sKey)) != null && oEntries instanceof Vector) {
            Vector vEntries = (Vector)oEntries;
            vEntries.removeAllElements();
            this.m_oEntriesTable.remove(sKey);
            this.m_oEntriesTable.put(sKey, S_NOT_LOADED);
        }
    }

    public void unloadFileEntries() {
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4 || this.iFileGroupType == 5) {
            this.unloadFileEntries2x();
        } else if (this.iFileGroupType == 2) {
            this.unloadFileEntries1x();
        }
    }

    private void unloadFileEntries2x() {
        if (this.m_oEntriesTable != null) {
            this.m_oEntriesTable.clear();
        }
        this.m_oEntriesTable = null;
    }

    private void unloadFileEntries1x() {
        if (this.m_entries != null) {
            this.m_entries.removeAllElements();
        }
        this.m_entries = null;
    }

    public Vector getFileEntriesList() {
        Vector<String> vEntryNames;
        String sFileMapPath = this.getFileMapRef().getFileMapPath();
        if (this.iFileGroupType == 3 || this.iFileGroupType == 4) {
            if (this.m_asEntryKeys == null) {
                Hashtable oEntriesTable = this.getEntriesTable();
                vEntryNames = new Vector(oEntriesTable.size(), 5);
                Enumeration enum_1 = oEntriesTable.keys();
                while (enum_1.hasMoreElements()) {
                    vEntryNames.addElement(sFileMapPath + this.m_sEntryFileName + this.getEntriesFileNameThunk((String)enum_1.nextElement()) + "." + s_sExtn);
                }
            } else {
                vEntryNames = new Vector(this.m_asEntryKeys.length, 5);
                for (int i = 0; i < this.m_asEntryKeys.length; ++i) {
                    vEntryNames.addElement(sFileMapPath + this.m_sEntryFileName + this.getEntriesFileNameThunk(this.m_asEntryKeys[i]) + "." + s_sExtn);
                }
            }
        } else {
            vEntryNames = new Vector<String>(1, 5);
            vEntryNames.addElement(sFileMapPath + this.m_sEntryFileName);
        }
        return vEntryNames;
    }

    public Enumeration getEntriesKeys() {
        Enumeration oRetVal = null;
        if (this.m_oEntriesTable != null) {
            oRetVal = this.m_oEntriesTable.keys();
        }
        return oRetVal;
    }

    public Hashtable getDestToEntriesMapping() {
        if (this.m_oRevEntriesTable == null) {
            this.m_oRevEntriesTable = new Hashtable(101);
            if (this.m_oEntriesTable != null) {
                Enumeration oKeys = this.m_oEntriesTable.keys();
                while (oKeys.hasMoreElements()) {
                    String sKey = (String)oKeys.nextElement();
                    Vector vEntries = (Vector)this.m_oEntriesTable.get(sKey);
                    if (vEntries == null) continue;
                    Enumeration oFileEntries = vEntries.elements();
                    while (oFileEntries.hasMoreElements()) {
                        OiisFileEntry oEntry = (OiisFileEntry)oFileEntries.nextElement();
                        Vector<OiisFileEntry> vMappedEntries = (Vector<OiisFileEntry>)this.m_oRevEntriesTable.get(oEntry.getDestination());
                        if (vMappedEntries == null) {
                            vMappedEntries = new Vector<OiisFileEntry>(1);
                        }
                        vMappedEntries.addElement(oEntry);
                        this.m_oRevEntriesTable.put(oEntry.getDestination(), vMappedEntries);
                    }
                }
            }
        }
        return this.m_oRevEntriesTable;
    }

    public boolean getShouldDefaultify() {
        return this.m_bShouldDefaultify;
    }

    public void setShouldDefaultify(boolean bDefaultify) {
        this.m_bShouldDefaultify = bDefaultify;
    }

    private boolean isDefaultFileEntry(OiisFileEntry oFileEntry, BitSet oLbs) {
        boolean retVal = false;
        if (oFileEntry != null) {
            int indexOfPercent;
            String sDest;
            boolean bForEnglish = false;
            boolean bInOracleHome = false;
            if (OiisLangIndexMapping.isLangAllBitSet(oLbs)) {
                bForEnglish = true;
            } else {
                int iEngIdx = this.getEngBitInLangSet();
                if (iEngIdx >= 0) {
                    bForEnglish = oLbs.get(iEngIdx);
                }
            }
            if (bForEnglish && (sDest = oFileEntry.getDestination()) != null && (bInOracleHome = sDest.trim().startsWith(S_ORACLE_HOME_VAR)) && (indexOfPercent = sDest.indexOf(37, S_ORACLE_HOME_VAR.length())) > 0) {
                bInOracleHome = false;
            }
            retVal = bForEnglish && bInOracleHome && oFileEntry.isForAllStagedPlats();
        }
        return retVal;
    }

    public String getEntriesFileNameThunk(String sKey) {
        return S_DEFAULT_ENTRIES_KEY.equals(sKey) ? "" : "." + sKey;
    }

    private int getEngBitInLangSet() {
        if (this.m_EngBitSet == null) {
            Vector<Locale> vTmp = new Vector<Locale>(1);
            vTmp.addElement(Locale.ENGLISH);
            this.m_EngBitSet = this.genLangsBitSet(vTmp);
        }
        return this.m_EngBitSet.length() - 1;
    }
}

