/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.File;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiii.OiiiCdLabel;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiisDiskLocator {
    private OiisVariableOwner m_oVarOwner;

    public OiisDiskLocator(OiisVariableOwner oVarOwner) {
        this.m_oVarOwner = oVarOwner;
    }

    public String getDiskLocation(String sLocation, String sLabel, int nDiskNumber) throws OiiiDiskNotFoundException {
        String diskLoc = sLocation;
        if (sLabel != null) {
            if (OiisDiskLocator.isValidDisk(diskLoc = this.getNativeLoc(diskLoc), sLabel, nDiskNumber)) {
                return diskLoc;
            }
            diskLoc = this.getDiskLocFromVar(nDiskNumber);
            if (!diskLoc.equals("")) {
                diskLoc = this.getLocationWithStage(diskLoc);
                if (OiisDiskLocator.isValidDisk(diskLoc = this.getNativeLoc(diskLoc), sLabel, nDiskNumber)) {
                    return diskLoc;
                }
            }
            diskLoc = OiiiTargetAreaControl.getDefaultDiskLocation(sLocation, nDiskNumber);
            if (OiisDiskLocator.isValidDisk(diskLoc = this.getNativeLoc(diskLoc), sLabel, nDiskNumber)) {
                return diskLoc;
            }
            diskLoc = this.getDiskLocationFromUser(sLocation, sLabel, nDiskNumber);
        }
        return diskLoc;
    }

    private String getDiskLocationFromUser(String sDefLoc, String label, int nDiskNumber) throws OiiiDiskNotFoundException {
        String diskLoc = sDefLoc;
        do {
            if (diskLoc.endsWith("stage" + File.separator) || diskLoc.endsWith("stage/")) {
                diskLoc = diskLoc.substring(0, diskLoc.length() - 6);
            }
            diskLoc = OiicSessionInterfaceManager.getInterfaceManager().getDiskLocation(diskLoc, label, nDiskNumber);
            diskLoc = OiixPathOps.directorify(diskLoc);
            if (OiisDiskLocator.isValidDisk(diskLoc = this.getNativeLoc(diskLoc), label, nDiskNumber)) break;
            diskLoc = this.getLocationWithStage(diskLoc);
        } while (!OiisDiskLocator.isValidDisk(diskLoc = this.getNativeLoc(diskLoc), label, nDiskNumber));
        return diskLoc;
    }

    private String getNativeLoc(String diskLoc) {
        String sNewLoc = OiixPathOps.getUnexpandedCanonicalPath(diskLoc);
        sNewLoc = OiixPathOps.getStandardForm(sNewLoc);
        sNewLoc = OiixPathOps.directorify(sNewLoc);
        sNewLoc = OiixPathOps.getNativeForm(sNewLoc);
        return sNewLoc;
    }

    private String getLocationWithStage(String defLoc) {
        String diskLoc = OiixPathOps.getStandardForm(defLoc);
        diskLoc = OiixPathOps.directorify(diskLoc);
        diskLoc = OiixPathOps.concatPath(diskLoc, "stage");
        diskLoc = OiixPathOps.directorify(diskLoc);
        diskLoc = OiixPathOps.getNativeForm(diskLoc);
        return diskLoc;
    }

    private String getDiskLocFromVar(int nDisk) {
        String sLocation = "";
        if (this.m_oVarOwner != null) {
            OiisVariable oVar = this.m_oVarOwner.getVariable("LOCATION_FOR_DISK" + nDisk);
            if (oVar != null) {
                sLocation = (String)oVar.getValue();
            }
            if (sLocation == null) {
                sLocation = "";
            }
        }
        return sLocation;
    }

    public static boolean isValidDisk(String location, String sLabel, int nDiskNumber) {
        OiiiCdLabel labelFile = new OiiiCdLabel();
        try {
            labelFile.readLabelFile(location);
        }
        catch (Exception e) {
            boolean bl = false;
        }
        boolean retVal = labelFile.equals(sLabel, nDiskNumber);
        return retVal;
    }

    public boolean isDiskAccessible(int nDisk, String sLabel) {
        String sLoc = this.getDiskLocFromVar(nDisk);
        if (sLabel == null || sLabel.length() == 0) {
            return false;
        }
        if (sLoc == null || sLoc.length() == 0) {
            OiisVariable fromLocationVar = this.m_oVarOwner.getVariable("FROM_LOCATION");
            String sRoot = (String)fromLocationVar.getValue();
            sRoot = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sRoot));
            sLoc = OiiiTargetAreaControl.getDefaultDiskLocation(sRoot, nDisk);
            sLoc = this.getNativeLoc(sLoc);
        } else {
            sLoc = this.getNativeLoc(sLoc);
            sLoc = this.getLocationWithStage(sLoc);
        }
        return OiisDiskLocator.isValidDisk(sLoc, sLabel, nDisk);
    }
}

