/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisDeps
implements Serializable {
    static final long serialVersionUID = -3218559353547377617L;
    private transient boolean m_bResourceBundleSet = false;
    private Vector m_depRules;
    private Vector m_depModes;

    public OiisDeps() {
        this.m_depRules = new Vector();
        this.m_depModes = new Vector();
    }

    public OiisDeps(Vector depRules, Vector depModes) {
        this.m_depRules = depRules;
        this.m_depModes = depModes;
        this.m_bResourceBundleSet = false;
    }

    public Vector getDepRules() {
        return this.m_depRules;
    }

    public void setDepRules(Vector depRules) {
        this.m_depRules = depRules;
    }

    public Vector getDepModes() {
        return this.m_depModes;
    }

    public void setDepModes(Vector depModes) {
        this.m_depModes = depModes;
    }

    public OiisDepRule getDepRule(int depRuleId) {
        Enumeration depRules = this.m_depRules.elements();
        while (depRules.hasMoreElements()) {
            OiisDepRule depRL = (OiisDepRule)depRules.nextElement();
            if (depRuleId != depRL.getID()) continue;
            return depRL;
        }
        return null;
    }

    public OiisDepRule getDepRule(String depRuleName) {
        OiisDepRule oRule = null;
        int nIndex = OiixVectorOps.vectIndexOf(this.m_depRules, (Object)depRuleName);
        if (nIndex != -1) {
            oRule = (OiisDepRule)this.m_depRules.elementAt(nIndex);
        }
        return oRule;
    }

    public void setResourceBundle(OiixJarResourceBundle rb) {
        if (rb == null) {
            return;
        }
        if (!this.m_bResourceBundleSet) {
            Enumeration enum_1 = this.m_depRules.elements();
            while (enum_1.hasMoreElements()) {
                OiisDepRule dRule = (OiisDepRule)enum_1.nextElement();
                dRule.setResourceBundle(rb);
            }
            enum_1 = this.m_depModes.elements();
            while (enum_1.hasMoreElements()) {
                OiisDepMode dMode = (OiisDepMode)enum_1.nextElement();
                dMode.setResourceBundle(rb);
            }
            this.m_bResourceBundleSet = true;
        }
    }

    public Vector getAllDependees() {
        Vector<OiiiCompInstallID> depsHere = new Vector<OiiiCompInstallID>();
        int numRules = this.m_depRules.size();
        for (int i = 0; i < numRules; ++i) {
            OiisDepRule drule = (OiisDepRule)this.m_depRules.elementAt(i);
            Vector depIDs = drule.getDepCompIds();
            int numIDs = depIDs.size();
            for (int j = 0; j < numIDs; ++j) {
                OiiiCompInstallID depID = (OiiiCompInstallID)depIDs.elementAt(j);
                if (depsHere.contains(depID)) continue;
                depsHere.addElement(depID);
            }
        }
        return depsHere;
    }

    public int getNextRuleID() {
        int i;
        Vector<Integer> existingRuleIDs = new Vector<Integer>();
        Vector depRules = this.getDepRules();
        int numRules = depRules.size();
        for (i = 0; i < numRules; ++i) {
            OiisDepRule dRule = (OiisDepRule)depRules.elementAt(i);
            existingRuleIDs.addElement(new Integer(dRule.getID()));
        }
        int chosenID = numRules;
        for (i = 0; i < numRules; ++i) {
            if (existingRuleIDs.contains(new Integer(i))) continue;
            chosenID = i;
            break;
        }
        return chosenID;
    }

    public String getNextRuleName() {
        Vector depRules = this.getDepRules();
        int numRules = depRules.size();
        String chosenID = "Group" + numRules;
        for (int i = 0; i < numRules; ++i) {
            if (OiixVectorOps.vectIndexOf(depRules, (Object)("Group" + i)) != -1) continue;
            chosenID = "Group" + i;
            break;
        }
        return chosenID;
    }

    public void optimizePlatList() {
        Vector depRules = this.getDepRules();
        if (depRules == null) {
            return;
        }
        int numRules = depRules.size();
        for (int i = 0; i < numRules; ++i) {
            OiisDepRule dRule = (OiisDepRule)depRules.elementAt(i);
            dRule.optimizePlatList();
        }
        Vector vDepModes = this.getDepModes();
        if (vDepModes == null) {
            return;
        }
        int numModes = vDepModes.size();
        for (int i = 0; i < numModes; ++i) {
            OiisDepMode dMode = (OiisDepMode)vDepModes.elementAt(i);
            dMode.optimizePlatList();
        }
    }

    public void optimizeSizeVector() {
        Vector vDepModes = this.getDepModes();
        if (vDepModes == null) {
            return;
        }
        int numModes = vDepModes.size();
        for (int i = 0; i < numModes; ++i) {
            OiisDepMode dMode = (OiisDepMode)vDepModes.elementAt(i);
            dMode.optimizeSizeVector();
        }
    }

    public boolean isResourceBundleSet() {
        return this.m_bResourceBundleSet;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(OiixResourceBundle.getString("S_LOG_OIISDEPS"));
        Vector depRules = this.getDepRules();
        Vector depModes = this.getDepModes();
        sbuf.append(OiixResourceBundle.getString("S_LOG_RULES_ARE"));
        int numDepRules = depRules.size();
        for (int i = 0; i < numDepRules; ++i) {
            OiisDepRule depRule = (OiisDepRule)depRules.elementAt(i);
            sbuf.append(depRule.toString());
            sbuf.append(", ");
        }
        sbuf.append("] ");
        sbuf.append(OiixResourceBundle.getString("S_LOG_MODES_ARE"));
        int numDepModes = depModes.size();
        for (int i = 0; i < numDepModes; ++i) {
            OiisDepMode depMode = (OiisDepMode)depModes.elementAt(i);
            sbuf.append(depMode.toString());
            sbuf.append(", ");
        }
        sbuf.append("] }");
        return sbuf.toString();
    }
}

