/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisDepRuleComp;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiisDepRuleProperty
implements Serializable {
    static final long serialVersionUID = -1155648764914995474L;
    private int m_id;
    private String m_sRuleName;
    private boolean m_ask;
    private boolean m_bOpen = true;
    private Vector m_depRuleComps;

    public OiisDepRuleProperty(int id, boolean ask, Vector depRuleComps) {
        this.m_id = id;
        this.m_sRuleName = "Group" + Integer.toString(this.m_id);
        this.m_ask = ask;
        this.m_bOpen = true;
        this.m_depRuleComps = depRuleComps;
    }

    public OiisDepRuleProperty(String id, boolean ask, Vector depRuleComps) {
        this.m_sRuleName = id;
        this.m_ask = ask;
        this.m_bOpen = true;
        this.m_depRuleComps = depRuleComps;
    }

    public Vector getDepRuleComps() {
        return this.m_depRuleComps;
    }

    public void setDepRuleComps(Vector depRuleComps) {
        this.m_depRuleComps = depRuleComps;
    }

    public OiisDepRuleComp getDepRuleComp(OiiiCompInstallID cid) {
        int numComps = this.m_depRuleComps.size();
        OiisDepRuleComp retComp = null;
        for (int i = 0; i < numComps; ++i) {
            OiisDepRuleComp iterc = (OiisDepRuleComp)this.m_depRuleComps.elementAt(i);
            OiiiCompInstallID rid = iterc.getComp();
            if (rid == null || !cid.equals(rid)) continue;
            retComp = iterc;
            break;
        }
        return retComp;
    }

    public void optimizePlatList() {
        Vector vRuleComps = this.getDepRuleComps();
        int nSize = vRuleComps.size();
        for (int i = 0; i < nSize; ++i) {
            OiisDepRuleComp oRule = (OiisDepRuleComp)vRuleComps.elementAt(i);
            oRule.optimizePlatList();
        }
    }

    public boolean shouldAsk() {
        return this.m_ask;
    }

    public void setAsk(boolean ask) {
        this.m_ask = ask;
    }

    public boolean isOpen() {
        return this.m_bOpen;
    }

    public void setOpen(boolean bOpen) {
        this.m_bOpen = bOpen;
    }

    public int getRuleID() {
        return this.m_id;
    }

    public void setRuleID(int nId) {
        this.m_id = nId;
    }

    public String getRuleName() {
        if (this.m_sRuleName == null) {
            this.setRuleName("Group" + Integer.toString(this.m_id));
        }
        return this.m_sRuleName;
    }

    public void setRuleName(String nId) {
        this.m_sRuleName = nId;
    }

    public boolean equals(String sName) {
        if (sName == null) {
            return false;
        }
        return sName.equalsIgnoreCase(this.getRuleName());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof String) {
            return this.equals((String)other);
        }
        return super.equals(other);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(OiixResourceBundle.getString("S_LOG_RULE_ID"));
        sbuf.append(this.getRuleName());
        sbuf.append(OiixResourceBundle.getString("S_LOG_ASK"));
        sbuf.append(this.shouldAsk());
        sbuf.append(OiixResourceBundle.getString("S_LOG_OPEN"));
        sbuf.append(this.isOpen());
        sbuf.append(OiixResourceBundle.getString("S_LOG_COMPS"));
        Vector depRuleComps = this.getDepRuleComps();
        int numdrcs = depRuleComps.size();
        for (int i = 0; i < numdrcs; ++i) {
            OiisDepRuleComp depRuleComp = (OiisDepRuleComp)depRuleComps.elementAt(i);
            sbuf.append(depRuleComp.toString());
            sbuf.append(", ");
        }
        sbuf.append(" ]]");
        sbuf.append(System.getProperty("line.separator"));
        return sbuf.toString();
    }
}

