/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Vector;
import oracle.bali.share.nls.StringUtils;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDepRuleComp;
import oracle.sysman.oii.oiis.OiisDepRuleProperty;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisSize;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisDepMode
implements Serializable {
    static final long serialVersionUID = 147936014537106098L;
    public static final int CUSTOMMODE_ID = 0;
    public static final int TYPICALMODE_ID = -1;
    public static final int MINMODE_ID = -2;
    public static final int MAXMODE_ID = -3;
    public static final String S_CUSTOMMODE_ID = "Custom";
    public static final String S_TYPICALMODE_ID = "Typical";
    public static final String S_MINMODE_ID = "Minimum";
    public static final String S_MAXMODE_ID = "Complete";
    public static final int S_REQUIRED_SELECTIONS = 0;
    public static final int S_ONEORMORE_SELECTIONS = 1;
    public static final int S_CONFLICT_SELECTIONS = 2;
    public static final int S_TOTAL_SELECTION_ERROR_TYPES = 3;
    private int m_id;
    private String m_name;
    private Vector m_depRuleProps;
    private String m_sInternalName;
    private OiisSize m_oSize;
    private String m_sDescription;
    private transient OiixJarResourceBundle m_rb;

    public OiisDepMode(int id, String name, Vector depRuleProps) {
        this.m_id = id;
        this.m_sInternalName = OiisDepMode.getInternalNameForID(this.m_id);
        this.m_name = name;
        this.m_depRuleProps = depRuleProps;
        this.m_oSize = new OiisSize();
    }

    public OiisDepMode(String sInternalName, String sExternalNameID, Vector depRuleProps) {
        this.m_sInternalName = sInternalName;
        this.m_name = sExternalNameID;
        this.m_depRuleProps = depRuleProps;
        this.m_oSize = new OiisSize();
    }

    public Vector getDepRuleProps() {
        return this.m_depRuleProps;
    }

    private String getResource(String key) {
        String res = key;
        if (this.m_rb != null) {
            try {
                res = this.m_rb.getString(key);
                if (res != null && res == key) {
                    res = this.m_rb.getString(OiisGenericConstant.formDefaultName(key));
                }
            }
            catch (MissingResourceException e) {
                System.err.println("MissingResourceException in " + this.getInternalName() + ":" + key);
            }
        }
        return res;
    }

    public void optimizePlatList() {
        Vector vRule = this.getDepRuleProps();
        int nSize = vRule.size();
        for (int i = 0; i < nSize; ++i) {
            OiisDepRuleProperty depRuleProp = (OiisDepRuleProperty)vRule.elementAt(i);
            depRuleProp.optimizePlatList();
        }
    }

    public void optimizeSizeVector() {
        this.m_oSize = null;
    }

    public int getId() {
        return this.m_id;
    }

    public void setInternalName(String sName) {
        this.m_sInternalName = sName;
    }

    public String getInternalName() {
        if (this.m_sInternalName == null) {
            this.setInternalName(OiisDepMode.getInternalNameForID(this.m_id));
        }
        return this.m_sInternalName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.getName(true);
    }

    public String getName(boolean bStripMnemonics) {
        return bStripMnemonics ? StringUtils.stripMnemonic((String)this.getResource(this.m_name)) : this.getResource(this.m_name);
    }

    public String getNameID() {
        return this.m_name;
    }

    public void setId(int Id) {
        this.m_id = Id;
        this.setInternalName(OiisDepMode.getInternalNameForID(this.m_id));
    }

    public void setDescription(String sDescription) {
        this.m_sDescription = sDescription;
    }

    public String getDescription() {
        return this.getResource(this.m_sDescription);
    }

    public String getDescriptionID() {
        return this.m_sDescription;
    }

    public void setResourceBundle(OiixJarResourceBundle rb) {
        this.m_rb = rb;
    }

    public boolean equals(String sName) {
        if (sName == null) {
            return false;
        }
        return sName.equalsIgnoreCase(this.getInternalName());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof String) {
            return this.equals((String)other);
        }
        return super.equals(other);
    }

    public static String getInternalNameForID(int id) {
        String s = "INSTALL_TYPE_" + Integer.toString(id);
        switch (id) {
            case 0: {
                s = S_CUSTOMMODE_ID;
                break;
            }
            case -1: {
                s = S_TYPICALMODE_ID;
                break;
            }
            case -2: {
                s = S_MINMODE_ID;
                break;
            }
            case -3: {
                s = S_MAXMODE_ID;
            }
        }
        return s;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(OiixResourceBundle.getString("S_LOG_ID"));
        sbuf.append(this.getInternalName());
        sbuf.append(OiixResourceBundle.getString("S_LOG_NAME"));
        sbuf.append(this.getName());
        sbuf.append(OiixResourceBundle.getString("S_LOG_PROPERTIES_DEPMODE"));
        Vector depRuleProps = this.getDepRuleProps();
        int numdrps = depRuleProps.size();
        for (int i = 0; i < numdrps; ++i) {
            OiisDepRuleProperty depRuleProp = (OiisDepRuleProperty)depRuleProps.elementAt(i);
            sbuf.append(depRuleProp.toString());
            sbuf.append(", ");
        }
        sbuf.append(" ]]");
        sbuf.append(System.getProperty("line.separator"));
        return sbuf.toString();
    }

    public static Vector[] checkErrorInSelections(OiisDepMode dMode, Vector depRules) {
        Vector[] vErrorMsgs = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            vErrorMsgs[i] = new Vector(5, 5);
        }
        int numRules = depRules.size();
        Hashtable<String, Integer> ruleTypeTbl = new Hashtable<String, Integer>();
        for (int i = 0; i < numRules; ++i) {
            OiisDepRule dRule = (OiisDepRule)depRules.elementAt(i);
            ruleTypeTbl.put(dRule.getInternalName(), new Integer(dRule.getType()));
        }
        Vector depRuleProps = dMode.getDepRuleProps();
        int numProps = depRuleProps.size();
        Vector<OiiiCompInstallID> vSelectedComps = new Vector<OiiiCompInstallID>(10, 10);
        Vector<OiiiCompInstallID> vUnSelectedComps = new Vector<OiiiCompInstallID>(10, 10);
        for (int i = 0; i < numRules; ++i) {
            OiisDepRuleProperty depProp = (OiisDepRuleProperty)depRuleProps.elementAt(i);
            String ruleId = depProp.getRuleName();
            int nPrevSelected = vSelectedComps.size();
            boolean bSelected = false;
            Vector depComps = depProp.getDepRuleComps();
            int numDCs = depComps.size();
            for (int j = 0; j < numDCs; ++j) {
                OiisDepRuleComp dc = (OiisDepRuleComp)depComps.elementAt(j);
                OiiiCompInstallID id = dc.getComp();
                if (dc.getSelected()) {
                    bSelected = true;
                    vSelectedComps.addElement(id);
                    if (OiixVectorOps.vectIndexOf(vUnSelectedComps, (Object)id) == -1 || vErrorMsgs[2].indexOf(id) != -1) continue;
                    vErrorMsgs[2].addElement(id);
                    continue;
                }
                vUnSelectedComps.addElement(id);
                if (OiixVectorOps.vectIndexOf(vSelectedComps, (Object)id) == -1 || vErrorMsgs[2].indexOf(id) != -1) continue;
                vErrorMsgs[2].addElement(id);
            }
            int rType = (Integer)ruleTypeTbl.get(ruleId);
            if (!bSelected && rType == 1 && !depComps.isEmpty()) {
                vErrorMsgs[1].addElement(ruleId);
            }
            if (rType != 3 || numDCs <= vSelectedComps.size() - nPrevSelected) continue;
            vErrorMsgs[0].addElement(ruleId);
        }
        return vErrorMsgs;
    }

    public static Vector getInvalidSelections(OiisDepMode dMode, Vector depRules) {
        int i;
        Vector<OiiiCompInstallID> unselComps = new Vector<OiiiCompInstallID>();
        Vector<OiiiCompInstallID> probComps = new Vector<OiiiCompInstallID>();
        Vector<OiisDepRuleProperty> nonOneRules = new Vector<OiisDepRuleProperty>();
        Vector depRuleProps = dMode.getDepRuleProps();
        int numProps = depRuleProps.size();
        int numRules = depRules.size();
        Hashtable<String, Integer> ruleTypeTbl = new Hashtable<String, Integer>();
        for (i = 0; i < numRules; ++i) {
            OiisDepRule dRule = (OiisDepRule)depRules.elementAt(i);
            ruleTypeTbl.put(dRule.getInternalName(), new Integer(dRule.getType()));
        }
        for (i = 0; i < numProps; ++i) {
            OiisDepRuleProperty depProp = (OiisDepRuleProperty)depRuleProps.elementAt(i);
            String ruleId = depProp.getRuleName();
            int rType = (Integer)ruleTypeTbl.get(ruleId);
            if (rType != 2) {
                nonOneRules.addElement(depProp);
                continue;
            }
            Vector depComps = depProp.getDepRuleComps();
            int numDCs = depComps.size();
            for (int j = 0; j < numDCs; ++j) {
                OiisDepRuleComp dc = (OiisDepRuleComp)depComps.elementAt(j);
                if (dc.getSelected()) continue;
                unselComps.addElement(dc.getComp());
            }
        }
        int numNonOnes = nonOneRules.size();
        for (int i2 = 0; i2 < numNonOnes; ++i2) {
            OiisDepRuleProperty depProp = (OiisDepRuleProperty)depRuleProps.elementAt(i2);
            int numUnsels = unselComps.size();
            for (int j = 0; j < numUnsels; ++j) {
                OiiiCompInstallID cid = (OiiiCompInstallID)unselComps.elementAt(j);
                OiisDepRuleComp dc = depProp.getDepRuleComp(cid);
                if (dc == null || !dc.getSelected()) continue;
                probComps.addElement(cid);
            }
        }
        return probComps;
    }

    public boolean isCustomMode() {
        boolean retVal = false;
        Vector vDepRuleProps = this.getDepRuleProps();
        if (vDepRuleProps != null) {
            Enumeration oAllDepRuleProps = vDepRuleProps.elements();
            while (oAllDepRuleProps.hasMoreElements()) {
                OiisDepRuleProperty oDepRuleProp = (OiisDepRuleProperty)oAllDepRuleProps.nextElement();
                if (!oDepRuleProp.shouldAsk()) continue;
                retVal = true;
                break;
            }
        }
        return retVal;
    }
}

