/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiConfigToolID;
import oracle.sysman.oii.oiii.OiiiLibType;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiReadmeID;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisLibDeps;
import oracle.sysman.oii.oiis.OiisReadmeDetails;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;

public class OiisCompProperties
implements Cloneable {
    static final long serialVersionUID = 2266961441150486794L;
    private OiiiCompInstallID m_cID;
    private Vector m_languages;
    private Vector m_supLangs;
    private Locale m_defLang = null;
    private transient OiixJarResourceBundle m_resBundle;
    private String m_location;
    private Vector[] m_libDeps;
    private boolean m_bNoProdHome = false;
    private boolean m_bNoPreReq = false;
    private Vector m_configToolDetails = new Vector();
    private Vector m_configToolsToSuppress = new Vector();
    private Vector m_readmeDetails = new Vector();
    private Vector m_readmesToSuppress = new Vector();
    private String m_bookName;
    private OiisCompJarInfo m_compJarInfo;
    public static final int INTERVIEW_PHASE = 1;
    public static final int INSTALL_PHASE_1 = 2;
    public static final int INSTALL_PHASE_2 = 4;
    public static final int LINK_PHASE = 8;
    public static final int PRE_REQ_CALC = 16;
    public static final int PROD_HOME_CALC = 32;
    public static final int VAR_CALC = 64;
    public static final int VAR_VALIDATION = 96;
    public static final int ALL_PHASES = 255;
    public static final int NONE_PHASES = 0;

    public OiisCompProperties(OiiiCompInstallID id) {
        this.m_cID = id;
        this.init();
    }

    private void init() {
        this.m_languages = new Vector();
        this.m_supLangs = new Vector();
        this.m_resBundle = null;
        this.m_location = null;
        this.m_libDeps = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            this.m_libDeps[i] = new Vector();
        }
        this.m_compJarInfo = null;
    }

    void setCompInstallID(OiiiCompInstallID cid) {
        this.m_cID = cid;
    }

    public void setCompJarInfo(OiisCompJarInfo compJarInfo) {
        this.m_compJarInfo = compJarInfo;
    }

    public OiisCompJarInfo getCompJarInfo() {
        return this.m_compJarInfo;
    }

    public Object clone() {
        OiisCompProperties oClone = null;
        try {
            oClone = (OiisCompProperties)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.m_compJarInfo != null) {
            oClone.m_compJarInfo = (OiisCompJarInfo)this.m_compJarInfo.clone();
        }
        return oClone;
    }

    public void convertLibDepsVector() {
        for (int i = 0; i < 3; ++i) {
            int nSize = this.m_libDeps[i].size();
            Vector<OiisLibDeps> v = new Vector<OiisLibDeps>(nSize);
            int defMap = this.getDefaultPhaseMap(i);
            for (int j = 0; j < nSize; ++j) {
                OiiiLibraryID lid = (OiiiLibraryID)this.m_libDeps[i].elementAt(j);
                OiisLibDeps ldep = new OiisLibDeps(lid, defMap);
                v.addElement(ldep);
            }
            this.m_libDeps[i] = v;
        }
    }

    private int getDefaultPhaseMap(int libType) {
        int defMap = 255;
        switch (libType) {
            case 0: {
                defMap = 6;
                break;
            }
            case 1: {
                defMap = 255;
                break;
            }
            case 2: {
                defMap = 1;
            }
        }
        return defMap;
    }

    public Vector getLibraryDeps(int libType) {
        if (OiiiLibType.validType(libType)) {
            int size = this.m_libDeps[libType].size();
            Vector<OiiiLibraryID> v = new Vector<OiiiLibraryID>(size);
            for (int i = 0; i < size; ++i) {
                OiisLibDeps ldp = (OiisLibDeps)this.m_libDeps[libType].elementAt(i);
                v.addElement(ldp.getLibID());
            }
            return v;
        }
        return new Vector();
    }

    public int getPhaseMap(OiiiLibraryID lid, int libType) {
        int phaseMap = 0;
        if (OiiiLibType.validType(libType)) {
            boolean bFoundEntry = false;
            int nSize = this.m_libDeps[libType].size();
            OiisLibDeps ldep = null;
            for (int i = 0; i < nSize; ++i) {
                ldep = (OiisLibDeps)this.m_libDeps[libType].elementAt(i);
                if (!ldep.getLibID().equals(lid)) continue;
                bFoundEntry = true;
                break;
            }
            if (bFoundEntry) {
                phaseMap = ldep.getDepMap();
            }
        }
        return phaseMap;
    }

    public void setLibraryDeps(Vector libDeps, int libType, int phase) {
        if (OiiiLibType.validType(libType)) {
            if (libDeps == null) {
                libDeps = new Vector();
            }
            Enumeration en = libDeps.elements();
            while (en.hasMoreElements()) {
                OiiiLibraryID lid = (OiiiLibraryID)en.nextElement();
                OiisLibDeps ldep = null;
                boolean bFoundEntry = false;
                int nSize = this.m_libDeps[libType].size();
                for (int i = 0; i < nSize; ++i) {
                    ldep = (OiisLibDeps)this.m_libDeps[libType].elementAt(i);
                    if (!ldep.getLibID().equals(lid)) continue;
                    bFoundEntry = true;
                    break;
                }
                if (bFoundEntry) {
                    ldep.addDep(phase);
                    continue;
                }
                ldep = new OiisLibDeps(lid, phase);
                this.m_libDeps[libType].addElement(ldep);
            }
        }
    }

    public void setLibraryDeps(Vector libDeps, int libType) {
        this.setLibraryDeps(libDeps, libType, 255);
    }

    public void clearLibraryDepMap(OiiiLibraryID lid, int libType) {
        if (OiiiLibType.validType(libType)) {
            boolean bFoundEntry = false;
            int nSize = this.m_libDeps[libType].size();
            OiisLibDeps ldep = null;
            for (int i = 0; i < nSize; ++i) {
                ldep = (OiisLibDeps)this.m_libDeps[libType].elementAt(i);
                if (!ldep.getLibID().equals(lid)) continue;
                bFoundEntry = true;
                break;
            }
            if (bFoundEntry) {
                ldep.setDepMap(0);
            }
        }
    }

    public OiiiCompInstallID getCompInstallID() {
        return this.m_cID;
    }

    public void setLanguages(Vector langs) {
        this.m_languages = langs;
    }

    public void setResBundle(OiixJarResourceBundle resBundle) {
        int i;
        int size;
        Enumeration e;
        this.m_resBundle = resBundle;
        if (this.m_readmeDetails != null) {
            e = this.m_readmeDetails.elements();
            size = this.m_readmeDetails.size();
            for (i = 0; i < size; ++i) {
                OiisReadmeDetails rd = (OiisReadmeDetails)e.nextElement();
                rd.setBundle(resBundle);
            }
        }
        if (this.m_configToolDetails != null) {
            e = this.m_configToolDetails.elements();
            size = this.m_configToolDetails.size();
            for (i = 0; i < size; ++i) {
                OiisConfigToolDetails cd = (OiisConfigToolDetails)e.nextElement();
                cd.setBundle(resBundle);
            }
        }
    }

    public Vector getLanguages() {
        return this.m_languages;
    }

    public void addLanguage(Locale lang) {
        this.m_languages.addElement(lang);
    }

    public void removeLanguage(Locale lang) {
        if (lang != null) {
            this.m_languages.removeElement(lang);
        }
    }

    public void setSupportedLangs(Vector langs) {
        this.m_supLangs = langs;
        if (this.m_defLang == null && !langs.isEmpty()) {
            this.m_defLang = (Locale)this.m_supLangs.firstElement();
        }
    }

    public Vector getSupportedLangs() {
        return this.m_supLangs;
    }

    public void addSupportedLang(Locale lang) {
        this.m_supLangs.addElement(lang);
    }

    public void removeSupportedLang(Locale lang) {
        if (lang != null) {
            this.m_supLangs.removeElement(lang);
        }
    }

    public void setDefaultLang(Locale lang) {
        this.m_defLang = lang;
    }

    public Locale getDefaultLang() {
        return this.m_defLang;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String loc) {
        this.m_location = loc;
    }

    public boolean isNoProdHomeAvailable() {
        return this.m_bNoProdHome;
    }

    public void setNoProdHomeAvailable(boolean bNoProdHome) {
        this.m_bNoProdHome = bNoProdHome;
    }

    public boolean isNoPreReqAvailable() {
        return this.m_bNoPreReq;
    }

    public void setNoPreReqAvailable(boolean bNoPreReq) {
        this.m_bNoPreReq = bNoPreReq;
    }

    public String getDisplayName() {
        return this.m_resBundle.getString("Name");
    }

    public String getDisplayDescription() {
        return this.m_resBundle.getString("Description");
    }

    public Vector[] getLibDeps() {
        return this.m_libDeps;
    }

    public OiixJarResourceBundle getResBundle() {
        return this.m_resBundle;
    }

    public Vector getReadmeDetails() {
        if (this.m_readmeDetails == null) {
            this.m_readmeDetails = new Vector();
        }
        return this.m_readmeDetails;
    }

    public Vector getReadmesToSuppress() {
        if (this.m_readmesToSuppress == null) {
            this.m_readmesToSuppress = new Vector();
        }
        return this.m_readmesToSuppress;
    }

    public void addReadmeDetails(OiisReadmeDetails rdetails) {
        if (this.m_readmeDetails == null) {
            this.m_readmeDetails = new Vector();
        }
        this.m_readmeDetails.addElement(rdetails);
    }

    public void setReadmeDetails(Vector v) {
        this.m_readmeDetails = v;
    }

    public void setReadmesToSuppress(Vector v) {
        this.m_readmesToSuppress = v;
    }

    public void addReadmeToSuppress(OiiiReadmeID rid) {
        if (this.m_readmesToSuppress == null) {
            this.m_readmesToSuppress = new Vector();
        }
        this.m_readmesToSuppress.addElement(rid);
    }

    public void addConfigToolDetails(OiisConfigToolDetails cdetails) {
        if (this.m_configToolDetails == null) {
            this.m_configToolDetails = new Vector();
        }
        this.m_configToolDetails.addElement(cdetails);
    }

    public void setConfigToolDetails(Vector v) {
        this.m_configToolDetails = v;
    }

    public Vector getConfigToolDetails() {
        if (this.m_configToolDetails == null) {
            this.m_configToolDetails = new Vector();
        }
        return this.m_configToolDetails;
    }

    public int getConfigToolCount() {
        return this.getConfigToolDetails().size();
    }

    public Vector getConfigToolsToSuppress() {
        if (this.m_configToolsToSuppress == null) {
            this.m_configToolsToSuppress = new Vector();
        }
        return this.m_configToolsToSuppress;
    }

    public void setConfigToolsToSuppress(Vector v) {
        this.m_configToolsToSuppress = v;
    }

    public void addConfigToolToSuppress(OiiiConfigToolID cid) {
        if (this.m_configToolsToSuppress == null) {
            this.m_configToolsToSuppress = new Vector();
        }
        this.m_configToolsToSuppress.addElement(cid);
    }

    public void setHelpBookName(String bookName) {
        this.m_bookName = bookName;
    }

    public String getHelpBookName() {
        return this.m_bookName;
    }
}

