/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiisCompJarInfo
implements Serializable,
Cloneable {
    private Properties m_classProps;
    private static final String LIST_DELIMITER = ",";
    private static final String KEY_PROPERTIES = "propertyObj";
    private static final String KEY_DEPENDENCIES = "dependencyObj";
    private static final String KEY_FILEMAP = "filemapObj";
    private static final String KEY_CONTEXT = "contextClass";
    private static final String KEY_ACTIONS = "actionsClass";
    private static final String KEY_PATCHDEPS = "patchDepObj";
    private static final String KEY_PATCHSETCONTENTS = "patchSetContents";
    private static final String KEY_RESOURCES = "resourceClass";
    private static final String KEY_HELP = "helpDir";
    private static final String KEY_FILESFILEMAP = "filesFileMap";
    private static final String KEY_CFGTOOLS = "cfgTools";
    private static final String KEY_ACTIONPHASES = "actionPhaseClasses";
    private static final String KEY_IDENTIFIERSXML = "identifiersXML";
    public static final String KEY_DIALOGS = "dialogsClass";
    public static final String KEY_CONDITIONS = "conditionsClass";
    public static final String KEY_VARIABLES = "variablesClass";
    public static final String KEY_CONSTANTS = "constantsClass";
    public static final String KEY_PRODHOME = "prodHomeClass";
    public static final String KEY_PREREQUISITE = "preRequisiteClass";
    public static final String KEY_RESOURCEBUNDLE = "resourceBundle";
    private static final String KEY_FASTCOPYLOGXML = "fastCopyLogXML";
    private static final String PROP_DESC = "Contains information about the component installation components in a JAR file";
    private static String PROD_HOME_CLASS_NAME = "oracle.sysman.oii.oiis.OiisProdHomeVar";
    private static String PRE_REQ_CLASS_NAME = "oracle.sysman.oii.oiis.OiisPreRequisiteVar";

    public OiisCompJarInfo() {
        this.m_classProps = new Properties();
        this.init();
    }

    OiisCompJarInfo(Properties classProps) {
        this.m_classProps = classProps != null ? classProps : new Properties();
        this.init();
    }

    private void init() {
        this.setProdHomeClass(PROD_HOME_CLASS_NAME);
        this.setPreRequisiteClass(PRE_REQ_CLASS_NAME);
        this.setResourceBundleClass("oracle.sysman.oii.oiix.OiixBaseResourceBundle");
    }

    public synchronized void save(OutputStream os) {
        this.m_classProps.save(os, PROP_DESC);
    }

    public Properties getProperties() {
        return this.m_classProps;
    }

    public void setProperties(Properties props) {
        this.m_classProps = props;
    }

    private void setProperty(String prop, String value) {
        this.m_classProps.setProperty(prop, value);
    }

    public void setPropObj(String propObjName) {
        this.setProperty(KEY_PROPERTIES, propObjName);
    }

    public void setDepObj(String depObjName) {
        this.setProperty(KEY_DEPENDENCIES, depObjName);
    }

    public void setResourcesClass(String resourceClassName) {
        this.setProperty(KEY_RESOURCES, resourceClassName);
    }

    public void setResourceBundleClass(String resourceBundleClassName) {
        this.setProperty(KEY_RESOURCEBUNDLE, resourceBundleClassName);
    }

    public void setHelpDir(String helpDirName) {
        this.setProperty(KEY_HELP, helpDirName);
    }

    public void setFileMapObj(String fileMapName) {
        this.setProperty(KEY_FILEMAP, fileMapName);
    }

    public void setProdHomeClass(String prodhomeClassName) {
        this.setProperty(KEY_PRODHOME, prodhomeClassName);
    }

    public void setPreRequisiteClass(String preReqClassName) {
        this.setProperty(KEY_PREREQUISITE, preReqClassName);
    }

    public void setContextClass(String contextClassName) {
        this.setProperty(KEY_CONTEXT, contextClassName);
    }

    public void setActionsClass(String actionsClassName) {
        this.setProperty(KEY_ACTIONS, actionsClassName);
    }

    public void setDialogsClass(String dialogsClassName) {
        this.setProperty(KEY_DIALOGS, dialogsClassName);
    }

    public void setConditionsClass(String conditionsClassName) {
        this.setProperty(KEY_CONDITIONS, conditionsClassName);
    }

    public void setConstantsClass(String constantsClassName) {
        this.setProperty(KEY_CONSTANTS, constantsClassName);
    }

    public void setVariablesClass(String variablesClassName) {
        this.setProperty(KEY_VARIABLES, variablesClassName);
    }

    public void setVariableClass(String varName, String variableClassName) {
        if (varName.equals("PROD_HOME")) {
            this.setProdHomeClass(variableClassName);
            return;
        }
        if (varName.equals("PRE_REQUISITE")) {
            this.setPreRequisiteClass(variableClassName);
            return;
        }
    }

    public void setPatchDepsObj(String patchDepObjName) {
        this.setProperty(KEY_PATCHDEPS, patchDepObjName);
    }

    public void setFilesFilemap(String[] saFiles) {
        if (saFiles != null) {
            this.setProperty(KEY_FILESFILEMAP, OiixFunctionOps.implodeList(saFiles, LIST_DELIMITER));
        }
    }

    public void setActionPhaseClasses(String[] saFiles) {
        if (saFiles != null) {
            this.setProperty(KEY_ACTIONPHASES, OiixFunctionOps.implodeList(saFiles, LIST_DELIMITER));
        }
    }

    public void setConfigTools(String[] saFiles) {
        if (saFiles != null) {
            this.setProperty(KEY_CFGTOOLS, OiixFunctionOps.implodeList(saFiles, LIST_DELIMITER));
        }
    }

    public void setPatchSetContentsObj(String pSetContents) {
        this.setProperty(KEY_PATCHSETCONTENTS, pSetContents);
    }

    public String getFastCopyLogXML() {
        return this.m_classProps.getProperty(KEY_FASTCOPYLOGXML);
    }

    public void setFastCopyLogXML(String sFCLXML) {
        this.setProperty(KEY_FASTCOPYLOGXML, sFCLXML);
    }

    public void setIdentifiersXML(String sIDXML) {
        this.setProperty(KEY_IDENTIFIERSXML, sIDXML);
    }

    public synchronized void load(InputStream is) throws IOException {
        try {
            this.m_classProps.load(is);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e.getMessage() != null) {
                throw new IOException(e.getMessage());
            }
            e.printStackTrace(System.err);
        }
    }

    public String getPropObj() {
        return this.m_classProps.getProperty(KEY_PROPERTIES);
    }

    public String getDepObj() {
        return this.m_classProps.getProperty(KEY_DEPENDENCIES);
    }

    public String getResourceBundleClass() {
        return this.m_classProps.getProperty(KEY_RESOURCEBUNDLE);
    }

    public String getResourcesClass() {
        return this.m_classProps.getProperty(KEY_RESOURCES);
    }

    public String getHelpDir() {
        String helpDir = this.m_classProps.getProperty(KEY_HELP);
        helpDir = OiixPathOps.directorify(helpDir);
        return helpDir;
    }

    public String getFileMapObj() {
        return this.m_classProps.getProperty(KEY_FILEMAP);
    }

    public String getContextClass() {
        return this.m_classProps.getProperty(KEY_CONTEXT);
    }

    public String getProdHomeClass() {
        return this.m_classProps.getProperty(KEY_PRODHOME);
    }

    public String getPreRequisiteClass() {
        return this.m_classProps.getProperty(KEY_PREREQUISITE);
    }

    public String getActionsClass() {
        return this.m_classProps.getProperty(KEY_ACTIONS);
    }

    public String getDialogsClass() {
        return this.m_classProps.getProperty(KEY_DIALOGS);
    }

    public String getConditionsClass() {
        return this.m_classProps.getProperty(KEY_CONDITIONS);
    }

    public String getConstantsClass() {
        return this.m_classProps.getProperty(KEY_CONSTANTS);
    }

    public String getIdentifiersXML() {
        return this.m_classProps.getProperty(KEY_IDENTIFIERSXML);
    }

    public String getVariablesClass() {
        return this.m_classProps.getProperty(KEY_VARIABLES);
    }

    public String getPatchDepsObj() {
        return this.m_classProps.getProperty(KEY_PATCHDEPS);
    }

    public String getPatchSetContents() {
        return this.m_classProps.getProperty(KEY_PATCHSETCONTENTS);
    }

    public String[] getFilesFilemap() {
        String sFiles = this.m_classProps.getProperty(KEY_FILESFILEMAP);
        if (sFiles != null) {
            return OiixFunctionOps.explodeString(sFiles, LIST_DELIMITER);
        }
        return null;
    }

    public String[] getActionPhaseClasses() {
        String sFiles = this.m_classProps.getProperty(KEY_ACTIONPHASES);
        if (sFiles != null) {
            return OiixFunctionOps.explodeString(sFiles, LIST_DELIMITER);
        }
        return null;
    }

    public String[] getConfigTools() {
        String sFiles = this.m_classProps.getProperty(KEY_CFGTOOLS);
        if (sFiles != null) {
            return OiixFunctionOps.explodeString(sFiles, LIST_DELIMITER);
        }
        return null;
    }

    public void disposeForInstall() {
        String[] asKeys = new String[]{KEY_FILESFILEMAP, KEY_ACTIONPHASES, KEY_CFGTOOLS};
        for (int i = 0; i < asKeys.length; ++i) {
            if (!this.m_classProps.containsKey(asKeys[i])) continue;
            this.m_classProps.remove(asKeys[i]);
        }
    }

    public Object clone() {
        OiisCompJarInfo oClone = null;
        try {
            oClone = (OiisCompJarInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.m_classProps != null) {
            oClone.m_classProps = (Properties)this.m_classProps.clone();
        }
        return oClone;
    }
}

