/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisConstantException;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisPlatformSpecificConstant;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oix.oixs.OixsDefaultHandler;
import oracle.sysman.oix.oixs.OixsElementHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class OiisCompContextHandler
extends OixsDefaultHandler {
    private OiisCompContext m_oCompContext;
    private OiisCompConstants m_oCompConstants;
    private OiisVarHandler m_oVarHandler;
    private OiisConstHandler m_oConstHandler;

    @Override
    public void startDocument() throws SAXException {
    }

    public OiisCompContext getCompContext() {
        return this.m_oCompContext;
    }

    @Override
    protected OixsElementHandler createElementHandlers() {
        OixsElementHandler handlerCompContext = new OixsElementHandler("COMP_CONTEXT");
        OiisVarListHandler handlerVarList = new OiisVarListHandler("VAR_LIST");
        this.m_oVarHandler = new OiisVarHandler("VAR");
        handlerVarList.addChildHandler("VAR", this.m_oVarHandler);
        OiisConstListHandler handlerConstList = new OiisConstListHandler("CONST_LIST");
        this.m_oConstHandler = new OiisConstHandler("CONST");
        handlerConstList.addChildHandler("CONST", this.m_oConstHandler);
        handlerCompContext.addChildHandler("VAR_LIST", handlerVarList);
        handlerCompContext.addChildHandler("CONST_LIST", handlerConstList);
        return handlerCompContext;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private class OiisConstHandler
    extends OixsElementHandler {
        public OiisConstHandler(String sName) {
            super(sName);
        }

        @Override
        public void onStart(String sTagName, AttributeList atts) {
            OiisGenericConstant oConst = null;
            String sName = atts.getValue("NAME");
            String sTransFlag = atts.getValue("TRANS");
            boolean isTranslatable = false;
            if (sTransFlag.equalsIgnoreCase("T")) {
                isTranslatable = true;
            }
            String sType = atts.getValue("TYPE");
            int nType = OiisDataTypes.getTypeID(sType);
            String sValue = atts.getValue("VAL");
            Object oValue = OiisDataTypes.getValueObject(sValue, sType);
            String sPlatSpFlag = atts.getValue("PLAT_SP");
            try {
                if (sPlatSpFlag.equalsIgnoreCase("T")) {
                    oConst = new OiisPlatformSpecificConstant(sName, nType);
                    int nCurPlatID = OiixPlatform.getCurrentPlatform();
                    if (isTranslatable) {
                        ((OiisPlatformSpecificConstant)oConst).setID(nCurPlatID, (String)oValue);
                    } else {
                        ((OiisPlatformSpecificConstant)oConst).setValue(nCurPlatID, oValue);
                    }
                } else {
                    oConst = new OiisGenericConstant(sName, nType);
                    if (isTranslatable) {
                        oConst.setID((String)oValue);
                    } else {
                        oConst.setValue(oValue);
                    }
                }
            }
            catch (OiisConstantException ce) {
                ce.printStackTrace();
            }
            OiisCompContextHandler.this.m_oCompConstants.addConstant(oConst);
        }
    }

    private class OiisVarHandler
    extends OixsElementHandler {
        public OiisVarHandler(String sName) {
            super(sName);
        }

        @Override
        public void onStart(String sTagName, AttributeList atts) {
            if (atts == null) {
                return;
            }
            String sName = atts.getValue("NAME");
            String sResourceId = atts.getValue("DESC_RES_ID");
            String sSecureFlag = atts.getValue("SECURE");
            boolean bSecure = false;
            if (sSecureFlag != null && sSecureFlag.equalsIgnoreCase("T")) {
                bSecure = true;
            }
            String sAdvice = atts.getValue("ADV");
            boolean bAdvice = true;
            if (sAdvice != null && sAdvice.equalsIgnoreCase("F")) {
                bAdvice = false;
            }
            String sClonable = atts.getValue("CLONABLE");
            boolean bClonable = true;
            if (sClonable == null || sClonable.equalsIgnoreCase("F")) {
                bClonable = false;
            }
            String valueTypeString = atts.getValue("USER_INPUT");
            int valueType = 3;
            if (valueTypeString != null) {
                valueType = OiisVariable.getValueTypeInt(valueTypeString);
            }
            if (sName.equalsIgnoreCase("PROD_HOME")) {
                OiisProdHomeVar oVar = new OiisProdHomeVar();
                oVar.setOwner(OiisCompContextHandler.this.m_oCompContext);
                oVar.setDescriptionID(sResourceId);
                oVar.setSecure(bSecure);
                this.setValueAndType(atts, oVar);
                if (oVar.isSecure()) {
                    oVar.setAdvice(false);
                } else {
                    oVar.setAdvice(bAdvice);
                }
                oVar.setValueInputType(valueType);
                OiisCompContextHandler.this.m_oCompContext.setProdHome(oVar);
            } else {
                OiisVariable oVar = new OiisVariable(OiisCompContextHandler.this.m_oCompContext, sName);
                oVar.setDescriptionID(sResourceId);
                oVar.setSecure(bSecure);
                this.setValueAndType(atts, oVar);
                if (oVar.isSecure()) {
                    oVar.setAdvice(false);
                } else {
                    oVar.setAdvice(bAdvice);
                }
                oVar.setComputeAtClone(bClonable);
                oVar.setValueInputType(valueType);
                OiisCompContextHandler.this.m_oCompContext.addVariable(oVar);
            }
        }

        private void setValueAndType(AttributeList atts, OiisVariable oVar) {
            String sType = atts.getValue("TYPE");
            String sValue = atts.getValue("VAL");
            int nType = OiisDataTypes.getTypeID(sType);
            oVar.setType(nType);
            if (!oVar.isSecure()) {
                Object oValue = OiisDataTypes.getValueObject(sValue, sType);
                oVar.setValueWithoutValidation(oValue);
            }
        }
    }

    private class OiisConstListHandler
    extends OixsElementHandler {
        public OiisConstListHandler(String sName) {
            super(sName);
        }

        @Override
        public void onStart(String sTagName, AttributeList atts) {
            int nSize = 0;
            String sSize = atts.getValue("SIZE");
            try {
                if (sSize != null && !sSize.trim().equals("")) {
                    nSize = Integer.parseInt(sSize);
                }
            }
            catch (NumberFormatException ne) {
                nSize = 0;
            }
            OiisCompContextHandler.this.m_oCompConstants = new OiisCompConstants(nSize);
        }

        @Override
        public void onEnd(String sTagName) {
            OiisCompContextHandler.this.m_oCompContext.setConstants(OiisCompContextHandler.this.m_oCompConstants);
        }
    }

    private class OiisVarListHandler
    extends OixsElementHandler {
        public OiisVarListHandler(String sName) {
            super(sName);
        }

        @Override
        public void onStart(String sTagName, AttributeList atts) {
            int size = Integer.parseInt(atts.getValue("SIZE"));
            OiisCompContextHandler.this.m_oCompContext = new OiisCompContext(size);
        }
    }
}

