/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicCloneSession;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicLWSessionContext;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilExceptionContinue;
import oracle.sysman.oii.oiil.OiilExceptionDlg;
import oracle.sysman.oii.oiil.OiilExceptionFailure;
import oracle.sysman.oii.oiil.OiilExceptionHandler;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiioz.OiiozResponseFileManager;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompContextHandler;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisComputeAtCloneVars;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisConstantException;
import oracle.sysman.oii.oiis.OiisDataTypes;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDialogLoadingException;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisPatchDepObj;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisPlatformSpecificConstant;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.sysman.oii.oiis.OiisPreRequisiteVar;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisQueryLibLoader;
import oracle.sysman.oii.oiis.OiisQueryLoadingException;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixRetryException;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiisCompContext
extends OiicLWSessionContext
implements OiifbWizOperation,
OiisVariableOwner {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    protected Vector m_wceArray;
    private transient OiifbCondIterator m_iter;
    private OiiiCompInstallID m_compID;
    protected Vector m_varOrderTable;
    private Hashtable m_roVars;
    protected OiicPullSession m_pullSession;
    private OiisVariableOwner m_parContext = null;
    private Vector m_responseFileList;
    private OiiozResponseFileManager m_responseFile;
    private OiixProgressListener m_progressListener;
    private boolean m_bContextFailed;
    private OiisCompConstants m_compConst;
    private int m_iActionsIP1 = 0;
    private int m_iActionsIP2 = 0;
    private int m_iActionsLKP = 0;
    private transient String m_compInsJarLoc;
    public static final String PROD_HOME_VARNAME = "PROD_HOME";
    public static final String PRE_REQUISITE_VARNAME = "PRE_REQUISITE";
    public static final String DEPENDEES_VARNAME = "DEPENDENCY_LIST";
    public static final String OPTCONFIGTOOLS_VARNAME = "OPTIONAL_CONFIG_TOOLS";
    private static final String[] s_roVarList = new String[]{"PROD_HOME", "PRE_REQUISITE", "DEPENDENCY_LIST", "OPTIONAL_CONFIG_TOOLS"};
    private static final int[] s_roVarTypes = new int[]{OiisVariable.STRING, OiisVariable.BOOL, OiisVariable.STRINGLIST, OiisVariable.STRINGLIST};
    private static final boolean[] s_roVarPublic = new boolean[]{true, false, true, true};
    private static final String UNCAUGHT_RUNTIME_EX_NAME = "UNCAUGHT_RUNTIME";

    public OiisCompContext() {
        this(10, 10, 10);
    }

    public OiisCompContext(int nVarSize) {
        this(nVarSize, 10, 10);
    }

    public OiisCompContext(int nVarSize, int nChainElems, int nConstSize) {
        super(nVarSize);
        this.m_varOrderTable = new Vector(nVarSize);
        this.m_roVars = new Hashtable();
        for (int i = 0; i < s_roVarList.length; ++i) {
            OiisVariable oVar = new OiisVariable(this, s_roVarList[i]);
            oVar.setType(s_roVarTypes[i]);
            oVar.setExported(s_roVarPublic[i]);
            this.m_roVars.put(s_roVarList[i], oVar);
        }
        this.m_wceArray = new Vector(nChainElems);
        this.m_compConst = new OiisCompConstants(nConstSize);
    }

    @Override
    public Hashtable getCommandLineArgsTable() {
        return this.m_parContext.getCommandLineArgsTable();
    }

    public void setPullSession(OiicPullSession pSession) {
        this.m_pullSession = pSession;
    }

    public void setIP1FlowCount(int sz) {
        this.m_iActionsIP1 = sz;
    }

    public int getIP1FlowCount() {
        return this.m_iActionsIP1;
    }

    public void setIP2FlowCount(int sz) {
        this.m_iActionsIP2 = sz;
    }

    public int getIP2FlowCount() {
        return this.m_iActionsIP2;
    }

    public void setLKPFlowCount(int sz) {
        this.m_iActionsLKP = sz;
    }

    public int getLKPFlowCount() {
        int curPlatGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        return curPlatGroup == -1 ? this.m_iActionsLKP : 0;
    }

    public int getConstantsCount() {
        return this.m_compConst != null ? this.m_compConst.size() : 0;
    }

    public void setCompID(OiiiCompInstallID compID) {
        this.m_compID = compID;
    }

    public OiisVariable createVariable(OiisCompContext oCompContext, String sName, String sDescID, int iType, boolean bExport, boolean bSecure, String sSerLoc, OiixJarClassLoader oClassLoader, boolean bCalcMethodSet, boolean bValidationMethodSet) {
        OiisVariable v = new OiisVariable(oCompContext, sName);
        v.setType(iType);
        v.setExported(bExport);
        v.setSecure(bSecure);
        if (sSerLoc != null) {
            v.setChildVarElems(sSerLoc, oClassLoader);
        }
        if (sDescID != null && sDescID.trim().length() != 0) {
            v.setDescriptionID(sDescID);
        }
        v.setCalcMethodPresent(bCalcMethodSet);
        v.setValidationMethodPresent(bValidationMethodSet);
        return v;
    }

    public OiisVariable createVariable(OiisCompContext oCompContext, String sName, String sDescID, int iType, boolean bExport, boolean bSecure, boolean bCalcMethodSet, boolean bValidationMethodSet) {
        return this.createVariable(oCompContext, sName, sDescID, iType, bExport, bSecure, null, null, bCalcMethodSet, bValidationMethodSet);
    }

    public OiisAdvisedValue getCalculatedValue(String varName) throws OiifbCancelException, OiisVarSettingException, OiixRetryException {
        return new OiisAdvisedValue(this.getCalculatedValueObject(varName), false);
    }

    public Object getCalculatedValueObject(String varName) throws OiifbCancelException, OiisVarSettingException, OiixRetryException {
        return null;
    }

    public void setConstants(OiisCompConstants consts) {
        this.m_compConst = consts;
    }

    @Override
    public OiisCompConstants getCompConstants() {
        return this.m_compConst;
    }

    @Override
    public Enumeration getConstants() {
        if (this.m_compConst != null) {
            return this.m_compConst.getAllConstants();
        }
        return new Vector().elements();
    }

    @Override
    public void dispose() {
        this.m_iter.dispose();
    }

    public void disposeVars() {
        this.m_varOrderTable.removeAllElements();
        this.m_varTable.clear();
        this.m_roVars.clear();
        if (this.m_compConst != null) {
            this.m_compConst.dispose();
        }
    }

    public void disposeWizardElems() {
        if (this.m_wceArray != null) {
            this.m_wceArray.removeAllElements();
        }
    }

    @Override
    public void initialize() {
        String tempStr = OiixResourceBundle.getString("S_LOG_ENTERING_COMP") + this.m_compID.getName() + OiixResourceBundle.getString("S_LOG_INSTALLATION");
        OiiolTextLogger.appendText(tempStr, OiiolTextLogger.LOG_BASIC);
    }

    public void setResourceBundle(OiixJarResourceBundle rb) {
        int nVars = this.m_varOrderTable.size();
        for (int i = 0; i < nVars; ++i) {
            OiisVariable oVar = (OiisVariable)this.m_varOrderTable.elementAt(i);
            oVar.setResourceBundle(rb);
        }
    }

    public void setProdHome(OiisProdHomeVar oProdhome) {
        this.m_roVars.put(PROD_HOME_VARNAME, oProdhome);
    }

    public void setProdHome(String pHome) throws OiisVarSettingException {
        OiisVariable pHomeVar = (OiisVariable)this.m_roVars.get(PROD_HOME_VARNAME);
        try {
            pHomeVar.setValue(pHome, true);
        }
        catch (OiifbCancelException ce) {
            ce.printStackTrace();
        }
    }

    public void setPreRequisite(OiisPreRequisiteVar oPreReq) {
        this.m_roVars.put(PRE_REQUISITE_VARNAME, oPreReq);
    }

    public String getProdHome() {
        OiisVariable pHomeVar = (OiisVariable)this.m_roVars.get(PROD_HOME_VARNAME);
        return (String)pHomeVar.getValue();
    }

    public boolean isPreRequisiteFine() {
        OiisVariable pVar = (OiisVariable)this.m_roVars.get(PRE_REQUISITE_VARNAME);
        Boolean bVal = (Boolean)pVar.getValue();
        if (bVal == null) {
            return true;
        }
        return bVal;
    }

    public String[] getOptionalConfigTools() {
        OiisVariable pVar = (OiisVariable)this.m_roVars.get(OPTCONFIGTOOLS_VARNAME);
        try {
            pVar.setVariable(this.getCompInstallID());
            return (String[])pVar.getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public OiicPullSession getSession() {
        return this.m_pullSession;
    }

    public void setParContext(OiisVariableOwner parContext) {
        this.m_parContext = parContext;
    }

    public OiisVariableOwner getParContext() {
        return this.m_parContext;
    }

    public void init(OiiiCompInstallID cid, OiicPullSession pullSession) {
        if (pullSession != null) {
            this.m_pullSession = pullSession;
            this.m_compID = cid;
            this.m_wceArray.removeAllElements();
            this.initChainElements();
            this.m_iter = new OiifbCondIterator(this.m_wceArray, false);
        }
    }

    public void initChainElements() {
    }

    public Vector getWizChainElems() {
        return this.m_wceArray;
    }

    @Override
    public final int doOperation(boolean isBack) throws OiifbEndIterateException {
        int retBack;
        block27: {
            if (this.m_bContextFailed) {
                return isBack ? 1 : 0;
            }
            OiicSessionPlan sessionPlan = this.m_pullSession.getSessionPlan();
            try {
                Enumeration e;
                if (!isBack) {
                    if (this.m_progressListener != null) {
                        String sName = this.m_pullSession.getStgCompDisplayName(this.getCompInstallID());
                        Object[] obj = new String[]{sName};
                        String sMsg = MessageFormat.format(OiixResourceBundle.getString("S_INTERVIEW_PROG_MSG"), obj);
                        this.m_progressListener.setStatus(sMsg);
                        this.m_progressListener.addBytes(1);
                    }
                    OiisCompContext installInvContext = null;
                    boolean useOldAlgorithm = false;
                    if (this.m_pullSession.isCloneMode()) {
                        this.updateComputeAtCloneVars(true);
                        this.updateComputeAtCloneVars(false);
                        OiiiInstallInventory instInv = OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory();
                        int ohIndex = this.m_pullSession.getHomeIndex(this.m_compID);
                        OiiiInstallCompInvEntry oInstCompInvEntry = instInv.getInstallCompInvEntry(this.m_compID, ohIndex);
                        OiisCompInstallation compInstall = this.m_pullSession.getCompInstall(this.m_compID);
                        OiiiStageInventory stageInv = compInstall.getContext().getSession().getSourceAccess().getStageInventory();
                        OiiiStageCompInvEntry oEntry = stageInv.getStageCompInvEntry(this.m_compID, new Vector());
                        if (new OiiiVersion("2.3").laterThan(oEntry.getStageVersion())) {
                            useOldAlgorithm = true;
                        }
                        if (oInstCompInvEntry != null) {
                            installInvContext = OiisCompContext.createContextFromInstallInv(oInstCompInvEntry, ohIndex);
                            if (null == installInvContext) {
                                String sMsg = MessageFormat.format(OiixResourceBundle.getString("S_NO_INSTALL_CONTEXT"), this.getCompInstallID().toString());
                                throw new OiifbEndIterateException(sMsg);
                            }
                            OiisVariable varSelLangs = this.getVariable("SELECTED_LANGUAGES");
                            try {
                                Vector vLangs = oInstCompInvEntry.getLanguages();
                                varSelLangs.setValue(OiixLanguage.getStringArray(vLangs));
                            }
                            catch (OiisVarSettingException vse) {
                                vse.printStackTrace();
                            }
                        }
                    }
                    Enumeration e2 = this.getAllVariables();
                    while (e2.hasMoreElements()) {
                        OiisVariable v = (OiisVariable)e2.nextElement();
                        try {
                            v.setVariable(this.m_compID, installInvContext, useOldAlgorithm);
                        }
                        catch (OiisVarSettingException vse) {
                            String sName = this.m_pullSession.getStgCompDisplayName(this.getCompInstallID());
                            Object[] msgArr = new String[]{vse.getMessage(), sName};
                            String sMsg = MessageFormat.format(OiixResourceBundle.getString("S_INSTALL_CANT_CONTINUE"), msgArr);
                            int button_ops = 0;
                            button_ops |= 1;
                            OiicInstallCancelHandler errDlg = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(button_ops |= 2, sMsg, 1);
                            int userInput = errDlg.doCancelOperation();
                            switch (userInput) {
                                case 1: {
                                    throw new OiifbCancelException(vse.getMessage(), true);
                                }
                                case 2: {
                                    throw new OiifbCancelException(vse.getMessage(), false);
                                }
                            }
                        }
                    }
                    installInvContext = null;
                } else {
                    if (this.m_progressListener != null) {
                        this.m_progressListener.removeBytes(1);
                    }
                    e = this.getAllVariables();
                    while (e.hasMoreElements()) {
                        OiisVariable v = (OiisVariable)e.nextElement();
                        v.unsetChildVariables();
                    }
                }
                try {
                    retBack = this.m_iter.iterate(isBack);
                }
                catch (OiifbEndIterateException eie) {
                    Exception ex = eie.getException();
                    if (ex != null && ex instanceof OiifbCancelException) {
                        throw (OiifbCancelException)ex;
                    }
                    throw eie;
                }
                if (retBack != 1) {
                    e = this.getAllVariables();
                    while (e.hasMoreElements()) {
                        OiisVariable v = (OiisVariable)e.nextElement();
                        v.setChildVariables();
                    }
                }
                int compPhase = 0;
                compPhase = retBack == 0 ? 10 : 5;
                sessionPlan.setAdditionPhase(this.m_compID, compPhase);
            }
            catch (OiifbCancelException ce) {
                if (ce.isCancelSession()) {
                    throw new OiifbEndIterateException(ce);
                }
                retBack = 0;
                this.m_bContextFailed = true;
                sessionPlan.setAdditionPhase(this.m_compID, 5);
                Vector v = sessionPlan.getSuccessfulAdditions(10);
                if (v.size() != 0) break block27;
                throw new OiifbEndIterateException(new OiifbCancelException(ce.getMessage(), true));
            }
        }
        return retBack;
    }

    private void updateComputeAtCloneVars(boolean bComputeAtClone) {
        OiicCloneSession oCloneSession = (OiicCloneSession)this.m_pullSession;
        OiisComputeAtCloneVars ccv = oCloneSession.getComputeAtCloneVarsList();
        Iterator it = ccv.getComputeAtCloneVariables(this.m_compID, bComputeAtClone);
        if (it != null) {
            while (it.hasNext()) {
                String sVar = (String)it.next();
                OiisVariable oVar = this.getVariable(sVar);
                if (oVar == null) continue;
                oVar.setComputeAtClone(bComputeAtClone);
            }
        }
    }

    @Override
    public OiiozResponseFileManager getResponseFileManager() {
        if (this.m_parContext != null) {
            this.setResponseFileManager(this.m_parContext.getResponseFileManager());
        }
        return this.m_responseFile;
    }

    @Override
    public void setResponseFileManager(OiiozResponseFileManager rf) {
        this.m_responseFile = rf;
    }

    @Override
    public final int hashCode() {
        return this.m_compID.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj != null && obj instanceof OiisCompContext) {
            return ((OiisCompContext)obj).getCompInstallID().equals(this.m_compID);
        }
        return false;
    }

    public OiiiCompInstallID getCompInstallID() {
        return this.m_compID;
    }

    @Override
    public OiisVariable getVariable(String name) {
        OiisVariable retVar = null;
        retVar = OiisCompContext.isROVarName(name = name.toUpperCase()) ? (OiisVariable)this.m_roVars.get(name) : (OiisVariable)this.m_varTable.get(name);
        if (retVar == null && this.m_parContext != null) {
            retVar = this.m_parContext.getVariable(name);
        }
        return retVar;
    }

    public Vector getInstantiableVariables() {
        Vector instVars = new Vector();
        Enumeration rwVars = this.getAllVariables();
        while (rwVars.hasMoreElements()) {
            instVars.addElement(rwVars.nextElement());
        }
        Enumeration roVars = this.getROVariables();
        while (roVars.hasMoreElements()) {
            instVars.addElement(roVars.nextElement());
        }
        if (this.m_parContext != null) {
            Enumeration sesVars = this.m_parContext.getAllVariables();
            while (sesVars.hasMoreElements()) {
                instVars.addElement(sesVars.nextElement());
            }
        }
        return instVars;
    }

    @Override
    public void addVariable(OiisVariable v) {
        String varName = v.getName().toUpperCase();
        OiisVariable prevVal = this.m_varTable.put(varName, v);
        if (prevVal != null) {
            this.m_varOrderTable.removeElement(prevVal);
        }
        this.m_varOrderTable.addElement(v);
    }

    public void addConstant(OiisGenericConstant oConst) {
        this.m_compConst.addConstant(oConst);
    }

    public void writeContext(String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        Vector varVect = this.getAllVarsVect();
        int numVars = varVect.size();
        oos.writeInt(numVars);
        for (int i = 0; i < numVars; ++i) {
            OiisVariable var = (OiisVariable)varVect.elementAt(i);
            oos.writeUTF(var.getName().toUpperCase());
            oos.writeBoolean(var.getAdvice());
            oos.writeObject(var.getValue());
        }
        Enumeration e = this.getConstants();
        int nConst = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++nConst;
        }
        oos.writeInt(nConst);
        e = this.getConstants();
        for (int i = 0; i < nConst; ++i) {
            OiisGenericConstant oConst = (OiisGenericConstant)e.nextElement();
            oos.writeUTF(oConst.getName().toUpperCase());
            oos.writeInt(oConst.getType());
            oos.writeObject(oConst.getValue());
        }
        oos.flush();
        oos.close();
        fos.close();
    }

    public void writeXMLContext(String sXmlContextFile) throws IOException {
        File oXmlContextDir = new File(new File(sXmlContextFile).getParent());
        OiixFileOps.mkdirs(oXmlContextDir);
        FileWriter fileWriter = new FileWriter(sXmlContextFile);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        printWriter.println(OixsXMLOps.createXMLDirective(true));
        printWriter.println(OixsXMLOps.getStandardHeader());
        XMLElement oXMLCompContext = this.buildDOMTree();
        oXMLCompContext.print(printWriter);
        printWriter.close();
        bufferedWriter.close();
        fileWriter.close();
    }

    private XMLElement buildDOMTree() {
        XMLElement elemCompContext = new XMLElement("COMP_CONTEXT");
        XMLElement elemVarList = new XMLElement("VAR_LIST");
        elemVarList.setAttribute("SIZE", new Integer(this.m_varOrderTable.size()).toString());
        Vector vCompVariables = this.getAllVarsVect();
        vCompVariables.addElement(this.getVariable(PROD_HOME_VARNAME));
        if (OiicPullSession.isLangAddonMode()) {
            vCompVariables.addElement(this.getVariable("SELECTED_LANGUAGES"));
        }
        Enumeration enVars = vCompVariables.elements();
        while (enVars.hasMoreElements()) {
            XMLElement elemVar = new XMLElement("VAR");
            OiisVariable oVar = (OiisVariable)enVars.nextElement();
            elemVar.setAttribute("NAME", oVar.getName());
            String sType = OiisVariable.getTypeString(oVar.getType());
            elemVar.setAttribute("TYPE", sType);
            elemVar.setAttribute("DESC_RES_ID", oVar.getDescriptionID());
            if (!oVar.isSecure()) {
                elemVar.setAttribute("SECURE", "F");
                elemVar.setAttribute("VAL", OiisDataTypes.getStringValue(oVar.getValue(), sType));
                elemVar.setAttribute("ADV", "F");
            } else {
                elemVar.setAttribute("SECURE", "T");
                if (oVar.getAdvice()) {
                    elemVar.setAttribute("ADV", "T");
                } else {
                    elemVar.setAttribute("ADV", "F");
                }
            }
            if (oVar.isComputeAtClone()) {
                elemVar.setAttribute("CLONABLE", "T");
            } else {
                elemVar.setAttribute("CLONABLE", "F");
            }
            elemVar.setAttribute("USER_INPUT", oVar.getValueTypeString());
            elemVarList.appendChild((Node)elemVar);
        }
        elemCompContext.appendChild((Node)elemVarList);
        XMLElement elemConstList = new XMLElement("CONST_LIST");
        elemConstList.setAttribute("SIZE", new Integer(this.getCompConstants().size()).toString());
        Enumeration enConst = this.getConstants();
        while (enConst.hasMoreElements()) {
            XMLElement elemConst = new XMLElement("CONST");
            OiisGenericConstant oConstant = (OiisGenericConstant)enConst.nextElement();
            elemConst.setAttribute("NAME", oConstant.getName());
            if (oConstant instanceof OiisPlatformSpecificConstant) {
                oConstant = (OiisPlatformSpecificConstant)oConstant;
                elemConst.setAttribute("PLAT_SP", "T");
            } else {
                elemConst.setAttribute("PLAT_SP", "F");
            }
            String sType = OiisVariable.getTypeString(oConstant.getType());
            elemConst.setAttribute("TYPE", sType);
            if (oConstant.isTranslatable()) {
                elemConst.setAttribute("TRANS", "T");
                elemConst.setAttribute("VAL", oConstant.getID());
            } else {
                elemConst.setAttribute("TRANS", "F");
                elemConst.setAttribute("VAL", OiisDataTypes.getStringValue(oConstant.getValue(), sType));
            }
            elemConstList.appendChild((Node)elemConst);
        }
        elemCompContext.appendChild((Node)elemConstList);
        return elemCompContext;
    }

    protected Vector getAllVarsVect() {
        return this.m_varOrderTable;
    }

    public static OiisCompContext createContextFromInstallInv(OiiiInstallCompInvEntry oInstComp, int ohIndex) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sXMLContextPath = iac.getXMLContextLoc(ohIndex, oInstComp.getLocationInXMLInventory());
        OiisCompContext oCompContext = OiisCompContext.readXMLContext(sXMLContextPath);
        OiixJarResourceBundle oResourceBundle = new OiixJarResourceBundle(iac.getResourceBundle(oInstComp));
        if (oCompContext != null) {
            oCompContext.setResourceBundle(oResourceBundle);
            oCompContext.getCompConstants().setResourceBundle(oResourceBundle, true);
            OiisCompContext.addSessionVariablesToCompContext(oCompContext, oInstComp, ohIndex);
        }
        return oCompContext;
    }

    private static void addSessionVariablesToCompContext(OiisCompContext oContext, OiiiInstallCompInvEntry icie, int nOHIndex) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiisVariable oVar = new OiisVariable(oContext, "INVENTORY_LOCATION");
        oVar.setValueWithoutValidation(iac.getAreaRoot());
        oContext.addVariable(oVar);
        int nHomeType = icie.getCompInstallID().getHomeType();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        OiiiOracleHomeInfo oInfo = instInv.getHomeInfo(nOHIndex);
        switch (nHomeType) {
            case 1: 
            case 2: {
                String sLocation = oInfo.getLocation();
                String sHomeName = oInfo.getName();
                String sVarName = "ORACLE_HOME";
                oVar = new OiisVariable(oContext, sVarName);
                oVar.setValueWithoutValidation(sLocation);
                oContext.addVariable(oVar);
                sVarName = "ORACLE_HOME_NAME";
                oVar = new OiisVariable(oContext, sVarName);
                oVar.setValueWithoutValidation(sHomeName);
                oContext.addVariable(oVar);
                int curPlatGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
                if (curPlatGroup != -3) break;
                try {
                    sVarName = "ORACLE_HOME_FOLDER";
                    oVar = new OiisVariable(oContext, sVarName);
                    String sValue = OiipgOracleHomes.getHomeGroupName(sHomeName);
                    oVar.setValueWithoutValidation(sValue);
                    oContext.addVariable(oVar);
                    sVarName = "ORACLE_HOME_SERVICE";
                    oVar = new OiisVariable(oContext, sVarName);
                    oVar.setValueWithoutValidation(sHomeName);
                    oContext.addVariable(oVar);
                    sVarName = "ORACLE_HOME_KEY";
                    oVar = new OiisVariable(oContext, sVarName);
                    sValue = OiipgOracleHomes.getHomeKey(sHomeName);
                    oVar.setValueWithoutValidation(sValue);
                    oContext.addVariable(oVar);
                }
                catch (OiilNativeException ne) {
                    ne.printStackTrace();
                }
                break;
            }
            case 3: {
                String sAppltopLocation = oInfo.getLocation();
                String sAppltopName = oInfo.getName();
                String sVarName = "APPLTOP";
                oVar = new OiisVariable(oContext, sVarName);
                oVar.setValueWithoutValidation(sAppltopLocation);
                oContext.addVariable(oVar);
                sVarName = "APPLTOP_NAME";
                oVar = new OiisVariable(oContext, sVarName);
                oVar.setValueWithoutValidation(sAppltopName);
                oContext.addVariable(oVar);
            }
        }
    }

    public void readContext(String fileName) throws IOException, OiisVarSettingException, ClassNotFoundException {
        ObjectInputStream ois;
        FileInputStream fis;
        block9: {
            fis = new FileInputStream(fileName);
            ois = new ObjectInputStream(fis);
            int numVars = ois.readInt();
            for (int i = 0; i < numVars; ++i) {
                String varName = ois.readUTF();
                boolean advice = ois.readBoolean();
                Object val = ois.readObject();
                OiisVariable oVar = new OiisVariable(this, varName);
                try {
                    oVar.setValue(new OiisAdvisedValue(val, advice), true);
                }
                catch (OiifbCancelException ce) {
                    ce.printStackTrace();
                }
                this.addVariable(oVar);
            }
            try {
                int numConst = ois.readInt();
                if (numConst <= 0) break block9;
                OiisCompConstants oConstants = this.getCompConstants();
                if (oConstants == null) {
                    oConstants = new OiisCompConstants(numConst);
                    this.setConstants(oConstants);
                }
                for (int i = 0; i < numConst; ++i) {
                    String constName = ois.readUTF();
                    int nType = ois.readInt();
                    Object val = ois.readObject();
                    OiisGenericConstant oConst = new OiisGenericConstant(constName, nType);
                    try {
                        oConst.setValue(val);
                    }
                    catch (OiisConstantException oiisConstantException) {
                        // empty catch block
                    }
                    oConstants.addConstant(oConst);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        ois.close();
        fis.close();
    }

    public static OiisCompContext readXMLContext(String sContextFile) {
        OiisCompContext oContext = null;
        try {
            Parser m_xmlParser = OixsXMLOps.createSAXParser();
            OiisCompContextHandler handlerCompContext = new OiisCompContextHandler();
            FileReader fContextReader = new FileReader(sContextFile);
            BufferedReader bufferedReader = new BufferedReader(fContextReader);
            m_xmlParser.setDocumentHandler(handlerCompContext);
            m_xmlParser.setErrorHandler(handlerCompContext);
            m_xmlParser.parse(new InputSource(bufferedReader));
            bufferedReader.close();
            fContextReader.close();
            oContext = handlerCompContext.getCompContext();
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return oContext;
    }

    public int getWCEIndex(String sWceName) {
        int numElems = this.m_wceArray.size();
        for (int i = 0; i < numElems; ++i) {
            OiifbCondWizOperation wce = (OiifbCondWizOperation)this.m_wceArray.elementAt(i);
            if (!wce.getName().equals(sWceName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Enumeration getAllVariables() {
        return this.m_varOrderTable.elements();
    }

    public Enumeration getROVariables() {
        return this.m_roVars.elements();
    }

    public Vector getVariablesForDeinstallLogs() {
        Vector<OiisVariable> vVars = new Vector<OiisVariable>(this.m_varOrderTable.size() + 10);
        vVars.addElement(this.getVariable(PROD_HOME_VARNAME));
        vVars.addElement(this.getVariable("INVENTORY_LOCATION"));
        int nHomeType = this.m_compID.getHomeType();
        switch (nHomeType) {
            case 1: 
            case 2: {
                vVars.addElement(this.getVariable("ORACLE_HOME"));
                vVars.addElement(this.getVariable("ORACLE_HOME_NAME"));
                int curPlatId = OiixPlatform.getCurrentPlatform();
                if (OiixPlatform.getPlatGroup(curPlatId) != -3) break;
                vVars.addElement(this.getVariable("ORACLE_HOME_SERVICE"));
                vVars.addElement(this.getVariable("ORACLE_HOME_FOLDER"));
                vVars.addElement(this.getVariable("ORACLE_HOME_KEY"));
                break;
            }
            case 3: {
                vVars.addElement(this.getVariable("APPLTOP"));
                vVars.addElement(this.getVariable("APPLTOP_NAME"));
            }
        }
        vVars.addAll(this.m_varOrderTable);
        return vVars;
    }

    public void setCompInsJarLoc(String jarLoc) {
        this.m_compInsJarLoc = jarLoc;
    }

    public String getCompInsJarLoc() {
        return this.m_compInsJarLoc;
    }

    public static Vector getDisplayROVarNames() {
        Vector<String> roList = OiicSessionContext.getDisplayROVarNames();
        if (roList == null) {
            roList = new Vector<String>();
        }
        roList.addElement(PROD_HOME_VARNAME);
        return roList;
    }

    public static boolean isROVarName(String varName) {
        for (int i = 0; i < s_roVarList.length; ++i) {
            if (!varName.equalsIgnoreCase(s_roVarList[i])) continue;
            return true;
        }
        return false;
    }

    private boolean showErrorDlg(String msg) throws OiifbCancelException {
        int button_ops = 2;
        OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(msg, button_ops, 0);
        int userInput = actionDlg.doModal();
        actionDlg = null;
        Thread.yield();
        switch (userInput) {
            case 2: {
                return true;
            }
            case 32: {
                throw new OiifbCancelException(msg, false);
            }
            case 16: {
                throw new OiifbCancelException(msg, true);
            }
        }
        return false;
    }

    public Object doQuery(OiiiLibraryID lid, String queryName, Vector inputs) throws OiifbCancelException {
        OiilExceptionHandler[] queryExcHandlerArr = null;
        return this.doQuery(lid, queryName, inputs, null, queryExcHandlerArr);
    }

    private void toLog(OiiiLibraryID lid, String actionName, Vector inputs) {
        StringBuffer sb = new StringBuffer();
        sb.append(OiixResourceBundle.getString("S_CALLING"));
        sb.append(OiixResourceBundle.getString("S_QUERY"));
        sb.append(lid.getName() + lid.getVersion() + "  ");
        sb.append(actionName);
        int size = inputs.size();
        for (int i = 0; i < size; ++i) {
            OiilActionInputElement elem = (OiilActionInputElement)inputs.elementAt(i);
            if (elem.isImplicit()) continue;
            sb.append(OiiolTextLogger.NEW_LINE);
            sb.append(OiiolTextLogger.getLogLevelStr(OiiolTextLogger.LOG_BASIC));
            sb.append(elem.getParamName());
            sb.append(" = ");
            Object value = elem.getObject();
            if (value instanceof OiisVariable) {
                OiisVariable var = (OiisVariable)value;
                value = var.getLogValue();
            }
            if (value instanceof String[]) {
                value = OiiolTextLogger.StringArrayToStringBuf((String[])value);
            }
            if (elem.isSecure()) {
                value = OiixResourceBundle.getString("S_LOG_PROTECTED_VALUE");
            }
            sb.append(value);
        }
        OiiolTextLogger.appendText(sb.toString());
    }

    public Object doQuery(OiiiLibraryID lid, String queryName, Vector inputs, Object defaultVal, OiilExceptionHandler[] queryExcHandlerArr) throws OiifbCancelException {
        return this.doQuery(lid, queryName, inputs, defaultVal, queryExcHandlerArr, true);
    }

    public Object doQuery(OiiiLibraryID lid, String queryName, Vector inputs, Object defaultVal, OiilExceptionHandler[] queryExcHandlerArr, boolean bLogResult) throws OiifbCancelException {
        if (lid.getPlatforms().size() != 0 && !lid.forPlatform(OiixPlatform.getCurrentPlatform())) {
            return defaultVal;
        }
        boolean retry = false;
        boolean ignore = false;
        Object returnVal = defaultVal;
        OiilQuery query = null;
        StringBuffer sb = new StringBuffer();
        OiisCompInstallation compInstall = this.m_pullSession.getCompInstall(this.m_compID);
        boolean bSuppressIgnore = OiixOraparam.isSuppressIgnoreWarnings();
        inputs = OiilActionInputElement.addImplicitArg(inputs, this.m_pullSession, "installSession");
        inputs = OiilActionInputElement.addImplicitArg(inputs, compInstall, "compInstallation");
        try {
            OiisQueryLibLoader lLoader;
            try {
                int homeIndex = this.m_pullSession.getHomeIndex(this.m_compID);
                lLoader = this.m_pullSession.getQueryLibLoader(lid, homeIndex);
                if (lLoader == null) {
                    throw new IOException(OiixResourceBundle.getString("S_LOADER_NOT_FOUND"));
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new OiisQueryLoadingException(ioe.getMessage());
            }
            this.toLog(lLoader.getLibraryID(), queryName, inputs);
            if (!lLoader.isActionAvailable(queryName, OiixPlatform.getCurrentPlatform())) {
                StringBuffer logMsg = new StringBuffer();
                logMsg.append(OiixResourceBundle.getString("S_QUERY"));
                logMsg.append(" '" + queryName + "' ");
                logMsg.append("from library '");
                logMsg.append(lid.getName() + lid.getVersion() + "' ");
                logMsg.append("is not supported on the current platform '");
                logMsg.append(OiixPlatform.getCurrentPlatformCommonNameEx());
                logMsg.append(" ' . This query is skipped on the current platform. ");
                if (Boolean.getBoolean("oracle.installer.debug")) {
                    String debugMsg = "If this is an error, fix the library to support the current platform and update the shiphome. It is best practice to define the libraries support ALL_PLATFORMS, UNIX or Windows. It is not advisable to list specific platforms except in exception cases.";
                    OiiolTextLogger.appendText(logMsg.toString() + debugMsg, OiiolTextLogger.LOG_BASIC);
                } else {
                    OiiolTextLogger.appendText(logMsg.toString(), OiiolTextLogger.LOG_BASIC);
                }
                return defaultVal;
            }
            boolean tryAgain = false;
            do {
                tryAgain = false;
                try {
                    query = lLoader.getQuery(queryName, OiixPlatform.getCurrentPlatform());
                    if (query == null) {
                        String msgDesc = OiixResourceBundle.getString("S_QUERY_UNAVAILABLE") + OiiolTextLogger.NEW_LINE + OiixResourceBundle.getString("S_LOG_USING_DEFAULT_QUERY");
                        OiiolTextLogger.appendText(msgDesc);
                        return defaultVal;
                    }
                }
                catch (IOException ioe) {
                    Properties pp = System.getProperties();
                    ioe.printStackTrace();
                    String destination = pp.getProperty("oracle.installer.scratchPath");
                    Object[] args = new String[]{lid.getName()};
                    String errMsg = OiixResourceBundle.getString("S_ERROR_LOADING");
                    errMsg = MessageFormat.format(errMsg, args);
                    OiiolTextLogger.appendErrorText(ioe.getMessage());
                    OiiolTextLogger.appendText(ioe.getMessage());
                    tryAgain = this.showErrorDlg(errMsg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new OiisQueryLoadingException(e.getMessage());
                }
            } while (tryAgain);
        }
        catch (OiisQueryLoadingException qle) {
            int button_ops = 0;
            button_ops |= 1;
            Object[] args = new String[]{lid.getName()};
            String errMsg = OiixResourceBundle.getString("S_ERROR_LOADING");
            errMsg = MessageFormat.format(errMsg, args);
            OiicInstallCancelHandler queryDlg = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(button_ops |= 2, errMsg, 1);
            int userInput = queryDlg.doCancelOperation();
            switch (userInput) {
                case 1: {
                    throw new OiifbCancelException(qle.getMessage(), true);
                }
                case 2: {
                    throw new OiifbCancelException(qle.getMessage(), false);
                }
            }
        }
        do {
            retry = false;
            try {
                try {
                    returnVal = query.performQuery(inputs);
                    sb.append(OiixResourceBundle.getString("S_LOG_QUERY_RETURNED"));
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                    String exMsg = re.getMessage();
                    if (exMsg == null) {
                        exMsg = OiixResourceBundle.getString("S_UNCAUGHT_RUNTIME_QUERY");
                    }
                    throw new OiilQueryException(UNCAUGHT_RUNTIME_EX_NAME, exMsg);
                }
            }
            catch (OiilQueryException qe) {
                int userInput;
                Object queryDlg;
                String excName = qe.getExceptionName();
                sb.append(OiiolTextLogger.NEW_LINE + OiixResourceBundle.getString("S_LOG_QUERY_EXCEPTION") + excName);
                sb.append(OiiolTextLogger.NEW_LINE + OiixResourceBundle.getString("S_LOG_QUERY_EXECPTION_CLASS") + qe.getClass());
                OiiolTextLogger.appendText(sb.toString());
                sb = new StringBuffer();
                int index = -1;
                if (queryExcHandlerArr != null) {
                    for (index = 0; index < queryExcHandlerArr.length; ++index) {
                        String userMsg;
                        if (!excName.equals(queryExcHandlerArr[index].getHandlerIntlName())) continue;
                        if (queryExcHandlerArr[index] instanceof OiilExceptionFailure) {
                            int button_ops = 0;
                            button_ops |= 1;
                            String instMsg = qe.getMessage();
                            userMsg = ((OiilExceptionFailure)queryExcHandlerArr[index]).getFailMsg();
                            queryDlg = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(button_ops |= 2, userMsg == null || userMsg.equals("") || userMsg.equals("null") ? instMsg : userMsg, 0);
                            userInput = queryDlg.doCancelOperation();
                            switch (userInput) {
                                case 1: {
                                    throw new OiifbCancelException(qe.getMessage(), true);
                                }
                                case 2: {
                                    throw new OiifbCancelException(qe.getMessage(), false);
                                }
                            }
                            break;
                        }
                        if (queryExcHandlerArr[index] instanceof OiilExceptionContinue) {
                            ignore = true;
                            returnVal = defaultVal;
                            break;
                        }
                        if (!(queryExcHandlerArr[index] instanceof OiilExceptionDlg)) break;
                        int button_ops = 0;
                        if (((OiilExceptionDlg)queryExcHandlerArr[index]).getRetry()) {
                            button_ops |= 2;
                        }
                        if (((OiilExceptionDlg)queryExcHandlerArr[index]).getContinue()) {
                            button_ops |= 4;
                        }
                        if (button_ops == 0) {
                            button_ops |= 2;
                            button_ops |= 4;
                        }
                        int userInput2 = 4;
                        String instMsg = qe.getMessage();
                        userMsg = ((OiilExceptionDlg)queryExcHandlerArr[index]).getErrMsg();
                        if (bSuppressIgnore && (button_ops & 4) == 4) {
                            String sSuppressDesc = OiixResourceBundle.getString("S_SUPPRESS_WARNING");
                            Object[] args = new String[]{instMsg};
                            sSuppressDesc = MessageFormat.format(sSuppressDesc, args);
                            OiiolTextLogger.appendText(sSuppressDesc);
                        } else {
                            OiifbIRetry queryDlg2 = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(userMsg == null || userMsg.equals("") || userMsg.equals("null") ? instMsg : userMsg, button_ops, 1);
                            userInput2 = queryDlg2.doModal();
                            queryDlg2 = null;
                            Thread.yield();
                        }
                        switch (userInput2) {
                            case 2: {
                                retry = true;
                                break;
                            }
                            case 4: {
                                returnVal = defaultVal;
                                ignore = true;
                                break;
                            }
                            case 32: {
                                OiiolTextLogger.appendText(userMsg);
                                throw new OiifbCancelException(qe.getMessage(), false);
                            }
                            case 16: {
                                OiiolTextLogger.appendText(userMsg);
                                throw new OiifbCancelException(qe.getMessage(), true);
                            }
                        }
                        break;
                    }
                }
                if (index != -1 && index < queryExcHandlerArr.length) continue;
                int button_ops = 0;
                button_ops |= 2;
                queryDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(qe.getMessage(), button_ops |= 4, 1);
                userInput = queryDlg.doModal();
                queryDlg = null;
                Thread.yield();
                switch (userInput) {
                    case 2: {
                        retry = true;
                        break;
                    }
                    case 4: {
                        returnVal = defaultVal;
                        ignore = true;
                        break;
                    }
                    case 32: {
                        throw new OiifbCancelException(qe.getMessage(), false);
                    }
                    case 16: {
                        throw new OiifbCancelException(qe.getMessage(), true);
                    }
                }
            }
        } while (retry);
        if (bLogResult) {
            if (returnVal == null) {
                sb.append(OiixResourceBundle.getString("S_LOG_NULL") + OiiolTextLogger.NEW_LINE);
                sb.append(OiixResourceBundle.getString("S_LOG_USING_DEFAULT_QUERY"));
            }
        } else {
            sb.append(OiixResourceBundle.getString("S_LOG_PROTECTED_VALUE"));
        }
        if (returnVal == null) {
            returnVal = defaultVal;
        }
        if (bLogResult) {
            if (returnVal instanceof String[]) {
                sb.append(OiiolTextLogger.StringArrayToStringBuf((String[])returnVal));
            } else {
                sb.append(returnVal);
            }
        }
        OiiolTextLogger.appendText(sb.toString());
        return returnVal;
    }

    public void setProgressListener(OiixProgressListener l) {
        this.m_progressListener = l;
    }

    public OiixProgressListener getProgressListener() {
        return this.m_progressListener;
    }

    public static Vector getROVariablesList(OiiiStageInventory stageInv, OiisCompInstallation ci) {
        OiixJarResourceBundle jrb = new OiixJarResourceBundle(OiixResourceBundle.getBundle());
        Vector<OiisVariable> v = new Vector<OiisVariable>();
        OiisVariable oVar = null;
        String sNewLine = System.getProperty("line.separator");
        OiisCompContext oContext = ci.getContext();
        OiiiCompInstallID id = ci.getCompInstallID();
        if (id.isNOHComp()) {
            oVar = new OiisVariable(oContext, PROD_HOME_VARNAME);
            oVar.setType(OiisVariable.STRING);
            oVar.setExported(true);
            oVar.setDescription("S_PROD_HOME_VARNAME_DESC");
            oVar.setResourceBundle(jrb);
            oVar.setCalcMethodPresent(true);
            String sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
            Object[] objs = new String[]{PROD_HOME_VARNAME, "\"C:\\ProductName\""};
            sDesc = MessageFormat.format(sDesc, objs);
            oVar.setAllValueList(sDesc);
            v.addElement(oVar);
        }
        OiisCompContext.generateDepsVar(stageInv, ci, jrb, v);
        OiisCompProperties compProps = ci.getProperties();
        Vector vTools = compProps.getConfigToolDetails();
        int nTools = vTools.size();
        if (nTools > 0) {
            oVar = new OiisVariable(oContext, OPTCONFIGTOOLS_VARNAME);
            oVar.setType(OiisVariable.STRINGLIST);
            oVar.setExported(true);
            oVar.setDescription("S_OPTCONFIGTOOLS_VARNAME_DESC");
            oVar.setResourceBundle(jrb);
            String sConfigsList = "";
            String sSampleValue = "";
            int nOptionalConfigTools = 0;
            for (int i = 0; i < nTools; ++i) {
                OiisConfigToolDetails cd = (OiisConfigToolDetails)vTools.elementAt(i);
                OiisCompJarLoader cjl = ci.getCompJarLoader();
                OiisPostInstallTool pTool = null;
                try {
                    String toolClassName;
                    if (null != cd.getToolClassName() && cd.getToolClassName().trim().length() > 0 && (toolClassName = cd.getToolClassName()) != null) {
                        pTool = cjl.loadConfigTool(toolClassName);
                        pTool.initToolProperties();
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (pTool == null) continue;
                pTool.setCompContext(oContext);
                if (pTool.isRequired()) continue;
                ++nOptionalConfigTools;
                String s = OiixResourceBundle.getString("S_ALL_VALUE_COMPS_FROMAT");
                Object[] objs = new String[]{cd.getConfigToolID().getInternalName(), " ", cd.getExternalName()};
                s = MessageFormat.format(s, objs);
                sConfigsList = sConfigsList + sNewLine + s;
                if (!sSampleValue.equals("")) continue;
                sSampleValue = OiixResourceBundle.getString("S_STRLIST_FROMAT");
                objs = new String[]{cd.getConfigToolID().getInternalName()};
                sSampleValue = MessageFormat.format(sSampleValue, objs);
            }
            if (nOptionalConfigTools > 0) {
                String sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                Object[] objs = new String[]{OPTCONFIGTOOLS_VARNAME, sSampleValue};
                sDesc = MessageFormat.format(sDesc, objs);
                sConfigsList = sConfigsList + sNewLine + sDesc;
                String sChoices = OiixResourceBundle.getString("S_CHOICES1_FORMAT") + sNewLine;
                sChoices = sChoices + OiixResourceBundle.getString("S_CHOICES3_FORMAT");
                sConfigsList = sChoices + sConfigsList;
                oVar.setAllValueList(sConfigsList);
                oVar.setCalcMethodPresent(true);
                v.addElement(oVar);
            }
        }
        return v;
    }

    private static void generateDepsVar(OiiiStageInventory stageInv, OiisCompInstallation ci, OiixJarResourceBundle jrb, Vector v) {
        int i;
        Object oDeps;
        String sNewLine = System.getProperty("line.separator");
        OiiiCompInstallID id = ci.getCompInstallID();
        OiisVariable oVar = null;
        OiisCompContext oContext = ci.getContext();
        OiiiStageCompInvEntry invEntry = stageInv.getStageCompInvEntry(id, new Vector());
        Vector<OiiiCompInstallID> vComps = new Vector<OiiiCompInstallID>();
        if (id.getCompType() == 1) {
            oDeps = invEntry.getDeps();
            if (oDeps == null) {
                OiisDepInfo depInfo = ci.getDepInfo();
                oDeps = depInfo.getDeps();
            }
            Vector vRules = ((OiisDeps)oDeps).getDepRules();
            int nRules = vRules.size();
            for (i = 0; i < nRules; ++i) {
                OiisDepRule oRule = (OiisDepRule)vRules.elementAt(i);
                if (oRule.getType() == 3) continue;
                Vector vDeps = oRule.getDepCompIds();
                OiixVectorOps.unionInPlace(vComps, vDeps);
            }
        }
        if (id.getCompType() == 2) {
            oDeps = ((OiiiStagePatchInvEntry)invEntry).getPatchDeps();
            Vector vDeps = ((OiisPatchDeps)oDeps).getDepObjs();
            int nSize = vDeps.size();
            for (i = 0; i < nSize; ++i) {
                OiisPatchDepObj oPatchObj = (OiisPatchDepObj)vDeps.elementAt(i);
                if (!oPatchObj.isVerUpgraded()) continue;
                OiiiCompInstallID dependee = oPatchObj.getCurDepId();
                vComps.addElement(dependee);
            }
        }
        if (vComps.size() > 0) {
            oVar = new OiisVariable(oContext, DEPENDEES_VARNAME);
            oVar.setType(OiisVariable.STRINGLIST);
            oVar.setExported(true);
            oVar.setDescription("S_DEPENDEES_VARNAME_DESC");
            oVar.setResourceBundle(jrb);
            String sCompsList = "";
            String sSampleValue = "";
            int nComps = vComps.size();
            for (int j = 0; j < nComps; ++j) {
                OiiiCompInstallID depId = (OiiiCompInstallID)vComps.elementAt(j);
                OiiiStageCompInvEntry depEntry = (OiiiStageCompInvEntry)stageInv.getCompatCompEntry(depId, 0, 0);
                if (depEntry == null) continue;
                String s = OiixResourceBundle.getString("S_ALL_VALUE_COMPS_FROMAT");
                Object[] val = new String[]{depId.getName(), depId.getVersion().toString(), depEntry.getFullDisplayName()};
                s = MessageFormat.format(s, val);
                sCompsList = sCompsList + sNewLine + s;
                if (!sSampleValue.equals("")) continue;
                sSampleValue = OiixResourceBundle.getString("S_DEPENDENCY_COMP_FORMAT");
                val = new String[]{depId.getName(), depId.getVersion().toString()};
                sSampleValue = MessageFormat.format(sSampleValue, val);
            }
            if (!sCompsList.equals("")) {
                String sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                Object[] objs = new String[]{DEPENDEES_VARNAME, sSampleValue};
                sDesc = MessageFormat.format(sDesc, objs);
                sCompsList = sCompsList + sNewLine + sDesc;
                String sChoices = OiixResourceBundle.getString("S_CHOICES2_FORMAT") + sNewLine;
                sChoices = sChoices + OiixResourceBundle.getString("S_CHOICES_TOPLEVEL_FORMAT");
                sCompsList = sChoices + sCompsList;
                oVar.setAllValueList(sCompsList);
                oVar.setCalcMethodPresent(true);
                v.addElement(oVar);
            }
        }
    }

    public void validate(String varName, Object val) throws OiisVarSettingException, OiifbCancelException, OiixRetryException {
        if (val == null) {
            throw new OiisVarSettingException(this, this.getVariable(varName), "Null value for variable");
        }
    }

    public int getWCCNext(String varName) {
        return -1;
    }

    public void doCalculation(String varName) throws OiifbCancelException, OiisVarSettingException {
    }

    public int getNextDialog(String dialogName) {
        return -1;
    }

    public void initializeDialog(String dialogName) throws OiifbCancelException, OiisDialogLoadingException {
    }

    protected void addChainElement(OiifbCondWizOperation oElem) {
        this.m_wceArray.addElement(oElem);
    }

    public OiifbCondWizOperation getChainElementAt(int i) {
        if (i < this.m_wceArray.size()) {
            return (OiifbCondWizOperation)this.m_wceArray.elementAt(i);
        }
        System.err.println("Incorrect access into the wizard chain.");
        return null;
    }

    @Override
    public void setVariablesMap(Map oMap) throws RuntimeException {
        String sMsg = "Method 'setVariablesMap(Map)' should not be called on the instance of the class '" + this.getClass().getName() + "'.";
        OiiolTextLogger.appendText(sMsg);
        throw new RuntimeException(sMsg);
    }
}

