/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisPlatformSpecificConstant;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiisCompConstants {
    private Hashtable m_vConstants;
    protected OiixJarResourceBundle m_oResourceBundle;
    private static final int DEFAULT_SIZE = 10;

    public OiisCompConstants(int size) {
        this.m_vConstants = new Hashtable(size);
    }

    public OiisCompConstants() {
        this.m_vConstants = new Hashtable(10);
    }

    public void addConstant(OiisGenericConstant gConst) {
        if (gConst.isTranslatable()) {
            gConst.setResourceBundle(this.m_oResourceBundle);
        }
        this.m_vConstants.put(gConst.getName().toUpperCase(), gConst);
    }

    public OiisGenericConstant getConstant(String name) {
        return (OiisGenericConstant)this.m_vConstants.get(name.toUpperCase());
    }

    public Enumeration getAllConstants() {
        return this.m_vConstants.elements();
    }

    public Properties getConstantsAsProperties() {
        Properties oProps = new Properties();
        int nCurPlatId = OiixPlatform.getCurrentPlatform();
        Enumeration en = this.getAllConstants();
        while (en.hasMoreElements()) {
            OiisGenericConstant oConstant = (OiisGenericConstant)en.nextElement();
            if (!oConstant.isTranslatable()) continue;
            if (oConstant instanceof OiisPlatformSpecificConstant) {
                OiisPlatformSpecificConstant oPlatSpecificConstant = (OiisPlatformSpecificConstant)oConstant;
                String sResourceID = OiisPlatformSpecificConstant.formDefaultName(oPlatSpecificConstant.getName(), nCurPlatId);
                oProps.put(sResourceID, oPlatSpecificConstant.getValue(nCurPlatId).toString());
                continue;
            }
            String sResourceID = OiisGenericConstant.formDefaultName(oConstant.getName());
            oProps.put(sResourceID, oConstant.getValue().toString());
        }
        return oProps;
    }

    public Properties getConstantsAsProperties(ResourceBundle oResBundle) {
        Properties oProps = new Properties();
        int nCurPlatId = OiixPlatform.getCurrentPlatform();
        Enumeration en = this.getAllConstants();
        while (en.hasMoreElements()) {
            OiisGenericConstant oConstant = (OiisGenericConstant)en.nextElement();
            if (oConstant instanceof OiisPlatformSpecificConstant) {
                OiisPlatformSpecificConstant oPlatSpecificConstant = (OiisPlatformSpecificConstant)oConstant;
                if (!oPlatSpecificConstant.isTranslatable()) continue;
                String sResourceID = OiisPlatformSpecificConstant.formDefaultName(oPlatSpecificConstant.getName(), nCurPlatId);
                oProps.put(sResourceID, oResBundle.getString(sResourceID));
                continue;
            }
            if (!oConstant.isTranslatable()) continue;
            String sResourceID = OiisGenericConstant.formDefaultName(oConstant.getName());
            oProps.put(sResourceID, oResBundle.getString(sResourceID));
        }
        return oProps;
    }

    public int size() {
        return this.m_vConstants.size();
    }

    public void initConstants(boolean bInitAllConstants) {
    }

    public void setResourceBundle(OiixJarResourceBundle oBundle, boolean bSetInConstants) {
        this.setResourceBundle(oBundle);
        Enumeration enConst = this.getAllConstants();
        while (enConst.hasMoreElements()) {
            OiisGenericConstant oConst = (OiisGenericConstant)enConst.nextElement();
            if (!oConst.isTranslatable()) continue;
            oConst.setResourceBundle(oBundle);
        }
    }

    public void setResourceBundle(OiixJarResourceBundle oBundle) {
        this.m_oResourceBundle = oBundle;
    }

    public void dispose() {
        this.m_vConstants.clear();
        this.m_oResourceBundle = null;
    }
}

