/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiis;

import java.io.IOException;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifj.OiifjInstallErrorDlg;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiii.OiiiCdLabel;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageArchiveInfo;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionCloneCapable;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilExceptionContinue;
import oracle.sysman.oii.oiil.OiilExceptionDlg;
import oracle.sysman.oii.oiil.OiilExceptionFailure;
import oracle.sysman.oii.oiil.OiilExceptionHandler;
import oracle.sysman.oii.oiio.oiiol.OiiolActionLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarInfo;
import oracle.sysman.oii.oiis.OiisDiskLocator;
import oracle.sysman.oii.oiis.OiisFileEntry;
import oracle.sysman.oii.oiis.OiisFileGroup;
import oracle.sysman.oii.oiis.OiisIdentifierOps;
import oracle.sysman.oii.oiis.OiisLangFileGroup;
import oracle.sysman.oii.oiis.OiisPathEntry;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiisCompActions {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x200000;
    public static final int SIMULATE = 1;
    public static final int NORMAL = 2;
    public static final int RESUME = 3;
    protected OiicPullSession m_pullSession;
    protected OiicInstallTimeSession m_instTimeSession;
    protected OiifrProgressActionListener m_oListener;
    protected OiisCompInstallation m_myCompInstall;
    private int m_nActionsExecuted = 0;
    private int m_nCurrentPhaseFlowCount = 0;
    private static final String UNCAUGHT_RUNTIME_EX_NAME = "UNCAUGHT_RUNTIME";
    public static final String ACTIONSTART_PREFIX = "ACTION:START:";
    public static final String ACTIONEND_PREFIX = "ACTION:END:";
    private static final String ACTION_MSGDELIM = "__";
    private static final String FECTH_FASTCOPYLOG = "FETCH_COPY";
    private static final String FASTCOPY_LOG_FILENAME = "fastCopyLog.xml";
    private String m_sCurCompName;
    private String m_sEscapedWinOH;

    protected OiisCompActions() {
    }

    public void init(OiicPullSession pullSession, OiisCompInstallation ci) {
        this.m_pullSession = pullSession;
        this.m_instTimeSession = pullSession;
        this.m_myCompInstall = ci;
    }

    public void init(OiicInstallTimeSession session) {
        if (session instanceof OiicPullSession) {
            this.m_pullSession = (OiicPullSession)session;
        }
        this.m_instTimeSession = session;
        this.m_myCompInstall = null;
    }

    public void setCallBack(OiifrProgressActionListener lstr) {
        this.m_oListener = lstr;
    }

    public static void toLog(OiiiLibraryID lid, String actionName, Vector inputs) {
        StringBuffer sb = new StringBuffer();
        sb.append(OiixResourceBundle.getString("S_CALLING"));
        sb.append(OiixResourceBundle.getString("S_ACTION"));
        sb.append(lid.getName() + lid.getVersion() + "  ");
        sb.append(actionName);
        int size = inputs.size();
        for (int i = 0; i < size; ++i) {
            OiilActionInputElement elem = (OiilActionInputElement)inputs.elementAt(i);
            if (elem.isImplicit()) continue;
            sb.append(OiiolTextLogger.getLogLevelStr(OiiolTextLogger.LOG_BASIC));
            sb.append("\t");
            sb.append(elem.getParamName());
            sb.append(" = ");
            Object value = elem.getObject();
            if (value instanceof OiisVariable) {
                OiisVariable var = (OiisVariable)value;
                value = var.getLogValue();
            }
            if (value instanceof String[]) {
                value = OiiolTextLogger.StringArrayToStringBuf((String[])value);
            }
            if (elem.isSecure()) {
                value = OiixResourceBundle.getString("S_LOG_PROTECTED_VALUE");
            }
            sb.append(value);
        }
        sb.append(OiiolTextLogger.NEW_LINE);
        OiiolTextLogger.appendText(sb.toString(), OiiolTextLogger.LOG_BASIC);
    }

    public void stateChangeActions() throws OiilActionException, OiifbCancelException, OiisVarSettingException {
    }

    public void preStateChangeActions() {
        this.m_nActionsExecuted = 0;
        this.m_nCurrentPhaseFlowCount = 0;
        OiisCompContext cxt = this.m_myCompInstall.getContext();
        if (cxt != null) {
            this.m_nCurrentPhaseFlowCount = cxt.getIP1FlowCount();
        }
        this.m_sCurCompName = this.m_myCompInstall.getCompInstallID().getName();
    }

    public void postStateChangeActions() {
        OiicInstallSession oSession;
        this.m_oListener.addBytes(Math.max(0, this.m_nCurrentPhaseFlowCount - this.m_nActionsExecuted) * OiifwActionsPhaseWCDE.getActionSize());
        this.m_nActionsExecuted = 0;
        this.m_nCurrentPhaseFlowCount = 0;
        if (this.m_pullSession.isInstallMode() && (oSession = (OiicInstallSession)this.m_instTimeSession).isFastMode()) {
            long lTime = System.currentTimeMillis();
            String sDbgMsg = null;
            if (OiixDebug.PRINT_VERBOSETIME) {
                sDbgMsg = FECTH_FASTCOPYLOG + this.m_sCurCompName;
                lTime = System.currentTimeMillis();
            }
            this.copyFastCopyLog();
            if (OiixDebug.PRINT_VERBOSETIME) {
                long lCurTime = System.currentTimeMillis();
                OiixDebug.printTimeMsg(sDbgMsg, lCurTime - lTime);
            }
        }
    }

    public void stateChangePhaseLinkActions() throws OiilActionException, OiifbCancelException, OiisVarSettingException {
    }

    public void preStateChangePhaseLinkActions() {
        this.m_nActionsExecuted = 0;
        this.m_nCurrentPhaseFlowCount = 0;
        OiisCompContext cxt = this.m_myCompInstall.getContext();
        if (cxt != null) {
            this.m_nCurrentPhaseFlowCount = cxt.getLKPFlowCount();
        }
    }

    public void postStateChangePhaseLinkActions() {
        this.m_oListener.addBytes(Math.max(0, this.m_nCurrentPhaseFlowCount - this.m_nActionsExecuted) * OiifwActionsPhaseWCDE.getActionSize());
        this.m_nActionsExecuted = 0;
        this.m_nCurrentPhaseFlowCount = 0;
    }

    public void stateChangePhase2Actions() throws OiilActionException, OiifbCancelException, OiisVarSettingException {
    }

    public void preStateChangePhase2Actions() {
        this.m_nActionsExecuted = 0;
        this.m_nCurrentPhaseFlowCount = 0;
        OiisCompContext cxt = this.m_myCompInstall.getContext();
        if (cxt != null) {
            this.m_nCurrentPhaseFlowCount = cxt.getIP2FlowCount();
        }
    }

    public void postStateChangePhase2Actions() {
        this.m_oListener.addBytes(Math.max(0, this.m_nCurrentPhaseFlowCount - this.m_nActionsExecuted) * OiifwActionsPhaseWCDE.getActionSize());
        this.m_nActionsExecuted = 0;
        this.m_nCurrentPhaseFlowCount = 0;
    }

    public OiisCompInstallation getCompInstall() {
        return this.m_myCompInstall;
    }

    public OiicPullSession getInstallSession() {
        return this.m_pullSession;
    }

    protected void doAction(OiiiLibraryID lid, String actionName, Vector inputs) throws OiilActionException, OiifbCancelException {
        OiilExceptionHandler[] actionExcHandlerArr = null;
        this.doAction(lid, actionName, inputs, actionExcHandlerArr);
    }

    protected void doAction(OiiiLibraryID lid, String actionName, Vector inputs, OiilExceptionHandler[] actionExcHandlerArr) throws OiilActionException, OiifbCancelException {
        boolean installFlag = true;
        boolean deinstallFlag = true;
        this.doAction(lid, actionName, inputs, actionExcHandlerArr, installFlag, deinstallFlag);
    }

    protected void doAction(OiiiLibraryID lid, String actionName, Vector inputs, OiilExceptionHandler[] actionExcHandlerArr, boolean installFlag, boolean deinstallFlag) throws OiilActionException, OiifbCancelException {
        this.doAction(lid, actionName, inputs, actionExcHandlerArr, installFlag, deinstallFlag, installFlag);
    }

    protected void doAction(OiiiLibraryID lid, String actionName, Vector inputs, OiilExceptionHandler[] actionExcHandlerArr, boolean installFlag, boolean deinstallFlag, boolean cloneFlag) throws OiilActionException, OiifbCancelException {
        OiifbProgressControl progCtrl = this.m_pullSession.getActionsPhaseWCDE().getProgressControl();
        long lTime = 0L;
        if (OiixDebug.PRINT_MEMORY) {
            lTime = System.currentTimeMillis();
            OiixDebug.printMemory(ACTIONSTART_PREFIX + actionName, lTime);
        }
        if (!progCtrl.canContinue()) {
            boolean cancelSession = (Boolean)progCtrl.getCancelCondition();
            String exStr = OiixResourceBundle.getString("S_USER_CANCEL");
            throw new OiifbCancelException(exStr, cancelSession);
        }
        if (System.getProperty("oracle.installer." + lid.getName(), "true").equals("false")) {
            return;
        }
        if (lid.getName().equalsIgnoreCase("fileActions") && actionName.equalsIgnoreCase("finalClusterSetup")) {
            return;
        }
        boolean bProceedWithActions = false;
        if (OiicPullSession.isLangAddonMode()) {
            if (lid.getName().equalsIgnoreCase("fileActions") && actionName.equals("copyGroup")) {
                bProceedWithActions = true;
            }
        } else if (lid.getName().equalsIgnoreCase("fileActions") && (actionName.equals("copyGroup") || actionName.equals("copyLangGroup") || actionName.equals("copyDllGroup"))) {
            bProceedWithActions = true;
        }
        if (bProceedWithActions) {
            if (!actionName.equals("copyLangGroup")) {
                boolean isDllCp = actionName.equals("copyDllGroup");
                boolean bLoadFileGroup = true;
                OiiiStageCompInvEntry sc = null;
                if (this.m_pullSession.isInstallMode()) {
                    sc = this.m_myCompInstall.getStageCompInvEntry();
                } else {
                    OiiiStageInventory stageInv = this.m_pullSession.getSourceAccess().getStageInventory();
                    sc = stageInv.getStageCompInvEntry(this.m_myCompInstall.getCompInstallID());
                }
                if (!sc.isStageVersionPreX("2.2.0.2.0")) {
                    bLoadFileGroup = true;
                }
                String gpName = (String)OiilActionInputElement.getNamedParam(inputs, "copyGroup");
                OiisFileGroup fg = this.m_myCompInstall.getFileMap().getFileGroup(gpName);
                if (fg != null) {
                    boolean grpArchive = this.isGroupArchived(fg, sc);
                    this.copyGroupAction(lid, fg, inputs, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag, isDllCp, grpArchive, this.getCompDiskNumber(sc), bLoadFileGroup);
                }
            } else {
                String lgpName = (String)OiilActionInputElement.getNamedParam(inputs, "copyLangGroup");
                OiisLangFileGroup lfg = this.m_myCompInstall.getFileMap().getLangFileGroup(lgpName);
                if (lfg != null) {
                    Vector compLangs = this.m_myCompInstall.getLanguages();
                    int numLangs = compLangs.size();
                    for (int i = 0; i < numLangs; ++i) {
                        Vector inputsCopy = (Vector)inputs.clone();
                        Locale sgName = (Locale)compLangs.elementAt(i);
                        OiisFileGroup fg = lfg.getFileGroup(sgName);
                        if (fg == null) continue;
                        this.copyGroupAction(lid, fg, inputsCopy, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag, false, true, 1, true);
                    }
                }
            }
        } else if (!OiicPullSession.isLangAddonMode()) {
            if (inputs != null) {
                OiilActionInputElement aie = new OiilActionInputElement("ProgressListener", this.m_oListener);
                aie.setImplicit(true);
                inputs.addElement(aie);
            }
            this.doActionImpl(lid, actionName, inputs, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag);
        }
        if (!progCtrl.canContinue()) {
            boolean cancelSession = (Boolean)progCtrl.getCancelCondition();
            String exStr = OiixResourceBundle.getString("S_USER_CANCEL");
            throw new OiifbCancelException(exStr, cancelSession);
        }
        if (OiixDebug.PRINT_MEMORY) {
            lTime = System.currentTimeMillis();
            OiixDebug.printMemory(ACTIONEND_PREFIX + actionName, lTime);
        }
    }

    protected void copyGroup(String groupName) throws OiilActionException, OiifbCancelException {
        OiisCompActions oiisCompActions = this;
        OiiiLibraryID fileLibID = oiisCompActions.m_pullSession.getCurrentPlatformFileLibraryID();
        Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>();
        OiilActionInputElement aie = new OiilActionInputElement("copyGroup", groupName);
        inputs.addElement(aie);
        this.doAction(fileLibID, "copyGroup", inputs);
    }

    protected void copyLangGroup(String groupName) throws OiilActionException, OiifbCancelException {
        OiisCompActions oiisCompActions = this;
        OiiiLibraryID fileLibID = oiisCompActions.m_pullSession.getCurrentPlatformFileLibraryID();
        Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>();
        OiilActionInputElement aie = new OiilActionInputElement("copyLangGroup", groupName);
        inputs.addElement(aie);
        this.doAction(fileLibID, "copyLangGroup", inputs);
    }

    protected void copyGroupAction(OiiiLibraryID lid, OiisFileGroup fg, Vector inputs, OiilExceptionHandler[] actionExcHandlerArr, boolean installFlag, boolean deinstallFlag, boolean cloneFlag, boolean isDllGroup, boolean isGroupArchived, int nDiskNumber, boolean bLoadFileGroup) throws OiilActionException, OiifbCancelException {
        boolean bFastMode = false;
        boolean bGenerateRACFileList = false;
        if (this.m_pullSession.isInstallMode()) {
            OiicInstallSession oSession = (OiicInstallSession)this.m_instTimeSession;
            bFastMode = oSession.isFastMode();
            boolean bl = bGenerateRACFileList = oSession.getFastModeType() == 2;
        }
        if (fg.isNewStyleGroup()) {
            Vector vDefEntries;
            Vector relLangSets = null;
            if (OiicPullSession.isLangAddonMode()) {
                OiiiInstallInventory installInventory = ((OiicInstallSession)this.m_pullSession).getInstallAreaControl().getInstallInventory();
                OiisCompContext compContext = this.m_myCompInstall.getContext();
                OiiiCompInstallID compID = compContext.getCompInstallID();
                OiiiInstallCompInvEntry installCompInvEntry = installInventory.getInstallCompInvEntry(compID, this.m_pullSession.getHomeIndex(compID));
                Vector iLangs = installCompInvEntry.getLanguages();
                Vector uLangs = installCompInvEntry.getUpgradeLangs();
                Vector vInstalledLangSet = fg.getRelevantLangSetList(iLangs);
                Vector vUpgradedLangSet = fg.getRelevantLangSetList(uLangs);
                relLangSets = (Vector)vUpgradedLangSet.clone();
                relLangSets.removeAll(vInstalledLangSet);
            } else {
                Vector compLangs = this.m_myCompInstall.getLanguages();
                relLangSets = fg.getRelevantLangSetList(compLangs, false);
            }
            Vector relPlatSets = fg.getRelevantPlatSetList();
            int numLS = relLangSets.size();
            int numPS = relPlatSets.size();
            OiiiStageCompInvEntry sc = null;
            if (this.m_pullSession.isInstallMode()) {
                sc = this.m_myCompInstall.getStageCompInvEntry();
            } else {
                OiiiStageInventory stageInv = this.m_pullSession.getSourceAccess().getStageInventory();
                sc = stageInv.getStageCompInvEntry(this.m_myCompInstall.getCompInstallID());
            }
            if ((!bFastMode && !OiicPullSession.isLangAddonMode() || bFastMode && !sc.canDefaultify()) && (vDefEntries = fg.getDefaultEntries()) != null) {
                if (this.m_pullSession.isInstallMode()) {
                    this.ensureValidDisk(nDiskNumber);
                }
                Vector inputsCopy = (Vector)inputs.clone();
                if (isGroupArchived) {
                    String sGroup = fg.getJarName() + ".jar";
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.writeLogWithTimeAndTrace("calling CopyGroupAction for default Group :" + sGroup, OiiolTextLogger.STR_LOG_DETAILED);
                    }
                    this.copyGroupActionInner(sGroup, vDefEntries, lid, inputsCopy, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag, isDllGroup, true, true);
                } else {
                    String relLoc = fg.getGroupLocation();
                    this.copyExpandedGroupActionInner(relLoc, vDefEntries, lid, inputsCopy, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag, isDllGroup);
                }
            }
            if (bFastMode && !OiicPullSession.isLangAddonMode() && bGenerateRACFileList) {
                vDefEntries = fg.getDefaultEntries();
                this.addToRACFilesList(vDefEntries);
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.writeLogWithTimeAndTrace("Number of LangSets :" + numLS, OiiolTextLogger.STR_LOG_DETAILED);
            }
            for (int i = 0; i < numLS; ++i) {
                int lsInd = (Integer)relLangSets.elementAt(i);
                for (int j = 0; j < numPS; ++j) {
                    int psInd;
                    if (this.m_pullSession.isInstallMode() || OiicPullSession.isLangAddonMode()) {
                        this.ensureValidDisk(nDiskNumber);
                    }
                    if (!fg.containsFileEntriesForLangPlat(lsInd, psInd = ((Integer)relPlatSets.elementAt(j)).intValue())) continue;
                    String groupJarName = fg.getJarName() + "." + lsInd + "." + psInd + ".jar";
                    Vector gpEntries = null;
                    boolean bEntriesLoaded = true;
                    bEntriesLoaded = bLoadFileGroup || !isGroupArchived ? (gpEntries = fg.getEntriesForLangPlatSet(lsInd, psInd)) != null : true;
                    if (!bEntriesLoaded) continue;
                    Vector inputsCopy = this.getParamVectorClone(inputs);
                    if (isGroupArchived) {
                        this.copyGroupActionInner(groupJarName, gpEntries, lid, inputsCopy, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag, isDllGroup, bLoadFileGroup, false);
                    } else {
                        String groupRelLoc = fg.getGroupLocation();
                        this.copyExpandedGroupActionInner(groupRelLoc, gpEntries, lid, inputsCopy, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag, isDllGroup);
                    }
                    if (gpEntries == null) continue;
                    fg.unloadFileEntries(lsInd, psInd);
                }
            }
            fg.unloadFileEntries();
        } else {
            String groupJarName = fg.getJarName() + ".jar";
            Vector gpEntries = fg.getEntries();
            this.copyGroupActionInner(groupJarName, gpEntries, lid, inputs, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag, isDllGroup, true, false);
        }
    }

    protected void copyGroupActionInner(String groupJarName, Vector gpEntries, OiiiLibraryID lid, Vector inputs, OiilExceptionHandler[] actionExcHandlerArr, boolean installFlag, boolean deinstallFlag, boolean cloneFlag, boolean isDllGroup, boolean bLoadFileGroup, boolean bDefaultGroup) throws OiilActionException, OiifbCancelException {
        int numEntries;
        if (gpEntries != null && (numEntries = gpEntries.size()) < 1) {
            return;
        }
        OiiiCompInstallID myID = this.m_myCompInstall.getCompInstallID();
        OiiiSourceAccess sAccess = this.m_pullSession.getSourceAccess();
        String jarFile = null;
        if (this.m_pullSession.isInstallMode() || OiicPullSession.isLangAddonMode()) {
            try {
                jarFile = sAccess.fetchCompFilesJar(myID, groupJarName, null);
            }
            catch (IOException ioe) {
                if (bLoadFileGroup) {
                    if (ioe instanceof SocketException) {
                        if (sAccess.isHttpStage()) {
                            OiiolTextLogger.appendText(ioe.getMessage());
                            boolean bRetry = this.showErrorDlg(OiixResourceBundle.getString("S_HTTP_COPY_FAILS_DUE_TO_SOCKET_EXCEPTION"));
                            if (bRetry) {
                                this.copyGroupActionInner(groupJarName, gpEntries, lid, inputs, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag, isDllGroup, bLoadFileGroup, bDefaultGroup);
                                return;
                            }
                            this.handleException(ioe.getMessage());
                        } else {
                            this.handleException(ioe.getMessage());
                        }
                    } else {
                        this.handleException(ioe.getMessage());
                    }
                }
                return;
            }
        }
        String actionName = "copyGroupFromJar";
        OiilActionInputElement aie = new OiilActionInputElement("JarLoc", jarFile);
        inputs.addElement(aie);
        aie = new OiilActionInputElement("gpEntries", gpEntries);
        inputs.addElement(aie);
        aie = new OiilActionInputElement("installSession");
        inputs.addElement(aie);
        aie = new OiilActionInputElement("compInstallation");
        inputs.addElement(aie);
        aie = new OiilActionInputElement("DllGroup", OiixUtilityOps.booleanValueOf(isDllGroup));
        inputs.addElement(aie);
        aie = new OiilActionInputElement("DefaultGroup", OiixUtilityOps.booleanValueOf(bDefaultGroup));
        aie.setImplicit(true);
        inputs.addElement(aie);
        aie = new OiilActionInputElement("ProgressListener", this.m_oListener);
        aie.setImplicit(true);
        inputs.addElement(aie);
        this.doActionImpl(lid, actionName, inputs, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag);
        if (this.m_pullSession.isInstallMode()) {
            sAccess.releaseCompFilesJar(myID, jarFile);
        }
    }

    protected void copyExpandedGroupActionInner(String groupRelLoc, Vector gpEntries, OiiiLibraryID lid, Vector inputs, OiilExceptionHandler[] actionExcHandlerArr, boolean installFlag, boolean deinstallFlag, boolean cloneFlag, boolean isDllGroup) throws OiilActionException, OiifbCancelException {
        int numEntries = gpEntries.size();
        if (numEntries < 1) {
            return;
        }
        OiiiCompInstallID myID = this.m_myCompInstall.getCompInstallID();
        OiiiSourceAccess sAccess = this.m_pullSession.getSourceAccess();
        String actionName = "copyExpandedGroup";
        OiilActionInputElement aie = new OiilActionInputElement("groupRelLoc", groupRelLoc);
        inputs.addElement(aie);
        aie = new OiilActionInputElement("gpEntries", gpEntries);
        inputs.addElement(aie);
        aie = new OiilActionInputElement("installSession");
        inputs.addElement(aie);
        aie = new OiilActionInputElement("compInstallation");
        inputs.addElement(aie);
        aie = new OiilActionInputElement("DllGroup", OiixUtilityOps.booleanValueOf(isDllGroup));
        inputs.addElement(aie);
        aie = new OiilActionInputElement("ProgressListener", this.m_oListener);
        aie.setImplicit(true);
        inputs.addElement(aie);
        this.doActionImpl(lid, actionName, inputs, actionExcHandlerArr, installFlag, deinstallFlag, cloneFlag);
    }

    private OiilAction getAction(String actionName, OiisActionLibLoader lLoader) throws OiifbCancelException {
        OiilAction action = null;
        boolean tryAgain = false;
        OiiiLibraryID lid = lLoader.getLibraryID();
        do {
            tryAgain = false;
            try {
                action = lLoader.getAction(actionName, OiixPlatform.getCurrentPlatform());
                if (action == null) {
                    System.out.println("Action object created is NULL");
                    throw new IOException(OiixResourceBundle.getString("S_ACTION_UNAVAILABLE"));
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Properties pp = System.getProperties();
                String destination = pp.getProperty("oracle.installer.scratchPath");
                try {
                    Object[] args = new String[]{lid.getName()};
                    String errMsg = OiixResourceBundle.getString("S_ERROR_LOADING");
                    errMsg = MessageFormat.format(errMsg, args);
                    OiiolTextLogger.appendErrorText(ioe.getMessage());
                    OiiolTextLogger.appendText(ioe.getMessage());
                    tryAgain = this.showErrorDlg(errMsg);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_EXCEPTION_NOT_FOUND") + actionName + OiixResourceBundle.getString("S_IN_LIBRARY") + lid);
                e.printStackTrace();
                this.handleException(e.getMessage());
            }
        } while (tryAgain);
        return action;
    }

    protected void doActionImpl(OiiiLibraryID lid, String actionName, Vector inputs, OiilExceptionHandler[] actionExcHandlerArr, boolean installFlag, boolean deinstallFlag, boolean cloneFlag) throws OiilActionException, OiifbCancelException {
        long lTime = 0L;
        String sDbgMsg = null;
        if (OiixDebug.PRINT_VERBOSETIME) {
            sDbgMsg = ACTIONSTART_PREFIX + this.m_sCurCompName + ACTION_MSGDELIM + actionName;
            lTime = System.currentTimeMillis();
        }
        if (lid.getPlatforms().size() != 0 && !lid.forPlatform(OiixPlatform.getCurrentPlatform())) {
            if (this.m_nCurrentPhaseFlowCount > 0) {
                this.m_oListener.addBytes(OiifwActionsPhaseWCDE.getActionSize());
                ++this.m_nActionsExecuted;
            }
            return;
        }
        int actionMode = 2;
        OiiiCompInstallID myID = null;
        OiisActionLibLoader lLoader = null;
        inputs = OiilActionInputElement.addImplicitArg(inputs, this.m_instTimeSession, "installSession");
        if (this.m_myCompInstall != null) {
            myID = this.m_myCompInstall.getCompInstallID();
            inputs = OiilActionInputElement.addImplicitArg(inputs, this.m_myCompInstall, "compInstallation");
        }
        inputs = OiilActionInputElement.addImplicitArg(inputs, this.m_oListener, "ProgressListener");
        String[] remoteNodes = (String[])this.m_instTimeSession.getSessionContext().getVarValue("REMOTE_NODES");
        if (remoteNodes != null && remoteNodes.length > 0) {
            inputs = OiilActionInputElement.addImplicitArg(inputs, remoteNodes, "remoteNodes");
        }
        int homeIndex = this.m_instTimeSession.getOHIndex();
        if (myID != null && this.m_instTimeSession instanceof OiicPullSession) {
            homeIndex = ((OiicPullSession)this.m_instTimeSession).getHomeIndex(myID);
        }
        try {
            lLoader = this.m_instTimeSession.getActionLibLoader(lid, homeIndex);
            if (lLoader == null) {
                throw new IOException(OiixResourceBundle.getString("S_LOADER_NOT_FOUND"));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.handleException(ioe.getMessage());
        }
        OiisCompActions.toLog(lLoader.getLibraryID(), actionName, inputs);
        if (!lLoader.isActionAvailable(actionName, OiixPlatform.getCurrentPlatform())) {
            StringBuffer sb = new StringBuffer();
            sb.append(OiixResourceBundle.getString("S_ACTION"));
            sb.append(" '" + actionName + "' ");
            sb.append("from library '");
            sb.append(lid.getName() + lid.getVersion() + "' ");
            sb.append("is not supported on the current platform '");
            sb.append(OiixPlatform.getCurrentPlatformCommonNameEx());
            sb.append(" ' . This action is skipped on the current platform. ");
            if (Boolean.getBoolean("oracle.installer.debug")) {
                String debugMsg = "If this is an error, fix the library to support the\tcurrent platform and update the shiphome. It is best practice to define the libraries support ALL_PLATFORMS, UNIX or Windows. It is not advisable to list specific platforms except in exception cases.";
                OiiolTextLogger.appendText(sb.toString() + debugMsg, OiiolTextLogger.LOG_BASIC);
            } else {
                OiiolTextLogger.appendText(sb.toString(), OiiolTextLogger.LOG_BASIC);
            }
            if (this.m_nCurrentPhaseFlowCount > 0) {
                this.m_oListener.addBytes(OiifwActionsPhaseWCDE.getActionSize());
                ++this.m_nActionsExecuted;
            }
            return;
        }
        OiilAction action = this.getAction(actionName, lLoader);
        if (actionMode == 1) {
            System.out.println(action.getDescription(inputs));
        } else {
            if (actionMode == 3) {
                return;
            }
            Vector logObjects = new Vector();
            Vector backupObjects = new Vector();
            boolean ignore = this.doActionWithException(actionName, action, inputs, installFlag, cloneFlag, actionExcHandlerArr, logObjects, backupObjects);
            if (!ignore && myID != null) {
                int nSize = inputs.size();
                if (nSize > 0) {
                    inputs.removeElementAt(nSize - 1);
                }
                inputs = OiilActionInputElement.nullImplicitArg(inputs);
                Vector logInputs = this.processInputsForGroupElements(lid, actionName, inputs);
                this.parameterizeLogValues(logInputs);
                this.parameterizeLogValues(logObjects);
                OiiolActionLogEntry ale = new OiiolActionLogEntry(lid, actionName, logInputs, logObjects, backupObjects, installFlag, deinstallFlag);
                try {
                    if (this.m_pullSession == null) {
                        System.err.println("error: m_pullSession is null");
                    } else if (this.m_pullSession.getActionsPhaseWCDE() == null) {
                        System.err.println("error: installActionsPhase is null");
                    }
                    this.m_pullSession.getActionsPhaseWCDE().addLogEntry(myID, ale);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        if (OiixDebug.PRINT_VERBOSETIME) {
            long lCurTime = System.currentTimeMillis();
            OiixDebug.printTimeMsg(sDbgMsg, lCurTime - lTime);
        }
    }

    private void parameterizeLogValues(Vector vInputs) {
        int nSize = vInputs.size();
        for (int i = 0; i < nSize; ++i) {
            Object oInput = vInputs.elementAt(i);
            if (oInput instanceof OiilActionInputElement) {
                OiilActionInputElement oElem = (OiilActionInputElement)oInput;
                if (oElem.isImplicit()) continue;
                OiiolTextLogger.appendText("Parameterizing : " + oElem.getParamName(), OiiolTextLogger.LOG_TRACE);
                OiiolTextLogger.appendText("Log Value : " + oElem.getLogValue(), OiiolTextLogger.LOG_TRACE);
                Object oValue = oElem.getObject();
                if (oValue == null) continue;
                OiiolTextLogger.appendText("Value : " + oValue, OiiolTextLogger.LOG_TRACE);
                this.parameterize(oElem);
                continue;
            }
            if (oInput instanceof Vector) {
                Vector vObjects = (Vector)oInput;
                int nLogObjCount = vObjects.size();
                for (int j = 0; j < nLogObjCount; ++j) {
                    Object oLogObj = vObjects.elementAt(j);
                    if (oLogObj instanceof OiilActionInputElement) {
                        this.parameterize((OiilActionInputElement)oLogObj);
                        continue;
                    }
                    if (!OiisCompActions.isPrimitiveType(oLogObj)) continue;
                    vObjects.setElementAt(this.parameterizeOldValue(oLogObj), i);
                }
                continue;
            }
            if (!OiisCompActions.isPrimitiveType(oInput)) continue;
            vInputs.setElementAt(this.parameterizeOldValue(oInput), i);
        }
    }

    private static boolean isPrimitiveType(Object obj) {
        if (obj != null) {
            return obj instanceof String;
        }
        return false;
    }

    private void parameterize(OiilActionInputElement oElem) {
        Object _val = oElem.getObject();
        if (_val instanceof String[]) {
            String[] saArgValues = (String[])_val;
            int nNumValues = saArgValues.length;
            String[] newValues = new String[nNumValues];
            for (int j = 0; j < nNumValues; ++j) {
                newValues[j] = this.parameterizeArgument(saArgValues[j], this.m_myCompInstall.getContext());
            }
            OiiolTextLogger.appendText("Parameterized log value : " + newValues, OiiolTextLogger.LOG_TRACE);
            oElem.setObject(newValues);
        } else if (OiisCompActions.isPrimitiveType(_val)) {
            this.parameterizeValue(oElem);
        }
    }

    private String parameterizeOldValue(Object obj) {
        String _val = obj.toString();
        _val = OiisIdentifierOps.parameterizeString(_val, this.m_myCompInstall.getContext());
        OiiolTextLogger.appendText("Parameterized log value : " + _val, OiiolTextLogger.LOG_TRACE);
        return _val;
    }

    private void parameterizeValue(OiilActionInputElement oElem) {
        String _val = oElem.getLogValue();
        if (!OiisCompActions.isParameterized(_val)) {
            _val = oElem.getObject().toString();
            _val = OiisIdentifierOps.parameterizeString(_val, this.m_myCompInstall.getContext());
        }
        OiiolTextLogger.appendText("Parameterized log value : " + _val, OiiolTextLogger.LOG_TRACE);
        oElem.setObject(_val);
    }

    private String parameterizeArgument(String sArg, OiisCompContext oContext) {
        OiisVariable oOHVar = oContext.getVariable("ORACLE_HOME");
        String sArgBuf = sArg;
        if (oOHVar != null) {
            String sOHValue = oOHVar.getValue().toString();
            String sVarName = "ORACLE_HOME";
            String sSub = '%' + sVarName + '%';
            sArgBuf = OiisIdentifierOps.replaceAll(sArg, sOHValue, sSub);
            if (OiixPlatform.isPlatInGroup(-3, OiixPlatform.getCurrentPlatform())) {
                if (this.m_sEscapedWinOH == null) {
                    this.m_sEscapedWinOH = OiisIdentifierOps.replaceAll(sOHValue, "\\", "\\\\");
                }
                sArgBuf = OiisIdentifierOps.replaceAll(sArgBuf, this.m_sEscapedWinOH, sSub);
            }
        }
        return OiisIdentifierOps.parameterizeString(sArgBuf, oContext);
    }

    private Vector getParamVectorClone(Vector inputs) {
        int size = inputs.size();
        Vector<Object> clonedVector = new Vector<Object>(size);
        for (int i = 0; i < size; ++i) {
            OiilActionInputElement oElem = (OiilActionInputElement)inputs.elementAt(i);
            clonedVector.add(oElem.clone());
        }
        return clonedVector;
    }

    protected boolean doActionWithException(String actionName, OiilAction action, Vector inputs, boolean installFlag, boolean cloneFlag, OiilExceptionHandler[] actionExcHandlerArr, Vector logObjects, Vector backupObjects) throws OiifbCancelException {
        boolean retry = false;
        boolean ignore = false;
        boolean bSuppressIgnore = OiixOraparam.isSuppressIgnoreWarnings();
        do {
            retry = false;
            try {
                if ((!installFlag || this.m_instTimeSession.isCloneMode()) && (!cloneFlag || !this.m_instTimeSession.isCloneMode())) continue;
                if (action == null) {
                    System.out.println("Action object created is NULL");
                }
                try {
                    if (this.m_instTimeSession.inRollbackMode()) {
                        action.saveAndInstallAction(inputs, logObjects, backupObjects);
                    } else if (this.m_instTimeSession.isCloneMode()) {
                        if (action instanceof OiilActionCloneCapable) {
                            ((OiilActionCloneCapable)((Object)action)).cloneAction(inputs, logObjects);
                        } else {
                            String sDesc = OiixResourceBundle.getString("S_ACTION_SKIPPED_AT_CLONE");
                            Object[] args = new String[]{actionName};
                            sDesc = MessageFormat.format(sDesc, args);
                            String sMsg = OiixResourceBundle.getString("S_LOG_ALERT_WARNING") + " " + sDesc;
                            OiiolTextLogger.appendText(sMsg, OiiolTextLogger.LOG_BASIC);
                        }
                    } else {
                        action.installAction(inputs, logObjects);
                    }
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                    String exMsg = re.getMessage();
                    if (exMsg == null) {
                        exMsg = OiixResourceBundle.getString("S_UNCAUGHT_RUNTIME_ACTION");
                    }
                    throw new OiilActionException(UNCAUGHT_RUNTIME_EX_NAME, exMsg, -1);
                }
            }
            catch (OiilActionException ae) {
                Object actionDlg;
                StringBuffer sb = new StringBuffer();
                sb.append(OiixResourceBundle.getString("S_LOG_EXCEPTION_ACTION") + actionName);
                sb.append(OiiolTextLogger.NEW_LINE);
                sb.append(OiixResourceBundle.getString("S_LOG_EXCEPTION_NAME") + ae.getExceptionName());
                sb.append(OiiolTextLogger.NEW_LINE);
                sb.append(OiixResourceBundle.getString("S_LOG_EXCEPTION_STRING") + ae.getExceptionString());
                sb.append(OiiolTextLogger.NEW_LINE);
                sb.append(OiixResourceBundle.getString("S_LOG_EXCEPTION_SEVERITY") + ae.getExceptionSeverity());
                OiiolTextLogger.appendText(sb.toString());
                sb = new StringBuffer();
                String excName = ae.getExceptionName();
                int index = -1;
                if (actionExcHandlerArr != null) {
                    for (index = 0; index < actionExcHandlerArr.length; ++index) {
                        String userMsg;
                        String instMsg;
                        int button_ops;
                        OiilExceptionHandler exHndlr = actionExcHandlerArr[index];
                        if (exHndlr == null || !excName.equals(exHndlr.getHandlerIntlName())) continue;
                        if (exHndlr instanceof OiilExceptionFailure) {
                            sb.append(OiixResourceBundle.getString("S_LOG_EXCEPTION_HANDLING_FAIL"));
                            button_ops = 0;
                            button_ops |= 1;
                            instMsg = ae.getMessage();
                            userMsg = ((OiilExceptionFailure)exHndlr).getFailMsg();
                            actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(button_ops |= 2, userMsg == null || userMsg.equals("") || userMsg.equals("null") ? instMsg : userMsg, 0);
                            int userInput = actionDlg.doCancelOperation(true);
                            switch (userInput) {
                                case 1: {
                                    sb.append(OiixResourceBundle.getString("S_LOG_USER_SELECTED_STOPALL"));
                                    OiiolTextLogger.appendText(sb.toString());
                                    throw new OiifbCancelException(ae.getMessage(), true);
                                }
                                case 2: {
                                    sb.append(OiixResourceBundle.getString("S_LOG_USER_SELECTED_STOPONLY"));
                                    OiiolTextLogger.appendText(sb.toString());
                                    throw new OiifbCancelException(ae.getMessage(), false);
                                }
                                case 8: {
                                    sb.append(OiixResourceBundle.getString("S_LOG_USER_SELECTED_STOPALL"));
                                    OiiolTextLogger.appendText(sb.toString());
                                    OiicExitOps.getExitOps().exit();
                                }
                            }
                            break;
                        }
                        if (exHndlr instanceof OiilExceptionContinue) {
                            sb.append(OiixResourceBundle.getString("S_LOG_EXCEPTION_HANDLING_IGNORE"));
                            ignore = true;
                            break;
                        }
                        if (!(exHndlr instanceof OiilExceptionDlg)) break;
                        sb.append(OiixResourceBundle.getString("S_LOG_EXCEPTION_HANDLING_OPTIONS"));
                        button_ops = 0;
                        if (((OiilExceptionDlg)exHndlr).getRetry()) {
                            button_ops |= 2;
                            sb.append(OiixResourceBundle.getString("S_LOG_RETRY1"));
                        }
                        if (((OiilExceptionDlg)exHndlr).getContinue()) {
                            sb.append(OiixResourceBundle.getString("S_LOG_IGNORE1"));
                            button_ops |= 4;
                        }
                        if (button_ops == 0) {
                            button_ops |= 2;
                            button_ops |= 4;
                        }
                        int userInput = 4;
                        instMsg = ae.getMessage();
                        userMsg = ((OiilExceptionDlg)exHndlr).getErrMsg();
                        if (bSuppressIgnore && (button_ops & 4) == 4) {
                            OiiolTextLogger.appendText("Warning Ignored :" + instMsg);
                        } else {
                            OiicInstallTimeSession oSession;
                            OiifbIRetry actionDlg2 = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(userMsg == null || userMsg.equals("") || userMsg.equals("null") ? instMsg : userMsg, button_ops, 0);
                            boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
                            if (!OiicPullSession.isSilentMode() && !isAPIMode) {
                                ((OiifjInstallErrorDlg)actionDlg2).setExitOnCancel(true);
                            }
                            if (OiicPullSession.isSilentMode() && !isAPIMode && ((button_ops & 4) == 4 || (button_ops & 2) == 2) && (oSession = OiicSessionInterfaceManager.getInterfaceManager().getSession()) != null && oSession instanceof OiicInstallSession) {
                                ((OiicInstallSession)oSession).setSuccessfullInstallation(false);
                            }
                            userInput = actionDlg2.doModal();
                            actionDlg2 = null;
                            Thread.yield();
                        }
                        sb.append(OiiolTextLogger.NEW_LINE);
                        sb.append(OiixResourceBundle.getString("S_LOG_USER_CHOICE"));
                        switch (userInput) {
                            case 2: {
                                sb.append(OiixResourceBundle.getString("S_LOG_RETRY2"));
                                retry = true;
                                break;
                            }
                            case 4: {
                                sb.append(OiixResourceBundle.getString("S_LOG_IGNORE2"));
                                ignore = true;
                                break;
                            }
                            case 32: {
                                sb.append(OiixResourceBundle.getString("S_LOG_USER_SELECTED_STOPONLY"));
                                OiiolTextLogger.appendText(sb.toString());
                                throw new OiifbCancelException(ae.getMessage(), false);
                            }
                            case 16: {
                                sb.append(OiixResourceBundle.getString("S_LOG_USER_SELECTED_STOPALL"));
                                OiiolTextLogger.appendText(sb.toString());
                                if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
                                    throw new OiifbCancelException(ae.getMessage(), true);
                                }
                                OiicExitOps.getExitOps().exit();
                            }
                        }
                        OiiolTextLogger.appendText(sb.toString());
                        break;
                    }
                }
                if (index != -1 && index < actionExcHandlerArr.length || this.m_pullSession == null) continue;
                int button_ops = 0;
                button_ops = 0;
                button_ops |= 2;
                if (ae.getExceptionSeverity() != -1) {
                    button_ops |= 4;
                }
                int userInput = 0;
                try {
                    actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(ae.getMessage(), button_ops, 1);
                    userInput = actionDlg.doModal();
                    actionDlg = null;
                    Thread.yield();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                switch (userInput) {
                    case 2: {
                        retry = true;
                        break;
                    }
                    case 4: {
                        if (System.getProperty("oracle.installer.handleExitForRegisterForMake", "false").equalsIgnoreCase("true") && System.getProperty("oracle.installer.exitOnMakeFailure", "false").equalsIgnoreCase("true")) {
                            ignore = false;
                            OiiolTextLogger.appendText(ae.getMessage());
                            throw new OiifbCancelException(ae.getMessage(), true);
                        }
                        boolean isAPIMode = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
                        boolean isResponseFileSpecified = System.getProperty("oracle.installer.responseFile", "false").equalsIgnoreCase("true");
                        if (OiicPullSession.isSilentMode() && cloneFlag || isAPIMode && cloneFlag) {
                            OiiolTextLogger.writeToLogAndConsole(ae.getExceptionString());
                        } else if (OiicPullSession.isSilentMode() && isResponseFileSpecified) {
                            OiiolTextLogger.writeToLogAndConsole(ae.getExceptionString());
                        }
                        ignore = true;
                        break;
                    }
                    case 32: {
                        throw new OiifbCancelException(ae.getMessage(), false);
                    }
                    case 16: {
                        throw new OiifbCancelException(ae.getMessage(), true);
                    }
                }
            }
        } while (retry);
        if (!actionName.equalsIgnoreCase("registerForMake") && this.m_nCurrentPhaseFlowCount > 0) {
            this.m_oListener.addBytes(OiifwActionsPhaseWCDE.getActionSize());
        }
        ++this.m_nActionsExecuted;
        return ignore;
    }

    private boolean showErrorDlg(String msg) throws OiifbCancelException {
        int button_ops = 2;
        OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(msg, button_ops, 0);
        int userInput = actionDlg.doModal();
        actionDlg = null;
        Thread.yield();
        switch (userInput) {
            case 2: {
                return true;
            }
            case 32: {
                throw new OiifbCancelException(msg, false);
            }
            case 16: {
                throw new OiifbCancelException(msg, true);
            }
        }
        return false;
    }

    private int getCompDiskNumber(OiiiStageCompInvEntry sc) {
        return sc.getDiskNumber();
    }

    private boolean isGroupArchived(OiisFileGroup fg, OiiiStageCompInvEntry sc) {
        OiiiStageArchiveInfo sai = sc.getStageArchiveInfo();
        boolean stageArchive = sai != null ? sai.isArchiveForPlat(OiixPlatform.getCurrentPlatform()) : true;
        boolean grpArchive = !stageArchive ? false : fg.isGroupArchived();
        return grpArchive;
    }

    public void ensureValidDisk(int diskNumber) throws OiifbCancelException {
        OiicInstallSession instSession = null;
        if (this.m_pullSession.isInstallMode() || OiicPullSession.isLangAddonMode()) {
            instSession = (OiicInstallSession)this.m_pullSession;
        }
        if (instSession.getCurrentDiskNumber() != diskNumber) {
            OiiiSourceAccess sAccess = instSession.getSourceAccess();
            String sRoot = sAccess.getAbsoluteSourceRoot();
            if (instSession.getDiskLabel() != null) {
                boolean bRetry = true;
                while (bRetry) {
                    try {
                        OiisDiskLocator oDiskLocator = new OiisDiskLocator(instSession.getSessionContext());
                        String sNewLoc = oDiskLocator.getDiskLocation(sRoot, instSession.getDiskLabel(), diskNumber);
                        sAccess.createFileLoader(sNewLoc, diskNumber);
                        OiiiCdLabel labelFile = new OiiiCdLabel();
                        labelFile.readLabelFile(sNewLoc);
                        instSession.setCurrentDisk(labelFile);
                        bRetry = false;
                    }
                    catch (OiiiDiskNotFoundException ie) {
                        bRetry = this.showErrorDlg(ie.getMessage());
                    }
                    catch (IOException ie) {
                        bRetry = this.showErrorDlg(ie.getMessage());
                    }
                }
            }
        }
    }

    private Vector processInputsForGroupElements(OiiiLibraryID lid, String actionName, Vector inputs) {
        int gpEntriesPos;
        Vector retVect = inputs;
        if (lid.getName().equalsIgnoreCase("fileActions") && (actionName.equals("copyGroupFromJar") || actionName.equals("copyExpandedGroup")) && (gpEntriesPos = OiixVectorOps.vectIndexOf(inputs, (Object)"gpEntries")) != -1) {
            retVect = (Vector)inputs.clone();
            retVect.removeElementAt(gpEntriesPos);
        }
        return retVect;
    }

    private void handleException(String exStr) throws OiifbCancelException {
        int button_ops = 0;
        button_ops |= 1;
        OiicInstallCancelHandler actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(button_ops |= 2, OiixResourceBundle.getString("S_ERROR_OCCURRED"), 1);
        int userInput = actionDlg.doCancelOperation();
        switch (userInput) {
            case 1: {
                throw new OiifbCancelException(exStr, true);
            }
            case 2: {
                throw new OiifbCancelException(exStr, false);
            }
        }
    }

    private void appendActionToFile(String stringToAppend, boolean installFlag, boolean deinstallFlag) {
        StringBuffer tempBuff = new StringBuffer();
        tempBuff.append(stringToAppend);
        if (installFlag && deinstallFlag) {
            tempBuff.append(OiixResourceBundle.getString("S_INSTALL_DEINSTALL_ACTION"));
        } else if (installFlag) {
            tempBuff.append(OiixResourceBundle.getString("S_INSTALL_ONLY_ACTION"));
        } else if (deinstallFlag) {
            tempBuff.append(OiixResourceBundle.getString("S_DEINSTALL_ONLY_ACTION"));
        }
        tempBuff.append(System.getProperty("line.separator"));
        String bufferToWrite = new String(tempBuff);
        OiiolTextLogger.appendText(new String(tempBuff));
    }

    private void addToRACFilesList(Vector vDefEntries) {
        boolean bCluster = false;
        String[] remoteNodes = (String[])this.m_instTimeSession.getSessionContext().getVarValue("REMOTE_NODES");
        if (remoteNodes != null && remoteNodes.length > 0) {
            bCluster = true;
        }
        if (!bCluster) {
            return;
        }
        if (vDefEntries != null) {
            Enumeration en = vDefEntries.elements();
            while (en.hasMoreElements()) {
                OiisPathEntry oPathEntry = (OiisPathEntry)en.nextElement();
                if (!(oPathEntry instanceof OiisFileEntry)) continue;
                OiisFileEntry oFileEntry = (OiisFileEntry)oPathEntry;
                String sDestFile = oFileEntry.getDestination();
                sDestFile = this.m_myCompInstall.instantiate(sDestFile);
                OiipgCFSDriveCheck cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
                if (cfsDriveCheck.isDriveOnCFS(sDestFile)) continue;
                if (oFileEntry.isDirectoryEntry()) {
                    OiipgClusterLogger.logDirCommands(sDestFile);
                    continue;
                }
                OiipgClusterLogger.logCopyFile(sDestFile);
            }
        }
    }

    private void copyFastCopyLog() {
        int homeIndex = this.m_instTimeSession.getOHIndex();
        OiiiCompInstallID cid = this.m_myCompInstall.getCompInstallID();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        String sLogLoc = iac.getXMLCompFullLoc(cid, homeIndex);
        sLogLoc = OiixPathOps.concatPath(sLogLoc, FASTCOPY_LOG_FILENAME);
        sLogLoc = OiixPathOps.getNativeForm(sLogLoc);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.writeLogWithTimeAndTrace("Extracting FastCopyLog.xml to :" + sLogLoc, OiiolTextLogger.STR_LOG_DETAILED);
        }
        OiisCompJarInfo oji = this.m_myCompInstall.getProperties().getCompJarInfo();
        this.m_myCompInstall.getCompJarLoader().fetchFastCopyLog(oji, sLogLoc);
    }

    private static boolean isParameterized(String value) {
        return null != value && value.indexOf("%") >= 0;
    }
}

