/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.osd.win32;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallLogManipulator;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiil.OiilActionClusterOps;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilWinActionsClusterDeinstall;
import oracle.sysman.oii.oiil.OiilWinActionsClusterInstall;
import oracle.sysman.oii.oiio.oiiol.OiiolActionLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolLogManipulator;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterExecution;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisCompActions;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiipwWindowsClusterExecution
extends OiipgClusterExecution {
    public OiipwWindowsClusterExecution(OiicInstallTimeSession instSession, OiifrProgressActionListener list) {
        this.m_instSession = instSession;
        this.m_oProgressListener = list;
    }

    @Override
    public void executeClusterActions(String[] remoteNodesArr) {
        boolean bInstall = true;
        try {
            if (this.m_instSession.isAddNodeMode()) {
                if (Boolean.getBoolean("oracle.installer.remoteActions")) {
                    Vector installElems = new Vector();
                    installElems = this.m_instSession.getSessionPlan().getSuccessfulAdditionsForAddNode();
                    if (installElems != null && installElems.size() > 0) {
                        OiiiInstallCompInvEntry[] iciesInstall = new OiiiInstallCompInvEntry[installElems.size()];
                        int numComps = installElems.size();
                        int i = numComps - 1;
                        for (int j = 0; i >= 0 && j < numComps; --i, ++j) {
                            iciesInstall[j] = (OiiiInstallCompInvEntry)installElems.elementAt(i);
                        }
                        this.doComponentActions(installElems, iciesInstall, bInstall, remoteNodesArr);
                    }
                }
            } else if (remoteNodesArr != null && remoteNodesArr.length > 0) {
                Vector vInstallIdOhList = null;
                Vector vDeinstallIdOhList = null;
                vInstallIdOhList = OiifwActionsPhaseWCDE.s_installList;
                vDeinstallIdOhList = m_componentList;
                String logText = null;
                String remoteNodesString = OiixFunctionOps.implodeList(remoteNodesArr, ",");
                Object[] obj = new Object[]{remoteNodesString};
                if (vDeinstallIdOhList != null && vDeinstallIdOhList.size() > 0) {
                    OiiiInstallCompInvEntry[] iciesDeinstall = m_deinstallIcies;
                    logText = OiixResourceBundle.getString("S_BEGIN_CLUSTER_DEINSTALL", obj);
                    if (this.m_oProgressListener != null) {
                        this.m_oProgressListener.setStatus(logText);
                    }
                    bInstall = false;
                    this.doComponentActions(vDeinstallIdOhList, iciesDeinstall, bInstall, remoteNodesArr);
                }
                if (vInstallIdOhList != null && vInstallIdOhList.size() > 0) {
                    OiiiInstallCompInvEntry[] iciesInstall = this.getInstallInvEntries(vInstallIdOhList, true);
                    logText = OiixResourceBundle.getString("S_BEGIN_CLUSTER_INSTALL", obj);
                    bInstall = true;
                    if (this.m_oProgressListener != null) {
                        this.m_oProgressListener.setStatus(logText);
                    }
                    this.doComponentActions(vInstallIdOhList, iciesInstall, bInstall, remoteNodesArr);
                }
                OiiolTextLogger.appendText(logText, OiiolTextLogger.LOG_BASIC);
            }
        }
        catch (IOException e) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_IOEXCEPTION_DURING_CLUSTER_OPERATION"), OiiolTextLogger.LOG_BASIC);
        }
        catch (OiifbCancelException ce) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_CANCELEXCEPTION_DURING_CLUSTER_OPERATION"), OiiolTextLogger.LOG_BASIC);
        }
        catch (ClassNotFoundException fe) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_CNFEXCEPTION_DURING_CLUSTER_OPERATION"), OiiolTextLogger.LOG_BASIC);
        }
        catch (InstantiationException ie) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_INSTANTIATEEXCEPTION_DURING_CLUSTER_OPERATION"), OiiolTextLogger.LOG_BASIC);
        }
        catch (IllegalAccessException iae) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_ILLEGALACCESSEXCEPTION_DURING_CLUSTER_OPERATION"), OiiolTextLogger.LOG_BASIC);
        }
    }

    private OiiiInstallCompInvEntry[] getInstallInvEntries(Vector vIdOhList, boolean bInstall) throws IOException {
        OiiiInstallCompInvEntry[] icies = new OiiiInstallCompInvEntry[vIdOhList.size()];
        int numComps = vIdOhList.size();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        if (bInstall) {
            int i = numComps - 1;
            for (int j = 0; i >= 0 && j < numComps; --i, ++j) {
                icies[j] = (OiiiInstallCompInvEntry)vIdOhList.elementAt(i);
            }
        } else {
            for (int i = 0; i < numComps; ++i) {
                OiiiCompIdOhPair cIdOh = (OiiiCompIdOhPair)vIdOhList.elementAt(i);
                OiiiCompInstallID cid = cIdOh.getCompID();
                int compOhIndex = cIdOh.getOHIndex();
                icies[i] = instInv.getInstallCompInvEntry(cid, compOhIndex);
            }
        }
        return icies;
    }

    private void doComponentActions(Vector vIdOhList, OiiiInstallCompInvEntry[] icies, boolean bInstall, String[] remoteNodes) throws IOException, OiifbCancelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int numComps = vIdOhList.size();
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        Vector oracleHomes = instInv.getHomes();
        int nHomes = oracleHomes.size();
        OiisCompContext[] oCompContexts = new OiisCompContext[numComps];
        int[] iaPhases = OiiiInstallLogManipulator.getPhases(bInstall);
        int numPhases = iaPhases.length;
        boolean bIfFirstIterDone = false;
        OiiiVersion vSinglePhaseVer = OiiiInstallLogManipulator.getSinglePhaseVersion();
        for (int phaseNo = 0; phaseNo < numPhases; ++phaseNo) {
            if (phaseNo > 0) {
                bIfFirstIterDone = true;
            }
            for (int i = 0; i < numComps; ++i) {
                if (bIfFirstIterDone && vSinglePhaseVer.laterThan(icies[i].getInstallerVersion())) continue;
                String sDisplay = icies[i].getFullDisplayName();
                try {
                    Object[] args = new String[]{icies[i].getFullDisplayName()};
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_CLUSTER_INSTALLING", args), OiiolTextLogger.LOG_BASIC);
                    OiiiInstallCompInvEntry icie = icies[i];
                    OiisVariable oOH = this.m_instSession.getSessionContext().getVariable("ORACLE_HOME");
                    String ohLoc = (String)oOH.getValue();
                    if (icie == null) continue;
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("Component:" + icie);
                        OiiolTextLogger.appendText("Component OH index:" + icie.getOHIndex());
                    }
                    OiiiCompIdOhPair IdOh = new OiiiCompIdOhPair(icie.getCompInstallID(), icie.getOHIndex());
                    OiisCompContext oCompContext = null;
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("Creating comp context for:" + icie + ":idx = " + IdOh.getOHIndex() + ":icie idx = " + icie.getOHIndex() + ":install inv loc = " + icie.getLocationInXMLInventory(), OiiolTextLogger.LOG_DETAILED);
                    }
                    if (!bIfFirstIterDone) {
                        oCompContexts[i] = OiisCompContext.createContextFromInstallInv(icie, IdOh.getOHIndex());
                    }
                    oCompContext = oCompContexts[i];
                    oCompContext.setParContext(this.m_instSession.getSessionContext());
                    OiiiInstallLogManipulator installLogManip = new OiiiInstallLogManipulator(icie, IdOh, bInstall);
                    Vector installLogManips = installLogManip.getInstallLogManipulator(iaPhases[phaseNo]);
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("Log Manip object:" + installLogManips);
                    }
                    if (installLogManips == null) {
                        String logText = OiixResourceBundle.getString("") + " " + icie.getFullDisplayName() + OiixResourceBundle.getString("S_LOG_INVALID_INSTALL_LOG");
                        OiiolTextLogger.appendText(logText, OiiolTextLogger.LOG_BASIC);
                        continue;
                    }
                    if (bInstall && 8 == iaPhases[phaseNo]) {
                        OiilWinActionsClusterInstall winActionsInstall = new OiilWinActionsClusterInstall(remoteNodes);
                        winActionsInstall.runActions(icie.getCompInstallID(), oCompContext);
                    }
                    int nManips = installLogManips.size();
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("Log Manip object size:" + installLogManips.size());
                    }
                    int curPlatform = OiixPlatform.getCurrentPlatform();
                    for (int j = 0; j < nManips; ++j) {
                        OiiolLogManipulator oLog = (OiiolLogManipulator)installLogManips.elementAt(j);
                        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                            OiiolTextLogger.appendText("Using log manipulator:" + oLog.getLogFileName(), OiiolTextLogger.LOG_DETAILED);
                        }
                        Enumeration en = null;
                        Enumeration enumeration = en = bInstall ? oLog.getEntriesForInstall() : oLog.getEntriesForDeinstall();
                        while (en.hasMoreElements()) {
                            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                                OiiolTextLogger.appendText("Executing component logs", OiiolTextLogger.LOG_DETAILED);
                            }
                            Vector inputs = null;
                            Vector logObjects = null;
                            Object outLogObjects = null;
                            Object outBackupObjects = null;
                            OiiolActionLogEntry ale = (OiiolActionLogEntry)en.nextElement();
                            OiisActionLibLoader lLoader = this.m_instSession.getActionLibLoader(ale.getLibraryID(), IdOh.getOHIndex());
                            String actionName = ale.getActionName();
                            boolean installFlag = ale.getInstallFlag();
                            boolean deinstallFlag = ale.getDeinstallFlag();
                            OiilActionClusterOps action = lLoader.getClusterAction(actionName, curPlatform);
                            if (action == null) {
                                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) continue;
                                OiiolTextLogger.appendText("Action:" + actionName + " in library:" + ale.getLibraryID() + " does not implement OiilActionClusterOps. Ignoring the action.", OiiolTextLogger.LOG_DETAILED);
                                continue;
                            }
                            boolean retry = false;
                            do {
                                Object[] exargs;
                                Object[] exargs2;
                                String severity;
                                try {
                                    retry = false;
                                    inputs = ale.getInputsForDeinstall(oCompContext);
                                    OiilActionInputElement aie = new OiilActionInputElement("compIdOhPair", IdOh);
                                    aie.setImplicit(true);
                                    inputs.addElement(aie);
                                    inputs = OiilActionInputElement.addImplicitArg(inputs, this.m_instSession, "installSession");
                                    if (remoteNodes != null && remoteNodes.length > 0) {
                                        inputs = OiilActionInputElement.addImplicitArg(inputs, remoteNodes, "remoteNodes");
                                    }
                                    aie = new OiilActionInputElement("ProgressListener", this.m_oProgressListener);
                                    aie.setImplicit(true);
                                    inputs.add(aie);
                                    logObjects = ale.getLogObjects(oCompContext);
                                    OiisCompActions.toLog(ale.getLibraryID(), actionName, inputs);
                                    if (bInstall && installFlag) {
                                        action.clusterInstallAction(inputs, logObjects);
                                        continue;
                                    }
                                    if (bInstall || !deinstallFlag) continue;
                                    action.clusterDeinstallAction(inputs, logObjects);
                                }
                                catch (OiilActionException ae) {
                                    severity = String.valueOf(ae.getExceptionSeverity());
                                    exargs2 = new String[]{actionName, ae.getExceptionName(), ae.getExceptionString(), severity};
                                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35900", exargs2));
                                    OiiolTextLogger.appendException(ae);
                                    int button_ops = 0;
                                    button_ops = 0;
                                    button_ops |= 2;
                                    if (ae.getExceptionSeverity() != -1) {
                                        button_ops |= 4;
                                    }
                                    int userInput = 0;
                                    try {
                                        OiifbIRetry actionDlg = OiicSessionInterfaceManager.getInterfaceManager().getRetryHandler(ae.getMessage(), button_ops, 1);
                                        userInput = actionDlg.doModal();
                                        actionDlg = null;
                                        Thread.yield();
                                    }
                                    catch (Exception e) {
                                        OiiolTextLogger.appendException(e);
                                    }
                                    switch (userInput) {
                                        case 2: {
                                            retry = true;
                                            break;
                                        }
                                        case 4: {
                                            retry = false;
                                            break;
                                        }
                                        case 32: {
                                            throw new OiifbCancelException(ae.getMessage(), false);
                                        }
                                        case 16: {
                                            throw new OiifbCancelException(ae.getMessage(), true);
                                        }
                                    }
                                }
                                catch (OiilDeinstallException de) {
                                    severity = String.valueOf(de.getExceptionSeverity());
                                    exargs2 = new String[]{actionName, de.getExceptionName(), de.getExceptionString(), severity};
                                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35900", exargs2));
                                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                    OiiolTextLogger.appendException(de);
                                }
                                catch (InterruptedException ie) {
                                    exargs = new String[]{actionName};
                                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35901", exargs));
                                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                    OiiolTextLogger.appendException(ie);
                                }
                                catch (InvocationTargetException ie) {
                                    exargs = new String[]{actionName};
                                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35901", exargs));
                                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                                    OiiolTextLogger.appendException(ie);
                                }
                            } while (retry);
                        }
                    }
                    if (bInstall || 8 != iaPhases[phaseNo]) continue;
                    OiilWinActionsClusterDeinstall winActionsDeinstall = new OiilWinActionsClusterDeinstall(remoteNodes);
                    winActionsDeinstall.runActions(icie.getCompInstallID(), oCompContext);
                    continue;
                }
                catch (OiifbCancelException oce) {
                    if (oce.isCancelSession()) {
                        throw oce;
                    }
                    Object[] args = new String[]{sDisplay};
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("OUI-35206", args), OiiolTextLogger.LOG_BASIC);
                }
            }
        }
    }
}

