/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.osd.unix;

import java.util.Vector;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.osd.unix.OiipuFileSysTable;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;

public class OiipuFileSystemInformation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 262144;
    static Vector m_vTable = new Vector();
    static OiipuFileSysTable m_infoTable = null;

    public static void clearDiskInfo() {
        m_infoTable = null;
    }

    public static OiipuFileSysTable getFileSystemInfo() {
        if (m_infoTable == null) {
            OiipuFileSystemInformation.getInfo();
            m_infoTable = new OiipuFileSysTable(m_vTable);
            m_vTable = null;
        }
        return m_infoTable;
    }

    private static void getInfo() {
        m_vTable = new Vector();
        String[] volList = new String[]{};
        try {
            volList = OiipuUnixOps.ssGetVolList();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < volList.length; ++i) {
            Vector<Object> tabEntry = new Vector<Object>(3);
            OiipgFileSystem fileSys = new OiipgFileSystem();
            tabEntry.addElement(new String(volList[i]));
            tabEntry.addElement(new Long(fileSys.getVolumeTotalSpace(volList[i])));
            tabEntry.addElement(new Long(fileSys.getVolumeFreeSpace(volList[i])));
            m_vTable.addElement(tabEntry);
        }
    }

    public static void main(String[] args) {
        OiipuFileSystemInformation fsi = new OiipuFileSystemInformation();
        OiipuFileSysTable info = fsi.getFileSystemInfo();
        Vector list = info.getListOfFileSystems();
        for (int i = 0; i < list.size(); ++i) {
            System.out.println("****FILE SYSTEM IS : " + (String)list.elementAt(i));
            System.out.println("FILE SYSTEM TOTAL SPACE IS : " + info.getTotalSpace((String)list.elementAt(i)));
            System.out.println("FILE SYSTEM Free SPACE IS : " + info.getFreeSpace((String)list.elementAt(i)));
        }
    }
}

