/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiip.oiipg.OiipgRgsEntry;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiipgReadRGS {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 131072;
    String m_sFileName;
    Vector m_vRgsTable = new Vector();

    public void init(String oraHomePath) throws IOException {
        this.m_sFileName = this.getRgsFileName(oraHomePath);
    }

    public String getRgsFileName(String oraHome) {
        String osRgsName = "unknownPlat";
        Properties pp = System.getProperties();
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        block0 : switch (curPlatGroup) {
            case -1: {
                osRgsName = "unix.rgs";
                break;
            }
            case -3: {
                switch (curPlatId) {
                    case 912: {
                        osRgsName = "nt.rgs";
                        break block0;
                    }
                    case 50: 
                    case 615: {
                        osRgsName = "win95.rgs";
                        break block0;
                    }
                }
                break;
            }
        }
        oraHome = oraHome.replace('\\', '/');
        if (!oraHome.endsWith("/")) {
            oraHome = oraHome + "/";
        }
        String fileName = oraHome + "orainst/" + osRgsName;
        return OiixPathOps.getNativeForm(fileName);
    }

    public Vector getRgsTable() {
        return this.m_vRgsTable;
    }

    private void addOiipgRgsEntry(Vector rgsSplitLine) {
        OiipgRgsEntry rgsEntryObj = new OiipgRgsEntry();
        String tmp = (String)rgsSplitLine.elementAt(0);
        rgsEntryObj.setID(new Integer(tmp));
        rgsEntryObj.setName((String)rgsSplitLine.elementAt(1));
        rgsEntryObj.setParentRegistry((String)rgsSplitLine.elementAt(2));
        rgsEntryObj.setFileName((String)rgsSplitLine.elementAt(3));
        rgsEntryObj.setVersion((String)rgsSplitLine.elementAt(4));
        rgsEntryObj.setInterfaceLabel((String)rgsSplitLine.elementAt(5));
        rgsEntryObj.setSize(new Long((String)rgsSplitLine.elementAt(6)));
        rgsEntryObj.setRegDate((String)rgsSplitLine.elementAt(7));
        rgsEntryObj.setReferences((String)rgsSplitLine.elementAt(8));
        this.m_vRgsTable.addElement(rgsEntryObj);
    }

    public void doReadRgs() throws IOException {
        String rgsLine;
        FileInputStream inStream = new FileInputStream(new File(this.m_sFileName));
        InputStreamReader insReader = new InputStreamReader(inStream);
        BufferedReader rdr = new BufferedReader(insReader);
        while ((rgsLine = rdr.readLine()) != null) {
            Vector rgsEntries = this.splitRgsLine(rgsLine);
            this.addOiipgRgsEntry(rgsEntries);
            int len = rgsEntries.size();
            for (int i = 0; i < len; ++i) {
            }
        }
        rdr.close();
        insReader.close();
        inStream.close();
    }

    Vector splitRgsLine(String rgsLine) {
        Vector<String> entries = new Vector<String>();
        StringBuffer newEntry = null;
        rgsLine = rgsLine.trim();
        int len = rgsLine.length();
        boolean makingEntry = false;
        boolean isInQ = false;
        block4: for (int i = 0; i < len; ++i) {
            char ch = rgsLine.charAt(i);
            switch (ch) {
                case ' ': {
                    if (!makingEntry) continue block4;
                    if (isInQ) {
                        newEntry.append(ch);
                        continue block4;
                    }
                    makingEntry = false;
                    entries.addElement(newEntry.toString());
                    newEntry = null;
                    continue block4;
                }
                case '\"': {
                    if (!makingEntry) {
                        isInQ = true;
                        makingEntry = true;
                        newEntry = new StringBuffer();
                        newEntry.append(ch);
                        continue block4;
                    }
                    newEntry.append(ch);
                    isInQ = false;
                    makingEntry = false;
                    entries.addElement(newEntry.toString());
                    newEntry = null;
                    continue block4;
                }
                default: {
                    if (!makingEntry) {
                        makingEntry = true;
                        newEntry = new StringBuffer();
                        newEntry.append(ch);
                        continue block4;
                    }
                    newEntry.append(ch);
                }
            }
        }
        if (newEntry != null) {
            entries.addElement(newEntry.toString());
        }
        return entries;
    }

    public static void main(String[] args) {
        try {
            OiipgReadRGS rrgs = new OiipgReadRGS();
            rrgs.init("c:\\orant\\orainst\\nt.rgs");
            rrgs.doReadRgs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

