/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgMethodUnsupportedOnPlatformException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiipgEnvironment {
    private static String key = "HKEY_LOCAL_MACHINE";
    private static String subKey = "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";

    public static String getDisplayErrorDetails() {
        StringBuffer value = new StringBuffer("");
        Object[] asXClockLoc = new String[]{""};
        int nMessageList = 14;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -3: {
                break;
            }
            case -1: {
                for (int i = 1; i < 14; ++i) {
                    value.append(OiixResourceBundle.getString("S_ERR_DISPLAY_INCORRECT_" + i));
                }
                switch (curPlatId) {
                    case 453: {
                        asXClockLoc[0] = "/usr/openwin/bin/xclock";
                        break;
                    }
                    case 2: 
                    case 87: 
                    case 197: 
                    case 610: {
                        asXClockLoc[0] = "/usr/bin/X11/xclock";
                        break;
                    }
                    case 46: {
                        asXClockLoc[0] = "/usr/X11R6/bin/xclock";
                        break;
                    }
                }
                value.append(OiixResourceBundle.getString("S_ERR_DISPLAY_XCLOCK_LOC", asXClockLoc));
                break;
            }
        }
        return value.toString();
    }

    public static String getSystemEnvironment(String varName) {
        String value = "";
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        block1 : switch (curPlatGroup) {
            case -1: {
                break;
            }
            case -3: {
                switch (curPlatId) {
                    case 208: 
                    case 233: 
                    case 912: {
                        try {
                            value = OiipwWin32NativeCalls.RegGetValue(key, subKey, varName);
                        }
                        catch (OiilNativeException oiilNativeException) {}
                        break block1;
                    }
                }
                break;
            }
        }
        return value;
    }

    public static String getEnv(String varName) {
        String value = "";
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        block0 : switch (curPlatGroup) {
            case -1: {
                value = OiipuUnixOps.getenv(varName);
                break;
            }
            case -3: {
                switch (curPlatId) {
                    case 208: 
                    case 233: 
                    case 912: {
                        value = OiipwWin32NativeCalls.getenv(varName);
                        break block0;
                    }
                }
                break;
            }
        }
        return value;
    }

    public static void setEnv(String varName, String value, boolean bAppend, boolean bReplace) {
        String sExistingVal = OiipgEnvironment.getEnv(varName);
        String sNewVal = "";
        if (bAppend) {
            if (sExistingVal.length() > 0 && !sExistingVal.endsWith(";") && value.length() > 0) {
                sExistingVal = sExistingVal + ";";
            }
            sNewVal = sExistingVal + value;
        } else {
            sNewVal = bReplace ? value : value + ";" + sExistingVal;
        }
        OiipgEnvironment.setEnv(varName, sNewVal);
    }

    public static void setEnv(String varName, String value) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                String sEnv = varName + "=" + value;
                OiipuUnixOps.setenv(sEnv);
                break;
            }
            case -3: {
                OiipwWin32NativeCalls.PutEnv(varName, value);
                break;
            }
        }
    }

    public static void SendIniChangeMessage() {
        OiipwWin32NativeCalls.SendIniChangeMessage();
    }

    public static void setSystemEnvironment(String varName, String value) throws OiilNativeException {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        block0 : switch (curPlatGroup) {
            case -1: {
                break;
            }
            case -3: {
                switch (curPlatId) {
                    case 208: 
                    case 233: 
                    case 912: {
                        OiipwWin32NativeCalls.RegSetWideCharsetValue(key, subKey, varName, value, true, true, "");
                        String sExpValue = OiipwWin32NativeCalls.expandEnvironmentStrings(value);
                        OiipgEnvironment.setEnv(varName, sExpValue);
                        OiipwWin32NativeCalls.SendIniChangeMessage();
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public static String regGetValue(String sKey, String sSubKey, String Value) {
        String value = "";
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        block1 : switch (curPlatGroup) {
            case -1: {
                break;
            }
            case -3: {
                switch (curPlatId) {
                    case 208: 
                    case 233: 
                    case 912: {
                        try {
                            value = OiipwWin32NativeCalls.RegGetValue(key, subKey, Value);
                        }
                        catch (OiilNativeException oiilNativeException) {}
                        break block1;
                    }
                }
                break;
            }
        }
        return value;
    }

    public static String getCurrentWorkingDir() throws OiilNativeException {
        String value = "";
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                value = OiipuUnixOps.getCurrentWorkingDir();
                break;
            }
            case -3: {
                value = OiipwWin32NativeCalls.getCurrentWorkingDir();
            }
        }
        return value;
    }

    public static int changeDir(String dirName) throws OiilNativeException {
        int value = -1;
        int curPlatId = OiixPlatform.getCurrentPlatform();
        int curPlatGroup = OiixPlatform.getPlatGroup(curPlatId);
        switch (curPlatGroup) {
            case -1: {
                value = OiipuUnixOps.changeDir(dirName);
                break;
            }
            case -3: {
                value = OiipwWin32NativeCalls.changeDir(dirName);
            }
        }
        return value;
    }

    public static String[] getUnixGroups() {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.getUnixGroups();
        }
        Object[] args = new String[]{"getUnixGroups", "UNIX"};
        String message = OiixResourceBundle.getString("S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static String ssgetCurrentGroupOfUserux(String user) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.ssgetCurrentGroupOfUserux(user);
        }
        Object[] args = new String[]{"getCurrentGroupOfUser", "UNIX"};
        String message = OiixResourceBundle.getString("S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static int ssgetUidux() {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.ssgetUidux();
        }
        Object[] args = new String[]{"getUid", "UNIX"};
        String message = OiixResourceBundle.getString("S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static String ssgetUidNameux() {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.ssgetUidNameux();
        }
        Object[] args = new String[]{"getUidName", "UNIX"};
        String message = OiixResourceBundle.getString("S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static String ssgetCurrentActiveUserGroupux(String user) {
        int curPlatId = OiixPlatform.getCurrentPlatform();
        if (OiixPlatform.getPlatGroup(curPlatId) == -1) {
            return OiipuUnixOps.ssgetCurrentActiveUserGroupux(user);
        }
        Object[] args = new String[]{"getCurrentActiveUserGroup", "UNIX"};
        String message = OiixResourceBundle.getString("S_METHOD_UNSUPPORTED_ON_PLATOFRM_EXCEPTION", args);
        throw new OiipgMethodUnsupportedOnPlatformException(message);
    }

    public static void main(String[] argv) {
        System.out.println(argv[0] + " is " + OiipgEnvironment.getEnv(argv[0]));
    }
}

