/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.util.Vector;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterwareInfo;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiipgDetectCluster {
    private String[] m_nodeNames = null;
    private String m_localNodeName = null;
    private boolean m_bAlreadyChecked = false;
    private boolean m_bCluster = false;
    private OiipgClusterwareInfo m_clusterwareInfo = OiipgClusterwareInfo.getClusterwareInfo();
    private static OiipgDetectCluster s_detectCluster = null;

    private OiipgDetectCluster() {
    }

    public static OiipgDetectCluster getDetectCluster() {
        if (s_detectCluster == null) {
            s_detectCluster = new OiipgDetectCluster();
        }
        return s_detectCluster;
    }

    public boolean isCluster() {
        return this.isClusterImpl();
    }

    private boolean isClusterImpl() {
        if (this.m_clusterwareInfo != null && !this.m_bAlreadyChecked) {
            this.m_bCluster = this.m_clusterwareInfo.isCluster();
            this.m_bAlreadyChecked = true;
        }
        return this.m_bCluster;
    }

    public boolean isClusterMode() {
        boolean bCluster = false;
        if (OiipgDetectCluster.isClusterEnabled() && (Boolean.getBoolean("oracle.srvm.formCluster") || this.isCluster())) {
            bCluster = true;
        }
        return bCluster;
    }

    public static boolean isClusterEnabled() {
        return Boolean.getBoolean("oracle.installer.clusterEnabled");
    }

    public static void setClusterEnabled(boolean flag) {
        System.setProperty("oracle.installer.clusterEnabled", String.valueOf(flag));
        System.setProperty("oracle.installer.local", String.valueOf(!flag));
    }

    public static boolean checkCluster() {
        return true;
    }

    public String getSoftwareVersion(String sNodeName) {
        return this.m_clusterwareInfo.getSoftwareVersion(sNodeName);
    }

    public String getActiveVersion() {
        return this.m_clusterwareInfo.getActiveVersion();
    }

    public String[] getNodeNames() {
        if (this.m_clusterwareInfo != null && this.m_nodeNames == null) {
            String[] nodeNames = this.m_clusterwareInfo.getNodeNames();
            this.m_localNodeName = this.m_clusterwareInfo.getLocalNodeName();
            if (nodeNames != null && nodeNames.length > 0 && this.m_localNodeName != null) {
                for (int i = 0; i < nodeNames.length; ++i) {
                    if (!this.m_localNodeName.equalsIgnoreCase(nodeNames[i])) continue;
                    String temp = nodeNames[0];
                    nodeNames[0] = this.m_localNodeName;
                    nodeNames[i] = temp;
                    break;
                }
            }
            this.m_nodeNames = nodeNames;
        }
        return this.m_nodeNames;
    }

    public void setLocalNodeName(String localNode) {
        this.m_localNodeName = localNode;
    }

    public String getLocalNodeName() {
        if (this.m_localNodeName == null) {
            this.m_localNodeName = this.m_clusterwareInfo.getLocalNodeName();
        }
        return this.m_localNodeName;
    }

    public String[] getRemoteNodes() {
        boolean j = false;
        String[] remoteNodes = null;
        if (this.m_nodeNames != null && this.m_nodeNames.length > 1) {
            remoteNodes = new String[this.m_nodeNames.length - 1];
            for (int i = 0; i < this.m_nodeNames.length - 1; ++i) {
                remoteNodes[i] = this.m_nodeNames[i + 1];
            }
        }
        return remoteNodes;
    }

    public Vector getRemoteNodes(String[] clusterList) {
        Vector vRemoteNodes = new Vector();
        if (clusterList != null && clusterList.length > 0) {
            boolean j = false;
            if (!this.isCluster()) {
                String[] remoteNodes = new String[clusterList.length - 1];
                System.arraycopy(clusterList, 1, remoteNodes, 0, clusterList.length - 1);
                vRemoteNodes = OiixVectorOps.strArr2Vect(remoteNodes);
            } else {
                this.m_localNodeName = this.getLocalNodeName();
                if (this.m_localNodeName != null) {
                    for (int i = 0; i < clusterList.length; ++i) {
                        if (clusterList[i].equalsIgnoreCase(this.m_localNodeName)) continue;
                        vRemoteNodes.addElement(clusterList[i]);
                    }
                }
            }
        }
        return vRemoteNodes;
    }

    public String[] orderNodes(String[] clusterList) {
        Vector vOrderedList = this.orderNodes(OiixVectorOps.strArr2Vect(clusterList));
        return OiixVectorOps.vect2StrArr(vOrderedList);
    }

    public Vector orderNodes(Vector clusterList) {
        this.m_localNodeName = this.getLocalNodeName();
        if (clusterList != null && clusterList.size() > 0 && this.m_localNodeName != null) {
            int clusterListSize = clusterList.size();
            String[] clusterStrArr = new String[clusterListSize];
            clusterStrArr = OiixVectorOps.vect2StrArr(clusterList);
            for (int i = 0; i < clusterListSize; ++i) {
                if (!this.m_localNodeName.equalsIgnoreCase(clusterStrArr[i])) continue;
                String temp = clusterStrArr[0];
                clusterStrArr[0] = this.m_localNodeName;
                clusterStrArr[i] = temp;
                clusterList = OiixVectorOps.strArr2Vect(clusterStrArr);
                break;
            }
        }
        return clusterList;
    }

    public String getVirtualHostName(String sNodename) {
        return this.m_clusterwareInfo.getVirtualHostName(sNodename);
    }

    public String getPrivateNodeName(String sNodename) {
        return this.m_clusterwareInfo.getPrivateNodeName(sNodename);
    }

    public String getClusterName() {
        return this.m_clusterwareInfo.getClusterName();
    }

    public boolean isGNSConfiguredCluster() {
        return this.m_clusterwareInfo.isGNSConfigured();
    }

    public boolean isTBCluster() {
        return false;
    }

    public boolean isDependentOnASM(String dbUniqueName) {
        return this.m_clusterwareInfo.isDependentOnASM(dbUniqueName);
    }

    public boolean isDependentOnASM(String dbUniqueName, String nodeName) {
        return this.m_clusterwareInfo.isDependentOnASM(dbUniqueName, nodeName);
    }

    public String getScanName() {
        return this.m_clusterwareInfo.getScanName();
    }
}

