/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.util.Vector;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.scan.ScanFactory;
import oracle.sysman.oii.oiic.OiicSystemPropertyOps;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCRSClusterwareInfo;
import oracle.sysman.oii.oiip.oiipg.OiipgVendorClusterwareInfo;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public abstract class OiipgClusterwareInfo {
    private static OiipgClusterwareInfo s_oClusterwareInfo;
    protected String[] m_nodeNames = null;
    protected String m_localNodeName = null;

    private static void createClusterwareInfo() {
        boolean bClusterwareInfo = false;
        String sCRSLocation = OiicSystemPropertyOps.getCRSLocation();
        if (sCRSLocation != null) {
            s_oClusterwareInfo = new OiipgCRSClusterwareInfo(sCRSLocation);
            bClusterwareInfo = true;
        } else {
            String clusterwareInfoStr;
            String[] clusterwareInfo = OiixOraparam.getClusterwareInfo();
            if (clusterwareInfo == null && (clusterwareInfoStr = System.getProperty("oracle.installer.clusterware")) != null) {
                clusterwareInfo = OiixFunctionOps.explodeString(clusterwareInfoStr, ",");
            }
            if (clusterwareInfo != null) {
                bClusterwareInfo = true;
                if (clusterwareInfo.length != 2) {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1102"));
                    s_oClusterwareInfo = null;
                } else {
                    OiiiCompInstallID compID = OiipgClusterwareInfo.getCompInstallID(clusterwareInfo);
                    s_oClusterwareInfo = new OiipgCRSClusterwareInfo(compID);
                }
            }
        }
        boolean vendorClusterware = OiixOraparam.isVendorClusterware();
        if (!bClusterwareInfo || !s_oClusterwareInfo.isCluster() && vendorClusterware) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1103"));
            s_oClusterwareInfo = new OiipgVendorClusterwareInfo();
        }
    }

    public static OiipgClusterwareInfo getClusterwareInfo() {
        if (s_oClusterwareInfo == null) {
            OiipgClusterwareInfo.createClusterwareInfo();
        }
        return s_oClusterwareInfo;
    }

    public abstract boolean isCluster();

    protected abstract String getClusterwareLocation();

    String getSoftwareVersion(String sNodeName) {
        return null;
    }

    String getActiveVersion() {
        return null;
    }

    private static OiiiCompInstallID getCompInstallID(String[] clusterwareInfo) {
        Vector plats = OiixPlatform.getCurrentPlatformVector();
        OiiiVersion version = new OiiiVersion(clusterwareInfo[1]);
        return new OiiiCompInstallID(clusterwareInfo[0], version, plats, new OiiiVersion("0.0.0.0.0"), 1, 1, 0);
    }

    public String[] getNodeNames() {
        return this.m_nodeNames;
    }

    String getLocalNodeName() {
        return this.m_localNodeName;
    }

    public boolean isVendorClusterwarePresent() {
        OiipgVendorClusterwareInfo vcInfo = new OiipgVendorClusterwareInfo();
        return vcInfo.isCluster();
    }

    public String[] getVendorClusterwareNodes() {
        String[] vcNodes;
        OiipgVendorClusterwareInfo vcInfo = new OiipgVendorClusterwareInfo();
        String[] vcNodeList = null;
        if (vcInfo.isCluster() && (vcNodes = vcInfo.getNodeNames()) != null && vcNodes.length > 0) {
            vcNodeList = new String[vcNodes.length];
            System.arraycopy(vcNodes, 0, vcNodeList, 0, vcNodes.length);
        }
        return vcNodeList;
    }

    abstract String getPrivateNodeName(String var1);

    abstract String getVirtualHostName(String var1);

    public String getClusterName() {
        return null;
    }

    public boolean isGNSConfigured() {
        return false;
    }

    public boolean isDependentOnASM(String dbUniqueName) {
        return false;
    }

    public boolean isDependentOnASM(String dbUniqueName, String nodeName) {
        return false;
    }

    public String getScanName() {
        try {
            return ScanFactory.getInstance().getScan().getScanName();
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
            return null;
        }
    }

    public boolean isClusterDatabase(String dbUniqueName) {
        try {
            return DatabaseFactory.getInstance().getDatabase(dbUniqueName).isClusterDatabase();
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
            return false;
        }
    }
}

