/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.osd.win32.OiipwClusterWindowsOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiipgClusterRunCmd {
    private static ClusterCmd s_oClusterCmd = null;
    private Vector s_saAlreadyCopied = new Vector();
    private String[] m_nodeList = null;

    public OiipgClusterRunCmd(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    public OiipgClusterRunCmd() {
    }

    public static ClusterCmd getClusterCmdObj() {
        if (s_oClusterCmd == null) {
            s_oClusterCmd = new ClusterCmd();
        }
        return s_oClusterCmd;
    }

    public void setNodesToRun(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    private void runCmdOnWindows(String clsCmd, String[] nodeList, String serviceName) throws OiipgRemoteOpsException {
        Object[] args;
        block12: {
            block11: {
                String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
                args = new String[]{serviceName, sNodeList};
                try {
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35030", args), OiiolTextLogger.LOG_BASIC);
                    }
                    OiipwClusterWindowsOps.deleteServiceOnNodes(serviceName, nodeList);
                }
                catch (OiipgRemoteOpsException ce) {
                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) break block11;
                    OiiolTextLogger.appendException(ce);
                }
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35029", args), OiiolTextLogger.LOG_BASIC);
            }
            OiipwClusterWindowsOps.createServiceOnNodes(clsCmd, serviceName, 2, nodeList);
            try {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35027", args), OiiolTextLogger.LOG_BASIC);
                }
                OiipwClusterWindowsOps.startServiceOnNodes(serviceName, nodeList);
            }
            catch (OiipgRemoteOpsException ce) {
                // empty catch block
            }
            try {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35028", args), OiiolTextLogger.LOG_BASIC);
                }
                OiipwClusterWindowsOps.stopServiceOnNodes(serviceName, nodeList);
            }
            catch (OiipgRemoteOpsException ce) {
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) break block12;
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35026", args), OiiolTextLogger.LOG_DETAILED);
            }
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35030", args), OiiolTextLogger.LOG_BASIC);
        }
        OiipwClusterWindowsOps.deleteServiceOnNodes(serviceName, nodeList);
    }

    private void runCmdOnUnix(String clsCmd, String[] nodeList) throws OiipgRemoteOpsException {
        ClusterCmd cluster = new ClusterCmd();
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                String execStr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVOKE_REMOTE_OUI", nodeList);
                OiiolTextLogger.appendText(execStr, OiiolTextLogger.LOG_BASIC);
                OiiolTextLogger.appendText(clsCmd, OiiolTextLogger.LOG_BASIC);
            }
            cluster.runCmd(clsCmd, null, null, nodeList);
        }
        catch (ClusterException ce) {
            String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
            Object[] args = new String[]{clsCmd, sNodeList, ce.getMessage()};
            throw new OiipgRemoteOpsException("OUI-25014", OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25014", args), ce);
        }
    }

    public void runCmd(String cmd, String[] nodeList, String oracleHomeName, String currentNodeName) throws OiipgRemoteOpsException, OiipgRemoteFileOperationException {
        this.runCmd(cmd, nodeList, null, oracleHomeName, currentNodeName, true);
    }

    public void runCmd(String cmd, String[] nodeList, String oracleHome, String oracleHomeName, String currentNodeName, boolean bootstrap) throws OiipgRemoteOpsException, OiipgRemoteFileOperationException {
        if (nodeList == null || nodeList.length <= 0) {
            return;
        }
        if (System.getProperty("oracle.installer.oui_loc") != null) {
            String clsCmd = this.constructCmdStr(cmd, currentNodeName, oracleHome, bootstrap);
            String serviceNameIfWindows = "OracleOUI" + oracleHomeName + "Service";
            this.runAnyCmdOnNodes(clsCmd, nodeList, serviceNameIfWindows);
        }
    }

    public void runCmd(String cmd, String oracleHomeName, String currentNodeName) throws OiipgRemoteOpsException, OiipgRemoteFileOperationException {
        this.runCmd(cmd, this.m_nodeList, oracleHomeName, currentNodeName);
    }

    public void runAnyCmdOnNodes(String clsCmd, String[] nodeList, String desiredServiceName) throws OiipgRemoteOpsException {
        if (nodeList == null || nodeList.length <= 0 || clsCmd == null) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25015");
            throw new OiipgRemoteOpsException(sMsg);
        }
        String nodeListStr = OiixFunctionOps.implodeList(nodeList, ",");
        Object[] args = new String[]{clsCmd, nodeListStr};
        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1018", args));
        if (OiixInstallUtil.isUnix()) {
            this.runCmdOnUnix(clsCmd, nodeList);
        } else if (OiixInstallUtil.isWindows()) {
            if (desiredServiceName != null) {
                this.runCmdOnWindows(clsCmd, nodeList, desiredServiceName);
            } else {
                throw new OiipgRemoteOpsException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25013"));
            }
        }
    }

    private void bootstrapInstallerToNodes(String[] nodeList) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        if (!OiixInstallUtil.isAPIMode() && Boolean.getBoolean("oracle.installer.bootstrap") || OiixInstallUtil.isAPIMode() && !Boolean.getBoolean("oracle.installer.setCustomNodelist")) {
            Object[] args;
            Vector newNodeList = OiixVectorOps.arrayToVect(nodeList);
            Vector nodesToBootstrap = OiixVectorOps.subtract(newNodeList, this.s_saAlreadyCopied);
            if (nodesToBootstrap == null || nodesToBootstrap.size() == 0) {
                return;
            }
            String[] nodesToBootstrapArr = OiixVectorOps.list2StrArr(nodesToBootstrap);
            ClusterCmd clsCmd = OiipgClusterRunCmd.getClusterCmdObj();
            String dirName = System.getProperty("oracle.installer.scratchPath");
            if (OiixInstallUtil.isAPIMode() && OiixInstallUtil.isAddNodeMode()) {
                String homeLoc = System.getProperty("HOME_LOCATION_API");
                String srvmLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(homeLoc, "srvm"));
                String srvmLocNew = OiixPathOps.getNativeForm(OiixPathOps.concatPath(dirName, "srvm"));
                File srvmFile = new File(srvmLoc);
                File scratchSrvmFile = new File(srvmLocNew);
                if (srvmFile.exists()) {
                    try {
                        OiixFileOps.copyDir(srvmFile, scratchSrvmFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                clsCmd.transferDirToNodes(nodesToBootstrapArr, dirName, null);
                OiixVectorOps.unionInPlace(this.s_saAlreadyCopied, nodesToBootstrap);
            }
            catch (ClusterException ce) {
                args = new String[]{dirName, ce.getMessage()};
                OiipgClusterOps.throwRemoteOpsException("OUI-35031", args, ce);
            }
            catch (RemoteFileOperationException rfoe) {
                args = new String[]{dirName, rfoe.getMessage()};
                Vector nodesOK = new Vector();
                String exceptionMsg = OiipgClusterOps.constructOiipgRemoteFileOperationException("OUI-35031", (String[])args, rfoe, nodesToBootstrapArr, nodesOK);
                OiixVectorOps.unionInPlace(this.s_saAlreadyCopied, nodesOK);
                throw new OiipgRemoteFileOperationException(exceptionMsg, rfoe);
            }
        }
    }

    public void dispose() {
        if (this.s_saAlreadyCopied.size() > 0) {
            String dirName = System.getProperty("oracle.installer.scratchPath");
            ClusterCmd clsCmd = OiipgClusterRunCmd.getClusterCmdObj();
            String[] nodesToClean = OiixVectorOps.list2StrArr(this.s_saAlreadyCopied);
            this.s_saAlreadyCopied.removeAllElements();
            this.s_saAlreadyCopied = null;
            try {
                clsCmd.removeDirectory(nodesToClean, dirName, true);
            }
            catch (ClusterException ce) {
                OiiolTextLogger.appendException(ce);
            }
        }
        s_oClusterCmd = null;
    }

    private String constructCmdStr(String cmd, String currentNode, String oracleHome, boolean bootstrap) {
        String loglevel;
        String sOUILoc = bootstrap ? System.getProperty("oracle.installer.oui_loc") : OiixPathOps.concatPath(oracleHome, "oui");
        String sClusterParamFile = OiixPathOps.concatPath(sOUILoc, "clusterparam.ini");
        sOUILoc = OiixPathOps.concatPath(sOUILoc, "bin");
        sOUILoc = OiixInstallUtil.getOUILoc(sOUILoc);
        String jreArg = " ";
        if (bootstrap && (OiixInstallUtil.isAPIMode() || OiixInstallUtil.isOptionSet("oracle.installer.bootstrap"))) {
            jreArg = " -jreLoc " + System.getProperty("oracle.installer.jre_loc");
        }
        String clsCmd = sOUILoc.concat(jreArg);
        clsCmd = clsCmd + " -paramFile " + sClusterParamFile + "  -silent -ignoreSysPrereqs " + cmd;
        clsCmd = clsCmd + " -remoteInvocation -invokingNodeName " + currentNode + " -logFilePath " + "\"" + OiiolTextLogger.getLogDir() + "\"" + " -timestamp " + OiixUtilityOps.getSessionTimeStamp();
        if (OiixInstallUtil.isOptionSet("oracle.installer.debug")) {
            clsCmd = clsCmd + " -debug";
        }
        if ((loglevel = System.getProperty("oracle.installer.logLevel")) != null) {
            clsCmd = clsCmd + " -loglevel " + loglevel;
        }
        if (OiixInstallUtil.isOptionSet("oracle.installer.doNotUpdateNodeList")) {
            clsCmd = clsCmd + " -doNotUpdateNodeList ";
        }
        return clsCmd;
    }
}

