/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.cluster.RemoveListedFilesException;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgNodeStatus;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoveListedFilesException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiipgClusterOps {
    private static Map s_oUnSuccessfulDirRemovalCache = null;
    private static String S_LINE_SEPERATOR = "----------------------------------------------------------------------------------\n";
    private static String S_NEWLINE_AND_SPACES = "\n    ";

    public static void copyFileToNode(String fileName, String node, String destination) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Copy file to node:" + fileName + ":" + node + ":" + destination + ":" + new File(fileName).exists());
            }
            OiipgClusterRunCmd.getClusterCmdObj().copyFileToNode(fileName, node, destination);
        }
        catch (ClusterException e) {
            String str = "***Unable to copy file to node (" + e.getMessage() + "):" + fileName + ":" + node + ":" + destination + ":" + new File(fileName).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    public static void copyFileToNodes(String fileName, String[] nodeList) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Copy file to nodes:" + fileName + ":" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + new File(fileName).exists());
            }
            OiipgClusterRunCmd.getClusterCmdObj().copyFileToNodes(fileName, nodeList);
        }
        catch (ClusterException e) {
            String str = "***Unable to copy file to nodes (" + e.getMessage() + "):" + fileName + ":" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + new File(fileName).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    public static void copyFileToNodes(String[] nodes, String src, String dest) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Copy file to nodes:" + src + ":" + OiixFunctionOps.implodeList(nodes, ",") + ":" + OiixUtil.isFileExists(src));
            }
            OiipgClusterRunCmd.getClusterCmdObj().copyFileToNodes(src, nodes, dest);
        }
        catch (ClusterException e) {
            String str = "***Unable to copy file to node (" + e.getMessage() + "):" + src + ":" + OiixFunctionOps.implodeList(nodes, ",") + ":" + dest + ":" + OiixUtil.isFileExists(src);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            OiiolTextLogger.appendException(e);
        }
    }

    public static void createDirInNodes(String[] nodeList, String dirName) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***Create dir in nodes:" + dirName + ":" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + new File(dirName).exists());
            }
            OiipgClusterRunCmd.getClusterCmdObj().createDirInNodes(nodeList, dirName);
        }
        catch (ClusterException e) {
            String str = "***Unable to create dir in nodes (" + e.getMessage() + "):" + dirName + ":" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + new File(dirName).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    public static void removeFileFromNodes(String[] nodeList, String fileName) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***remove file from nodes:" + fileName + ":" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + new File(fileName).exists());
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeFileFromNodes(nodeList, fileName);
        }
        catch (ClusterException e) {
            String str = "***Unable to remove file from nodes (" + e.getMessage() + "):" + fileName + ":" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + new File(fileName).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    public static void createDirInNode(String nodeName, String dirName) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***create dir in node:" + dirName + ":" + nodeName + ":" + new File(dirName).exists());
            }
            OiipgClusterRunCmd.getClusterCmdObj().createDirInNode(nodeName, dirName);
        }
        catch (ClusterException e) {
            String str = "***Unable to create dir in node (" + e.getMessage() + "):" + dirName + ":" + nodeName + ":" + new File(dirName).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    public static void removeFileFromNode(String nodeName, String fileName) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***remove file from node:" + fileName + ":" + nodeName + ":" + new File(fileName).exists());
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeFileFromNode(nodeName, fileName);
        }
        catch (ClusterException e) {
            String str = "***Unable to remove file from node (" + e.getMessage() + "):" + fileName + ":" + nodeName + ":" + new File(fileName).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    public static void removeDirFromNode(String nodeName, String dirName) {
        OiipgClusterOps.removeDirFromNode(nodeName, dirName, true);
    }

    public static void removeDirFromNode(String nodeName, String dirName, boolean bCache) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***remove dir from node:" + dirName + ":" + nodeName + ":" + new File(dirName).exists());
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeDirectory(nodeName, dirName);
        }
        catch (ClusterException e) {
            if (bCache) {
                OiipgClusterOps.addToUnsuccessfulDirRemovalCache(nodeName, dirName);
            }
            String str = "***Unable to remove dir from node (" + e.getMessage() + "):" + dirName + ":" + nodeName + ":" + new File(dirName).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    private static void addToUnsuccessfulDirRemovalCache(Object nodeName, String dirName) {
        ArrayList<String> oDirList;
        if (s_oUnSuccessfulDirRemovalCache == null) {
            s_oUnSuccessfulDirRemovalCache = new HashMap();
        }
        if ((oDirList = (ArrayList<String>)s_oUnSuccessfulDirRemovalCache.get(nodeName)) == null) {
            oDirList = new ArrayList<String>();
        }
        oDirList.add(dirName);
        s_oUnSuccessfulDirRemovalCache.put(nodeName, oDirList);
    }

    public static void removeCachedDirsFromNodes() {
        Iterator oNodes;
        Set oNodesSet;
        if (s_oUnSuccessfulDirRemovalCache != null && (oNodesSet = s_oUnSuccessfulDirRemovalCache.keySet()) != null && (oNodes = oNodesSet.iterator()) != null) {
            while (oNodes.hasNext()) {
                Object oNodeName = oNodes.next();
                List oDirList = (List)s_oUnSuccessfulDirRemovalCache.get(oNodeName);
                if (oDirList == null) continue;
                int nCnt = oDirList.size();
                for (int i = 0; i < nCnt; ++i) {
                    if (oNodeName instanceof String) {
                        OiipgClusterOps.removeDirFromNode((String)oNodeName, (String)oDirList.get(i), false);
                        continue;
                    }
                    OiipgClusterOps.removeDirFromNodes((String[])oNodeName, (String)oDirList.get(i), false);
                }
                oDirList.clear();
            }
            s_oUnSuccessfulDirRemovalCache.clear();
            s_oUnSuccessfulDirRemovalCache = null;
        }
    }

    public static void removeDirFromNodes(String[] nodeNames, String dirName) {
        OiipgClusterOps.removeDirFromNodes(nodeNames, dirName, true);
    }

    public static void removeDirFromNodes(String[] nodeNames, String dirName, boolean bCache) {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***remove dir from nodes:" + dirName + ":" + OiixFunctionOps.implodeList(nodeNames, ",") + ":" + new File(dirName).exists());
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeDirectory(nodeNames, dirName);
        }
        catch (ClusterException e) {
            if (bCache) {
                OiipgClusterOps.addToUnsuccessfulDirRemovalCache(nodeNames, dirName);
            }
            String str = "***Unable to remove dir from nodes (" + e.getMessage() + "):" + dirName + ":" + OiixFunctionOps.implodeList(nodeNames, ",") + ":" + new File(dirName).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    public static void moveFilesOnNode(String source, String destination, String[] nodeList) {
        try {
            for (int i = 0; i < nodeList.length; ++i) {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                    OiiolTextLogger.appendText("***move file on nodes :" + source + ":" + destination + ":" + nodeList[i] + ":" + new File(destination).exists());
                }
                OiipgClusterRunCmd.getClusterCmdObj().moveFilesOnNode(nodeList[i], source, destination);
            }
        }
        catch (ClusterException e) {
            String str = "***Unable to move file on nodes (" + e.getMessage() + "):" + source + ":" + destination + ":" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + new File(destination).exists();
            OiiolTextLogger.appendText(str);
            OiiolTextLogger.appendErrorText(str, OiiolTextLogger.LOG_WITHOUT_LEVEL);
            e.printStackTrace();
        }
    }

    public static String getHostName(String sNodeName) throws OiipgClusterException {
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("***getHostName:" + sNodeName, OiiolTextLogger.LOG_DETAILED);
            }
            return ClusterInfo.getHostName((String)sNodeName, (Version)new Version());
        }
        catch (ClusterInfoException e) {
            Object[] args = new String[]{sNodeName, e.getMessage()};
            throw new OiipgClusterException("OUI-35080", OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35080", args), e);
        }
    }

    public static String[] getHostNamesEx(String[] nodeNames) throws OiipgClusterException {
        String[] hostNames = null;
        if (nodeNames != null && nodeNames.length > 0) {
            hostNames = new String[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                hostNames[i] = OiipgClusterOps.getHostName(nodeNames[i]);
            }
        }
        return hostNames;
    }

    public static String[] getHostNames(String[] nodeNames) throws ClusterInfoException {
        String[] hostNames = null;
        if (nodeNames != null && nodeNames.length > 0) {
            hostNames = new String[nodeNames.length];
            for (int i = 0; i < nodeNames.length; ++i) {
                hostNames[i] = ClusterInfo.getHostName((String)nodeNames[i], (Version)new Version());
            }
        }
        return hostNames;
    }

    public static void copyLogsToCallingNode(String calledNodeName, String sourceAbsoluteFilePath) throws OiipgRemoteOpsException {
        String callingNodeName = System.getProperty("oracle.installer.invokingNodeName");
        String destinationDir = System.getProperty("oracle.installer.logFilePath");
        if (sourceAbsoluteFilePath == null || callingNodeName == null || destinationDir == null) {
            throw new OiipgRemoteOpsException("OUI-35034", OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35034"));
        }
        String sourceStandardFilePath = OiixPathOps.getStandardForm(sourceAbsoluteFilePath);
        String destinationStandardDir = OiixPathOps.getStandardForm(destinationDir);
        destinationStandardDir = OiixPathOps.directorify(destinationStandardDir);
        String sourceDir = OiixPathOps.getParentDir(sourceStandardFilePath);
        String sourceFileName = OiixPathOps.getFileName(sourceStandardFilePath);
        if (sourceDir == null || sourceFileName == null) {
            throw new OiipgRemoteOpsException("OUI-35034", OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35034"));
        }
        sourceDir = OiixPathOps.directorify(sourceDir);
        String destinationAbsoluteFilePath = OiixPathOps.getNativeForm(destinationStandardDir) + sourceFileName + "." + calledNodeName;
        OiipgClusterOps.transferFileToNode(sourceAbsoluteFilePath, callingNodeName, destinationAbsoluteFilePath);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Copied file " + sourceDir + sourceFileName, OiiolTextLogger.LOG_TRACE);
        }
    }

    public static void createDirOnNodes(String[] nodeNames, String pathname) throws OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{pathname, nodeNamesStr};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1009", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().createDirInNodes(nodeNames, pathname);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1010"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{pathname, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35110", errorArgs, ce);
        }
    }

    public static void createDirOnNode(String nodeName, String pathname) throws OiipgRemoteOpsException {
        Object[] args = new String[]{pathname, nodeName};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1008", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().createDirInNode(nodeName, pathname);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1007"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{pathname, nodeName, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35115", errorArgs, ce);
        }
    }

    public static void createDirOnNodesWithPermission(String[] nodes, String dir, String permission) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        try {
            OiipgClusterRunCmd.getClusterCmdObj().createDirWithPermissionsOnNodes(nodes, dir, permission);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{dir, OiixFunctionOps.implodeList(nodes, ","), ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35115", errorArgs, ce);
        }
    }

    public static void createDirOnNodeWithPermission(String nodeName, String baseDir, String mode) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String[] nodes = new String[]{nodeName};
        try {
            OiipgClusterRunCmd.getClusterCmdObj().createDirWithPermissionsOnNodes(nodes, baseDir, mode);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{baseDir, nodeName, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35115", errorArgs, ce);
        }
    }

    public static void transferDirToNodes(String[] nodeNames, String pathname, String excludeListFile) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{pathname, excludeListFile, nodeNamesStr};
        try {
            File oExcludeListFile;
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35035", args), OiiolTextLogger.LOG_DETAILED);
            }
            if (!(excludeListFile == null || (oExcludeListFile = new File(excludeListFile)).exists() && oExcludeListFile.length() != 0L)) {
                OiiolTextLogger.appendText("Exclude file list " + excludeListFile + " does not exist or is empty. The file is ignored.");
                excludeListFile = null;
            }
            OiipgClusterRunCmd.getClusterCmdObj().transferDirToNodes(nodeNames, pathname, excludeListFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35036"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{pathname, excludeListFile, nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35003", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{pathname, excludeListFile, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35003", errorArgs, ce);
        }
    }

    public static void transferListedFilesToNode(String nodeName, String baseDir, String copyListFile) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, baseDir, copyListFile};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35037", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().transferListedFilesToNode(nodeName, baseDir, copyListFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35038"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] nodeNames = new String[]{nodeName};
            String[] errorArgs = new String[]{nodeName, baseDir, copyListFile, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35004", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, baseDir, copyListFile, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35004", errorArgs, ce);
        }
    }

    public static void transferListedDirsToNode(String nodeName, String baseDir, String copyListFile, String excludeListFile) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, baseDir, copyListFile, excludeListFile};
        try {
            File oExcludeListFile;
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35039", args), OiiolTextLogger.LOG_DETAILED);
            }
            if (!(excludeListFile == null || (oExcludeListFile = new File(excludeListFile)).exists() && oExcludeListFile.length() != 0L)) {
                OiiolTextLogger.appendText("Exclude file list " + excludeListFile + " does not exist or is empty. The file is ignored.");
                excludeListFile = null;
            }
            OiipgClusterRunCmd.getClusterCmdObj().transferListedDirsToNode(nodeName, baseDir, copyListFile, excludeListFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35040"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] nodeNames = new String[]{nodeName};
            String[] errorArgs = new String[]{nodeName, baseDir, copyListFile, excludeListFile, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35015", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, baseDir, copyListFile, excludeListFile, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35015", errorArgs, ce);
        }
    }

    public static void transferListedDirsToNodes(String[] nodeNames, String baseDir, String copyListFile, String excludeListFile) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{baseDir, copyListFile, excludeListFile, nodeNamesStr};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35041", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().transferListedDirsToNodes(nodeNames, baseDir, copyListFile, excludeListFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35042"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{baseDir, copyListFile, excludeListFile, nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35016", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{baseDir, copyListFile, excludeListFile, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35016", errorArgs, ce);
        }
    }

    public static void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDir) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(remoteNodeNames, ",");
        String destinationDirs = OiixFunctionOps.implodeList(remoteNodeDestDir, ",");
        Object[] args = new String[]{oracleHome, nodeNamesStr, topLevelDir, includeListFile, String.valueOf(includePathnamesCanBeRegex), excludeListFile, String.valueOf(excludePathnamesCanBeRegex), remoteNodeTempDir, destinationDirs};
        try {
            File oExcludeListFile;
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35069", args), OiiolTextLogger.LOG_DETAILED);
            }
            if (!(excludeListFile == null || (oExcludeListFile = new File(excludeListFile)).exists() && oExcludeListFile.length() != 0L)) {
                OiiolTextLogger.appendText("Exclude file list " + excludeListFile + " does not exist or is empty. The file is ignored.");
                excludeListFile = null;
            }
            OiipgClusterRunCmd.getClusterCmdObj().transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDir);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35070"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{oracleHome, excludeListFile, nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35003", errorArgs, rfoe, remoteNodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{oracleHome, excludeListFile, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35003", errorArgs, ce);
        }
    }

    public static void transferListedFilesToNodes(String[] nodeNames, String baseDir, String copyListFile) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{baseDir, copyListFile, nodeNamesStr};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35043", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().transferListedFilesToNodes(nodeNames, baseDir, copyListFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35038"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{baseDir, copyListFile, nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35005", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{baseDir, copyListFile, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35005", errorArgs, ce);
        }
    }

    public static void transferFileToNode(String sourcePath, String nodeName, String destinationPath) throws OiipgRemoteOpsException {
        Object[] args = new String[]{sourcePath, nodeName, destinationPath};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35045", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().copyFileToNode(sourcePath, nodeName, destinationPath);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35046"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (ClusterException e) {
            Object[] errorArgs = new String[]{sourcePath, nodeName, destinationPath, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35024", errorArgs, e);
        }
    }

    public static void removeFileOnNode(String nodeName, String destinationPath) throws OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, destinationPath};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1004", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeFileFromNode(nodeName, destinationPath);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1005"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (ClusterException e) {
            Object[] errorArgs = new String[]{nodeName, destinationPath, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35112", errorArgs, e);
        }
    }

    public static void removeFileOnNodes(String[] nodeNames, String destinationPath) throws OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{nodeNamesStr, destinationPath};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1011", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeFileFromNodes(nodeNames, destinationPath);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1006"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (ClusterException e) {
            Object[] errorArgs = new String[]{nodeNamesStr, destinationPath, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35111", errorArgs, e);
        }
    }

    public static void removeDirOnNode(String nodeName, String destinationPath) throws OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, destinationPath};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1001", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeDirectory(nodeName, destinationPath);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1000"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (ClusterException e) {
            Object[] errorArgs = new String[]{nodeName, destinationPath, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35114", errorArgs, e);
        }
    }

    public static void removeDirOnNodes(String[] nodeNames, String destinationPath) throws OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{nodeNamesStr, destinationPath};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1003", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeDirectory(nodeNames, destinationPath);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1002"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (ClusterException e) {
            Object[] errorArgs = new String[]{nodeNamesStr, destinationPath, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35113", errorArgs, e);
        }
    }

    public static void transferFileToNodes(String[] nodeNames, String sourceFile, String baseDir) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{sourceFile, baseDir, nodeNamesStr};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35047", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().transferFileToNodes(nodeNames, baseDir, sourceFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35048"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{sourceFile, baseDir, nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35006", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{sourceFile, baseDir, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35006", errorArgs, ce);
        }
    }

    public static void createPathInNodes(String[] nodeNames, String pathName, String baseDir) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{pathName, baseDir, nodeNamesStr};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35049", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().createPathInNodes(nodeNames, pathName, baseDir);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35050"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{pathName, baseDir, nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35007", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{pathName, baseDir, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35007", errorArgs, ce);
        }
    }

    public static void createListedDirsOnNode(String nodeName, String createListFile, String baseDir) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, createListFile, baseDir};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35051", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().createListedDirsOnNode(nodeName, createListFile, baseDir);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35052"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] nodeNames = new String[]{nodeName};
            String[] errorArgs = new String[]{nodeName, createListFile, baseDir, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35008", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            OiipgClusterOps.throwRemoteOpsException("OUI-35008", args, ce);
        }
    }

    public static void createListedDirsOnNodes(String[] nodeNames, String createListFile, String baseDir) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{createListFile, baseDir, nodeNamesStr};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35065", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().createListedDirsOnNodes(nodeNames, createListFile, baseDir);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("OIIPG-35066", "oracle.sysman.oii.oiir.OiirRuntimeRes"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{createListFile, baseDir, nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35011", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{createListFile, baseDir, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35011", errorArgs, ce);
        }
    }

    public static boolean removeListedFilesFromNodes(String[] nodeList, String removeListFile) throws OiipgRemoveListedFilesException {
        ArrayList<String> nodesFailed = new ArrayList<String>();
        ArrayList<OiipgNodeStatus> nodeStatusList = new ArrayList<OiipgNodeStatus>();
        for (int i = 0; i < nodeList.length; ++i) {
            OiipgNodeStatus nodeStatus;
            try {
                OiipgClusterOps.removeListedFilesFromNode(nodeList[i], removeListFile);
                OiipgNodeStatus nodeStatus2 = new OiipgNodeStatus(nodeList[i], 1, null);
                nodeStatusList.add(nodeStatus2);
                continue;
            }
            catch (IOException e) {
                nodesFailed.add(nodeList[i]);
                nodeStatus = new OiipgNodeStatus(nodeList[i], 2, e);
                nodeStatusList.add(nodeStatus);
                continue;
            }
            catch (OiipgRemoteOpsException e) {
                nodesFailed.add(nodeList[i]);
                nodeStatus = new OiipgNodeStatus(nodeList[i], 2, e);
                nodeStatusList.add(nodeStatus);
            }
        }
        if (nodesFailed.size() > 0) {
            String[] sampleArray = new String[nodesFailed.size()];
            sampleArray = nodesFailed.toArray(sampleArray);
            Object[] args = new String[]{OiixFunctionOps.implodeList(sampleArray, ","), removeListFile};
            String basicMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35085", args);
            String briefMessage = OiipgClusterOps.constructBriefMessageOiipgRemoveListedFilesException(basicMessage, nodeStatusList);
            throw new OiipgRemoveListedFilesException(basicMessage, briefMessage, nodeStatusList);
        }
        return true;
    }

    public static boolean removeListedFilesFromNode(String nodeName, String removeListFile) throws OiipgRemoteOpsException, IOException {
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -3) {
            return OiipgClusterOps.removeListedFilesFromNodeW32(nodeName, removeListFile);
        }
        Object[] args = new String[]{nodeName, removeListFile};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35067", args), OiiolTextLogger.LOG_DETAILED);
            }
            boolean cmdResult = OiipgClusterRunCmd.getClusterCmdObj().removeListedFilesFromNode(nodeName, removeListFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35068"), OiiolTextLogger.LOG_DETAILED);
            }
            return cmdResult;
        }
        catch (RemoteShellException ce) {
            Object[] errorArgs = new String[]{nodeName, removeListFile, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35017", errorArgs, ce);
        }
        catch (RemoveListedFilesException ce) {
            Object[] errorArgs = new String[]{nodeName, removeListFile, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35017", errorArgs, ce);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, removeListFile, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35017", errorArgs, ce);
        }
        return false;
    }

    private static boolean removeListedFilesFromNodeW32(String nodeName, String removeListFile) throws OiipgRemoteOpsException, IOException {
        File rmFile;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("Calling removeListedFilesFromNode for windows on Node: " + nodeName, OiiolTextLogger.LOG_DETAILED);
        }
        if (!(rmFile = new File(removeListFile)).exists()) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("Remove File list " + removeListFile + " does not exist. Remove File operations not performed on remote node.", OiiolTextLogger.LOG_DETAILED);
            }
            return false;
        }
        BufferedReader removeFileReader = null;
        ArrayList<String> unremovedFiles = new ArrayList<String>();
        removeFileReader = new BufferedReader(new FileReader(removeListFile));
        String fileName = null;
        while ((fileName = removeFileReader.readLine()) != null) {
            try {
                OiipgClusterOps.removeFileOnNode(nodeName, fileName);
            }
            catch (OiipgRemoteOpsException e) {
                boolean bExists = true;
                try {
                    bExists = OiipgClusterOps.fileExistsOnNode(nodeName, fileName);
                }
                catch (OiipgRemoteOpsException oiipgRemoteOpsException) {
                    // empty catch block
                }
                if (!bExists) continue;
                OiiolTextLogger.appendText(e.getMessage());
                unremovedFiles.add(fileName);
            }
        }
        try {
            removeFileReader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (unremovedFiles != null && unremovedFiles.size() > 0) {
            String[] unrmedFiles = OiixVectorOps.list2StrArr(unremovedFiles);
            String unrmedFilesStr = OiixFunctionOps.implodeList(unrmedFiles, "\n");
            Object[] args = new String[]{nodeName, unrmedFilesStr};
            String resId = "OUI-35205";
            throw new OiipgRemoteOpsException(resId, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", resId, args));
        }
        return true;
    }

    public static void removeListedDirsFromNode(String nodeName, String removeListFile) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, removeListFile};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35055", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeListedDirsFromNode(nodeName, removeListFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35056"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{nodeName, removeListFile, rfoe.getMessage()};
            String[] nodeNames = new String[]{nodeName};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35012", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, removeListFile, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35012", errorArgs, ce);
        }
    }

    public static void removeListedDirsFromNodes(String[] nodeNames, String removeListFile) throws OiipgRemoteFileOperationException, OiipgRemoteOpsException {
        String nodeNamesStr = OiixFunctionOps.implodeList(nodeNames, ",");
        Object[] args = new String[]{removeListFile, nodeNamesStr};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35057", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeListedDirsFromNodes(nodeNames, removeListFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35058"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{removeListFile, nodeNamesStr, rfoe.getMessage()};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35009", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{removeListFile, nodeNamesStr, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35009", errorArgs, ce);
        }
    }

    public static boolean fileExistsOnNode(String nodeName, String fileName) throws OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, fileName};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35059", args), OiiolTextLogger.LOG_DETAILED);
            }
            boolean cmdResult = Cluster.isExists((String)nodeName, (String)fileName);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35060"), OiiolTextLogger.LOG_DETAILED);
            }
            return cmdResult;
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, fileName, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35010", errorArgs, ce);
            return false;
        }
    }

    public static long getFreeSpaceOnNode(String nodeName, String path) throws OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, path};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35061", args), OiiolTextLogger.LOG_DETAILED);
            }
            long cmdResult = OiipgClusterRunCmd.getClusterCmdObj().getFreeSpace(nodeName, path);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35062"), OiiolTextLogger.LOG_DETAILED);
            }
            return cmdResult;
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, path, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35013", errorArgs, ce);
            return 0L;
        }
    }

    public static boolean isDirWritableOnNode(String nodeName, String dir) throws OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, dir};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35063", args), OiiolTextLogger.LOG_DETAILED);
            }
            boolean cmdResult = OiipgClusterRunCmd.getClusterCmdObj().isDirWritable(nodeName, dir);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-35064"), OiiolTextLogger.LOG_DETAILED);
            }
            return cmdResult;
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, dir, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35014", errorArgs, ce);
            return false;
        }
    }

    public static String[] listDirectory(String nodeName, String dirName) throws OiipgRemoteOpsException {
        Object[] args = new String[]{nodeName, dirName};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1015", args), OiiolTextLogger.LOG_DETAILED);
            }
            String[] dirContents = OiipgClusterRunCmd.getClusterCmdObj().listDirectory(nodeName, dirName);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1014"), OiiolTextLogger.LOG_DETAILED);
            }
            return dirContents;
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, dirName, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35082", errorArgs, ce);
            return null;
        }
    }

    public static void transferFileFromNode(String sourceNode, String sourceFile, String destFile) throws OiipgRemoteOpsException {
        Object[] args = new String[]{sourceNode, sourceFile, destFile};
        try {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1012", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().copyFileFromNode(sourceNode, sourceFile, destFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1013"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{sourceNode, sourceFile, destFile, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35081", errorArgs, ce);
        }
    }

    public static void removeDirectoryFromNode(String nodeName, String dir, String scratchPath) throws OiipgRemoteOpsException, OiipgRemoteFileOperationException {
        Object[] args = new String[]{nodeName, dir};
        try {
            scratchPath = OiixPathOps.getStandardForm(scratchPath);
            scratchPath = scratchPath + '/';
            String newFile = scratchPath + "removeInvDir" + OiixUtilityOps.getTimeStamp();
            OiixFileOps.appendLine(newFile, dir);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1016", args), OiiolTextLogger.LOG_DETAILED);
            }
            OiipgClusterRunCmd.getClusterCmdObj().removeListedDirsFromNode(nodeName, newFile);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG-1017"), OiiolTextLogger.LOG_DETAILED);
            }
        }
        catch (RemoteFileOperationException rfoe) {
            String[] errorArgs = new String[]{nodeName, dir, rfoe.getMessage()};
            String[] nodeNames = new String[]{nodeName};
            OiipgClusterOps.throwOiipgRemoteFileOperationException("OUI-35113", errorArgs, rfoe, nodeNames, null);
        }
        catch (ClusterException ce) {
            Object[] errorArgs = new String[]{nodeName, dir, ce.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35113", errorArgs, ce);
        }
        catch (IOException e) {
            Object[] errorArgs = new String[]{nodeName, dir, e.getMessage()};
            OiipgClusterOps.throwRemoteOpsException("OUI-35113", errorArgs, e);
        }
    }

    public static void throwRemoteOpsException(String resId, Object[] args, Throwable ce) throws OiipgRemoteOpsException {
        throw new OiipgRemoteOpsException(resId, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", resId, args), ce);
    }

    public static String constructOiipgRemoteFileOperationException(String resId, String[] args, RemoteFileOperationException rfoe, String[] nodeNames, List nodesOK) {
        return OiipgClusterOps.constructOiipgRemoteFileOperationExceptionWithLength(resId, args, rfoe, nodeNames, nodesOK, nodeNames.length, true, false);
    }

    static String constructBriefMessageOiipgRemoteFileOperationException(String resId, String[] args, RemoteFileOperationException rfoe, String[] nodeNames, List nodesOK) {
        int length = nodeNames.length;
        try {
            Integer oNumNodesForDisplay = Integer.getInteger("oracle.installer.numNodesToDisplayOnAlert");
            if (oNumNodesForDisplay != null) {
                length = oNumNodesForDisplay;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return OiipgClusterOps.constructOiipgRemoteFileOperationExceptionWithLength(resId, args, rfoe, nodeNames, nodesOK, length, false, true);
    }

    private static String constructOiipgRemoteFileOperationExceptionWithLength(String resId, String[] args, RemoteFileOperationException rfoe, String[] nodeNames, List nodesOK, int length, boolean bDisplayOKNodes, boolean bUseLinesPerNode) {
        StringBuffer msg = new StringBuffer(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", resId, args));
        msg.append("\n");
        msg.append(S_LINE_SEPERATOR);
        int iCount = 0;
        for (int i = 0; i < nodeNames.length; ++i) {
            try {
                int status = rfoe.getStatus(nodeNames[i]);
                if (status == 1) {
                    if (++iCount > length) continue;
                    msg.append(nodeNames[i]);
                    msg.append(":");
                    msg.append(S_NEWLINE_AND_SPACES);
                    if (bUseLinesPerNode) {
                        int iLinesPerNode = 2;
                        try {
                            Integer oNumLinesPerNodeForDisplay = Integer.getInteger("oracle.installer.numLinesPerNodeToDisplayOnAlert");
                            if (oNumLinesPerNodeForDisplay != null) {
                                iLinesPerNode = oNumLinesPerNodeForDisplay;
                            }
                        }
                        catch (NumberFormatException oNumLinesPerNodeForDisplay) {
                            // empty catch block
                        }
                        String[] asErrorMessages = rfoe.getErrorMessages(nodeNames[i]);
                        if (asErrorMessages != null) {
                            iLinesPerNode = Math.min(iLinesPerNode, asErrorMessages.length);
                            for (int j = 0; j < iLinesPerNode; ++j) {
                                msg.append(asErrorMessages[j]);
                                msg.append(S_NEWLINE_AND_SPACES);
                            }
                            if (iLinesPerNode < asErrorMessages.length) {
                                msg.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1114"));
                            }
                        } else {
                            msg.append("Message error unavailable for node " + nodeNames[i] + "\n");
                        }
                    } else {
                        msg.append(OiixFunctionOps.implodeList(rfoe.getErrorMessages(nodeNames[i]), S_NEWLINE_AND_SPACES));
                    }
                    msg.append("\n");
                    msg.append(S_LINE_SEPERATOR);
                    continue;
                }
                if (status == 2) {
                    if (++iCount > length) continue;
                    msg.append(nodeNames[i]);
                    msg.append(":");
                    Exception oNodeExc = rfoe.getException(nodeNames[i]);
                    if (oNodeExc != null) {
                        msg.append(oNodeExc.getMessage());
                    } else {
                        msg.append("Message error unavailable for node " + nodeNames[i] + "  as Exception returned was null\n");
                    }
                    msg.append("\n");
                    msg.append(S_LINE_SEPERATOR);
                    continue;
                }
                if (nodesOK != null) {
                    nodesOK.add(nodeNames[i]);
                }
                if (!bDisplayOKNodes) continue;
                msg.append(nodeNames[i]);
                msg.append(":");
                msg.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1113"));
                msg.append("\n");
                msg.append(S_LINE_SEPERATOR);
                continue;
            }
            catch (NoSuchNodeException nsne) {
                if (++iCount > length) continue;
                Object[] nsneargs = new String[]{nodeNames[i]};
                msg.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35033", nsneargs));
                msg.append("\n");
                msg.append(S_LINE_SEPERATOR);
            }
        }
        if (length < iCount) {
            msg.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1112"));
        }
        return msg.toString();
    }

    public static void throwOiipgRemoteFileOperationException(String resId, String[] args, RemoteFileOperationException rfoe, String[] nodeNames, List nodesOK) throws OiipgRemoteFileOperationException {
        String basicMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", resId, args);
        String msg = OiipgClusterOps.constructOiipgRemoteFileOperationException(resId, args, rfoe, nodeNames, nodesOK);
        String briefMsg = OiipgClusterOps.constructBriefMessageOiipgRemoteFileOperationException(resId, args, rfoe, nodeNames, nodesOK);
        throw new OiipgRemoteFileOperationException(msg, rfoe, basicMessage, briefMsg);
    }

    static String constructBriefMessageOiipgRemoveListedFilesException(String basicMessage, List nodeStatusList) {
        int length = nodeStatusList.size();
        try {
            Integer oNumNodesForDisplay = Integer.getInteger("oracle.installer.numNodesToDisplayOnAlert");
            if (oNumNodesForDisplay != null) {
                length = oNumNodesForDisplay;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return OiipgClusterOps.constructOiipgRemoveListedFilesException(basicMessage, nodeStatusList, length, false);
    }

    private static String constructOiipgRemoveListedFilesException(String basicMessage, List nodeStatusList, int length, boolean bDisplayOKNodes) {
        StringBuffer msg = new StringBuffer(basicMessage);
        msg.append("\n");
        msg.append(S_LINE_SEPERATOR);
        int iCount = 0;
        for (int i = 0; i < nodeStatusList.size(); ++i) {
            OiipgNodeStatus nodeStatus = (OiipgNodeStatus)nodeStatusList.get(i);
            int status = nodeStatus.getStatus();
            if (status == 2) {
                if (++iCount > length) continue;
                msg.append(nodeStatus.getNode());
                msg.append(":");
                msg.append(nodeStatus.getException().getMessage());
                msg.append("\n");
                msg.append(S_LINE_SEPERATOR);
                continue;
            }
            if (!bDisplayOKNodes) continue;
            msg.append(nodeStatus.getNode());
            msg.append(":");
            msg.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1113"));
            msg.append("\n");
            msg.append(S_LINE_SEPERATOR);
        }
        if (length < iCount) {
            msg.append(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIPG1112"));
        }
        return msg.toString();
    }

    public static void main(String[] args) {
        String[] nodeNames = new String[]{"ez1", "ez2"};
        try {
            String[] hostNames = OiipgClusterOps.getHostNames(nodeNames);
            for (int i = 0; i < hostNames.length; ++i) {
                System.out.println("The hostnames are " + hostNames[i]);
            }
        }
        catch (Exception ce) {
            ce.printStackTrace();
        }
    }
}

