/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.util.ArrayList;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.NodeLivenessListener;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.sysman.oii.oiic.OiicClusterInstallInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiipgClusterChecks {
    public static final int S_DEFAULT_NODE_TIMEOUT = 30;
    public static final int S_DEFAULT_VIRTUAL_HOST_TIMEOUT = 3;

    public static String[] checkUserEquivalence(String[] nodes, OiicClusterInstallInfo oClustInfo) throws OiipgClusterException {
        String[] equivalentNodes = nodes;
        if (nodes != null && nodes.length > 0) {
            ArrayList<String> oEquivalentNodes = new ArrayList<String>();
            try {
                OiipgClusterRunCmd.getClusterCmdObj().validateUserEquivalence(nodes);
            }
            catch (ClusterException e) {
                Object[] args = new String[]{e.getMessage()};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35000", args);
                throw new OiipgClusterException("OUI-35000", sMsg, e);
            }
            catch (RemoteFileOperationException e) {
                for (int i = 0; i < nodes.length; ++i) {
                    try {
                        switch (e.getStatus(nodes[i])) {
                            case 0: {
                                oEquivalentNodes.add(nodes[i]);
                                break;
                            }
                            case 1: {
                                oClustInfo.setAvailabilityErrorList(nodes[i], e.getErrorMessage(nodes[i]));
                                break;
                            }
                            case 2: {
                                oClustInfo.setAvailabilityErrorList(nodes[i], e.getException(nodes[i]).getMessage());
                            }
                        }
                    }
                    catch (NoSuchNodeException nsne) {
                        OiiolTextLogger.appendException(nsne);
                    }
                    equivalentNodes = new String[oEquivalentNodes.size()];
                    equivalentNodes = oEquivalentNodes.toArray(equivalentNodes);
                }
            }
        }
        return equivalentNodes;
    }

    public static String[] getAliveNodes(String[] nodes, int timeout, OiicClusterInstallInfo oClustInfo, NodeLivenessListener lsnr) throws OiipgClusterException {
        String[] asAliveNodes = nodes;
        if (nodes != null && nodes.length > 0) {
            ArrayList<String> oAliveNodes = new ArrayList<String>();
            try {
                OiipgClusterRunCmd.getClusterCmdObj().areNodesAlive(nodes, timeout, null);
            }
            catch (ClusterException e) {
                Object[] args = new String[]{e.getMessage()};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35000", args);
                throw new OiipgClusterException("OUI-35000", sMsg, e);
            }
            catch (RemoteFileOperationException e) {
                for (int i = 0; i < nodes.length; ++i) {
                    try {
                        switch (e.getStatus(nodes[i])) {
                            case 0: {
                                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                                    OiiolTextLogger.appendText("Node:" + nodes[i] + " is alive", OiiolTextLogger.LOG_DETAILED);
                                }
                                oAliveNodes.add(nodes[i]);
                                break;
                            }
                            case 1: {
                                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                                    OiiolTextLogger.appendText("Node:" + nodes[i] + " is not alive. Error reported:" + e.getErrorMessage(nodes[i]), OiiolTextLogger.LOG_DETAILED);
                                }
                                oClustInfo.setAvailabilityErrorList(nodes[i], e.getErrorMessage(nodes[i]));
                                break;
                            }
                            case 2: {
                                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                                    OiiolTextLogger.appendText("Node:" + nodes[i] + " is not alive. Exception reported:" + e.getException(nodes[i]).getMessage(), OiiolTextLogger.LOG_DETAILED);
                                }
                                oClustInfo.setAvailabilityErrorList(nodes[i], e.getException(nodes[i]).getMessage());
                            }
                        }
                    }
                    catch (NoSuchNodeException nsne) {
                        OiiolTextLogger.appendException(nsne);
                        oClustInfo.setAvailabilityErrorList(nodes[i], nsne.getMessage());
                    }
                    asAliveNodes = new String[oAliveNodes.size()];
                    asAliveNodes = oAliveNodes.toArray(asAliveNodes);
                }
            }
        }
        return asAliveNodes;
    }

    public static String[] performPermissionsTestOnNodes(String sPath, OiicClusterInstallInfo clusterInfo, String[] nodes) {
        ArrayList<String> oNodesWithoutPerms = new ArrayList<String>();
        if (sPath != null & nodes != null && nodes.length > 0) {
            String sNodes = OiixFunctionOps.implodeList(nodes, ",");
            String[] obj = new String[]{sPath, sNodes};
            String errStatus = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35100", new String[]{sPath});
            for (int i = 0; i < nodes.length; ++i) {
                try {
                    if (OiipgClusterOps.isDirWritableOnNode(nodes[i], sPath)) {
                        if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) continue;
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35101", new String[]{nodes[i], sPath}), OiiolTextLogger.LOG_DETAILED);
                        continue;
                    }
                    if (clusterInfo != null) {
                        clusterInfo.setAvailabilityErrorList(nodes[i], errStatus);
                    }
                    oNodesWithoutPerms.add(nodes[i]);
                    continue;
                }
                catch (OiipgRemoteOpsException e) {
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35102", new String[]{nodes[i], errStatus}), OiiolTextLogger.LOG_DETAILED);
                    }
                    if (clusterInfo != null) {
                        clusterInfo.setAvailabilityErrorList(nodes[i], errStatus);
                    }
                    oNodesWithoutPerms.add(nodes[i]);
                }
            }
        }
        return OiixVectorOps.list2StrArr(oNodesWithoutPerms);
    }

    public static String[] performVirtualHostNameTests(String[] asVirtualHostNames, String[] asNodes, int timeout, OiicClusterInstallInfo oClustInfo, NodeLivenessListener lsnr) throws OiipgClusterException {
        String[] asOKNodes = null;
        if (asNodes != null && asNodes.length > 0 && asVirtualHostNames != null && asVirtualHostNames.length > 0 && asNodes.length == asVirtualHostNames.length) {
            ArrayList<String> oOKNodes = new ArrayList<String>();
            try {
                OiipgClusterRunCmd.getClusterCmdObj().areNodesAlive(asVirtualHostNames, timeout, null);
                if (OiiolTextLogger.getLogLevel() > OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText("All nodes alive", OiiolTextLogger.LOG_TRACE);
                }
                for (int i = 0; i < asVirtualHostNames.length; ++i) {
                    if (oClustInfo == null) continue;
                    oClustInfo.setAvailabilityErrorList(asNodes[i], OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35105", new String[]{asVirtualHostNames[i], asNodes[i]}));
                    oClustInfo.setVirtualHostName(asNodes[i], asVirtualHostNames[i]);
                }
                asOKNodes = new String[]{};
            }
            catch (ClusterException e) {
                asOKNodes = new String[asNodes.length];
                System.arraycopy(asNodes, 0, asOKNodes, 0, asNodes.length);
            }
            catch (RemoteFileOperationException e) {
                if (OiiolTextLogger.getLogLevel() > OiiolTextLogger.LOG_TRACE) {
                    OiiolTextLogger.appendText("VIPs:" + asVirtualHostNames.length, OiiolTextLogger.LOG_TRACE);
                }
                for (int i = 0; i < asVirtualHostNames.length; ++i) {
                    try {
                        if (OiiolTextLogger.getLogLevel() > OiiolTextLogger.LOG_TRACE) {
                            OiiolTextLogger.appendText("VIP:" + asVirtualHostNames[i] + "Node:" + asNodes[i] + ":" + e.getStatus(asVirtualHostNames[i]), OiiolTextLogger.LOG_TRACE);
                        }
                        switch (e.getStatus(asVirtualHostNames[i])) {
                            case 0: {
                                if (OiiolTextLogger.getLogLevel() > OiiolTextLogger.LOG_TRACE) {
                                    OiiolTextLogger.appendText("VIP:" + asVirtualHostNames[i] + "Node:" + asNodes[i] + ":SUCCESS", OiiolTextLogger.LOG_TRACE);
                                }
                                if (oClustInfo == null) break;
                                oClustInfo.setAvailabilityErrorList(asNodes[i], OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35105", new String[]{asVirtualHostNames[i], asNodes[i]}));
                                break;
                            }
                            case 1: 
                            case 2: {
                                if (OiiolTextLogger.getLogLevel() > OiiolTextLogger.LOG_TRACE) {
                                    OiiolTextLogger.appendText("VIP:" + asVirtualHostNames[i] + "Node:" + asNodes[i] + ":ERROR/EXCEPTION", OiiolTextLogger.LOG_TRACE);
                                }
                                oOKNodes.add(asNodes[i]);
                            }
                        }
                        if (oClustInfo == null) continue;
                        oClustInfo.setVirtualHostName(asNodes[i], asVirtualHostNames[i]);
                        continue;
                    }
                    catch (NoSuchNodeException nsne) {
                        OiiolTextLogger.appendException(nsne);
                        if (oClustInfo == null) continue;
                        oClustInfo.setAvailabilityErrorList(asNodes[i], nsne.getMessage());
                    }
                }
                asOKNodes = new String[oOKNodes.size()];
                asOKNodes = oOKNodes.toArray(asOKNodes);
            }
        }
        return asOKNodes;
    }

    public static String[] performPrivateNodeNameTests(String[] asPrivateNodes, String[] asNodes, int timeout, OiicClusterInstallInfo oClustInfo, NodeLivenessListener lsnr) throws OiipgClusterException {
        String[] asAliveNodes = asNodes;
        if (asNodes != null && asNodes.length > 0 && asPrivateNodes != null && asPrivateNodes.length > 0 && asNodes.length == asPrivateNodes.length) {
            ArrayList<String> oAliveNodes = new ArrayList<String>();
            try {
                OiipgClusterRunCmd.getClusterCmdObj().areNodesAlive(asPrivateNodes, timeout, null);
            }
            catch (ClusterException e) {
                Object[] args = new String[]{e.getMessage()};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-35000", args);
                throw new OiipgClusterException("OUI-35000", sMsg, e);
            }
            catch (RemoteFileOperationException e) {
                for (int i = 0; i < asPrivateNodes.length; ++i) {
                    block13: {
                        try {
                            switch (e.getStatus(asPrivateNodes[i])) {
                                case 0: {
                                    oAliveNodes.add(asNodes[i]);
                                    break;
                                }
                                case 1: {
                                    if (oClustInfo == null) break;
                                    oClustInfo.setAvailabilityErrorList(asNodes[i], e.getErrorMessage(asPrivateNodes[i]));
                                    break;
                                }
                                case 2: {
                                    if (oClustInfo == null) break;
                                    oClustInfo.setAvailabilityErrorList(asNodes[i], e.getException(asPrivateNodes[i]).getMessage());
                                }
                            }
                            if (oClustInfo != null) {
                                oClustInfo.setPrivateNodeName(asNodes[i], asPrivateNodes[i]);
                            }
                        }
                        catch (NoSuchNodeException nsne) {
                            OiiolTextLogger.appendException(nsne);
                            if (oClustInfo == null) break block13;
                            oClustInfo.setAvailabilityErrorList(asNodes[i], nsne.getMessage());
                        }
                    }
                    asAliveNodes = new String[oAliveNodes.size()];
                    asAliveNodes = oAliveNodes.toArray(asAliveNodes);
                }
            }
        }
        return asAliveNodes;
    }
}

