/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiipgCFSDriveCheck {
    private static OiipgCFSDriveCheck _instance = null;
    private Vector _cfs_drives = null;
    private Vector _cfs_paths = null;
    private String[] _nodes = null;
    private String _local_node = null;
    private static String S_DEFAULT_INSTALL_LOC = "install";

    private OiipgCFSDriveCheck() {
        this.initialize();
    }

    public static OiipgCFSDriveCheck getCFSDriveChecker() {
        if (_instance == null) {
            _instance = new OiipgCFSDriveCheck();
        }
        return _instance;
    }

    public static void dispose() {
        if (_instance != null) {
            _instance.clear();
            _instance = null;
        }
    }

    private void clear() {
        this._cfs_drives = null;
        this._cfs_paths = null;
        this._nodes = null;
        this._local_node = null;
    }

    private void initialize() {
        OiicSessionInterfaceManager interfaceMgr;
        OiicInstallTimeSession _session;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("CFSDriveChecker being initialzed.");
        }
        if ((_session = (interfaceMgr = OiicSessionInterfaceManager.getInterfaceManager()).getSession()) != null) {
            String sInstall_home_loc;
            boolean _isShared;
            String _home_loc = null;
            OiisVariable o_home_loc = _session.getSessionContext().getVariable("ORACLE_HOME");
            if (o_home_loc != null) {
                _home_loc = (String)o_home_loc.getValue();
            }
            this.updateClusterNodes(_session);
            if (_home_loc != null && (_isShared = this.isDriveOnCFS(sInstall_home_loc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(_home_loc, System.getProperty("oracle.installer.installDirLoc", S_DEFAULT_INSTALL_LOC)))))) {
                this.addCFSDriveToList(_home_loc);
            }
        }
    }

    private void updateClusterNodes(OiicInstallTimeSession _session) {
        ArrayList<String> _clusterNodes = new ArrayList<String>();
        OiisVariable localNode = _session.getSessionContext().getVariable("LOCAL_NODE");
        if (localNode != null) {
            this._local_node = (String)localNode.getValue();
            _clusterNodes.add(this._local_node);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("Initializing CFSDriveChecker. Local Node:" + this._local_node);
            }
        }
        OiisVariable remoteNodes = _session.getSessionContext().getVariable("REMOTE_NODES");
        this.updateList(_clusterNodes, remoteNodes, "Remote Nodes");
        OiisVariable existingRemoteNodes = _session.getSessionContext().getVariable("EXISTING_REMOTE_NODES");
        this.updateList(_clusterNodes, existingRemoteNodes, "Existing Remote Nodes");
        if (_clusterNodes != null) {
            int numElems = _clusterNodes.size();
            this._nodes = new String[numElems];
            for (int i = 0; i < numElems; ++i) {
                this._nodes[i] = (String)_clusterNodes.get(i);
            }
        }
    }

    private void updateList(List _clusterNodes, OiisVariable nodesObj, String name) {
        String[] nodes;
        if (nodesObj != null && (nodes = (String[])nodesObj.getValue()) != null && nodes.length > 0) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("Initializing CFSDriveChecker. " + name + ":" + OiixFunctionOps.implodeList(nodes, ","));
            }
            for (int i = 0; i < nodes.length; ++i) {
                _clusterNodes.add(nodes[i]);
            }
        }
    }

    private void addCFSDriveToList(String loc) {
        this.addVolumeToCFSDriveList(loc);
        this.addPathToCFSPathList(loc);
    }

    private void addPathToCFSPathList(String loc) {
        if (loc != null) {
            if (this._cfs_paths == null) {
                this._cfs_paths = new Vector(1);
            }
            this.addToList(loc, this._cfs_paths);
        }
    }

    private void addVolumeToCFSDriveList(String loc) {
        if (loc != null) {
            if (this._cfs_drives == null) {
                this._cfs_drives = new Vector(1);
            }
            this.addToDriveList(loc, this._cfs_drives);
        }
    }

    private void addToList(String loc, Vector _list) {
        if (!OiipgFileSystem.isCaseSensitive()) {
            loc = loc.toLowerCase();
        }
        if (!_list.contains(loc = OiixPathOps.getStandardForm(loc))) {
            _list.addElement(loc);
        }
    }

    private void addToDriveList(String loc, Vector _list) {
        OiipgFileSystem system = new OiipgFileSystem();
        String _vol_name = system.getVolumeName(loc);
        this.addToList(_vol_name, _list);
    }

    public static boolean isDriveOnCFS(String[] nodeList, String sLocalNode, String path) {
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Calling isDriveOnCFS:" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + path);
        }
        if (!OiipgDetectCluster.isClusterEnabled()) {
            OiiolTextLogger.appendText("Cluster mode is disabled:Drive is considered to be on on CFS by default");
            return true;
        }
        if (sLocalNode == null && nodeList != null && nodeList.length > 1) {
            sLocalNode = nodeList[0];
        }
        boolean bShared = OiipgCFSDriveCheck.isSharedPath(nodeList, sLocalNode, path);
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Calling isDriveOnCFS:" + OiixFunctionOps.implodeList(nodeList, ",") + ":" + path + ":returning " + bShared);
        }
        return OiipgCFSDriveCheck.isSharedPath(nodeList, sLocalNode, path);
    }

    public boolean isDriveOnCFS(String path) {
        String _vol_name = null;
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
            OiiolTextLogger.appendText("Calling isDriveOnCFS:" + path);
        }
        if (!OiipgDetectCluster.isClusterEnabled()) {
            OiiolTextLogger.appendText("Cluster mode is disabled:Drive is considered to be on on CFS by default");
            return true;
        }
        File _path = new File(path);
        _vol_name = _path.isDirectory() ? path : _path.getParent();
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("In isDriveOnCFS() : Volume Name :" + _vol_name, OiiolTextLogger.LOG_DETAILED);
        }
        if (_vol_name == null) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In isDriveOnCFS() : Volume Name :" + _vol_name + ":returning false", OiiolTextLogger.LOG_DETAILED);
            }
            return false;
        }
        _vol_name = OiixPathOps.getStandardForm(_vol_name);
        if (this.isPathOnCFS(_vol_name = OiixPathOps.directorify(_vol_name))) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In isDriveOnCFS()/isPathOnCFS : Volume Name :" + _vol_name + ":returning true", OiiolTextLogger.LOG_DETAILED);
            }
            return true;
        }
        if (this.isPathOnCFSDrive(_vol_name)) {
            this.addPathToCFSPathList(_vol_name);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In isDriveOnCFS()/isPathOnCFSDrive : Volume Name :" + _vol_name + ":returning true", OiiolTextLogger.LOG_DETAILED);
            }
            return true;
        }
        if (this._nodes != null && this._nodes.length > 1 && this._local_node != null) {
            try {
                String inventory;
                if (Boolean.getBoolean("oracle.installer.rootOwnedHome") && new File(inventory = OiixPathOps.getNativeForm(OiixPathOps.concatPath(_vol_name, "inventory"))).exists()) {
                    _vol_name = inventory;
                    OiiolTextLogger.appendText("rootOwnedHome is set using :" + _vol_name + " as path ");
                }
                String _nativeVolName = OiixPathOps.getNativeForm(_vol_name);
                OiiolTextLogger.appendText("Native Volume Name:" + _nativeVolName);
                OiiolTextLogger.appendText("Nodes:" + OiixFunctionOps.implodeList(this._nodes, ","));
                OiiolTextLogger.appendText("Local Node:" + this._local_node);
                if (Cluster.isSharedPath((String)_nativeVolName, (String[])this._nodes, (String)this._local_node)) {
                    this.addCFSDriveToList(_vol_name);
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                        OiiolTextLogger.appendText("In isDriveOnCFS()/isSharedPath : Volume Name :" + _vol_name + ":returning true", OiiolTextLogger.LOG_DETAILED);
                    }
                    return true;
                }
            }
            catch (SharedDeviceException e) {
                e.printStackTrace();
            }
            catch (InvalidNodeListException e) {
                e.printStackTrace();
            }
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText("In isDriveOnCFS() : Volume Name :" + _vol_name + ":returning false", OiiolTextLogger.LOG_DETAILED);
        }
        return false;
    }

    private static boolean isSharedPath(String[] asNodeList, String sLocalNode, String sPath) {
        boolean bDriveOnCFS = false;
        if (asNodeList != null && asNodeList.length > 1 && sLocalNode != null) {
            try {
                String sNativeVolName = OiixPathOps.getNativeForm(sPath);
                bDriveOnCFS = Cluster.isSharedPath((String)sNativeVolName, (String[])asNodeList, (String)sLocalNode);
            }
            catch (SharedDeviceException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (InvalidNodeListException e) {
                OiiolTextLogger.appendException(e);
            }
        }
        return bDriveOnCFS;
    }

    private boolean isPathOnCFS(String path) {
        return this.isPathInList(path, this._cfs_paths);
    }

    private boolean isPathOnCFSDrive(String path) {
        return this.isPathInDriveList(path, this._cfs_drives);
    }

    private boolean isPathInDriveList(String path, Vector _list) {
        if (_list != null) {
            if (!OiipgFileSystem.isCaseSensitive()) {
                path = path.toLowerCase();
            }
            return _list.contains(path);
        }
        return false;
    }

    private boolean isPathInList(String path, Vector _list) {
        if (_list != null) {
            if (!OiipgFileSystem.isCaseSensitive()) {
                path = path.toLowerCase();
            }
            for (int i = 0; i < _list.size(); ++i) {
                String sPath = (String)_list.elementAt(i);
                if (!path.startsWith(sPath)) continue;
                return true;
            }
        }
        return false;
    }
}

