/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.File;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiipgAddNodeRootSh {
    private String ADDNODE_SCRIPT = System.getProperty("oracle.installer.rootaddnode.destn");
    private String ROOT_SCRIPT = "root.sh";

    public void displayRootSh(OiicPullSession session) {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (platGroup == -1) {
            OiiiOracleHomeInfo oInfo;
            OiisVariable ohNameVar = session.getSessionContext().getVariable("ORACLE_HOME");
            String ohLoc = (String)ohNameVar.getValue();
            OiisVariable oNodeNames = session.getSessionContext().getVariable("CLUSTER_NODES");
            String[] clusterList = (String[])oNodeNames.getValue();
            boolean bCluster = false;
            OiicSessionInterfaceManager sim = OiicSessionInterfaceManager.getInterfaceManager();
            String sTitle = OiixResourceBundle.getString("S_RUN_ROOTSH_TITLE");
            Object[] args = null;
            String[] arr = new String[1];
            OiiiInstallAreaControl oAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
            OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
            if (oInventory != null && (oInfo = oInventory.getHomeWithLocation(ohLoc)) != null) {
                if (oInfo.isCRSHome()) {
                    String sAddNodeRootShLocation = ohLoc.concat(File.separator);
                    File f = new File(sAddNodeRootShLocation = sAddNodeRootShLocation.concat(this.ADDNODE_SCRIPT));
                    if (f.exists()) {
                        arr[0] = sAddNodeRootShLocation;
                        String message = null;
                        if (clusterList != null && clusterList.length > 0) {
                            String sNodeList = clusterList[0];
                            args = new Object[]{sAddNodeRootShLocation, sNodeList};
                            bCluster = true;
                            message = sim.getRootSHMessage(args, bCluster);
                            if (!OiicSessionContext.isDlgToBeShown("SHOW_ROOTSH_CONFIRMATION")) {
                                if (OiicPullSession.isSilentMode()) {
                                    OiiolTextLogger.appendErrorText(message);
                                } else {
                                    OiiolTextLogger.appendText(message, OiiolTextLogger.LOG_BASIC);
                                }
                            } else {
                                OiifmAlert.displayAlert(sTitle, message, 40, 1, 1, 10, true);
                                if (OiicPullSession.isSilentMode()) {
                                    OiiolTextLogger.writeMessageToConsole(message);
                                }
                            }
                        }
                    }
                }
                Object[] rootargs = null;
                String sRootShLocation = ohLoc.concat(File.separator);
                File rootFile = new File(sRootShLocation = sRootShLocation.concat(this.ROOT_SCRIPT));
                if (!rootFile.exists()) {
                    return;
                }
                OiisVariable oNames = session.getSessionContext().getVariable("CLUSTER_NEW_NODES");
                String[] nodeList = (String[])oNames.getValue();
                if (nodeList != null && nodeList.length > 0) {
                    String sNodes = OiixFunctionOps.implodeList(nodeList, ",");
                    rootargs = new Object[]{sRootShLocation, sNodes};
                    bCluster = true;
                } else {
                    args = arr;
                }
                String messageRoot = sim.getRootSHMessage(rootargs, bCluster);
                if (!OiicSessionContext.isDlgToBeShown("SHOW_ROOTSH_CONFIRMATION")) {
                    if (OiicPullSession.isSilentMode()) {
                        OiiolTextLogger.appendErrorText(messageRoot);
                    } else {
                        OiiolTextLogger.appendText(messageRoot, OiiolTextLogger.LOG_BASIC);
                    }
                } else {
                    OiifmAlert.displayAlert(sTitle, messageRoot, 40, 1, 1, 10, true);
                    if (OiicPullSession.isSilentMode()) {
                        OiiolTextLogger.writeMessageToConsole(messageRoot);
                    }
                }
            }
        } else if (platGroup == -3) {
            return;
        }
    }
}

