/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiipgAddNodeInstantiate {
    private String INSTANTIATE_DELIMITER = "%";
    private String NEW_NODES = "%slNewNodes%";
    private String PRIVATE_NODES = "%slPrivateNodes%";
    private String ORACLE_HOME_VAR = "%sOracleHome%";
    private String DELETED_NODES = "%slDelNodes%";
    private String HOST_NAMES = "%slHostNames%";
    private static String ADDNODE_UNIX_SCRIPT = "rootaddnode.sh";
    private String ADDNODE_UNIX_INSTANTIATE_SCRIPT = "install/rootaddnode.sbs";
    private String ADDNODE_WIN_INSTANTIATE_SCRIPT = "install/crssetup.add.sbs";
    private static String ADDNODE_WIN_SCRIPT = "crssetup.add.bat";
    private String[] S_ASVALUE_VARS = new String[]{"CLUSTER_NEW_NODES", "ORACLE_HOME"};

    public static String getAddNodeScript() {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        String destScript = null;
        if (platGroup == -1) {
            destScript = ADDNODE_UNIX_SCRIPT;
        } else if (platGroup == -3) {
            destScript = ADDNODE_WIN_SCRIPT;
        }
        return System.getProperty("oracle.installer.rootaddnode.destn", destScript);
    }

    public void instantiate(OiicPullSession session) {
        int platGroup = OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        String sourceScript = null;
        String destScript = null;
        if (platGroup == -1) {
            sourceScript = this.ADDNODE_UNIX_INSTANTIATE_SCRIPT;
            destScript = ADDNODE_UNIX_SCRIPT;
        } else if (platGroup == -3) {
            sourceScript = this.ADDNODE_WIN_INSTANTIATE_SCRIPT;
            destScript = ADDNODE_WIN_SCRIPT;
        }
        sourceScript = System.getProperty("oracle.installer.rootaddnode.source", sourceScript);
        destScript = System.getProperty("oracle.installer.rootaddnode.destn", destScript);
        OiisVariable oOhLoc = session.getSessionContext().getVariable("ORACLE_HOME");
        String sOhLoc = (String)oOhLoc.getValue();
        String sInstSource = OiixPathOps.concatPath(sOhLoc, sourceScript);
        String sInstDest = OiixPathOps.concatPath(sOhLoc, destScript);
        File addNodeRootFile = new File(sInstSource);
        if (addNodeRootFile.exists()) {
            String sVarsToReplace;
            String[] asVars = new String[]{this.NEW_NODES, this.PRIVATE_NODES, this.ORACLE_HOME_VAR, this.HOST_NAMES};
            String[] asValueVars = this.S_ASVALUE_VARS;
            String sValueVars = System.getProperty("oracle.installer.rootaddnode.value_vars");
            if (sValueVars != null) {
                asValueVars = OiixFunctionOps.explodeString(sValueVars, ",");
            }
            if ((sVarsToReplace = System.getProperty("oracle.installer.rootaddnode.vars")) != null) {
                asVars = OiixFunctionOps.explodeString(sVarsToReplace, ",");
            }
            String[] asValues = this.getValuesForVars(session.getSessionContext(), asValueVars);
            HashMap searchReplaceMap = this.getSearchReplaceMap(asVars, asValues);
            String sDelimiter = System.getProperty("oracle.installer.rootaddnode.delimiter", this.INSTANTIATE_DELIMITER);
            try {
                OiixFileOps.instantiateFile(sInstSource, sInstDest, searchReplaceMap, sDelimiter);
                if (platGroup == -1) {
                    OiixFileOps.changePermissions(sInstDest, "0755");
                }
            }
            catch (FileNotFoundException fe) {
                OiiolTextLogger.appendText(fe.getMessage(), OiiolTextLogger.LOG_BASIC);
            }
            catch (IOException ioex) {
                OiiolTextLogger.appendText(ioex.getMessage(), OiiolTextLogger.LOG_BASIC);
            }
        } else {
            String sMsg = sInstSource + " does not exist. Instantiation is skipped.";
            OiiolTextLogger.appendText(sMsg, OiiolTextLogger.LOG_BASIC);
        }
    }

    private HashMap getSearchReplaceMap(String[] asVarsToReplace, String[] asValues) {
        HashMap<String, String> oSearchReplaceMap = new HashMap<String, String>();
        for (int i = 0; i < asVarsToReplace.length; ++i) {
            oSearchReplaceMap.put(asVarsToReplace[i].toLowerCase(), asValues[i]);
        }
        return oSearchReplaceMap;
    }

    private String[] getValuesForVars(OiisVariableOwner vo, String[] asValueVars) {
        String[] asValues = new String[asValueVars.length];
        OiisVariable oClusterNewNodeNumbers = vo.getVariable("CLUSTER_NEW_NODE_NUMBERS");
        String[] asClusterNodeNumbers = (String[])oClusterNewNodeNumbers.getValue();
        for (int i = 0; i < asValueVars.length; ++i) {
            OiisVariable oVar = vo.getVariable(asValueVars[i]);
            Object o = oVar.getValue();
            if (o == null) {
                asValues[i] = "";
                continue;
            }
            if (oVar.getType() == OiisVariable.STRINGLIST) {
                String[] asVal = (String[])o;
                String sVarName = oVar.getName();
                if (sVarName.equals("CLUSTER_NEW_NODES")) {
                    asValues[i] = OiixFunctionOps.implodeList(this.getVariableWithNumbers(asVal, asClusterNodeNumbers), ",");
                    continue;
                }
                asValues[i] = OiixFunctionOps.implodeList(asVal, ",");
                continue;
            }
            asValues[i] = o.toString();
        }
        return asValues;
    }

    private String[] getVariableWithNumbers(String[] varString, String[] numString) {
        String[] combinedArray = null;
        if (varString != null && varString.length > 0 && numString != null && numString.length > 0 && numString.length == varString.length) {
            int combinedArrayLength = 2 * varString.length;
            combinedArray = new String[combinedArrayLength];
            int j = 0;
            for (int i = 0; i < varString.length && j < combinedArrayLength; ++i) {
                combinedArray[j++] = varString[i];
                combinedArray[j++] = numString[i];
            }
        }
        return combinedArray;
    }
}

