/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiip.oiipg;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifw.OiifwRootShWCDE;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterLogger;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiipgActionsPhase {
    private OiicPullSession m_oSession = null;
    private String m_rootShLoc = null;
    private String m_rootShOldLoc = null;
    private int m_curPlatGroup = 0;

    public OiipgActionsPhase(OiicPullSession oSession) {
        this.m_oSession = oSession;
        int v_curPlatId = OiixPlatform.getCurrentPlatform();
        this.m_curPlatGroup = OiixPlatform.getPlatGroup(v_curPlatId);
    }

    public boolean needLinkPhase() {
        return this.needLinkPhaseForPlat(OiixPlatform.getCurrentPlatform());
    }

    public boolean needLinkPhaseForPlat(int platform) {
        boolean retVal = false;
        switch (this.m_curPlatGroup) {
            case -1: {
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public void initialize() {
        switch (this.m_curPlatGroup) {
            case -1: {
                OiicSessionContext sesCntxt = this.m_oSession.getSessionContext();
                OiisVariable oRootShLocVar = sesCntxt.getVariable("ROOTSH_LOCATION");
                this.m_rootShLoc = (String)oRootShLocVar.getValue();
                if (this.m_rootShLoc != null) {
                    this.m_rootShLoc = this.m_rootShLoc.trim();
                }
                if (this.m_rootShLoc == null || this.m_rootShLoc.equals("")) {
                    String oh = (String)sesCntxt.getVariable("ORACLE_HOME").getValue();
                    this.m_rootShLoc = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oh, "root.sh"));
                    try {
                        oRootShLocVar.setValue(this.m_rootShLoc);
                    }
                    catch (OiifbCancelException e) {
                        e.printStackTrace();
                    }
                    catch (OiisVarSettingException e) {
                        e.printStackTrace();
                    }
                }
                if (this.m_oSession.isAddNodeMode()) break;
                this.initRootShLocation();
                break;
            }
        }
    }

    public OiifbWizOperation getPrivelegedOps() {
        OiifwRootShWCDE wizOp = null;
        switch (this.m_curPlatGroup) {
            case -1: {
                OiipuUnixOps nc = new OiipuUnixOps();
                wizOp = new OiifwRootShWCDE(this.m_rootShLoc, this.m_oSession, 0 == nc.getUserId() ? 0 : 1);
                break;
            }
        }
        return wizOp;
    }

    public String getRootShLocation() {
        return this.m_rootShLoc;
    }

    private void initRootShLocation() {
        try {
            boolean rootShExists = new File(this.m_rootShLoc).exists();
            if (rootShExists && Boolean.getBoolean("oracle.installer.rootshbackup")) {
                this.m_rootShOldLoc = OiixFileOps.backUpFile(this.m_rootShLoc, this.m_rootShLoc + ".old");
                OiipgClusterLogger.logCopyFile(this.m_rootShOldLoc);
            }
            if (!rootShExists || !Boolean.getBoolean("oracle.installer.rootshcumulative")) {
                PrintWriter pos = new PrintWriter(new BufferedWriter(new FileWriter(this.m_rootShLoc)));
                pos.write("#!/bin/sh");
                pos.println();
                pos.close();
            }
            OiipuUnixOps.chmod(this.m_rootShLoc, 488);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (OiilNativeException ex) {
            ex.printStackTrace();
        }
    }

    public void restoreRootSh() {
        if (this.isEmptyRootSh()) {
            File f2;
            File f1 = null;
            if (this.m_rootShLoc != null) {
                f1 = new File(this.m_rootShLoc);
            }
            if (null != f1 && f1.exists()) {
                f1.delete();
            }
            String sTmp = this.m_rootShLoc;
            this.m_rootShLoc = this.m_rootShOldLoc;
            if (this.isEmptyRootSh() && null != this.m_rootShOldLoc && null != (f2 = new File(this.m_rootShOldLoc)) && f2.exists()) {
                f2.delete();
                this.m_rootShOldLoc = null;
            }
            this.m_rootShLoc = sTmp;
            if (null != this.m_rootShOldLoc && null != f1 && (f2 = new File(this.m_rootShOldLoc)).exists()) {
                f2.renameTo(f1);
            }
        }
    }

    public boolean isEmptyRootSh() {
        boolean retVal = true;
        if (this.m_rootShLoc == null) {
            return true;
        }
        try {
            FileReader fr = new FileReader(this.m_rootShLoc);
            LineNumberReader lnr = new LineNumberReader(fr);
            lnr.readLine();
            String contents = lnr.readLine();
            if (contents != null) {
                retVal = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retVal;
    }

    public boolean canClearLibLoaders() {
        boolean bRet = false;
        switch (this.m_curPlatGroup) {
            default: 
        }
        bRet = false;
        return bRet;
    }

    public void dispose() {
        switch (this.m_curPlatGroup) {
            case -1: {
                break;
            }
        }
    }
}

