/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiioz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisChildVarElem;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.sysman.oii.oiis.OiisVarHolder;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixIniComment;
import oracle.sysman.oii.oiix.OiixIniFile;
import oracle.sysman.oii.oiix.OiixIniPair;
import oracle.sysman.oii.oiix.OiixIniParsingException;
import oracle.sysman.oii.oiix.OiixIniRawText;
import oracle.sysman.oii.oiix.OiixIniSection;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oii.oiiz.OiizResourceBundle;

public class OiiozResponseFileWriter {
    private int m_nResponseFiles = 1;
    private OiixIniFile m_IniFile;
    private static String sCommentChar = OiixResourceBundle.getString("S_COMMENT_CHAR");
    private static String sNewLine = System.getProperty("line.separator");
    private static boolean s_debug = false;
    private boolean m_bError = false;
    private String s_configResponseVarName = "s_responseFileName";
    public static final String S_RSP_SEPARATOR_LINE = "-------------------------------------------------------------------------------";
    public static final String S_EQUAL = "=";
    public static final String SEPARATOR = ":";
    public static final int AVGVARS = 10;
    private static String m_sRspBakExt = ".bak";
    private Hashtable m_hHashTable = new Hashtable(150);
    private String sDefaultRecordFileName = null;

    public void setRecordModeFileName(String sFile) {
        OiicPullSession.setRecordModeFileName(sFile);
    }

    public String getRecordModeFileName() {
        return OiicPullSession.getRecordModeFileName();
    }

    public void addToVarTable(OiisVariable oVar, OiiiCompInstallID oCompID, boolean bFlag) {
        Object oVarValue;
        OiisAdvisedValue oVal;
        OiisVarHolder oVarHolder = new OiisVarHolder(oCompID.getName(), oCompID.getVersion().getVerString(), OiisVariable.getTypeString(oVar.getType()), oVar.getDescription(), oVar.getAllValueList(), oCompID.getPlatforms(), oVar.getChildVarElems(), oCompID.getCompType(), oVar.getName());
        Vector v = null;
        String str = oVar.getName().toLowerCase();
        String sValue = null;
        sValue = !bFlag ? ((oVal = oVar.getInitialValue()) == null ? (oVar.isCalcMethodPresent() ? OiizResourceBundle.getString("S_RSP_DEF_VAL1") : OiizResourceBundle.getString("S_RSP_DEF_VAL2")) : (String)oVal.getValue()) : ((oVarValue = oVar.getValue()) != null && !oVar.isSecure() ? OiiozResponseFileWriter.getStringValue(oVar) : OiixResourceBundle.getString("S_RSP_DEF_VAL1"));
        oVarHolder.setVarValue(sValue);
        v = (Vector)this.m_hHashTable.get(str);
        if (v != null) {
            v = (Vector)this.m_hHashTable.get(str);
            v.addElement(oVarHolder);
        } else {
            v = new Vector();
            v.addElement(oVarHolder);
        }
        this.m_hHashTable.put(str, v);
    }

    public void resolveVarAssoc() {
        Enumeration oKeys = this.m_hHashTable.keys();
        while (oKeys.hasMoreElements()) {
            String strVarName = (String)oKeys.nextElement();
            Vector v = (Vector)this.m_hHashTable.get(strVarName);
            for (int i = 0; i < v.size(); ++i) {
                OiisVarHolder oHold = (OiisVarHolder)v.elementAt(i);
                Enumeration enumChild = oHold.getChildVarElems();
                while (enumChild.hasMoreElements()) {
                    OiisChildVarElem oChildVar = (OiisChildVarElem)enumChild.nextElement();
                    String strChildName = oChildVar.getChildVarName().toLowerCase();
                    Vector vChild = (Vector)this.m_hHashTable.get(strChildName);
                    if (vChild == null) continue;
                    int iCount = 0;
                    for (int j = 0; j < vChild.size(); ++j) {
                        OiisVarHolder oHolder = (OiisVarHolder)vChild.elementAt(j);
                        OiiiCompInstallID oChildID = oChildVar.getCompInstallID();
                        Vector vVectPlats = oChildID.getPlatforms();
                        if (!oChildID.getName().equals(oHolder.getComponentInternalName()) || !oChildID.getVersion().toString().equals(oHolder.getComponentVersion()) || !vVectPlats.equals(oHolder.getPlatforms())) continue;
                        vChild.removeElementAt(j - iCount);
                        Object[] sArgs = new String[]{strChildName, oHold.getComponentInternalName(), oHold.getComponentVersion()};
                        String strMsg = OiixResourceBundle.getString("S_INFO_VAR_ASSOC", sArgs);
                        System.out.println(strMsg);
                        ++iCount;
                    }
                }
            }
        }
    }

    public void generateRSPVariables(PrintWriter out, Vector vVarnames) {
        this.resolveVarAssoc();
        String[] arrSession = OiicSessionContext.getSessionVariablesArray();
        int vectSize = vVarnames.size();
        for (int i = 0; i < vectSize; ++i) {
            String strVarName = vVarnames.elementAt(i).toString();
            String strVarGen = null;
            Vector v = (Vector)this.m_hHashTable.get(strVarName);
            int vSize = 0;
            if (v != null) {
                vSize = v.size();
            }
            if (vSize == 1) {
                OiisVarHolder oVarValue = (OiisVarHolder)v.elementAt(0);
                String strCompName = oVarValue.getComponentInternalName();
                strVarName = oVarValue.getVarString();
                this.writeVariableBlock(out, strVarName, oVarValue);
                for (int iSize = 0; iSize < arrSession.length; ++iSize) {
                    if (!arrSession[iSize].toLowerCase().equals(strVarGen)) continue;
                    strVarGen = oVarValue.getComponentInternalName() + SEPARATOR + strVarName + S_EQUAL + oVarValue.getVarValue();
                    break;
                }
                strVarGen = strVarName + S_EQUAL + oVarValue.getVarValue();
                out.println(strVarGen);
                continue;
            }
            for (int k = 0; k < vSize; ++k) {
                boolean bFlag = false;
                OiisVarHolder oVarValue = (OiisVarHolder)v.elementAt(k);
                for (int j = 0; j < vSize; ++j) {
                    if (k == j) continue;
                    OiisVarHolder tVar = (OiisVarHolder)v.elementAt(j);
                    if (!oVarValue.getComponentInternalName().equals(tVar.getComponentInternalName())) continue;
                    strVarName = oVarValue.getVarString();
                    strVarGen = oVarValue.getComponentInternalName() + SEPARATOR + oVarValue.getComponentVersion() + SEPARATOR + strVarName;
                    bFlag = true;
                    break;
                }
                strVarName = oVarValue.getVarString();
                strVarGen = !bFlag ? oVarValue.getComponentInternalName() + SEPARATOR + strVarName + S_EQUAL + oVarValue.getVarValue() : strVarGen + S_EQUAL + oVarValue.getVarValue();
                this.writeVariableBlock(out, strVarName, oVarValue);
                out.println(strVarGen);
            }
        }
        out.flush();
        out.close();
    }

    private boolean doRecModeStartupChecks(OiicPullSession oSession) {
        String sRecFilename = this.getRecordModeFileName();
        try {
            this.sDefaultRecordFileName = oSession.getDefaultRecordRespFile();
            OiiolTextLogger.appendText("The default response file generated with recorded values is " + this.sDefaultRecordFileName);
            if (null == sRecFilename) {
                OiiolTextLogger.appendText("-destinationFile option was not provided. Saving the default response file as " + this.sDefaultRecordFileName);
                this.setRecordModeFileName(this.sDefaultRecordFileName);
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
        }
        return this.doRecModeStartupChecks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(OiicInstallSession instSession) {
        if (!this.doRecModeStartupChecks(instSession)) {
            return;
        }
        OiiiCompInstallID oCompID = instSession.getSelTopLevelCompID();
        Vector vCompsToInstall = instSession.getCompInstallVector();
        String sRespLocation = this.getRecordModeFileName();
        File f = new File(sRespLocation);
        if (f.exists()) {
            this.logMessage(OiixResourceBundle.getString("S_RSP_FILE_EXISTS", new String[]{sRespLocation}));
            String strBakLoc = sRespLocation + m_sRspBakExt;
            File fBak = new File(strBakLoc);
            if (fBak.exists()) {
                fBak.delete();
            }
            File foriginal = new File(sRespLocation);
            foriginal.renameTo(fBak);
        }
        FileOutputStream fStream = null;
        PrintWriter out = null;
        try {
            fStream = new FileOutputStream(f);
            out = new PrintWriter(fStream);
        }
        catch (IOException ioe) {
            this.logMessage(ioe.getMessage());
            return;
        }
        OiicSessionContext session = instSession.getSessionContext();
        boolean bCustomInstallType = false;
        if (oCompID.getCompType() != 4) {
            try {
                OiisDepMode oMode = instSession.getDepEngine().getDepNode(oCompID).getInstallType();
                String sInstType = oMode.getInternalName();
                if (sInstType.equalsIgnoreCase("Custom")) {
                    bCustomInstallType = true;
                }
            }
            catch (Exception oMode) {
                // empty catch block
            }
        }
        this.setHeader(out);
        out.println();
        out.println();
        out.println(OiizResourceBundle.getString("S_RSP_VERSTR") + S_EQUAL + OiizResourceBundle.getString("S_RSP_VERSION_2.2.1"));
        try {
            this.generateSessionVariables(instSession, out);
            this.generateGlobalVariables(instSession, out);
            int nCompsToInstall = vCompsToInstall.size();
            Vector vPlats = new Vector(0);
            String[] depList = new String[nCompsToInstall - 1];
            boolean ndeps = false;
            Vector<String> vVarnames = new Vector<String>();
            for (int i = 0; i < nCompsToInstall; ++i) {
                OiisVariable oVar;
                OiisCompInstallation oCompInstall = (OiisCompInstallation)vCompsToInstall.elementAt(i);
                OiiiCompInstallID id = oCompInstall.getCompInstallID();
                if (id.getCompType() == 4) continue;
                OiiodDepNode oDepNode = instSession.getDepEngine().getDepNode(id);
                if (oCompInstall == null) continue;
                OiisCompContext oContext = oCompInstall.getContext();
                if (id.equals(oCompID)) {
                    OiisVariable oVar2 = session.getVariable(OiixResourceBundle.getString("S_SEL_LANG_VAR_NAME"));
                    String[] strLangsList = (String[])oVar2.getValue();
                    Vector value = OiixLanguage.getLangsVector(strLangsList);
                    String[] langs = new String[value.size()];
                    int valSize = value.size();
                    for (int k = 0; k < valSize; ++k) {
                        Locale locale = (Locale)value.elementAt(k);
                        langs[k] = locale.toString();
                    }
                    OiisVariable tempVar = new OiisVariable(oContext, new String(oVar2.getName()));
                    tempVar.setType(4);
                    tempVar.setValue(langs);
                    tempVar.setDescription(OiixResourceBundle.getString("S_COMPONENT_LANGUAGES_DESC"));
                    this.addToVarTable(tempVar, oCompID, true);
                    if (!vVarnames.contains(tempVar.getName().toLowerCase())) {
                        vVarnames.add(tempVar.getName().toLowerCase());
                    }
                    tempVar = null;
                    OiicPullSession pSession = session.getSession();
                    OiiiSourceAccess srcAccess = pSession.getSourceAccess();
                    OiiiStageInventory osi = srcAccess.getStageInventory();
                    OiiiStageCompInvEntry stageCompInvEntry = osi.getStageCompInvEntry(oCompID);
                    Vector supportedLangs = stageCompInvEntry.getLanguages();
                    int suppSize = supportedLangs.size();
                    String[] compLangs = new String[suppSize];
                    String langList = "{";
                    for (int k = 0; k < suppSize; ++k) {
                        Locale locale = (Locale)supportedLangs.elementAt(k);
                        compLangs[k] = locale.toString();
                        langList = langList + "\"" + compLangs[k] + "\"";
                        if (k == suppSize - 1) continue;
                        langList = langList + ",";
                    }
                    langList = langList + "}";
                    tempVar = new OiisVariable(oContext, new String(OiixResourceBundle.getString("S_COMP_LANG_VAR_NAME")));
                    tempVar.setType(4);
                    tempVar.setValue(langs);
                    String langDesc = OiixResourceBundle.getString("S_SUPPORTED_LANGUAGES_DESC");
                    Object[] langArgs = new String[]{langList};
                    langDesc = MessageFormat.format(langDesc, langArgs);
                    tempVar.setDescription(langDesc);
                    this.addToVarTable(tempVar, oCompID, true);
                    if (!vVarnames.contains(tempVar.getName().toLowerCase())) {
                        vVarnames.add(tempVar.getName().toLowerCase());
                    }
                    oVar2 = session.getVariable("DEP_MODE");
                    String nMode = (String)oVar2.getValue();
                    OiisDepMode oMode = oDepNode.getInstallType();
                    tempVar = new OiisVariable(oContext, "INSTALL_TYPE");
                    tempVar.setType(1);
                    tempVar.setValue(oMode.getName());
                    tempVar.setDescription(OiixResourceBundle.getString("S_INSTALL_TYPE_DESC"));
                    this.addToVarTable(tempVar, oCompID, true);
                    if (!vVarnames.contains(tempVar.getName().toLowerCase())) {
                        vVarnames.add(tempVar.getName().toLowerCase());
                    }
                }
                Enumeration enum_1 = oContext.getROVariables();
                while (enum_1.hasMoreElements()) {
                    oVar = (OiisVariable)enum_1.nextElement();
                    if (oVar.getName().equals(OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_LIST"))) {
                        Vector deps;
                        if (oDepNode == null || !bCustomInstallType || (deps = oDepNode.getSelectedVisibleDependees()).size() == 0) continue;
                        ArrayList<String> alDeps = new ArrayList<String>(deps.size());
                        for (int index = 0; index < deps.size(); ++index) {
                            OiiodDepNode dep = (OiiodDepNode)deps.elementAt(index);
                            if (!dep.isSelected()) continue;
                            alDeps.add(dep.getCompInstallID().getName() + SEPARATOR + dep.getCompInstallID().getVersion().getVerString());
                        }
                        String[] saDeps = OiixVectorOps.list2StrArr(alDeps);
                        oVar.setType(4);
                        oVar.setValue(saDeps);
                        oVar.setDescription(OiixResourceBundle.getString("S_DEPENDEES_VARNAME_DESC"));
                        this.addToVarTable(oVar, id, true);
                        if (vVarnames.contains(oVar.getName().toLowerCase())) continue;
                        vVarnames.add(oVar.getName().toLowerCase());
                        continue;
                    }
                    if (oVar.getName().equals(OiixResourceBundle.getString("S_OPTIONAL_CONFIG_TOOLS_VAR_NAME"))) {
                        oVar.setType(1);
                        oVar.setValue("{}");
                        String sDesc = this.getOptionalConfigToolVariablePreText(oVar, oCompInstall);
                        if (sDesc == null) continue;
                        oVar.setDescription(sDesc);
                        this.addToVarTable(oVar, id, true);
                        if (vVarnames.contains(oVar.getName().toLowerCase())) continue;
                        vVarnames.add(oVar.getName().toLowerCase());
                        continue;
                    }
                    if (!oVar.getExported()) continue;
                    this.addToVarTable(oVar, id, true);
                    if (vVarnames.contains(oVar.getName().toLowerCase())) continue;
                    vVarnames.add(oVar.getName().toLowerCase());
                }
                enum_1 = oContext.getAllVariables();
                while (enum_1.hasMoreElements()) {
                    oVar = (OiisVariable)enum_1.nextElement();
                    if (!oVar.getGenerateRSP() || !oVar.getExported()) continue;
                    this.addToVarTable(oVar, id, true);
                    if (vVarnames.contains(oVar.getName().toLowerCase())) continue;
                    vVarnames.add(oVar.getName().toLowerCase());
                }
                OiisCompProperties props = oCompInstall.getProperties();
                Vector configTools = props.getConfigToolDetails();
                Vector<String> configToolVarNames = new Vector<String>(configTools.size());
                Vector<String> configToolRSPNames = new Vector<String>(configTools.size());
                int configSize = configTools.size();
                for (int k = 0; k < configSize; ++k) {
                    OiisConfigToolDetails details = (OiisConfigToolDetails)configTools.elementAt(k);
                    String sToolName = details.getConfigToolID().getInternalName();
                    configToolVarNames.add("s_" + sToolName + "_responseFileName");
                    String sCfgRspFile = OiicPullSession.getRecordModeResponseFileLocation() + "/" + sToolName + ".rsp";
                    configToolRSPNames.add(sCfgRspFile);
                }
                enum_1 = oContext.getAllVariables();
                while (enum_1.hasMoreElements()) {
                    Vector vVect;
                    int index;
                    OiisVariable oVar3 = (OiisVariable)enum_1.nextElement();
                    if (!oVar3.getExported() || (index = configToolVarNames.indexOf(oVar3.getName())) == -1 || (vVect = (Vector)this.m_hHashTable.get(oVar3.getName().toLowerCase())) == null) continue;
                    int iSize = vVect.size();
                    for (int k = 0; k < iSize; ++k) {
                        OiisVarHolder oHold = (OiisVarHolder)vVect.elementAt(k);
                        String strCompName = oHold.getComponentInternalName();
                        if (!oHold.getComponentVersion().equals(id.getVersion().toString())) continue;
                        oHold.setVarValue(configToolRSPNames.elementAt(index).toString());
                    }
                }
            }
            this.generateRSPVariables(out, vVarnames);
            out.close();
            fStream.close();
            this.copyRspToDefaultFile();
        }
        catch (IOException nCompsToInstall) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            out.flush();
            out.close();
        }
    }

    private void copyRspToDefaultFile() {
        if (null != this.getRecordModeFileName() && this.getRecordModeFileName().compareToIgnoreCase(this.sDefaultRecordFileName) != 0) {
            try {
                OiiolTextLogger.appendText("Copying " + this.getRecordModeFileName() + " to " + this.sDefaultRecordFileName, OiiolTextLogger.LOG_DETAILED);
                OiixFileOps.copyFile(this.getRecordModeFileName(), this.sDefaultRecordFileName, false, true, true, false, null, null, null, null, true);
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
            }
            catch (OiifbCancelException e) {
                OiiolTextLogger.appendException(e);
            }
        }
    }

    private boolean doRecModeStartupChecks() {
        String sRecordModeFileName = this.getRecordModeFileName();
        this.logMessage(OiixResourceBundle.getString("S_RECORD_MODE_BEGIN", new String[]{sRecordModeFileName}));
        String sRespLocation = this.getRecordModeFileName();
        String sDir = OiicPullSession.getRecordModeResponseFileLocation();
        File oParent = new File(sDir);
        try {
            OiipgFileSystem.checkWritablePath(sDir);
            OiipgFileSystem.mkdirs(oParent);
        }
        catch (OiipgPathException ie) {
            this.logMessage(ie.getMessage());
            OiiolTextLogger.appendText(ie.getMessage());
            this.setRecordModeFileName(this.sDefaultRecordFileName);
            sRespLocation = this.getRecordModeFileName();
            sDir = OiicPullSession.getRecordModeResponseFileLocation();
            oParent = new File(sDir);
            try {
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_ERR_RESP_FILE_CREATION", new String[]{sRecordModeFileName}), OiiolTextLogger.LOG_WARNING);
                OiipgFileSystem.checkWritablePath(sDir);
                OiipgFileSystem.mkdirs(oParent);
            }
            catch (OiipgPathException ie1) {
                OiiolTextLogger.appendText(ie.getMessage());
                return false;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(OiicLangAddonSession instSession) {
        if (!this.doRecModeStartupChecks(instSession)) {
            return;
        }
        String sRespLocation = this.getRecordModeFileName();
        File f = new File(sRespLocation);
        if (f.exists()) {
            this.logMessage(OiixResourceBundle.getString("S_RSP_FILE_EXISTS", new String[]{sRespLocation}));
            String strBakLoc = sRespLocation + m_sRspBakExt;
            File fBak = new File(strBakLoc);
            if (fBak.exists()) {
                fBak.delete();
            }
            File foriginal = new File(sRespLocation);
            foriginal.renameTo(fBak);
        }
        FileOutputStream fStream = null;
        PrintWriter out = null;
        try {
            fStream = new FileOutputStream(f);
            out = new PrintWriter(fStream);
        }
        catch (IOException ioe) {
            this.logMessage(ioe.getMessage());
            return;
        }
        OiicSessionContext session = instSession.getSessionContext();
        this.setHeader(out);
        out.println();
        out.println();
        out.println(OiizResourceBundle.getString("S_RSP_VERSTR") + S_EQUAL + OiizResourceBundle.getString("S_RSP_VERSION_2.2.1"));
        try {
            this.generateSessionVariables(instSession, out);
            OiisVariable oVar = session.getVariable(OiixResourceBundle.getString("S_SEL_LANG_VAR_NAME"));
            String[] strLangsList = (String[])oVar.getValue();
            Vector value = OiixLanguage.getLangsVector(strLangsList);
            String[] langs = new String[value.size()];
            int valSize = value.size();
            for (int k = 0; k < valSize; ++k) {
                Locale locale = (Locale)value.elementAt(k);
                langs[k] = locale.toString();
            }
            OiisVariable tempVar = new OiisVariable(session, new String(oVar.getName()));
            tempVar.setType(4);
            tempVar.setValue(langs);
            tempVar.setDescription(OiixResourceBundle.getString("S_COMPONENT_LANGUAGES_DESC"));
            this.writeVariableBlock(out, tempVar, true);
            out.close();
            fStream.close();
            this.copyRspToDefaultFile();
        }
        catch (IOException oVar) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            out.flush();
            out.close();
        }
    }

    public void write() {
        try {
            OiixIniSection oSection = this.m_IniFile.getSection(OiixResourceBundle.getString("S_RSP_SESSION"));
            this.updateSection(oSection, "NEXT_SESSION_RESPONSE", this.getNextResponseFileName(), OiixResourceBundle.getString("S_NEXT_SESSION_RSP_DESC"));
            this.m_IniFile.writeFile();
            this.logMessage(OiixResourceBundle.getString("S_RECORD_MODE_END"));
        }
        catch (IOException e) {
            String sMsg = e.getMessage();
            if (sMsg == null) {
                sMsg = OiixResourceBundle.getString("S_RSP_GEN_ERROR");
            }
            this.processError(sMsg, null);
            if (s_debug) {
                e.printStackTrace();
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String getNextResponseFileName() {
        String fileName;
        int nFileName;
        String curRSP = this.getRecordModeFileName();
        int count = ++this.m_nResponseFiles;
        String sNextFileLocation = this.getRecordModeFileName() + count;
        int nDir = OiixPathOps.getStandardForm(curRSP).lastIndexOf("/");
        if (nDir != -1 && (nFileName = (fileName = curRSP.substring(nDir)).lastIndexOf(".")) != -1) {
            sNextFileLocation = curRSP.substring(0, nDir) + fileName.substring(0, nFileName) + count + fileName.substring(nFileName);
        }
        this.setRecordModeFileName(sNextFileLocation);
        this.logMessage(OiixResourceBundle.getString("S_RECORD_MODE_NEXT_SESSION_FILE", new String[]{sNextFileLocation}));
        return sNextFileLocation;
    }

    private void generateSessionVariables(OiicInstallSession instSession, PrintWriter out) throws IOException {
        OiiiCompInstallID oCompID = instSession.getSelTopLevelCompID();
        OiicSessionContext oSessCon = instSession.getSessionContext();
        Enumeration vVect = oSessCon.getAllVariables();
        Object[] saTopLevelComp = null;
        String[] arrSession = OiicSessionContext.getSessionVariablesArray();
        int size = arrSession.length;
        OiisVariable oVarApplTop = null;
        OiisVariable oVarApplTopName = null;
        Object[] objs = new String[2];
        String sVarName = null;
        String sInitialValue = null;
        String sDefVal = "";
        saTopLevelComp = new String[]{oCompID.getName(), oCompID.getVersion().toString()};
        for (int i = 0; i < size; ++i) {
            String sDesc;
            String sDesc22;
            OiisVariable oVar = instSession.getSessionVariable(arrSession[i]);
            sVarName = oVar.getName();
            if (sVarName.equals("APPLTOP")) {
                oVarApplTop = oVar;
                continue;
            }
            if (sVarName.equals("APPLTOP_NAME")) {
                oVarApplTopName = oVar;
                continue;
            }
            if (sVarName.equals("TOPLEVEL_COMPONENT")) {
                OiisVariable oTLVar = new OiisVariable(instSession.getSessionContext(), "TOPLEVEL_COMPONENT");
                try {
                    oTLVar.setType(4);
                    oTLVar.setValue(new OiisAdvisedValue(saTopLevelComp, false));
                    oTLVar.setResourceBundle(new OiixJarResourceBundle(OiixResourceBundle.getBundle()));
                    oTLVar.setDescription(oVar.getDescription());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sDesc22 = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sInitialValue = OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TOPLEVEL_COMP_FORMAT");
                sInitialValue = MessageFormat.format(sInitialValue, saTopLevelComp);
                objs[0] = sVarName;
                objs[1] = sInitialValue;
                sDesc22 = MessageFormat.format(sDesc22, objs);
                oTLVar.setAllValueList(sDesc22);
                this.writeVariableBlock(out, oTLVar, true);
                continue;
            }
            if (sVarName.equals("DEINSTALL_LIST")) {
                sInitialValue = OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TOPLEVEL_COMP_FORMAT");
                sInitialValue = MessageFormat.format(sInitialValue, saTopLevelComp);
                OiisVariable oDLVar = new OiisVariable(instSession.getSessionContext(), "DEINSTALL_LIST");
                if (saTopLevelComp != null) {
                    try {
                        oDLVar.setType(4);
                        oDLVar.setValue(new OiisAdvisedValue(saTopLevelComp, false));
                        oDLVar.setResourceBundle(new OiixJarResourceBundle(OiixResourceBundle.getBundle()));
                        oDLVar.setDescription(oVar.getDescription());
                    }
                    catch (Exception sDesc22) {
                        // empty catch block
                    }
                }
                sDesc22 = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                objs[0] = sVarName;
                objs[1] = sInitialValue;
                sDesc22 = MessageFormat.format(sDesc22, objs);
                oDLVar.setAllValueList(sDesc22);
                this.writeVariableBlock(out, oDLVar, true);
                continue;
            }
            if (sVarName.equals("ANONYMOUS_LOGIN") || sVarName.equals("PASSWORD") || sVarName.equals("LOGIN_CATEGORY") || sVarName.equals("LOGIN_NAME") || sVarName.equals("REGISTRATION_KEYWORD") || sVarName.equals("STAGE_TO_LOCATION") || sVarName.equals("SELECTED_PLATFORMS")) continue;
            if (sVarName.equals("UNIX_GROUP_NAME")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\"install\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("REMOTE_NODES")) {
                if (!Boolean.getBoolean("oracle.installer.enableRollingUpgrade")) continue;
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "{\"node1\",\"node2\"}";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("CLUSTER_NODES")) {
                if (Boolean.getBoolean("oracle.srvm.formCluster")) continue;
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "{\"node1\",\"node2\"}";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("FROM_LOCATION")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\".." + File.separator + "stage" + File.separator + "products.xml" + "\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("FROM_LOCATION_CD_LABEL")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\"CD Label\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("NEXT_SESSION_RESPONSE")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\"nextinstall.rsp\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("ORACLE_BASE")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\"C:\\app\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("METALINK_USERNAME") || sVarName.equals("METALINK_PASSWORD") || sVarName.equals("METALINK_LOCATION")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("PROXY_HOST")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("PROXY_PORT")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("PROXY_REALM")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("PROXY_USER")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("PROXY_PWD")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("DONT_PROXY_FOR")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("ORACLE_HOME")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\"C:\\OHOME1\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("ORACLE_HOME_NAME")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\"OHOME1\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (sVarName.equals("SHOW_SPLASH_SCREEN") || sVarName.equals("SHOW_SUMMARY_PAGE") || sVarName.equals("SHOW_INSTALL_PROGRESS_PAGE") || sVarName.equals("SHOW_REQUIRED_CONFIG_TOOL_PAGE") || sVarName.equals("SHOW_CONFIG_TOOL_PAGE") || sVarName.equals("SHOW_RELEASE_NOTES") || sVarName.equals("SHOW_ROOTSH_CONFIRMATION") || sVarName.equals("SHOW_END_SESSION_PAGE") || sVarName.equals("SHOW_EXIT_CONFIRMATION") || sVarName.equals("NEXT_SESSION") || sVarName.equals("NEXT_SESSION_ON_FAIL") || sVarName.equals("SHOW_DEINSTALL_CONFIRMATION") || sVarName.equals("SHOW_DEINSTALL_PROGRESS") || sVarName.equals("ACCEPT_LICENSE_AGREEMENT")) {
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "true";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVar.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVar, true);
                continue;
            }
            if (!sVarName.equals("SHOW_WELCOME_PAGE") && !sVarName.equals("SHOW_COMPONENT_LOCATIONS_PAGE") && !sVarName.equals("SHOW_CUSTOM_TREE_PAGE")) continue;
            sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
            sDefVal = "false";
            objs[0] = sVarName;
            objs[1] = sDefVal;
            sDesc = MessageFormat.format(sDesc, objs);
            oVar.setAllValueList(sDesc);
            this.writeVariableBlock(out, oVar, true);
        }
        if (oCompID.getOracleHomeType() == 3) {
            if (oVarApplTop != null) {
                String sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\"C:\\APPLTOP1\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVarApplTop.setAllValueList(sDesc);
                this.writeVariableBlock(out, oVarApplTop, true);
            }
            if (oVarApplTopName != null) {
                String sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                sDefVal = "\"APPLTOP1\"";
                objs[0] = sVarName;
                objs[1] = sDefVal;
                sDesc = MessageFormat.format(sDesc, objs);
                oVarApplTopName.setAllValueList(sDesc);
            }
            this.writeVariableBlock(out, oVarApplTopName, true);
        }
    }

    private void generateGlobalVariables(OiicInstallSession instSession, PrintWriter out) throws IOException {
        List vars = instSession.getSessionContext().getGlobalVariables();
        if (null == vars || vars.size() == 0) {
            return;
        }
        for (int i = 0; i < vars.size(); ++i) {
            OiisVariable oVar = (OiisVariable)vars.get(i);
            this.writeVariableBlock(out, oVar, true);
        }
    }

    private void generateVariableBlock(OiixIniSection oSection, OiisVariable oVar) throws IOException {
        String sAllValues;
        String sVarName = oVar.getName();
        int nType = oVar.getType();
        Object oVarValue = oVar.getValue();
        String sValue = oVarValue != null && !oVar.isSecure() ? OiiozResponseFileWriter.getStringValue(oVar) : OiixResourceBundle.getString("S_RSP_DEF_VAL1");
        Vector<String> vComments = new Vector<String>(4);
        boolean i = false;
        vComments.addElement(sCommentChar + OiixResourceBundle.getString("S_RSP_PARAM_STR") + sVarName);
        vComments.addElement(sCommentChar + OiixResourceBundle.getString("S_RSP_TYPE_STR") + OiisVariable.getTypeString(nType));
        String desc = oVar.getDescription();
        String sVarDesc = OiiozResponseFileWriter.updateNewLine(oVar.getDescription());
        if (sVarDesc != null) {
            vComments.addElement(sCommentChar + OiixResourceBundle.getString("S_RSP_DESC_STR") + sVarDesc);
        }
        if ((sAllValues = oVar.getAllValueList()) != null) {
            vComments.addElement(sAllValues);
        }
        Object[] asComments = new String[vComments.size()];
        vComments.copyInto(asComments);
        this.updateSection(oSection, sVarName, sValue, (String[])asComments);
    }

    private OiixIniFile getResponseFileObject() {
        String sRespLocation = this.getRecordModeFileName();
        String sDir = OiicPullSession.getRecordModeResponseFileLocation();
        File oParent = new File(sDir);
        try {
            OiipgFileSystem.checkWritablePath(sDir);
            OiipgFileSystem.mkdirs(oParent);
        }
        catch (OiipgPathException ie) {
            this.logMessage(ie.getMessage());
            return null;
        }
        File f = new File(sRespLocation);
        if (f.exists()) {
            this.logMessage(OiixResourceBundle.getString("S_RSP_FILE_EXISTS", new String[]{sRespLocation}));
            f.delete();
        }
        this.m_IniFile = new OiixIniFile(sRespLocation, true);
        this.setHeader();
        this.setGeneralSection();
        return this.m_IniFile;
    }

    private static String[] getVariableHeader(OiisVariable oVar) {
        Vector<String> vVect = new Vector<String>();
        vVect.add(sCommentChar + S_RSP_SEPARATOR_LINE);
        String str = OiizResourceBundle.getString("S_RSP_PARAM_STR") + oVar.getName();
        vVect.add(sCommentChar + str);
        str = OiizResourceBundle.getString("S_RSP_TYPE_STR") + OiisVariable.getTypeString(oVar.getType());
        vVect.add(sCommentChar + str);
        str = oVar.getDescription();
        if (str != null) {
            str = OiiozResponseFileWriter.updateNewLine(oVar.getDescription());
            str = sCommentChar + OiizResourceBundle.getString("S_RSP_DESC_STR") + str;
            vVect.add(str);
        }
        if (oVar.getAllValueList() != null) {
            vVect.add(oVar.getAllValueList());
        }
        vVect.add(sCommentChar + S_RSP_SEPARATOR_LINE);
        String[] strArray = new String[vVect.size()];
        for (int i = 0; i < vVect.size(); ++i) {
            strArray[i] = vVect.elementAt(i).toString();
        }
        return strArray;
    }

    public void writeVariableBlock(PrintWriter oPrntWrite, String strVarName, OiisVarHolder oVar) {
        String str = null;
        oPrntWrite.println();
        oPrntWrite.println(sCommentChar + S_RSP_SEPARATOR_LINE);
        oPrntWrite.println(sCommentChar + OiizResourceBundle.getString("S_RSP_PARAM_STR") + strVarName);
        oPrntWrite.println(sCommentChar + OiizResourceBundle.getString("S_RSP_TYPE_STR") + oVar.getVariableDataType());
        if (oVar.getVariableDescription() != null) {
            str = oVar.getVariableDescription();
            str = OiiozResponseFileWriter.updateNewLine(str);
            str = sCommentChar + OiizResourceBundle.getString("S_RSP_DESC_STR") + str;
            oPrntWrite.println(str);
        }
        if (oVar.getVarAllValue() != null) {
            str = oVar.getVarAllValue();
            oPrntWrite.println(str);
        }
        Object[] sArgs = new String[]{oVar.getComponentInternalName()};
        String sString = OiizResourceBundle.getString("S_RSP_COMP_NAME_STR", sArgs);
        oPrntWrite.println(sCommentChar + sString);
        oPrntWrite.println(sCommentChar + S_RSP_SEPARATOR_LINE);
        oPrntWrite.println();
    }

    public void writeVariableBlock(PrintWriter out, OiisVariable oVar, boolean bFlag) {
        this.writeVariableBlock(out, oVar, bFlag, false);
    }

    public void writeVariableBlock(PrintWriter out, OiisVariable oVar, boolean bFlag, boolean bComment) {
        Object oVarValue;
        OiisAdvisedValue oVal;
        String[] strHeader = OiiozResponseFileWriter.getVariableHeader(oVar);
        out.println();
        for (int i = 0; i < strHeader.length; ++i) {
            out.println(strHeader[i]);
        }
        String sValue = null;
        sValue = !bFlag ? ((oVal = oVar.getInitialValue()) == null ? (oVar.isCalcMethodPresent() ? OiizResourceBundle.getString("S_RSP_DEF_VAL1") : OiizResourceBundle.getString("S_RSP_DEF_VAL2")) : (String)oVal.getValue()) : ((oVarValue = oVar.getValue()) != null && !oVar.isSecure() ? OiiozResponseFileWriter.getStringValue(oVar) : OiixResourceBundle.getString("S_RSP_DEF_VAL1"));
        if (bComment) {
            out.println(sCommentChar + oVar.getName() + S_EQUAL + sValue);
        } else {
            out.println(oVar.getName() + S_EQUAL + sValue);
        }
    }

    private void updateSection(OiixIniSection oSection, String sName, String sValue, String sDesc) {
        String[] asComments = null;
        if (sDesc != null) {
            asComments = new String[]{sDesc};
        }
        this.updateSection(oSection, sName, sValue, asComments);
    }

    public void updateSection(OiixIniSection oSection, String sName, String sValue, String[] asComments) {
        OiixIniPair oPair = oSection.getPair(sName);
        if (oPair == null) {
            if (asComments != null && asComments.length > 0) {
                int i = 0;
                String sHdr = asComments[i];
                OiixIniComment oComment = new OiixIniComment(sHdr);
                if (asComments.length > 1) {
                    for (i = 1; i < asComments.length; ++i) {
                        oComment.addLine(asComments[i]);
                    }
                    oSection.addItem(oComment);
                }
            }
            try {
                oPair = new OiixIniPair(sName, sValue);
                oSection.addItem(oPair);
                oSection.addItem(new OiixIniRawText(sNewLine));
            }
            catch (OiixIniParsingException e) {
                e.printStackTrace();
            }
        } else {
            String sOrigVal = oPair.getValue();
            if (sValue != null) {
                oPair.setValue(sValue);
            }
        }
    }

    private void setGeneralSection() {
        String sSection = OiixResourceBundle.getString("S_RSP_GENERAL");
        OiixIniSection oSection = this.m_IniFile.addSection(sSection);
        String[] asComments = new String[]{};
        this.updateSection(oSection, OiixResourceBundle.getString("S_RSP_VERSTR"), OiixResourceBundle.getString("S_RSP_VERSION"), asComments);
    }

    public void setHeader(PrintWriter out) {
        for (int i = 1; i < 25; ++i) {
            if (2 == i) {
                Object[] oHdrArgs = new Object[]{Integer.toString(Calendar.getInstance().get(1))};
                String sCopyRightInfo = OiizResourceBundle.getString("S_RSP_HEADING_COPYRIGHT");
                String sCopyRightHdr = MessageFormat.format(sCopyRightInfo, oHdrArgs);
                out.println(sCopyRightHdr);
                continue;
            }
            out.println(OiizResourceBundle.getString("S_RSP_HEADING" + i));
        }
    }

    private void setHeader() {
        OiixIniComment oComment = null;
        int i = 1;
        String sHdr = OiixResourceBundle.getString("S_RSP_HEADING" + i);
        oComment = new OiixIniComment(sHdr);
        for (i = 2; i < 25; ++i) {
            oComment.addLine(OiixResourceBundle.getString("S_RSP_HEADING" + i));
        }
        this.m_IniFile.addItem(oComment);
    }

    static String updateNewLine(String sStr) {
        return OiiozResponseFileWriter.updateNewLine(sStr, "\n");
    }

    static String updateNewLine(String sStr, String sReplacee) {
        if (sStr == null) {
            return null;
        }
        String sReplacer = sNewLine + sCommentChar;
        String sVar = OiixFunctionOps.replaceStr(sStr, sReplacer, sReplacee);
        sVar = OiixFunctionOps.replaceStr(sVar, sReplacee, sReplacer);
        if (sStr.endsWith(sReplacee) && sVar.endsWith(sReplacer)) {
            sVar = sVar.substring(0, sVar.length() - 1);
        }
        return sVar;
    }

    public void processError(String errmsg, Vector oDetails) {
        this.m_bError = true;
        String sMsg = OiixResourceBundle.getString("S_ERROR");
        this.logMessage(sMsg + errmsg);
        if (errmsg == null) {
            new Throwable().printStackTrace(System.err);
        }
    }

    private void logMessage(String msg) {
        if (OiicPullSession.isSilentMode()) {
            OiiolTextLogger.appendErrorText(msg);
        } else {
            OiiolTextLogger.appendText(msg);
        }
    }

    public String getValue(String sSectionName, String lhs) {
        OiixIniSection oSection = this.m_IniFile.getSection(sSectionName);
        OiixIniPair oPair = oSection.getPair(lhs);
        if (oPair != null) {
            return oPair.getValue();
        }
        return null;
    }

    public void setValue(String sSectionName, String lhs, String rhs) {
        OiixIniSection oSection = this.m_IniFile.getSection(sSectionName);
        OiixIniPair oPair = oSection.getPair(lhs);
        if (oPair != null) {
            oPair.setValue(rhs);
        }
    }

    public static String getStringValue(OiisVariable oVar) {
        String sValue;
        if (oVar == null || oVar.getValue() == null) {
            return "";
        }
        Object oVarValue = oVar.getValue();
        switch (oVar.getType()) {
            case 2: {
                sValue = ((Integer)oVarValue).toString();
                break;
            }
            case 4: {
                String[] strList = (String[])oVarValue;
                StringBuffer sbuf = new StringBuffer("{");
                int len = strList.length;
                if (len > 0) {
                    sbuf.append("\"");
                    sbuf.append(strList[0]);
                    sbuf.append("\"");
                    for (int i = 1; i < len; ++i) {
                        sbuf.append(",");
                        sbuf.append("\"");
                        sbuf.append(strList[i]);
                        sbuf.append("\"");
                    }
                }
                sbuf.append("}");
                sValue = sbuf.toString();
                break;
            }
            case 3: {
                sValue = ((Boolean)oVarValue).toString();
                break;
            }
            case 1: {
                sValue = "\"" + (String)oVarValue + "\"";
                break;
            }
            default: {
                sValue = "";
            }
        }
        return sValue;
    }

    private String getOptionalConfigToolVariablePreText(OiisVariable oVar, OiisCompInstallation ci) {
        String sSampleValue;
        OiixJarResourceBundle jrb = new OiixJarResourceBundle(OiixResourceBundle.getBundle());
        String sNewLine = System.getProperty("line.separator");
        OiisCompProperties compProps = ci.getProperties();
        Vector vTools = compProps.getConfigToolDetails();
        int nTools = vTools.size();
        OiisCompContext oContext = ci.getContext();
        String sConfigsList = OiixResourceBundle.getString("S_OPTCONFIGTOOLS_VARNAME_DESC");
        if (nTools > 0) {
            sSampleValue = "";
            int nOptionalConfigTools = 0;
            for (int i = 0; i < nTools; ++i) {
                OiisConfigToolDetails cd = (OiisConfigToolDetails)vTools.elementAt(i);
                OiisCompJarLoader cjl = ci.getCompJarLoader();
                OiisPostInstallTool pTool = null;
                try {
                    String toolClassName = cd.getToolClassName();
                    if (toolClassName != null && toolClassName.length() > 0) {
                        OiiolTextLogger.appendText("************************ " + toolClassName);
                        pTool = cjl.loadConfigTool(toolClassName);
                        pTool.initToolProperties();
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (pTool == null) continue;
                pTool.setCompContext(oContext);
                if (pTool.isRequired()) continue;
                ++nOptionalConfigTools;
                String s = OiixResourceBundle.getString("S_ALL_VALUE_COMPS_FROMAT");
                Object[] objs = new String[]{cd.getConfigToolID().getInternalName(), " ", cd.getExternalName()};
                s = MessageFormat.format(s, objs);
                sConfigsList = sConfigsList + sNewLine + s;
                if (!sSampleValue.equals("")) continue;
                sSampleValue = OiixResourceBundle.getEnglishString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_STRLIST_FROMAT");
                objs = new String[]{cd.getConfigToolID().getInternalName()};
                sSampleValue = MessageFormat.format(sSampleValue, objs);
            }
            if (nOptionalConfigTools <= 0) {
                return null;
            }
        } else {
            return null;
        }
        String sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
        Object[] objs = new String[]{oVar.getName(), sSampleValue};
        sDesc = MessageFormat.format(sDesc, objs);
        sConfigsList = sConfigsList + sNewLine + sDesc;
        String sChoices = OiixResourceBundle.getString("S_CHOICES1_FORMAT") + sNewLine;
        sChoices = sChoices + OiixResourceBundle.getString("S_CHOICES3_FORMAT");
        sConfigsList = sChoices + sConfigsList;
        return sConfigsList;
    }
}

