/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiol.OiiolConfigLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolConfigLogHandler;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.oix.oixs.OixsXMLizable;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OiiolXMLConfigLog
implements OixsXMLizable {
    private Vector m_vConfigTools = new Vector(5, 1);
    private String m_sXMLConfigLogPath;
    private OiiiCompInstallID m_compID;

    public OiiolXMLConfigLog(String sConfigLogPath) {
        this.m_sXMLConfigLogPath = OiixPathOps.getStandardForm(sConfigLogPath);
    }

    public String getLogPath() {
        return this.m_sXMLConfigLogPath;
    }

    public void setCompID(OiiiCompInstallID compID) {
        this.m_compID = compID;
    }

    public boolean equals(Object obj) {
        OiiolXMLConfigLog oLog;
        String sConfigLogPath;
        return obj instanceof OiiolXMLConfigLog && OiipgFileSystem.equalPathStrs(sConfigLogPath = OiixPathOps.getNativeForm((oLog = (OiiolXMLConfigLog)obj).getLogPath()), this.m_sXMLConfigLogPath);
    }

    public void addConfigToolForLog(OiisPostInstallTool oTool) {
        this.m_vConfigTools.addElement(oTool);
    }

    public void addConfigToolForDeinstallLog(OiisPostInstallTool oTool) {
        oTool.setDeinstall(true);
        this.m_vConfigTools.addElement(oTool);
    }

    public void writeConfigLog() throws IOException {
        this.writeConfigLog(null);
    }

    public void writeConfigLog(Vector vConfigLogEntries) throws IOException {
        String sParentDir = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(this.m_sXMLConfigLogPath));
        File oParentDir = new File(OiixPathOps.getNativeForm(sParentDir));
        OiixFileOps.mkdirs(oParentDir);
        String sConfigLogNativePath = OiixPathOps.getNativeForm(this.m_sXMLConfigLogPath);
        File oLogFile = new File(sConfigLogNativePath);
        FileOutputStream oFOStream = new FileOutputStream(oLogFile);
        BufferedWriter oBufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)oFOStream, "UTF-8"));
        PrintWriter oPrintWriter = new PrintWriter(oBufferedWriter);
        oPrintWriter.println(OixsXMLOps.createXMLDirective(true));
        oPrintWriter.println(OixsXMLOps.getStandardHeader());
        XMLElement oConfigList = null;
        oConfigList = vConfigLogEntries == null ? this.buildDOMTree() : this.buildDOMTree(vConfigLogEntries);
        oConfigList.print(oPrintWriter);
        if (oPrintWriter != null) {
            oPrintWriter.close();
        }
        if (oBufferedWriter != null) {
            oBufferedWriter.close();
        }
        if (oFOStream != null) {
            oFOStream.close();
        }
    }

    @Override
    public void writeXML(PrintWriter oPrintWriter) throws IOException {
        XMLElement oXMLEntry = this.buildDOMTree();
        oXMLEntry.print(oPrintWriter);
    }

    @Override
    public XMLElement toXML() {
        return this.buildDOMTree();
    }

    protected XMLElement buildDOMTree() {
        int nConfigToolCount = this.m_vConfigTools.size();
        XMLElement elemConfigList = new XMLElement("CONFIG_LIST");
        int deinstallCount = 0;
        for (int i = 0; i < nConfigToolCount; ++i) {
            OiisPostInstallTool oConfigTool = (OiisPostInstallTool)this.m_vConfigTools.elementAt(i);
            if (!oConfigTool.isDeinstall()) continue;
            ++deinstallCount;
            XMLElement elemTool = new XMLElement("CT");
            elemTool.setAttribute("NAME", oConfigTool.getName());
            if (oConfigTool.isSilentInstall()) {
                elemTool.setAttribute("SUPPORT_SILENT", "T");
                XMLElement elemSilent = new XMLElement("SILENT");
                elemSilent.setAttribute("CMD", oConfigTool.getSilentDeinstallCmdLine(true));
                elemTool.appendChild((Node)elemSilent);
            } else {
                elemTool.setAttribute("SUPPORT_SILENT", "F");
            }
            XMLElement elemInteractive = new XMLElement("INTERACTIVE");
            elemInteractive.setAttribute("CMD", oConfigTool.getInteractiveDeinstallCmdLine(true));
            elemTool.appendChild((Node)elemInteractive);
            elemConfigList.appendChild((Node)elemTool);
        }
        elemConfigList.setAttribute("SIZE", String.valueOf(deinstallCount));
        return elemConfigList;
    }

    protected XMLElement buildDOMTree(Vector vConfigLogEntries) {
        int nConfigToolCount = vConfigLogEntries.size();
        XMLElement elemConfigList = new XMLElement("CONFIG_LIST");
        elemConfigList.setAttribute("SIZE", new Integer(nConfigToolCount).toString());
        for (int i = 0; i < nConfigToolCount; ++i) {
            OiiolConfigLogEntry oEntry = (OiiolConfigLogEntry)vConfigLogEntries.elementAt(i);
            XMLElement elemTool = new XMLElement("CT");
            elemTool.setAttribute("NAME", "");
            if (oEntry.isToolSilentMode()) {
                elemTool.setAttribute("SUPPORT_SILENT", "T");
                XMLElement elemSilent = new XMLElement("SILENT");
                elemSilent.setAttribute("CMD", oEntry.getSilentCL());
                elemTool.appendChild((Node)elemSilent);
            } else {
                elemTool.setAttribute("SUPPORT_SILENT", "F");
            }
            XMLElement elemInteractive = new XMLElement("INTERACTIVE");
            elemInteractive.setAttribute("CMD", oEntry.getInteractiveCL());
            elemTool.appendChild((Node)elemInteractive);
            elemConfigList.appendChild((Node)elemTool);
        }
        return elemConfigList;
    }

    public XMLElement getComponentTools() {
        int nConfigToolCount = this.m_vConfigTools.size();
        XMLElement component = new XMLElement("COMP");
        component.setAttribute("NAME", this.m_compID.getName());
        component.setAttribute("VER", this.m_compID.getVersion().getVerString());
        component.setAttribute("SIZE", String.valueOf(nConfigToolCount));
        for (int i = 0; i < nConfigToolCount; ++i) {
            OiisPostInstallTool oConfigTool = (OiisPostInstallTool)this.m_vConfigTools.elementAt(i);
            XMLElement elemTool = new XMLElement("CT");
            elemTool.setAttribute("NAME", oConfigTool.getName());
            if (oConfigTool.isSilentInstall()) {
                elemTool.setAttribute("SUPPORT_SILENT", "T");
            } else {
                elemTool.setAttribute("SUPPORT_SILENT", "F");
            }
            if (oConfigTool.isRequired()) {
                elemTool.setAttribute("RECOMMENDED", "T");
            } else {
                elemTool.setAttribute("RECOMMENDED", "F");
            }
            if (oConfigTool.isAutoLaunch()) {
                elemTool.setAttribute("LAUNCH_ON_EXIT", "F");
            } else {
                elemTool.setAttribute("LAUNCH_ON_EXIT", "T");
            }
            XMLElement install = new XMLElement("INSTALL");
            if (oConfigTool.isSilentInstall()) {
                XMLElement elemSilent = new XMLElement("SILENT");
                elemSilent.setAttribute("CMD", oConfigTool.getSilentInstallCmdLine(true));
                install.appendChild((Node)elemSilent);
            }
            XMLElement elemInteractive = new XMLElement("INTERACTIVE");
            elemInteractive.setAttribute("CMD", oConfigTool.getInteractiveInstallCmdLine(true));
            install.appendChild((Node)elemInteractive);
            elemTool.appendChild((Node)install);
            if (oConfigTool.isClone()) {
                XMLElement clone = new XMLElement("CLONE");
                clone.setAttribute("CMD", oConfigTool.getCloneCmdLine(true));
                elemTool.appendChild((Node)clone);
            }
            if (oConfigTool.isDeinstall()) {
                XMLElement deinstall = new XMLElement("DEINSTALL");
                if (oConfigTool.isSilentInstall()) {
                    XMLElement elemSilent = new XMLElement("SILENT");
                    elemSilent.setAttribute("CMD", oConfigTool.getSilentDeinstallCmdLine(true));
                    deinstall.appendChild((Node)elemSilent);
                }
                elemInteractive = new XMLElement("INTERACTIVE");
                elemInteractive.setAttribute("CMD", oConfigTool.getInteractiveDeinstallCmdLine(true));
                deinstall.appendChild((Node)elemInteractive);
                elemTool.appendChild((Node)deinstall);
            }
            component.appendChild((Node)elemTool);
        }
        return component;
    }

    public Vector readConfigLogEntries() {
        Vector vConfigLogEntries = new Vector();
        try {
            Parser m_xmlParser = OixsXMLOps.createSAXParser();
            OiiolConfigLogHandler handlerConfigLog = new OiiolConfigLogHandler();
            FileReader fLogReader = new FileReader(OiixPathOps.getNativeForm(this.m_sXMLConfigLogPath));
            BufferedReader bufferedLogReader = new BufferedReader(fLogReader);
            m_xmlParser.setDocumentHandler(handlerConfigLog);
            m_xmlParser.setErrorHandler(handlerConfigLog);
            m_xmlParser.parse(new InputSource(bufferedLogReader));
            bufferedLogReader.close();
            fLogReader.close();
            vConfigLogEntries = handlerConfigLog.getConfigLogEntries();
        }
        catch (SAXException sxe) {
            sxe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return vConfigLogEntries;
    }

    public static void main(String[] args) {
        String sLogLoc = args[0];
        OiiolXMLConfigLog oLog = new OiiolXMLConfigLog(sLogLoc);
        Vector v = oLog.readConfigLogEntries();
        System.out.println("entry count = " + v.size());
    }
}

