/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiol;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiLogBlockHeader;
import oracle.sysman.oii.oiio.oiiol.OiiolActionLogEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolLogManipulator;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiolInstallLog
implements OiiolLogManipulator {
    private static final int BLOCK_HEADER_SIZE = 110;
    static final int NUM_BLOCK_ENTRIES = 25;
    static final int SAFE_BLOCK_SIZE = 10240;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 65536;
    private RandomAccessFile m_raf;
    private Vector m_blockHeaders = null;
    private int m_blockIndex = -1;
    private int m_entryIndex = -1;
    private String m_logLoc;
    private ObjectInputStream m_ois;
    private Vector m_currentBlockEntries;
    private ByteArrayOutputStream m_baos;
    private ObjectOutputStream m_oos;
    private int m_oldStreamSize;

    public OiiolInstallLog(String logLoc) throws IOException {
        this.m_logLoc = OiixPathOps.getNativeForm(logLoc);
        this.m_raf = new RandomAccessFile(this.m_logLoc, "rw");
        this.readBlockHeaders();
    }

    @Override
    public String getLogFileName() {
        return this.m_logLoc;
    }

    private void readBlockHeaders() throws IOException {
        long curFilePos = 0L;
        this.m_blockHeaders = new Vector();
        byte[] headerBuf = new byte[110];
        this.m_raf.seek(curFilePos);
        while (this.m_raf.read(headerBuf) == 110) {
            OiLogBlockHeader lh = new OiLogBlockHeader(headerBuf);
            this.m_blockHeaders.addElement(lh);
            this.m_raf.seek(curFilePos += (long)(110 + lh.getBlockLength()));
        }
    }

    public boolean isReversed() {
        boolean rev = false;
        if (this.m_blockHeaders.size() > 0) {
            rev = ((OiLogBlockHeader)this.m_blockHeaders.firstElement()).isReversed();
        }
        return rev;
    }

    public void setReversed(boolean rev) throws IOException {
        if (this.m_blockHeaders.size() > 0) {
            OiLogBlockHeader firstHeader = (OiLogBlockHeader)this.m_blockHeaders.firstElement();
            firstHeader.setReversed(rev);
            firstHeader.writeHeader(this.m_raf);
        }
    }

    private void closeInputStream() throws IOException {
        if (this.m_ois != null) {
            this.m_ois.close();
            this.m_ois = null;
        }
    }

    public void openRead() throws IOException {
        this.m_blockIndex = -1;
        this.m_entryIndex = -1;
        this.closeInputStream();
        if (this.m_raf == null) {
            this.m_raf = new RandomAccessFile(this.m_logLoc, "rw");
            this.readBlockHeaders();
        }
    }

    public boolean hasMoreEntries() {
        int numHeaders = this.m_blockHeaders.size();
        int startBlockIndex = this.m_blockIndex != -1 ? this.m_blockIndex : 0;
        boolean moreEntries = false;
        for (int i = startBlockIndex; i < numHeaders; ++i) {
            OiLogBlockHeader lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(i);
            int firstInd = this.m_entryIndex < lh.getStartIndex() ? -1 : this.m_entryIndex - lh.getStartIndex();
            if ((firstInd = lh.firstEntryAfter(firstInd)) == -1) continue;
            moreEntries = true;
            break;
        }
        return moreEntries;
    }

    public boolean hasMoreEntriesReverse() {
        int numHeaders = this.m_blockHeaders.size();
        int startBlockIndex = this.m_blockIndex != -1 ? this.m_blockIndex : numHeaders - 1;
        boolean moreEntries = false;
        for (int i = startBlockIndex; i >= 0; --i) {
            OiLogBlockHeader lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(i);
            int firstInd = this.m_entryIndex == -1 ? lh.getNumEntries() - 1 : this.m_entryIndex - lh.getStartIndex();
            if ((firstInd = lh.firstEntryBefore(firstInd)) == -1) continue;
            moreEntries = true;
            break;
        }
        return moreEntries;
    }

    public OiiolActionLogEntry getNextEntry() {
        OiiolActionLogEntry logEntry = null;
        try {
            logEntry = this.nextEntry();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logEntry;
    }

    public OiiolActionLogEntry nextEntry() throws IOException, ClassNotFoundException {
        OiLogBlockHeader lh = null;
        int numHeaders = this.m_blockHeaders.size();
        int oldBlockIndex = this.m_blockIndex;
        int oldEntryIndex = this.m_entryIndex;
        if (this.m_blockIndex == -1) {
            this.m_blockIndex = 0;
        }
        for (int i = this.m_blockIndex; i < numHeaders; ++i) {
            lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(i);
            int firstInd = this.m_entryIndex < lh.getStartIndex() ? -1 : this.m_entryIndex - lh.getStartIndex();
            if ((firstInd = lh.firstEntryAfter(firstInd)) == -1) continue;
            this.m_blockIndex = i;
            this.m_entryIndex = lh.getStartIndex() + firstInd;
            break;
        }
        if (this.m_entryIndex != -1) {
            if (this.m_blockIndex > oldBlockIndex) {
                lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(this.m_blockIndex);
                this.initBlockInputStream(lh);
            }
            int startSkipIndex = oldEntryIndex == -1 || this.m_blockIndex > oldBlockIndex ? lh.getStartIndex() : oldEntryIndex + 1;
            int skipEntries = this.m_entryIndex - startSkipIndex;
            for (int i = 0; i < skipEntries; ++i) {
                this.m_ois.readObject();
            }
            OiiolActionLogEntry logEntry = (OiiolActionLogEntry)this.m_ois.readObject();
            return logEntry;
        }
        return null;
    }

    public OiiolActionLogEntry nextEntryReverse() throws IOException, ClassNotFoundException {
        OiLogBlockHeader lh = null;
        int numHeaders = this.m_blockHeaders.size();
        int oldBlockIndex = this.m_blockIndex;
        int oldEntryIndex = this.m_entryIndex;
        if (this.m_blockIndex == -1) {
            this.m_blockIndex = numHeaders - 1;
        }
        for (int i = this.m_blockIndex; i >= 0; --i) {
            lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(i);
            int firstInd = this.m_entryIndex == -1 ? lh.getNumEntries() : this.m_entryIndex - lh.getStartIndex();
            if ((firstInd = lh.firstEntryBefore(firstInd)) == -1) continue;
            this.m_blockIndex = i;
            this.m_entryIndex = lh.getStartIndex() + firstInd;
            break;
        }
        if (this.m_entryIndex != -1) {
            if (this.m_blockIndex < oldBlockIndex || oldBlockIndex == -1) {
                lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(this.m_blockIndex);
                this.initBlockInputStream(lh);
                this.readBlockEntries(lh);
            }
            int relIndex = this.m_entryIndex - lh.getStartIndex();
            OiiolActionLogEntry logEntry = (OiiolActionLogEntry)this.m_currentBlockEntries.elementAt(relIndex);
            return logEntry;
        }
        return null;
    }

    private void readBlockEntries(OiLogBlockHeader lh) throws IOException, ClassNotFoundException {
        int nEntries = lh.getNumEntries();
        this.m_currentBlockEntries = new Vector(nEntries);
        for (int i = 0; i < nEntries; ++i) {
            OiiolActionLogEntry oEntry = (OiiolActionLogEntry)this.m_ois.readObject();
            this.m_currentBlockEntries.addElement(oEntry);
        }
    }

    private void initBlockInputStream(OiLogBlockHeader lh) throws IOException {
        this.closeInputStream();
        int blockSize = lh.getBlockLength();
        long filePos = lh.getFilePos() + 110L;
        byte[] byteArray = new byte[blockSize];
        this.m_raf.seek(filePos);
        this.m_raf.read(byteArray);
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        this.m_ois = new ObjectInputStream(bais);
    }

    private void closeOutputStream() throws IOException {
        if (this.m_oos != null) {
            this.m_oos.close();
            this.m_baos.close();
            this.m_oos = null;
        }
    }

    @Override
    public void startWrite() throws IOException {
        if (this.m_raf == null) {
            this.m_raf = new RandomAccessFile(this.m_logLoc, "rw");
            this.readBlockHeaders();
        }
        int numHeaders = this.m_blockHeaders.size();
        long filePos = 0L;
        int startIndex = 0;
        if (numHeaders > 0) {
            OiLogBlockHeader lh = (OiLogBlockHeader)this.m_blockHeaders.lastElement();
            startIndex = lh.getStartIndex() + lh.getNumEntries();
            filePos = lh.getFilePos() + 110L + (long)lh.getBlockLength();
        }
        OiLogBlockHeader newHeader = new OiLogBlockHeader(startIndex, filePos);
        this.m_blockHeaders.addElement(newHeader);
        this.closeOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.closeInputStream();
        this.closeOutputStream();
        if (this.m_raf != null) {
            this.m_raf.close();
            this.m_raf = null;
        }
    }

    public void writeEntry(OiiolActionLogEntry oEntry) throws IOException {
        this.addEntry(oEntry);
    }

    @Override
    public void addEntry(OiiolActionLogEntry logEntry) throws IOException {
        OiLogBlockHeader lh = (OiLogBlockHeader)this.m_blockHeaders.lastElement();
        if (lh.isFull()) {
            this.closeOutputStream();
            int startIndex = lh.getStartIndex() + lh.getNumEntries();
            long filePos = lh.getFilePos() + 110L + (long)lh.getBlockLength();
            OiLogBlockHeader newHeader = new OiLogBlockHeader(startIndex, filePos);
            this.m_blockHeaders.addElement(newHeader);
            lh = newHeader;
        }
        if (lh.getNumEntries() == 0) {
            this.m_baos = new ByteArrayOutputStream();
            this.m_oos = new ObjectOutputStream(this.m_baos);
            this.m_oldStreamSize = 0;
        }
        this.m_oos.writeObject(logEntry);
        byte[] byteArray = this.m_baos.toByteArray();
        int newSize = byteArray.length;
        int extraSize = newSize - this.m_oldStreamSize;
        boolean bSpaceChecked = false;
        while (true) {
            this.m_raf.seek(lh.getFilePos() + 110L + (long)this.m_oldStreamSize);
            try {
                this.m_raf.write(byteArray, this.m_oldStreamSize, extraSize);
                break;
            }
            catch (IOException e) {
                if (bSpaceChecked) {
                    throw e;
                }
                try {
                    OiixFileOps.validateDiskSpace(extraSize, this.m_logLoc, false);
                    bSpaceChecked = true;
                }
                catch (OiifbCancelException ie) {
                    throw new IOException(ie.getMessage());
                }
            }
        }
        lh.addEntry(extraSize);
        lh.writeHeader(this.m_raf);
        this.m_oldStreamSize = newSize;
        byteArray = null;
    }

    @Override
    public void markCurrentEntry() throws IOException {
        if (this.m_entryIndex != -1) {
            OiLogBlockHeader lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(this.m_blockIndex);
            int relIndex = this.m_entryIndex - lh.getStartIndex();
            lh.markEntry(relIndex);
            lh.writeHeader(this.m_raf);
        }
    }

    public void terminateLog() throws IOException, ClassNotFoundException {
        long readBytesTotal;
        int readBytes;
        if (this.m_entryIndex == -1) {
            return;
        }
        OiLogBlockHeader lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(this.m_blockIndex);
        this.initBlockInputStream(lh);
        this.m_raf.close();
        String tempLoc = this.m_logLoc + ".tmp";
        FileOutputStream fos = new FileOutputStream(tempLoc);
        FileInputStream fis = new FileInputStream(this.m_logLoc);
        long numBytes = lh.getFilePos();
        int bufSize = 512;
        if (numBytes < (long)bufSize) {
            bufSize = (int)numBytes;
        }
        BufferedOutputStream bos = new BufferedOutputStream(fos, bufSize);
        byte[] buf = new byte[bufSize];
        for (readBytesTotal = 0L; readBytesTotal < numBytes && (readBytes = fis.read(buf, 0, bufSize)) != -1; readBytesTotal += (long)readBytes) {
            bos.write(buf, 0, readBytes);
        }
        if (readBytesTotal < numBytes) {
            throw new IOException(OiixResourceBundle.getString("S_XCPT_UNEXPECTED_EOF"));
        }
        bos.flush();
        int numLastBlockEntries = this.m_entryIndex - lh.getStartIndex();
        if (numLastBlockEntries > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            for (int i = 0; i < numLastBlockEntries; ++i) {
                OiiolActionLogEntry logEntry = (OiiolActionLogEntry)this.m_ois.readObject();
                oos.writeObject(logEntry);
            }
            oos.flush();
            byte[] byteArray = baos.toByteArray();
            OiLogBlockHeader newHeader = new OiLogBlockHeader(lh.getStartIndex(), lh.getFilePos());
            newHeader.addEntry(byteArray.length);
            for (int i = 1; i < numLastBlockEntries; ++i) {
                newHeader.addEntry(0);
            }
            byte[] headerByteArray = newHeader.toByteArray();
            bos.write(headerByteArray);
            int spaceBytes = 110 - headerByteArray.length;
            for (int i = 0; i < spaceBytes; ++i) {
                bos.write(0);
            }
            bos.write(byteArray);
            bos.flush();
        }
        fis.close();
        fos.close();
        this.closeInputStream();
        this.deleteAndRename(tempLoc);
        this.m_raf = new RandomAccessFile(this.m_logLoc, "rw");
        this.readBlockHeaders();
    }

    public void reverseLog() throws IOException, ClassNotFoundException {
        String tempLoc = this.m_logLoc + ".tmp";
        OiiolInstallLog tmpLog = new OiiolInstallLog(tempLoc);
        tmpLog.startWrite();
        this.closeInputStream();
        int numHeaders = this.m_blockHeaders.size();
        for (int m_blockIndex = numHeaders - 1; m_blockIndex >= 0; --m_blockIndex) {
            OiiolActionLogEntry logEntry;
            int i;
            Vector<OiiolActionLogEntry> blockEntries = new Vector<OiiolActionLogEntry>();
            OiLogBlockHeader lh = (OiLogBlockHeader)this.m_blockHeaders.elementAt(m_blockIndex);
            this.initBlockInputStream(lh);
            int numBlockEntries = lh.getNumEntries();
            for (i = 0; i < numBlockEntries; ++i) {
                logEntry = (OiiolActionLogEntry)this.m_ois.readObject();
                if (lh.isEntryMarked(i)) continue;
                blockEntries.addElement(logEntry);
            }
            for (i = blockEntries.size() - 1; i >= 0; --i) {
                logEntry = (OiiolActionLogEntry)blockEntries.elementAt(i);
                tmpLog.addEntry(logEntry);
            }
        }
        tmpLog.setReversed(!this.isReversed());
        tmpLog.close();
        this.m_raf.close();
        this.deleteAndRename(tempLoc);
        this.m_raf = new RandomAccessFile(this.m_logLoc, "rw");
        this.readBlockHeaders();
    }

    public void compactLog() throws IOException, ClassNotFoundException {
        String tempLoc = this.m_logLoc + ".tmp";
        OiiolInstallLog tmpLog = new OiiolInstallLog(tempLoc);
        tmpLog.startWrite();
        this.openRead();
        while (this.hasMoreEntries()) {
            tmpLog.addEntry(this.nextEntry());
        }
        tmpLog.close();
        this.m_raf.close();
        this.deleteAndRename(tempLoc);
        this.m_raf = new RandomAccessFile(this.m_logLoc, "rw");
        this.readBlockHeaders();
    }

    private void deleteAndRename(String tempLoc) {
        File oldLogFile = new File(this.m_logLoc);
        File newLogFile = new File(tempLoc);
        oldLogFile.delete();
        newLogFile.renameTo(oldLogFile);
    }

    @Override
    public Enumeration getEntries() throws IOException {
        return new OiiolLogEnumerator(this, false);
    }

    @Override
    public Enumeration getEntriesForInstall() throws IOException {
        return new OiiolLogEnumerator(this, false);
    }

    @Override
    public Enumeration getEntriesForDeinstall() throws IOException {
        return new OiiolLogEnumerator(this, true);
    }

    public static void main(String[] args) {
        Vector inputs;
        OiiiLibraryID libID;
        String actionName;
        OiiolActionLogEntry oEntry;
        int index;
        PrintWriter pRefFile;
        FileWriter refFileWriter;
        String destFile;
        OiiolInstallLog installLog;
        String sourceFile;
        String usageStr = "Usage : OiiolInstallLog <logFileName> <outdir>";
        if (args.length < 2) {
            System.err.println(usageStr);
            System.exit(0);
        }
        String sLogFile = args[0];
        String sOutputDir = args[1];
        try {
            sourceFile = OiixPathOps.getNativeForm(sLogFile);
            installLog = new OiiolInstallLog(sLogFile);
            if (!installLog.isReversed()) {
                installLog.reverseLog();
            }
            installLog.openRead();
            destFile = OiixPathOps.getNativeForm(sOutputDir + "/refFile");
            refFileWriter = new FileWriter(destFile);
            pRefFile = new PrintWriter(refFileWriter);
            index = 0;
            while (installLog.hasMoreEntries()) {
                oEntry = installLog.getNextEntry();
                actionName = oEntry.getActionName();
                libID = oEntry.getLibraryID();
                inputs = oEntry.getInputs();
                pRefFile.println("Action: " + (index + 1) + " " + actionName + " Library : " + libID.getName() + " " + libID.getVersion());
                ++index;
            }
            pRefFile.close();
            refFileWriter.close();
            installLog.reverseLog();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            sourceFile = OiixPathOps.getNativeForm(sLogFile);
            installLog = new OiiolInstallLog(sLogFile);
            installLog.openRead();
            destFile = OiixPathOps.getNativeForm(sOutputDir + "/outFile");
            refFileWriter = new FileWriter(destFile);
            pRefFile = new PrintWriter(refFileWriter);
            index = 0;
            while (installLog.hasMoreEntriesReverse()) {
                oEntry = installLog.nextEntryReverse();
                actionName = oEntry.getActionName();
                libID = oEntry.getLibraryID();
                inputs = oEntry.getInputs();
                pRefFile.println("Action: " + (index + 1) + " " + actionName + " Library : " + libID.getName() + " " + libID.getVersion());
                ++index;
            }
            pRefFile.close();
            refFileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static OiiolActionLogEntry createTestEntry(int i) {
        Vector<String> plats = new Vector<String>();
        plats.addElement("NT");
        OiiiLibraryID lid = new OiiiLibraryID("a1", new OiiiVersion("0.0"), plats, new OiiiVersion("0.0"));
        Vector<Integer> inputs = new Vector<Integer>();
        int numInputs = (int)(Math.random() * 4.0) + 1;
        System.out.println("Adding " + numInputs + " inputs");
        for (int j = 0; j < numInputs; ++j) {
            inputs.addElement(new Integer(i));
        }
        OiiolActionLogEntry logEntry = new OiiolActionLogEntry(lid, "action1", inputs, new Vector(), new Vector());
        return logEntry;
    }

    class OiiolLogEnumerator
    implements Enumeration {
        private OiiolInstallLog m_installLog;
        private boolean m_bReverse;

        public OiiolLogEnumerator(OiiolInstallLog installLog, boolean bReverse) throws IOException {
            this.m_installLog = installLog;
            this.m_bReverse = bReverse;
            this.m_installLog.openRead();
        }

        @Override
        public boolean hasMoreElements() {
            boolean bMoreElements = false;
            bMoreElements = this.m_bReverse ? this.m_installLog.hasMoreEntriesReverse() : this.m_installLog.hasMoreEntries();
            try {
                if (!bMoreElements) {
                    this.m_installLog.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return bMoreElements;
        }

        public Object nextElement() {
            OiiolActionLogEntry elem = null;
            try {
                elem = this.m_bReverse ? this.m_installLog.nextEntryReverse() : this.m_installLog.nextEntry();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (ClassNotFoundException clsEx) {
                clsEx.printStackTrace();
            }
            return elem;
        }
    }
}

