/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiof;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiofHTTPFileLoader
extends OiiofFileLoader {
    private String m_sourceRoot;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32768;
    private static boolean b_certificateAccepted = false;
    private static final int DEFAULT_WAIT_TIME = 1000;

    public OiiofHTTPFileLoader(String sourceRoot, String tempRoot) {
        super(true, tempRoot);
        this.setupProxyProperties();
        this.m_sourceRoot = sourceRoot;
    }

    private void setupProxyProperties() {
        Properties sysProps;
        String curProxyHost;
        String proxyHost = System.getProperty("oracle.installer.proxyHost");
        String proxyPort = System.getProperty("oracle.installer.proxyPort");
        if (proxyHost != null && (curProxyHost = (sysProps = System.getProperties()).getProperty("http.proxyHost")) == null) {
            sysProps.put("http.proxyHost", proxyHost);
            if (proxyPort != null) {
                sysProps.put("http.proxyPort", proxyPort);
            }
            System.setProperties(sysProps);
        }
    }

    @Override
    public String fetchImpl(String remoteLoc, String localLoc) throws IOException, OiifbCancelException {
        String retLoc = localLoc;
        if (localLoc == null) {
            retLoc = this.getTempLoc();
        }
        String sFullPath = this.calcSrcPath(remoteLoc);
        this.httpFetch(sFullPath, retLoc);
        return retLoc;
    }

    private void httpFetch(String remoteURL, String localLoc) throws IOException, OiifbCancelException {
        int BUFF_SIZE = 512;
        byte[] buffer = new byte[BUFF_SIZE];
        try {
            File fParent;
            File fLocal = new File(localLoc);
            if (!fLocal.exists() && !(fParent = fLocal.getParentFile()).exists()) {
                OiixFileOps.mkdirs(fParent);
            }
            TrustManager[] trustAllCerts = new TrustManager[]{new TrustManagerForSSL()};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            }
            catch (Exception sc) {
                // empty catch block
            }
            URL url = new URL(remoteURL);
            InputStream is = url.openStream();
            FileOutputStream os = new FileOutputStream(localLoc);
            if (url.toString().startsWith("https")) {
                int retryCount = Integer.parseInt(System.getProperty("oracle.installer.httpRetryCount"));
                int retryInterval = Integer.parseInt(System.getProperty("oracle.installer.httpRetryInterval"));
                byteReadTest byteThread = new byteReadTest(is, os);
                byteThread.start();
                int timeToWaitFor = retryCount * retryInterval;
                if (timeToWaitFor > 0) {
                    byteThread.join(retryCount * retryInterval);
                } else {
                    byteThread.join(1000L);
                }
            }
            OiixFileOps.copyStreamFromURL(is, os, localLoc, true, null, false, buffer, BUFF_SIZE);
            is.close();
            os.close();
        }
        catch (UnknownHostException me) {
            Object[] sArgs = new String[]{me.getMessage()};
            throw new IOException(OiixResourceBundle.getString("S_ERROR_HOSTNAME", sArgs));
        }
        catch (MalformedURLException me) {
            throw new IOException(me.getMessage());
        }
        catch (FileNotFoundException fe) {
            throw fe;
        }
        catch (Exception me) {
            if (me instanceof IOException) {
                throw (IOException)me;
            }
            me.printStackTrace();
            throw new IOException(me.getMessage());
        }
    }

    private String calcSrcPath(String relPath) {
        return OiixPathOps.concatPath(this.m_sourceRoot, OiixPathOps.getStandardForm(relPath));
    }

    public String getSourceRoot() {
        return this.m_sourceRoot;
    }

    public String getHost() {
        try {
            URL url = new URL(this.m_sourceRoot);
            String path = url.getPath();
            String host = this.m_sourceRoot.substring(0, this.m_sourceRoot.indexOf(path));
            return host;
        }
        catch (MalformedURLException malformedURLException) {
            return this.m_sourceRoot;
        }
    }

    @Override
    public String fetchDllFile(String sourceDir, String dllFile) throws IOException, OiifbCancelException {
        String sourceLoc = OiixPathOps.concatPath(sourceDir, dllFile);
        return this.getLocalCopyToDest(sourceLoc, null);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage :: java oracle.sysman.oii.oiio.oiiof.OiiofHTTPFileLoader <URL loc> <localLoc>");
        } else {
            try {
                String urlLoc = args[0];
                String localLoc = args[1];
                URL url = new URL(urlLoc);
                String urlRoot = "http://" + url.getHost();
                String urlFile = url.getFile().substring(1);
                OiiofHTTPFileLoader hfl = new OiiofHTTPFileLoader(urlRoot, "/tmp");
                hfl.getLocalCopyToDest(urlFile, localLoc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class TrustManagerForSSL
    implements X509TrustManager {
        X509TrustManager X509TM = null;
        TrustManagerFactory ClientTMF = null;
        TrustManager[] ClientTMs = null;
        String[] algorithms = new String[]{"SunX509", "IbmX509", "IbmX509"};
        String[] providers = new String[]{"SunJSSE", "IBMJSSE", "IBMJSSE2"};

        public TrustManagerForSSL() {
            for (int i = 0; i < this.algorithms.length; ++i) {
                try {
                    this.ClientTMF = TrustManagerFactory.getInstance(this.algorithms[i], this.providers[i]);
                }
                catch (NoSuchAlgorithmException e) {
                    OiiolTextLogger.appendText("No algorithm found " + this.algorithms[i]);
                }
                catch (NoSuchProviderException e) {
                    OiiolTextLogger.appendText("No providers found " + this.providers[i]);
                }
                if (this.ClientTMF != null) break;
            }
            if (this.ClientTMF == null) {
                OiiolTextLogger.appendText("No SSL Providers found");
            } else {
                KeyStore ks = null;
                try {
                    this.ClientTMF.init(ks);
                }
                catch (KeyStoreException e) {
                    // empty catch block
                }
                this.ClientTMs = this.ClientTMF.getTrustManagers();
                for (int i = 0; i < this.ClientTMs.length; ++i) {
                    if (!(this.ClientTMs[i] instanceof X509TrustManager)) continue;
                    this.X509TM = (X509TrustManager)this.ClientTMs[i];
                    return;
                }
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            block6: {
                try {
                    this.X509TM.checkServerTrusted(certs, authType);
                }
                catch (CertificateException e) {
                    if (b_certificateAccepted) break block6;
                    boolean bGUI = !OiicPullSession.isSilentMode();
                    Object[] args = new Object[]{OiiofHTTPFileLoader.this.getHost()};
                    if (bGUI) {
                        if (Boolean.getBoolean("oracle.installer.acceptUntrustedCertificates")) {
                            b_certificateAccepted = true;
                            OiiolTextLogger.appendText("Accepting untrusted certificate.Continuing...");
                            return;
                        }
                        String sWarningMsg = OiixResourceBundle.getString("S_WARNING_UNTRUSTED_CERTIFICATE", args);
                        int result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_WARNING", args), sWarningMsg, 30, 3, 1, 10);
                        if (result == 2) {
                            throw e;
                        }
                        b_certificateAccepted = true;
                    }
                    if (Boolean.getBoolean("oracle.installer.acceptUntrustedCertificates")) {
                        b_certificateAccepted = true;
                        OiiolTextLogger.appendText("Accepting untrusted certificate.Continuing...");
                    }
                    OiifmAlert.displayError(OiixResourceBundle.getString("S_ERROR_UNTRUSTED_CERTIFICATE", args));
                    OiiolTextLogger.writeToLogAndConsole(OiixResourceBundle.getString("S_MESSAGE_UNTRUSTED_CERTIFICATE"));
                    throw e;
                }
            }
        }
    }

    private class byteReadTest
    extends Thread {
        InputStream is = null;
        OutputStream os = null;

        public byteReadTest(InputStream iStream, OutputStream oStream) {
            this.is = iStream;
            this.os = oStream;
        }

        @Override
        public void run() {
            try {
                this.os.write(this.is.read());
            }
            catch (IOException e) {
                OiiolTextLogger.appendException(e);
            }
        }
    }
}

