/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiof;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofHTTPFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofLocalFileLoader;
import oracle.sysman.oii.oiio.oiiof.OiiofNetworkFileLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiofFileLoaderFactory {
    private OiiofFileLoaderFactory() {
    }

    public static OiiofFileLoader createFileLoader(String sourceRoot, String tempLoc) throws IOException {
        return OiiofFileLoaderFactory.createFileLoader(sourceRoot, tempLoc, true);
    }

    public static OiiofFileLoader createFileLoader(String sourceRoot, String tempLoc, boolean bRetainPerm) throws IOException {
        OiiofFileLoader retFL = null;
        if (sourceRoot == null) {
            throw new IOException(OiixResourceBundle.getString("S_ERROR_FROMLOC"));
        }
        retFL = sourceRoot.length() > 7 && sourceRoot.substring(0, 7).equalsIgnoreCase("http://") ? new OiiofHTTPFileLoader(sourceRoot, tempLoc) : (sourceRoot.length() > 8 && sourceRoot.substring(0, 8).equalsIgnoreCase("https://") ? new OiiofHTTPFileLoader(sourceRoot, tempLoc) : (OiiofFileLoaderFactory.isNetworkSource(sourceRoot) ? new OiiofNetworkFileLoader(sourceRoot, tempLoc) : new OiiofLocalFileLoader(sourceRoot, tempLoc, bRetainPerm)));
        return retFL;
    }

    public static boolean isNetworkSource(String sourceRoot) {
        String sourceType = System.getProperty("oracle.installer.sourceType", "local");
        return sourceType.equalsIgnoreCase("network");
    }

    public static boolean isWriteableSource(String sourceRoot) {
        boolean retVal = true;
        if (sourceRoot == null) {
            retVal = false;
        } else if (sourceRoot.startsWith("http://")) {
            retVal = false;
        } else if (sourceRoot.startsWith("https://")) {
            retVal = false;
        } else if (sourceRoot.startsWith("oraIIOP://")) {
            retVal = false;
        } else {
            try {
                File sourceRootFile = new File(sourceRoot, "write.tmp");
                FileOutputStream fos = new FileOutputStream(sourceRootFile);
                fos.close();
                sourceRootFile.delete();
            }
            catch (IOException ioe) {
                retVal = false;
            }
            catch (NullPointerException ioe) {
                retVal = false;
            }
        }
        return retVal;
    }

    public static boolean pathExists(String path) {
        boolean retVal = true;
        if (path.startsWith("http://")) {
            path = OiixPathOps.getStandardForm(path);
            try {
                URL url = new URL(path);
                InputStream is = url.openStream();
                retVal = true;
                is.close();
            }
            catch (IOException ioe) {
                retVal = false;
            }
        } else if (path.startsWith("https://")) {
            path = OiixPathOps.getStandardForm(path);
            try {
                URL url = new URL(path);
                InputStream is = url.openStream();
                retVal = true;
                is.close();
            }
            catch (IOException ioe) {
                retVal = false;
            }
        } else if (path.startsWith("oraIIOP://")) {
            retVal = false;
        } else {
            File f = new File(OiixPathOps.getNativeForm(path));
            retVal = f.exists();
        }
        return retVal;
    }
}

