/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiof;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiio.oiiof.OiFetchRequest;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPriorityQueue;

public abstract class OiiofFileLoader {
    private boolean doQueuing;
    public static final int MINPRIO = 0;
    public static final int NORMPRIO = 3;
    public static final int MAXPRIO = 5;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32768;
    private Hashtable m_requests = new Hashtable();
    private OiixPriorityQueue m_queue;
    private Thread m_worker;
    private Vector m_tempFiles = new Vector();
    protected boolean m_bRetainPerm = true;
    protected int m_nBuffSize;
    protected byte[] s_buffer = null;
    private static int s_nTempCount = 0;
    private static final String DEF_TEMP = "dtemp";
    private String m_tempRoot;
    private int tempCount = 0;

    protected OiiofFileLoader(boolean doQueuing, String tempRoot) {
        this.m_queue = new OiixPriorityQueue();
        if (tempRoot != null) {
            this.m_tempRoot = OiixPathOps.getNativeForm(tempRoot);
        }
        this.m_worker = null;
    }

    protected void finalize() {
    }

    public void dispose() {
        if (this.m_worker != null) {
            if (this.m_worker.isAlive()) {
                this.m_worker.stop();
            }
            this.m_worker = null;
        }
        this.removeRemainingTempFiles();
    }

    public final void prefetchLocalCopy(String remoteLoc, int prio) {
        this.prefetchLocalCopyToDest(remoteLoc, null, prio);
    }

    public final synchronized void prefetchLocalCopyToDest(String remoteLoc, String localLoc, int prio) {
        OiFetchRequest fReq;
        if (this.m_worker == null) {
            this.m_worker = new Thread(new OiQueueWorker());
            this.m_worker.setPriority(4);
            this.m_worker.setDaemon(true);
            this.m_worker.start();
        }
        if ((fReq = (OiFetchRequest)this.m_requests.get(remoteLoc)) == null) {
            fReq = new OiFetchRequest(remoteLoc, localLoc);
            this.m_requests.put(remoteLoc, fReq);
            this.m_queue.insert(fReq, prio);
            this.notifyAll();
        }
    }

    public final synchronized void cancelPrefetch(String remoteLoc) {
        OiFetchRequest fReq = (OiFetchRequest)this.m_requests.get(remoteLoc);
        if (fReq != null && fReq.getStatus() == 1) {
            this.m_requests.remove(remoteLoc);
            this.m_queue.remove(fReq);
        }
    }

    public final String getLocalCopy(String remoteLoc) throws IOException, OiifbCancelException {
        return this.getLocalCopyToDest(remoteLoc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized String getLocalCopyToDest(String remoteLoc, String localLoc) throws IOException, OiifbCancelException {
        String retLoc = null;
        OiFetchRequest fReq = (OiFetchRequest)this.m_requests.get(remoteLoc);
        if (fReq != null) {
            OiFetchRequest oiFetchRequest = fReq;
            synchronized (oiFetchRequest) {
                int status = fReq.getStatus();
                if (status == 1 || status == 0) {
                    this.m_queue.remove(fReq);
                    if (this.m_worker != null) {
                        this.m_worker.suspend();
                    }
                    retLoc = this.fetchImpl(remoteLoc, localLoc);
                    fReq.setStatus(3);
                    fReq.setLocalLoc(retLoc);
                    if (this.m_worker != null) {
                        this.m_worker.resume();
                    }
                } else if (status == 3) {
                    String oldLoc = fReq.getLocalLoc();
                    if (!oldLoc.equals(localLoc)) {
                        this.copyFile(oldLoc, localLoc);
                    }
                    retLoc = localLoc;
                } else if (status == 2) {
                    try {
                        while (fReq.getStatus() == 2) {
                            fReq.wait();
                        }
                    }
                    catch (InterruptedException ie) {
                        throw new IOException(ie.getMessage());
                    }
                    if (fReq.getStatus() == 0) {
                        throw fReq.getException();
                    }
                    retLoc = fReq.getLocalLoc();
                }
            }
        }
        if (this.m_worker != null) {
            this.m_worker.suspend();
        }
        retLoc = this.fetchImpl(remoteLoc, localLoc);
        if (this.m_worker != null) {
            this.m_worker.resume();
        }
        return retLoc;
    }

    public void setRetainPermission(boolean bPerm) {
        this.m_bRetainPerm = bPerm;
    }

    public boolean getRetainPermission() {
        return this.m_bRetainPerm;
    }

    protected void copyFile(String fromLoc, String toLoc) throws IOException, OiifbCancelException {
        if (this.m_bRetainPerm) {
            OiixFileOps.copyFile(fromLoc, toLoc, true, true);
        } else {
            OiixFileOps.copyFile(fromLoc, toLoc, true, true, true, "0644", null, null);
        }
    }

    protected synchronized String getTempLoc() {
        File tempF;
        boolean exists = false;
        String tempPath = null;
        do {
            tempF = new File(this.m_tempRoot, "temp" + this.tempCount++);
            tempPath = tempF.getPath();
        } while (exists = tempF.exists());
        this.m_tempFiles.addElement(tempPath);
        return tempPath;
    }

    public synchronized void releaseTempFile(String tempPath) {
        int locPos = this.m_tempFiles.indexOf(tempPath);
        File tFile = new File(tempPath);
        if (locPos != -1 && (!tFile.exists() || new File(tempPath).delete())) {
            this.m_tempFiles.removeElementAt(locPos);
        }
    }

    public void removeRemainingTempFiles() {
        int numTempFiles = this.m_tempFiles.size();
        for (int i = 0; i < numTempFiles; ++i) {
            String path = (String)this.m_tempFiles.elementAt(i);
            new File(path).delete();
        }
        this.m_tempFiles.removeAllElements();
    }

    protected abstract String fetchImpl(String var1, String var2) throws IOException, OiifbCancelException;

    public String fetchDllFile(String sourceDir, String dllFile) throws IOException, OiifbCancelException {
        return dllFile;
    }

    public void setBufferInfo(byte[] buffer, int nBuffSize) {
        this.s_buffer = buffer;
        this.m_nBuffSize = nBuffSize;
    }

    public String fetchDefaultJarToLocal(String sJarLocation) {
        String sRetLoc = OiiofFileLoader.getDefaultTempLoc(this.m_tempRoot);
        if (sRetLoc == null) {
            return sJarLocation;
        }
        FileOutputStream fos = null;
        BufferedInputStream fis = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(sJarLocation), 8192);
            fos = new FileOutputStream(sRetLoc);
            OiixFileOps.copyStream(fis, fos, sRetLoc, true, null, true, this.s_buffer, this.m_nBuffSize);
            fos.close();
            OiixFileOps.changePermissions(sRetLoc, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sRetLoc = sJarLocation;
        }
        return sRetLoc;
    }

    private static synchronized String getDefaultTempLoc(String sTempRoot) {
        File tempF;
        if (sTempRoot == null) {
            return null;
        }
        boolean exists = false;
        String tempPath = null;
        do {
            tempF = new File(sTempRoot, DEF_TEMP + s_nTempCount++);
            tempPath = tempF.getPath();
        } while (exists = tempF.exists());
        return tempPath;
    }

    class OiQueueWorker
    implements Runnable {
        OiQueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (!OiiofFileLoader.this.m_queue.isEmpty()) {
                    OiFetchRequest fReq;
                    OiFetchRequest oiFetchRequest = fReq = (OiFetchRequest)OiiofFileLoader.this.m_queue.getHead();
                    synchronized (oiFetchRequest) {
                        fReq.setStatus(2);
                        try {
                            String retLoc = OiiofFileLoader.this.fetchImpl(fReq.getRemoteLoc(), fReq.getLocalLoc());
                            fReq.setLocalLoc(retLoc);
                            fReq.setStatus(3);
                        }
                        catch (IOException ioe) {
                            OiiofFileLoader.this.m_requests.remove(fReq.getRemoteLoc());
                            fReq.setFailure(ioe);
                        }
                        catch (OiifbCancelException ioe) {
                            OiiofFileLoader.this.m_requests.remove(fReq.getRemoteLoc());
                            fReq.setFailure(new IOException(ioe.getMessage()));
                        }
                        fReq.notifyAll();
                    }
                }
                try {
                    OiiofFileLoader oiiofFileLoader = OiiofFileLoader.this;
                    synchronized (oiiofFileLoader) {
                        OiiofFileLoader.this.wait();
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

