/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.io.File;
import java.util.HashMap;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;

public class OiiodVolumeInfo {
    private String m_sVolume = null;
    private long m_lRequiredSpace = 0L;
    private long m_lTempSpace = 0L;
    private long m_lPostInstallSpace = 0L;
    private long m_lAvailableSpace = 0L;
    private long m_lLastRefreshTime = 0L;
    private HashMap m_oClusterAvailableSpace = null;
    private boolean m_bCFSDrive = false;
    private boolean m_bInvalidAvailableSpace = true;
    private static final int REFRESH_TIME = 600000;

    public OiiodVolumeInfo(String sVolume) {
        this(sVolume, false);
    }

    public OiiodVolumeInfo(String sVolume, boolean bCFS) {
        if (!sVolume.endsWith(File.separator)) {
            sVolume = sVolume + File.separatorChar;
        }
        this.m_sVolume = sVolume;
        this.m_bCFSDrive = bCFS;
    }

    public boolean isCFS() {
        return this.m_bCFSDrive;
    }

    public String getVolumeName() {
        return this.m_sVolume;
    }

    public void setRequiredSpace(long lReqSpace) {
        this.m_lRequiredSpace = lReqSpace;
    }

    public void addRequiredSpace(long lReqSpace) {
        this.m_lRequiredSpace += lReqSpace;
    }

    public long getRequiredSpace() {
        return this.m_lRequiredSpace;
    }

    public void setTempSpace(long lTempSpace) {
        this.m_lTempSpace = lTempSpace;
    }

    public void addTempSpace(long lTempSpace) {
        this.m_lTempSpace += lTempSpace;
    }

    public long getTempSpace() {
        return this.m_lTempSpace;
    }

    public void setPostInstallSpace(long lPostInstallSpace) {
        this.m_lPostInstallSpace = lPostInstallSpace;
    }

    public void addPostInstallSpace(long lPostInstallSpace) {
        this.m_lPostInstallSpace += lPostInstallSpace;
    }

    public long getPostInstallSpace() {
        return this.m_lPostInstallSpace;
    }

    public long getAvailableSpace() {
        if (this.isInvalidAvailableSpace()) {
            this.computeAvailableSpace();
        }
        return this.m_lAvailableSpace;
    }

    public long getAvailableSpace(String sNode) {
        Object oAvblSpace = this.m_oClusterAvailableSpace == null ? null : this.m_oClusterAvailableSpace.get(sNode);
        long lAvblSpace = 0L;
        lAvblSpace = oAvblSpace == null ? this.computeAvailableSpace(sNode) : ((Long)oAvblSpace).longValue();
        return lAvblSpace;
    }

    private long computeAvailableSpace(String sNode) {
        long lAvailSpaceCluster = 0L;
        if (!this.m_bCFSDrive) {
            try {
                lAvailSpaceCluster = OiipgClusterOps.getFreeSpaceOnNode(sNode, this.m_sVolume);
                lAvailSpaceCluster *= 1024L;
                if (this.m_oClusterAvailableSpace == null) {
                    this.m_oClusterAvailableSpace = new HashMap();
                }
                this.m_oClusterAvailableSpace.put(sNode, new Long(lAvailSpaceCluster));
            }
            catch (OiipgRemoteOpsException ce) {
                OiiolTextLogger.appendException(ce);
            }
        } else {
            lAvailSpaceCluster = this.m_lAvailableSpace;
        }
        return lAvailSpaceCluster;
    }

    private long computeAvailableSpace() {
        this.m_lAvailableSpace = new OiipgFileSystem().getVolumeFreeSpace(this.m_sVolume);
        this.m_bInvalidAvailableSpace = false;
        this.m_lLastRefreshTime = System.currentTimeMillis();
        return this.m_lAvailableSpace;
    }

    public boolean equals(Object obj) {
        boolean bResult = false;
        if (obj != null) {
            if (this == obj) {
                bResult = true;
            } else if (obj instanceof OiiodVolumeInfo) {
                OiiodVolumeInfo vi2 = (OiiodVolumeInfo)obj;
                bResult = this.m_sVolume.equals(vi2.getVolumeName());
            }
        }
        return bResult;
    }

    public int hashCode() {
        return this.m_sVolume.hashCode();
    }

    public long getTotalRequiredSpace(boolean bLocal) {
        return bLocal ? this.m_lRequiredSpace + this.m_lTempSpace + this.m_lPostInstallSpace : this.m_lRequiredSpace;
    }

    private boolean isInvalidAvailableSpace() {
        if (System.currentTimeMillis() - this.m_lLastRefreshTime > 600000L) {
            this.invalidateAvailableSpace();
        }
        return this.m_bInvalidAvailableSpace;
    }

    public void invalidateAvailableSpace() {
        this.m_bInvalidAvailableSpace = true;
        if (this.m_oClusterAvailableSpace != null) {
            this.m_oClusterAvailableSpace.clear();
        }
    }
}

