/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodDepCountException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiio.oiiod.OiiodDepErrorDetails;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiod.OiiodDepRuleNode;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepBaseObject;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepCompObject;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngCmpListener;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngErrListener;
import oracle.sysman.oii.oiio.oiiod.OiiodISelector;
import oracle.sysman.oii.oiio.oiiod.OiiodPatchSetNode;
import oracle.sysman.oii.oiio.oiiod.OiiodPatchesNode;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiodRuleSelector
implements OiiodIDepCompObject,
OiiodISelector {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16384;
    private OiiodDepRuleNode m_oRuleNode;
    private OiiodDepNode m_oCompNode;
    private OiiodDepNode m_oParentNode;
    private Vector m_oRules;
    private boolean m_bAsk;
    private boolean m_bSelected;
    private boolean m_bExapandedByDefault;
    private Vector m_oUIListeners;
    private boolean m_bDefaultSelection;

    public OiiodRuleSelector(OiiodDepNode depNode, OiiodDepRuleNode ruleNode) {
        this.m_oRuleNode = ruleNode;
        this.m_oCompNode = depNode;
        if (ruleNode != null) {
            this.m_oParentNode = ruleNode.getParentNode();
        }
        this.m_oUIListeners = new Vector();
        this.m_oRules = new Vector();
        this.m_bSelected = false;
    }

    public String getDisplayName() {
        return this.m_oCompNode.getDisplayName();
    }

    public OiiodDepNode getCompNode() {
        return this.m_oCompNode;
    }

    public OiiodDepRuleNode getRuleNode() {
        return this.m_oRuleNode;
    }

    public OiiodDepNode getParentNode() {
        return this.m_oParentNode;
    }

    @Override
    public boolean isEnforced() {
        return this.m_oRuleNode.isEnforced();
    }

    public void setRuleNodes(Vector vChildren) {
        this.m_oRules = vChildren;
    }

    public Vector getChildren() {
        return this.m_oRules;
    }

    public Vector getAllPatches() {
        OiiodPatchSetNode oPatchSet = (OiiodPatchSetNode)this.m_oCompNode;
        return oPatchSet.getPatchSelectors();
    }

    @Override
    public Vector getAllChildren() {
        Vector<OiiodIDepBaseObject> v = null;
        if (this.m_oCompNode.getCompInstallID().getCompType() == 4) {
            v = this.getAllPatches();
        } else {
            OiiodDepRuleNode oRule;
            int i;
            v = new Vector<OiiodIDepBaseObject>(5, 5);
            if (this.m_oCompNode.hasPatches()) {
                v.addElement(this.m_oCompNode.getPatchesNode());
            }
            int nSize = this.m_oRules.size();
            int nVisibleCount = 0;
            for (i = 0; i < nSize; ++i) {
                oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
                if (!oRule.isVisible()) continue;
                ++nVisibleCount;
            }
            for (i = 0; i < nSize; ++i) {
                oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
                if (oRule.getRuleType() == 3) continue;
                if (nVisibleCount == 1) {
                    Vector nextVisible = oRule.getAllChildren();
                    OiiodDepEngineHelper.mergeVect(v, nextVisible);
                    continue;
                }
                if (oRule.getChildren().size() <= 0) continue;
                v.addElement(oRule);
            }
            for (i = 0; i < nSize; ++i) {
                oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
                if (oRule.getRuleType() != 3 || oRule.getChildren().size() <= 0) continue;
                v.addElement(oRule);
            }
        }
        return v;
    }

    @Override
    public Vector getVisibleChildren() {
        OiiodDepRuleNode oRule;
        int i;
        Vector<OiiodIDepBaseObject> v = new Vector<OiiodIDepBaseObject>();
        if (this.isVisible() && this.m_oCompNode.hasPatches()) {
            v.addElement(this.m_oCompNode.getPatchesNode());
        }
        int nSize = this.m_oRules.size();
        int nVisibleCount = 0;
        for (i = 0; i < nSize; ++i) {
            oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            if (!oRule.isVisible()) continue;
            ++nVisibleCount;
        }
        for (i = 0; i < nSize; ++i) {
            oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            if (!oRule.isVisible() || nVisibleCount == 1) {
                Vector nextVisible = oRule.getVisibleChildren();
                OiiodDepEngineHelper.mergeVect(v, nextVisible);
                continue;
            }
            if (oRule.getChildren().size() <= 0) continue;
            v.addElement(oRule);
        }
        return v;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.m_oCompNode.getDescription();
    }

    @Override
    public boolean isExpandedByDefault() {
        int nSize = this.m_oRules.size();
        boolean bExpanded = false;
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            if (!oRule.isVisible() || !oRule.isExpandedByDefault()) continue;
            bExpanded = true;
            break;
        }
        return bExpanded;
    }

    public boolean isVisible() {
        return this.m_oRuleNode.isVisible();
    }

    @Override
    public OiiiCompInstallID getCompInstallID() {
        return this.m_oCompNode.getCompInstallID();
    }

    @Override
    public void addUIListener(OiiodIDepEngCmpListener listener) {
        this.m_oUIListeners.addElement(listener);
    }

    @Override
    public boolean isSelected() {
        if (this.m_bSelected && this.getInstallStatus() == 6) {
            return false;
        }
        if (this.getInstallStatus() == 3) {
            return false;
        }
        return this.m_bSelected;
    }

    @Override
    public boolean isSelectedForInstall() {
        if (this.m_oCompNode.getCompStatus() == 3) {
            return true;
        }
        return this.m_bSelected && (this.m_bDefaultSelection || this.m_bAsk);
    }

    @Override
    public void setSelected(boolean bSelect) {
        boolean prevSelection = this.m_bSelected;
        this.m_bSelected = bSelect;
        if (prevSelection != this.m_bSelected) {
            this.callListeners(1);
            this.callListeners(8);
        }
    }

    @Override
    public boolean isSelectable() {
        boolean bIsSelectable = false;
        if (!this.m_oCompNode.isDownGrade() && !this.m_oCompNode.isNotInStage()) {
            bIsSelectable = true;
            if (this.m_oRuleNode.getRuleType() == 3 && this.m_oCompNode.getCompStatus() != 2 && this.m_oCompNode.getCompStatus() != 5) {
                bIsSelectable = false;
            }
            if (!this.isVisible() && this.m_oCompNode.getCompStatus() != 2 && this.m_oCompNode.getCompStatus() != 5) {
                bIsSelectable = false;
            }
        }
        return bIsSelectable;
    }

    @Override
    public boolean areAllSubCmpsSelected() {
        return true;
    }

    @Override
    public int getInstallStatus() {
        return this.m_oCompNode.getInstallStatus();
    }

    @Override
    public OiiiVersion getInstalledVersion() {
        return this.m_oCompNode.getInstalledVersion();
    }

    @Override
    public boolean select(OiiodIDepEngErrListener errListener) {
        Object oNode;
        int i;
        Vector<OiiodRuleSelector> vSelectedComps = new Vector<OiiodRuleSelector>();
        vSelectedComps.addElement(this);
        OiiodDepErrorDetails oError = new OiiodDepErrorDetails(1);
        for (int i2 = 0; i2 < vSelectedComps.size(); ++i2) {
            OiiodRuleSelector oSelector = (OiiodRuleSelector)vSelectedComps.elementAt(i2);
            Vector vComps = this.gatherCurrentSelections(oSelector, oError);
            OiixVectorOps.unionInPlace(vSelectedComps, vComps);
        }
        if (oError.hasErrors()) {
            String sMsg = OiixResourceBundle.getString("S_WARNING_CMP_SEL");
            int nResult = errListener.processWarning(sMsg, oError.getErrorLines());
            if (nResult == 1) {
                return false;
            }
        }
        Vector<OiiodDepNode> vSelNodes = new Vector<OiiodDepNode>();
        int nSize = vSelectedComps.size();
        for (i = 0; i < nSize; ++i) {
            oNode = (OiiodRuleSelector)vSelectedComps.elementAt(i);
            if (OiixVectorOps.vectIndexOf(vSelNodes, (Object)((OiiodRuleSelector)oNode).getCompNode()) != -1) continue;
            vSelNodes.addElement(((OiiodRuleSelector)oNode).getCompNode());
        }
        nSize = vSelNodes.size();
        for (i = 0; i < nSize; ++i) {
            oNode = (OiiodDepNode)vSelNodes.elementAt(i);
            if (oNode == this.m_oCompNode) {
                ((OiiodDepNode)oNode).select();
                ((OiiodDepNode)oNode).getPatchesNode().setupPatchLevels();
                continue;
            }
            if (((OiiodDepNode)oNode).getCompStatus() == 5) continue;
            ((OiiodDepNode)oNode).select();
            ((OiiodDepNode)oNode).getPatchesNode().setupPatchLevels();
        }
        return true;
    }

    private Vector gatherCurrentSelections(OiiodRuleSelector oSelector, OiiodDepErrorDetails oDetails) {
        Vector vRules = oSelector.getChildren();
        Vector vSelectedComps = new Vector();
        int nSize = vRules.size();
        for (int i = 0; i < nSize; ++i) {
            Vector vComps;
            block5: {
                OiiodDepRuleNode oRule = (OiiodDepRuleNode)vRules.elementAt(i);
                vComps = null;
                if (oRule.getRuleType() == 3) {
                    vComps = oRule.getChildren();
                } else {
                    try {
                        vComps = oRule.getCurrentSelections();
                    }
                    catch (OiiodDepCountException e) {
                        vComps = oRule.getOSPSelections();
                        if (oRule.anyChildSelectedInOneOrMoreRule()) break block5;
                        oDetails.addProblemRule(oRule);
                    }
                }
            }
            if (vComps == null) continue;
            OiixVectorOps.unionInPlace(vSelectedComps, vComps);
        }
        return vSelectedComps;
    }

    @Override
    public boolean deselect(OiiodIDepEngErrListener errListener) {
        boolean bRet = true;
        OiiodDepErrorDetails oError = new OiiodDepErrorDetails(2);
        Vector oSelectors = this.m_oCompNode.getSelectors();
        Vector vErrors = new Vector();
        int nSize = oSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodISelector oSelector = (OiiodISelector)oSelectors.elementAt(i);
            oSelector.canDeselect(oError);
        }
        if (oError.hasErrors()) {
            if (errListener != null) {
                String sMsg = OiixResourceBundle.getString("S_ERROR_CMP_DESEL");
                errListener.processError(sMsg, oError.getErrorLines());
            }
            return false;
        }
        this.m_oCompNode.deselect();
        this.activatePatches(this.m_oCompNode);
        return bRet;
    }

    @Override
    public boolean canParticipate() {
        boolean bParticipate = this.m_oParentNode.canParticipate() ? (this.isVisible() ? true : this.isSelected()) : false;
        return bParticipate;
    }

    @Override
    public boolean canDeselect(OiiodDepErrorDetails oError) {
        if (!this.isEnforced() || this.m_oCompNode.getCompStatus() == 2) {
            return true;
        }
        boolean bRet = true;
        try {
            int nRuleType = this.m_oRuleNode.getRuleType();
            switch (nRuleType) {
                case 3: {
                    oError.addProblemRule(this.m_oRuleNode);
                    bRet = false;
                    break;
                }
                case 1: {
                    Vector oSelectedNodes = this.m_oRuleNode.getCurrentSelections();
                    if (oSelectedNodes.size() != 1 || oSelectedNodes.elementAt(0) != this) break;
                    oError.addProblemRule(this.m_oRuleNode);
                    bRet = false;
                    break;
                }
            }
        }
        catch (OiiodDepCountException exp) {
            oError.addProblemRule(this.m_oRuleNode);
        }
        return bRet;
    }

    @Override
    public void callListeners(int nMessage) {
        int nSize = this.m_oUIListeners.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodIDepEngCmpListener listener = (OiiodIDepEngCmpListener)this.m_oUIListeners.elementAt(i);
            listener.stateChanged(nMessage);
        }
    }

    public boolean equals(OiiiCompInstallID id) {
        if (id == null) {
            return false;
        }
        return this.m_oCompNode.equals(id);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof OiiiCompInstallID) {
            return this.equals((OiiiCompInstallID)other);
        }
        return super.equals(other);
    }

    public void activatePatches(OiiodDepNode oNode) {
        Vector v = oNode.getRules();
        int nSize = v.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRule = (OiiodDepRuleNode)v.elementAt(i);
            Vector vDeps = oRule.getDepNodes();
            int nComps = vDeps.size();
            for (int j = 0; j < nComps; ++j) {
                OiiodDepNode oDepNode = (OiiodDepNode)vDeps.elementAt(j);
                OiiodPatchesNode oPatchesNode = oDepNode.getPatchesNode();
                oPatchesNode.callListeners(2);
            }
        }
    }

    public void setDefaultSelection(boolean bDefaultSelection) {
        this.m_bDefaultSelection = bDefaultSelection;
    }

    public boolean getDefaultSelection() {
        return this.m_bDefaultSelection;
    }

    public void setAskUser(boolean bAsk) {
        this.m_bAsk = bAsk;
    }
}

