/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiodReplaceRangeComps {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16384;
    private Vector m_oCompNodes = new Vector();
    private OiiiInstallCompInvEntry m_oInstallEntry;
    private Vector m_oReplEntries;
    private static boolean s_bIgnoreBuild = OiixOraparam.canIgnoreBuildNumber();

    public OiiodReplaceRangeComps(OiiiInstallCompInvEntry installEntry) {
        this.m_oInstallEntry = installEntry;
    }

    public OiiodDepNode getDepNode(OiiiCompInstallID id) {
        OiiodDepNode oNode = null;
        int index = OiixVectorOps.vectIndexOf(this.m_oCompNodes, (Object)id);
        if (index != -1) {
            oNode = (OiiodDepNode)this.m_oCompNodes.elementAt(index);
        }
        return oNode;
    }

    public void addDepNode(OiiodDepNode oChild) {
        int i;
        int nSize = this.m_oCompNodes.size();
        for (i = 0; i < nSize; ++i) {
            OiiodDepNode oNode = (OiiodDepNode)this.m_oCompNodes.elementAt(i);
            if (oChild.getVersion().equals(oNode.getVersion(), s_bIgnoreBuild)) break;
            if (!oChild.getVersion().laterThan(oNode.getVersion(), s_bIgnoreBuild)) continue;
            this.m_oCompNodes.insertElementAt(oChild, i);
            break;
        }
        if (i == nSize) {
            this.m_oCompNodes.addElement(oChild);
        }
        this.setCompStatus(oChild);
    }

    public boolean isCompInRange(OiiiCompInstallID id) {
        OiiodDepNode oNode;
        OiiiCompInstallID oTopID;
        boolean bIsInRange = false;
        int nSize = this.m_oCompNodes.size();
        if (nSize > 0 && (oTopID = (oNode = (OiiodDepNode)this.m_oCompNodes.elementAt(0)).getCompInstallID()).getName().equals(id.getName())) {
            bIsInRange = oTopID.inSameVersionRange(id);
        }
        return bIsInRange;
    }

    public Vector getAllComps() {
        return this.m_oCompNodes;
    }

    public OiiodDepNode getSelectedNode() {
        OiiodDepNode oSelectedNode = null;
        int nSize = this.m_oCompNodes.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepNode oNode = (OiiodDepNode)this.m_oCompNodes.elementAt(i);
            if (!oNode.isSelected()) continue;
            oSelectedNode = oNode;
            break;
        }
        return oSelectedNode;
    }

    public void setInstalledVersion(OiiiInstallCompInvEntry invEntry) {
        this.m_oInstallEntry = invEntry;
    }

    public OiiiInstallCompInvEntry getInstalledInventory() {
        return this.m_oInstallEntry;
    }

    public void setReplaceComps(Vector vEntries) {
        this.m_oReplEntries = vEntries;
    }

    public Vector getReplaceComps() {
        if (this.m_oReplEntries == null) {
            return new Vector();
        }
        return this.m_oReplEntries;
    }

    private void setCompStatus(OiiodDepNode oChild) {
        if (this.m_oInstallEntry != null) {
            oChild.setInstalledVersion(this.m_oInstallEntry);
            OiiiCompInstallID id = this.m_oInstallEntry.getCompInstallID();
            OiiiVersion oInstVer = id.getVersion();
            OiiiVersion oCurVer = oChild.getVersion();
            if (oInstVer.laterThan(oCurVer, s_bIgnoreBuild)) {
                oChild.setCompStatus(3);
            }
            if (oInstVer.equals(oCurVer, s_bIgnoreBuild)) {
                oChild.setCompStatus(5);
            }
            if (oCurVer.laterThan(oInstVer, s_bIgnoreBuild)) {
                oChild.setCompStatus(1);
            }
        }
    }
}

