/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiod.OiiodDepPatchNode;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngCmpListener;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngErrListener;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepPatchObject;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiodPatchesNode
implements OiiodIDepPatchObject {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16384;
    private OiiodDepNode m_oParentNode;
    private Vector m_oPatchNodes;
    private OiiiVersion m_oMinimumPatchLevel;
    private OiiiVersion m_oSelectedPatchLevel;
    private Vector m_oUIListeners;
    private boolean m_bSelected;
    private int m_nCompStatus;
    private OiiiInstallPatchInvEntry m_oInstallEntry;
    private String m_sName;
    private static boolean s_bIgnoreBuild = OiixOraparam.canIgnoreBuildNumber();

    public OiiodPatchesNode(OiiodDepNode depNode) {
        this.m_oParentNode = depNode;
        this.m_oUIListeners = new Vector();
        this.m_oPatchNodes = new Vector();
        this.m_oMinimumPatchLevel = null;
        this.m_oSelectedPatchLevel = null;
        this.m_bSelected = false;
        this.m_nCompStatus = 6;
        this.m_oInstallEntry = null;
        this.m_sName = OiixResourceBundle.getString("S_CT_PATCH");
    }

    public String getDisplayName() {
        return this.m_sName;
    }

    public OiiodDepNode getParentNode() {
        return this.m_oParentNode;
    }

    public OiiodDepPatchNode getPatchNode(OiiiVersion oVer) {
        OiiodDepPatchNode oNode = null;
        int index = OiixVectorOps.vectIndexOf(this.m_oPatchNodes, (Object)oVer);
        if (index != -1) {
            oNode = (OiiodDepPatchNode)this.m_oPatchNodes.elementAt(index);
        }
        return oNode;
    }

    public void addPatchNode(OiiodDepPatchNode oChild) {
        int i;
        int nSize = this.m_oPatchNodes.size();
        for (i = 0; i < nSize; ++i) {
            OiiodDepPatchNode oNode = (OiiodDepPatchNode)this.m_oPatchNodes.elementAt(i);
            if (oChild.getVersion().equals(oNode.getVersion(), s_bIgnoreBuild)) break;
            if (!oChild.getVersion().laterThan(oNode.getVersion(), s_bIgnoreBuild)) continue;
            this.m_oPatchNodes.insertElementAt(oChild, i);
            break;
        }
        if (i == nSize) {
            this.m_oPatchNodes.addElement(oChild);
        }
    }

    public Vector getAllPatches() {
        return this.m_oPatchNodes;
    }

    @Override
    public Vector getPatchLevels() {
        OiiiVersion oNodeVersion;
        OiiodDepPatchNode oNode;
        int i;
        Vector<OiiiVersion> vPatches = new Vector<OiiiVersion>();
        int nSize = this.m_oPatchNodes.size();
        boolean bMinimumPatchLevelSet = false;
        for (i = 0; i < nSize; ++i) {
            oNode = (OiiodDepPatchNode)this.m_oPatchNodes.elementAt(i);
            oNodeVersion = oNode.getVersion();
            if (!oNode.isActiveSelectorPresent()) continue;
            this.setMinimumPatchLevel(oNodeVersion);
            bMinimumPatchLevelSet = true;
            break;
        }
        if (!bMinimumPatchLevelSet) {
            this.m_oMinimumPatchLevel = null;
        }
        for (i = 0; i < nSize; ++i) {
            oNode = (OiiodDepPatchNode)this.m_oPatchNodes.elementAt(i);
            oNodeVersion = oNode.getVersion();
            if (this.m_oMinimumPatchLevel != null && this.m_oMinimumPatchLevel.laterThan(oNodeVersion, s_bIgnoreBuild)) break;
            vPatches.addElement(oNodeVersion);
        }
        return vPatches;
    }

    @Override
    public OiiiVersion getMinimumPatchLevel() {
        return this.m_oMinimumPatchLevel;
    }

    public void setMinimumPatchLevel(OiiiVersion oMinVer) {
        this.m_oMinimumPatchLevel = oMinVer;
        this.callListeners(2);
    }

    @Override
    public OiiiVersion getSelectedPatchLevel() {
        return this.m_oSelectedPatchLevel;
    }

    public void setupPatchLevels() {
        if (this.hasPatches()) {
            OiiiVersion installedVersion = this.getInstalledVersion();
            if (installedVersion != null) {
                this.setSelected(true);
            }
            if (this.isSelected()) {
                this.setCompStatus(0);
            }
        }
    }

    public boolean hasPatches() {
        return this.m_oPatchNodes.size() > 0;
    }

    public void setSelectedPatchLevel(OiiiVersion selected) {
        this.m_oSelectedPatchLevel = selected;
        this.setSelected(true);
        this.callListeners(32);
        this.callListeners(2);
    }

    @Override
    public boolean selectPatchLevel(OiiodIDepEngErrListener errListener, OiiiVersion patchVersion) {
        if (errListener != null && !this.isSelected()) {
            return true;
        }
        if (this.m_oSelectedPatchLevel != null && this.m_oSelectedPatchLevel.laterThan(patchVersion, s_bIgnoreBuild) && this.isActiveSelectorPresent(this.m_oSelectedPatchLevel)) {
            return false;
        }
        OiiodDepPatchNode oNode = this.getPatchNode(patchVersion);
        this.setSelectedPatchLevel(patchVersion);
        Vector vMessages = new Vector();
        oNode.select(vMessages);
        return true;
    }

    public Vector getChildren() {
        return null;
    }

    @Override
    public Vector getAllChildren() {
        return null;
    }

    @Override
    public Vector getVisibleChildren() {
        return null;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDescription() {
        String sDesc = "";
        if (this.m_oSelectedPatchLevel != null) {
            OiiodDepPatchNode oPatch = this.getPatchNode(this.m_oSelectedPatchLevel);
            sDesc = oPatch.getDescription();
        }
        return sDesc;
    }

    @Override
    public boolean isExpandedByDefault() {
        return true;
    }

    @Override
    public OiiiCompInstallID getCompInstallID() {
        OiiiCompInstallID id = null;
        if (this.m_oSelectedPatchLevel != null) {
            OiiodDepPatchNode oPatch = this.getPatchNode(this.m_oSelectedPatchLevel);
            id = oPatch.getCompInstallID();
        }
        return id;
    }

    @Override
    public void addUIListener(OiiodIDepEngCmpListener listener) {
        this.m_oUIListeners.addElement(listener);
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean isSelected() {
        if (!this.m_oParentNode.isSelected() || this.m_oParentNode.getCompStatus() == 3) {
            return false;
        }
        return this.m_bSelected;
    }

    public boolean isSelectedForInstall() {
        if (this.m_oParentNode.getCompStatus() == 3) {
            return false;
        }
        return this.m_bSelected;
    }

    public void setSelected(boolean bSelect) {
        boolean prevSelection = this.m_bSelected;
        this.m_bSelected = bSelect;
        if (this.m_bSelected) {
            this.setCompStatus(0);
        } else {
            this.setCompStatus(6);
        }
        this.callListeners(1);
        this.callListeners(8);
    }

    @Override
    public boolean isSelectable() {
        boolean bSelectable = false;
        if (this.getInstallStatus() != 3) {
            if (this.getInstallStatus() == 2 || this.getInstallStatus() == 5) {
                bSelectable = true;
            } else {
                OiiiCompInstallID id = this.m_oParentNode.getCompInstallID();
                if (!this.isActiveSelectorPresent(id.getVersion())) {
                    bSelectable = true;
                }
            }
        }
        return bSelectable;
    }

    @Override
    public boolean areAllSubCmpsSelected() {
        return true;
    }

    public int calcPatchStatus(int initStatus) {
        int status = initStatus;
        if (this.m_oInstallEntry != null) {
            OiiiVersion installedVersion = this.getInstalledVersion();
            if (this.m_oSelectedPatchLevel.laterThan(installedVersion, s_bIgnoreBuild)) {
                status = 1;
            }
            if (installedVersion.laterThan(this.m_oSelectedPatchLevel, s_bIgnoreBuild)) {
                status = 3;
            }
            if (this.m_oSelectedPatchLevel.equals(installedVersion, s_bIgnoreBuild)) {
                status = 5;
            }
        } else if (this.m_oSelectedPatchLevel != null) {
            status = 0;
        }
        return status;
    }

    public void calcInitStatus() {
        int status = this.calcPatchStatus(6);
        this.setCompStatus(status);
    }

    public void setCompStatus(int status) {
        int nCompStatus = this.calcPatchStatus(this.m_nCompStatus);
        this.m_nCompStatus = OiiodDepNode.computeCorrectStatus(nCompStatus, status);
    }

    @Override
    public int getInstallStatus() {
        if (!this.m_oParentNode.isSelected() || this.m_oParentNode.getCompStatus() == 3) {
            this.setCompStatus(6);
        }
        return this.m_nCompStatus;
    }

    public void setInstalledVersion(OiiiInstallPatchInvEntry invEntry) {
        this.m_oInstallEntry = invEntry;
    }

    public OiiiInstallPatchInvEntry getInstallInvEntry() {
        return this.m_oInstallEntry;
    }

    @Override
    public OiiiVersion getInstalledVersion() {
        OiiiVersion oInstalledVer = null;
        if (this.m_oInstallEntry != null) {
            oInstalledVer = this.m_oInstallEntry.getCompInstallID().getVersion();
        }
        return oInstalledVer;
    }

    @Override
    public boolean select(OiiodIDepEngErrListener errListener) {
        this.setSelected(true);
        if (this.m_oSelectedPatchLevel != null) {
            OiiodDepPatchNode oPatch = this.getPatchNode(this.m_oSelectedPatchLevel);
            Vector v = new Vector();
            oPatch.select(v);
        }
        return true;
    }

    @Override
    public boolean deselect(OiiodIDepEngErrListener errListener) {
        if ((this.m_nCompStatus == 2 || this.m_nCompStatus == 1) && this.m_oParentNode.getCompStatus() == 2) {
            String sMsg = OiixResourceBundle.getString("S_ERROR_PATCH_DESEL");
            errListener.processError(sMsg, null);
            return false;
        }
        this.setSelected(false);
        if (this.m_oSelectedPatchLevel != null) {
            OiiodDepPatchNode oPatch = this.getPatchNode(this.m_oSelectedPatchLevel);
            Vector v = new Vector();
            oPatch.deselect(v);
        }
        return true;
    }

    private boolean isActiveSelectorPresent(OiiiVersion oUptoVersion) {
        OiiodDepPatchNode oNode;
        boolean bPresent = false;
        int nSize = this.m_oPatchNodes.size();
        for (int i = 0; i < nSize && !oUptoVersion.laterThan((oNode = (OiiodDepPatchNode)this.m_oPatchNodes.elementAt(i)).getVersion(), s_bIgnoreBuild); ++i) {
            if (!oNode.isActiveSelectorPresent()) continue;
            bPresent = true;
            break;
        }
        return bPresent;
    }

    public void callListeners(int nMessage) {
        int nSize = this.m_oUIListeners.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodIDepEngCmpListener listener = (OiiodIDepEngCmpListener)this.m_oUIListeners.elementAt(i);
            listener.stateChanged(nMessage);
        }
    }

    public void print(String sTab) {
        int nSize = this.m_oPatchNodes.size();
        System.out.println(sTab + "Contains " + nSize + " Patches");
        for (int i = 0; i < nSize; ++i) {
            OiiodDepPatchNode oPatch = (OiiodDepPatchNode)this.m_oPatchNodes.elementAt(i);
            oPatch.print(sTab + "  ");
        }
    }
}

