/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepRuleNode;
import oracle.sysman.oii.oiio.oiiod.OiiodISelector;
import oracle.sysman.oii.oiio.oiiod.OiiodPatchesNode;
import oracle.sysman.oii.oiio.oiiod.OiiodRuleSelector;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDepRuleProperty;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiodDepNode {
    private OiiiCompInstallID m_oCompID;
    private OiiiCompInvEntry m_oCompInvEntry;
    public static final int S_INSTALL = 0;
    public static final int S_UPGRADE = 1;
    public static final int S_REINSTALL = 2;
    public static final int S_DOWNGRADE = 3;
    public static final int S_DEINSTALL = 4;
    public static final int S_ALREADY_INSTALLED = 5;
    public static final int S_NOT_INSTALLED = 6;
    private static final int PARTICIPATION_UNKNOWN = 0;
    private static final int NO_PARTICIPATION = 1;
    private static final int PARTICIPATES = 2;
    private int m_iParticipate = 0;
    private boolean m_bDowngrade;
    private int m_nCompStatus;
    private int m_nInitialCompStatus;
    private boolean m_bInitialCompStatusSet = false;
    private boolean m_bNotInStage;
    private Vector m_oParentRuleNodes;
    private Vector m_oSelectors;
    private Vector m_oRules;
    private OiisDepMode m_oDepMode;
    private OiiodPatchesNode m_oPatchesNode;
    private OiiiInstallCompInvEntry m_oInstallEntry;
    private boolean m_bSelectedAtDepModeApply;

    public OiiodDepNode(OiiiCompInvEntry invEntry) {
        this.m_oCompInvEntry = invEntry;
        this.m_oCompID = invEntry.getCompInstallID();
        this.m_bNotInStage = false;
        this.m_oDepMode = null;
        this.m_nCompStatus = 6;
        this.m_oParentRuleNodes = new Vector();
        this.m_oRules = new Vector();
        this.m_oSelectors = new Vector();
        this.m_oPatchesNode = new OiiodPatchesNode(this);
        this.m_oInstallEntry = null;
    }

    public boolean isNotInStage() {
        return this.m_bNotInStage;
    }

    public void setNotInStage(boolean val) {
        this.m_bNotInStage = val;
    }

    public boolean isDownGrade() {
        return this.m_nCompStatus == 3;
    }

    public boolean isSelectable() {
        return this.m_nCompStatus != 3;
    }

    public OiisDepMode getInstallType() {
        return this.m_oDepMode;
    }

    public void setInstallType(OiisDepMode oMode) {
        if (this.m_oDepMode != null) {
            if (!this.m_oDepMode.equals(oMode) && this.m_oCompInvEntry instanceof OiiiStageCompInvEntry) {
                OiisDepMode currentDepMode = this.m_oDepMode;
                OiisDepInfo dInfo = ((OiiiStageCompInvEntry)this.m_oCompInvEntry).getDepInfo();
                this.m_oDepMode = dInfo.getDepMode("Custom");
                if (!currentDepMode.getInternalName().equals("Custom")) {
                    Object[] args = new String[4];
                    String sMsg = "\t" + OiixResourceBundle.getString("S_LOG_COMP_INSTALL_TYPE_CONFLICT");
                    args[0] = this.getDisplayName();
                    args[1] = oMode.getName() + " (" + oMode.getInternalName() + ")";
                    args[2] = currentDepMode.getName() + " (" + currentDepMode.getInternalName() + ")";
                    args[3] = this.m_oDepMode.getName() + " (" + this.m_oDepMode.getInternalName() + ")";
                    sMsg = MessageFormat.format(sMsg, args);
                    OiiodDepEngine.logText(sMsg);
                }
            }
        } else {
            this.m_oDepMode = oMode;
        }
    }

    public int getCompStatus() {
        return this.m_nCompStatus;
    }

    public void setCompStatus(int status) {
        this.m_nCompStatus = OiiodDepNode.computeCorrectStatus(this.m_nCompStatus, status);
        if (!this.m_bInitialCompStatusSet) {
            this.m_nInitialCompStatus = this.m_nCompStatus;
            this.m_bInitialCompStatusSet = true;
        }
    }

    public int getInstallStatus() {
        if (!this.isSelected()) {
            if (this.m_nCompStatus == 1 || this.m_nCompStatus == 3) {
                return 5;
            }
            return 6;
        }
        return this.m_nCompStatus;
    }

    public void setInstalledVersion(OiiiInstallCompInvEntry invEntry) {
        this.m_oInstallEntry = invEntry;
    }

    public OiiiInstallCompInvEntry getInstallInvEntry() {
        return this.m_oInstallEntry;
    }

    public OiiiVersion getInstalledVersion() {
        OiiiVersion oInstalledVer = null;
        if (this.m_oInstallEntry != null) {
            oInstalledVer = this.m_oInstallEntry.getCompInstallID().getVersion();
        }
        return oInstalledVer;
    }

    public boolean isEnforced() {
        return true;
    }

    public boolean isSelected() {
        if (this.isDownGrade()) {
            return true;
        }
        if (this.getCompStatus() == 5) {
            return true;
        }
        boolean bIsSelected = false;
        int nSize = this.m_oSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodISelector oSelector = (OiiodISelector)this.m_oSelectors.elementAt(i);
            if (!oSelector.isSelectedForInstall() || !oSelector.isEnforced()) continue;
            bIsSelected = true;
            break;
        }
        return bIsSelected;
    }

    public String getDisplayName() {
        return this.m_oCompInvEntry.getFullDisplayName();
    }

    public OiiiStageCompInvEntry getStageInvEntry() {
        if (this.m_oCompInvEntry instanceof OiiiStageCompInvEntry) {
            return (OiiiStageCompInvEntry)this.m_oCompInvEntry;
        }
        return null;
    }

    public OiiiCompInstallID getCompInstallID() {
        return this.m_oCompID;
    }

    public void resetAll() {
        this.m_oSelectors = new Vector();
        int nSize = this.m_oRules.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            oRule.resetAll();
        }
        this.m_oDepMode = null;
        if (this.m_bInitialCompStatusSet) {
            this.m_nCompStatus = this.m_nInitialCompStatus;
        }
    }

    public OiiiVersion getVersion() {
        return this.m_oCompID.getVersion();
    }

    public OiiodPatchesNode getPatchesNode() {
        return this.m_oPatchesNode;
    }

    public boolean hasPatches() {
        return this.m_oPatchesNode.hasPatches();
    }

    public void addRule(OiiodDepRuleNode oChild) {
        if (this.m_oRules.indexOf(oChild) == -1) {
            this.m_oRules.addElement(oChild);
        }
    }

    public Vector getRules() {
        return this.m_oRules;
    }

    public boolean hasRules() {
        return this.m_oRules.size() > 0;
    }

    public void addParentRule(OiiodDepRuleNode oRule) {
        if (this.m_oParentRuleNodes.indexOf(oRule) == -1) {
            this.m_oParentRuleNodes.addElement(oRule);
        }
    }

    public Vector getParentRules() {
        return this.m_oParentRuleNodes;
    }

    public void addSelector(OiiodISelector oSelector) {
        boolean bSelectedBefore = this.isSelected();
        if (this.m_oSelectors.indexOf(oSelector) == -1) {
            this.m_oSelectors.addElement(oSelector);
            if (this.m_nCompStatus != 5) {
                if (bSelectedBefore) {
                    oSelector.setSelected(true);
                } else if (this.isSelected()) {
                    this.select();
                }
            }
        }
    }

    public Vector getSelectors() {
        return this.m_oSelectors;
    }

    public boolean hasSelectors() {
        return this.m_oSelectors.size() > 0;
    }

    public void select() {
        this.setCompStatus(0);
        int nSize = this.m_oSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodISelector oSelector = (OiiodISelector)this.m_oSelectors.elementAt(i);
            oSelector.setSelected(true);
        }
    }

    public void deselect() {
        this.setCompStatus(6);
        int nSize = this.m_oSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodISelector oSelector = (OiiodISelector)this.m_oSelectors.elementAt(i);
            oSelector.setSelected(false);
        }
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDescription() {
        return this.m_oCompInvEntry.getDescription();
    }

    public boolean equals(OiiiCompInstallID id) {
        return this.equals(id, true);
    }

    public boolean equals(OiiiCompInstallID id, boolean bIgnoreBuild) {
        if (id == null) {
            return false;
        }
        return this.m_oCompID.equalsWithPlatInt(id, bIgnoreBuild);
    }

    public boolean equals(Object other) {
        return this.equals(other, true);
    }

    public boolean equals(Object other, boolean bIgnoreBuild) {
        if (other == null) {
            return false;
        }
        if (other instanceof OiiiCompInstallID) {
            return this.equals((OiiiCompInstallID)other, bIgnoreBuild);
        }
        if (other instanceof OiiodDepNode) {
            OiiiCompInstallID id = ((OiiodDepNode)other).getCompInstallID();
            return this.equals(id, bIgnoreBuild);
        }
        return super.equals(other);
    }

    public Vector getCurrentDeps() {
        Vector vCompsList = new Vector();
        int nSize = this.m_oRules.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            Vector oDepNodes = oRule.getDepNodes();
            OiixVectorOps.unionInPlace(vCompsList, oDepNodes);
        }
        return vCompsList;
    }

    public OiisDepRuleProperty getDepRuleProperty(String ruleID) {
        if (this.m_oDepMode == null) {
            return null;
        }
        Vector depRuleProps = this.m_oDepMode.getDepRuleProps();
        OiisDepRuleProperty retProp = null;
        int nIndex = OiixVectorOps.vectIndexOf(depRuleProps, (Object)ruleID);
        if (nIndex != -1) {
            retProp = (OiisDepRuleProperty)depRuleProps.elementAt(nIndex);
        }
        return retProp;
    }

    public void callListeners(int nMessage) {
        int nSize = this.m_oSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodISelector oSelector = (OiiodISelector)this.m_oSelectors.elementAt(i);
            oSelector.callListeners(nMessage);
        }
    }

    public static int computeCorrectStatus(int curStatus, int newStatus) {
        int correctStatus = newStatus;
        if (curStatus == 5 && newStatus == 0) {
            correctStatus = 2;
        } else if (curStatus == 5 && newStatus == 6) {
            correctStatus = 5;
        } else if (curStatus == 2 && newStatus == 6) {
            correctStatus = 5;
        } else if (curStatus == 2 && newStatus == 0) {
            correctStatus = 2;
        } else if (curStatus == 1 && (newStatus == 0 || newStatus == 6)) {
            correctStatus = 1;
        } else if (curStatus == 3 && (newStatus == 0 || newStatus == 6)) {
            correctStatus = 3;
        }
        return correctStatus;
    }

    public boolean canParticipate() {
        this.m_iParticipate = this.computeParticipation();
        return this.m_iParticipate == 2;
    }

    private int computeParticipation() {
        int iParticipate = 1;
        int nSize = this.m_oSelectors.size();
        for (int i = 0; iParticipate != 2 && i < nSize; ++i) {
            OiiodISelector oSelector = (OiiodISelector)this.m_oSelectors.elementAt(i);
            if (!oSelector.canParticipate()) continue;
            iParticipate = 2;
        }
        return iParticipate;
    }

    public Vector getSelectedVisibleDependees() {
        Vector<OiiodDepNode> vDependees = new Vector<OiiodDepNode>(5, 5);
        if (this.m_oRules != null) {
            int nRules = this.m_oRules.size();
            for (int i = 0; i < nRules; ++i) {
                OiiodDepRuleNode oRuleNode = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
                Vector vDepSelectors = oRuleNode.getChildren();
                if (vDepSelectors == null) continue;
                int nDepSelectors = vDepSelectors.size();
                for (int j = 0; j < nDepSelectors; ++j) {
                    OiiodRuleSelector oSelector = (OiiodRuleSelector)vDepSelectors.elementAt(j);
                    if (!oRuleNode.isVisible() || !oSelector.isSelected()) continue;
                    vDependees.addElement(oSelector.getCompNode());
                }
            }
        }
        return vDependees;
    }

    Vector getParticipatingDependees() {
        Vector<OiiodDepNode> vDependees = new Vector<OiiodDepNode>(5, 5);
        if (this.m_oRules != null) {
            int nRules = this.m_oRules.size();
            for (int i = 0; i < nRules; ++i) {
                OiiodDepRuleNode oRuleNode = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
                Vector vDepNodes = oRuleNode.getDepNodes();
                if (vDepNodes == null) continue;
                int nDepNodes = vDepNodes.size();
                for (int j = 0; j < nDepNodes; ++j) {
                    OiiodDepNode oDepNode = (OiiodDepNode)vDepNodes.elementAt(j);
                    if (!oDepNode.canParticipate()) continue;
                    vDependees.addElement(oDepNode);
                }
            }
        }
        return vDependees;
    }

    public boolean hasVisbileDependees() {
        boolean bVisible = false;
        int nSize = this.m_oRules.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRuleNode = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            if (!oRuleNode.isVisible()) continue;
            bVisible = true;
            break;
        }
        return bVisible;
    }

    public void print(String sTab) {
        int nSize = this.m_oRules.size();
        System.out.println(sTab + "Dep Node Name : " + this.toString());
        System.out.println(sTab + "PATCHES");
        this.m_oPatchesNode.print(sTab + "  ");
        System.out.println(sTab + "Contains " + nSize + " Rules");
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRule = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            oRule.print(sTab + "  ");
        }
    }

    void setSelectedAtDepModeApply(boolean bSelect) {
        this.m_bSelectedAtDepModeApply = bSelect;
    }

    boolean isSelectedAtDepModeApply() {
        return this.m_bSelectedAtDepModeApply;
    }
}

