/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiio.oiiod.OiiodDepRuleNode;
import oracle.sysman.oii.oiio.oiiod.OiiodISelector;
import oracle.sysman.oii.oiio.oiiod.OiiodRuleSelector;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiiodDepErrorDetails {
    public static final int S_SELECTION_ERROR = 1;
    public static final int S_DESELECTION_ERROR = 2;
    private OiiodDepRuleNode m_oRuleNode;
    private Vector m_oRules;
    private int m_nType = 1;
    private boolean m_bFoundTopLevel = false;
    private Vector m_oTree;

    public OiiodDepErrorDetails(int nType) {
        this.m_nType = nType;
        this.m_oRules = new Vector();
    }

    private void getOneLevelChildren(OiiodDepRuleNode oRule, Vector v) {
        String sTab = "  ";
        Vector vDepNodes = oRule.getChildren();
        int nSize = vDepNodes.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodISelector oNode = (OiiodISelector)vDepNodes.elementAt(i);
            v.addElement(sTab + oNode);
        }
    }

    public boolean hasErrors() {
        return this.m_oRules.size() > 0;
    }

    private void getOSPSelectedChildren(OiiodDepRuleNode oRule, Vector v) {
        String sTab = "  ";
        Vector vDepNodes = oRule.getOSPSelections();
        int nSize = vDepNodes.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodRuleSelector oNode = (OiiodRuleSelector)vDepNodes.elementAt(i);
            v.addElement(sTab + oNode);
        }
    }

    private void createSelectionErrors() {
        String sMsg = OiixResourceBundle.getString("S_DEPTREE_SEL_DETAILS");
        String sRuleMsg = OiixResourceBundle.getString("S_DEPTREE_RULE_DETAILS");
        this.m_oTree.addElement(sMsg);
        int nSize = this.m_oRules.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRuleNode = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            Object[] s = new String[]{oRuleNode.toString()};
            this.m_oTree.addElement(MessageFormat.format(sRuleMsg, s));
            this.getOSPSelectedChildren(oRuleNode, this.m_oTree);
        }
    }

    private void createDeSelectionWarnings() {
        String sMsg = OiixResourceBundle.getString("S_DEPTREE_SEL_DETAILS");
        String sRuleMsg = OiixResourceBundle.getString("S_DEPTREE_RULE_DETAILS");
        this.m_oTree.addElement(sMsg);
        int nSize = this.m_oRules.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRuleNode = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            Object[] s = new String[]{oRuleNode.toString()};
            this.m_oTree.addElement(MessageFormat.format(sRuleMsg, s));
            this.getOSPSelectedChildren(oRuleNode, this.m_oTree);
        }
    }

    private void createDeSelectionErrors() {
        String sMsg = OiixResourceBundle.getString("S_ERROR_CMP_DESEL_DETAILS");
        this.m_oTree.addElement(sMsg);
        int nSize = this.m_oRules.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oRuleNode = (OiiodDepRuleNode)this.m_oRules.elementAt(i);
            this.m_oTree.addElement(i + 1 + ". " + oRuleNode.getParentNode().toString());
            String sRuleMsg = OiixResourceBundle.getString("S_REQUIRED");
            if (oRuleNode.getRuleType() == 1) {
                sRuleMsg = "";
            }
            this.m_oTree.addElement(oRuleNode.toString() + sRuleMsg);
            this.getOneLevelChildren(oRuleNode, this.m_oTree);
            this.m_oTree.addElement("\n");
        }
    }

    public void addProblemRule(OiiodDepRuleNode oNode) {
        this.m_oRules.addElement(oNode);
    }

    public Vector getErrorLines() {
        if (this.m_oTree == null) {
            this.m_oTree = new Vector();
            switch (this.m_nType) {
                case 1: {
                    this.createSelectionErrors();
                    break;
                }
                case 2: {
                    this.createDeSelectionErrors();
                }
            }
        }
        return this.m_oTree;
    }
}

