/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiii.OiiiAreaInventory;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompIdVerPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiDeinstallObjects;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodRuleSelector;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompProperties;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiodDepEngineHelper {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x2004000;
    private static int m_nCurPlatform = OiixPlatform.getCurrentPlatform();
    private static Vector allComponents = new Vector();

    public static Vector getRefsToDeinstall(OiiiAreaInventory areaInv, OiiiCompIdOhPair cIdOh, Vector vCompsToRemove, Vector vOneoffsToRemove) {
        Hashtable recRefsMap = new Hashtable();
        Hashtable hOneoffs = new Hashtable();
        Vector retVect = OiiodDepEngineHelper.getAllRecursiveDependents(areaInv, cIdOh, recRefsMap, vCompsToRemove, vOneoffsToRemove, hOneoffs);
        return retVect;
    }

    private static void addPatchOneoffs(OiiiInstallPatchInvEntry ipie, Vector deinstallOneoffs) {
        block8: {
            boolean debug = Boolean.getBoolean("oracle.installer.debug");
            try {
                Vector vPatchMiniPatchsets;
                OiiiOneoffIdOhPair oPair;
                OiiiOneoffInvEntry ooEntry;
                int k;
                int kSize;
                Vector vPatchOneoffs = ipie.getOneoffsVect();
                if (vPatchOneoffs != null) {
                    kSize = vPatchOneoffs.size();
                    for (k = 0; k < kSize; ++k) {
                        ooEntry = (OiiiInstallOneoffInvEntry)vPatchOneoffs.elementAt(k);
                        oPair = ((OiiiInstallOneoffInvEntry)ooEntry).getOneoffIdOhPair();
                        if (debug) {
                            OiiolTextLogger.appendText(" Selecting Oneoffid " + oPair.getOneoffID() + ", Base Compid " + ipie.getCompInstallID() + " Home " + oPair.getHomeIndex());
                        }
                        if (deinstallOneoffs.contains(oPair)) continue;
                        deinstallOneoffs.addElement(oPair);
                    }
                }
                if ((vPatchMiniPatchsets = (Vector)ipie.getMiniPatchsetsList()) != null) {
                    kSize = vPatchMiniPatchsets.size();
                    for (k = 0; k < kSize; ++k) {
                        ooEntry = (OiiiInstallMiniPatchsetInvEntry)vPatchMiniPatchsets.elementAt(k);
                        oPair = ((OiiiInstallMiniPatchsetInvEntry)ooEntry).getMiniPatchsetIdOhPair();
                        if (debug) {
                            OiiolTextLogger.appendText(" Selecting MiniPatchsetid " + oPair.getOneoffID() + ", Base Compid " + ipie.getCompInstallID() + " Home " + oPair.getHomeIndex());
                        }
                        if (deinstallOneoffs.contains(oPair)) continue;
                        deinstallOneoffs.addElement(oPair);
                    }
                }
            }
            catch (Exception e) {
                if (!debug) break block8;
                OiiolTextLogger.appendException(e);
            }
        }
    }

    public static Vector getDependeesToDeinstall(OiiiAreaInventory areaInv, Vector deinstallCompOhs, Vector deinstallOneoffs, Hashtable hOneoffs) {
        Vector allDeinstalls = (Vector)deinstallCompOhs.clone();
        Vector allDependees = new Vector();
        int numDeinsts = deinstallCompOhs.size();
        Hashtable idsToRecDeps = new Hashtable();
        boolean debug = Boolean.getBoolean("oracle.installer.debug");
        Vector allCompsFromDeinstallHomes = new Vector();
        for (int i = 0; i < numDeinsts; ++i) {
            Vector topLvlComps;
            OiiiCompIdOhPair selIdOh = (OiiiCompIdOhPair)deinstallCompOhs.elementAt(i);
            int ohIdx = selIdOh.getOHIndex();
            if (null != areaInv) {
                allComponents.addAll(areaInv.getAllCompsVect(ohIdx));
            }
            if (OiixVectorOps.vectorSubset(topLvlComps = OiiiCompIdOhPair.createCompIdOhVector(areaInv.getTopLevelComps(ohIdx), ohIdx), allDeinstalls)) {
                Vector<OiiiCompIdOhPair> allCompsVect = new Vector<OiiiCompIdOhPair>();
                Enumeration allComps = areaInv.getAllComps(ohIdx);
                while (allComps.hasMoreElements()) {
                    OiiiCompInvEntry cie = (OiiiCompInvEntry)allComps.nextElement();
                    OiiiCompIdOhPair cidOh = new OiiiCompIdOhPair(cie.getCompInstallID(), ohIdx);
                    allCompsVect.add(cidOh);
                }
                OiixVectorOps.unionInPlace(allCompsFromDeinstallHomes, allCompsVect);
            }
            OiixVectorOps.unionInPlace(allDependees, OiiodDepEngineHelper.getAllRecursiveDependees(areaInv, selIdOh, idsToRecDeps, deinstallOneoffs, hOneoffs));
        }
        OiixVectorOps.unionInPlace(allDependees, allCompsFromDeinstallHomes);
        allDependees = OiiodDepEngineHelper.sortCompOhsList(areaInv, allDependees, deinstallOneoffs, hOneoffs);
        Enumeration deps = allDependees.elements();
        while (deps.hasMoreElements()) {
            Vector refs;
            int ohIndex;
            OiiiCompInstallID cid;
            OiiiInstallCompInvEntry icie;
            OiiiCompIdOhPair cIdOh = (OiiiCompIdOhPair)deps.nextElement();
            if (allDeinstalls.contains(cIdOh) || (icie = (OiiiInstallCompInvEntry)areaInv.getCompatCompEntry(cid = cIdOh.getCompID(), ohIndex = cIdOh.getOHIndex(), m_nCurPlatform)) == null || !OiixVectorOps.vectorSubset(refs = icie.getReferencers(), allDeinstalls)) continue;
            allDeinstalls.addElement(cIdOh);
        }
        Vector<OiiiCompIdOhPair> finalDeinstalls = new Vector<OiiiCompIdOhPair>();
        int nSize = allDeinstalls.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiInstallPatchInvEntry ipie;
            int ohIndex;
            OiiiCompIdOhPair cIdOh = (OiiiCompIdOhPair)allDeinstalls.elementAt(i);
            OiiiCompInstallID cid = cIdOh.getCompID();
            OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)areaInv.getCompatCompEntry(cid, ohIndex = cIdOh.getOHIndex(), m_nCurPlatform);
            if (icie != null && (ipie = icie.getPatchInvEntry()) != null) {
                OiiiCompIdOhPair pPair = new OiiiCompIdOhPair(ipie.getCompInstallID(), ohIndex);
                OiiodDepEngineHelper.addPatchOneoffs(ipie, deinstallOneoffs);
                if (!finalDeinstalls.contains(pPair)) {
                    if (debug) {
                        OiiolTextLogger.appendText("Adding to  Deinstall Component List " + cIdOh);
                    }
                    finalDeinstalls.addElement(pPair);
                }
            }
            if (finalDeinstalls.contains(cIdOh)) continue;
            finalDeinstalls.addElement(cIdOh);
        }
        OiiodDepEngineHelper.filterOneOffsToDeinstall(deinstallOneoffs, finalDeinstalls, areaInv);
        return finalDeinstalls;
    }

    public static Vector sortCompsList(OiiiAreaInventory areaInv, Vector compsList) {
        int vectSize = compsList.size();
        if (vectSize < 2) {
            return compsList;
        }
        Hashtable depsVals = new Hashtable(vectSize);
        for (int i = 0; i < vectSize; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)compsList.elementAt(i);
            OiiodDepEngineHelper.getAllRecursiveDependees(areaInv, cid, depsVals);
        }
        return OiiodDepEngineHelper.sortCompsList(compsList, depsVals);
    }

    public static Vector sortCompsList(Vector compsList, Hashtable depsVals) {
        int vectSize = compsList.size();
        Vector retLst = (Vector)compsList.clone();
        for (int i = 0; i < vectSize - 1; ++i) {
            for (int j = i + 1; j < vectSize; ++j) {
                OiiiCompInstallID aid = (OiiiCompInstallID)retLst.elementAt(i);
                OiiiCompInstallID bid = (OiiiCompInstallID)retLst.elementAt(j);
                Vector deps = (Vector)depsVals.get(bid);
                if (!deps.contains(aid)) continue;
                retLst.setElementAt(bid, i);
                retLst.setElementAt(aid, j);
            }
        }
        return retLst;
    }

    public static Vector groupCIdsVect(Vector cidVect) {
        Vector cidGroups = OiiodDepEngineHelper.groupCIdsVectIgnoringPlats(cidVect);
        Vector<Vector> retCidGroups = new Vector<Vector>();
        int numGps = cidGroups.size();
        for (int i = 0; i < numGps; ++i) {
            Vector gpI = (Vector)cidGroups.elementAt(i);
            int numEls = gpI.size();
            if (numEls <= 0) continue;
            OiiiCompInstallID cid = (OiiiCompInstallID)gpI.elementAt(0);
            if (cid.getCompType() == 4) {
                retCidGroups.addElement(gpI);
                continue;
            }
            Vector nonIntersectingGps = OiiodDepEngineHelper.splitIntoGpsOfIntPlats(gpI);
            OiixVectorOps.unionInPlace(retCidGroups, nonIntersectingGps);
        }
        return retCidGroups;
    }

    private static Vector groupCIdsVectIgnoringPlats(Vector cidVect) {
        Vector cidGroups = new Vector();
        int numIDs = cidVect.size();
        for (int i = 0; i < numIDs; ++i) {
            int j;
            OiiiCompInstallID cid = (OiiiCompInstallID)cidVect.elementAt(i);
            String intName = cid.getName();
            OiiiVersion ver = cid.getVersion();
            int compType = cid.getCompType();
            int numGroups = cidGroups.size();
            for (j = 0; j < numGroups; ++j) {
                Vector gpJ = (Vector)cidGroups.elementAt(j);
                OiiiCompInstallID gId = (OiiiCompInstallID)gpJ.firstElement();
                if (!gId.getName().equals(intName) || !gId.getVersion().equals(ver) || gId.getCompType() != compType) continue;
                gpJ.addElement(cid);
                break;
            }
            if (j != numGroups) continue;
            Vector<OiiiCompInstallID> newGpVect = new Vector<OiiiCompInstallID>();
            newGpVect.addElement(cid);
            cidGroups.addElement(newGpVect);
        }
        return cidGroups;
    }

    private static Vector splitIntoGpsOfIntPlats(Vector sameNameVerVect) {
        Vector allPlats = new Vector();
        int numIDs = sameNameVerVect.size();
        for (int i = 0; i < numIDs; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)sameNameVerVect.elementAt(i);
            OiixVectorOps.unionInPlace(allPlats, cid.getPlatforms());
        }
        Vector remainingPlats = (Vector)allPlats.clone();
        Vector remainingCIds = (Vector)sameNameVerVect.clone();
        Vector idGpGps = new Vector();
        while (!remainingPlats.isEmpty()) {
            Vector intGpPlats = new Vector();
            Vector<OiiiCompInstallID> curIDGp = new Vector<OiiiCompInstallID>();
            intGpPlats.addElement(remainingPlats.firstElement());
            for (int srchPos = 0; srchPos < intGpPlats.size(); ++srchPos) {
                Integer searchPlat = (Integer)intGpPlats.elementAt(srchPos);
                int numRemIDs = remainingCIds.size();
                int numMoves = 0;
                for (int i = 0; i < numRemIDs; ++i) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)remainingCIds.elementAt(i - numMoves);
                    Vector idPlats = cid.getPlatforms();
                    if (!idPlats.contains(searchPlat)) continue;
                    OiixVectorOps.unionInPlace(intGpPlats, idPlats);
                    remainingCIds.removeElement(cid);
                    curIDGp.addElement(cid);
                    ++numMoves;
                }
            }
            OiixVectorOps.subtractInPlace(remainingPlats, intGpPlats);
            idGpGps.addElement(curIDGp);
        }
        return idGpGps;
    }

    public static Vector sortCIDGpsList(Vector cidGpsList, Hashtable depsVals) {
        int vectSize = cidGpsList.size();
        Vector retLst = (Vector)cidGpsList.clone();
        for (int i = 0; i < vectSize - 1; ++i) {
            for (int j = i + 1; j < vectSize; ++j) {
                Vector aids = (Vector)retLst.elementAt(i);
                Vector bids = (Vector)retLst.elementAt(j);
                int numAIds = aids.size();
                int numBIds = bids.size();
                boolean switched = false;
                for (int k = 0; !switched && k < numAIds; ++k) {
                    OiiiCompInstallID aid = (OiiiCompInstallID)aids.elementAt(k);
                    for (int l = 0; !switched && l < numBIds; ++l) {
                        OiiiCompInstallID bid = (OiiiCompInstallID)bids.elementAt(l);
                        String bidGpHashStr = OiiodDepEngineHelper.computeIDGpHashStr(bid);
                        Vector deps = (Vector)depsVals.get(bidGpHashStr);
                        if (!deps.contains(aid)) continue;
                        retLst.setElementAt(bids, i);
                        retLst.setElementAt(aids, j);
                        switched = true;
                    }
                }
            }
        }
        return retLst;
    }

    public static String computeIDGpHashStr(OiiiCompInstallID cid) {
        int hashType = cid.getCompType();
        if (hashType == 2) {
            hashType = 1;
        }
        OiiiVersion hashVer = hashType == 4 ? cid.getVersion() : cid.getReplaceVersion();
        return cid.getName() + ";" + hashType + ";" + hashVer;
    }

    public static Vector sortCompOhsList(OiiiAreaInventory areaInv, Vector compOhsList) {
        Vector deinstallOneoffs = new Vector();
        Hashtable hOneoffs = new Hashtable();
        return OiiodDepEngineHelper.sortCompOhsList(areaInv, compOhsList, deinstallOneoffs, hOneoffs);
    }

    public static Vector sortCompOhsList(OiiiAreaInventory areaInv, Vector compOhsList, Vector deinstallOneoffs, Hashtable hOneoffs) {
        int vectSize = compOhsList.size();
        if (vectSize < 2) {
            return compOhsList;
        }
        Hashtable depsVals = new Hashtable(vectSize);
        for (int i = 0; i < vectSize; ++i) {
            OiiiCompIdOhPair cIdOh = (OiiiCompIdOhPair)compOhsList.elementAt(i);
            OiiodDepEngineHelper.getAllRecursiveDependees(areaInv, cIdOh, depsVals, deinstallOneoffs, hOneoffs);
        }
        return OiiodDepEngineHelper.sortCompOhsList(compOhsList, depsVals);
    }

    public static Vector sortCompOhsList(Vector compOhsList, Hashtable depsVals) {
        int vectSize = compOhsList.size();
        Vector retLst = (Vector)compOhsList.clone();
        for (int i = 0; i < vectSize - 1; ++i) {
            for (int j = i + 1; j < vectSize; ++j) {
                OiiiCompIdOhPair aIdOh = (OiiiCompIdOhPair)retLst.elementAt(i);
                OiiiCompIdOhPair bIdOh = (OiiiCompIdOhPair)retLst.elementAt(j);
                Vector deps = (Vector)depsVals.get(bIdOh);
                if (deps == null || !deps.contains(aIdOh)) continue;
                retLst.setElementAt(bIdOh, i);
                retLst.setElementAt(aIdOh, j);
            }
        }
        return retLst;
    }

    public static Vector getUnrefComps(OiiiAreaInventory areaInv, int ohIndex) {
        Vector compIdsVect = areaInv.getTopLevelComps(ohIndex);
        Vector vRefComps = OiiiCompIdOhPair.createCompIdOhVector(compIdsVect, ohIndex);
        Vector compInvEntries = areaInv.getAllCompsVect(ohIndex);
        Vector vUnRefComps = new Vector(10, 10);
        int nSize = compInvEntries.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInvEntry oEntry = (OiiiCompInvEntry)compInvEntries.elementAt(i);
            OiiiCompIdOhPair cIdOh = new OiiiCompIdOhPair(oEntry.getCompInstallID(), ohIndex);
            OiiodDepEngineHelper.computeUnrefComps(areaInv, cIdOh, vRefComps, vUnRefComps);
        }
        return vUnRefComps;
    }

    public static boolean computeUnrefComps(OiiiAreaInventory areaInv, OiiiCompIdOhPair cIdOh, Vector vRefComps, Vector vUnRefComps) {
        OiiiCompInstallID cid = cIdOh.getCompID();
        int ohIndex = cIdOh.getOHIndex();
        OiiiPatchInstallID pid = null;
        if (cid instanceof OiiiPatchInstallID) {
            pid = (OiiiPatchInstallID)cid;
            cid = pid.getCompInstallID();
            cIdOh = new OiiiCompIdOhPair(cid, ohIndex);
        }
        boolean bTopRefFound = false;
        Object recRefsHere = null;
        int nUnrefIndex = OiixVectorOps.vectIndexOf(vUnRefComps, (Object)cid);
        if (vRefComps.indexOf(cIdOh) == -1 && nUnrefIndex == -1) {
            OiiiCompInvEntry icie = areaInv.getCompatCompEntry(cid, ohIndex, m_nCurPlatform);
            if (icie == null) {
                return false;
            }
            Vector recsHere = icie.getReferencers();
            int numDeps = recsHere.size();
            for (int i = 0; i < numDeps; ++i) {
                OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)recsHere.elementAt(i);
                OiiiCompInvEntry backicie = areaInv.getCompatCompEntry(depIdOh.getCompID(), depIdOh.getOHIndex(), m_nCurPlatform);
                if (backicie == null) continue;
                if (backicie.isTopLevel()) {
                    if (cIdOh.getOHIndex() != depIdOh.getOHIndex()) break;
                    bTopRefFound = true;
                    vRefComps.addElement(depIdOh);
                    break;
                }
                if (vRefComps.indexOf(depIdOh) != -1) {
                    if (cIdOh.getOHIndex() != depIdOh.getOHIndex()) break;
                    bTopRefFound = true;
                    break;
                }
                if (OiixVectorOps.vectIndexOf(vUnRefComps, (Object)depIdOh.getCompID()) != -1 || cIdOh.getOHIndex() != depIdOh.getOHIndex() || !OiiodDepEngineHelper.computeUnrefComps(areaInv, depIdOh, vRefComps, vUnRefComps)) continue;
                bTopRefFound = true;
                break;
            }
            if (bTopRefFound) {
                vRefComps.addElement(cIdOh);
            } else {
                vUnRefComps.addElement(icie);
            }
        } else {
            bTopRefFound = nUnrefIndex == -1;
        }
        return bTopRefFound;
    }

    public static Vector getAllRecursiveDependents(OiiiAreaInventory areaInv, OiiiCompIdOhPair cIdOh, Hashtable recRefsMap, Vector vCompsToRemove, Vector vOneoffsToRemove, Hashtable hOneoffs) {
        Vector<OiiiCompIdOhPair> vAllCompsToRemove = vCompsToRemove != null ? (Vector)vCompsToRemove.clone() : new Vector<OiiiCompIdOhPair>();
        Vector vAllOneoffsToRemove = null;
        vAllOneoffsToRemove = vAllOneoffsToRemove != null ? (Vector)vOneoffsToRemove.clone() : new Vector();
        Vector vOneoffs = new Vector();
        OiiiCompInstallID cid = cIdOh.getCompID();
        int ohIndex = cIdOh.getOHIndex();
        OiiiPatchInstallID pid = null;
        if (cid instanceof OiiiPatchInstallID) {
            pid = (OiiiPatchInstallID)cid;
            cid = pid.getCompInstallID();
            cIdOh = new OiiiCompIdOhPair(cid, ohIndex);
        }
        Vector<OiiiCompIdOhPair> recRefsHere = null;
        recRefsHere = (Vector<OiiiCompIdOhPair>)recRefsMap.get(cIdOh);
        if (recRefsHere == null) {
            recRefsHere = new Vector<OiiiCompIdOhPair>();
            recRefsMap.put(cIdOh, recRefsHere);
            OiiiCompInvEntry icie = areaInv.getCompatCompEntry(cid, ohIndex, m_nCurPlatform);
            if (icie == null) {
                return recRefsHere;
            }
            OiiodDepEngineHelper.addToOneoffsVect(vOneoffs, cIdOh, (OiiiInstallInventory)areaInv);
            Vector recsHere = icie.getReferencers();
            int numDeps = recsHere.size();
            for (int i = 0; i < numDeps; ++i) {
                OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)recsHere.elementAt(i);
                if (recRefsHere.contains(depIdOh)) continue;
                if (!cIdOh.equals(depIdOh)) {
                    OiiiCompInvEntry backicie = areaInv.getCompatCompEntry(depIdOh.getCompID(), depIdOh.getOHIndex(), m_nCurPlatform);
                    Vector depsBack = backicie.getDependees();
                    int nIndex = OiixVectorOps.vectIndexOf(depsBack, (Object)cIdOh);
                    if (nIndex != -1) {
                        OiiiCompIdOhPair depBackIdOh = (OiiiCompIdOhPair)depsBack.elementAt(nIndex);
                        int iDepType = depBackIdOh.getDepType();
                        if (iDepType == 0) continue;
                        if (iDepType == 1) {
                            String sDepGroup = depBackIdOh.getDepGroup();
                            Vector vDeps = backicie.getDependees(sDepGroup);
                            int iCompsToRemove = vAllCompsToRemove.size();
                            for (int j = 0; j < iCompsToRemove; ++j) {
                                OiiiCompIdOhPair oComp = (OiiiCompIdOhPair)vAllCompsToRemove.elementAt(j);
                                int nLoc = vDeps.indexOf(oComp);
                                if (nLoc == -1) continue;
                                vDeps.removeElementAt(nLoc);
                            }
                            if (!vDeps.isEmpty()) continue;
                        }
                    }
                    recRefsHere.addElement(depIdOh);
                    vAllCompsToRemove.addElement(depIdOh);
                    OiiodDepEngineHelper.addToOneoffsVect(vOneoffs, depIdOh, (OiiiInstallInventory)areaInv);
                    Vector depRecRefs = (Vector)recRefsMap.get(depIdOh);
                    if (depRecRefs == null) {
                        depRecRefs = OiiodDepEngineHelper.getAllRecursiveDependents(areaInv, depIdOh, recRefsMap, vAllCompsToRemove, vOneoffsToRemove, hOneoffs);
                    }
                    OiixVectorOps.unionInPlace(recRefsHere, depRecRefs);
                    OiixVectorOps.unionInPlace(vAllCompsToRemove, depRecRefs);
                } else {
                    recRefsHere.addElement(depIdOh);
                }
                vAllCompsToRemove.addElement(depIdOh);
            }
            if (pid != null) {
                recRefsHere.addElement(cIdOh);
                vAllCompsToRemove.addElement(cIdOh);
            }
        }
        int iOneoffs = vOneoffs.size();
        for (int k = 0; k < iOneoffs; ++k) {
            OiiiOneoffIdOhPair oPair = (OiiiOneoffIdOhPair)vOneoffs.elementAt(k);
            if (hOneoffs.get(oPair.getOneoffID()) != null) continue;
            hOneoffs.put(oPair.getOneoffID(), oPair);
            if (!vOneoffsToRemove.contains(oPair)) {
                vOneoffsToRemove.addElement(oPair);
            }
            try {
                OiiiOneoffInvEntry ooEntry;
                int iBaseComps = 0;
                Vector vBaseCompsOfMiniPatchsets = null;
                Vector vBaseCompsOfOneoffs = null;
                boolean isOneoff = false;
                if (oPair.isOneoff()) {
                    ooEntry = ((OiiiInstallInventory)areaInv).getOneoffInvEntry(oPair.getOneoffID().getID(), oPair.getHomeIndex());
                    vBaseCompsOfOneoffs = ooEntry.getBaseComps();
                    iBaseComps = vBaseCompsOfOneoffs.size();
                    isOneoff = true;
                } else {
                    ooEntry = ((OiiiInstallInventory)areaInv).getMiniPatchsetInvEntry(oPair.getOneoffID().getID(), oPair.getHomeIndex());
                    vBaseCompsOfMiniPatchsets = ((OiiiMiniPatchsetInvEntry)ooEntry).getBaseComps();
                    iBaseComps = vBaseCompsOfMiniPatchsets.size();
                }
                for (int ik = 0; ik < iBaseComps; ++ik) {
                    OiiiCompIdOhPair oBCIdOh = null;
                    if (isOneoff) {
                        oBCIdOh = (OiiiCompIdOhPair)vBaseCompsOfOneoffs.elementAt(ik);
                    } else {
                        OiiiCompIdVerPair oBCIdVerPair = (OiiiCompIdVerPair)vBaseCompsOfOneoffs.elementAt(ik);
                        oBCIdOh = oBCIdVerPair.getCompIdOhPair();
                    }
                    Vector depRecRefs = (Vector)recRefsMap.get(oBCIdOh);
                    if (depRecRefs != null) continue;
                    depRecRefs = OiiodDepEngineHelper.getAllRecursiveDependents(areaInv, oBCIdOh, recRefsMap, vAllCompsToRemove, vOneoffsToRemove, hOneoffs);
                    OiixVectorOps.unionInPlace(recRefsHere, depRecRefs);
                    OiixVectorOps.unionInPlace(vAllCompsToRemove, depRecRefs);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recRefsHere;
    }

    public static Vector getAllRecursiveDependees(OiiiAreaInventory areaInv, OiiiCompIdOhPair cIdOh, Hashtable recDepsMap, Vector vOneoffsToRemove, Hashtable hOneoffs) {
        OiiiCompInstallID cid = cIdOh.getCompID();
        int ohIndex = cIdOh.getOHIndex();
        Vector vOneoffs = new Vector();
        OiiiPatchInstallID pid = null;
        if (cid instanceof OiiiPatchInstallID) {
            pid = (OiiiPatchInstallID)cid;
            cid = pid.getCompInstallID();
            cIdOh = new OiiiCompIdOhPair(cid, ohIndex);
        }
        if (cid.isNOHComp()) {
            ohIndex = 0;
        }
        OiiiInstallCompInvEntry icie = null;
        icie = pid == null ? (OiiiInstallCompInvEntry)areaInv.getCompatCompEntry(cid, ohIndex, m_nCurPlatform) : (OiiiInstallCompInvEntry)areaInv.getCompatCompEntry(pid, ohIndex, m_nCurPlatform);
        if (icie != null) {
            Vector vCompOneoffs = icie.getOneoffsVect();
            vOneoffs = OiiodDepEngineHelper.getOneoffIdOhVect(vCompOneoffs);
            Vector vCompMiniPatchsets = (Vector)icie.getMiniPatchsetsList();
            OiixVectorOps.unionInPlace(vOneoffs, OiiodDepEngineHelper.getOneoffIdOhVect(vCompMiniPatchsets));
        }
        Vector<OiiiCompIdOhPair> recDepsHere = null;
        recDepsHere = (Vector<OiiiCompIdOhPair>)recDepsMap.get(cIdOh);
        if (recDepsHere == null) {
            recDepsHere = new Vector<OiiiCompIdOhPair>();
            recDepsMap.put(cIdOh, recDepsHere);
            Vector depsHere = areaInv.getCurrentEntryDeps(cid, ohIndex);
            int numDeps = depsHere.size();
            for (int i = 0; i < numDeps; ++i) {
                OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)depsHere.elementAt(i);
                if (recDepsHere.contains(depIdOh)) continue;
                recDepsHere.addElement(depIdOh);
                Vector depRecDeps = (Vector)recDepsMap.get(depIdOh);
                if (depRecDeps == null) {
                    depRecDeps = OiiodDepEngineHelper.getAllRecursiveDependees(areaInv, depIdOh, recDepsMap, vOneoffsToRemove, hOneoffs);
                }
                OiixVectorOps.unionInPlace(recDepsHere, depRecDeps);
            }
        }
        int iSize = vOneoffs.size();
        for (int k = 0; k < iSize; ++k) {
            OiiiOneoffIdOhPair oPair = (OiiiOneoffIdOhPair)vOneoffs.elementAt(k);
            if (hOneoffs.get(oPair.getOneoffID()) != null) continue;
            hOneoffs.put(oPair.getOneoffID(), oPair);
            if (!vOneoffsToRemove.contains(oPair)) {
                vOneoffsToRemove.addElement(oPair);
            }
            try {
                OiiiOneoffInvEntry ooEntry;
                int iBaseComps = 0;
                Vector vBaseCompsOfMiniPatchsets = null;
                Vector vBaseCompsOfOneoffs = null;
                boolean isOneoff = false;
                if (oPair.isOneoff()) {
                    ooEntry = ((OiiiInstallInventory)areaInv).getOneoffInvEntry(oPair.getOneoffID().getID(), oPair.getHomeIndex());
                    vBaseCompsOfOneoffs = ooEntry.getBaseComps();
                    iBaseComps = vBaseCompsOfOneoffs.size();
                    isOneoff = true;
                } else {
                    ooEntry = ((OiiiInstallInventory)areaInv).getMiniPatchsetInvEntry(oPair.getOneoffID().getID(), oPair.getHomeIndex());
                    vBaseCompsOfMiniPatchsets = ((OiiiMiniPatchsetInvEntry)ooEntry).getBaseComps();
                    iBaseComps = vBaseCompsOfMiniPatchsets.size();
                }
                for (int ik = 0; ik < iBaseComps; ++ik) {
                    OiiiCompIdOhPair oBCIdOh = null;
                    if (isOneoff) {
                        oBCIdOh = (OiiiCompIdOhPair)vBaseCompsOfOneoffs.elementAt(ik);
                    } else {
                        OiiiCompIdVerPair oBCIdVerPair = (OiiiCompIdVerPair)vBaseCompsOfOneoffs.elementAt(ik);
                        oBCIdOh = oBCIdVerPair.getCompIdOhPair();
                    }
                    Vector depRecRefs = (Vector)recDepsMap.get(oBCIdOh);
                    if (depRecRefs != null) continue;
                    depRecRefs = OiiodDepEngineHelper.getAllRecursiveDependees(areaInv, oBCIdOh, recDepsMap, vOneoffsToRemove, hOneoffs);
                    OiixVectorOps.unionInPlace(recDepsHere, depRecRefs);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recDepsHere;
    }

    public static Vector getAllRecursiveDependees(OiiiAreaInventory areaInv, OiiiCompInstallID cid, Hashtable recDepsMap) {
        OiiiCompInvEntry icie = areaInv.getCompatCompEntry(cid, 0, m_nCurPlatform);
        Vector<OiiiCompInstallID> recDepsHere = new Vector<OiiiCompInstallID>();
        if (icie == null) {
            return recDepsHere;
        }
        if (cid instanceof OiiiPatchInstallID) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)cid;
            cid = pid.getCompInstallID();
            icie = areaInv.getCompatCompEntry(cid, 0, m_nCurPlatform);
        }
        Vector depsHere = icie.getDependees();
        int numDeps = depsHere.size();
        for (int i = 0; i < numDeps; ++i) {
            OiiiCompInstallID depID = (OiiiCompInstallID)depsHere.elementAt(i);
            if (recDepsHere.contains(depID)) continue;
            recDepsHere.addElement(depID);
            Vector depRecDeps = (Vector)recDepsMap.get(depID);
            if (depRecDeps == null) {
                depRecDeps = OiiodDepEngineHelper.getAllRecursiveDependees(areaInv, depID, recDepsMap);
            }
            OiixVectorOps.unionInPlace(recDepsHere, depRecDeps);
        }
        recDepsMap.put(cid, recDepsHere);
        return recDepsHere;
    }

    public static boolean getLangsToInstall(OiicPullSession session, OiiiCompInstallID cid, OiiiStageCompInvEntry scie, Vector compLangs, Vector warnings) {
        int OHIndex;
        OiiiAreaInventory inventory;
        OiiiCompInvEntry ocie;
        OiicSessionContext oContext = session.getSessionContext();
        OiisCompProperties cp = session.getCompInstall(cid).getProperties();
        Vector supportedLangs = cp.getSupportedLangs();
        Vector selLangs = null;
        if (session.isCloneMode()) {
            selLangs = OiiodDepEngineHelper.getInstalledLanguages(session, cid);
        } else {
            OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
            String[] strList = (String[])oLangs.getValue();
            selLangs = OiixLanguage.getLangsVector(strList);
        }
        Vector oCompLangs = OiixVectorOps.intersect(selLangs, supportedLangs);
        for (int i = 0; i < oCompLangs.size(); ++i) {
            compLangs.addElement(oCompLangs.elementAt(i));
        }
        boolean bChanged = true;
        Locale compDefLang = null;
        int nDefLangIndex = OiixVectorOps.vectIndexOf(supportedLangs, (Object)OiixLanguage.ENGLISH);
        if (nDefLangIndex != -1) {
            compDefLang = (Locale)supportedLangs.elementAt(nDefLangIndex);
        }
        if (compDefLang == null && (compDefLang = cp.getDefaultLang()) == null) {
            compDefLang = (Locale)supportedLangs.elementAt(0);
        }
        if (compLangs.indexOf(compDefLang) == -1) {
            compLangs.addElement(compDefLang);
        }
        if ((ocie = (inventory = session.getInstallAreaControl().getAreaInventory()).getCompatCompEntry(cid, OHIndex = session.getHomeIndex(cid))) != null) {
            OiiiCompIdOhPair cIdRef;
            Vector vOneoffsToDeinstall;
            Vector vCompsToDeinstall;
            Vector installedLangs = ocie.getLanguages();
            OiiiCompIdOhPair cIdOh = new OiiiCompIdOhPair(ocie.getCompInstallID(), OHIndex);
            Vector refs = OiiodDepEngineHelper.getRefsToDeinstall(inventory, cIdOh, vCompsToDeinstall = new Vector(), vOneoffsToDeinstall = new Vector());
            if (!refs.isEmpty() && refs.size() == 1 && !(cIdRef = (OiiiCompIdOhPair)refs.elementAt(0)).getCompID().equals(ocie.getCompInstallID())) {
                Vector stagedLangs = scie.getLanguages();
                int size = installedLangs == null ? 0 : installedLangs.size();
                for (int i = 0; i < size; ++i) {
                    Locale mergeElem = (Locale)installedLangs.elementAt(i);
                    if (mergeElem.equals(OiixLanguage.OLD_US_ENGLISH)) {
                        mergeElem = OiixLanguage.US_ENGLISH;
                    }
                    if (mergeElem.equals(OiixLanguage.OLD_FR_FRENCH)) {
                        mergeElem = OiixLanguage.FR_FRENCH;
                    }
                    if (compLangs.contains(mergeElem)) continue;
                    if (stagedLangs.contains(mergeElem)) {
                        compLangs.addElement(mergeElem);
                        continue;
                    }
                    warnings.addElement(mergeElem.getDisplayName());
                }
            }
            if (OiixVectorOps.vectorsEqual(compLangs, installedLangs)) {
                bChanged = false;
            }
        }
        return bChanged;
    }

    private static Vector getInstalledLanguages(OiicPullSession session, OiiiCompInstallID cid) {
        OiiiInstallInventory instInv = session.getInstallAreaControl().getInstallInventory();
        OiiiInstallCompInvEntry invEntry = instInv.getInstallCompInvEntry(cid, session.getOHIndex());
        return invEntry.getLanguages();
    }

    public static void mergeVect(Vector v1, Vector v2) {
        if (v2 == null) {
            return;
        }
        int nSize = v2.size();
        for (int i = 0; i < nSize; ++i) {
            int idx;
            Object obj = v2.elementAt(i);
            if (obj instanceof OiiodRuleSelector) {
                obj = ((OiiodRuleSelector)obj).getCompInstallID();
            }
            if ((idx = OiixVectorOps.vectIndexOf(v1, obj)) != -1) continue;
            v1.addElement(v2.elementAt(i));
        }
    }

    private static void addToOneoffsVect(Vector vOneoffs, OiiiCompIdOhPair baseIdOh, OiiiInstallInventory inventory) {
        OiiiInstallPatchInvEntry oPatchEntry;
        OiiiInstallCompInvEntry icie;
        Vector vBaseOneoffs;
        boolean bPatch = false;
        boolean bPatchSet = false;
        OiiiCompInstallID cid = baseIdOh.getCompID();
        if (cid.getCompType() == 2) {
            OiiiPatchInstallID pid = (OiiiPatchInstallID)cid;
            cid = pid.getCompInstallID();
            bPatch = true;
        }
        if (cid.getCompType() == 4) {
            bPatchSet = true;
        }
        int iSize = (vBaseOneoffs = (icie = (OiiiInstallCompInvEntry)inventory.getCompatCompEntry(cid, baseIdOh.getOHIndex(), m_nCurPlatform)).getOneoffsVect()) != null ? vBaseOneoffs.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallOneoffInvEntry ooEntry = (OiiiInstallOneoffInvEntry)vBaseOneoffs.elementAt(i);
            OiiiOneoffIdOhPair oPair = ooEntry.getOneoffIdOhPair();
            if (vOneoffs.contains(oPair)) continue;
            vOneoffs.addElement(oPair);
        }
        Vector vBaseMiniPatchsets = (Vector)icie.getMiniPatchsetsList();
        iSize = vBaseMiniPatchsets != null ? vBaseMiniPatchsets.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallMiniPatchsetInvEntry ooEntry = (OiiiInstallMiniPatchsetInvEntry)vBaseMiniPatchsets.elementAt(i);
            OiiiOneoffIdOhPair oPair = ooEntry.getMiniPatchsetIdOhPair();
            if (vOneoffs.contains(oPair)) continue;
            vOneoffs.addElement(oPair);
        }
        if (!bPatch && !bPatchSet && (oPatchEntry = icie.getPatchInvEntry()) != null) {
            Vector vPatchOneoffs = oPatchEntry.getOneoffsVect();
            int kSize = vPatchOneoffs.size();
            for (int k = 0; k < kSize; ++k) {
                OiiiInstallOneoffInvEntry ooEntry = (OiiiInstallOneoffInvEntry)vPatchOneoffs.elementAt(k);
                OiiiOneoffIdOhPair oPair = ooEntry.getOneoffIdOhPair();
                if (vOneoffs.contains(oPair)) continue;
                vOneoffs.addElement(oPair);
            }
            Vector vPatchMiniPatchsets = (Vector)oPatchEntry.getMiniPatchsetsList();
            kSize = vPatchMiniPatchsets.size();
            for (int k = 0; k < kSize; ++k) {
                OiiiInstallMiniPatchsetInvEntry ooEntry = (OiiiInstallMiniPatchsetInvEntry)vPatchMiniPatchsets.elementAt(k);
                OiiiOneoffIdOhPair oPair = ooEntry.getMiniPatchsetIdOhPair();
                if (vOneoffs.contains(oPair)) continue;
                vOneoffs.addElement(oPair);
            }
        }
    }

    private static Vector getOneoffIdOhVect(Vector vOneoffs) {
        Vector<OiiiOneoffIdOhPair> vRetVect = new Vector<OiiiOneoffIdOhPair>();
        if (vOneoffs == null || vOneoffs.size() == 0) {
            return vRetVect;
        }
        int iSize = vOneoffs.size();
        for (int i = 0; i < iSize; ++i) {
            OiiiInstallOneoffInvEntry ooEntry = (OiiiInstallOneoffInvEntry)vOneoffs.elementAt(i);
            vRetVect.addElement(ooEntry.getOneoffIdOhPair());
        }
        return vRetVect;
    }

    public static OiiiDeinstallObjects getDeinstallObjects(OiiiAreaInventory areaInv, Vector selComps, Vector selOneoffs) {
        Vector allDeinstalls = (Vector)selComps.clone();
        Hashtable hCompsMap = new Hashtable();
        Hashtable hOneoffs = new Hashtable();
        int numDeinsts = selComps.size();
        for (int i = 0; i < numDeinsts; ++i) {
            OiiiCompIdOhPair selIdOh = (OiiiCompIdOhPair)selComps.elementAt(i);
            int ohIndex = selIdOh.getOHIndex();
            if (null != areaInv) {
                allComponents.addAll(areaInv.getAllCompsVect(ohIndex));
            }
            OiixVectorOps.unionInPlace(allDeinstalls, OiiodDepEngineHelper.getAllRecursiveDependents(areaInv, selIdOh, hCompsMap, selComps, selOneoffs, hOneoffs));
        }
        hOneoffs = new Hashtable();
        Vector compsToDeinstall = (Vector)allDeinstalls.clone();
        int iSize = selComps.size();
        for (int k = 0; k < iSize; ++k) {
            OiiiCompIdOhPair selIdOh = (OiiiCompIdOhPair)compsToDeinstall.elementAt(k);
            OiixVectorOps.unionInPlace(allDeinstalls, OiiodDepEngineHelper.getDependeesToDeinstall(areaInv, compsToDeinstall, selOneoffs, hOneoffs));
        }
        OiiodDepEngineHelper.filterOneOffsToDeinstall(selOneoffs, allDeinstalls, areaInv);
        OiiiDeinstallObjects odo = new OiiiDeinstallObjects(allDeinstalls, selOneoffs);
        return odo;
    }

    private static void filterOneOffsToDeinstall(Vector deinstallOneoffs, Vector finalDeinstalls, OiiiAreaInventory areaInv) {
        Vector baseComps = null;
        Vector copy = (Vector)deinstallOneoffs.clone();
        for (int k = 0; k < copy.size(); ++k) {
            OiiiOneoffIdOhPair oPair = (OiiiOneoffIdOhPair)copy.get(k);
            OiiolTextLogger.appendText("\t\t\t #### One-Off Name is : " + oPair.getOneoffID());
            try {
                OiiiInstallOneoffInvEntry ooEntry = ((OiiiInstallInventory)areaInv).getOneoffInvEntry(oPair.getOneoffID().getID(), oPair.getHomeIndex());
                baseComps = ooEntry.getBaseComps();
            }
            catch (OiiiOneoffException ex) {
                OiiolTextLogger.appendText("\t\t\t Discarding the OneOff :'" + oPair.getOneoffID() + "'  because of below exception");
                OiiolTextLogger.appendException(ex);
                continue;
            }
            boolean deinstallOneOff = false;
            if (null != baseComps) {
                block3: for (int index = 0; index < baseComps.size(); ++index) {
                    OiiiCompIdOhPair baseComp = (OiiiCompIdOhPair)baseComps.get(index);
                    if (finalDeinstalls.contains(baseComp)) {
                        deinstallOneOff = true;
                        OiiolTextLogger.appendText("\t\t\t The final list of de-install contains the component :" + baseComp.getCompID().getName() + " which refers the OneOff:" + oPair.getOneoffID() + " and this OneOff will be removed !!!");
                        continue;
                    }
                    for (int innerIndex = 0; innerIndex < allComponents.size(); ++innerIndex) {
                        OiiiInstallCompInvEntry obj = (OiiiInstallCompInvEntry)allComponents.get(innerIndex);
                        if (baseComp.getCompID().getName().equals(obj.getName()) || obj.getCompInstallID().getName().equals(baseComp.getCompID().getName())) {
                            deinstallOneOff = false;
                            OiiolTextLogger.appendText("\t\t\t There are still some reference from components remains to the OneOff: " + oPair.getOneoffID() + " and hence this OneOff won't be removed");
                            break block3;
                        }
                        deinstallOneOff = true;
                    }
                    break;
                }
            }
            if (deinstallOneOff) continue;
            OiiolTextLogger.appendText("\t\t\t *** REMOVING THE ONE-OFF :" + oPair.getOneoffID());
            deinstallOneoffs.remove(oPair);
        }
        copy.clear();
        copy = null;
        OiiolTextLogger.appendText("\t\t\t *** FINAL DE-INSTALL ONE-OFF SIZE = " + deinstallOneoffs.size());
        allComponents.clear();
    }
}

