/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompIdVerPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallMiniPatchsetInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiOneoffIdOhPair;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodAdditionalComps;
import oracle.sysman.oii.oiio.oiiod.OiiodDepCountException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngineHelper;
import oracle.sysman.oii.oiio.oiiod.OiiodDepException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiod.OiiodDepPatchNode;
import oracle.sysman.oii.oiio.oiiod.OiiodDepRuleNode;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngErrListener;
import oracle.sysman.oii.oiio.oiiod.OiiodISelector;
import oracle.sysman.oii.oiio.oiiod.OiiodOneorMoreDepNodeInfo;
import oracle.sysman.oii.oiio.oiiod.OiiodPatchSetNode;
import oracle.sysman.oii.oiio.oiiod.OiiodPatchesNode;
import oracle.sysman.oii.oiio.oiiod.OiiodReplaceRangeComps;
import oracle.sysman.oii.oiio.oiiod.OiiodRuleSelector;
import oracle.sysman.oii.oiio.oiiod.OiiodTimer;
import oracle.sysman.oii.oiio.oiiod.OiiodTopLevelSelector;
import oracle.sysman.oii.oiio.oiiod.OiiodVolumeInfo;
import oracle.sysman.oii.oiio.oiiof.OiiofFileLoaderFactory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgCFSDriveCheck;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDepRuleComp;
import oracle.sysman.oii.oiis.OiisDepRuleProperty;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisPatchDepObj;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisPreRequisiteVar;
import oracle.sysman.oii.oiis.OiisProdHomeVar;
import oracle.sysman.oii.oiis.OiisStagedCompRep;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiiodDepEngine {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x2004000;
    protected Hashtable m_compTable = null;
    private Hashtable m_depsTable = null;
    protected Vector m_replaceRangeComps = null;
    protected OiicInstallTimeSession m_instTimeSession = null;
    private OiicInstallSession m_instSession = null;
    protected Vector m_installCompIds = null;
    protected Vector m_deinstallCompIds = null;
    protected Vector m_deinstallOneoffIdOhs = null;
    protected Map m_oConflictingOneOffIdMap = null;
    private boolean m_bRemoveAllOneOffs = false;
    protected Vector m_alreadyInstalledIds = null;
    private Vector m_topLevelSelectors = null;
    private int m_nCompsProcessed = -1;
    private OiixProgressListener m_progListener = null;
    private OiiiInstallInventory m_installInv = null;
    protected OiiiStageInventory m_stageInv = null;
    private Vector m_compNodes = null;
    private Vector m_patchNodes = null;
    private Vector m_patchSetNodes = null;
    private Vector m_selPatchIds = null;
    private Vector m_selCompsVect = null;
    private Vector m_oneoffNodes = null;
    private ArrayList addComps = new ArrayList();
    protected OiiiCompInstallID[] m_tlSelCompIDs = null;
    private static int medHashSize = 100;
    private static final int S_ONE_OFF_STATUS_NO_REMOVE = 0;
    private static final int S_ONE_OFF_STATUS_REMOVE = 1;
    private static final int S_ONE_OFF_STATUS_CONFLICT = 3;
    private boolean m_bMoreQs = false;
    private boolean m_bExecutePreReq = true;
    private static int m_nCurPlatform = OiixPlatform.getCurrentPlatform();
    private long m_totalReqBytes = -1L;
    private List m_oVolumeSpaceInfo = null;
    private static OiiodIDepEngErrListener s_oErrListener;
    private boolean m_bResponseFileUsed;
    private boolean m_bIgnoreBuild = false;
    private boolean m_bReadOnly = false;
    private Vector m_vReadOnlySelectedCompNodes = null;
    public boolean m_bAutoOUI = false;
    private boolean m_bVersionEqual = false;
    public static final String S_OUI_NAME = "oracle.swd.oui";
    public static final int OUI_INDEX = 0;
    public static final String S_OUI_CORE_NAME = "oracle.swd.oui.core";
    public static final String S_OUI_CORE_MIN_NAME = "oracle.swd.oui.core.min";
    public static final int OUI_CORE_INDEX = 2;
    public static final int OUI_CORE_MIN_INDEX = 3;
    public static final String S_OUI_OPATCH_NAME = "oracle.swd.opatch";
    public static final int OUI_OPATCH_INDEX = 1;
    public static final String[] OUICOMPS;
    public static final int S_OUI_COMPS_COUNT = 4;
    private OiiiCompInstallID m_autopatchCID;
    public static final String S_JRE_NAME = "oracle.swd.jre";
    public static final String S_ADDITIONAL_COMPONENTS = "ADDITIONAL_COMPONENTS";
    private int addComps_size = 0;
    public static final String S_JDK_NAME = "oracle.jdk";
    public static final String JDK_JRE_NAME = "oracle.jre";
    public static final String S_JDK_J2EE_CORE_NAME = "oracle.java.j2ee.core";
    public static final String S_JROCKIT_NAME = "oracle.jrockit";
    private ArrayList m_aOneOrMoreDepNodesToProcess;
    private OiiodTimer depModeTimer;
    private OiiodTimer applySelectionTimer;

    public OiiodDepEngine(OiicInstallSession instSession) {
        this(instSession, false);
    }

    public OiiodDepEngine(OiicInstallTimeSession instSession) {
        this(instSession, false);
    }

    private void init() {
        this.m_compTable = new Hashtable();
        this.m_compNodes = new Vector(5, 10);
        this.m_replaceRangeComps = new Vector(5, 5);
        this.m_patchNodes = new Vector(5, 5);
        this.m_patchSetNodes = new Vector(3, 2);
        this.m_nCompsProcessed = 0;
    }

    public OiiodDepEngine(OiicInstallTimeSession instSession, boolean bReadOnly) {
        this.init();
        this.m_instTimeSession = instSession;
        this.m_installInv = null;
        this.m_bIgnoreBuild = OiixOraparam.canIgnoreBuildNumber();
        this.m_bReadOnly = bReadOnly;
        if (this.m_bReadOnly) {
            this.m_vReadOnlySelectedCompNodes = new Vector(5, 5);
        }
    }

    public void dispose() {
        this.m_installInv = null;
        this.m_compTable = null;
        this.m_selCompsVect = null;
        this.m_deinstallCompIds = null;
        this.m_stageInv = null;
        this.m_compNodes = null;
        this.m_tlSelCompIDs = null;
        this.m_patchNodes = null;
        this.m_patchSetNodes = null;
        this.m_deinstallOneoffIdOhs = null;
        this.m_oConflictingOneOffIdMap = null;
    }

    public void setInventories(OiiiStageInventory oStage, OiiiInstallInventory oInstall) {
        this.m_stageInv = oStage;
        this.m_installInv = oInstall;
    }

    public void setCurrentPlatform(int plat) {
        m_nCurPlatform = plat;
    }

    public void setCurrentTLIDs(OiiiCompInstallID[] ids) {
        this.m_tlSelCompIDs = ids;
    }

    public void setExecutePreReq(boolean bExecute) {
        this.m_bExecutePreReq = bExecute;
    }

    public Vector getReplaceRangeComps() {
        return this.m_replaceRangeComps;
    }

    public Vector getDepNodes() {
        return this.m_compNodes;
    }

    public void setDepNodes(Vector depNodes) {
        this.m_compNodes = depNodes;
    }

    public OiiiCompInstallID[] getCurrentTLIDs() {
        return this.m_tlSelCompIDs;
    }

    public boolean isTopLevelSelComp(OiiiCompInstallID cid) {
        boolean retVal = false;
        int numTLComps = 0;
        if (this.m_tlSelCompIDs != null) {
            numTLComps = this.m_tlSelCompIDs.length;
        }
        for (int i = 0; i < numTLComps; ++i) {
            if (!cid.equals(this.m_tlSelCompIDs[i])) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static Vector getChangedDepModes(OiiiCompInstallID[] oldCompList, String[] oldDepModeList, OiiiCompInstallID[] newCompList, String[] newDepModeList) {
        Vector<Integer> retVect = new Vector<Integer>();
        int numChkComps = newCompList.length;
        block0: for (int i = 0; i < numChkComps; ++i) {
            int numOldComps = oldCompList.length;
            for (int j = 0; j < numOldComps; ++j) {
                if (newCompList[i] == null || !newCompList[i].equals(oldCompList[j])) continue;
                if (newDepModeList[i] != null && newDepModeList[i].equalsIgnoreCase(oldDepModeList[j])) continue block0;
                retVect.addElement(new Integer(i));
                continue block0;
            }
        }
        return retVect;
    }

    public boolean buildCompArray() throws OiiodDepException {
        String[] ac = null;
        if (this.m_instTimeSession instanceof OiicInstallSession) {
            while (this.m_instSession.getInstallAreaControl() == null) {
                this.m_instSession.waitOnLoadInv();
            }
            this.m_installInv = this.m_instSession.getInstallAreaControl().getInstallInventory();
        }
        int nTlComps = this.m_tlSelCompIDs.length;
        boolean bLookForAvailPatches = false;
        bLookForAvailPatches = false;
        this.init();
        for (int i = 0; i < nTlComps; ++i) {
            OiiodDepNode newDepNode;
            OiiiCompInstallID cid = this.m_tlSelCompIDs[i];
            String addComp = System.getProperty("oracle.installer.installAdditionalComponents", null);
            if (addComp != null) {
                StringTokenizer st = new StringTokenizer(addComp, ",");
                int tokens = st.countTokens();
                ac = new String[tokens];
                for (int k = 0; k < tokens; ++k) {
                    ac[k] = st.nextToken();
                }
            } else {
                ac = OiixOraparam.getOraparamProfileStringList("ORACLE", S_ADDITIONAL_COMPONENTS, null);
            }
            if (ac != null) {
                OiiodAdditionalComps obj = new OiiodAdditionalComps(ac);
                ArrayList ret = obj.parseCompsTable();
                int retSize = ret == null ? 0 : ret.size();
                for (int k = 0; k < retSize; ++k) {
                    obj = (OiiodAdditionalComps)ret.get(k);
                    if (!this.buildAdditionalComponents(cid, obj)) continue;
                    this.addComps.add(obj);
                }
            }
            if (cid.getCompType() == 1) {
                bLookForAvailPatches = true;
            } else if (cid.getCompType() == 4) {
                this.m_bRemoveAllOneOffs = System.getProperty("oracle.installer.removeAllOneoffs", "false").equalsIgnoreCase("true");
                this.m_bAutoOUI = false;
                this.m_autopatchCID = null;
                if (!OiixOraparam.getAutoOUIInstall().equalsIgnoreCase("NEVER")) {
                    this.buildOUIComponents(cid);
                }
            }
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("m_bRemoveAllOneOffs is set to:" + this.m_bRemoveAllOneOffs, OiiolTextLogger.getLogLevel());
            }
            if ((newDepNode = this.getDepNode(cid)) == null) {
                this.buildCompArray(cid, null, cid.getCompType(), true);
            }
            this.addComps_size = this.addComps.size();
            try {
                for (int j = 0; j < this.addComps_size; ++j) {
                    OiiodAdditionalComps obj = (OiiodAdditionalComps)this.addComps.get(j);
                    String cName = obj.getInternalName();
                    String version = obj.getVersion();
                    OiiiCompInstallID ci = null;
                    if (version != null && version.length() > 0) {
                        ci = ((OiiiCompInvEntry)this.m_stageInv.getCompInvEntries(cName, new OiiiVersion(version), 0).elementAt(0)).getCompInstallID();
                    } else {
                        Vector cIEs = this.m_stageInv.getCompInvEntries(cName, 0);
                        for (int index = 0; index < cIEs.size() && (ci = ((OiiiCompInvEntry)cIEs.elementAt(index)).getCompInstallID()).getCompType() != 1; ++index) {
                        }
                    }
                    if (ci != null) {
                        obj.setCID(ci);
                    } else {
                        OiiolTextLogger.appendText("No Additional Component found for" + obj.getInternalName());
                    }
                    OiiolTextLogger.appendText("Building Comp Array For" + ci);
                    this.buildCompArray(ci, null, ci.getCompType(), true);
                }
            }
            catch (Exception j) {
                // empty catch block
            }
            if (this.m_bAutoOUI) {
                OiiiCompInstallID ci;
                this.m_autopatchCID = ci = ((OiiiCompInvEntry)this.m_stageInv.getCompInvEntries(S_OUI_NAME, 0).elementAt(0)).getCompInstallID();
                OiiolTextLogger.appendText("Building Comp Array For" + ci);
                this.buildCompArray(ci, null, ci.getCompType(), true);
            }
            if (!(this.m_instTimeSession instanceof OiicPullSession)) continue;
            ((OiicPullSession)this.m_instTimeSession).setAutoOUI(this.m_bAutoOUI);
            boolean addComps = this.addComps_size > 0;
            ((OiicPullSession)this.m_instTimeSession).setAdditionalComps(addComps);
        }
        this.sortCompNodes();
        if (bLookForAvailPatches) {
            this.getAvailablePatchesInStage();
        }
        return true;
    }

    public ArrayList getaddComps() {
        return this.addComps;
    }

    public void buildCompArray(OiiiCompInstallID comp, OiiodDepRuleNode oParentRule, int nExpectedType) throws OiiodDepException {
        this.buildCompArray(comp, oParentRule, nExpectedType, true);
    }

    public void buildCompArray(OiiiCompInstallID comp, OiiodDepRuleNode oParentRule, int nExpectedType, boolean bCompatible) throws OiiodDepException {
        int ohIndex = this.m_instTimeSession.getOHIndex();
        int appltopIndex = this.m_instTimeSession.getAppltopIndex();
        if (comp.isAppltopComponent()) {
            ohIndex = appltopIndex;
        }
        OiiiStageCompInvEntry oEntry = null;
        oEntry = bCompatible ? (OiiiStageCompInvEntry)this.m_stageInv.getCompatCompEntry(comp, 0, m_nCurPlatform, this.m_bIgnoreBuild) : this.m_stageInv.getStageCompInvEntry(comp);
        if (oEntry != null && nExpectedType != oEntry.getCompInstallID().getCompType()) {
            oEntry = null;
        }
        OiiodDepNode newDepNode = null;
        if (oEntry == null) {
            OiiiInstallCompInvEntry ie = (OiiiInstallCompInvEntry)this.m_installInv.getCompatCompEntry(comp, ohIndex, m_nCurPlatform, this.m_bIgnoreBuild);
            if (ie == null && comp.isNOHComp()) {
                OiiiCompInstallID checkID = null;
                checkID = comp.getCompType() == 2 ? new OiiiPatchInstallID(comp, comp.getVersion(), comp.getPlatforms(), false) : (comp.getCompType() == 4 ? new OiiiPatchSetInstallID(comp.getName(), comp.getVersion(), false) : new OiiiCompInstallID(comp.getName(), comp.getVersion(), comp.getPlatforms(), comp.getReplaceVersion(), comp.getCompType(), 2, comp.getReleaseLevel(), false));
                ie = (OiiiInstallCompInvEntry)this.m_installInv.getCompatCompEntry(checkID, ohIndex, m_nCurPlatform, this.m_bIgnoreBuild);
                if (ie == null && OiixOraparam.isApplTopStage()) {
                    checkID.setHomeType(3);
                    ie = (OiiiInstallCompInvEntry)this.m_installInv.getCompatCompEntry(checkID, appltopIndex, m_nCurPlatform, this.m_bIgnoreBuild);
                }
            }
            if (ie != null) {
                if (ie instanceof OiiiInstallPatchInvEntry) {
                    newDepNode = this.createNotInStagePatch((OiiiInstallPatchInvEntry)ie);
                    try {
                        newDepNode.addSelector(oParentRule);
                    }
                    catch (Exception exception) {}
                } else {
                    newDepNode = this.createNotInStageComp(ie);
                    if (oParentRule != null) {
                        oParentRule.addDepNode(newDepNode);
                        newDepNode.addParentRule(oParentRule);
                    }
                }
            }
        } else {
            if (this.m_progListener != null) {
                this.m_progListener.addBytes(1);
            }
            ++this.m_nCompsProcessed;
            comp = oEntry.getCompInstallID();
            switch (comp.getCompType()) {
                case 1: {
                    newDepNode = this.createComp(oEntry, oParentRule);
                    break;
                }
                case 2: {
                    newDepNode = this.createPatch((OiiiStagePatchInvEntry)oEntry, oParentRule);
                    break;
                }
                case 4: {
                    newDepNode = this.createPatchSet(oEntry, oParentRule);
                }
            }
        }
    }

    public OiiodDepNode createComp(OiiiStageCompInvEntry oEntry, OiiodDepRuleNode oParentRule) throws OiiodDepException {
        boolean bExtDep = false;
        OiiiCompInstallID comp = oEntry.getCompInstallID();
        OiiodDepNode newDepNode = new OiiodDepNode(oEntry);
        OiiodReplaceRangeComps oRepComp = this.addToReplaceRangeComp(newDepNode);
        this.m_compTable.put(comp, oRepComp);
        this.m_compNodes.addElement(newDepNode);
        if (newDepNode.isDownGrade() && oParentRule != null) {
            oParentRule.addDepNode(newDepNode);
            return newDepNode;
        }
        OiisDeps deps = null;
        if (oEntry.getDepInfo() == null) {
            OiisCompInstallation oCompInstall = this.m_instTimeSession.getCompInstall(comp);
            if (oCompInstall == null) {
                Object[] args = new Object[]{oEntry.getFullDisplayName()};
                throw new OiiodDepException(0, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_INSTALL_DEFN_CREATED", args));
            }
            deps = oCompInstall.getDepInfo().getDeps();
            oEntry.setDeps(deps);
        } else {
            deps = oEntry.getDepInfo().getDeps();
        }
        Vector depRules = deps.getDepRules();
        int nDepRuleSize = depRules.size();
        for (int i = 0; i < nDepRuleSize; ++i) {
            OiisDepRule depRule = (OiisDepRule)depRules.elementAt(i);
            OiiodDepRuleNode oRuleNode = new OiiodDepRuleNode(newDepNode, depRule);
            Vector depComps = depRule.getDepCompIds();
            Enumeration compsEn = depComps.elements();
            while (compsEn.hasMoreElements()) {
                OiiiCompInstallID depComp = (OiiiCompInstallID)compsEn.nextElement();
                OiiiCompInvEntry oDepEntry = this.m_stageInv.getCompatCompEntry(depComp, 0, m_nCurPlatform);
                if (oDepEntry != null) {
                    OiiiCompInstallID newdepComp = oDepEntry.getCompInstallID();
                    if (depComp.isExtDep()) {
                        String sDepHomeLoc = depComp.getDepHome();
                        depComp = newdepComp;
                        depComp.setExtDep(true);
                        depComp.setDepHome(sDepHomeLoc);
                        bExtDep = true;
                    } else {
                        depComp = oDepEntry.getCompInstallID();
                        bExtDep = false;
                    }
                }
                if (m_nCurPlatform != 0 && OiixVectorOps.vectIndexOf(depComp.getPlatforms(), (Object)new Integer(m_nCurPlatform)) == -1 || bExtDep) continue;
                int nIndex = OiixVectorOps.vectIndexOf(this.m_compNodes, (Object)depComp);
                if (nIndex == -1) {
                    this.buildCompArray(depComp, oRuleNode, depComp.getCompType(), true);
                    continue;
                }
                OiiodDepNode oNode = (OiiodDepNode)this.m_compNodes.elementAt(nIndex);
                oRuleNode.addDepNode(oNode);
                oNode.addParentRule(oRuleNode);
            }
            newDepNode.addRule(oRuleNode);
        }
        if (oParentRule != null) {
            oParentRule.addDepNode(newDepNode);
            newDepNode.addParentRule(oParentRule);
        }
        return newDepNode;
    }

    private OiiodDepPatchNode createPatch(OiiiStagePatchInvEntry oEntry, OiiodDepRuleNode oParentRule) throws OiiodDepException {
        OiiiPatchInstallID oPatchID = (OiiiPatchInstallID)oEntry.getCompInstallID();
        OiiodDepPatchNode oPatchNode = this.getDepPatchNode(oPatchID, this.m_bIgnoreBuild);
        OiiiCompInstallID oCompatBaseID = oPatchID.getCompInstallID();
        if (oPatchNode == null) {
            OiiiInstallCompInvEntry ie;
            OiiiCompInstallID oBaseCompID = oPatchID.getCompInstallID();
            OiiodDepNode oBaseNode = this.getDepCompatReplaceNode(oBaseCompID, oPatchID.getVersion());
            if (oBaseNode == null) {
                int ohIndex = this.m_instTimeSession.getOHIndex();
                ie = (OiiiInstallCompInvEntry)this.m_installInv.getCompatCompEntry(oBaseCompID, ohIndex, m_nCurPlatform, this.m_bIgnoreBuild);
                if (ie != null) {
                    if (oPatchID.getVersion().laterThan(ie.getCompInstallID().getVersion())) {
                        oCompatBaseID = ie.getCompInstallID();
                    }
                } else {
                    OiiiCompInvEntry sie = this.m_stageInv.getCompatCompEntry(oBaseCompID, 0, m_nCurPlatform, this.m_bIgnoreBuild);
                    if (sie != null && oPatchID.getVersion().laterThan(sie.getCompInstallID().getVersion())) {
                        oCompatBaseID = sie.getCompInstallID();
                    }
                }
                this.buildCompArray(oCompatBaseID, oParentRule, 1, false);
                oBaseNode = this.getDepNode(oCompatBaseID, true);
                oPatchID.setBaseVersion(oCompatBaseID.getVersion());
                oPatchID.setCompVersion(oCompatBaseID.getVersion());
            }
            if (oBaseNode != null) {
                oCompatBaseID = oBaseNode.getCompInstallID();
                oPatchID.setBaseVersion(oCompatBaseID.getVersion());
                oPatchID.setCompVersion(oCompatBaseID.getVersion());
                OiiodPatchesNode oPatchesNode = oBaseNode.getPatchesNode();
                oPatchNode = new OiiodDepPatchNode(oEntry, oPatchesNode);
                ie = (OiiiInstallCompInvEntry)this.m_installInv.getCompatCompEntry(oCompatBaseID, this.m_instTimeSession.getOHIndex(), m_nCurPlatform, true);
                oPatchNode.setInstalledVersion(ie);
                oPatchesNode.addPatchNode(oPatchNode);
                this.m_patchNodes.addElement(oPatchNode);
                OiisPatchDeps oDeps = oEntry.getPatchDeps();
                Vector vDeps = oDeps.getDepObjs();
                int nSize = vDeps.size();
                for (int i = 0; i < nSize; ++i) {
                    OiisPatchDepObj oPatchObj = (OiisPatchDepObj)vDeps.elementAt(i);
                    if (!oPatchObj.isVerUpgraded()) continue;
                    OiiiCompInstallID depId = oPatchObj.getCurDepId();
                    OiiiStageCompInvEntry oDepEntry = (OiiiStageCompInvEntry)this.m_stageInv.getCompatCompEntry(depId, 0, m_nCurPlatform, true);
                    OiiodDepPatchNode oDepPatch = null;
                    if (oDepEntry == null) {
                        OiiiInstallPatchInvEntry depIE = (OiiiInstallPatchInvEntry)this.m_installInv.getCompatCompEntry(depId, this.m_instTimeSession.getOHIndex(), m_nCurPlatform, true);
                        if (depIE != null) {
                            oDepPatch = this.createNotInStagePatch(depIE);
                        }
                    } else {
                        depId = oDepEntry.getCompInstallID();
                        try {
                            oPatchObj.setCurDepId(depId);
                        }
                        catch (Exception depIE) {
                            // empty catch block
                        }
                        if (depId.getCompType() == 2) {
                            oDepPatch = this.createPatch((OiiiStagePatchInvEntry)oDepEntry, null);
                        } else {
                            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PATCH_TO_COMP_DEP");
                            Object[] objs = new Object[]{oEntry.getFullDisplayName(), oDepEntry.getFullDisplayName()};
                            if (this.processError(sMsg = MessageFormat.format(sMsg, objs)) == -1) {
                                throw new OiiodDepException(0, sMsg);
                            }
                        }
                    }
                    if (oDepPatch == null) continue;
                    oPatchNode.addDependee(oDepPatch);
                    oDepPatch.addSelector(oPatchNode);
                }
            } else {
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_PATCH_NOT_ADDED1");
                Object[] obj = new Object[]{oEntry.getFullDisplayName()};
                sMsg = MessageFormat.format(sMsg, obj);
                this.processWarning(sMsg);
            }
        }
        if (oPatchNode != null) {
            OiiodDepNode oBaseNode = oPatchNode.getParentNode();
            if (oParentRule != null) {
                oBaseNode.addParentRule(oParentRule);
                oParentRule.addDepNode(oBaseNode);
                oPatchNode.addSelector(oParentRule);
            }
        }
        return oPatchNode;
    }

    public OiiodDepNode createPatchSet(OiiiStageCompInvEntry oEntry, OiiodDepRuleNode oParentRule) throws OiiodDepException {
        OiiiPatchSetInstallID oPatchSetID = (OiiiPatchSetInstallID)oEntry.getCompInstallID();
        OiisPatchSetInstallation oPSetInstall = this.m_instTimeSession.getPSetInstall(oPatchSetID);
        OiiodPatchSetNode newDepNode = new OiiodPatchSetNode(oEntry);
        OiiiCompInstallID comp = oEntry.getCompInstallID();
        OiiodReplaceRangeComps oRepComp = this.addToReplaceRangeComp(newDepNode);
        this.m_compTable.put(comp, oRepComp);
        this.m_patchSetNodes.addElement(newDepNode);
        if (oPSetInstall != null) {
            OiisPatchSetContents oPSetContents = oPSetInstall.getContents();
            if (oPSetContents == null) {
                return newDepNode;
            }
            Vector vPatches = oPSetContents.getContainedPatches();
            int nSize = vPatches.size();
            for (int i = 0; i < nSize; ++i) {
                OiiiStageCompInvEntry oPatchEntry;
                OiiiPatchInstallID pID = (OiiiPatchInstallID)vPatches.elementAt(i);
                this.buildCompArray(pID, oParentRule, pID.getCompType(), false);
                OiiodDepPatchNode oPatchNode = this.getDepPatchNode(pID, this.m_bIgnoreBuild);
                if (oPatchNode != null) {
                    newDepNode.addPatchNode(oPatchNode);
                    oPatchNode.addSelector(newDepNode);
                    continue;
                }
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEPPATCH_NOT_FOUND_IN_PSET");
                Object[] obj = new Object[]{pID.getName() + " " + pID.getVersion(), oEntry.getFullDisplayName()};
                sMsg = MessageFormat.format(sMsg, obj);
                if (OiiolTextLogger.getLogLevel() > OiiolTextLogger.LOG_BASIC) {
                    this.processWarning(sMsg);
                }
                if ((oPatchEntry = this.m_stageInv.getStageCompInvEntry((OiiiCompInstallID)pID, true)) != null && oPatchEntry.getCompInstallID().getCompType() != 2) {
                    oPatchEntry = null;
                }
                if (oPatchEntry != null) continue;
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEPPATCH_NOT_FOUND_IN_PSET_1");
                if (OiiolTextLogger.getLogLevel() <= OiiolTextLogger.LOG_BASIC) continue;
                this.processWarning(sMsg);
            }
        }
        return newDepNode;
    }

    private OiiodDepNode createNotInStageComp(OiiiInstallCompInvEntry ie) {
        OiiiCompInstallID comp = ie.getCompInstallID();
        OiiodDepNode newDepNode = new OiiodDepNode(ie);
        newDepNode.setInstalledVersion(ie);
        newDepNode.setNotInStage(true);
        this.m_compNodes.addElement(newDepNode);
        OiiodReplaceRangeComps oRepComp = this.addToReplaceRangeComp(newDepNode);
        this.m_compTable.put(comp, oRepComp);
        return newDepNode;
    }

    private OiiodDepPatchNode createNotInStagePatch(OiiiInstallCompInvEntry ie) {
        OiiodDepPatchNode newDepNode = new OiiodDepPatchNode(ie, null);
        newDepNode.setInstalledVersion(ie);
        newDepNode.setNotInStage(true);
        newDepNode.setCompStatus(5);
        this.m_patchNodes.addElement(newDepNode);
        return newDepNode;
    }

    public void getAvailablePatchesInStage() throws OiiodDepException {
        Vector vAllPatches = this.m_stageInv.getAllPatches(m_nCurPlatform);
        int nSize = vAllPatches.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiStagePatchInvEntry oEntry = (OiiiStagePatchInvEntry)vAllPatches.elementAt(i);
            OiiiPatchInstallID oPatchID = (OiiiPatchInstallID)oEntry.getCompInstallID();
            OiiiCompInstallID oCompID = oPatchID.getCompInstallID();
            OiiodDepNode oNode = this.getDepCompatReplaceNode(oCompID, oPatchID.getVersion());
            if (oNode == null) continue;
            this.createPatch(oEntry, null);
        }
    }

    public void sortCompNodes() throws OiiodDepException {
        int nSize = this.m_compNodes.size();
        if (nSize < 2) {
            return;
        }
        if (this.m_instTimeSession instanceof OiicInstallSession && this.m_stageInv.getCompsOrdered()) {
            this.matchStageInvOrder();
        } else {
            this.m_depsTable = new Hashtable(nSize);
            for (int i = 0; i < nSize; ++i) {
                OiiodDepNode oNode = (OiiodDepNode)this.m_compNodes.elementAt(i);
                this.getAllRecursiveDependeeNodes(oNode, this.m_depsTable);
            }
            this.m_compNodes = this.sortCompNodes(this.m_depsTable);
        }
    }

    private void matchStageInvOrder() {
        Vector<OiiodDepNode> vOrderedCompNodes = new Vector<OiiodDepNode>(this.m_compNodes.size());
        Vector vCompNodes = (Vector)this.m_compNodes.clone();
        Vector vInvEntries = this.m_stageInv.getAllCompsVect(0);
        int stgIdx = 0;
        int depIdx = 0;
        while (depIdx < vCompNodes.size() && stgIdx < vInvEntries.size()) {
            OiiiStageCompInvEntry invEntry;
            OiiodDepNode depNode = (OiiodDepNode)vCompNodes.elementAt(depIdx);
            if (depNode == null) {
                ++depIdx;
                continue;
            }
            if (depNode.isNotInStage()) {
                vOrderedCompNodes.addElement(depNode);
                vCompNodes.setElementAt(null, depIdx);
                ++depIdx;
                continue;
            }
            OiiiCompInstallID cid = depNode.getCompInstallID();
            if (cid.equals((invEntry = (OiiiStageCompInvEntry)vInvEntries.elementAt(stgIdx)).getCompInstallID(), this.m_bIgnoreBuild)) {
                vOrderedCompNodes.addElement(depNode);
                vCompNodes.setElementAt(null, depIdx);
                ++stgIdx;
                ++depIdx;
                continue;
            }
            OiiiCompInstallID stageCompID = invEntry.getCompInstallID();
            int idx = OiixVectorOps.vectIndexOf(vCompNodes, (Object)stageCompID, depIdx);
            if (idx != -1) {
                OiiodDepNode stageDepNode = (OiiodDepNode)vCompNodes.elementAt(idx);
                vOrderedCompNodes.addElement(stageDepNode);
                vCompNodes.setElementAt(null, idx);
            }
            ++stgIdx;
        }
        if (vOrderedCompNodes.size() < vCompNodes.size()) {
            for (int j = vOrderedCompNodes.size(); j < vCompNodes.size(); ++j) {
                OiiodDepNode depNode = (OiiodDepNode)vCompNodes.elementAt(j);
                if (depNode == null) continue;
                vOrderedCompNodes.addElement((OiiodDepNode)vCompNodes.elementAt(j));
            }
        }
        this.m_compNodes = vOrderedCompNodes;
    }

    private Vector sortCompNodes(Hashtable depsVals) throws OiiodDepException {
        int i;
        int vectSize = this.m_compNodes.size();
        Vector<OiiodDepNode> retLst = (Vector<OiiodDepNode>)this.m_compNodes.clone();
        for (int i2 = 0; i2 < vectSize - 1; ++i2) {
            for (int j = i2 + 1; j < vectSize; ++j) {
                OiiodDepNode aNode = (OiiodDepNode)retLst.elementAt(i2);
                OiiodDepNode bNode = (OiiodDepNode)retLst.elementAt(j);
                Vector deps = (Vector)depsVals.get(bNode);
                if (!this.isCompatibleNodeInList(deps, aNode)) continue;
                retLst.setElementAt(bNode, i2);
                retLst.setElementAt(aNode, j);
                deps = (Vector)depsVals.get(aNode);
                if (!this.isCompatibleNodeInList(deps, bNode)) continue;
                String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_CIRCULAR_DEP");
                Object[] sArr = new String[]{aNode.toString()};
                throw new OiiodDepException(2, MessageFormat.format(sErr, sArr));
            }
        }
        Vector<OiiodDepNode> vNodes = new Vector<OiiodDepNode>(retLst.size());
        Vector<OiiodDepNode> vJDK = new Vector<OiiodDepNode>();
        Vector<OiiodDepNode> vJRE = new Vector<OiiodDepNode>();
        Vector<OiiodDepNode> vJrockit = new Vector<OiiodDepNode>();
        OiiodDepNode[] oOUICompNodes = new OiiodDepNode[4];
        for (i = 0; i < retLst.size(); ++i) {
            OiiodDepNode depNode = (OiiodDepNode)retLst.elementAt(i);
            OiiiCompInstallID cid = depNode.getCompInstallID();
            if (cid.getName().toLowerCase().equals(S_OUI_NAME)) {
                oOUICompNodes[0] = depNode;
                continue;
            }
            if (cid.getName().toLowerCase().equals(S_OUI_OPATCH_NAME)) {
                oOUICompNodes[1] = depNode;
                continue;
            }
            if (cid.getName().toLowerCase().equals(S_OUI_CORE_NAME)) {
                oOUICompNodes[2] = depNode;
                continue;
            }
            if (cid.getName().toLowerCase().equals(S_OUI_CORE_MIN_NAME)) {
                oOUICompNodes[3] = depNode;
                continue;
            }
            if (cid.getName().toLowerCase().equals(S_JRE_NAME)) {
                vJRE.add(depNode);
                continue;
            }
            if (cid.getName().toLowerCase().equals(S_JROCKIT_NAME)) {
                vJrockit.add(depNode);
                continue;
            }
            String compname = cid.getName().toLowerCase();
            if (S_JDK_NAME.equals(compname)) {
                vJDK.insertElementAt(depNode, 0);
            }
            if (JDK_JRE_NAME.equals(compname)) {
                vJDK.insertElementAt(depNode, 1);
                continue;
            }
            if (S_JDK_J2EE_CORE_NAME.equals(compname)) {
                vJDK.addElement(depNode);
                continue;
            }
            vNodes.addElement(depNode);
        }
        for (i = 0; i < oOUICompNodes.length; ++i) {
            if (oOUICompNodes[i] == null) continue;
            vNodes.addElement(oOUICompNodes[i]);
        }
        if (vJRE.size() > 0) {
            vNodes.addAll(vJRE);
        }
        if (vJrockit.size() > 0) {
            vNodes.addAll(vJrockit);
        }
        for (i = 0; i < vJDK.size(); ++i) {
            vNodes.addElement((OiiodDepNode)vJDK.elementAt(i));
        }
        retLst = vNodes;
        return retLst;
    }

    private Vector getAllRecursiveDependeeNodes(OiiodDepNode oNode, Hashtable depsTable) {
        Vector<OiiodDepNode> recDepsHere = (Vector<OiiodDepNode>)depsTable.get(oNode);
        if (recDepsHere == null) {
            recDepsHere = new Vector<OiiodDepNode>();
            depsTable.put(oNode, recDepsHere);
            Vector depsHere = oNode.getCurrentDeps();
            int numDeps = depsHere.size();
            for (int i = 0; i < numDeps; ++i) {
                OiiodDepNode depNode = (OiiodDepNode)depsHere.elementAt(i);
                if (recDepsHere.contains(depNode)) continue;
                recDepsHere.addElement(depNode);
                Vector depRecDeps = (Vector)depsTable.get(depNode);
                if (depRecDeps == null) {
                    depRecDeps = this.getAllRecursiveDependeeNodes(depNode, depsTable);
                }
                OiixVectorOps.unionInPlace(recDepsHere, depRecDeps);
            }
        }
        return recDepsHere;
    }

    private boolean isCompatibleNodeInList(Vector vList, OiiodDepNode oSearchNode) {
        boolean bFound = false;
        int nSize = vList.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepNode oNode = (OiiodDepNode)vList.elementAt(i);
            OiiiCompInstallID oSearchID = oSearchNode.getCompInstallID();
            OiiiCompInstallID oNodeID = oNode.getCompInstallID();
            if (!oNodeID.isCompatible(oSearchID) && !oSearchID.isCompatible(oNodeID)) continue;
            bFound = true;
            break;
        }
        return bFound;
    }

    public Vector getOrderedComps() {
        OiiodDepNode oNode;
        int i;
        Vector<OiiiCompInstallID> vCompIds = new Vector<OiiiCompInstallID>();
        Vector v = this.getDepNodes();
        int nSize = v.size();
        for (i = 0; i < nSize; ++i) {
            oNode = (OiiodDepNode)v.elementAt(i);
            OiiodPatchesNode oPatches = oNode.getPatchesNode();
            Vector vChildren = oPatches.getAllPatches();
            int nChild = vChildren.size();
            for (int j = 0; j < nChild; ++j) {
                OiiodDepNode oPatch = (OiiodDepNode)vChildren.elementAt(j);
                vCompIds.addElement(oPatch.getCompInstallID());
            }
            vCompIds.addElement(oNode.getCompInstallID());
        }
        nSize = this.m_patchSetNodes.size();
        for (i = 0; i < nSize; ++i) {
            oNode = (OiiodDepNode)this.m_patchSetNodes.elementAt(i);
            vCompIds.insertElementAt(oNode.getCompInstallID(), 0);
        }
        return vCompIds;
    }

    public OiiodDepNode getDepNode(OiiiCompInstallID id, boolean bIgnoreBuild) {
        OiiodDepNode oDepNode = null;
        int iCompNodes = this.m_compNodes.size();
        for (int i = 0; i < iCompNodes; ++i) {
            oDepNode = (OiiodDepNode)this.m_compNodes.elementAt(i);
            if (!oDepNode.equals(id, bIgnoreBuild)) continue;
            return oDepNode;
        }
        return null;
    }

    public OiiodDepNode getDepCompatNode(OiiiCompInstallID id) {
        OiiodDepNode oDepNode = null;
        int iCompNodes = this.m_compNodes.size();
        for (int i = 0; i < iCompNodes; ++i) {
            oDepNode = (OiiodDepNode)this.m_compNodes.elementAt(i);
            OiiiCompInstallID oid = null;
            Object oIDInstall = null;
            OiiiStageCompInvEntry osEntry = oDepNode.getStageInvEntry();
            OiiiInstallCompInvEntry oiEntry = oDepNode.getInstallInvEntry();
            if (oiEntry != null) {
                oid = oiEntry.getCompInstallID();
            }
            if (oid != null && oid.equals(id)) {
                return oDepNode;
            }
            if (osEntry != null) {
                oid = osEntry.getCompInstallID();
            }
            if (oid == null || !oid.equals(id)) continue;
            return oDepNode;
        }
        return null;
    }

    private OiiodDepNode getDepCompatReplaceNode(OiiiCompInstallID id, OiiiVersion ver) {
        OiiodDepNode oDepNode = null;
        int iCompNodes = this.m_compNodes.size();
        for (int i = 0; i < iCompNodes; ++i) {
            oDepNode = (OiiodDepNode)this.m_compNodes.elementAt(i);
            OiiiCompInstallID oid = null;
            Object oIDInstall = null;
            OiiiStageCompInvEntry osEntry = oDepNode.getStageInvEntry();
            OiiiInstallCompInvEntry oiEntry = oDepNode.getInstallInvEntry();
            if (oiEntry != null) {
                oid = oiEntry.getCompInstallID();
            }
            if (oid != null && oid.isCompatible(id) && ver.laterThan(oid.getVersion())) {
                return oDepNode;
            }
            if (osEntry != null) {
                oid = osEntry.getCompInstallID();
            }
            if (oid == null || !oid.isCompatible(id) || !ver.laterThan(oid.getVersion())) continue;
            return oDepNode;
        }
        return null;
    }

    public OiiodDepNode getDepNode(OiiiCompInstallID id) {
        return this.getDepNode(id, true);
    }

    public OiiodDepPatchNode getDepPatchNode(OiiiCompInstallID id) {
        return this.getDepPatchNode(id, true);
    }

    public OiiodDepPatchNode getDepPatchNode(OiiiCompInstallID id, boolean bIgnoreBuild) {
        OiiodDepPatchNode oDepNode = null;
        int iCompNodes = this.m_patchNodes.size();
        for (int i = 0; i < iCompNodes; ++i) {
            oDepNode = (OiiodDepPatchNode)this.m_patchNodes.elementAt(i);
            if (!oDepNode.equals(id, bIgnoreBuild)) continue;
            return oDepNode;
        }
        return null;
    }

    public OiiodPatchSetNode getPatchSetNode(OiiiCompInstallID id) {
        return this.getPatchSetNode(id, true);
    }

    public OiiodPatchSetNode getPatchSetNode(OiiiCompInstallID id, boolean bIgnoreBuild) {
        OiiodPatchSetNode oDepNode = null;
        int iCompNodes = this.m_patchSetNodes.size();
        for (int i = 0; i < iCompNodes; ++i) {
            oDepNode = (OiiodPatchSetNode)this.m_patchSetNodes.elementAt(i);
            if (!oDepNode.equals(id, bIgnoreBuild)) continue;
            return oDepNode;
        }
        return null;
    }

    public void undoAllDepModeApply() {
        int nSize = this.m_compNodes.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepNode depNode = (OiiodDepNode)this.m_compNodes.elementAt(i);
            if (depNode.isNotInStage()) continue;
            depNode.resetAll();
        }
        this.m_installCompIds = new Vector();
        this.m_deinstallCompIds = new Vector();
        this.m_deinstallOneoffIdOhs = new Vector();
        this.m_oConflictingOneOffIdMap = new HashMap();
    }

    public void resetAllPreReqFlag() {
        Vector vComps = this.m_instSession.getCompInstallVector();
        int nSize = vComps.size();
        for (int i = 0; i < nSize; ++i) {
            OiisCompInstallation ci = (OiisCompInstallation)vComps.elementAt(i);
            ci.setComputePreReq(true);
        }
    }

    public void depModeApply(boolean bConfirm) throws OiiodDepException, OiifbCancelException {
        int i;
        OiiodDepNode oNode;
        OiiodAdditionalComps obj;
        int i2;
        Object[] args;
        OiisCompInstallation oCompInstall;
        int i3;
        long lTime = 0L;
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        if (this.m_instTimeSession.getSessionContext() != null) {
            this.m_instTimeSession.getSessionContext();
            this.m_bResponseFileUsed = OiicSessionContext.isResponseFileUsed();
        }
        this.m_progListener = null;
        this.m_aOneOrMoreDepNodesToProcess = new ArrayList();
        if (this.m_instSession != null) {
            int nComps = this.m_stageInv.getAllCompsVect(0).size();
            OiixProgressListener progListener = this.m_instSession.getProgressListener();
            if (progListener != null) {
                progListener.setTotalBytes(nComps * 6);
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_PROG_MSG");
                progListener.setStatus(sMsg);
                progListener.setTitle(sMsg);
                progListener.addBytes(this.m_nCompsProcessed);
                this.m_progListener = progListener;
            }
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("OiiodDepEngine, Build Comp Tree ", System.currentTimeMillis() - lTime);
        }
        if (this.m_progListener != null) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_IT_PROG_MSG");
            this.m_progListener.setStatus(sMsg);
        }
        this.undoAllDepModeApply();
        if (this.m_instSession != null) {
            this.resetAllPreReqFlag();
        }
        int numTLComps = this.m_tlSelCompIDs.length;
        OiiodDepNode[] depNodes = new OiiodDepNode[numTLComps];
        OiiodDepNode depNodesAutoPatch = null;
        OiiodDepNode depNodesAutoPatch_ac = null;
        OiisStagedCompRep autoCompInstall = null;
        OiisStagedCompRep autoCompInstall_ac = null;
        OiisDepInfo autoDepInfo = null;
        OiisDepInfo autoDepInfo_ac = null;
        OiiodTopLevelSelector autopatchTopSelector = null;
        OiiodTopLevelSelector autopatchTopSelector_ac = null;
        for (i3 = 0; i3 < numTLComps; ++i3) {
            OiiiCompInstallID cid = this.m_tlSelCompIDs[i3];
            depNodes[i3] = this.getDepNode(cid);
            if (cid.getCompType() == 4) {
                depNodes[i3] = this.getPatchSetNode(cid);
                continue;
            }
            if (cid.getCompType() == 2) {
                depNodes[i3] = this.getDepPatchNode(cid);
                continue;
            }
            oCompInstall = this.m_instTimeSession.getCompInstall(depNodes[i3].getCompInstallID());
            if (oCompInstall == null) {
                args = new Object[]{depNodes[i3].getDisplayName()};
                throw new OiiodDepException(0, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_INSTALL_DEFN_CREATED", args));
            }
            OiisDepInfo depInfo = oCompInstall.getDepInfo();
            depNodes[i3].setInstallType(depInfo.getDepMode());
        }
        for (i3 = 0; i3 < this.addComps_size; ++i3) {
            OiiodAdditionalComps obj2 = (OiiodAdditionalComps)this.addComps.get(i3);
            OiiiCompInstallID CID = obj2.getCID();
            depNodesAutoPatch_ac = this.getDepNode(CID);
            obj2.setDepNode(depNodesAutoPatch_ac);
            if (depNodesAutoPatch_ac != null) {
                autoCompInstall_ac = this.m_instTimeSession.getCompInstall(depNodesAutoPatch_ac.getCompInstallID());
            }
            if (autoCompInstall_ac == null) {
                args = new Object[]{depNodesAutoPatch_ac.getDisplayName()};
                throw new OiiodDepException(0, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_INSTALL_DEFN_CREATED", args));
            }
            autoDepInfo_ac = autoCompInstall_ac.getDepInfo();
            if (autoDepInfo_ac == null) continue;
            depNodesAutoPatch_ac.setInstallType(autoDepInfo_ac.getDepMode());
        }
        if (this.m_bAutoOUI) {
            depNodesAutoPatch = this.getDepNode(this.m_autopatchCID);
            if (depNodesAutoPatch != null) {
                autoCompInstall = this.m_instTimeSession.getCompInstall(depNodesAutoPatch.getCompInstallID());
            }
            if (autoCompInstall == null) {
                Object[] args2 = new Object[]{depNodesAutoPatch.getDisplayName()};
                throw new OiiodDepException(0, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_INSTALL_DEFN_CREATED", args2));
            }
            autoDepInfo = autoCompInstall.getDepInfo();
            if (autoDepInfo != null) {
                depNodesAutoPatch.setInstallType(autoDepInfo.getDepMode());
            }
        }
        this.depModeTimer = new OiiodTimer();
        int nSize = this.m_compNodes.size();
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        for (i2 = 0; i2 < this.addComps_size; ++i2) {
            obj = (OiiodAdditionalComps)this.addComps.get(i2);
            OiiodDepNode oNode2 = obj.getDepNode();
            oNode2.setSelectedAtDepModeApply(true);
        }
        for (i2 = 0; i2 < nSize; ++i2) {
            oNode = (OiiodDepNode)this.m_compNodes.elementAt(i2);
            if (this.m_progListener != null) {
                this.m_progListener.addBytes(1);
            }
            this.depModeApply(oNode);
        }
        this.processOneOrMoreDeps();
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("DepEngine DepModeApply ", System.currentTimeMillis() - lTime);
        }
        this.m_bMoreQs = false;
        this.applySelectionTimer = new OiiodTimer();
        block11: for (i2 = 0; i2 < numTLComps; ++i2) {
            if (this.m_tlSelCompIDs[i2].getCompType() == 4 || this.m_tlSelCompIDs[i2].getCompType() == 2) continue;
            oCompInstall = this.m_instTimeSession.getCompInstall(this.m_tlSelCompIDs[i2]);
            int nPreReq = this.checkPreReq(oCompInstall);
            switch (nPreReq) {
                case 1: {
                    String sMsg = this.getPreReqErrorMessage(this.m_tlSelCompIDs[i2]);
                    if (this.m_instTimeSession.getSessionContext().ignorePreReqCheck()) {
                        OiiodDepEngine.logText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_IGNORE_PREREQ_FAIL"));
                        continue block11;
                    }
                    this.m_progListener = null;
                    throw new OiiodDepException(0, sMsg);
                }
            }
        }
        if (this.m_progListener != null) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PREREQ_PROG_MSG");
            this.m_progListener.setStatus(sMsg);
        }
        this.m_selCompsVect = new Vector();
        this.m_topLevelSelectors = new Vector();
        if (this.m_instTimeSession instanceof OiicInstallSession) {
            OiicInstallSession oSession = (OiicInstallSession)this.m_instTimeSession;
            oSession.resetInstalledTLComps();
        }
        for (i = 0; i < numTLComps; ++i) {
            OiiodDepNode parent = depNodes[i];
            OiiodTopLevelSelector oTopSelector = new OiiodTopLevelSelector(parent, null);
            parent.addSelector(oTopSelector);
            if (this.isDowngrade(parent)) {
                parent.setCompStatus(5);
            } else {
                parent.setCompStatus(0);
            }
            this.m_selCompsVect.addElement(parent);
            this.m_topLevelSelectors.addElement(oTopSelector);
            Vector depRules = parent.getRules();
            oTopSelector.setRuleNodes(depRules);
        }
        block13: for (i = 0; i < this.addComps_size; ++i) {
            obj = (OiiodAdditionalComps)this.addComps.get(i);
            depNodesAutoPatch_ac = obj.getDepNode();
            autopatchTopSelector_ac = new OiiodTopLevelSelector(depNodesAutoPatch_ac, null);
            if (autopatchTopSelector_ac == null || depNodesAutoPatch_ac == null) continue;
            OiisCompInstallation oCompInstall2 = this.m_instTimeSession.getCompInstall(obj.getCID());
            int nPreReq = this.checkPreReq(oCompInstall2);
            switch (nPreReq) {
                case 1: {
                    String sMsg = this.getPreReqErrorMessage(obj.getCID());
                    if (this.m_instTimeSession.getSessionContext().ignorePreReqCheck()) {
                        OiiodDepEngine.logText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_IGNORE_PREREQ_FAIL"));
                        continue block13;
                    }
                    this.m_progListener = null;
                    throw new OiiodDepException(0, sMsg);
                }
                case 2: 
                case 3: {
                    continue block13;
                }
                default: {
                    depNodesAutoPatch_ac.addSelector(autopatchTopSelector_ac);
                    depNodesAutoPatch_ac.setCompStatus(0);
                    this.m_selCompsVect.addElement(depNodesAutoPatch_ac);
                    this.m_topLevelSelectors.addElement(autopatchTopSelector_ac);
                    Vector autodepRules = depNodesAutoPatch_ac.getRules();
                    autopatchTopSelector_ac.setRuleNodes(autodepRules);
                }
            }
        }
        if (this.m_bAutoOUI && (autopatchTopSelector = new OiiodTopLevelSelector(depNodesAutoPatch, null)) != null && depNodesAutoPatch != null) {
            depNodesAutoPatch.addSelector(autopatchTopSelector);
            depNodesAutoPatch.setCompStatus(0);
            this.m_selCompsVect.addElement(depNodesAutoPatch);
            this.m_topLevelSelectors.addElement(autopatchTopSelector);
            Vector autodepRules = depNodesAutoPatch.getRules();
            autopatchTopSelector.setRuleNodes(autodepRules);
        }
        if (OiixDebug.PRINT_TIME) {
            lTime = System.currentTimeMillis();
        }
        for (int i4 = 0; i4 < nSize; ++i4) {
            oNode = (OiiodDepNode)this.m_compNodes.elementAt(i4);
            if (this.m_progListener != null) {
                this.m_progListener.addBytes(1);
            }
            this.applySelection(oNode);
        }
        if (OiixDebug.PRINT_TIME) {
            OiixDebug.printTimeMsg("DepEngine ApplySelection ", System.currentTimeMillis() - lTime);
        }
        if (this.m_progListener != null && !OiicInstallSession.isSilentMode()) {
            this.m_progListener.onDoneProgress();
        }
        this.m_progListener = null;
    }

    public void depModeApply(OiiodDepNode depNode) throws OiiodDepException {
        if (depNode.isDownGrade() || depNode.isNotInStage()) {
            return;
        }
        OiisDepMode oDepMode = depNode.getInstallType();
        if (oDepMode == null) {
            return;
        }
        OiiiStageCompInvEntry oNodeEntry = depNode.getStageInvEntry();
        OiisDepMode depMode = oDepMode;
        OiisDeps deps = oNodeEntry.getDeps();
        oNodeEntry.setDepModeName(depMode.getInternalName());
        this.depModeTimer.start();
        Object[] args = new String[]{oNodeEntry.getFullDisplayName(), depMode.getName()};
        String sLogMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_LOG_COMP_INSTALL_TYPE");
        sLogMsg = MessageFormat.format(sLogMsg, args);
        OiiodDepEngine.logText(sLogMsg);
        this.depModeTimer.stop();
        Vector depRuleProps = oDepMode.getDepRuleProps();
        Enumeration depPropEn = depRuleProps.elements();
        while (depPropEn.hasMoreElements()) {
            OiisDepRuleProperty depRuleProp = (OiisDepRuleProperty)depPropEn.nextElement();
            Vector depRuleComps = depRuleProp.getDepRuleComps();
            this.selectCompsFromRule(depRuleComps, depNode, oNodeEntry, depRuleProp);
        }
    }

    private void selectCompsFromRule(Vector depRuleComps, OiiodDepNode depNode, OiiiStageCompInvEntry oNodeEntry, OiisDepRuleProperty depRuleProp) throws OiiodDepException {
        Vector<OiisDepRuleComp> notInInvSelectedOneOrMoreComps = null;
        Vector<OiisDepRuleComp> inInvSelectedOneOrMoreComps = null;
        Vector<OiisDepRuleComp> inInvNonSelectedOneOrMoreComps = null;
        Vector<String> selectedOneOrMoreCompsMsgs = null;
        Vector<String> nonSelectedOneOrMoreCompMsgs = null;
        OiisDeps deps = oNodeEntry.getDeps();
        OiisDepRule propRule = deps.getDepRule(depRuleProp.getRuleName());
        if (propRule.getType() == 1) {
            notInInvSelectedOneOrMoreComps = new Vector<OiisDepRuleComp>();
            inInvSelectedOneOrMoreComps = new Vector<OiisDepRuleComp>();
            inInvNonSelectedOneOrMoreComps = new Vector<OiisDepRuleComp>();
            selectedOneOrMoreCompsMsgs = new Vector<String>();
            nonSelectedOneOrMoreCompMsgs = new Vector<String>();
        }
        Enumeration depCompEn = depRuleComps.elements();
        while (depCompEn.hasMoreElements()) {
            OiiodDepNode deeNode;
            OiisDepRuleComp depRuleComp = (OiisDepRuleComp)depCompEn.nextElement();
            OiiiCompInstallID dependee = depRuleComp.getComp();
            if (this.canSkipDependeeBasedOnPlats(dependee, null)) continue;
            OiiiCompInvEntry oDepEntry = this.m_stageInv.getCompatCompEntry(dependee, 0, m_nCurPlatform);
            if (oDepEntry == null) {
                oDepEntry = this.m_stageInv.getCompatCompEntry(dependee, 0, m_nCurPlatform, true, true);
            }
            if (oDepEntry != null) {
                dependee = oDepEntry.getCompInstallID();
                if (dependee.getCompType() == 2) {
                    OiiiPatchInstallID pid = (OiiiPatchInstallID)dependee;
                    dependee = pid.getCompInstallID();
                    oDepEntry = this.m_stageInv.getCompatCompEntry(dependee, 0, m_nCurPlatform);
                }
                if (!this.m_bReadOnly) {
                    depRuleComp.setComp(dependee);
                }
            }
            if (oDepEntry == null) {
                int nOhIndex = this.m_instTimeSession.getOHIndex();
                if (this.m_instTimeSession instanceof OiicInstallSession) {
                    nOhIndex = ((OiicInstallSession)this.m_instTimeSession).getHomeIndex(dependee);
                }
                if ((oDepEntry = this.m_installInv.getCompatCompEntry(dependee, nOhIndex, m_nCurPlatform)) != null) {
                    dependee = oDepEntry.getCompInstallID();
                    if (!this.m_bReadOnly) {
                        depRuleComp.setComp(dependee);
                    }
                }
            }
            if ((deeNode = this.getDepNode(dependee)) == null) {
                if (this.canSkipDependeeBasedOnPlats(dependee, oNodeEntry)) continue;
                String sMsg = null;
                Object[] objs = new String[]{depNode.toString(), dependee.getName() + " " + dependee.getVersion()};
                sMsg = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_NOT_FOUND"), objs);
                if (propRule.getType() != 0) {
                    if (propRule.getType() == 1) {
                        if (depRuleComp.getSelected()) {
                            notInInvSelectedOneOrMoreComps.addElement(depRuleComp);
                            sMsg = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_SELECTED_ONE_OR_MORE_NOT_FOUND"), objs);
                            selectedOneOrMoreCompsMsgs.addElement(sMsg);
                            continue;
                        }
                        sMsg = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_NONSELECTED_ONE_OR_MORE_NOT_FOUND"), objs);
                        nonSelectedOneOrMoreCompMsgs.addElement(sMsg);
                        continue;
                    }
                    if (depRuleProp.shouldAsk() || depRuleComp.getSelected()) {
                        if (this.processError(sMsg) != -1) continue;
                        throw new OiiodDepException(0, sMsg);
                    }
                    this.processWarning(sMsg);
                    continue;
                }
                this.processWarning(sMsg);
                continue;
            }
            if (!deeNode.isNotInStage() && (depRuleProp.shouldAsk() || depRuleComp.getSelected())) {
                OiiiStageCompInvEntry oDepInvEntry;
                OiisDepInfo dInfo;
                OiisDepMode deeDepMode;
                if (depRuleComp.getSelected()) {
                    deeNode.setSelectedAtDepModeApply(true);
                }
                if ((deeDepMode = (dInfo = (oDepInvEntry = deeNode.getStageInvEntry()).getDepInfo()).getDepMode(depRuleComp.getDepModeName())) == null) {
                    deeDepMode = dInfo.getDepMode("Custom");
                }
                deeNode.setInstallType(deeDepMode);
            }
            if (propRule.getType() != 1) continue;
            if (depRuleComp.getSelected()) {
                inInvSelectedOneOrMoreComps.addElement(depRuleComp);
                continue;
            }
            inInvNonSelectedOneOrMoreComps.addElement(depRuleComp);
        }
        if (propRule.getType() == 1) {
            this.addToUnProcessedOneOrMoreDepNodeInfo(depNode, notInInvSelectedOneOrMoreComps, inInvSelectedOneOrMoreComps, inInvNonSelectedOneOrMoreComps, selectedOneOrMoreCompsMsgs, nonSelectedOneOrMoreCompMsgs);
        }
    }

    private void addToUnProcessedOneOrMoreDepNodeInfo(OiiodDepNode oNode, Vector notInInvSelectedOneOrMoreComps, Vector inInvSelectedOneOrMoreComps, Vector inInvNonSelectedOneOrMoreComps, Vector selectedOneOrMoreCompsMsgs, Vector nonSelectedOneOrMoreCompMsgs) {
        OiiodOneorMoreDepNodeInfo oInfo = new OiiodOneorMoreDepNodeInfo(oNode, notInInvSelectedOneOrMoreComps, inInvSelectedOneOrMoreComps, inInvNonSelectedOneOrMoreComps, selectedOneOrMoreCompsMsgs, nonSelectedOneOrMoreCompMsgs);
        this.m_aOneOrMoreDepNodesToProcess.add(oInfo);
    }

    private void processOneOrMoreDeps() throws OiiodDepException {
        int iSize = this.m_aOneOrMoreDepNodesToProcess.size();
        if (iSize > 0) {
            for (int i = 0; i < iSize; ++i) {
                OiiodOneorMoreDepNodeInfo oInfo = (OiiodOneorMoreDepNodeInfo)this.m_aOneOrMoreDepNodesToProcess.get(i);
                this.processOneOrMoreDeps(oInfo);
            }
        }
    }

    private void processOneOrMoreDeps(OiiodOneorMoreDepNodeInfo oInfo) throws OiiodDepException {
        Vector notInInvSelectedOneOrMoreComps = oInfo._notInInvSelectedOneOrMoreComps;
        Vector inInvSelectedOneOrMoreComps = oInfo._inInvSelectedOneOrMoreComps;
        Vector inInvNonSelectedOneOrMoreComps = oInfo._inInvNonSelectedOneOrMoreComps;
        Vector selectedOneOrMoreCompsMsgs = oInfo._selectedOneOrMoreCompsMsgs;
        Vector nonSelectedOneOrMoreCompMsgs = oInfo._nonSelectedOneOrMoreCompMsgs;
        int nSelectedNotInInv = notInInvSelectedOneOrMoreComps.size();
        int nSelectedInInv = inInvSelectedOneOrMoreComps.size();
        int nNonSelected = inInvNonSelectedOneOrMoreComps.size();
        String sWarning = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_SELECTED_ONE_OR_MORE_NOT_FOUND_WARNING");
        String sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_SELECTED_ONE_OR_MORE_NOT_FOUND_ERROR");
        if (nSelectedInInv > 0) {
            String sMsg;
            for (int j = 0; j < selectedOneOrMoreCompsMsgs.size(); ++j) {
                sMsg = (String)selectedOneOrMoreCompsMsgs.elementAt(j);
                this.processWarning(sMsg + sWarning);
            }
            for (int k = 0; k < nonSelectedOneOrMoreCompMsgs.size(); ++k) {
                sMsg = (String)nonSelectedOneOrMoreCompMsgs.elementAt(k);
                this.processWarning(sMsg);
            }
            return;
        }
        if (nSelectedNotInInv > 0 && nNonSelected == 0) {
            for (int j = 0; j < selectedOneOrMoreCompsMsgs.size(); ++j) {
                String sMsg = (String)selectedOneOrMoreCompsMsgs.elementAt(j) + sError;
                if (this.processError(sMsg) != -1) continue;
                throw new OiiodDepException(0, sMsg);
            }
            return;
        }
        if (nNonSelected > 0) {
            String sMsg;
            boolean bChecked = false;
            int nCheckedIndex = -1;
            for (int l = 0; l < nNonSelected; ++l) {
                OiisDepRuleComp oDepRuleComp = (OiisDepRuleComp)inInvNonSelectedOneOrMoreComps.elementAt(l);
                OiiodDepNode oDepNode = this.getDepNode(oDepRuleComp.getComp());
                if (!oDepRuleComp.getSelected() && (oDepNode == null || !oDepNode.isSelected() && !oDepNode.isSelectedAtDepModeApply())) continue;
                bChecked = true;
                nCheckedIndex = l;
                break;
            }
            if (!bChecked) {
                OiisDepRuleComp oDepRuleComp = (OiisDepRuleComp)inInvNonSelectedOneOrMoreComps.elementAt(0);
                if (!this.m_bReadOnly) {
                    oDepRuleComp.setSelected(true);
                } else {
                    OiiodDepNode odn = this.getDepNode(oDepRuleComp.getComp());
                    if (odn != null) {
                        this.m_vReadOnlySelectedCompNodes.addElement(odn);
                    } else {
                        String sMsg2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NULL_DEPNODE");
                        Object[] args = new String[]{oDepRuleComp.getComp().getName()};
                        sMsg2 = MessageFormat.format(sMsg2, args);
                        this.processWarning(sMsg2);
                    }
                }
            }
            for (int j = 0; j < selectedOneOrMoreCompsMsgs.size(); ++j) {
                sMsg = (String)selectedOneOrMoreCompsMsgs.elementAt(j);
                this.processWarning(sMsg);
            }
            for (int k = 0; k < nonSelectedOneOrMoreCompMsgs.size(); ++k) {
                if (k == nCheckedIndex) continue;
                sMsg = (String)nonSelectedOneOrMoreCompMsgs.elementAt(k);
                this.processWarning(sMsg);
            }
            return;
        }
    }

    private boolean canSkipDependeeBasedOnPlats(OiiiCompInstallID dependee, OiiiStageCompInvEntry oNodeEntry) {
        if (m_nCurPlatform != 0 && !OiixPlatform.platInVector(dependee.getPlatforms(), m_nCurPlatform)) {
            return true;
        }
        return oNodeEntry != null && m_nCurPlatform == 0 && !OiixVectorOps.checkIntersection(dependee.getPlatforms(), oNodeEntry.getPlatforms());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applySelection(OiiodDepNode oNode) throws OiiodDepException, OiifbCancelException {
        OiiiInstallCompInvEntry oInstEntry;
        OiiodPatchesNode oPatchesNode = oNode.getPatchesNode();
        OiiiCompInstallID compId = oNode.getCompInstallID();
        int nHomeIndex = this.m_instTimeSession.getOHIndex();
        if (compId.isAppltopComponent()) {
            nHomeIndex = this.m_instTimeSession.getAppltopIndex();
        }
        if ((oInstEntry = this.m_installInv.getInstallCompInvEntry(compId, nHomeIndex)) != null) {
            OiiiInstallPatchInvEntry oPatchInvEntry = oInstEntry.getPatchInvEntry();
            oPatchesNode.setInstalledVersion(oPatchInvEntry);
        }
        this.setupPatchLevels(oPatchesNode);
        OiisDepMode depMode = oNode.getInstallType();
        if (depMode == null) {
            return;
        }
        Vector depRules = oNode.getRules();
        int nRules = depRules.size();
        int i = 0;
        while (true) {
            OiiodDepRuleNode oRule;
            block34: {
                if (i >= nRules) {
                    return;
                }
                oRule = (OiiodDepRuleNode)depRules.elementAt(i);
                OiisDepRuleProperty depRuleProp = oNode.getDepRuleProperty(oRule.getInternalName());
                oRule.setExpandedByDefault(depRuleProp.isOpen());
                boolean bShouldAsk = depRuleProp.shouldAsk();
                oRule.setToBeAsked(bShouldAsk);
                boolean bRequired = oRule.getRuleType() == 3;
                Vector vComps = depRuleProp.getDepRuleComps();
                int nCompsSize = vComps.size();
                block8: for (int j = 0; j < nCompsSize; ++j) {
                    OiiiStageCompInvEntry oEntry;
                    OiisDepRuleComp depRuleComp = (OiisDepRuleComp)vComps.elementAt(j);
                    OiiiCompInstallID dependee = depRuleComp.getComp();
                    if (m_nCurPlatform != 0 && !OiixPlatform.platInVector(dependee.getPlatforms(), m_nCurPlatform)) continue;
                    OiiodDepNode compDepNode = this.getDepNode(dependee);
                    boolean bDefaultSelection = depRuleComp.getSelected();
                    if (!bShouldAsk && !bDefaultSelection) continue;
                    if (compDepNode == null) {
                        OiiiCompInvEntry cie = this.m_stageInv.getCompatCompEntry(dependee, 0, m_nCurPlatform);
                        if (cie == null) continue;
                        dependee = cie.getCompInstallID();
                        compDepNode = this.getDepNode(dependee);
                        if (compDepNode == null) {
                            System.err.println("This is actually erroneous. Should not occur");
                            new Throwable().printStackTrace();
                            continue;
                        }
                    }
                    OiiodRuleSelector oRuleSel = new OiiodRuleSelector(compDepNode, oRule);
                    oRuleSel.setDefaultSelection(bDefaultSelection);
                    oRuleSel.setAskUser(bShouldAsk);
                    boolean bPreReq = true;
                    if (!compDepNode.isNotInStage() && !(oEntry = compDepNode.getStageInvEntry()).isNoPreReq()) {
                        int nPreReq = 2;
                        OiisCompInstallation oCompInstall = this.m_instTimeSession.getCompInstall(dependee);
                        if (oCompInstall == null) {
                            Object[] args = new Object[]{oEntry.getFullDisplayName()};
                            throw new OiiodDepException(0, OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_NO_INSTALL_DEFN_CREATED", args));
                        }
                        nPreReq = this.checkPreReq(oCompInstall);
                        switch (nPreReq) {
                            case 1: {
                                String sMsg = this.getPreReqErrorMessage(dependee);
                                if (!this.m_instTimeSession.getSessionContext().ignorePreReqCheck()) {
                                    this.m_progListener = null;
                                    throw new OiiodDepException(0, sMsg);
                                }
                                OiiodDepEngine.logText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_IGNORE_PREREQ_FAIL"));
                                break;
                            }
                            case 2: {
                                if (oRule.getRuleType() != 3) {
                                    bPreReq = false;
                                    break;
                                }
                            }
                            case 3: {
                                continue block8;
                            }
                        }
                    }
                    if (oRule.getRuleType() == 0 && dependee.getHomeType() == 1) {
                        Vector v;
                        Vector vRules = compDepNode.getParentRules();
                        boolean bAllOptional = true;
                        int nDepRules = vRules.size();
                        for (int k = 0; k < nDepRules; ++k) {
                            OiiodDepRuleNode oRuleNode = (OiiodDepRuleNode)vRules.elementAt(k);
                            if (oRuleNode.getRuleType() == 0) continue;
                            bAllOptional = false;
                            break;
                        }
                        if (bAllOptional && this.checkSOHCompPresentInInv(dependee, v = new Vector(1, 1))) {
                            this.processWarning((String)v.elementAt(0));
                            continue;
                        }
                    }
                    boolean bSelected = false;
                    int nStatus = compDepNode.getCompStatus();
                    boolean bSpecifiedInCmdLine = OiisVariable.isSpecifiedInCmdLine("DEPENDENCY_LIST", oNode.getCompInstallID());
                    if (bSpecifiedInCmdLine) {
                        this.m_bResponseFileUsed = true;
                    }
                    if (!bRequired && bShouldAsk && this.m_bResponseFileUsed) {
                        boolean bNewFormat = true;
                        if (!bNewFormat) {
                            bNewFormat = this.m_instTimeSession.getSessionContext().getResponseFileManager().isVersion221();
                        }
                        bSelected = this.isSelectedInResponse(dependee, oNode.getCompInstallID(), bNewFormat);
                        if (nStatus == 5 && bSelected) {
                            compDepNode.setCompStatus(0);
                        }
                        oRuleSel.setSelected(bSelected);
                    } else {
                        bSelected = depRuleComp.getSelected();
                        boolean isSelectedResponse = false;
                        if (this.m_bResponseFileUsed) {
                            isSelectedResponse = this.isSelectedInResponse(dependee, oNode.getCompInstallID(), true);
                        }
                        if (isSelectedResponse) {
                            if (nStatus == 5 && bSelected) {
                                compDepNode.setCompStatus(0);
                            }
                            oRuleSel.setSelected(bSelected && bPreReq);
                        } else if (nStatus != 5) {
                            oRuleSel.setSelected(bSelected && bPreReq);
                        }
                    }
                    compDepNode.addSelector(oRuleSel);
                    oRule.addRuleSelector(oRuleSel);
                    oRuleSel.setRuleNodes(compDepNode.getRules());
                }
                if (oRule.getRuleType() == 1) {
                    try {
                        Vector j = oRule.getCurrentSelections();
                    }
                    catch (OiiodDepCountException ie) {
                        Vector v = oRule.getChildren();
                        if (v.size() <= 0) break block34;
                        OiiodRuleSelector oRuleSel = (OiiodRuleSelector)v.elementAt(0);
                        oRuleSel.getCompNode().select();
                    }
                }
            }
            if (oRule.isVisible() && oRule.getVisibleChildren().size() > 0) {
                this.m_bMoreQs = true;
            }
            ++i;
        }
    }

    public Vector getTopLevelSelectors() {
        return this.m_topLevelSelectors;
    }

    public Vector getVisibleTopLevelSelectors() {
        Vector<OiiodTopLevelSelector> v = new Vector<OiiodTopLevelSelector>();
        int nSize = this.m_topLevelSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodTopLevelSelector oSel = (OiiodTopLevelSelector)this.m_topLevelSelectors.elementAt(i);
            if (oSel.getVisibleChildren().size() <= 0) continue;
            v.addElement(oSel);
        }
        return v;
    }

    public Vector getTreeToShow() {
        return this.m_topLevelSelectors;
    }

    public boolean isOUIComp(OiiiCompInstallID cid) {
        String compName = cid.getName();
        return compName.equalsIgnoreCase(S_OUI_NAME) || compName.equalsIgnoreCase(S_OUI_CORE_NAME) || compName.equalsIgnoreCase(S_OUI_CORE_MIN_NAME) || compName.equalsIgnoreCase(S_OUI_OPATCH_NAME);
    }

    public boolean isAdditionalCompForReinstall(OiiiCompInstallID cid) {
        String compName = cid.getName();
        ArrayList listOfAddComps = this.getaddComps();
        int size = listOfAddComps != null ? listOfAddComps.size() : 0;
        for (int k = 0; k < size; ++k) {
            OiiodAdditionalComps ad = (OiiodAdditionalComps)listOfAddComps.get(k);
            if (!compName.equalsIgnoreCase(ad.getInternalName()) || !ad.getFlag().equals("ALWAYS_IF_NEW_OR_VERSION_GTE")) continue;
            return true;
        }
        return false;
    }

    public boolean isPatchSetReinstall() {
        Vector v = new Vector();
        boolean bPatchReinstall = false;
        int nSize = this.m_topLevelSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodTopLevelSelector oSel = (OiiodTopLevelSelector)this.m_topLevelSelectors.elementAt(i);
            OiiodDepNode oNode = oSel.getCompNode();
            if (!(oNode instanceof OiiodPatchSetNode) || oNode.getCompStatus() != 5 && oNode.getCompStatus() != 2) continue;
            bPatchReinstall = true;
            break;
        }
        return bPatchReinstall;
    }

    public boolean isPatchSetInstall() {
        for (int i = 0; i < this.m_topLevelSelectors.size(); ++i) {
            OiiodTopLevelSelector oSel = (OiiodTopLevelSelector)this.m_topLevelSelectors.elementAt(i);
            OiiodDepNode oNode = oSel.getCompNode();
            if (!(oNode instanceof OiiodPatchSetNode)) continue;
            return true;
        }
        return false;
    }

    public boolean isPatchSetUpgrade() {
        Vector v = new Vector();
        boolean bPatchUpgrade = false;
        int nSize = this.m_topLevelSelectors.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodTopLevelSelector oSel = (OiiodTopLevelSelector)this.m_topLevelSelectors.elementAt(i);
            OiiodDepNode oNode = oSel.getCompNode();
            if (!(oNode instanceof OiiodPatchSetNode) || oNode.getCompStatus() != 0 && oNode.getCompStatus() != 1) continue;
            bPatchUpgrade = true;
            break;
        }
        return bPatchUpgrade;
    }

    public boolean moreQuestions() {
        if (this.isPatchSetReinstall()) {
            this.m_bMoreQs = true;
        }
        return this.m_bMoreQs;
    }

    public String getInstallDisplayString(OiiiCompInstallID cid) {
        String displayString = null;
        OiiiCompInvEntry instEntry = null;
        int ohIndex = this.m_instSession.getHomeIndex(cid);
        if (this.m_installInv != null) {
            instEntry = this.m_installInv.getCompatCompEntry(cid, ohIndex, m_nCurPlatform);
        }
        if (instEntry != null) {
            displayString = instEntry.getFullDisplayName();
        }
        return displayString;
    }

    public void checkTreeCorrectness(Vector vError) {
    }

    public Vector calcCompsToInstall() throws OiiodDepException {
        this.m_installCompIds = new Vector();
        this.m_deinstallCompIds = new Vector();
        this.m_alreadyInstalledIds = new Vector();
        this.m_selPatchIds = new Vector();
        this.calcInstDeinstComps();
        return this.m_installCompIds;
    }

    public Vector getCompsToInstall() {
        return this.m_installCompIds;
    }

    public Vector getCompsToDeinstall() {
        return this.m_deinstallCompIds;
    }

    public Vector getOneoffsToDeinstall() {
        Vector<OiiiOneoffInstallID> vRetVect = new Vector<OiiiOneoffInstallID>();
        int iSize = this.m_deinstallOneoffIdOhs.size();
        for (int i = 0; i < iSize; ++i) {
            OiiiOneoffIdOhPair oPair = (OiiiOneoffIdOhPair)this.m_deinstallOneoffIdOhs.get(i);
            if (!oPair.isOneoff()) continue;
            vRetVect.add(oPair.getOneoffID());
        }
        return vRetVect;
    }

    public Vector getMiniPatchsetsToDeinstall() {
        Vector<OiiiOneoffInstallID> vRetVect = new Vector<OiiiOneoffInstallID>();
        int iSize = this.m_deinstallOneoffIdOhs.size();
        for (int i = 0; i < iSize; ++i) {
            OiiiOneoffIdOhPair oPair = (OiiiOneoffIdOhPair)this.m_deinstallOneoffIdOhs.get(i);
            if (oPair.isOneoff()) continue;
            vRetVect.add(oPair.getOneoffID());
        }
        return vRetVect;
    }

    public Vector getOneoffIdOhsToDeinstall() {
        return this.m_deinstallOneoffIdOhs;
    }

    public Map getConflictingOneoffs() {
        return this.m_oConflictingOneOffIdMap;
    }

    public Vector getCompsToRemove() {
        Vector<Integer> vRuleType = new Vector<Integer>();
        Vector<Integer> vCompType = new Vector<Integer>();
        Vector<OiiiCompInstallID> vAppltopComps = new Vector<OiiiCompInstallID>();
        Vector<OiiiCompInstallID> vOhComps = new Vector<OiiiCompInstallID>();
        for (int i = 0; i < this.m_deinstallCompIds.size(); ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)this.m_deinstallCompIds.elementAt(i);
            if (cid.isAppltopComponent()) {
                vAppltopComps.addElement(cid);
            } else {
                vOhComps.addElement(cid);
            }
            vCompType.addElement(new Integer(4));
            vRuleType.addElement(new Integer(3));
        }
        Vector appltopCompIdOhPairs = OiiiCompIdOhPair.createCompIdOhVector(vAppltopComps, vRuleType, vCompType, this.m_instSession.getAppltopIndex());
        Vector deinstallCompIdOhPairs = OiiiCompIdOhPair.createCompIdOhVector(vOhComps, vRuleType, vCompType, this.m_instSession.getOHIndex());
        OiixVectorOps.unionInPlace(deinstallCompIdOhPairs, appltopCompIdOhPairs);
        return OiiodDepEngineHelper.sortCompOhsList(this.m_installInv, deinstallCompIdOhPairs);
    }

    public Vector getCompsToInstallAsOhVector() {
        int nSize = this.m_installCompIds.size();
        Vector<Integer> vRuleType = new Vector<Integer>();
        Vector<Integer> vCompType = new Vector<Integer>();
        for (int i = 0; i < nSize; ++i) {
            int nStatus;
            OiiiCompInstallID cid = (OiiiCompInstallID)this.m_installCompIds.elementAt(i);
            vRuleType.addElement(new Integer(3));
            if (cid instanceof OiiiPatchInstallID) {
                OiiodDepPatchNode oPatch = this.getDepPatchNode(cid);
                nStatus = oPatch.getPatchesNode().getInstallStatus();
            } else {
                OiiodDepNode oDepNode = this.getDepNode(cid);
                nStatus = oDepNode.getCompStatus();
            }
            vCompType.addElement(new Integer(nStatus));
        }
        int ohIndex = this.m_instSession.getOHIndex();
        Vector installCompIdOhPair = OiiiCompIdOhPair.createCompIdOhVector(this.m_installCompIds, vRuleType, vCompType, ohIndex);
        return installCompIdOhPair;
    }

    public Vector getAlreadyIntalledCompsAsOhVector() {
        int nSize = this.m_alreadyInstalledIds.size();
        Vector<Integer> vRuleType = new Vector<Integer>();
        Vector<Integer> vCompType = new Vector<Integer>();
        for (int i = 0; i < nSize; ++i) {
            OiiiCompInstallID cid = (OiiiCompInstallID)this.m_alreadyInstalledIds.elementAt(i);
            vRuleType.addElement(new Integer(3));
            vCompType.addElement(new Integer(5));
        }
        int ohIndex = this.m_instSession.getOHIndex();
        Vector installCompIdOhPair = OiiiCompIdOhPair.createCompIdOhVector(this.m_alreadyInstalledIds, vRuleType, vCompType, ohIndex);
        return installCompIdOhPair;
    }

    public Vector getSelectedPatches() {
        return this.m_selPatchIds;
    }

    public Vector getSelectedPatchSetsAsOhVector() {
        Vector<OiiiCompInstallID> vPatchSets = new Vector<OiiiCompInstallID>();
        int nSize = this.m_patchSetNodes.size();
        Vector<Integer> vRuleType = new Vector<Integer>();
        Vector<Integer> vCompType = new Vector<Integer>();
        for (int i = 0; i < nSize; ++i) {
            OiiodPatchSetNode oPatchSet = (OiiodPatchSetNode)this.m_patchSetNodes.elementAt(i);
            vPatchSets.addElement(oPatchSet.getCompInstallID());
            vRuleType.addElement(new Integer(3));
            vCompType.addElement(new Integer(oPatchSet.getCompStatus()));
        }
        int ohIndex = this.m_instSession.getOHIndex();
        Vector installCompIdOhPair = OiiiCompIdOhPair.createCompIdOhVector(vPatchSets, vRuleType, vCompType, ohIndex);
        return installCompIdOhPair;
    }

    public Vector getSelectedPatchSets() {
        Vector<OiiiCompInstallID> vPatchSets = new Vector<OiiiCompInstallID>();
        int nSize = this.m_patchSetNodes.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodPatchSetNode oPatchSet = (OiiodPatchSetNode)this.m_patchSetNodes.elementAt(i);
            vPatchSets.addElement(oPatchSet.getCompInstallID());
        }
        return vPatchSets;
    }

    protected void calcInstDeinstComps() throws OiiodDepException {
        int i;
        int nSize = this.m_compNodes.size();
        int nHashSize = nSize > 0 ? nSize : 1;
        Hashtable indexTable = new Hashtable(nHashSize);
        for (i = 0; i < nSize; ++i) {
            indexTable.put(this.m_compNodes.elementAt(i), new Integer(i));
        }
        nSize = this.m_replaceRangeComps.size();
        for (i = 0; i < nSize - 1; ++i) {
            for (int j = i + 1; j < nSize; ++j) {
                OiiodReplaceRangeComps oRepComp1 = (OiiodReplaceRangeComps)this.m_replaceRangeComps.elementAt(i);
                OiiodReplaceRangeComps oRepComp2 = (OiiodReplaceRangeComps)this.m_replaceRangeComps.elementAt(j);
                Vector vComps1 = oRepComp1.getAllComps();
                Vector vComps2 = oRepComp2.getAllComps();
                OiiodDepNode oNode1 = (OiiodDepNode)vComps1.elementAt(0);
                OiiodDepNode oNode2 = (OiiodDepNode)vComps2.elementAt(0);
                Integer oIndex = (Integer)indexTable.get(oNode1);
                int nIndex1 = -1;
                if (oIndex != null) {
                    nIndex1 = oIndex;
                }
                oIndex = (Integer)indexTable.get(oNode2);
                int nIndex2 = -1;
                if (oIndex != null) {
                    nIndex2 = oIndex;
                }
                if (nIndex2 >= nIndex1) continue;
                this.m_replaceRangeComps.setElementAt(oRepComp2, i);
                this.m_replaceRangeComps.setElementAt(oRepComp1, j);
            }
        }
        block10: for (i = 0; i < nSize; ++i) {
            OiiodReplaceRangeComps oRangComp = (OiiodReplaceRangeComps)this.m_replaceRangeComps.elementAt(i);
            OiiodDepNode iterNode = oRangComp.getSelectedNode();
            if (iterNode == null) continue;
            this.checkInstallerVersion(iterNode);
            OiiiCompInstallID selID = iterNode.getCompInstallID();
            if (selID.getCompType() == 4) continue;
            if (this.isOUIComp(selID) && this.m_bVersionEqual) {
                iterNode.setCompStatus(0);
            }
            if (this.isAdditionalCompForReinstall(selID)) {
                iterNode.setCompStatus(0);
            }
            this.gatherSelectedPatch(iterNode);
            switch (iterNode.getCompStatus()) {
                case 2: {
                    this.m_installCompIds.addElement(selID);
                    OiiiInstallCompInvEntry invEntry = iterNode.getInstallInvEntry();
                    this.m_deinstallCompIds.addElement(invEntry.getCompInstallID());
                    continue block10;
                }
                case 0: {
                    this.m_installCompIds.addElement(selID);
                    continue block10;
                }
                case 1: {
                    this.m_installCompIds.addElement(selID);
                    OiiiInstallCompInvEntry invEntry = iterNode.getInstallInvEntry();
                    this.m_deinstallCompIds.addElement(invEntry.getCompInstallID());
                    this.addToDeinstallVect(oRangComp.getReplaceComps(), this.m_deinstallCompIds);
                    continue block10;
                }
                case 5: {
                    OiiiInstallCompInvEntry invEntry = iterNode.getInstallInvEntry();
                    this.m_alreadyInstalledIds.addElement(invEntry.getCompInstallID());
                    continue block10;
                }
                case 3: {
                    OiiiInstallCompInvEntry invEntry = iterNode.getInstallInvEntry();
                    this.m_alreadyInstalledIds.addElement(invEntry.getCompInstallID());
                }
            }
        }
        this.calcDeinstComps(this.m_deinstallCompIds);
        if (this.m_bRemoveAllOneOffs) {
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("m_bRemoveAllOneOffs is set to:" + this.m_bRemoveAllOneOffs, OiiolTextLogger.getLogLevel());
                OiiolTextLogger.appendText("Creating a complete list of oneoffs to deinstall");
            }
            this.m_deinstallOneoffIdOhs = this.getAllOneOffsToDeinstall();
        } else {
            this.m_deinstallOneoffIdOhs = new Vector();
            this.m_oConflictingOneOffIdMap = new HashMap();
            this.calcDeinstOneOffs(this.m_deinstallOneoffIdOhs, this.m_oConflictingOneOffIdMap);
        }
    }

    private void gatherSelectedPatch(OiiodDepNode oNode) throws OiiodDepException {
        OiiodPatchesNode oPatchesNode = oNode.getPatchesNode();
        OiiiVersion oVersion = null;
        if (oPatchesNode.isSelected() || oPatchesNode.getInstallStatus() == 5) {
            oVersion = oPatchesNode.getSelectedPatchLevel();
        }
        if (oVersion != null) {
            OiiodDepPatchNode oPatch = oPatchesNode.getPatchNode(oVersion);
            this.checkInstallerVersion(oPatch);
            OiiiCompInstallID selID = oPatch.getCompInstallID();
            switch (oPatchesNode.getInstallStatus()) {
                case 2: {
                    this.m_installCompIds.addElement(selID);
                    this.m_deinstallCompIds.addElement(selID);
                    this.m_selPatchIds.addElement(selID);
                    break;
                }
                case 0: {
                    this.m_installCompIds.addElement(selID);
                    this.m_selPatchIds.addElement(selID);
                    break;
                }
                case 1: {
                    this.m_installCompIds.addElement(selID);
                    OiiiInstallPatchInvEntry invEntry = oPatchesNode.getInstallInvEntry();
                    this.m_deinstallCompIds.addElement(invEntry.getCompInstallID());
                    this.m_selPatchIds.addElement(selID);
                    break;
                }
                case 5: {
                    this.m_alreadyInstalledIds.addElement(selID);
                    this.logAlreadyInstalledPatchMsg(oPatch, oPatchesNode.getInstallInvEntry());
                    break;
                }
                case 3: {
                    OiiiInstallPatchInvEntry invEntry = oPatchesNode.getInstallInvEntry();
                    this.m_alreadyInstalledIds.addElement(invEntry.getCompInstallID());
                    this.logAlreadyInstalledPatchMsg(oPatch, oPatchesNode.getInstallInvEntry());
                }
            }
        }
    }

    private void logAlreadyInstalledPatchMsg(OiiodDepPatchNode oNode, OiiiInstallCompInvEntry oEntry) {
        String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_PATCH_NOT_ADDED2");
        Object[] objs = new String[]{oNode.toString(), oEntry.getFullDisplayName()};
        sMsg = MessageFormat.format(sMsg, objs);
        this.processWarning(sMsg);
    }

    private Vector getAllOneOffsToDeinstall() {
        OiiiOneoffInvEntry ooEntry;
        int i;
        int nCnt;
        int nOHIdx = this.m_instTimeSession.getOHIndex();
        Vector oOneOffs = this.m_installInv.getAllOneoffInvEntries(nOHIdx, false);
        Vector oMiniPatchsets = this.m_installInv.getAllMiniPatchsetInvEntries(nOHIdx, false);
        Vector<OiiiOneoffIdOhPair> oDeinstallOneOffIdOhs = null;
        if (oOneOffs != null) {
            nCnt = oOneOffs.size();
            oDeinstallOneOffIdOhs = new Vector<OiiiOneoffIdOhPair>();
            for (i = 0; i < nCnt; ++i) {
                ooEntry = (OiiiInstallOneoffInvEntry)oOneOffs.get(i);
                oDeinstallOneOffIdOhs.add(((OiiiInstallOneoffInvEntry)ooEntry).getOneoffIdOhPair());
            }
        }
        if (oMiniPatchsets != null) {
            nCnt = oMiniPatchsets.size();
            if (oDeinstallOneOffIdOhs == null) {
                oDeinstallOneOffIdOhs = new Vector();
            }
            for (i = 0; i < nCnt; ++i) {
                ooEntry = (OiiiInstallMiniPatchsetInvEntry)oMiniPatchsets.get(i);
                oDeinstallOneOffIdOhs.add(((OiiiInstallMiniPatchsetInvEntry)ooEntry).getMiniPatchsetIdOhPair());
            }
        }
        return oDeinstallOneOffIdOhs;
    }

    private void calcDeinstOneOffs(List oDeinstOneOffs, Map oConflictingOneOffs) {
        int nOHIdx = this.m_instTimeSession.getOHIndex();
        Vector oOneOffs = this.m_installInv.getAllOneoffInvEntries(nOHIdx, false);
        Vector oMiniPatchsets = this.m_installInv.getAllMiniPatchsetInvEntries(nOHIdx, false);
        Object oDeinstallOneOffIdOhs = null;
        if (oOneOffs != null) {
            int n;
            OiiiOneoffInvEntry ooEntry;
            int i;
            Vector oCompsToInstall = this.getCompsToInstall();
            Vector oCompsToDeinstall = this.getCompsToDeinstall();
            Map oCompsToInstallMap = this.getCompsMap(oCompsToInstall);
            Map oCompsToDeinstallMap = this.getCompsMap(oCompsToDeinstall);
            int nCnt = oOneOffs.size();
            for (i = 0; i < nCnt; ++i) {
                ooEntry = (OiiiInstallOneoffInvEntry)oOneOffs.get(i);
                n = this.shouldRemoveOneOff((OiiiInstallOneoffInvEntry)ooEntry, oCompsToInstallMap, oCompsToDeinstallMap, oDeinstOneOffs, oConflictingOneOffs);
            }
            nCnt = oMiniPatchsets != null ? oMiniPatchsets.size() : 0;
            for (i = 0; i < nCnt; ++i) {
                ooEntry = (OiiiInstallMiniPatchsetInvEntry)oMiniPatchsets.get(i);
                n = this.shouldRemoveMiniPatchset((OiiiInstallMiniPatchsetInvEntry)ooEntry, oCompsToInstallMap, oCompsToDeinstallMap, oDeinstOneOffs, oConflictingOneOffs);
            }
        }
    }

    private Map getCompsMap(List oCompsList) {
        HashMap oCompsMap = new HashMap();
        if (oCompsList != null) {
            int nComps = oCompsList.size();
            for (int i = 0; i < nComps; ++i) {
                OiiiCompInstallID cid = (OiiiCompInstallID)oCompsList.get(i);
                ArrayList<OiiiCompInstallID> oCidList = new ArrayList<OiiiCompInstallID>(2);
                oCidList.add(cid);
                oCompsMap.put(cid.getName(), oCidList);
            }
        }
        return oCompsMap;
    }

    private int shouldRemoveOneOff(OiiiInstallOneoffInvEntry ooEntry, Map oCompsToInstallMap, Map oCompsToDeinstallMap, List oDeinstOneOffs, Map oConflictingOneOffs) {
        OiiolTextLogger.appendText("Checking if one off:" + ooEntry.getID() + " should be removed or not.");
        int iOneOffStatus = 0;
        ArrayList<OiiiCompInstallID> oConflictingComps = new ArrayList<OiiiCompInstallID>();
        Vector oBaseComps = ooEntry.getBaseComps();
        boolean bCompUpgraded = false;
        int nCompsUpgraded = 0;
        boolean bCompDeinstalled = false;
        int nCompsDeinstalled = 0;
        int nRogueComps = 0;
        int nBaseComps = oBaseComps == null ? 0 : oBaseComps.size();
        for (int i = 0; i < nBaseComps; ++i) {
            List oCompsDeinstalled;
            bCompUpgraded = false;
            bCompDeinstalled = false;
            OiiiCompIdOhPair oPair = (OiiiCompIdOhPair)oBaseComps.get(i);
            OiiiCompInstallID oID = oPair.getCompID();
            String sCompName = oID.getName();
            List oCompsInstalled = (List)oCompsToInstallMap.get(sCompName);
            if (oCompsInstalled != null) {
                for (int j = 0; !bCompUpgraded && j < oCompsInstalled.size(); ++j) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)oCompsInstalled.get(j);
                    if (!cid.canReplace(oID, OiixPlatform.getCurrentPlatform())) continue;
                    bCompUpgraded = true;
                    ++nCompsUpgraded;
                }
            } else if (this.m_installInv.getInstalledInvEntry(sCompName, oID.getVersion(), oID.getVersion(), true, this.m_instTimeSession.getOHIndex()) == null) {
                ++nRogueComps;
            }
            if (!bCompUpgraded && (oCompsDeinstalled = (List)oCompsToDeinstallMap.get(sCompName)) != null) {
                for (int j = 0; !bCompDeinstalled && j < oCompsDeinstalled.size(); ++j) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)oCompsDeinstalled.get(j);
                    if (!cid.equals(oID, this.m_bIgnoreBuild)) continue;
                    bCompDeinstalled = true;
                    ++nCompsDeinstalled;
                }
            }
            if (bCompUpgraded || bCompDeinstalled) continue;
            oConflictingComps.add(oID);
            OiiolTextLogger.appendText(oID + ": this is a conflicting component");
        }
        int nConflictingComps = oConflictingComps.size();
        if (nRogueComps == nBaseComps) {
            OiiolTextLogger.appendText("None of the base components of the one off patch exist. The one off should be removed.");
            iOneOffStatus = 1;
            oDeinstOneOffs.add(ooEntry.getOneoffIdOhPair());
        } else if (nCompsUpgraded == 0 && nCompsDeinstalled == 0) {
            OiiolTextLogger.appendText("None of the base components of the one off patch are getting deinstalled / upgraded. The one off will not be removed.");
            iOneOffStatus = 0;
        } else if (nConflictingComps == 0) {
            OiiolTextLogger.appendText("All comps of the one off are getting deinstalled / upgraded. The one off will be removed.");
            iOneOffStatus = 1;
            oDeinstOneOffs.add(ooEntry.getOneoffIdOhPair());
        } else {
            OiiolTextLogger.appendText("Atleast one comps of the one off is getting deinstalled / upgraded and there is atleast one conflict. The one off will be marked as a conflict.");
            iOneOffStatus = 3;
            oConflictingOneOffs.put(ooEntry.getOneoffIdOhPair(), oConflictingComps);
        }
        return iOneOffStatus;
    }

    private int shouldRemoveMiniPatchset(OiiiInstallMiniPatchsetInvEntry ooEntry, Map oCompsToInstallMap, Map oCompsToDeinstallMap, List oDeinstMiniPatchsets, Map oConflictingMiniPatchsets) {
        OiiolTextLogger.appendText("Checking if mini patchset:" + ooEntry.getID() + " should be removed or not.");
        int iMiniPatchsetStatus = 0;
        ArrayList<OiiiCompInstallID> oConflictingComps = new ArrayList<OiiiCompInstallID>();
        Vector oBaseComps = ooEntry.getBaseComps();
        boolean bCompUpgraded = false;
        int nCompsUpgraded = 0;
        boolean bCompDeinstalled = false;
        int nCompsDeinstalled = 0;
        int nRogueComps = 0;
        int nBaseComps = oBaseComps == null ? 0 : oBaseComps.size();
        for (int i = 0; i < nBaseComps; ++i) {
            List oCompsDeinstalled;
            bCompUpgraded = false;
            bCompDeinstalled = false;
            OiiiCompIdVerPair oCIdVerPair = (OiiiCompIdVerPair)oBaseComps.get(i);
            OiiiCompIdOhPair oPair = oCIdVerPair.getCompIdOhPair();
            OiiiCompInstallID oID = oPair.getCompID();
            String sCompName = oID.getName();
            List oCompsInstalled = (List)oCompsToInstallMap.get(sCompName);
            if (oCompsInstalled != null) {
                for (int j = 0; !bCompUpgraded && j < oCompsInstalled.size(); ++j) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)oCompsInstalled.get(j);
                    if (!cid.canReplace(oID, OiixPlatform.getCurrentPlatform())) continue;
                    bCompUpgraded = true;
                    ++nCompsUpgraded;
                }
            } else if (this.m_installInv.getInstalledInvEntry(sCompName, oID.getVersion(), oID.getVersion(), true, this.m_instTimeSession.getOHIndex()) == null) {
                ++nRogueComps;
            }
            if (!bCompUpgraded && (oCompsDeinstalled = (List)oCompsToDeinstallMap.get(sCompName)) != null) {
                for (int j = 0; !bCompDeinstalled && j < oCompsDeinstalled.size(); ++j) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)oCompsDeinstalled.get(j);
                    if (!cid.equals(oID, this.m_bIgnoreBuild)) continue;
                    bCompDeinstalled = true;
                    ++nCompsDeinstalled;
                }
            }
            if (bCompUpgraded || bCompDeinstalled) continue;
            oConflictingComps.add(oID);
            OiiolTextLogger.appendText(oID + ": this is a conflicting component");
        }
        int nConflictingComps = oConflictingComps.size();
        if (nRogueComps == nBaseComps) {
            OiiolTextLogger.appendText("None of the base components of the mini patchset patch exist. The mini patchset should be removed.");
            iMiniPatchsetStatus = 1;
            oDeinstMiniPatchsets.add(ooEntry.getMiniPatchsetIdOhPair());
        } else if (nCompsUpgraded == 0 && nCompsDeinstalled == 0) {
            OiiolTextLogger.appendText("None of the base components of the mini patchset patch are getting deinstalled / upgraded. The mini patchset will not be removed.");
            iMiniPatchsetStatus = 0;
        } else if (nConflictingComps == 0) {
            OiiolTextLogger.appendText("All comps of the mini patchset are getting deinstalled / upgraded. The mini patchset will be removed.");
            iMiniPatchsetStatus = 1;
            oDeinstMiniPatchsets.add(ooEntry.getMiniPatchsetIdOhPair());
        } else {
            OiiolTextLogger.appendText("Atleast one comps of the mini patchset is getting deinstalled / upgraded and there is atleast one conflict. The one off will be marked as a conflict.");
            iMiniPatchsetStatus = 3;
            oConflictingMiniPatchsets.put(ooEntry.getMiniPatchsetIdOhPair(), oConflictingComps);
        }
        return iMiniPatchsetStatus;
    }

    private List getSelectedComps(List oComps) {
        ArrayList<OiiodDepNode> oSelectedComps = new ArrayList<OiiodDepNode>();
        int nCompSize = oComps.size();
        for (int j = 0; j < nCompSize; ++j) {
            OiiiCompInstallID oID;
            OiiiCompIdOhPair oPair = (OiiiCompIdOhPair)oComps.get(j);
            OiiiCompInstallID oCompatBaseID = oID = oPair.getCompID();
            OiiodDepNode oSelNode = null;
            if (oID.getCompType() == 2) {
                oCompatBaseID = ((OiiiPatchInstallID)oID).getCompInstallID();
                OiiodDepNode oBaseNode = this.getDepNode(oCompatBaseID);
                OiiodPatchesNode oPatchesNode = oBaseNode.getPatchesNode();
                oSelNode = this.getDepPatchNode(oPatchesNode.getCompInstallID());
            } else {
                OiiodReplaceRangeComps oRepComp = (OiiodReplaceRangeComps)this.m_compTable.get(oCompatBaseID);
                oSelNode = oRepComp.getSelectedNode();
            }
            if (oSelNode == null) continue;
            oSelectedComps.add(oSelNode);
        }
        return oSelectedComps;
    }

    private void calcDeinstComps(Vector deinstallIds) {
        for (int i = 0; i < deinstallIds.size(); ++i) {
            Vector vDeps;
            Vector compInvEntries;
            OiiiInstallCompInvEntry oEntry;
            OiiiInstallPatchInvEntry oPatchEntry;
            OiiiCompInstallID deinstallId = (OiiiCompInstallID)deinstallIds.elementAt(i);
            if (deinstallId.getCompType() == 2) continue;
            int nOhIndex = this.m_instTimeSession.getOHIndex();
            if (deinstallId.isAppltopComponent()) {
                nOhIndex = this.m_instTimeSession.getAppltopIndex();
            }
            if ((oPatchEntry = (oEntry = (OiiiInstallCompInvEntry)this.m_installInv.getCompInvEntry(deinstallId, nOhIndex)).getPatchInvEntry()) != null && deinstallIds.indexOf(oPatchEntry.getCompInstallID()) == -1) {
                deinstallIds.addElement(oPatchEntry.getCompInstallID());
            }
            if ((compInvEntries = this.m_installInv.getCompInvEntries(deinstallId.getName(), nOhIndex)) != null) {
                for (int idx = 0; idx < compInvEntries.size(); ++idx) {
                    OiiiCompInvEntry cie = (OiiiCompInvEntry)compInvEntries.elementAt(idx);
                    OiiiCompInstallID cid = cie.getCompInstallID();
                    if (!deinstallId.getVersion().laterThan(cid.getVersion()) || cid.getCompType() != 2 || deinstallIds.indexOf(cid) != -1) continue;
                    deinstallIds.addElement(cid);
                }
            }
            if ((vDeps = oEntry.getDependees()) == null) continue;
            int nDeps = vDeps.size();
            for (int j = 0; j < nDeps; ++j) {
                int idx;
                OiiiCompIdOhPair ohPair = (OiiiCompIdOhPair)vDeps.elementAt(j);
                OiiiCompInstallID oDependee = ohPair.getCompID();
                int nDepOhIndex = this.m_instTimeSession.getOHIndex();
                if (oDependee.isAppltopComponent()) {
                    nDepOhIndex = this.m_instTimeSession.getAppltopIndex();
                }
                if (deinstallIds.indexOf(oDependee) != -1) continue;
                OiiodDepNode oDepNode = this.getDepNode(oDependee);
                OiiiInstallCompInvEntry oDepEntry = (OiiiInstallCompInvEntry)this.m_installInv.getCompInvEntry(oDependee, nDepOhIndex);
                if (oDepNode != null || oDepEntry == null || (idx = OiixVectorOps.vectIndexOf(this.m_alreadyInstalledIds, (Object)(oDependee = oDepEntry.getCompInstallID()))) != -1) continue;
                boolean bValidRef = false;
                Vector vRefs = oDepEntry.getReferencers();
                int nRefs = vRefs.size();
                if (nRefs > 1) {
                    for (int k = 0; k < nRefs; ++k) {
                        OiiiCompIdOhPair ohRefPair = (OiiiCompIdOhPair)vRefs.elementAt(k);
                        OiiiCompInstallID oRef = ohRefPair.getCompID();
                        if (deinstallIds.indexOf(oRef) != -1) continue;
                        bValidRef = true;
                        break;
                    }
                } else {
                    int nInstallSize = this.m_installCompIds.size();
                    for (int m = 0; m < nInstallSize; ++m) {
                        OiiiCompInstallID installId = (OiiiCompInstallID)this.m_installCompIds.get(m);
                        if (!installId.canReplace(deinstallId, m_nCurPlatform)) continue;
                        try {
                            OiiodDepNode oRefNode = this.getDepNode(installId);
                            Vector vNewDeps = oRefNode.getStageInvEntry().getDeps().getAllDependees();
                            for (int n = 0; n < vNewDeps.size(); ++n) {
                                OiiiCompInstallID newDepId = (OiiiCompInstallID)vNewDeps.get(n);
                                if (!oDependee.canReplace(newDepId, m_nCurPlatform)) continue;
                                bValidRef = true;
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!bValidRef) {
                            continue;
                        }
                        break;
                    }
                }
                if (bValidRef) continue;
                deinstallIds.addElement(oDependee);
            }
        }
    }

    private void addToDeinstallVect(Vector vInvEntries, Vector deinstallIds) {
        int nSize = vInvEntries.size();
        for (int i = 0; i < nSize; ++i) {
            OiiiInstallPatchInvEntry oPatchEntry;
            OiiiInstallCompInvEntry oEntry = (OiiiInstallCompInvEntry)vInvEntries.elementAt(i);
            if (deinstallIds.indexOf(oEntry.getCompInstallID()) == -1) {
                deinstallIds.addElement(oEntry.getCompInstallID());
            }
            if ((oPatchEntry = oEntry.getPatchInvEntry()) == null || deinstallIds.indexOf(oPatchEntry.getCompInstallID()) != -1) continue;
            deinstallIds.addElement(oPatchEntry.getCompInstallID());
        }
    }

    public Vector getDependeeInfo(OiiiCompInstallID oCompId, int ohIndex) {
        Vector<OiiiCompIdOhPair> vDependees = new Vector<OiiiCompIdOhPair>();
        if (oCompId instanceof OiiiPatchInstallID || oCompId instanceof OiiiPatchSetInstallID) {
            return vDependees;
        }
        OiiodDepNode oNode = this.getDepNode(oCompId);
        Vector vRules = oNode.getRules();
        int nSize = vRules.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodDepRuleNode oPropNode = (OiiodDepRuleNode)vRules.elementAt(i);
            Vector vComps = oPropNode.getDepNodes();
            int nCompSize = vComps.size();
            for (int j = 0; j < nCompSize; ++j) {
                OiiodDepNode oCompNode = (OiiodDepNode)vComps.elementAt(j);
                OiiodReplaceRangeComps oRepComp = (OiiodReplaceRangeComps)this.m_compTable.get(oCompNode.getCompInstallID());
                OiiodDepNode oSelNode = oRepComp.getSelectedNode();
                if (oSelNode == null) continue;
                OiiiCompInstallID depId = oSelNode.getCompInstallID();
                if (oSelNode.isDownGrade() || oSelNode.getInstallStatus() == 5) {
                    OiiiInstallCompInvEntry invEntry = oSelNode.getInstallInvEntry();
                    depId = invEntry.getCompInstallID();
                    int depHomeIndex = invEntry.getOHIndex();
                    if (vDependees.indexOf(depId) != -1) continue;
                    OiiiCompIdOhPair oCompIDPair = new OiiiCompIdOhPair(depId, depId.isNOHComp() ? 0 : depHomeIndex);
                    oCompIDPair.setDepType(oPropNode.getRuleType());
                    oCompIDPair.setCompInstallType(5);
                    oCompIDPair.setDepGroup(oPropNode.getInternalName());
                    vDependees.addElement(oCompIDPair);
                    continue;
                }
                if (vDependees.indexOf(depId) != -1) continue;
                int depHomeIndex = this.m_instSession.getHomeIndex(depId);
                OiiiCompIdOhPair oCompIDPair = new OiiiCompIdOhPair(depId, depId.isNOHComp() ? 0 : depHomeIndex);
                oCompIDPair.setDepType(oPropNode.getRuleType());
                oCompIDPair.setCompInstallType(oCompNode.getCompStatus());
                oCompIDPair.setDepGroup(oPropNode.getInternalName());
                vDependees.addElement(oCompIDPair);
            }
        }
        return vDependees;
    }

    public Vector getContainedPatches(OiiiPatchSetInstallID id) {
        Vector<OiiiCompInstallID> v = new Vector<OiiiCompInstallID>();
        int nIndex = OiixVectorOps.vectIndexOf(this.m_patchSetNodes, (Object)id);
        if (nIndex != -1) {
            OiiodPatchSetNode oPSetNode = (OiiodPatchSetNode)this.m_patchSetNodes.elementAt(nIndex);
            Vector vPatches = oPSetNode.getPatches();
            int nSize = vPatches.size();
            for (int i = 0; i < nSize; ++i) {
                OiiodDepPatchNode oPatch = (OiiodDepPatchNode)vPatches.elementAt(i);
                OiiodPatchesNode oPatchesNode = oPatch.getPatchesNode();
                OiiiVersion oVersion = null;
                if (oPatchesNode != null) {
                    oVersion = oPatchesNode.getSelectedPatchLevel();
                }
                if (oVersion == null || !oVersion.equals(oPatch.getVersion())) continue;
                OiiiCompInstallID selID = oPatch.getCompInstallID();
                switch (oPatchesNode.getInstallStatus()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 5: {
                        v.addElement(selID);
                    }
                }
            }
        }
        return v;
    }

    public Vector getEditableCompsToInstall() {
        Vector<OiiiCompInstallID> edComps = new Vector<OiiiCompInstallID>();
        Vector comps = this.getCompsToInstall();
        int numElems = comps.size();
        for (int i = 0; i < numElems; ++i) {
            OiisProdHomeVar oVar;
            OiisCompInstallation compInstall;
            OiiiCompInstallID cid = (OiiiCompInstallID)comps.elementAt(i);
            if (!cid.isNOHComp() || cid.getCompType() == 2 || (compInstall = this.m_instSession.getCompInstall(cid)) == null || !(oVar = compInstall.getProdHome()).isEditable()) continue;
            edComps.addElement(cid);
        }
        return edComps;
    }

    public int checkPreReq(OiisCompInstallation oCompInstall) throws OiifbCancelException {
        boolean bReq;
        Boolean bVal;
        OiisCompContext oContext;
        OiisPreRequisiteVar pVar;
        if (null == this.applySelectionTimer) {
            this.applySelectionTimer = new OiiodTimer();
        }
        this.applySelectionTimer.start();
        int nResult = 0;
        if (this.m_bExecutePreReq && (pVar = (OiisPreRequisiteVar)(oContext = oCompInstall.getContext(true)).getVariable("PRE_REQUISITE")) != null && (bVal = (Boolean)pVar.getValue()) != null && !(bReq = bVal.booleanValue())) {
            OiiiCompInstallID compId = oCompInstall.getCompInstallID();
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_FAIL_PREREQ");
            if (this.m_instTimeSession instanceof OiicPullSession) {
                Object[] msgArr = new String[]{((OiicPullSession)this.m_instTimeSession).getStgCompDisplayName(compId)};
                sMsg = MessageFormat.format(sMsg, msgArr);
            }
            this.processWarning(sMsg);
            nResult = pVar.getFailureID();
        }
        this.applySelectionTimer.stop();
        return nResult;
    }

    public String getPreReqErrorMessage(OiiiCompInstallID compId) {
        OiisCompInstallation oCompInstall = this.m_instTimeSession.getCompInstall(compId);
        OiisPreRequisiteVar pVar = oCompInstall.getPreRequisite();
        String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INVALID_PREREQ");
        if (this.m_instTimeSession instanceof OiicPullSession) {
            Object[] msgArr = new String[]{((OiicPullSession)this.m_instTimeSession).getStgCompDisplayName(compId)};
            sMsg = MessageFormat.format(sMsg, msgArr);
        }
        if (pVar == null) {
            return sMsg;
        }
        Boolean bVal = (Boolean)pVar.getValue();
        if (bVal == null) {
            return sMsg;
        }
        String sMsg1 = pVar.getFailureMessage();
        if (sMsg1 != null && sMsg1.length() != 0) {
            return sMsg1;
        }
        return sMsg;
    }

    protected String getProdHome(OiisCompInstallation oContext) {
        OiisProdHomeVar pVar = oContext.getProdHome();
        String sVal = (String)pVar.getValue();
        return sVal;
    }

    protected boolean isPresentInInv(OiiiCompInstallID childId, OiiiCompInstallID parentID, int ohIndex) {
        OiiiCompInvEntry parentEntry;
        if (this.m_installInv != null && (parentEntry = this.m_installInv.getCompatCompEntry(parentID, ohIndex, m_nCurPlatform)) != null) {
            OiiiCompIdOhPair childOh;
            Vector vDeps = parentEntry.getDependees();
            int childOhIndex = ohIndex;
            if (childId.isNOHComp()) {
                childOhIndex = 0;
            }
            if (vDeps.indexOf(childOh = new OiiiCompIdOhPair(childId, childOhIndex)) != -1) {
                return true;
            }
        }
        return false;
    }

    public String[] getDepsFromVar(OiiiCompInstallID id) {
        String[] depsList = null;
        OiisVariable oVar = new OiisVariable(this.m_instSession.getSessionContext(), "DEPENDENCY_LIST");
        try {
            oVar.setVariable(id);
            depsList = (String[])oVar.getValue();
            if (null == depsList && OiisVariable.isSpecifiedInCmdLine("DEPENDENCY_LIST", id)) {
                OiisAdvisedValue oVal = OiisVariable.getValueFromCommandLine(id, "DEPENDENCY_LIST");
                if (null != oVar.getValue()) {
                    depsList = (String[])oVar.getValue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        OiiolTextLogger.appendText("The Dependency List from the variable / from the command line specified is : " + depsList);
        return depsList;
    }

    protected boolean isSelectedInResponse(OiiiCompInstallID childId, OiiiCompInstallID parentID, boolean bNewFormat) {
        if (this.m_instSession == null) {
            return false;
        }
        String[] depComps = this.getDepsFromVar(parentID);
        if (depComps != null && (bNewFormat || !bNewFormat && depComps.length != 0 && depComps.length % 2 == 0)) {
            String[] comps = new String[2];
            int append = bNewFormat ? 1 : 2;
            for (int i = 0; i < depComps.length; i += append) {
                OiiiCompInstallID id;
                if (bNewFormat) {
                    String strDepList = depComps[i];
                    if (depComps[i].indexOf(":") != -1) {
                        if (depComps[i].startsWith("\"") && depComps[i].endsWith("\"")) {
                            strDepList = strDepList.substring(strDepList.indexOf("\"") + 1, strDepList.lastIndexOf("\""));
                        }
                        comps[0] = strDepList.substring(0, strDepList.indexOf(":"));
                        comps[1] = strDepList.substring(strDepList.indexOf(":") + 1, strDepList.length());
                    } else {
                        comps[0] = depComps[i];
                        comps[1] = null;
                    }
                } else {
                    comps[0] = depComps[i];
                    comps[1] = depComps[i + 1];
                }
                if (comps[1] == null || !OiiiVersion.validate(comps[1])) {
                    comps[1] = childId.getVersion().toString();
                }
                if ((id = this.m_instSession.getCompIDValue(comps)) == null || !id.equalsWithPlatInt(childId)) continue;
                return true;
            }
        }
        return false;
    }

    private void setupPatchLevels(OiiodPatchesNode oPatchesNode) throws OiiodDepException {
        if (oPatchesNode.hasPatches()) {
            OiiodDepNode oNode;
            Vector oPatchNodes = oPatchesNode.getAllPatches();
            OiiodDepPatchNode oPatch = (OiiodDepPatchNode)oPatchNodes.elementAt(0);
            OiiiStagePatchInvEntry oEntry = (OiiiStagePatchInvEntry)oPatch.getStageInvEntry();
            if (oEntry != null) {
                OiisPatchDeps oDeps = oEntry.getPatchDeps();
                Vector vDeps = oDeps.getDepObjs();
                int nSize = vDeps.size();
                for (int i = 0; i < nSize; ++i) {
                    OiiiCompInstallID dependee;
                    int nIndex;
                    OiisPatchDepObj oPatchObj = (OiisPatchDepObj)vDeps.elementAt(i);
                    if (!oPatchObj.isVerUpgraded() || (nIndex = OiixVectorOps.vectIndexOf(this.m_patchNodes, (Object)(dependee = oPatchObj.getCurDepId()))) != -1) continue;
                    String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEPPATCH_NOT_FOUND");
                    Object[] objs = new String[]{oEntry.getFullDisplayName(), dependee.getName() + " " + dependee.getVersion()};
                    if (this.processError(sMsg = MessageFormat.format(sMsg, objs)) != -1) continue;
                    throw new OiiodDepException(0, sMsg);
                }
            }
            oPatchesNode.setSelectedPatchLevel(oPatch.getVersion());
            oPatchesNode.calcInitStatus();
            OiiiVersion oInstVer = oPatchesNode.getInstalledVersion();
            if (oInstVer != null) {
                oNode = oPatchesNode.getParentNode();
                if (OiixVectorOps.vectIndexOf(this.m_selCompsVect, (Object)oNode.getCompInstallID()) != -1) {
                    if (oPatchesNode.getInstallStatus() == 5) {
                        oPatchesNode.setCompStatus(2);
                    }
                    int nIndex = OiixVectorOps.vectIndexOf(this.m_topLevelSelectors, (Object)oNode.getCompInstallID());
                    OiiodISelector oSel = (OiiodISelector)this.m_topLevelSelectors.elementAt(nIndex);
                    oPatch.addSelector(oSel);
                } else {
                    OiiiVersion selectedPatchLevel = oPatchesNode.getSelectedPatchLevel();
                    if (selectedPatchLevel.laterThan(oInstVer, this.m_bIgnoreBuild)) {
                        oPatchesNode.setSelected(true);
                    } else if (selectedPatchLevel.equals(oInstVer, this.m_bIgnoreBuild)) {
                        boolean isUpgrade = !this.isPatchSetReinstall();
                        boolean bSelect = false;
                        String[] list = this.getDepsFromVar(null);
                        if (list != null) {
                            bSelect = this.isSelectedInResponse(oPatchesNode.getCompInstallID(), null, true);
                        }
                        if (isUpgrade || bSelect) {
                            oPatchesNode.setSelected(true);
                        } else {
                            oPatchesNode.setSelected(false);
                        }
                    } else {
                        oPatchesNode.setSelected(false);
                    }
                    oPatchesNode.setMinimumPatchLevel(oInstVer);
                }
            } else {
                oNode = oPatchesNode.getParentNode();
                OiiiVersion installedVersion = oNode.getInstalledVersion();
                if (installedVersion != null) {
                    String[] list = this.getDepsFromVar(null);
                    if (list != null && this.isPatchSetInstall()) {
                        if (this.isSelectedInResponse(oPatchesNode.getCompInstallID(), null, true)) {
                            oPatchesNode.setSelected(true);
                        } else {
                            oPatchesNode.setSelected(false);
                        }
                    } else {
                        oPatchesNode.setSelected(true);
                    }
                }
            }
        }
    }

    public Vector[] getRequiredSpace(OiisCompInstallation compInstall) {
        OiicSessionContext oContext = this.m_instSession.getSessionContext();
        OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
        String[] strArrLang = (String[])oLangs.getValue();
        Vector sLangs = OiixLanguage.getLangsVector(strArrLang);
        Vector<Long> sizeV = new Vector<Long>();
        Vector<String> volV = new Vector<String>();
        OiipgFileSystem system = new OiipgFileSystem();
        String sOracleHome = (String)oContext.getVariable("ORACLE_HOME").getValue();
        String sOracleHomeDrive = system.getVolumeName(sOracleHome);
        if (compInstall != null) {
            Long size = new Long(compInstall.getSize(sLangs));
            sizeV.addElement(size);
            OiiiCompInstallID id = compInstall.getCompInstallID();
            String phome = null;
            String vol = "";
            if (!id.isOracleHomeComp()) {
                phome = this.getProdHome(compInstall);
            }
            vol = phome == null || phome.length() == 0 ? sOracleHomeDrive : system.getVolumeName(phome);
            volV.addElement(vol);
        }
        Vector[] retValue = new Vector[]{volV, sizeV};
        return retValue;
    }

    public void invalidateVolumeInfo() {
        this.m_oVolumeSpaceInfo = null;
    }

    public List getRequiredSpace(boolean bCalculate) {
        if (this.m_oVolumeSpaceInfo == null || bCalculate) {
            if (this.m_instSession != null) {
                this.computeRequiredSpace();
            } else {
                this.m_oVolumeSpaceInfo = new ArrayList();
            }
        }
        return this.m_oVolumeSpaceInfo;
    }

    private List computeRequiredSpace() {
        boolean bLog;
        this.m_totalReqBytes = 0L;
        Vector vPlat = OiixPlatform.getCurrentPlatformVector();
        OiicSessionContext oSessContext = this.m_instSession.getSessionContext();
        OiisVariable oLangs = oSessContext.getVariable("SELECTED_LANGUAGES");
        String[] strLangsList = (String[])oLangs.getValue();
        Vector sLangs = OiixLanguage.getLangsVector(strLangsList);
        Vector v = this.getCompsToInstall();
        this.m_oVolumeSpaceInfo = new ArrayList();
        OiipgFileSystem system = new OiipgFileSystem();
        String sOracleHome = (String)oSessContext.getVariable("ORACLE_HOME").getValue();
        String sOracleHomeDrive = system.getVolumeName(sOracleHome);
        String sInvLocation = (String)oSessContext.getVariable("INVENTORY_LOCATION").getValue();
        String sCentralInvDrive = system.getVolumeName(sInvLocation);
        String sAppltopDrive = null;
        long lLargestFileGroupJar = 0L;
        long lLibSizes = this.m_instSession.getLibsSpaceRequired();
        boolean bNetworkMode = OiiofFileLoaderFactory.isNetworkSource("");
        String sAppltopLocation = null;
        if (OiixOraparam.isApplTopStage()) {
            sAppltopLocation = (String)oSessContext.getVariable("APPLTOP").getValue();
            sAppltopDrive = system.getVolumeName(sAppltopLocation);
        }
        String sTempDir = OiipgFileSystem.getTempLoc();
        String sTempVol = system.getVolumeName(sTempDir);
        boolean bl = bLog = OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED;
        if (bLog) {
            OiiolTextLogger.appendText("ComputeDiskInfo Temp Dir :" + sTempDir);
            OiiolTextLogger.appendText("ComputeDiskInfo Temp Vol :" + sTempVol);
        }
        int nSize = v.size();
        long lLibSpaceNOH = 0L;
        long lLibSpaceOH = 0L;
        long lLibSpaceAppltop = 0L;
        for (int i = 0; i < nSize; ++i) {
            OiisCompInstallation oInstall;
            OiiiStageCompInvEntry oEntry;
            OiiiCompInstallID id = (OiiiCompInstallID)v.elementAt(i);
            OiiodDepNode oNode = null;
            if (id.getCompType() == 1) {
                oNode = this.getDepNode(id);
            } else if (id.getCompType() == 2) {
                oNode = this.getDepPatchNode(id);
            }
            if (oNode == null || (oEntry = oNode.getStageInvEntry()) == null) continue;
            if (id.isNOHComp()) {
                if (lLibSpaceNOH == 0L) {
                    lLibSpaceNOH = lLibSizes;
                }
            } else if (id.isOracleHomeComp() && lLibSpaceOH == 0L) {
                lLibSpaceOH = lLibSizes;
            }
            if (id.isAppltopComponent() && lLibSpaceAppltop == 0L) {
                lLibSpaceAppltop = lLibSizes;
            }
            if (bLog) {
                OiiolTextLogger.appendText("ComputeDiskInfo Computing for :" + id);
            }
            long nFileSize = 0L;
            OiisFileSizeInfo oSize = oEntry.getFileSizeInfoEx();
            if (oSize == null && (oInstall = this.m_instSession.getCompInstall(id)) != null) {
                nFileSize = oInstall.getSize(sLangs);
                this.m_totalReqBytes += nFileSize;
                if (bLog) {
                    OiiolTextLogger.appendText("ComputeDiskInfo FILESIZES for Comp #" + id.getName() + "#" + "Size" + "#" + Long.toString(nFileSize));
                }
            }
            Hashtable htSizes = oSize.getSizesTable(sLangs, vPlat, oSessContext, 1);
            Enumeration e = htSizes.keys();
            Hashtable htTempSizes = oSize.getSizesTable(sLangs, vPlat, oSessContext, 2);
            Hashtable htNonInstallSizes = oSize.getSizesTable(sLangs, vPlat, oSessContext, 4);
            while (e.hasMoreElements()) {
                String sKey = (String)e.nextElement();
                long lRequiredSize = 0L;
                long lTempSize = 0L;
                long lNonInstallSize = 0L;
                Long lSize = null;
                lSize = (Long)htSizes.get(sKey);
                if (lSize != null) {
                    lRequiredSize = lSize;
                }
                if ((lSize = (Long)htTempSizes.get(sKey)) != null) {
                    lTempSize = lSize;
                }
                if ((lSize = (Long)htNonInstallSizes.get(sKey)) != null) {
                    lNonInstallSize = lSize;
                }
                String sVol = system.getVolumeName(sKey);
                if (sKey == null || sKey.length() == 0) {
                    OiiolTextLogger.appendText("ComputeDiskInfo Key is NULL, discarding");
                } else {
                    this.updateVolumeSizes(sKey, sVol, this.m_oVolumeSpaceInfo, lRequiredSize, lTempSize, lNonInstallSize);
                }
                this.m_totalReqBytes += lRequiredSize;
                this.m_totalReqBytes += lNonInstallSize;
                if (!bLog) continue;
                OiiolTextLogger.appendText("ComputeDiskInfo VolumeName for key:" + sKey + " :" + sVol);
                OiiolTextLogger.appendText("ComputeDiskInfo SIZE/VOL #" + sVol + "#" + "Comp " + id.getName() + "#" + "RequiredSize " + "#" + Long.toString(lRequiredSize) + "#" + "NonInstallSize" + "#" + Long.toString(lNonInstallSize));
            }
            long lLargestFGJarTemp = oSize.getLargestFileGroupJar(m_nCurPlatform);
            if (!bNetworkMode || lLargestFileGroupJar >= lLargestFGJarTemp) continue;
            lLargestFileGroupJar = lLargestFGJarTemp;
        }
        long lTempTotal = lLargestFileGroupJar + lLibSizes / 2L;
        this.m_instSession.setLargestFileGroupJarSize(lLargestFileGroupJar);
        this.updateVolumeSizes(sTempDir, sTempVol, this.m_oVolumeSpaceInfo, 0L, lTempTotal, 0L);
        if (lLibSpaceNOH != 0L) {
            this.updateVolumeSizes(sInvLocation, sCentralInvDrive, this.m_oVolumeSpaceInfo, lLibSpaceNOH, 0L, 0L);
        }
        if (lLibSpaceOH != 0L) {
            this.updateVolumeSizes(sOracleHome, sOracleHomeDrive, this.m_oVolumeSpaceInfo, lLibSpaceOH, 0L, 0L);
            if (bLog) {
                OiiolTextLogger.appendText("ComputeDiskInfo AddingLibSize #" + lLibSpaceOH);
            }
        }
        if (lLibSpaceAppltop != 0L) {
            if (sAppltopDrive != null) {
                this.updateVolumeSizes(sAppltopLocation, sAppltopDrive, this.m_oVolumeSpaceInfo, lLibSpaceAppltop, 0L, 0L);
            } else {
                System.err.println("Appltop install without setting appltop home");
            }
        }
        Hashtable htVolumesToCorrect = this.getSpaceFreedUpByDeinstall(sLangs, vPlat);
        int nTotalVolumes = this.m_oVolumeSpaceInfo.size();
        for (int i = 0; i < nTotalVolumes; ++i) {
            OiiodVolumeInfo oVolInfo = (OiiodVolumeInfo)this.m_oVolumeSpaceInfo.get(i);
            String sVol = oVolInfo.getVolumeName();
            Long olSizeCorrection = (Long)htVolumesToCorrect.get(sVol);
            if (olSizeCorrection == null) continue;
            long lOriginalSize = oVolInfo.getRequiredSpace();
            long lCorrectedSize = lOriginalSize - olSizeCorrection;
            if (lCorrectedSize < 0L) {
                lCorrectedSize = 0L;
            }
            oVolInfo.setRequiredSpace(lCorrectedSize);
        }
        return this.m_oVolumeSpaceInfo;
    }

    public List getLangAddonRequiredSpace(Vector vCompsToInstall) {
        if (this.m_oVolumeSpaceInfo == null) {
            this.computeLangAddonRequiredSpace(vCompsToInstall);
        }
        return this.m_oVolumeSpaceInfo;
    }

    private List computeLangAddonRequiredSpace(Vector vCompsToInstall) {
        this.m_totalReqBytes = 0L;
        Vector vPlat = OiixPlatform.getCurrentPlatformVector();
        if (this.m_instSession == null) {
            this.m_instSession = (OiicInstallSession)this.m_instTimeSession;
        }
        OiicSessionContext oSessContext = this.m_instSession.getSessionContext();
        Vector sLangs = null;
        OiisVariable oLangs = oSessContext.getVariable("SELECTED_LANGUAGES");
        String[] strLangsList = (String[])oLangs.getValue();
        sLangs = OiixLanguage.getLangsVector(strLangsList);
        OiisVariable oNodes = oSessContext.getVariable("CLUSTER_NODES");
        String[] asNodes = (String[])oNodes.getValue();
        String sLocalNode = null;
        if (asNodes != null && asNodes.length > 1) {
            OiipgDetectCluster dg = OiipgDetectCluster.getDetectCluster();
            sLocalNode = dg.getLocalNodeName();
        }
        this.m_oVolumeSpaceInfo = new ArrayList();
        OiipgFileSystem system = new OiipgFileSystem();
        String sOracleHome = (String)oSessContext.getVariable("ORACLE_HOME").getValue();
        String sOracleHomeDrive = system.getVolumeName(sOracleHome);
        String sInvLocation = (String)oSessContext.getVariable("INVENTORY_LOCATION").getValue();
        String sCentralInvDrive = system.getVolumeName(sInvLocation);
        String sAppltopDrive = null;
        long lLargestFileGroupJar = 0L;
        long lLibSizes = this.m_instSession.getLibsSpaceRequired();
        boolean bNetworkMode = OiiofFileLoaderFactory.isNetworkSource("");
        if (OiixOraparam.isApplTopStage()) {
            String sAppltopLocation = (String)oSessContext.getVariable("APPLTOP").getValue();
            sAppltopDrive = system.getVolumeName(sAppltopLocation);
        }
        String sTempDir = OiipgFileSystem.getTempLoc();
        String sTempVol = system.getVolumeName(sTempDir);
        int nSize = vCompsToInstall.size();
        long lLibSpaceNOH = 0L;
        long lLibSpaceOH = 0L;
        long lLibSpaceAppltop = 0L;
        for (int i = 0; i < nSize; ++i) {
            OiisCompInstallation oInstall;
            OiiiInstallCompInvEntry oInsEntry = (OiiiInstallCompInvEntry)vCompsToInstall.elementAt(i);
            OiiiCompInstallID id = oInsEntry.getCompInstallID();
            OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)this.m_stageInv.getCompInvEntry(id);
            if (oEntry == null) continue;
            if (id.isNOHComp()) {
                if (lLibSpaceNOH == 0L) {
                    lLibSpaceNOH = lLibSizes;
                }
            } else if (id.isOracleHomeComp() && lLibSpaceOH == 0L) {
                lLibSpaceOH = lLibSizes;
            }
            if (id.isAppltopComponent() && lLibSpaceAppltop == 0L) {
                lLibSpaceAppltop = lLibSizes;
            }
            long nFileSize = 0L;
            OiisFileSizeInfo oSize = oEntry.getFileSizeInfoEx();
            if (oSize == null && (oInstall = this.m_instSession.getCompInstall(id)) != null) {
                nFileSize = oInstall.getSize(sLangs);
                this.m_totalReqBytes += nFileSize;
            }
            Hashtable htSizes = null;
            Hashtable htTempSizes = null;
            Hashtable htNonInstallSizes = null;
            Vector uLangs = oInsEntry.getUpgradeLangs();
            Vector iLangs = oInsEntry.getLanguages();
            htSizes = oSize.getSizesTable(iLangs, uLangs, vPlat, oSessContext, 1);
            htTempSizes = oSize.getSizesTable(iLangs, uLangs, vPlat, oSessContext, 2);
            htNonInstallSizes = oSize.getSizesTable(iLangs, uLangs, vPlat, oSessContext, 4);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                OiiolTextLogger.appendText("In getLangAddonRequiredSpace() of OiiodDepEngine:\nFor component " + oInsEntry.getFullDisplayName() + " : " + "\nhtSizes = " + htSizes + "\nhtTempSizes =" + htTempSizes + "\n htNonInstallSizes =" + htNonInstallSizes, OiiolTextLogger.LOG_DETAILED);
            }
            Enumeration e = htSizes.keys();
            while (e.hasMoreElements()) {
                String sKey = (String)e.nextElement();
                long lRequiredSize = 0L;
                long lTempSize = 0L;
                long lNonInstallSize = 0L;
                Long lSize = null;
                lSize = (Long)htSizes.get(sKey);
                if (lSize != null) {
                    lRequiredSize = lSize;
                }
                if ((lSize = (Long)htTempSizes.get(sKey)) != null) {
                    lTempSize = lSize;
                }
                if ((lSize = (Long)htNonInstallSizes.get(sKey)) != null) {
                    lNonInstallSize = lSize;
                }
                String sVol = system.getVolumeName(sKey);
                this.updateVolumeSizes(sKey, sVol, this.m_oVolumeSpaceInfo, lRequiredSize, lTempSize, lNonInstallSize);
                this.m_totalReqBytes += lRequiredSize;
                this.m_totalReqBytes += lNonInstallSize;
            }
            long lLargestFGJarTemp = oSize.getLargestFileGroupJar(m_nCurPlatform);
            if (!bNetworkMode || lLargestFileGroupJar >= lLargestFGJarTemp) continue;
            lLargestFileGroupJar = lLargestFGJarTemp;
        }
        long lTempTotal = lLargestFileGroupJar + lLibSizes / 2L;
        this.m_instSession.setLargestFileGroupJarSize(lLargestFileGroupJar);
        this.updateVolumeSizes(sTempDir, sTempVol, this.m_oVolumeSpaceInfo, 0L, lTempTotal, 0L);
        return this.m_oVolumeSpaceInfo;
    }

    private void updateVolumeSizes(String sPath, String sDrive, List oVolumeInfo, long lValue, long lTempValue, long lNIValue) {
        OiiodVolumeInfo vi = new OiiodVolumeInfo(sDrive);
        int nIndex = OiixVectorOps.vectIndexOf(oVolumeInfo, (Object)vi);
        OiiodVolumeInfo oVolInfo = null;
        boolean bCFS = false;
        if (nIndex == -1) {
            String val = OiixOraparam.getOraparamProfileString("IGNORECLUSTER", "false");
            if (!val.equalsIgnoreCase("true")) {
                OiipgCFSDriveCheck cfsDriveCheck = OiipgCFSDriveCheck.getCFSDriveChecker();
                bCFS = cfsDriveCheck.isDriveOnCFS(sPath);
            }
            oVolInfo = new OiiodVolumeInfo(sDrive, bCFS);
            oVolumeInfo.add(oVolInfo);
        } else {
            oVolInfo = (OiiodVolumeInfo)oVolumeInfo.get(nIndex);
        }
        oVolInfo.addRequiredSpace(lValue);
        oVolInfo.addTempSpace(lTempValue);
        oVolInfo.addPostInstallSpace(lNIValue);
    }

    private Hashtable getSpaceFreedUpByDeinstall(Vector vLangs, Vector vPlats) {
        Hashtable htDestinationSizes = new Hashtable();
        OiiiInstallCompInvEntry oInstCompInvEntry = null;
        OiipgFileSystem system = new OiipgFileSystem();
        int iCompsInDeinstall = this.m_deinstallCompIds.size();
        for (int i = 0; i < iCompsInDeinstall; ++i) {
            OiisFileSizeInfo oSize;
            int ohIndex;
            boolean bFound = false;
            oInstCompInvEntry = null;
            OiiiCompInstallID oId = (OiiiCompInstallID)this.m_deinstallCompIds.elementAt(i);
            oInstCompInvEntry = this.m_installInv.getInstallCompInvEntry(oId, ohIndex = this.m_instSession.getHomeIndex(oId));
            if (oInstCompInvEntry == null || (oSize = oInstCompInvEntry.getFileSizeInfoEx()) == null) continue;
            OiisCompContext oCompContext = null;
            try {
                oCompContext = OiisCompContext.createContextFromInstallInv(oInstCompInvEntry, ohIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oCompContext == null) continue;
            oSize.setCompContext(oCompContext);
            Hashtable htDestinationSizesTemp = oSize.getDestinationSizesTable(vLangs, vPlats);
            Enumeration e = htDestinationSizesTemp.keys();
            while (e.hasMoreElements()) {
                String sDest = (String)e.nextElement();
                String sDestVolume = system.getVolumeName(sDest);
                long lVolSize = (Long)htDestinationSizesTemp.get(sDest);
                OiiodVolumeInfo oVolInfo = new OiiodVolumeInfo(sDestVolume);
                OiisFileSizeInfo.updateSizesTable(oVolInfo.getVolumeName(), lVolSize, htDestinationSizes);
            }
        }
        return htDestinationSizes;
    }

    public long getTotalRequiredSpace() {
        return this.m_totalReqBytes;
    }

    private boolean checkSOHCompPresentInInv(OiiiCompInstallID id, Vector vError) throws OiiodDepException {
        int iCurrIdx;
        int nOhIndex;
        OiiiCompIdOhPair oOhId;
        boolean bPresent = false;
        boolean bThrowSOHException = false;
        if (!this.m_bExecutePreReq) {
            return bPresent;
        }
        if (id.getHomeType() == 1 && (oOhId = this.m_installInv.getCompatCompInvEntryInAnyHome(id, m_nCurPlatform)) != null && (nOhIndex = oOhId.getOHIndex()) != (iCurrIdx = this.m_instSession.getOHIndex()) && nOhIndex != 0) {
            OiiiCompInvEntry cie = this.m_installInv.getCompatCompEntry(oOhId.getCompID(), nOhIndex);
            String sError = null;
            ArrayList<String> oArgs = new ArrayList<String>();
            if (cie.isTopLevel()) {
                sError = "OIIO1000";
                bThrowSOHException = true;
            } else {
                sError = "S_DEP_SINGLE_HOME";
            }
            String sName = this.m_instSession.getInstCompName(oOhId.getCompID(), nOhIndex);
            if (sName != null) {
                oArgs.add(sName);
            } else {
                oArgs.add(oOhId.getCompID().toString());
            }
            if (id.isOracleHomeComp()) {
                String sOHLocation = this.m_installInv.getHomeLocation(nOhIndex);
                if (sOHLocation != null) {
                    oArgs.add(sOHLocation);
                } else {
                    oArgs.add(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_UNKNOWN"));
                }
            }
            if (bThrowSOHException) {
                String sCurrOHLocation = this.m_installInv.getHomeLocation(iCurrIdx);
                oArgs.add(1, sCurrOHLocation);
            }
            Object[] obj = OiixVectorOps.list2StrArr(oArgs);
            sError = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sError, obj);
            if (bThrowSOHException) {
                throw new OiiodDepException(0, sError);
            }
            if (vError.indexOf(sError) == -1) {
                vError.add(sError);
            }
            bPresent = true;
        }
        return bPresent;
    }

    public void validateForMOH() throws OiiodDepException {
        Vector v = this.getCompsToInstall();
        Vector vError = new Vector();
        for (int i = 0; i < v.size(); ++i) {
            OiiiCompInstallID id = (OiiiCompInstallID)v.elementAt(i);
            this.checkSOHCompPresentInInv(id, vError);
        }
        if (vError.size() > 0) {
            Object[] msgArr = new String[]{vError.toString()};
            String sError = MessageFormat.format(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INSTALL_CONTINUE_ERROR"), msgArr);
            sError = sError + " " + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_DEP_SINGLE_HOME_DIAGNOSTIC");
            throw new OiiodDepException(0, sError);
        }
    }

    public void setErrListener(OiiodIDepEngErrListener l) {
        s_oErrListener = l;
    }

    public OiiodIDepEngErrListener getListener() {
        return s_oErrListener;
    }

    public int processError(String sMsg) {
        if (s_oErrListener != null) {
            s_oErrListener.processError(sMsg, null);
            return 0;
        }
        return -1;
    }

    public int processWarning(String sMsg) {
        if (s_oErrListener != null) {
            return s_oErrListener.processWarning(sMsg, null);
        }
        OiiolTextLogger.appendText(sMsg, 1);
        return -1;
    }

    public static void logText(String text) {
        if (s_oErrListener == null) {
            OiiolTextLogger.appendText(text);
        }
    }

    private void checkInstallerVersion(OiiodDepNode oNode) throws OiiodDepException {
        OiiiVersion oInstVer;
        OiiiVersion oVersion;
        OiiiStageCompInvEntry oEntry = oNode.getStageInvEntry();
        if (oEntry != null && (oVersion = oEntry.getInstallerVersion(m_nCurPlatform, oInstVer = OiicBaseApp.getInstallerVersion())).laterThan(oInstVer)) {
            String sErr = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INSTVER_ERR");
            Object[] sArr = new String[]{oVersion.toString()};
            throw new OiiodDepException(0, MessageFormat.format(sErr, sArr));
        }
    }

    private void initTopLevelCompsList() {
        if (this.m_instTimeSession instanceof OiicInstallSession) {
            this.m_instSession = (OiicInstallSession)this.m_instTimeSession;
            this.m_tlSelCompIDs = this.m_instSession.getSelTopLevelCompIDs();
            this.m_stageInv = this.m_instSession.getSourceAccess().getStageInventory();
        }
    }

    private OiiodReplaceRangeComps addToReplaceRangeComp(OiiodDepNode oNode) {
        OiiiCompInstallID id = oNode.getCompInstallID();
        OiiodReplaceRangeComps oRepComp = null;
        int nSize = this.m_replaceRangeComps.size();
        for (int i = 0; i < nSize; ++i) {
            OiiodReplaceRangeComps oReplaceRange = (OiiodReplaceRangeComps)this.m_replaceRangeComps.elementAt(i);
            if (!oReplaceRange.isCompInRange(id)) continue;
            oRepComp = oReplaceRange;
            break;
        }
        if (oRepComp == null) {
            int ohIndex = this.m_instTimeSession.getOHIndex();
            if (id.isAppltopComponent()) {
                ohIndex = this.m_instTimeSession.getAppltopIndex();
            }
            OiiiInstallCompInvEntry ie = (OiiiInstallCompInvEntry)this.m_installInv.getCompatCompEntry(id, ohIndex, m_nCurPlatform);
            Vector v = null;
            if (ie == null) {
                v = this.m_installInv.getReplaceCompEntries(id, ohIndex, m_nCurPlatform);
                if (v.size() == 0 && id.isNOHComp()) {
                    OiiiCompInstallID checkID = new OiiiCompInstallID(id.getName(), id.getVersion(), id.getPlatforms(), id.getReplaceVersion(), id.getCompType(), 2, id.getReleaseLevel(), false);
                    v = this.m_installInv.getReplaceCompEntries(checkID, ohIndex, m_nCurPlatform);
                }
                if (v.size() > 0) {
                    ie = (OiiiInstallCompInvEntry)v.elementAt(0);
                }
            }
            oRepComp = new OiiodReplaceRangeComps(ie);
            oRepComp.setReplaceComps(v);
            this.m_replaceRangeComps.addElement(oRepComp);
        }
        oRepComp.addDepNode(oNode);
        return oRepComp;
    }

    public void depBuild() throws OiiodDepException {
        this.initTopLevelCompsList();
        this.buildCompArray();
    }

    public void waitForPreLoadProdHomeComps() {
    }

    public void waitForPreLoadComps() {
    }

    public Vector getParticipatingCompsWithDependees() {
        OiiodDepNode oDepNode;
        Vector<Object[]> vParticipationInfo = new Vector<Object[]>(5, 5);
        Object[] aoCompInfo = null;
        if (this.m_compNodes != null) {
            int nCompNodes = this.m_compNodes.size();
            for (int i = 0; i < nCompNodes; ++i) {
                oDepNode = (OiiodDepNode)this.m_compNodes.elementAt(i);
                if (!oDepNode.canParticipate()) continue;
                aoCompInfo = new Object[]{oDepNode, oDepNode.getSelectedVisibleDependees()};
                vParticipationInfo.addElement(aoCompInfo);
            }
        }
        if (this.m_patchNodes != null) {
            int nPatchNodes = this.m_patchNodes.size();
            for (int j = 0; j < nPatchNodes; ++j) {
                oDepNode = (OiiodDepNode)this.m_patchNodes.elementAt(j);
                if (!oDepNode.canParticipate()) continue;
                aoCompInfo = new Object[]{oDepNode, oDepNode.getSelectedVisibleDependees()};
                vParticipationInfo.addElement(aoCompInfo);
            }
        }
        if (this.m_bReadOnly) {
            int nReadOnly = this.m_vReadOnlySelectedCompNodes.size();
            for (int k = 0; k < nReadOnly; ++k) {
                oDepNode = (OiiodDepNode)this.m_vReadOnlySelectedCompNodes.elementAt(k);
                aoCompInfo = new Object[]{oDepNode, oDepNode.getSelectedVisibleDependees()};
                vParticipationInfo.addElement(aoCompInfo);
            }
        }
        return vParticipationInfo;
    }

    public boolean isReinstall(OiiiCompInstallID cid) {
        int nCnt = this.m_deinstallCompIds.size();
        for (int i = 0; i < nCnt; ++i) {
            OiiiCompInstallID id = (OiiiCompInstallID)this.m_deinstallCompIds.elementAt(i);
            if (!id.equals(cid, this.m_bIgnoreBuild)) continue;
            return true;
        }
        return false;
    }

    public boolean isUpgrade(OiiiCompInstallID cid) {
        for (int i = 0; i < this.m_deinstallCompIds.size(); ++i) {
            int idx = OiixVectorOps.vectIndexOf(this.m_deinstallCompIds, (Object)cid.getName(), i);
            if (idx != -1) {
                if (!cid.isCompatible((OiiiCompInstallID)this.m_deinstallCompIds.elementAt(idx), this.m_bIgnoreBuild)) continue;
                OiiiCompInstallID installedCompID = (OiiiCompInstallID)this.m_deinstallCompIds.elementAt(idx);
                if (cid.getVersion().equals(installedCompID.getVersion(), this.m_bIgnoreBuild)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean buildAdditionalComponents(OiiiCompInstallID cid, OiiodAdditionalComps obj) {
        OiiiVersion verInstInv = null;
        OiiiVersion verStageInv = null;
        OiiiCompInstallID stageCid = null;
        OiiiCompInstallID installCid = null;
        String cName = obj.getInternalName();
        if (cid.getCompType() == 4 || cid.getCompType() == 1) {
            Vector varCompInvEntries;
            Vector ohCompInvEntries = this.m_installInv.getCompInvEntries(cName, this.m_instTimeSession.getOHIndex());
            if (ohCompInvEntries.size() > 0) {
                installCid = ((OiiiInstallCompInvEntry)ohCompInvEntries.elementAt(0)).getCompInstallID();
            }
            if (installCid != null) {
                verInstInv = installCid.getVersion();
            }
            if ((varCompInvEntries = this.m_stageInv.getCompInvEntries(cName, 0)).size() > 0) {
                stageCid = ((OiiiStageCompInvEntry)varCompInvEntries.elementAt(0)).getCompInstallID();
            }
            if (stageCid != null) {
                verStageInv = stageCid.getVersion();
            } else {
                OiisVariable oFromLoc = this.m_instSession.getSessionContext().getVariable("FROM_LOCATION");
                String sFromLoc = oFromLoc != null ? (String)oFromLoc.getValue() : null;
                OiiolTextLogger.appendText("   Additional Component" + obj.getDepNode() + "not present in stage" + sFromLoc);
            }
            if (cid.getCompType() == 1) {
                if (verStageInv != null && verInstInv != null && verStageInv.laterThan(verInstInv)) {
                    return true;
                }
                if (verStageInv != null && verInstInv != null && verStageInv.equals(verInstInv) && obj.getFlag().equalsIgnoreCase("ALWAYS_IF_NEW_OR_VERSION_GTE")) {
                    return true;
                }
                if (verStageInv != null && verInstInv == null && (obj.getFlag().equalsIgnoreCase("ALWAYS") || obj.getFlag().equalsIgnoreCase("ALWAYS_IF_NEW_OR_VERSION_GTE"))) {
                    return true;
                }
            }
            if (cid.getCompType() == 4) {
                if (verStageInv != null && verInstInv != null && verStageInv.laterThan(verInstInv)) {
                    return true;
                }
                if (verStageInv != null && verInstInv != null && verStageInv.equals(verInstInv) && obj.getFlag().equalsIgnoreCase("ALWAYS_IF_NEW_OR_VERSION_GTE")) {
                    return true;
                }
                if (verStageInv != null && verInstInv == null && (obj.getFlag().equalsIgnoreCase("ALWAYS") || obj.getFlag().equalsIgnoreCase("CONDITIONAL") || obj.getFlag().equalsIgnoreCase("ALWAYS_IF_NEW_OR_VERSION_GTE"))) {
                    return true;
                }
            }
        }
        return false;
    }

    public void buildOUIComponents(OiiiCompInstallID cid) {
        OiiiVersion verInstInv = null;
        OiiiVersion verStageInv = null;
        OiiiCompInstallID stageCid = null;
        OiiiCompInstallID installCid = null;
        if (cid.getCompType() == 4) {
            Vector varCompInvEntries;
            Vector ohCompInvEntries = this.m_installInv.getCompInvEntries(S_OUI_NAME, this.m_instTimeSession.getOHIndex());
            if (ohCompInvEntries.size() > 0) {
                installCid = ((OiiiInstallCompInvEntry)ohCompInvEntries.elementAt(0)).getCompInstallID();
            }
            if (installCid != null) {
                verInstInv = installCid.getVersion();
            }
            if ((varCompInvEntries = this.m_stageInv.getCompInvEntries(S_OUI_NAME, 0)).size() > 0) {
                stageCid = ((OiiiStageCompInvEntry)varCompInvEntries.elementAt(0)).getCompInstallID();
            }
            if (stageCid != null && stageCid.getCompType() == 1) {
                verStageInv = stageCid.getVersion();
            }
            if (verStageInv != null && verInstInv != null && verStageInv.laterThan(verInstInv)) {
                this.m_bAutoOUI = true;
            } else if (verStageInv != null && verInstInv != null && verStageInv.equals(verInstInv) && OiixOraparam.getAutoOUIInstall().equalsIgnoreCase("ALWAYS_IF_NEW_OR_VERSION_GTE")) {
                this.m_bAutoOUI = true;
                this.m_bVersionEqual = true;
            } else if (verStageInv != null && verInstInv == null && (OiixOraparam.getAutoOUIInstall().equalsIgnoreCase("ALWAYS") || OiixOraparam.getAutoOUIInstall().equalsIgnoreCase("ALWAYS_IF_NEW_OR_VERSION_GTE"))) {
                this.m_bAutoOUI = true;
            }
        }
    }

    private boolean isDowngrade(OiiodDepNode oNode) {
        OiiiInstallPatchInvEntry ipie;
        boolean nRet = false;
        OiiiCompInstallID id = oNode.getCompInstallID();
        if (!(this.m_instTimeSession instanceof OiicInstallSession)) {
            return false;
        }
        if (id.getCompType() != 1) {
            return false;
        }
        OiicInstallSession oSession = (OiicInstallSession)this.m_instTimeSession;
        OiiiInstallInventory installInv = oSession.getInstallAreaControl().getInstallInventory();
        boolean bIgnoreBuildNumber = OiixOraparam.canIgnoreBuildNumber();
        OiiiCompInvEntry ie = installInv.getCompatCompEntry(id, oSession.getHomeIndex(id), OiixPlatform.getCurrentPlatform(), bIgnoreBuildNumber);
        if (ie == null) {
            return false;
        }
        if (!nRet && (ie = installInv.getCompatCompEntry(id, oSession.getHomeIndex(id), OiixPlatform.getCurrentPlatform())) != null && (ipie = ((OiiiInstallCompInvEntry)ie).getPatchInvEntry()) != null) {
            nRet = true;
            oSession.addInstalledTLComp(oNode.getInstallInvEntry());
        }
        return nRet;
    }

    public Vector getDepPatchNodes() {
        return this.m_patchNodes;
    }

    static {
        OUICOMPS = new String[]{S_OUI_NAME, S_OUI_OPATCH_NAME, S_OUI_CORE_NAME, S_OUI_CORE_MIN_NAME};
    }
}

