/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiio.oiiod;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OiiodAdditionalComps {
    private String m_sInternalName;
    private String m_sVersion;
    private String m_sFlag;
    private String[] m_sAC;
    private OiiiCompInstallID m_cid;
    private OiiodDepNode m_depNode;
    public static final String S_ALWAYS = "ALWAYS";
    public static final String S_UPGRADE = "UPGRADE";
    public static final String S_CONDITIONAL = "CONDITIONAL";
    public static final String S_ALWAYS_IF_NEW_OR_VERSION_GTE = "ALWAYS_IF_NEW_OR_VERSION_GTE";
    public ArrayList retLst = new ArrayList();

    public OiiodAdditionalComps(String name, String Version, String flag) {
        this.m_sInternalName = name;
        this.m_sVersion = Version;
        this.m_sFlag = flag;
    }

    public OiiodAdditionalComps(String[] ac) {
        this.m_sAC = ac;
    }

    public ArrayList parseCompsTable() {
        OiiodAdditionalComps obj = null;
        for (int i = 0; i < this.m_sAC.length; ++i) {
            String flag;
            String version;
            StringTokenizer st = new StringTokenizer(this.m_sAC[i], ":");
            int tokens = st.countTokens();
            if (tokens <= 0 || tokens > 3) {
                OiiolTextLogger.appendErrorText("Illegal Format in Additional Component List" + this.m_sAC[i], true, 0);
                return null;
            }
            String name = st.nextToken();
            if (tokens == 3) {
                version = st.nextToken();
                flag = st.nextToken();
            } else if (tokens == 2) {
                String tmp = st.nextToken();
                if (tmp.equalsIgnoreCase(S_ALWAYS) || tmp.equalsIgnoreCase(S_UPGRADE) || tmp.equalsIgnoreCase(S_CONDITIONAL) || tmp.equalsIgnoreCase(S_ALWAYS_IF_NEW_OR_VERSION_GTE)) {
                    flag = tmp;
                    version = "";
                } else {
                    version = tmp;
                    flag = S_ALWAYS;
                }
            } else {
                version = "";
                flag = S_ALWAYS;
            }
            obj = new OiiodAdditionalComps(name, version, flag);
            this.retLst.add(obj);
        }
        return this.retLst;
    }

    public String getInternalName() {
        return this.m_sInternalName;
    }

    public String getVersion() {
        return this.m_sVersion;
    }

    public String getFlag() {
        return this.m_sFlag;
    }

    public void setCID(OiiiCompInstallID cid) {
        this.m_cid = cid;
    }

    public OiiiCompInstallID getCID() {
        return this.m_cid;
    }

    public void setDepNode(OiiodDepNode depNode) {
        this.m_depNode = depNode;
    }

    public OiiodDepNode getDepNode() {
        return this.m_depNode;
    }

    public String toString() {
        return this.m_sInternalName + "::" + this.m_sVersion + "::" + this.m_sFlag;
    }
}

