/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiApplyUpdates;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixIniFile;
import oracle.sysman.oii.oiix.OiixIniPair;
import oracle.sysman.oii.oiix.OiixIniParsingException;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiimUpdatesRestart {
    private static final String temp_INI = "temp.ini";
    private static boolean debug = Boolean.getBoolean("oracle.installer.debug");
    private static final String ouiexec_unix = "runInstaller";
    private static final String ouiexec_windows = "setup";
    private static final String unzip = "unzip";
    private static String m_ResponseDir = "";
    private static final String RESPONSE = "Response";
    private static final String PRODUCTS_XML = "products.xml";
    private static String m_FromLocation = "";
    private static final String COMPLETE = "oracle.swd.Complete.rsp";
    private static final String STAGE = "stage";
    private static final String OPATCH_DIR = "OPatch";
    private boolean m_ouiUpdate = false;
    public static final String RESTART = "-restart";
    public static final String OUIFROMLOCATION = "-ouifromLocation";
    public static final String OUIRESPONSEFILE = "-ouiResponseFile";
    public static final String OPATCHUPDATE = "-oPatchUpdate ";

    public static String getOUIResponseFileLocation() {
        return m_ResponseDir + File.separator + COMPLETE;
    }

    public static String getOUIStageLocation() {
        return m_FromLocation;
    }

    private void checkAndAddToINI(OiixIniFile inOld, OiixIniFile inNew, String section, String name) {
        block8: {
            OiixIniPair ipNew;
            OiiolTextLogger.appendText("OiimUpdatesRestart:INFO  Section Name : " + section + " Property Name: " + name);
            assert (null != section && null != name);
            String valOld = null;
            String valNew = null;
            OiixIniPair ipOld = inOld.getPair(section, name);
            if (ipOld != null) {
                valOld = ipOld.getValue();
            }
            if ((ipNew = inNew.getPair(section, name)) != null) {
                valNew = ipNew.getValue();
            }
            try {
                if (valOld != null) {
                    ipOld.setValue(valNew);
                } else if (null != valNew) {
                    inOld.addPair(section, name, valNew);
                }
            }
            catch (OiixIniParsingException e) {
                if (!debug) break block8;
                OiiolTextLogger.appendException(e);
            }
        }
    }

    public static String getFileListing(File aStartingDir) throws FileNotFoundException {
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        Iterator<File> filesIter = filesDirs.iterator();
        File file = null;
        while (filesIter.hasNext()) {
            file = filesIter.next();
            if (!file.isDirectory()) continue;
            String name = file.getName().trim();
            if (name.equalsIgnoreCase("Disk1")) {
                return file.getAbsolutePath();
            }
            String result = OiimUpdatesRestart.getFileListing(file);
            if (result == null || !result.endsWith(File.separator + "Disk1")) continue;
            return result;
        }
        return null;
    }

    public String findOUIDiskInStage(String destDir, int id) {
        String s = null;
        String ouiBugID = Integer.toString(id);
        String UPDATES_LOCATION = "Shiphome";
        String loc = OiiiApplyUpdates.getLatestUpdatesLoc(destDir, UPDATES_LOCATION);
        loc = loc + File.separator + ouiBugID;
        File dir = new File(loc);
        try {
            s = OiimUpdatesRestart.getFileListing(dir);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return s;
    }

    public boolean isOUIUpdate() {
        return this.m_ouiUpdate;
    }

    public static boolean updateOPatch(String ohome) {
        String scratchPath = System.getProperty("oracle.installer.scratchPath");
        try {
            String src = OiixPathOps.concatPath(scratchPath, OPATCH_DIR);
            String dest = OiixPathOps.concatPath(ohome, OPATCH_DIR);
            OiixFileOps.copyDir(new File(src), new File(dest));
        }
        catch (IOException e) {
            OiiolTextLogger.appendException(e);
            return false;
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
            return false;
        }
        return true;
    }

    public boolean restartOUI(String[] args, String downloadLoc, String paramFile, int ouiBugID, int OPatchBugID) {
        return this.restartOUI(args, downloadLoc, paramFile, ouiBugID, OPatchBugID, new ArrayList());
    }

    public boolean restartOUI(String[] args, String downloadLoc, String paramFile, int ouiBugID, int OPatchBugID, ArrayList VMArgs) {
        int VMArgsLength;
        String DELIM = "#";
        String scratchPath = "-rscratchPath";
        String timestamp = "-rtimestamp";
        String startupLoc = "-rstartupLoc";
        String pf = "-paramFile";
        String jreLoc = "-jreLoc";
        String cmdRestart = "";
        String cmdAppend = "";
        String startUpVal = "";
        String scratchPathVal = "";
        String installerVal = "";
        String commandLine = "";
        String JVMARGSCONSTANT = "-J";
        String jvmArgs = " ";
        boolean bParamFileFound = false;
        boolean bExtJreLocFound = false;
        boolean bIsWindows = false;
        String extJreProp = "-Doracle.installer.extjre=false";
        String startUpProp = "-Doracle.installer.startup_location=";
        if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -3) {
            bIsWindows = true;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-scratchPath")) {
                scratchPathVal = args[++i];
                cmdRestart = cmdRestart + DELIM + scratchPath + DELIM + scratchPathVal;
                continue;
            }
            if (args[i].startsWith(startUpProp)) {
                startUpVal = args[i].substring(args[i].indexOf("=") + 1);
                cmdRestart = cmdRestart + DELIM + startupLoc + DELIM + startUpVal;
                continue;
            }
            if (args[i].startsWith("-timestamp")) {
                cmdRestart = cmdRestart + DELIM + timestamp + DELIM + args[++i];
                continue;
            }
            if (args[i].startsWith("-jreLoc")) {
                bExtJreLocFound = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase(pf)) {
                paramFile = args[++i];
                continue;
            }
            cmdAppend = cmdAppend + DELIM + args[i];
        }
        if (OPatchBugID != -1) {
            File dest = new File(OiixPathOps.concatPath(scratchPathVal, OPATCH_DIR));
            String UPDATES_LOCATION = "Shiphome";
            String oPatchDownloadLoc = OiiiApplyUpdates.getLatestUpdatesLoc(downloadLoc, UPDATES_LOCATION);
            oPatchDownloadLoc = OiixPathOps.concatPath(oPatchDownloadLoc + File.separator + OPatchBugID, OPATCH_DIR);
            File src = new File(oPatchDownloadLoc);
            try {
                OiixFileOps.copyDir(src, dest);
            }
            catch (IOException e) {
                OiiolTextLogger.appendText("OPatch update failed to initialize");
            }
            cmdAppend = OPATCHUPDATE + DELIM + cmdAppend;
        }
        if (startUpVal.equalsIgnoreCase("")) {
            startUpVal = System.getProperty("oracle.installer.startup_location");
            cmdRestart = cmdRestart + DELIM + startupLoc + DELIM + startUpVal;
        }
        String ouiexec = null;
        if (ouiBugID != -1) {
            String res = this.findOUIDiskInStage(downloadLoc, ouiBugID);
            if (res == null) {
                OiiolTextLogger.appendText("OUI cd not found in downloaded stage");
                return false;
            }
            downloadLoc = OiixPathOps.concatPath(res, "install");
            m_ResponseDir = OiixPathOps.concatPath(res, STAGE + File.separator + RESPONSE);
            m_FromLocation = OiixPathOps.concatPath(res, STAGE + File.separator + PRODUCTS_XML);
            String tempINI = OiixPathOps.concatPath(scratchPathVal, temp_INI);
            try {
                OiixIniFile inNew = new OiixIniFile(OiixPathOps.concatPath(downloadLoc, "oraparam.ini"), true);
                inNew.readFile();
                OiixFileOps.copyFile(paramFile, tempINI, true);
                OiixIniFile inOld = new OiixIniFile(tempINI, true);
                inOld.readFile();
                this.checkAndAddToINI(inOld, inNew, "ORACLE", "JRE_LOCATION");
                this.checkAndAddToINI(inOld, inNew, "ORACLE", "OUI_VERSION");
                this.checkAndAddToINI(inOld, inNew, "ORACLE", "BOOTSTRAP_COMPS");
                this.checkAndAddToINI(inOld, inNew, "ORACLE", "ADDTO_CLASSPATH");
                inOld.writeFile();
            }
            catch (IOException e) {
                if (debug) {
                    OiiolTextLogger.appendException(e);
                }
                return false;
            }
            catch (OiifbCancelException e) {
                if (debug) {
                    OiiolTextLogger.appendException(e);
                }
                return false;
            }
            catch (OiixIniParsingException e) {
                if (debug) {
                    OiiolTextLogger.appendException(e);
                }
                return false;
            }
            catch (Exception e) {
                if (debug) {
                    OiiolTextLogger.appendException(e);
                }
                return false;
            }
            cmdAppend = DELIM + cmdAppend + DELIM + pf + DELIM + tempINI;
            cmdAppend = cmdAppend + DELIM + jreLoc + DELIM + System.getProperty("oracle.installer.jre_loc");
            if (bIsWindows) {
                ouiexec = "cmd" + DELIM + "/c" + DELIM + downloadLoc + File.separator + ouiexec_windows;
            } else {
                ouiexec = downloadLoc + File.separator + ouiexec_unix;
                String unzipexec = downloadLoc + File.separator + unzip;
                try {
                    OiixFileOps.setPermissions(ouiexec, "0755");
                    OiixFileOps.setPermissions(unzipexec, "0755");
                }
                catch (IOException e) {
                    OiiolTextLogger.appendException(e);
                }
            }
        } else {
            installerVal = System.getProperty("oracle.installer.installerLocation", startUpVal);
            ouiexec = bIsWindows ? "cmd" + DELIM + "/c" + DELIM + installerVal + File.separator + ouiexec_windows : installerVal + File.separator + ouiexec_unix;
            cmdAppend = DELIM + pf + DELIM + paramFile + DELIM + cmdAppend;
            cmdAppend = cmdAppend + DELIM + jreLoc + DELIM + System.getProperty("oracle.installer.jre_loc");
        }
        if (!bExtJreLocFound) {
            VMArgs.add(extJreProp);
        }
        if ((VMArgsLength = VMArgs.size()) > 0) {
            if (bIsWindows) {
                jvmArgs = jvmArgs + JVMARGSCONSTANT;
            }
            for (int i = 0; i < VMArgsLength; ++i) {
                jvmArgs = bIsWindows ? jvmArgs + VMArgs.get(i) + DELIM : jvmArgs + JVMARGSCONSTANT + VMArgs.get(i) + DELIM;
            }
        }
        commandLine = ouiBugID == -1 ? ouiexec + DELIM + cmdRestart + DELIM + RESTART + DELIM + cmdAppend + DELIM + jvmArgs : ouiexec + DELIM + cmdRestart + DELIM + RESTART + DELIM + OUIFROMLOCATION + DELIM + OiimUpdatesRestart.getOUIStageLocation() + DELIM + OUIRESPONSEFILE + DELIM + OiimUpdatesRestart.getOUIResponseFileLocation() + DELIM + cmdAppend + DELIM + jvmArgs;
        String[] cmdArgs = commandLine.split(DELIM);
        String cmdLineForDebug = commandLine.replaceAll(DELIM, " ");
        if (debug) {
            System.out.println(cmdLineForDebug);
        }
        OiiolTextLogger.appendText("RESTART:command line " + cmdLineForDebug);
        if (bIsWindows) {
            for (int i = 0; i < cmdArgs.length; ++i) {
                cmdArgs[i] = cmdArgs[i].trim();
                if (cmdArgs[i].startsWith("-J")) break;
                if (cmdArgs[i].indexOf(" ") == -1) continue;
                cmdArgs[i] = "\"" + cmdArgs[i] + "\"";
            }
        }
        if (bIsWindows) {
            int quoteArgument;
            for (int i = 0; i < cmdArgs.length; ++i) {
                if (cmdArgs[i].indexOf("/c") == -1) continue;
                cmdArgs[i] = cmdArgs[i] + "\"";
                break;
            }
            if (cmdArgs[cmdArgs.length - (quoteArgument = 1)] != null) {
                cmdArgs[cmdArgs.length - quoteArgument] = cmdArgs[cmdArgs.length - quoteArgument] + "\"";
            }
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            if (debug) {
                System.out.println("Command Line Arguments Passed Are");
                OiiolTextLogger.appendText("Command Line Arguments Passed Are");
            }
            for (int i = 0; i < cmdArgs.length; ++i) {
                if (cmdArgs[i] != null) {
                    cmdArgs[i] = cmdArgs[i].trim();
                }
                if (!debug) continue;
                System.out.println(cmdArgs[i]);
                OiiolTextLogger.appendText("cmdArgs[" + i + "]" + cmdArgs[i]);
            }
            Process process = runtime.exec(cmdArgs, null);
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
            errorGobbler.start();
            outputGobbler.start();
            if (!OiixInstallUtil.isWindows()) {
                process.waitFor();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            if (debug) {
                OiiolTextLogger.appendException(e);
            }
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.out);
            if (debug) {
                OiiolTextLogger.appendException(e);
            }
            return false;
        }
        return true;
    }

    private class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

