/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.NVPair;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import oracle.sysman.oii.oiim.OiimEMHTTPConnection;
import oracle.sysman.oii.oiim.OiimEMHTTPConstants;
import oracle.sysman.oii.oiim.OiimHTMLHelper;
import oracle.sysman.oii.oiim.OiimHTTPHelper;

public class OiimSSOAuthClientModule
implements HTTPClientModule {
    private static final String LOGIN_FORM_ACTION = "/sso/auth";
    private static final String CHANGE_PASSWORD_FORM_ACTION = "/sso/ChangePwdServlet";
    private static final String LOGIN_FORM_PARAM_NAME_USER_NAME = "ssousername";
    private static final String LOGIN_FORM_PARAM_NAME_PASSWORD = "password";
    private static final String[] LOGIN_PAGE_PARAMETERS = new String[]{"site2pstoretoken", "ssousername", "p_error_code", "p_cancel_url"};
    private static final String[] CHANGE_PWD_PAGE_PARAMETERS = new String[]{"p_username", "p_subscribername", "p_error_code", "p_done_url", "site2pstoretoken", "p_pwd_is_exp"};
    private static final String CHANGE_PWD_FORM_PARAM_NAME_ACTION = "p_action";
    private static final String PARAM_NAME_P_ERROR_CODE = "p_error_code";
    private static final String PARAM_NAME_P_PWD_IS_EXP = "p_pwd_is_exp";
    private static final String P_PWD_IS_EXP_WARN = "WARN";
    private static final String P_PWD_IS_EXP_FORCE = "FORCE";
    private static final String P_ACTION_OK = "OK";
    private static final String P_ACTION_CANCEL = "CANCEL";
    private static final String LOGIN_FAILURE_ERROR_MESSAGE_FORMAT = "<ssoAuthenticationFailure>\n    <errorCode>{0}</errorCode>\n    <errorDesc>{1}</errorDesc>\n</ssoAuthenticationFailure>";
    private String userName;
    private char[] password;
    private int loginAttempt = 0;
    private boolean returnGeneratedResponse = false;
    private String generatedResponse = null;

    public int requestHandler(Request request, Response[] responses) {
        if (this.returnGeneratedResponse) {
            NVPair[] headers = null;
            InputStream inputStream = null;
            byte[] data = this.generatedResponse.getBytes();
            responses[0] = new Response("HTTP/1.1", 409, "Conflict", headers, data, inputStream, data.length);
            return 4;
        }
        HTTPConnection conn = request.getConnection();
        if (this.userName == null && conn instanceof OiimEMHTTPConnection) {
            OiimEMHTTPConnection ssoConn = (OiimEMHTTPConnection)conn;
            this.userName = ssoConn.getUserName();
            this.password = ssoConn.getPassword();
        }
        return 0;
    }

    public void responsePhase1Handler(Response response, RoRequest roRequest) {
    }

    public int responsePhase2Handler(Response response, Request request) throws IOException {
        Map urlQueryParamsMap;
        String requestURI = request.getRequestURI();
        try {
            urlQueryParamsMap = OiimHTTPHelper.extractUriQueryParamsMap(requestURI);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        boolean isLoginPageRequest = this.isLoginPageRequest(urlQueryParamsMap);
        boolean isChangePasswordPageRequest = false;
        if (!isLoginPageRequest && this.loginAttempt > 0) {
            isChangePasswordPageRequest = this.isChangePasswordPageRequest(urlQueryParamsMap);
        }
        if (!isLoginPageRequest && !isChangePasswordPageRequest) {
            return 10;
        }
        if (isLoginPageRequest) {
            return this.handleLoginPage(response, request, urlQueryParamsMap);
        }
        if (isChangePasswordPageRequest) {
            return this.handleChangePasswordPage(response, request, urlQueryParamsMap);
        }
        return 10;
    }

    protected int handleLoginPage(Response response, Request request, Map urlQueryParamsMap) throws IOException {
        boolean isSSOAuthChallenge = false;
        String[] formData = null;
        String responseHTML = new String(response.getData());
        List formList = OiimHTMLHelper.extractFormElements(responseHTML);
        if (formList != null && formList.size() > 0) {
            for (int i = 0; i < formList.size(); ++i) {
                formData = (String[])formList.get(i);
                String action = formData[2];
                if (action.indexOf(LOGIN_FORM_ACTION) == -1) continue;
                isSSOAuthChallenge = true;
                break;
            }
        }
        if (isSSOAuthChallenge) {
            if (this.loginAttempt > 0) {
                this.generatedResponse = OiimSSOAuthClientModule.generateLoginFailureXML(urlQueryParamsMap);
                this.returnGeneratedResponse = true;
                return 15;
            }
            this.generateSSOLoginRequest(request, formData);
            ++this.loginAttempt;
            return 13;
        }
        return 10;
    }

    protected int handleChangePasswordPage(Response response, Request request, Map urlQueryParamsMap) throws IOException {
        boolean isChangePasswordForm = false;
        String[] formData = null;
        String responseHTML = new String(response.getData());
        List formList = OiimHTMLHelper.extractFormElements(responseHTML);
        if (formList != null && formList.size() > 0) {
            for (int i = 0; i < formList.size(); ++i) {
                formData = (String[])formList.get(i);
                String action = formData[2];
                if (action.indexOf(CHANGE_PASSWORD_FORM_ACTION) == -1) continue;
                isChangePasswordForm = true;
                break;
            }
        }
        if (isChangePasswordForm) {
            boolean passwordExpired = false;
            String pwdIsExp = (String)urlQueryParamsMap.get(PARAM_NAME_P_PWD_IS_EXP);
            if (pwdIsExp != null && pwdIsExp.equals(P_PWD_IS_EXP_FORCE)) {
                passwordExpired = true;
            }
            if (passwordExpired) {
                this.generatedResponse = OiimSSOAuthClientModule.generatePasswordExpiredXML();
                this.returnGeneratedResponse = true;
                return 15;
            }
            this.generateCancelChangePasswordRequest(request, formData);
            return 13;
        }
        return 10;
    }

    protected boolean isLoginPageRequest(Map queryParamsMap) {
        boolean requestContainsLoginPageParams = true;
        for (int i = 0; i < LOGIN_PAGE_PARAMETERS.length; ++i) {
            String paramName = LOGIN_PAGE_PARAMETERS[i];
            if (queryParamsMap.containsKey(paramName)) continue;
            requestContainsLoginPageParams = false;
            break;
        }
        return requestContainsLoginPageParams;
    }

    protected boolean isChangePasswordPageRequest(Map queryParamsMap) {
        boolean requestContainsChangePwdPageParams = true;
        for (int i = 0; i < CHANGE_PWD_PAGE_PARAMETERS.length; ++i) {
            String paramName = CHANGE_PWD_PAGE_PARAMETERS[i];
            if (queryParamsMap.containsKey(paramName)) continue;
            requestContainsChangePwdPageParams = false;
            break;
        }
        return requestContainsChangePwdPageParams;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) {
        this.userName = null;
        this.password = null;
    }

    public void trailerHandler(Response response, RoRequest roRequest) {
    }

    public void generateSSOLoginRequest(Request request, String[] formData) {
        List inputList = OiimHTMLHelper.extractInputElements(formData[0]);
        StringBuffer dataBuffer = new StringBuffer();
        for (int i = 0; i < inputList.size(); ++i) {
            String[] inputData = (String[])inputList.get(i);
            String name = inputData[2];
            String value = OiimHTTPHelper.encode(inputData[3]);
            if (LOGIN_FORM_PARAM_NAME_USER_NAME.equalsIgnoreCase(name)) {
                value = OiimHTTPHelper.encode(this.userName);
            } else if (LOGIN_FORM_PARAM_NAME_PASSWORD.equalsIgnoreCase(name)) {
                String valueBeforeEnc = new String(this.password);
                value = OiimHTTPHelper.encode(valueBeforeEnc);
            }
            if (dataBuffer.length() > 0) {
                dataBuffer.append("&");
            }
            dataBuffer.append(name).append("=").append(value);
        }
        request.setAllowUI(false);
        request.setMethod(formData[1].toUpperCase());
        request.setRequestURI(LOGIN_FORM_ACTION);
        NVPair contentType = OiimHTTPHelper.getFormURLEncodedContentType();
        NVPair[] headers = new NVPair[]{contentType};
        OiimHTTPHelper.setHTTPHeaders(request, headers);
        request.setData(dataBuffer.toString().getBytes());
        for (int i = 0; i < dataBuffer.length(); ++i) {
            dataBuffer.setCharAt(i, ' ');
        }
    }

    public void generateCancelChangePasswordRequest(Request request, String[] formData) {
        List inputList = OiimHTMLHelper.extractInputElements(formData[0]);
        StringBuffer dataBuffer = new StringBuffer();
        for (int i = 0; i < inputList.size(); ++i) {
            String[] inputData = (String[])inputList.get(i);
            String name = inputData[2];
            String value = OiimHTTPHelper.encode(inputData[3]);
            if (CHANGE_PWD_FORM_PARAM_NAME_ACTION.equalsIgnoreCase(name)) {
                value = P_ACTION_CANCEL;
            }
            if (dataBuffer.length() > 0) {
                dataBuffer.append("&");
            }
            dataBuffer.append(name).append("=").append(value);
        }
        request.setAllowUI(false);
        request.setMethod(formData[1]);
        request.setRequestURI(CHANGE_PASSWORD_FORM_ACTION);
        NVPair contentType = OiimHTTPHelper.getFormURLEncodedContentType();
        NVPair[] headers = new NVPair[]{contentType};
        OiimHTTPHelper.setHTTPHeaders(request, headers);
        request.setData(dataBuffer.toString().getBytes());
    }

    private static String generateLoginFailureXML(Map queryParamsMap) {
        String errorCode = (String)queryParamsMap.get(PARAM_NAME_P_ERROR_CODE);
        String errorMsg = null;
        if (errorCode != null) {
            errorMsg = (String)OiimEMHTTPConstants.LOGIN_PAGE_ERROR_CODES.get(errorCode);
        }
        if (errorMsg == null) {
            errorMsg = "Unknown Error";
        }
        String msg = MessageFormat.format(LOGIN_FAILURE_ERROR_MESSAGE_FORMAT, errorCode, errorMsg);
        return msg;
    }

    private static String generatePasswordExpiredXML() {
        String errorCode = "password_expired";
        String errorMsg = "The password has expired.";
        String msg = MessageFormat.format(LOGIN_FAILURE_ERROR_MESSAGE_FORMAT, errorCode, errorMsg);
        return msg;
    }
}

