/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.URI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Map;
import oracle.sysman.oii.oiim.OiimARUAuthException;
import oracle.sysman.oii.oiim.OiimARUConnection;
import oracle.sysman.oii.oiim.OiimHTTPHelper;
import oracle.sysman.oii.oiim.OiimSSOAuthClientModule;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OiimEMHTTPConnection
extends HTTPConnection {
    private static final String RETURN_DATA_TYPE_STRING = "string";
    private static final String RETURN_DATA_TYPE_INPUT_STREAM = "inputStream";
    private String userName;
    private char[] password;

    public OiimEMHTTPConnection(String host) {
        super(host);
        this.instanceCreated(null, null, null);
    }

    public OiimEMHTTPConnection(String host, String userName, char[] password, Object sharedContext) {
        super(host);
        this.instanceCreated(userName, password, sharedContext);
    }

    public OiimEMHTTPConnection(String host, int port) {
        super(host, port);
        this.instanceCreated(null, null, null);
    }

    public OiimEMHTTPConnection(String host, int port, String userName, char[] password, Object sharedContext) {
        super(host, port);
        this.instanceCreated(userName, password, sharedContext);
    }

    public OiimEMHTTPConnection(String protocol, String host, int port) throws ProtocolNotSuppException {
        super(protocol, host, port);
        this.instanceCreated(null, null, null);
    }

    public OiimEMHTTPConnection(String protocol, String host, int port, String userName, char[] password, Object sharedContext) throws ProtocolNotSuppException {
        super(protocol, host, port);
        this.instanceCreated(userName, password, sharedContext);
    }

    public OiimEMHTTPConnection(String protocol, String host, int port, InetAddress localAddr, int localPort) throws ProtocolNotSuppException {
        super(protocol, host, port, localAddr, localPort);
        this.instanceCreated(null, null, null);
    }

    public OiimEMHTTPConnection(String protocol, String host, int port, InetAddress localAddr, int localPort, String userName, char[] password, Object sharedContext) throws ProtocolNotSuppException {
        super(protocol, host, port, localAddr, localPort);
        this.instanceCreated(userName, password, sharedContext);
    }

    public OiimEMHTTPConnection(URI uri) throws ProtocolNotSuppException {
        super(uri);
        this.instanceCreated(null, null, null);
    }

    public OiimEMHTTPConnection(URI uri, String userName, char[] password, Object sharedContext) throws ProtocolNotSuppException {
        super(uri);
        this.instanceCreated(userName, password, sharedContext);
    }

    public OiimEMHTTPConnection(URL url) throws ProtocolNotSuppException {
        super(url);
        this.instanceCreated(null, null, null);
    }

    public OiimEMHTTPConnection(URL url, String userName, char[] password, Object sharedContext) throws ProtocolNotSuppException {
        super(url);
        this.instanceCreated(userName, password, sharedContext);
    }

    private void instanceCreated(String userName, char[] password, Object sharedContext) {
        this.userName = userName;
        this.password = password;
        this.addModule(OiimSSOAuthClientModule.class, -1);
        if (sharedContext != null && !"".equals(sharedContext)) {
            this.setContext(sharedContext);
        }
        OiimHTTPHelper.setDefaultHeaders(this);
        this.setAllowUserInteraction(false);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    protected String getUserName() {
        return this.userName;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    protected char[] getPassword() {
        return this.password;
    }

    public String doGet(String url) throws OiimARUAuthException, IOException, ModuleException {
        String data = null;
        data = this.doGet(url, null, null);
        return data;
    }

    public String doGet(String url, Map paramsMap, Map headersMap) throws OiimARUAuthException, IOException, ModuleException {
        return this.doGet(url, paramsMap, headersMap, null);
    }

    public String doGet(String url, Map paramsMap, Map headersMap, Map responseMetaData) throws OiimARUAuthException, IOException, ModuleException {
        String data = (String)this.sendRequest(url, paramsMap, headersMap, responseMetaData, "GET", RETURN_DATA_TYPE_STRING);
        return data;
    }

    public String doPost(String url) throws OiimARUAuthException, IOException, ModuleException {
        String data = this.doPost(url, null, null);
        return data;
    }

    public String doPost(String url, Map paramsMap, Map headersMap) throws OiimARUAuthException, IOException, ModuleException {
        return this.doPost(url, paramsMap, headersMap, null);
    }

    public String doPost(String url, Map paramsMap, Map headersMap, Map responseMetaData) throws OiimARUAuthException, IOException, ModuleException {
        String data = (String)this.sendRequest(url, paramsMap, headersMap, responseMetaData, "POST", RETURN_DATA_TYPE_STRING);
        return data;
    }

    public InputStream doGetAsInputStream(String url) throws OiimARUAuthException, IOException, ModuleException {
        InputStream inputStream = this.doGetAsInputStream(url, null, null);
        return inputStream;
    }

    public InputStream doGetAsInputStream(String url, Map paramsMap, Map headersMap) throws OiimARUAuthException, IOException, ModuleException {
        InputStream inputStream = this.doGetAsInputStream(url, paramsMap, headersMap, null);
        return inputStream;
    }

    public InputStream doGetAsInputStream(String url, Map paramsMap, Map headersMap, Map responseMetaData) throws OiimARUAuthException, IOException, ModuleException {
        InputStream data = (InputStream)this.sendRequest(url, paramsMap, headersMap, responseMetaData, "GET", RETURN_DATA_TYPE_INPUT_STREAM);
        return data;
    }

    public InputStream doPostAsInputStream(String url) throws OiimARUAuthException, IOException, ModuleException {
        return this.doPostAsInputStream(url, null, null);
    }

    public InputStream doPostAsInputStream(String url, Map paramsMap, Map headersMap) throws OiimARUAuthException, IOException, ModuleException {
        return this.doPostAsInputStream(url, paramsMap, headersMap, null);
    }

    public InputStream doPostAsInputStream(String url, Map paramsMap, Map headersMap, Map responseMetaData) throws OiimARUAuthException, IOException, ModuleException {
        InputStream data = (InputStream)this.sendRequest(url, paramsMap, headersMap, responseMetaData, "POST", RETURN_DATA_TYPE_INPUT_STREAM);
        return data;
    }

    protected void transferToOutputStream(InputStream inStream, OutputStream outStream) throws IOException {
        int bytesRead = 0;
        byte[] bytes = new byte[2048];
        do {
            if ((bytesRead = inStream.read(bytes)) <= 0) continue;
            outStream.write(bytes, 0, bytesRead);
        } while (bytesRead > 0);
        outStream.close();
    }

    protected String getResponseAsString(HTTPResponse response) throws IOException, ModuleException, OiimARUAuthException {
        this.validateResponse(response);
        try {
            return response.getText();
        }
        catch (ParseException e) {
            throw new IOException("Unable to get text response: " + e.getMessage());
        }
    }

    protected InputStream getResponseAsInputStream(HTTPResponse response) throws IOException, ModuleException, OiimARUAuthException {
        this.validateResponse(response);
        InputStream data = response.getInputStream();
        return data;
    }

    protected void validateResponse(HTTPResponse response) throws IOException, ModuleException, OiimARUAuthException {
        if (response.getStatusCode() != 200) {
            OiimARUConnection.checkStatusCodeAndThrowException(response.getStatusCode());
        }
    }

    public String doUpload(String url, InputStream inStream, int uploadSize) throws OiimARUAuthException, IOException, ModuleException {
        return this.doUpload(url, inStream, uploadSize, null);
    }

    public String doUpload(String url, InputStream inStream, int uploadSize, Map headersMap) throws OiimARUAuthException, IOException, ModuleException {
        return this.doUpload(url, inStream, uploadSize, headersMap, null);
    }

    public String doUpload(String url, InputStream inStream, int uploadSize, Map headersMap, Map responseMetaData) throws OiimARUAuthException, IOException, ModuleException {
        String data = (String)this.sendRequestUsingOutputStream(url, inStream, uploadSize, headersMap, responseMetaData, RETURN_DATA_TYPE_STRING);
        return data;
    }

    public InputStream doUploadAsInputStream(String url, InputStream inStream, int uploadSize) throws OiimARUAuthException, IOException, ModuleException {
        return this.doUploadAsInputStream(url, inStream, uploadSize, null);
    }

    public InputStream doUploadAsInputStream(String url, InputStream inStream, int uploadSize, Map headersMap) throws OiimARUAuthException, IOException, ModuleException {
        return this.doUploadAsInputStream(url, inStream, uploadSize, headersMap, null);
    }

    public InputStream doUploadAsInputStream(String url, InputStream inStream, int uploadSize, Map headersMap, Map responseMetaData) throws OiimARUAuthException, IOException, ModuleException {
        InputStream data = (InputStream)this.sendRequestUsingOutputStream(url, inStream, uploadSize, headersMap, responseMetaData, RETURN_DATA_TYPE_INPUT_STREAM);
        return data;
    }

    protected void populateResponseMetaDataMap(Map responseMetaData, HTTPResponse response) throws IOException, ModuleException {
        String contentType = response.getHeader("Content-Type");
        String contentDisposition = response.getHeader("Content-Disposition");
        responseMetaData.put("Content-Type", contentType);
        if (contentDisposition != null) {
            responseMetaData.put("Content-Disposition", contentDisposition);
        }
    }

    protected Object sendRequest(String url, Map paramsMap, Map headersMap, Map responseMetaData, String method, String returnDataType) throws OiimARUAuthException, ModuleException, IOException {
        HTTPResponse response;
        NVPair[] formData = OiimHTTPHelper.getNVPairs(paramsMap);
        NVPair[] headers = OiimHTTPHelper.getNVPairs(headersMap);
        if ("GET".equalsIgnoreCase(method)) {
            OiiolTextLogger.appendText("GET  " + url + "?" + formData.toString());
            response = super.Get(url, formData, headers);
        } else if ("POST".equalsIgnoreCase(method)) {
            OiiolTextLogger.appendText("POST " + url + "?" + formData.toString());
            response = super.Post(url, formData, headers);
        } else {
            throw new RuntimeException("Unsupported method: " + method);
        }
        Object data = this.getResponse(response, returnDataType, responseMetaData);
        return data;
    }

    protected Object sendRequestUsingOutputStream(String url, InputStream inStream, int uploadSize, Map headersMap, Map responseMetaData, String returnDataType) throws OiimARUAuthException, ModuleException, IOException {
        HttpOutputStream outStream = uploadSize > 0 ? new HttpOutputStream(uploadSize) : new HttpOutputStream();
        NVPair[] headers = OiimHTTPHelper.getNVPairs(headersMap);
        HTTPResponse response = this.Post(url, outStream, headers);
        this.transferToOutputStream(inStream, (OutputStream)outStream);
        Object data = this.getResponse(response, returnDataType, responseMetaData);
        return data;
    }

    protected Object getResponse(HTTPResponse response, String returnDataType, Map respMetaDataMap) throws IOException, ModuleException, OiimARUAuthException {
        Object data;
        if (RETURN_DATA_TYPE_STRING.equalsIgnoreCase(returnDataType)) {
            data = this.getResponseAsString(response);
        } else if (RETURN_DATA_TYPE_INPUT_STREAM.equalsIgnoreCase(returnDataType)) {
            data = this.getResponseAsInputStream(response);
        } else {
            throw new RuntimeException("Unknown Return Type:" + returnDataType);
        }
        if (respMetaDataMap != null) {
            this.populateResponseMetaDataMap(respMetaDataMap, response);
        }
        return data;
    }
}

