/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import java.io.File;
import java.util.ArrayList;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiim.OiimARUConnection;
import oracle.sysman.oii.oiim.OiimDownloadProgressStatusHolder;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFileOps;

public class OiimDownloadThread
implements Runnable {
    private OiimARUConnection aruConn;
    private String destDir;
    private ArrayList patchUrls;
    private OiimDownloadProgressStatusHolder dps;
    private ArrayList m_bids;

    public OiimDownloadThread(OiimARUConnection c, String dest, ArrayList urls, OiimDownloadProgressStatusHolder dp, ArrayList bids) {
        this.aruConn = c;
        this.destDir = dest;
        this.patchUrls = urls;
        this.dps = dp;
        this.m_bids = bids;
    }

    @Override
    public void run() {
        int i;
        for (i = 0; i < this.patchUrls.size() && this.dps.getStatus() != 4L; ++i) {
            String aruPatchUrl = (String)this.patchUrls.get(i);
            String string = this.aruConn.startDownload(this.aruConn, this.aruConn.getaruUrl(), aruPatchUrl, this.destDir, this.dps);
        }
        if (this.dps.getStatus() != 4L) {
            this.dps.setStatus(2);
            this.aruConn.unzipZipsInDir(new File(this.destDir));
            for (i = 0; i < this.m_bids.size(); ++i) {
                OiiiPatchMetadata pm = (OiiiPatchMetadata)this.m_bids.get(i);
                String bugNumberAsString = Integer.toString(pm.getPatchBugNumber());
                String loc = this.destDir + File.separator + bugNumberAsString;
                File getDir = new File(loc);
                String[] oneOffLoc = getDir.list();
                if (oneOffLoc == null) {
                    this.cleanUp();
                    this.dps.setStatus(5);
                    return;
                }
                int j = 0;
                for (j = 0; j < oneOffLoc.length; ++j) {
                    loc = getDir.getAbsolutePath() + File.separator + oneOffLoc[j];
                    File f = new File(loc);
                    if (!f.isDirectory()) continue;
                    pm.setDownloadLocation(loc);
                    break;
                }
                if (j != oneOffLoc.length) continue;
                pm.setDownloadLocation("");
            }
            this.dps.setStatus(3);
        } else {
            OiiolTextLogger.appendText("Download failed...\nDeleting the downloaded patches. Removing directory " + this.destDir);
            this.cleanUp();
        }
    }

    public void cleanUp() {
        this.dps.setStatus(4);
        OiixFileOps.recdelete(new File(this.destDir));
    }
}

