/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import HTTPClient.AuthorizationInfo;
import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpURLConnection;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiii.OiiiPlaceHolderAuthenticate;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiim.OiimARUAuthException;
import oracle.sysman.oii.oiim.OiimARUConnection;
import oracle.sysman.oii.oiim.OiimARUPatchData;
import oracle.sysman.oii.oiim.OiimChangePasswordException;
import oracle.sysman.oii.oiim.OiimDownloadProgressStatusHolder;
import oracle.sysman.oii.oiim.OiimDownloadThread;
import oracle.sysman.oii.oiim.OiimEMHTTPConnection;
import oracle.sysman.oii.oiim.OiimEMHTTPException;
import oracle.sysman.oii.oiim.OiimHTTPHelper;
import oracle.sysman.oii.oiim.OiimHTTPProxyUtil;
import oracle.sysman.oii.oiim.OiimLoginFailureException;
import oracle.sysman.oii.oiim.OiimMOSCsi;
import oracle.sysman.oii.oiim.OiimMOSException;
import oracle.sysman.oii.oiim.OiimMOSState;
import oracle.sysman.oii.oiim.OiimMOSUser;
import oracle.sysman.oii.oiim.OiimSSOAuthenticationFailure;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixGeneralQueries;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixRegistryOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixZipInputStream;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sun.misc.BASE64Encoder;

public class OiimARUOrionConnection
extends OiimARUConnection {
    private String m_aruUrl = null;
    private String m_encoding = null;
    private String m_mosUsername = null;
    private String m_mosPassword = null;
    private static OiimHTTPProxyUtil m_proxy;
    private static final String S_HTML_BEGIN = "<HTML";
    private static final String S_TITLE_BEGIN = "<TITLE>";
    private static final String S_TITLE_END = "</TITLE>";
    public static final int ARU_ORION_PATCH_QUERY_API = 0;
    public static final int ARU_ORION_PATCH_DOWNLOAD_API = 1;
    public static final int ARU_ORION_PATCH_README_API = 2;
    public static final int ARU_ORION_PRODUCTS_API = 3;
    public static final int ARU_ORION_RELEASES_API = 4;
    public static final int ARU_ORION_PLATFORMS_API = 5;
    public static final int ARU_ORION_LANGUAGES_API = 6;
    public static final int ARU_ORION_PRODUCT_GROUPS_API = 7;
    public static final int ARU_ORION_PRODUCT_RELEASES_API = 8;
    public static final int ARU_ORION_OUI_COMPONENTS_API = 9;
    public static final int ARU_ORION_BUG_ADVISORIES_API = 10;
    public static final int ARU_ORION_ID_SEARCH_API = 11;
    public static final int ARU_ORION_TABLE_SIZE = 12;
    public static final String[] s_aruOrionConnectionLookup;
    public static final int ARU_PATCH_QUERY_API = 0;
    public static final int ARU_PATCH_DOWNLOAD_API = 1;
    public static final int ARU_PATCH_README_API = 2;
    public static final int ARU_PRODUCTS_API = 3;
    public static final int ARU_RELEASES_API = 4;
    public static final int ARU_PLATFORMS_API = 5;
    public static final int ARU_LANGUAGES_API = 6;
    public static final int ARU_PRODUCT_GROUPS_API = 7;
    public static final int ARU_PRODUCT_RELEASES_API = 8;
    public static final int ARU_OUI_COMPONENTS_API = 9;
    public static final int ARU_BUG_ADVISORIES_API = 10;
    public static final int ARU_TABLE_SIZE = 11;
    private static final String[] s_aruDirectoryLookup;
    private static final String[] s_OiimARUOrionConnectionLookup;
    private ArrayList m_errorList = new ArrayList();
    private static final String DEFAULT_PROXY_PORT = "80";
    private static final String PLATFORM_PROP = "&platform=";
    private static final String LANGUAGE_PROP = "&language=";
    private static final String RELEASE_PROP = "&release=";
    private static final String PATCH_TYPE_PROP = "&patch_type=";
    private static final String BEGIN_TIME_PROP = "&begin_time=";
    private static final String END_TIME_PROP = "&end_time=";
    private static final String PRODUCT_FAMILY_PROP = "&product_family=";
    private static final String PRODUCT_PROP = "&product=";
    private static final String BUG_PROP = "&bug=";
    private static final String ARUID_PROP = "&aru=";
    private static final String EMAIL_PROP = "?email=test.user@oracle.com&userid=test";
    private static final String DOWNLOAD_SEED = "download_seed_data";
    private static final String PRODUCT_ID_TAG = "product_id";
    private static final String PRODUCT_NAME_TAG = "product_name";
    private static final String PLATFORM_ID_TAG = "platform_id";
    private static final String PLATFORM_NAME_TAG = "platform_name";
    private static final String RELEASE_ID_TAG = "release_id";
    private static final String RELEASE_NAME_TAG = "release_name";
    private static final String LANGUAGE_ID_TAG = "language_id";
    private static final String LANGUAGE_NAME_TAG = "nls_language";
    private static final String GROUP_PRODUCT_ID_TAG = "ap1.product_id";
    private static final String GROUP_MEMBER_ID_TAG = "ap2.product_id";
    private static final String RELEASE_PRODUCT_ID_TAG = "ap.product_id";
    private static final String RELEASE_RELEASE_ID_TAG = "ar.release_id";
    private static final String FULL_DATE_FORMAT = "yyyy:MM:dd:HH:mm:ss";
    private static final String PATCH_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String ALL_PATCHES = "all";
    public static final String PATCH_PATCHES = "patch";
    public static final String PATCHSET_PATCHES = "patchset";
    private static final String ERROR_TAG = "error";
    private static final String PATCH_TAG = "patch";
    private static final String TOTAL_TAG = "total";
    private static final String RESULTS_TAG = "results";
    private static final String DATE_TAG = "date";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TYPE_TAG = "type";
    private static final String PRODUCT_TAG = "product";
    private static final String STATUS_TAG = "status";
    private static final String ABSTRACT_TAG = "abstract";
    private static final String COMMENTS_TAG = "comments";
    private static final String BUG_TAG = "bug";
    private static final String PLATFORM_TAG = "platform";
    private static final String LANGUAGE_TAG = "language";
    private static final String RELEASE_TAG = "release";
    private static final String README_URL_TAG = "readme_url";
    private static final String PATCH_URL_TAG = "patch_url";
    private static final String SIZE_TAG = "size";
    private static final String FILES_TAG = "files";
    private static final String URL_TAG = "url";
    private static final String PATCH_README_TAG = "patch_readme";
    private static final String NUMBER_TAG = "number";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ACCESS_TAG = "access";
    private static final String UPDATE_DATE_TAG = "updated_date";
    private static final String REQUEST_ID_TAG = "request_id";
    private static final String FILE_TAG = "file";
    private static final String DOWNLOAD_URL_TAG = "download_url";
    private static final String DIGEST_TAG = "digest";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String OUI_COMPONENT_ID_TAG = "component_release";
    private static final String OUI_COMPONENT_NAME_TAG = "component_name";
    private static final String OUI_COMPONENT_RELEASE_TAG = "release_name";
    private static final String ADV_PATCHES_TAG = "patches";
    private static final String ADV_BUGS_TAG = "bugs";
    private static final String ADV_ADVISORIES_TAG = "advisories";
    private static final String ADV_ADVISORY_TAG = "advisory";
    private static final String ADV_PATCH_TAG = "patch";
    private static final String ADV_ID_TAG = "id";
    private static final String ADV_VERSION_TAG = "version";
    private static final String ADV_IMPACT_TAG = "impact";
    private static final String ADV_SEVERITY_TAG = "severity";
    private static final String ADV_URL_TAG = "url";
    private static final String ADV_ABSTRACT_TAG = "abstract";
    private static final String ADV_ADVISORY_NAME_TAG = "name";
    private static final String ADV_RELEASE_DATE_TAG = "release_date";
    private static final String FIXES_BUGS_TAG = "fixes_bugs";
    private static final String ADV_FIXESBUG_TAG = "fixesbug";
    private static final String ADV_COMPONENTS_TAG = "components";
    private static final String ADV_COMPONENT_RELEASE_TAG = "component_release";
    private static final String ADV_BUG_TAG = "bug";
    private static final String ADV_RELEASE_TAG = "release";
    private static final String ADV_PLATFORMS_TAG = "platforms";
    private static final String ADV_PLATFORM_TAG = "platform";
    private static final String ADV_PRODUCT_TAG = "product";
    private static final String ADV_LANGUAGE_TAG = "language";
    private static final String ADV_TYPE_TAG = "type";
    public static final String S_METALINK_URL = "http://updates.oracle.com";
    public static final String S_METALINK_URL_HTTPS = "https://updates.oracle.com";
    public static final String HTTPS_PROT = "https";
    public static final Object PATCH_CONTEXT;
    private static final String S_SEARCH_ERROR = "Search ERROR:";
    public static final int PATCH_TO_DOWNLOAD = 1390304;
    public static final int HTTP_OK = 200;
    public static final String CHARACTER_ENCODING = "UTF-8";
    public static final String METALINK_REALM = "Metalink";
    public static final String HTTP_PROXY_VAR = "HTTP_PROXY";
    private static boolean debug;
    public static OiimARUOrionConnection aruConnSingleton;
    public static final String SYSTEM_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    public static final String HTTPCLIENT_PROTOCOL_HANDLER = "HTTPClient";
    private static HashMap m_threadList;
    private static final String LOGIN_URI = "/CSP/login";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private static final String RETURN_DATA_TYPE_STRING = "string";
    private static final String RETURN_DATA_TYPE_INPUT_STREAM = "inputStream";
    private static final String USER_TAG = "user";
    private static final String CSILIST_TAG = "csiList";
    private static final String CSI_TAG = "csi";
    private static final String PRIV_TAG = "priv";
    private static final String USERINFO_TAG = "userInfo";
    private static final String PRIVLIST_TAG = "privList";
    private static final String ATTR_EMAIL = "email";
    private static final String ATTR_USER_ID = "id";
    private static final String ATTR_FIRST_NAME = "first_name";
    private static final String ATTR_LAST_NAME = "last_name";
    private static final String ATTR_CONTACT_NAME = "contact_name";
    private static final String ATTR_STREET_1 = "street1";
    private static final String ATTR_STREET_2 = "street2";
    private static final String ATTR_CITY = "city";
    private static final String ATTR_STATE = "state";
    private static final String ATTR_ZIP_CODE = "zipcode";
    private static final String ATTR_COUNTRY = "country";
    private static final String ATTR_PHONE = "phone";
    private static final String ATTR_FAX = "fax";
    private static final String ATTR_SUPPORTID = "support_id";
    private static final String ATTR_ORG_ID = "orgID";
    private static final String ATTR_CREATE_SR = "createSR";
    private static final String ATTR_CODE = "code";
    private static final String CODE_ADM = "ADM";
    private static final String CODE_PAS = "PAS";
    private static final String ATTR_AUTH_CODE = "authCode";
    private static final String AUTH_CODE_LOGIN_SUCCESS = "0";
    private static final String ATTR_MESSAGE = "message";
    public static HashMap authenticatedConn;

    public static OiimEMHTTPConnection getAuthenticatedConn(String host) {
        return (OiimEMHTTPConnection)((Object)authenticatedConn.get(host));
    }

    public static void setAuthenticatedConn(String urlHost, OiimEMHTTPConnection conn) {
        authenticatedConn.put(urlHost, conn);
    }

    private OiimARUOrionConnection(String aruUrl, String mosUsername, String mosPassword) {
        this.OiimARUOrionConnection(aruUrl, mosUsername, mosPassword);
    }

    private void OiimARUOrionConnection(String aruUrl, String mosUsername, String mosPassword) {
        this.m_aruUrl = aruUrl;
        this.m_encoding = OiimARUOrionConnection.encodeAuthorization(mosUsername, mosPassword);
        this.m_mosUsername = mosUsername;
        this.m_mosPassword = mosPassword;
    }

    @Override
    public ArrayList getPatchData(int bugNo, int platform, int language, int release, String patch_type) throws SAXException, IOException, java.text.ParseException, OiimARUAuthException {
        String url = this.getUrl(bugNo, platform, language, release, patch_type, this.m_aruUrl);
        return this.getPatchData(url, patch_type);
    }

    private static String checkXMLoutput(String xmlString) {
        String errorOutput = null;
        if (xmlString.startsWith(S_SEARCH_ERROR)) {
            errorOutput = xmlString;
        } else if (xmlString.indexOf(S_HTML_BEGIN) != -1 || xmlString.indexOf(S_HTML_BEGIN.toLowerCase()) != -1) {
            int endIndex;
            int startIndex = xmlString.indexOf(S_TITLE_BEGIN);
            if (startIndex == -1) {
                startIndex = xmlString.indexOf(S_TITLE_BEGIN.toLowerCase());
            }
            if ((endIndex = xmlString.indexOf(S_TITLE_END)) == -1) {
                endIndex = xmlString.indexOf(S_TITLE_END.toLowerCase());
            }
            if (startIndex != -1 && endIndex > startIndex) {
                errorOutput = xmlString.substring(startIndex + 7, endIndex).trim();
                if (errorOutput.startsWith("502") || errorOutput.startsWith("503") || errorOutput.startsWith("504") || errorOutput.startsWith("404")) {
                    String toLog = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "ERRMSG_ARUCONNECTSETUP");
                    OiiolTextLogger.appendText(toLog);
                } else if (errorOutput.indexOf("Invalid Login") != -1) {
                    String toLog = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "ARU_MISSING_CREDENTIALS");
                    OiiolTextLogger.appendText(toLog);
                } else {
                    errorOutput = xmlString;
                }
            } else {
                errorOutput = xmlString;
            }
        }
        return errorOutput;
    }

    private ArrayList getPatchData(String url, String patch_type) throws SAXException, IOException, java.text.ParseException, OiimARUAuthException {
        ArrayList<OiimARUPatchData> patchList = new ArrayList<OiimARUPatchData>();
        OiimARUPatchData patchData = null;
        String xmlString = this.getPatchUrlXML(url);
        String errorOutput = OiimARUOrionConnection.checkXMLoutput(xmlString);
        if (errorOutput != null) {
            this.m_errorList.add(errorOutput);
            return null;
        }
        XMLDocument theXMLDoc = OiimARUOrionConnection.parseString(xmlString);
        if (theXMLDoc.hasChildNodes()) {
            Node firstChild = theXMLDoc.getFirstChild();
            if (firstChild.getNodeName().equals(RESULTS_TAG)) {
                Node firstNode = firstChild.getFirstChild();
                if (firstNode.getNodeName().equals(ERROR_TAG)) {
                    NodeList nl = firstNode.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node err = nl.item(i);
                        if (err == null) continue;
                        this.m_errorList.add(err.getNodeValue());
                        OiiolTextLogger.appendText(err.getNodeValue());
                    }
                    return null;
                }
                boolean showAll = true;
                if (patch_type != null && patch_type.equals("patch")) {
                    showAll = false;
                }
                NodeList nl = firstChild.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node patchNode = nl.item(i);
                    if (!patchNode.getNodeName().equals("patch")) continue;
                    try {
                        patchData = OiimARUOrionConnection.getPatchDataFromXMLDoc(patchNode);
                    }
                    catch (Exception e) {
                        OiiolTextLogger.appendErrorText(e.getMessage());
                    }
                    if (debug) {
                        OiiolTextLogger.appendText("aruId = " + patchData.getAruId() + ": bugNo=" + patchData.getBugNo());
                    } else {
                        OiiolTextLogger.appendText("debug was not enabled ...aruId = " + patchData.getAruId() + ": bugNo=" + patchData.getBugNo());
                    }
                    if (!showAll && !patchData.getType().equalsIgnoreCase(patch_type)) continue;
                    patchList.add(patchData);
                }
            } else {
                throw new IOException("The xml string is not started from results tag : " + xmlString);
            }
        }
        return patchList;
    }

    private String getUrl(int bugNo, int platform, int language, int release, String patch_type, String aruUrl) {
        String platformArg = "";
        String languageArg = "";
        String releaseArg = "";
        String patchTypeArg = "";
        if (platform != -1) {
            platformArg = PLATFORM_PROP + platform;
        }
        if (language != -1) {
            languageArg = LANGUAGE_PROP + language;
        }
        if (release != -1) {
            releaseArg = RELEASE_PROP + release;
        }
        if (patch_type != null && patch_type.trim().length() > 0) {
            patchTypeArg = PATCH_TYPE_PROP + patch_type;
        }
        return aruUrl + s_aruOrionConnectionLookup[0] + BUG_PROP + bugNo + platformArg + languageArg + releaseArg + patchTypeArg;
    }

    private String getPatchUrlXML(String urlString) throws OiimARUAuthException {
        String stsText = null;
        try {
            URL url = new URL(urlString);
            OiiolTextLogger.appendText("lookupURL: " + url);
            OiimEMHTTPConnection conn = this.getNewEMHTTPConnection(url);
            stsText = this.getPatchUrlXML(urlString, conn);
        }
        catch (Throwable e) {
            OiimARUOrionConnection.throwExceptionObject(e);
        }
        return stsText;
    }

    @Override
    public boolean downloadARUData(String directory_path) throws IOException {
        if (!new File(directory_path).exists()) {
            new File(directory_path).mkdirs();
        }
        return this.downloadARUData(9, directory_path) && this.downloadARUData(10, directory_path) && this.downloadARUData(4, directory_path);
    }

    @Override
    public boolean removeARUData(String directory_path) {
        boolean ret = this.removeARUData(directory_path, false);
        return ret;
    }

    @Override
    public boolean removeARUData(String directory_path, boolean removeDirectory) {
        File delDir;
        boolean ret = true;
        for (int i = 3; i <= 10; ++i) {
            File delFile = new File(OiixPathOps.concatPath(directory_path, s_aruDirectoryLookup[i]));
            if (!delFile.exists() || delFile.delete()) continue;
            OiiolTextLogger.appendText("Failed to delete File at " + delFile.getAbsolutePath());
            ret = false;
        }
        if (removeDirectory && !(delDir = new File(directory_path)).delete()) {
            OiiolTextLogger.appendText("Failed to delete directory at " + delDir.getAbsolutePath());
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean downloadARUData(int whereIdx, String directory_path) throws IOException {
        InputStream result = null;
        OutputStreamWriter fos = null;
        try {
            OiimARUOrionConnection aruConn = OiimARUOrionConnection.getAruOrionConnection();
            if (aruConn == null) {
                boolean bl = false;
                return bl;
            }
            URL url = new URL(aruConn.getaruUrl() + s_OiimARUOrionConnectionLookup[whereIdx]);
            boolean isSecured = url.getProtocol().equalsIgnoreCase(HTTPS_PROT);
            if (isSecured) {
                try {
                    result = aruConn.getNewEMHTTPConnection(url).Get(url.getFile()).getInputStream();
                }
                catch (ModuleException m) {
                    HttpURLConnection connection = new HttpURLConnection(url);
                    aruConn.authentication(connection);
                    result = connection.getInputStream();
                }
            } else {
                HttpURLConnection connection = new HttpURLConnection(url);
                aruConn.authentication(connection);
                result = connection.getInputStream();
            }
            InputStreamReader isr = new InputStreamReader(result);
            BufferedReader br = new BufferedReader(isr);
            File outFile = new File(directory_path, s_aruDirectoryLookup[whereIdx]);
            fos = new FileWriter(outFile);
            BufferedWriter bw = new BufferedWriter(fos);
            String line = null;
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
        catch (Exception e) {
            if (debug) {
                OiiolTextLogger.appendException(e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return true;
    }

    public static String getReadmeContents(OiimARUOrionConnection aruConn, String urlString) throws IOException {
        URL url = new URL(urlString);
        InputStream result = null;
        boolean isSecured = url.getProtocol().equalsIgnoreCase(HTTPS_PROT);
        if (isSecured) {
            try {
                result = aruConn.getNewEMHTTPConnection(url).Get(url.getFile()).getInputStream();
            }
            catch (ModuleException m) {
                HttpURLConnection connection = new HttpURLConnection(url);
                aruConn.authentication(connection);
                result = connection.getInputStream();
            }
        } else {
            HttpURLConnection connection = new HttpURLConnection(url);
            aruConn.authentication(connection);
            result = connection.getInputStream();
        }
        if (result == null) {
            return "";
        }
        InputStreamReader isr = new InputStreamReader(result);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.toLowerCase().indexOf("charset=") >= 0) continue;
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void authentication(HttpURLConnection urlCon) {
        urlCon.setRequestProperty("Authorization", this.m_encoding);
    }

    public static void authenticate(String mosUsername, String mosPassword, String url) throws OiimARUAuthException {
        try {
            URL authURL = new URL(url + s_aruOrionConnectionLookup[3]);
            OiimEMHTTPConnection conn = OiimARUOrionConnection.getNewEMHTTPConnection(authURL, mosUsername, mosPassword);
            CookieModule.discardAllCookies();
            conn.doGet(authURL.getFile());
            OiimARUOrionConnection.setAuthenticatedConn(authURL.getHost(), conn);
        }
        catch (Throwable e) {
            OiimARUOrionConnection.throwExceptionObject(e);
        }
    }

    private static XMLDocument parseString(String xmlString) throws SAXException, IOException {
        XMLDocument theXMLDoc = null;
        DOMParser theParser = new DOMParser();
        ByteArrayInputStream theStream = new ByteArrayInputStream(xmlString.getBytes());
        theParser.parse((InputStream)theStream);
        theXMLDoc = theParser.getDocument();
        return theXMLDoc;
    }

    private static long parseLong(String longStr) {
        long longVal = -1L;
        try {
            if (longStr != null && longStr.trim().length() > 0) {
                longVal = Long.parseLong(longStr.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return longVal;
    }

    private static OiimARUPatchData getPatchDataFromXMLDoc(Node node) throws java.text.ParseException {
        HashMap<String, Node> hm = new HashMap<String, Node>();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            hm.put(child.getNodeName(), child);
        }
        String dateStr = OiimARUOrionConnection.getFieldValue(hm, UPDATE_DATE_TAG);
        SimpleDateFormat df = new SimpleDateFormat(PATCH_DATE_FORMAT, Locale.US);
        Timestamp date = new Timestamp(df.parse(dateStr).getTime());
        long aruId = OiimARUOrionConnection.parseLong(OiimARUOrionConnection.getFieldValue(hm, REQUEST_ID_TAG));
        String type = OiimARUOrionConnection.getFieldValue(hm, "type");
        long product = -1L;
        String productName = null;
        Node productNode = (Node)hm.get("product");
        if (productNode != null) {
            product = OiimARUOrionConnection.parseLong(OiimARUOrionConnection.getNodeAttribute(productNode, "id"));
            productName = OiimARUOrionConnection.getFirstChildNodeValue(productNode);
        }
        String status = OiimARUOrionConnection.getFieldValue(hm, STATUS_TAG);
        String access = OiimARUOrionConnection.getFieldValue(hm, ACCESS_TAG);
        long bugNo = -1L;
        String abs = null;
        Node bugNode = (Node)hm.get("bug");
        if (bugNode != null) {
            NodeList cnl = bugNode.getChildNodes();
            for (int i = 0; i < cnl.getLength(); ++i) {
                Node child = cnl.item(i);
                if (NUMBER_TAG.equals(child.getNodeName())) {
                    bugNo = OiimARUOrionConnection.parseLong(child.getFirstChild().getNodeValue().trim());
                }
                if (!"abstract".equals(child.getNodeName())) continue;
                abs = child.getFirstChild().getNodeValue().trim();
            }
        }
        String comments = null;
        long platform = -1L;
        String platformName = null;
        Node platformNode = (Node)hm.get("platform");
        if (platformNode != null) {
            platform = OiimARUOrionConnection.parseLong(OiimARUOrionConnection.getNodeAttribute(platformNode, "id"));
            platformName = OiimARUOrionConnection.getFirstChildNodeValue(platformNode);
        }
        long language = -1L;
        String languageName = null;
        Node languageNode = (Node)hm.get("language");
        if (languageNode != null) {
            language = OiimARUOrionConnection.parseLong(OiimARUOrionConnection.getNodeAttribute(languageNode, "id"));
            languageName = OiimARUOrionConnection.getFirstChildNodeValue(languageNode);
        }
        long releaseId = -1L;
        String release = null;
        Node releaseNode = (Node)hm.get("release");
        if (releaseNode != null) {
            releaseId = OiimARUOrionConnection.parseLong(OiimARUOrionConnection.getNodeAttribute(releaseNode, "id"));
            release = OiimARUOrionConnection.getNodeAttribute(releaseNode, "name");
        }
        String automation = "C";
        String readmeUrl = null;
        Node urlNode = (Node)hm.get("url");
        if (urlNode != null) {
            NodeList cnl = urlNode.getChildNodes();
            for (int i = 0; i < cnl.getLength(); ++i) {
                Node child = cnl.item(i);
                if (!PATCH_README_TAG.equals(child.getNodeName())) continue;
                readmeUrl = child.getFirstChild().getNodeValue().trim();
            }
        }
        String patchUrl = null;
        String digest = "-1";
        ArrayList patchUrlParts = new ArrayList();
        ArrayList digestParts = new ArrayList();
        Node filesNode = (Node)hm.get(FILES_TAG);
        if (filesNode != null) {
            OiimARUOrionConnection.getPatchFilesInfo((XMLElement)filesNode, patchUrlParts, digestParts, "SHA-1");
        }
        if (patchUrlParts.size() != 0) {
            patchUrl = (String)patchUrlParts.get(0);
        }
        if (digestParts.size() != 0) {
            digest = (String)digestParts.get(0);
        }
        long size = OiimARUOrionConnection.parseLong(OiimARUOrionConnection.getFieldValue(hm, SIZE_TAG));
        String manuallyPosted = "N";
        Timestamp lastReferenced = date;
        long fileLength = 0L;
        XMLElement tempNode = (XMLElement)hm.get(FIXES_BUGS_TAG);
        ArrayList fixesBugs = OiimARUOrionConnection.getFixesBugInfo(tempNode);
        OiimARUPatchData patchData = new OiimARUPatchData(aruId, status, type, bugNo, product, platform, language, release, abs, date, readmeUrl, patchUrl, comments, size, automation, manuallyPosted, lastReferenced, fileLength);
        patchData.setDigest(digest);
        return patchData;
    }

    private static String getNodeAttribute(Node node, String attributeName) {
        XMLElement xe = (XMLElement)node;
        String attributeValue = xe.getAttribute(attributeName);
        return attributeValue;
    }

    private static String getFirstChildNodeValue(Node node) {
        return node.getFirstChild().getNodeValue();
    }

    private static void getPatchFilesInfo(XMLElement filesNode, ArrayList patchUrlParts, ArrayList digestParts, String digestType) {
        if (filesNode == null) {
            return;
        }
        NodeList fileNodeList = filesNode.getChildrenByTagName(FILE_TAG);
        if (fileNodeList != null) {
            for (int i = 0; i < fileNodeList.getLength(); ++i) {
                NodeList childs;
                Node fileNode = fileNodeList.item(i);
                if (fileNode == null || (childs = fileNode.getChildNodes()) == null) continue;
                for (int j = 0; j < childs.getLength(); ++j) {
                    Node child = childs.item(j);
                    if (DOWNLOAD_URL_TAG.equals(child.getNodeName())) {
                        patchUrlParts.add(child.getFirstChild().getNodeValue().trim());
                    }
                    if (!DIGEST_TAG.equals(child.getNodeName()) || !digestType.equals(((XMLElement)child).getAttribute("type"))) continue;
                    digestParts.add(child.getFirstChild().getNodeValue().trim());
                }
            }
        }
    }

    private static ArrayList getFixesBugInfo(XMLElement fixesBugsEl) {
        ArrayList<String> fixesBugs = new ArrayList<String>();
        int bugId = 0;
        if (fixesBugsEl == null) {
            return fixesBugs;
        }
        NodeList nll = fixesBugsEl.getChildrenByTagName("bug");
        for (int i = 0; i < nll.getLength(); ++i) {
            XMLElement fixesBugElem = (XMLElement)nll.item(i);
            Node childNode = null;
            if (fixesBugElem != null) {
                NodeList nllc = fixesBugElem.getChildrenByTagName(NUMBER_TAG);
                childNode = nllc.item(0);
            }
            if (childNode != null) {
                childNode = childNode.getFirstChild();
            }
            if (childNode != null) {
                bugId = Integer.parseInt(childNode.getNodeValue());
            }
            if (bugId == 0) continue;
            fixesBugs.add("" + bugId);
        }
        return fixesBugs;
    }

    private static String getFieldValue(HashMap hm, String fieldName) {
        Node tempNode = (Node)hm.get(fieldName);
        String retVal = "";
        if (tempNode != null && (tempNode = tempNode.getFirstChild()) != null) {
            retVal = tempNode.getNodeValue().trim();
        }
        return retVal;
    }

    private static String encodeAuthorization(String username, String password) {
        String authorization = username + ":" + password;
        BASE64Encoder enCoder = new BASE64Encoder();
        return "Basic " + enCoder.encode(authorization.getBytes());
    }

    public OiimEMHTTPConnection getNewEMHTTPConnection(URL url) throws ProtocolNotSuppException {
        return OiimARUOrionConnection.getNewEMHTTPConnection(url, this.m_mosUsername, this.m_mosPassword);
    }

    public static OiimEMHTTPConnection getNewEMHTTPConnection(URL url, String user, String passwd) throws ProtocolNotSuppException {
        return OiimARUOrionConnection.getNewEMHTTPConnection(url, user, passwd, m_proxy);
    }

    public static OiimEMHTTPConnection getNewEMHTTPConnection(URL url, String user, String passwd, OiimHTTPProxyUtil proxy) throws ProtocolNotSuppException {
        OiimEMHTTPConnection httpConn = OiimARUOrionConnection.getAuthenticatedConn(url.getHost());
        if (httpConn != null) {
            return httpConn;
        }
        OiiolTextLogger.appendText("New Connection Established to" + url);
        String protocol = url.getProtocol();
        String mosUsername = user;
        char[] mosPassword = passwd.toCharArray();
        OiiiPlaceHolderAuthenticate authInfo = OiiiPlaceHolderAuthenticate.getAuthObject(null);
        try {
            httpConn = new OiimEMHTTPConnection(url, mosUsername, mosPassword, new Object());
            boolean isSecured = protocol.equalsIgnoreCase(HTTPS_PROT);
            if (OiimARUOrionConnection.isValid(proxy)) {
                OiiolTextLogger.appendText("Setting Current Proxy to" + proxy.getHost() + ":" + proxy.getPort());
                httpConn.setCurrentProxy(proxy.getHost(), proxy.getPort());
                if (OiimARUOrionConnection.isValid(proxy.getRealm()) && OiimARUOrionConnection.isValid(proxy.getUser()) && OiimARUOrionConnection.isValid(proxy.getPassword())) {
                    OiiolTextLogger.appendText("Adding authorisation info for realm" + proxy.getRealm());
                    AuthorizationInfo.addBasicAuthorization((String)proxy.getHost(), (int)proxy.getPort(), (String)proxy.getRealm(), (String)proxy.getUser(), (String)proxy.getPassword(), (Object)new Object());
                }
            } else {
                OiiolTextLogger.appendText("No Proxy set");
                httpConn.setCurrentProxy(null, -1);
            }
            if (isSecured) {
                SSLSocketFactory sslsf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                httpConn.setSSLSocketFactory(sslsf);
            }
            httpConn.setAllowUserInteraction(false);
        }
        catch (ProtocolNotSuppException e) {
            OiiolTextLogger.appendText("Protocol:" + protocol + " not supported.");
            throw e;
        }
        return httpConn;
    }

    @Override
    public synchronized String startDownload(OiimARUConnection aruConn, String aruUrl, String aruPatchUrl, String destDir, OiimDownloadProgressStatusHolder dp) {
        String theFile = null;
        String fileName = null;
        InputStream is = null;
        try {
            String fullURL = aruUrl + aruPatchUrl;
            fileName = aruPatchUrl.substring(aruPatchUrl.lastIndexOf("=") + 1);
            theFile = destDir + File.separator + fileName;
            OiiolTextLogger.appendText("\n\nDownloading patch " + fileName + "...");
            File file = new File(theFile);
            URL url = new URL(fullURL);
            boolean isSecured = url.getProtocol().equalsIgnoreCase(HTTPS_PROT);
            if (isSecured) {
                OiimEMHTTPConnection conn = this.getNewEMHTTPConnection(url);
                HTTPResponse response = conn.Get(url.getFile());
                is = response.getInputStream();
            }
            FileOutputStream os = new FileOutputStream(file);
            this.writeZip(is, os, dp);
            os.close();
            OiiolTextLogger.appendText(" Done.");
        }
        catch (IOException e) {
            OiiolTextLogger.appendText("\nFailed to download the patch : " + fileName);
            if (debug) {
                e.printStackTrace(System.err);
            }
            dp.setStatus(4);
        }
        catch (Exception e) {
            OiiolTextLogger.appendText("\nFailed to download the patch : " + fileName);
            if (debug) {
                e.printStackTrace(System.err);
            }
            dp.setStatus(4);
        }
        return theFile;
    }

    private void writeZip(InputStream is, OutputStream os, OiimDownloadProgressStatusHolder dp) throws IOException {
        byte[] tempbuf = new byte[100000];
        int bytesRead = 0;
        while ((bytesRead = is.read(tempbuf, 0, 100000)) != -1) {
            os.write(tempbuf, 0, bytesRead);
            dp.setBytesDownloaded(dp.getBytesDownloaded() + (long)bytesRead);
            dp.setPercentComplete(dp.getBytesDownloaded() * 100L / dp.getTotalSizeInBytes());
            dp.setStatus(1);
        }
        is.close();
    }

    private synchronized ArrayList unzip(String zipFileName, String toLocation) throws IOException {
        ZipEntry entry;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFileName));
        OiixZipInputStream zin = new OiixZipInputStream((InputStream)in, zipFileName);
        HashMap externalAttrInfo = zin.getPermissionInfo();
        ArrayList<String> fileNames = new ArrayList<String>();
        String FileName = new File(zipFileName).getName();
        String BugNo = FileName.substring(FileName.indexOf("p") + 1, FileName.indexOf("_"));
        while ((entry = zin.getNextEntry()) != null) {
            int count;
            String extractPath = toLocation + File.separator + BugNo + File.separator + entry.getName();
            fileNames.add(extractPath);
            int permissionInfo = Integer.parseInt(externalAttrInfo.get(entry.getName()).toString());
            if (entry.isDirectory()) {
                File e = new File(extractPath);
                if (!e.exists()) {
                    e.mkdirs();
                }
                if (permissionInfo == 0 || OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) != -1) continue;
                try {
                    OiipuUnixOps.chmod(extractPath, permissionInfo);
                }
                catch (OiilNativeException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            File entryFile = new File(extractPath);
            if (entryFile.exists()) {
                entryFile.delete();
            }
            byte[] data = new byte[512];
            File dir = entryFile.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(extractPath);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 512);
            while ((count = zin.read(data, 0, 512)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            if (permissionInfo == 0 || OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) != -1) continue;
            try {
                OiipuUnixOps.chmod(extractPath, permissionInfo);
            }
            catch (OiilNativeException e1) {
                e1.printStackTrace();
            }
        }
        ((InputStream)in).close();
        File zipFile = new File(zipFileName);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        return fileNames;
    }

    @Override
    public synchronized void unzipZipsInDir(File dir) {
        String[] fileList = dir.list();
        String fileName = null;
        for (int i = 0; i < fileList.length; ++i) {
            fileName = fileList[i];
            fileName = dir.getAbsolutePath() + File.separator + fileName;
            File fDir = new File(fileName);
            if (fDir.isDirectory()) {
                this.unzipZipsInDir(fDir);
            }
            if (!fDir.isFile() || !fileName.endsWith(".zip")) continue;
            try {
                OiiolTextLogger.appendText("\nUnzipping the file " + fileName + "...");
                this.unzip(fileName, dir.getAbsolutePath());
                OiiolTextLogger.appendText(" Done.");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static boolean downloadUpdates(ArrayList bids, OiimDownloadProgressStatusHolder dp) {
        return OiimARUOrionConnection.downloadUpdates(bids, dp, "");
    }

    public static boolean downloadUpdates(ArrayList bids, OiimDownloadProgressStatusHolder dp, String destDir) {
        ArrayList<String> patchUrls = new ArrayList<String>();
        ArrayList downloadLocations = new ArrayList();
        long totalBytes = 0L;
        String LATEST_UPDATES = "LatestUpdates";
        String UPDATES_LOCATION = "Shiphome";
        String concatPath = OiixPathOps.concatPath(LATEST_UPDATES, UPDATES_LOCATION);
        File dest = new File(destDir = destDir != null && destDir.equals("") ? OiixPathOps.concatPath(System.getProperty("user.home"), concatPath) : OiixPathOps.concatPath(destDir, concatPath));
        if (!dest.exists()) {
            dest.mkdirs();
        }
        int size = bids == null ? 0 : bids.size();
        OiimARUOrionConnection aruConn = null;
        try {
            aruConn = OiimARUOrionConnection.getAruOrionConnection();
        }
        catch (OiimARUAuthException e) {
            OiiolTextLogger.appendException(e);
            aruConn = null;
        }
        if (aruConn == null) {
            OiiolTextLogger.appendText("Couldnt establish connection with metalink");
            dp.setStatus(4);
            return false;
        }
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)bids.get(i);
            ArrayList patchDataList = OiimARUOrionConnection.download(aruConn, bid);
            int size_patchData = patchDataList == null ? 0 : patchDataList.size();
            for (int j = 0; j < size_patchData; ++j) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                patchUrls.add(pd.getPatchUrl());
                totalBytes += pd.getSize();
            }
        }
        dp.setStatus(0);
        dp.setTotalSizeInBytes(totalBytes);
        if (patchUrls.size() == 0) {
            return false;
        }
        OiimDownloadThread dt = new OiimDownloadThread(aruConn, destDir, patchUrls, dp, bids);
        Thread t = new Thread(dt);
        t.start();
        m_threadList.put(dt, t);
        return true;
    }

    public static String getReadMeContents(OiiiPatchMetadata bid) throws IOException, OiimARUAuthException {
        String readMe = "";
        OiimARUOrionConnection aruConn = OiimARUOrionConnection.getAruOrionConnection();
        ArrayList patchDataList = OiimARUOrionConnection.download(aruConn, bid);
        if (patchDataList.size() > 0) {
            OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(0);
            readMe = OiimARUOrionConnection.getReadmeContents(aruConn, aruConn.getaruUrl() + pd.getReadmeUrl());
        }
        return readMe;
    }

    public static boolean downloadCPUs(ArrayList bids, OiimDownloadProgressStatusHolder dp) {
        return OiimARUOrionConnection.downloadCPUs(bids, dp, "");
    }

    public static boolean downloadCPUs(ArrayList bids, OiimDownloadProgressStatusHolder dp, String destDir) {
        ArrayList<String> patchUrls = new ArrayList<String>();
        ArrayList downloadLocations = new ArrayList();
        long totalBytes = 0L;
        String LATEST_UPDATES = "LatestUpdates";
        String CPU_LOCATION = "CPUs";
        String concatPath = OiixPathOps.concatPath(LATEST_UPDATES, CPU_LOCATION);
        File dest = new File(destDir = destDir != null && destDir.equals("") ? OiixPathOps.concatPath(System.getProperty("user.home"), concatPath) : OiixPathOps.concatPath(destDir, concatPath));
        if (!dest.exists()) {
            dest.mkdirs();
        }
        int size = bids == null ? 0 : bids.size();
        OiimARUOrionConnection aruConn = null;
        try {
            aruConn = OiimARUOrionConnection.getAruOrionConnection();
        }
        catch (OiimARUAuthException e) {
            OiiolTextLogger.appendException(e);
            aruConn = null;
        }
        if (aruConn == null) {
            OiiolTextLogger.appendText("Couldnt establish connection with metalink");
            dp.setStatus(4);
            return false;
        }
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)bids.get(i);
            ArrayList patchDataList = OiimARUOrionConnection.download(aruConn, bid);
            int size_patchData = patchDataList == null ? 0 : patchDataList.size();
            for (int j = 0; j < size_patchData; ++j) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                patchUrls.add(pd.getPatchUrl());
                totalBytes += pd.getSize();
            }
        }
        dp.setStatus(0);
        dp.setTotalSizeInBytes(totalBytes);
        if (patchUrls.size() == 0) {
            return false;
        }
        OiimDownloadThread dt = new OiimDownloadThread(aruConn, destDir, patchUrls, dp, bids);
        Thread t = new Thread(dt);
        t.start();
        m_threadList.put(dt, t);
        return true;
    }

    public static boolean hasPatchDownloadPrivilege(OiimMOSState mosState) {
        boolean result = false;
        OiimMOSUser mUser = mosState.getMOSUser();
        if (mUser != null) {
            result = mUser.isCanDownloadPatch();
        }
        return result;
    }

    public OiimMOSState createMOSState(String mosUserName, String password) throws OiimMOSException {
        String PROP_DEFAULT_MOS_URL = "https://support.oracle.com";
        OiimEMHTTPConnection httpConn = null;
        try {
            URL mosURL = new URL(PROP_DEFAULT_MOS_URL);
            httpConn = OiimARUOrionConnection.getNewEMHTTPConnection(mosURL, mosUserName, password);
            OiimARUOrionConnection.setAuthenticatedConn(mosURL.getHost(), httpConn);
        }
        catch (MalformedURLException e) {
            OiiolTextLogger.appendException(e);
            throw new OiimMOSException("", "Malformed URL: " + e.getMessage(), e);
        }
        catch (ProtocolNotSuppException e) {
            OiiolTextLogger.appendException(e);
            throw new OiimMOSException("", "Protocol Not Supported: " + e.getMessage(), (Exception)((Object)e));
        }
        String strLoginXML = this.getLoginXML(httpConn, PROP_DEFAULT_MOS_URL);
        if (debug) {
            OiiolTextLogger.appendText("MOS Details");
            OiiolTextLogger.appendText(strLoginXML);
        }
        OiimMOSUser mosUser = this.extractMOSUser(strLoginXML);
        mosUser.setLoginId(mosUserName);
        OiimMOSState mosState = new OiimMOSState();
        mosState.setMosLoginId(mosUserName);
        mosState.setMosPassword(password);
        mosState.setMOSUser(mosUser);
        return mosState;
    }

    public String getLoginXML(OiimEMHTTPConnection httpConn, String mosURL) throws OiimMOSException {
        String strLoginXML;
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("cmd", STATUS_TAG);
        String url = mosURL + LOGIN_URI;
        try {
            strLoginXML = this.doGet(httpConn, LOGIN_URI, paramsMap, null, null);
        }
        catch (Exception e) {
            throw new OiimMOSException("", "Unable to get login XML: " + e.getMessage(), e);
        }
        return strLoginXML;
    }

    OiimMOSUser extractMOSUser(String loginXML) throws OiimMOSException {
        Document doc;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = parser.parse(new InputSource(new StringReader(loginXML)));
        }
        catch (ParserConfigurationException e) {
            throw new OiimMOSException("", "Unable to obtain parser: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new OiimMOSException("", "Unable to parse loginXML: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new OiimMOSException("", "Unable to parse loginXML: " + e.getMessage(), e);
        }
        Element loginElement = doc.getDocumentElement();
        String authCode = loginElement.getAttribute(ATTR_AUTH_CODE);
        if (!AUTH_CODE_LOGIN_SUCCESS.equals(authCode)) {
            throw new OiimMOSException("", "Login XML not complete: Auth Code: " + authCode + ": " + loginElement.getAttribute(ATTR_MESSAGE));
        }
        OiimMOSUser mosUser = new OiimMOSUser();
        this.extractUserData(loginElement, mosUser);
        this.extractCsiData(loginElement, mosUser);
        this.extractUserPriv(loginElement, mosUser);
        return mosUser;
    }

    void extractUserPriv(Element loginElement, OiimMOSUser mosUser) {
        boolean privPatchDownload = false;
        NodeList nList = loginElement.getElementsByTagName(USERINFO_TAG);
        if (nList.getLength() > 0) {
            Element e = (Element)nList.item(0);
            NodeList userInfoChildNodes = e.getChildNodes();
            block0: for (int i = 0; i < userInfoChildNodes.getLength(); ++i) {
                Node cNode = userInfoChildNodes.item(i);
                if (!cNode.getNodeName().equals(PRIVLIST_TAG)) continue;
                Element cElem = (Element)cNode;
                NodeList pList = cElem.getElementsByTagName(PRIV_TAG);
                for (int j = 0; j < pList.getLength(); ++j) {
                    Element priv = (Element)pList.item(j);
                    String code = priv.getAttribute(ATTR_CODE);
                    if (code == null || !code.equals(CODE_PAS)) continue;
                    privPatchDownload = true;
                    continue block0;
                }
            }
        }
        if (privPatchDownload) {
            mosUser.setCanDownloadPatch(true);
        }
    }

    void extractCsiData(Element loginElement, OiimMOSUser mosUser) {
        NodeList nList = loginElement.getElementsByTagName(CSILIST_TAG);
        int numNodes = nList.getLength();
        if (numNodes > 0) {
            Element e = (Element)nList.item(0);
            NodeList csis = e.getElementsByTagName(CSI_TAG);
            int numCSIs = csis.getLength();
            ArrayList<OiimMOSCsi> mosCsiList = new ArrayList<OiimMOSCsi>();
            mosUser.setMosCsiList(mosCsiList);
            for (int i = 0; i < numCSIs; ++i) {
                Element c = (Element)csis.item(i);
                String supportid = c.getAttribute(ATTR_SUPPORTID);
                String orgID = c.getAttribute(ATTR_ORG_ID);
                String createSR = c.getAttribute(ATTR_CREATE_SR);
                boolean createSRFlag = createSR != null && (createSR.equals("Y") || createSR.equals("y"));
                boolean adminFlag = false;
                boolean patchDownload = false;
                NodeList pList = c.getElementsByTagName(PRIV_TAG);
                for (int j = 0; j < pList.getLength(); ++j) {
                    Element priv = (Element)pList.item(j);
                    String code = priv.getAttribute(ATTR_CODE);
                    if (code != null && code.equals(CODE_ADM)) {
                        adminFlag = true;
                        break;
                    }
                    if (code == null || !code.equals(CODE_PAS)) continue;
                    patchDownload = true;
                    break;
                }
                OiimMOSCsi mosCsi = new OiimMOSCsi();
                mosCsi.setSupportIdentifier(supportid);
                mosCsi.setOrgId(orgID);
                mosCsi.setCanCreateSr(createSRFlag);
                mosCsi.setCanDownloadPatch(patchDownload);
                mosCsi.setCsiAdmin(adminFlag);
                if (patchDownload) {
                    mosUser.setCanDownloadPatch(true);
                }
                mosCsiList.add(mosCsi);
            }
        }
    }

    protected void extractUserData(Element loginElement, OiimMOSUser mosUser) {
        NodeList nList = loginElement.getElementsByTagName(USER_TAG);
        if (nList.getLength() > 0) {
            Element userElement = (Element)nList.item(0);
            String value = userElement.getAttribute(ATTR_EMAIL);
            mosUser.setEmail(value);
            value = userElement.getAttribute("id");
            mosUser.setUserId(value);
            value = userElement.getAttribute(ATTR_FIRST_NAME);
            mosUser.setFirstName(value);
            value = userElement.getAttribute(ATTR_LAST_NAME);
            mosUser.setLastName(value);
            value = userElement.getAttribute(ATTR_CONTACT_NAME);
            mosUser.setContactName(value);
            value = userElement.getAttribute(ATTR_STREET_2);
            mosUser.setStreet2(value);
            value = userElement.getAttribute(ATTR_STREET_1);
            mosUser.setStreet1(value);
            value = userElement.getAttribute(ATTR_CITY);
            mosUser.setCity(value);
            value = userElement.getAttribute(ATTR_STATE);
            mosUser.setState(value);
            value = userElement.getAttribute(ATTR_COUNTRY);
            mosUser.setCountry(value);
            value = userElement.getAttribute(ATTR_ZIP_CODE);
            mosUser.setZipCode(value);
            value = userElement.getAttribute(ATTR_PHONE);
            mosUser.setPhone(value);
            value = userElement.getAttribute(ATTR_FAX);
            mosUser.setFax(value);
        }
    }

    public String doGet(HTTPConnection httpConn, String url, Map paramsMap, Map headersMap, Map responseMetaData) throws OiimEMHTTPException, OiimLoginFailureException, OiimChangePasswordException {
        String data = (String)this.sendRequest(httpConn, url, paramsMap, headersMap, responseMetaData, METHOD_GET, RETURN_DATA_TYPE_STRING);
        return data;
    }

    protected Object sendRequest(HTTPConnection httpConn, String url, Map paramsMap, Map headersMap, Map responseMetaData, String method, String returnDataType) throws OiimEMHTTPException, OiimLoginFailureException, OiimChangePasswordException {
        NVPair[] formData = OiimHTTPHelper.getNVPairs(paramsMap);
        NVPair[] headers = OiimHTTPHelper.getNVPairs(headersMap);
        try {
            try {
                HTTPResponse response;
                if (METHOD_GET.equalsIgnoreCase(method)) {
                    OiiolTextLogger.appendText("GET  " + url + "?" + formData.toString());
                    response = httpConn.Get(url, formData, headers);
                } else if (METHOD_POST.equalsIgnoreCase(method)) {
                    OiiolTextLogger.appendText("POST " + url + "?" + formData.toString());
                    response = httpConn.Post(url, formData, headers);
                } else {
                    throw new RuntimeException("Unsupported method: " + method);
                }
                Object data = this.getResponse(response, returnDataType, responseMetaData);
                return data;
            }
            catch (IOException e) {
                throw new OiimEMHTTPException(0, e.getMessage(), e);
            }
        }
        catch (ModuleException e) {
            throw new OiimEMHTTPException(0, e.getMessage(), e);
        }
    }

    protected Object getResponse(HTTPResponse response, String returnDataType, Map respMetaDataMap) throws OiimEMHTTPException, OiimLoginFailureException, OiimChangePasswordException, IOException, ModuleException {
        Object data;
        if (RETURN_DATA_TYPE_STRING.equalsIgnoreCase(returnDataType)) {
            data = this.getResponseAsString(response);
        } else if (RETURN_DATA_TYPE_INPUT_STREAM.equalsIgnoreCase(returnDataType)) {
            data = this.getResponseAsInputStream(response);
        } else {
            throw new RuntimeException("Unknown Return Type:" + returnDataType);
        }
        if (respMetaDataMap != null) {
            this.populateResponseMetaDataMap(respMetaDataMap, response);
        }
        return data;
    }

    protected void populateResponseMetaDataMap(Map responseMetaData, HTTPResponse response) throws IOException, ModuleException {
        String contentType = response.getHeader("Content-Type");
        responseMetaData.put("Content-Type", contentType);
    }

    protected String getResponseAsString(HTTPResponse response) throws OiimEMHTTPException, OiimLoginFailureException, OiimChangePasswordException, IOException, ModuleException {
        this.validateResponse(response);
        try {
            return response.getText();
        }
        catch (ParseException e) {
            OiiolTextLogger.appendErrorText(e.getMessage());
            return "";
        }
    }

    protected InputStream getResponseAsInputStream(HTTPResponse response) throws OiimEMHTTPException, OiimLoginFailureException, OiimChangePasswordException, IOException, ModuleException {
        this.validateResponse(response);
        InputStream data = response.getInputStream();
        return data;
    }

    protected void validateResponse(HTTPResponse response) throws OiimLoginFailureException, OiimChangePasswordException, IOException, ModuleException {
        int responseCode = 0;
        try {
            responseCode = response.getStatusCode();
        }
        catch (ProtocolException e1) {
            OiiolTextLogger.appendText("Ignoreable Exception ,possible redirect due to bad cookies");
            OiiolTextLogger.appendErrorText(e1.getMessage());
        }
        if (response.getStatusCode() != 200) {
            if (response.getStatusCode() == 409) {
                String xmlError = new String(response.getData());
                try {
                    OiimSSOAuthenticationFailure ssoAuthFailure = OiimSSOAuthenticationFailure.getInstance(xmlError);
                    throw new OiimLoginFailureException(ssoAuthFailure.getErrorCode(), ssoAuthFailure.getErrorDesc());
                }
                catch (SAXException e) {
                    OiiolTextLogger.appendErrorText(e.getMessage());
                }
            }
            throw new IOException("IO Error: Status code: " + response.getStatusCode() + ", Reason: " + response.getReasonLine() + ", HTML:" + new String(response.getData()));
        }
    }

    public static String getMetaDataXML(String location, int ID, String version, String destDir) {
        long totalBytes = 0L;
        OiimDownloadProgressStatusHolder dp = new OiimDownloadProgressStatusHolder();
        if (location.equalsIgnoreCase(S_METALINK_URL) || location.equalsIgnoreCase(S_METALINK_URL_HTTPS)) {
            OiiiPatchMetadata pm = new OiiiPatchMetadata(ID, -1, version);
            ArrayList<OiiiPatchMetadata> bids = new ArrayList<OiiiPatchMetadata>();
            bids.add(pm);
            if (destDir != null && destDir.equals("")) {
                OiiolTextLogger.appendText("download Location cannot be empty for metadata xml");
                return null;
            }
            File dest = new File(destDir);
            if (!dest.exists()) {
                dest.mkdirs();
            }
            OiimARUOrionConnection aruConn = null;
            try {
                aruConn = OiimARUOrionConnection.getAruOrionConnection();
            }
            catch (OiimARUAuthException e) {
                OiiolTextLogger.appendException(e);
                aruConn = null;
            }
            if (aruConn == null) {
                OiiolTextLogger.appendText("Couldnt establish connection with metalink");
                return null;
            }
            ArrayList patchDataList = OiimARUOrionConnection.download(aruConn, pm);
            ArrayList<String> patchUrls = new ArrayList<String>();
            if (patchDataList != null && patchDataList.size() > 0) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(0);
                String aruPatchUrl = pd.getPatchUrl();
                patchUrls.add(aruPatchUrl);
                totalBytes += pd.getSize();
            }
            if (patchUrls.size() == 0) {
                return null;
            }
            dp.setStatus(0);
            dp.setTotalSizeInBytes(totalBytes);
            OiimDownloadThread dt = new OiimDownloadThread(aruConn, destDir, patchUrls, dp, bids);
            Thread t = new Thread(dt);
            t.start();
            try {
                t.join();
            }
            catch (Exception e) {
                OiiolTextLogger.appendErrorText(e.getMessage());
            }
        }
        if (dp.getStatus() == 3L) {
            File f = new File(destDir + File.separator + ID);
            File[] listFiles = f.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                String fileName = listFiles[i].getName();
                if (!listFiles[i].isFile() || !fileName.endsWith(".xml")) continue;
                return listFiles[i].getAbsolutePath();
            }
        }
        return null;
    }

    public static long getTotalPatchSize(ArrayList bids) throws OiimARUAuthException {
        long totalBytes = 0L;
        OiimARUOrionConnection aruConn = null;
        try {
            aruConn = OiimARUOrionConnection.getAruOrionConnection();
        }
        catch (OiimARUAuthException e) {
            OiiolTextLogger.appendException(e);
            aruConn = null;
            throw e;
        }
        int size = bids == null ? 0 : bids.size();
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)bids.get(i);
            ArrayList patchDataList = OiimARUOrionConnection.download(aruConn, bid);
            int size_patchData = patchDataList == null ? 0 : patchDataList.size();
            for (int j = 0; j < size_patchData; ++j) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                totalBytes += pd.getSize();
            }
        }
        return totalBytes;
    }

    public static boolean downloadOneOff(ArrayList bids, OiimDownloadProgressStatusHolder dp) {
        return OiimARUOrionConnection.downloadOneOff(bids, dp, "");
    }

    public static boolean downloadOneOff(ArrayList bids, OiimDownloadProgressStatusHolder dp, String destDir) {
        ArrayList<String> patchUrls = new ArrayList<String>();
        long totalBytes = 0L;
        String LATEST_UPDATES = "LatestUpdates";
        String ONEOFF_LOCATION = "OneOffs";
        String concatPath = OiixPathOps.concatPath(LATEST_UPDATES, ONEOFF_LOCATION);
        File dest = new File(destDir = destDir != null && destDir.equals("") ? OiixPathOps.concatPath(System.getProperty("user.home"), concatPath) : OiixPathOps.concatPath(destDir, concatPath));
        if (!dest.exists()) {
            dest.mkdirs();
        }
        int size = bids == null ? 0 : bids.size();
        OiimARUOrionConnection aruConn = null;
        try {
            aruConn = OiimARUOrionConnection.getAruOrionConnection();
        }
        catch (OiimARUAuthException e) {
            OiiolTextLogger.appendException(e);
            aruConn = null;
        }
        if (aruConn == null) {
            OiiolTextLogger.appendText("Couldnt establish connection with metalink");
            dp.setStatus(4);
            return false;
        }
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)bids.get(i);
            ArrayList patchDataList = OiimARUOrionConnection.download(aruConn, bid);
            int size_patchData = patchDataList == null ? 0 : patchDataList.size();
            for (int j = 0; j < size_patchData; ++j) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                patchUrls.add(pd.getPatchUrl());
                totalBytes += pd.getSize();
            }
        }
        dp.setStatus(0);
        dp.setTotalSizeInBytes(totalBytes);
        if (patchUrls.size() == 0) {
            return false;
        }
        OiimDownloadThread dt = new OiimDownloadThread(aruConn, destDir, patchUrls, dp, bids);
        Thread t = new Thread(dt);
        t.start();
        m_threadList.put(dt, t);
        return true;
    }

    public static String getDefaultProxy() {
        String retString;
        block7: {
            retString = null;
            int curPlat = OiixPlatform.getCurrentPlatform();
            int groupID = OiixPlatform.getPlatGroupIDFromCommonName("WINDOWS");
            boolean isWindows = OiixGeneralQueries.isPlatInGroup(groupID, curPlat);
            if (isWindows) {
                try {
                    String key = "HKEY_CURRENT_USER";
                    String subKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
                    String value = "ProxyEnable";
                    int retInt = OiixRegistryOps.RegGetNumValuew32(key, subKey, value);
                    if (retInt == 1) {
                        key = "HKEY_CURRENT_USER";
                        subKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
                        value = "ProxyServer";
                        retString = OiixRegistryOps.RegGetValue(key, subKey, value);
                        if (retString != null && (OiixFunctionOps.strContains(retString, "http=").booleanValue() || OiixFunctionOps.strContains(retString, "gopher=").booleanValue() || OiixFunctionOps.strContains(retString, "ftp=").booleanValue() || OiixFunctionOps.strContains(retString, "https=").booleanValue() || OiixFunctionOps.strContains(retString, "socks=").booleanValue())) {
                            String[] sl_proxyList = OiixFunctionOps.explodeString(retString, ";");
                            for (int index = 0; index <= sl_proxyList.length - 1; ++index) {
                                if (!OiixFunctionOps.strContains(sl_proxyList[index], "http=").booleanValue()) continue;
                                retString = OiixFunctionOps.substring(sl_proxyList[index], OiixFunctionOps.strLength("http="), OiixFunctionOps.strLength(sl_proxyList[index]));
                                return retString;
                            }
                            return retString;
                        }
                        return retString;
                    }
                    break block7;
                }
                catch (OiilNativeException ne) {
                    OiiolTextLogger.appendException(ne);
                    return retString;
                }
            }
            String val = OiixEnvironmentOps.getEnv(HTTP_PROXY_VAR);
            if (val.equals("")) {
                return null;
            }
        }
        return retString;
    }

    public static String[] getDefaultHostAndPort() {
        String ret = OiimARUOrionConnection.getDefaultProxy();
        if (ret != null) {
            String[] host_port = OiixFunctionOps.explodeString(ret, ":");
            return host_port;
        }
        return new String[0];
    }

    public static OiimARUOrionConnection getAruOrionConnection() throws OiimARUAuthException {
        if (aruConnSingleton == null) {
            String[] s;
            System.setProperty(SYSTEM_PROTOCOL_HANDLER, HTTPCLIENT_PROTOCOL_HANDLER);
            OiiiPlaceHolderAuthenticate authInfo = OiiiPlaceHolderAuthenticate.getAuthObject(null);
            String METALINK_URL = authInfo.getMetalinkLocation();
            String METALINK_USERNAME = authInfo.getAuthenticateUser();
            String METALINK_PASSWORD = authInfo.getAuthenticatePassword();
            if (authInfo.getProxyHost() == null && (s = OiimARUOrionConnection.getDefaultHostAndPort()).length > 0) {
                authInfo.setProxyHost(s[0]);
                String s_port = s.length >= 2 ? s[1] : DEFAULT_PROXY_PORT;
                authInfo.setProxyPort(Integer.parseInt(s_port));
            }
            OiimHTTPProxyUtil proxy = new OiimHTTPProxyUtil(authInfo.getProxyHost(), authInfo.getProxyPort(), authInfo.getProxyRealm(), authInfo.getProxyUser(), authInfo.getProxyPwd(), authInfo.getDontProxyFor());
            OiimHTTPProxyUtil.setProxyInfo(proxy);
            OiimARUOrionConnection.setProxy(proxy);
            OiimARUOrionConnection.authenticate(METALINK_USERNAME, METALINK_PASSWORD, METALINK_URL);
            aruConnSingleton = new OiimARUOrionConnection(METALINK_URL, METALINK_USERNAME, METALINK_PASSWORD);
        }
        return aruConnSingleton;
    }

    public static void setProxy(OiimHTTPProxyUtil proxy) {
        m_proxy = proxy;
    }

    public static boolean isValid(String str) {
        return str != null && str.trim().length() > 0;
    }

    public static boolean isValid(OiimHTTPProxyUtil proxy) {
        return proxy != null && OiimARUOrionConnection.isValid(proxy.getHost());
    }

    public static void resetAruConnection() {
        aruConnSingleton = null;
        OiiiPlaceHolderAuthenticate.resetAuthObject();
        if (authenticatedConn != null) {
            authenticatedConn.clear();
        }
    }

    public static void checkPatchDigest(String aruUrl, String aruPatchUrl, String digest) throws OiimARUAuthException, IOException {
        InputStream result = null;
        int count = 0;
        int BUCKET = 1024;
        byte[] tempbuf = null;
        String fullURL = null;
        try {
            fullURL = aruUrl + aruPatchUrl;
            OiimARUOrionConnection aruOS = OiimARUOrionConnection.getAruOrionConnection();
            URL url = new URL(fullURL);
            try {
                result = aruOS.getNewEMHTTPConnection(url).Get(url.getFile()).getInputStream();
            }
            catch (Exception e) {
                OiiolTextLogger.appendException(e);
            }
            tempbuf = new byte[1024];
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            while ((count = result.read(tempbuf, 0, 1024)) > 0) {
                md.update(tempbuf, 0, count);
            }
            byte[] messageDigest = md.digest();
            BigInteger number = new BigInteger(1, messageDigest);
            if (!digest.equals("-1")) {
                if (debug) {
                    StringBuffer log = new StringBuffer();
                    log.append("Digest calculated from patch download ==>" + number.toString(16) + "Digest from patch XML ==>  " + digest);
                    OiiolTextLogger.appendText(log.toString());
                }
                if (!digest.equalsIgnoreCase(number.toString(16))) {
                    OiimARUAuthException ae = new OiimARUAuthException();
                    ae.setErrorCode(5);
                    if (debug) {
                        StringBuffer log = new StringBuffer();
                        log.append("downloaded sample patchdoes not match with its digest " + fullURL + ";");
                        OiiolTextLogger.appendText(log.toString());
                    }
                    throw ae;
                }
            } else if (debug) {
                OiiolTextLogger.appendText("no digest obtained from xml, so skipping the digest test");
            }
        }
        catch (Throwable t) {
            OiimARUAuthException ae = new OiimARUAuthException();
            ae.setErrorCode(5);
            if (debug) {
                StringBuffer log = new StringBuffer();
                log.append("an exception occurred while downloading a samplepatch  from metalink URL = " + fullURL + ";");
                log.append(t.toString());
                OiiolTextLogger.appendText(log.toString());
            }
            throw ae;
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    public static ArrayList download(OiimARUOrionConnection aruConn, OiiiPatchMetadata bid) {
        Object filename = null;
        ArrayList<OiimARUPatchData> patchList = new ArrayList<OiimARUPatchData>();
        try {
            ArrayList al = null;
            OiimARUPatchData pd2 = null;
            Object bugList = null;
            al = aruConn.getPatchData(bid.getPatchBugNumber(), bid.getApplicablePlatform(), -1, -1, bid.getType());
            if (al != null) {
                for (OiimARUPatchData pd2 : al) {
                    if (bid.getLanguage() != -1 && bid.getVersion().equalsIgnoreCase("-1") ? pd2.getLanguage() != (long)bid.getLanguage() : (bid.getLanguage() == -1 && !bid.getVersion().equalsIgnoreCase("-1") ? !pd2.getRelease().equalsIgnoreCase(bid.getVersion()) : bid.getLanguage() != -1 && !bid.getVersion().equalsIgnoreCase("-1") && (pd2.getLanguage() != (long)bid.getLanguage() || pd2.getRelease() != bid.getVersion()))) continue;
                    patchList.add(pd2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return patchList;
    }

    public static void cancelAllDownloads() {
        for (OiimDownloadThread dt : m_threadList.keySet()) {
            Thread t = (Thread)m_threadList.get(dt);
            t.stop();
            dt.cleanUp();
        }
    }

    @Override
    public String getaruUrl() {
        return this.m_aruUrl;
    }

    public String getMosUsername() {
        return this.m_mosUsername;
    }

    public void setMosUsername(String username) {
        this.m_mosUsername = username;
    }

    public String getMosPassword() {
        return this.m_mosPassword;
    }

    public void setMosPassword(String password) {
        this.m_mosPassword = password;
    }

    static {
        HTTPConnection.setDefaultTimeout((int)60000);
        HTTPConnection.setDefaultConnectionTimeout((int)60000);
        m_proxy = null;
        s_aruOrionConnectionLookup = new String[12];
        s_aruDirectoryLookup = new String[11];
        s_OiimARUOrionConnectionLookup = new String[11];
        OiimARUOrionConnection.s_aruOrionConnectionLookup[0] = "/Orion/Services/search?get_downloads_count=false";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[1] = "/Orion/Services/download";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[2] = "/Orion/Services/download";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[3] = "/Orion/Services/metadata?table=aru_products";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[4] = "/Orion/Services/metadata?table=aru_releases";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[5] = "/Orion/Services/metadata?table=aru_platforms";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[6] = "/Orion/Services/metadata?table=aru_languages";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[7] = "/Orion/Services/metadata?table=aru_product_groups";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[8] = "/Orion/Services/metadata?table=aru_product_releases";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[9] = "/Orion/Services/metadata?table=aru_component_releases";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[10] = "/Orion/Services/search?language_id=0&classification_group=recommended&patch_type=all&group_by=target_type&group_by=release&group_by=platform";
        OiimARUOrionConnection.s_aruOrionConnectionLookup[11] = "/Orion/Services/search?request_id=";
        OiimARUOrionConnection.s_aruDirectoryLookup[0] = "query_patches.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[1] = "download_patch.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[2] = "download_readme.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[3] = "aru_products.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[4] = "aru_releases.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[5] = "aru_platforms.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[6] = "aru_languages.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[7] = "aru_product_groups.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[8] = "aru_product_releases.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[9] = "aru_component_releases.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[10] = "query_advisories.xml";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[0] = "/ARULink/XMLAPI/query_patches";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[1] = "/ARULink/XMLAPI/download_patch";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[2] = "/ARULink/XMLAPI/download_readme";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[3] = "/ARULink/XMLAPI/download_seed_data?table=aru_products";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[4] = "/ARULink/XMLAPI/download_seed_data?table=aru_releases";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[5] = "/ARULink/XMLAPI/download_seed_data?table=aru_platforms";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[6] = "/ARULink/XMLAPI/download_seed_data?table=aru_languages";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[7] = "/ARULink/XMLAPI/download_seed_data?table=aru_product_groups";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[8] = "/ARULink/XMLAPI/download_seed_data?table=aru_product_releases";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[9] = "/ARULink/XMLAPI/download_seed_data?table=aru_component_releases ";
        OiimARUOrionConnection.s_OiimARUOrionConnectionLookup[10] = "/ARULink/XMLAPI/query_advisories";
        OiimARUOrionConnection.s_aruDirectoryLookup[0] = "query_patches.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[1] = "download_patch.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[2] = "download_readme.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[3] = "aru_products.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[4] = "aru_releases.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[5] = "aru_platforms.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[6] = "aru_languages.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[7] = "aru_product_groups.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[8] = "aru_product_releases.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[9] = "aru_component_releases.xml";
        OiimARUOrionConnection.s_aruDirectoryLookup[10] = "query_advisories.xml";
        PATCH_CONTEXT = new String("context_patch");
        debug = true;
        aruConnSingleton = null;
        m_threadList = new HashMap();
        authenticatedConn = new HashMap();
    }
}

