/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpURLConnection;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.ZipEntry;
import javax.net.ssl.SSLSocketFactory;
import oracle.sysman.oii.oiii.OiiiPatchMetadata;
import oracle.sysman.oii.oiii.OiiiPlaceHolderAuthenticate;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiim.OiimARUAuthException;
import oracle.sysman.oii.oiim.OiimARUPatchData;
import oracle.sysman.oii.oiim.OiimDownloadProgressStatusHolder;
import oracle.sysman.oii.oiim.OiimDownloadThread;
import oracle.sysman.oii.oiim.OiimHTTPProxyUtil;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixGeneralQueries;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixRegistryOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixZipInputStream;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sun.misc.BASE64Encoder;

public class OiimARUConnection {
    private String m_aruUrl = null;
    private String m_encoding = null;
    private String m_user = null;
    private String m_passwd = null;
    private static final String S_HTML_BEGIN = "<HTML";
    private static final String S_TITLE_BEGIN = "<TITLE>";
    private static final String S_TITLE_END = "</TITLE>";
    public static final int ARU_PATCH_QUERY_API = 0;
    public static final int ARU_PATCH_DOWNLOAD_API = 1;
    public static final int ARU_PATCH_README_API = 2;
    public static final int ARU_PRODUCTS_API = 3;
    public static final int ARU_RELEASES_API = 4;
    public static final int ARU_PLATFORMS_API = 5;
    public static final int ARU_LANGUAGES_API = 6;
    public static final int ARU_PRODUCT_GROUPS_API = 7;
    public static final int ARU_PRODUCT_RELEASES_API = 8;
    public static final int ARU_OUI_COMPONENTS_API = 9;
    public static final int ARU_BUG_ADVISORIES_API = 10;
    public static final int ARU_TABLE_SIZE = 11;
    private static final String[] s_OiimARUConnectionLookup;
    private static final String[] s_aruDirectoryLookup;
    private ArrayList m_errorList = new ArrayList();
    private static final String DEFAULT_PROXY_PORT = "80";
    private static final String PLATFORM_PROP = "&platform=";
    private static final String LANGUAGE_PROP = "&language=";
    private static final String RELEASE_PROP = "&release=";
    private static final String PATCH_TYPE_PROP = "&patch_type=";
    private static final String BEGIN_TIME_PROP = "&begin_time=";
    private static final String END_TIME_PROP = "&end_time=";
    private static final String PRODUCT_FAMILY_PROP = "&product_family=";
    private static final String PRODUCT_PROP = "&product=";
    private static final String BUG_PROP = "&bug=";
    private static final String ARUID_PROP = "&aru=";
    private static final String EMAIL_PROP = "?email=test.user@oracle.com&userid=test";
    private static final String DOWNLOAD_SEED = "download_seed_data";
    private static final String PRODUCT_ID_TAG = "product_id";
    private static final String PRODUCT_NAME_TAG = "product_name";
    private static final String PLATFORM_ID_TAG = "platform_id";
    private static final String PLATFORM_NAME_TAG = "platform_name";
    private static final String RELEASE_ID_TAG = "release_id";
    private static final String RELEASE_NAME_TAG = "release_name";
    private static final String LANGUAGE_ID_TAG = "language_id";
    private static final String LANGUAGE_NAME_TAG = "nls_language";
    private static final String GROUP_PRODUCT_ID_TAG = "ap1.product_id";
    private static final String GROUP_MEMBER_ID_TAG = "ap2.product_id";
    private static final String RELEASE_PRODUCT_ID_TAG = "ap.product_id";
    private static final String RELEASE_RELEASE_ID_TAG = "ar.release_id";
    private static final String FULL_DATE_FORMAT = "yyyy:MM:dd:HH:mm:ss";
    private static final String PATCH_DATE_FORMAT = "dd-MMM-yyyy";
    public static final String ALL_PATCHES = "all";
    public static final String PATCH_PATCHES = "patch";
    public static final String PATCHSET_PATCHES = "patchset";
    private static final String ERROR_TAG = "error";
    private static final String PATCH_TAG = "patch";
    private static final String TOTAL_TAG = "total";
    private static final String RESULTS_TAG = "results";
    private static final String DATE_TAG = "date";
    private static final String ID_TAG = "id";
    private static final String TYPE_TAG = "type";
    private static final String PRODUCT_TAG = "product";
    private static final String STATUS_TAG = "status";
    private static final String ABSTRACT_TAG = "abstract";
    private static final String COMMENTS_TAG = "comments";
    private static final String BUG_TAG = "bug";
    private static final String PLATFORM_TAG = "platform";
    private static final String LANGUAGE_TAG = "language";
    private static final String RELEASE_TAG = "release";
    private static final String README_URL_TAG = "readme_url";
    private static final String PATCH_URL_TAG = "patch_url";
    private static final String SIZE_TAG = "size";
    private static final String OUI_COMPONENT_ID_TAG = "component_release";
    private static final String OUI_COMPONENT_NAME_TAG = "component_name";
    private static final String OUI_COMPONENT_RELEASE_TAG = "release_name";
    private static final String ADV_PATCHES_TAG = "patches";
    private static final String ADV_BUGS_TAG = "bugs";
    private static final String ADV_ADVISORIES_TAG = "advisories";
    private static final String ADV_ADVISORY_TAG = "advisory";
    private static final String ADV_PATCH_TAG = "patch";
    private static final String ADV_ID_TAG = "id";
    private static final String ADV_VERSION_TAG = "version";
    private static final String ADV_IMPACT_TAG = "impact";
    private static final String ADV_SEVERITY_TAG = "severity";
    private static final String ADV_URL_TAG = "url";
    private static final String ADV_ABSTRACT_TAG = "abstract";
    private static final String ADV_ADVISORY_NAME_TAG = "name";
    private static final String ADV_RELEASE_DATE_TAG = "release_date";
    private static final String ADV_FIXESBUGS_TAG = "fixesbugs";
    private static final String ADV_FIXESBUG_TAG = "fixesbug";
    private static final String ADV_COMPONENTS_TAG = "components";
    private static final String ADV_COMPONENT_RELEASE_TAG = "component_release";
    private static final String ADV_BUG_TAG = "bug";
    private static final String ADV_RELEASE_TAG = "release";
    private static final String ADV_PLATFORMS_TAG = "platforms";
    private static final String ADV_PLATFORM_TAG = "platform";
    private static final String ADV_PRODUCT_TAG = "product";
    private static final String ADV_LANGUAGE_TAG = "language";
    private static final String ADV_TYPE_TAG = "type";
    public static final String S_METALINK_URL = "http://updates.oracle.com";
    public static final String S_METALINK_URL_HTTPS = "https://updates.oracle.com";
    public static final String HTTPS_PROT = "https";
    public static final Object PATCH_CONTEXT;
    private static final String S_SEARCH_ERROR = "Search ERROR:";
    public static final int PATCH_TO_DOWNLOAD = 1390304;
    public static final int HTTP_OK = 200;
    public static final String CHARACTER_ENCODING = "UTF-8";
    public static final String METALINK_REALM = "Metalink";
    public static final String HTTP_PROXY_VAR = "HTTP_PROXY";
    private static boolean debug;
    public static OiimARUConnection aruConnSingleton;
    public static final String SYSTEM_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    public static final String HTTPCLIENT_PROTOCOL_HANDLER = "HTTPClient";
    private static HashMap m_threadList;

    protected OiimARUConnection() {
    }

    private OiimARUConnection(String aruUrl, String metalinkUsername, String metalinkPassword) {
        this.OiimARUConnection(aruUrl, metalinkUsername, metalinkPassword);
    }

    private void OiimARUConnection(String aruUrl, String metalinkUsername, String metalinkPassword) {
        this.m_aruUrl = aruUrl;
        this.m_encoding = OiimARUConnection.encodeAuthorization(metalinkUsername, metalinkPassword);
        this.m_user = metalinkUsername;
        this.m_passwd = metalinkPassword;
    }

    public ArrayList getPatchData(int bugNo, int platform, int language, int release, String patch_type) throws SAXException, IOException, ParseException, OiimARUAuthException {
        String url = this.getUrl(bugNo, platform, language, release, patch_type, this.m_aruUrl);
        return this.getPatchData(url, patch_type);
    }

    private static String checkXMLoutput(String xmlString) {
        String errorOutput = null;
        if (xmlString.startsWith(S_SEARCH_ERROR)) {
            errorOutput = xmlString;
        } else if (xmlString.indexOf(S_HTML_BEGIN) != -1 || xmlString.indexOf(S_HTML_BEGIN.toLowerCase()) != -1) {
            int endIndex;
            int startIndex = xmlString.indexOf(S_TITLE_BEGIN);
            if (startIndex == -1) {
                startIndex = xmlString.indexOf(S_TITLE_BEGIN.toLowerCase());
            }
            if ((endIndex = xmlString.indexOf(S_TITLE_END)) == -1) {
                endIndex = xmlString.indexOf(S_TITLE_END.toLowerCase());
            }
            if (startIndex != -1 && endIndex > startIndex) {
                errorOutput = xmlString.substring(startIndex + 7, endIndex).trim();
                if (errorOutput.startsWith("502") || errorOutput.startsWith("503") || errorOutput.startsWith("504") || errorOutput.startsWith("404")) {
                    String toLog = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "ERRMSG_ARUCONNECTSETUP");
                    OiiolTextLogger.appendText(toLog);
                } else if (errorOutput.indexOf("Invalid Login") != -1) {
                    String toLog = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "ARU_MISSING_CREDENTIALS");
                    OiiolTextLogger.appendText(toLog);
                } else {
                    errorOutput = xmlString;
                }
            } else {
                errorOutput = xmlString;
            }
        }
        return errorOutput;
    }

    private ArrayList getPatchData(String url, String patch_type) throws SAXException, IOException, ParseException, OiimARUAuthException {
        ArrayList<OiimARUPatchData> patchList = new ArrayList<OiimARUPatchData>();
        OiimARUPatchData patchData = null;
        String xmlString = this.getPatchUrlXML(url);
        String errorOutput = OiimARUConnection.checkXMLoutput(xmlString);
        if (errorOutput != null) {
            this.m_errorList.add(errorOutput);
            return null;
        }
        XMLDocument theXMLDoc = OiimARUConnection.parseString(xmlString);
        if (theXMLDoc.hasChildNodes()) {
            Node firstChild = theXMLDoc.getFirstChild();
            Node firstNode = firstChild.getFirstChild();
            if (firstNode.getNodeName().equals(ERROR_TAG)) {
                NodeList nl = firstNode.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node err = nl.item(i);
                    if (err == null) continue;
                    this.m_errorList.add(err.getNodeValue());
                    OiiolTextLogger.appendText(err.getNodeValue());
                }
                return null;
            }
            boolean showAll = true;
            if (patch_type != null && patch_type.equals("patch")) {
                showAll = false;
            }
            NodeList nl = firstChild.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node patchNode = nl.item(i);
                if (!patchNode.getNodeName().equals("patch")) continue;
                patchData = OiimARUConnection.getPatchDataFromXMLDoc(patchNode);
                if (debug) {
                    OiiolTextLogger.appendText("aruId = " + patchData.getAruId() + ": bugNo=" + patchData.getBugNo());
                } else {
                    OiiolTextLogger.appendText("debug was not enabled ...aruId = " + patchData.getAruId() + ": bugNo=" + patchData.getBugNo());
                }
                if (!showAll && !patchData.getType().equalsIgnoreCase(patch_type)) continue;
                patchList.add(patchData);
            }
        }
        return patchList;
    }

    private String getUrl(int bugNo, int platform, int language, int release, String patch_type, String aruUrl) {
        String platformArg = "";
        String languageArg = "";
        String releaseArg = "";
        String patchTypeArg = "";
        if (platform != -1) {
            platformArg = PLATFORM_PROP + platform;
        }
        if (language != -1) {
            languageArg = LANGUAGE_PROP + language;
        }
        if (release != -1) {
            releaseArg = RELEASE_PROP + release;
        }
        if (patch_type != null && patch_type.trim().length() > 0) {
            patchTypeArg = PATCH_TYPE_PROP + patch_type;
        }
        return aruUrl + s_OiimARUConnectionLookup[0] + EMAIL_PROP + BUG_PROP + bugNo + platformArg + languageArg + releaseArg + patchTypeArg;
    }

    private String getPatchUrlXML(String urlString) throws OiimARUAuthException {
        String stsText = null;
        try {
            URL url = new URL(urlString);
            OiiolTextLogger.appendText("lookupURL: " + url);
            HTTPConnection conn = this.getNewHTTPConnection(url);
            stsText = this.getPatchUrlXML(urlString, conn);
        }
        catch (Throwable e) {
            OiimARUConnection.throwExceptionObject(e);
        }
        return stsText;
    }

    protected String getPatchUrlXML(String urlString, HTTPConnection conn) throws OiimARUAuthException {
        int stsCode = -1;
        String stsMsg = null;
        String stsText = null;
        try {
            URL url = new URL(urlString);
            HTTPResponse response = conn.Get(url.getFile());
            stsCode = response.getStatusCode();
            if (stsCode != 200) {
                OiimARUConnection.checkStatusCodeAndThrowException(stsCode);
            }
            stsMsg = response.getReasonLine();
            stsText = response.getText();
            if (debug) {
                StringBuffer log = new StringBuffer();
                log.append("**Getting XML from a particular URL: ");
                log.append("URL:").append(urlString).append(";");
                log.append("Status Code:").append(stsCode).append(";");
                log.append("Status Message:").append(stsMsg).append(";");
                OiiolTextLogger.appendText(log.toString());
            }
        }
        catch (Throwable e) {
            OiimARUConnection.throwExceptionObject(e);
        }
        return stsText;
    }

    public boolean downloadARUData(String directory_path) throws IOException {
        if (!new File(directory_path).exists()) {
            new File(directory_path).mkdirs();
        }
        return this.downloadARUData(9, directory_path, this.getaruUrl()) && this.downloadARUData(10, directory_path, this.getaruUrl()) && this.downloadARUData(4, directory_path, this.getaruUrl());
    }

    public boolean downloadARUData(String directory_path, String cpuUrl) throws IOException {
        if (!new File(directory_path).exists()) {
            new File(directory_path).mkdirs();
        }
        return this.downloadARUData(9, directory_path, cpuUrl) && this.downloadARUData(10, directory_path, cpuUrl) && this.downloadARUData(4, directory_path, cpuUrl);
    }

    public boolean removeARUData(String directory_path) {
        boolean ret = this.removeARUData(directory_path, false);
        return ret;
    }

    public boolean removeARUData(String directory_path, boolean removeDirectory) {
        File delDir;
        boolean ret = true;
        for (int i = 3; i <= 10; ++i) {
            File delFile = new File(OiixPathOps.concatPath(directory_path, s_aruDirectoryLookup[i]));
            if (!delFile.exists() || delFile.delete()) continue;
            OiiolTextLogger.appendText("Failed to delete File at " + delFile.getAbsolutePath());
            ret = false;
        }
        if (removeDirectory && !(delDir = new File(directory_path)).delete()) {
            OiiolTextLogger.appendText("Failed to delete directory at " + delDir.getAbsolutePath());
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean downloadARUData(int whereIdx, String directory_path, String cpuUrl) throws IOException {
        InputStream result = null;
        OutputStreamWriter fos = null;
        try {
            OiimARUConnection aruConn = OiimARUConnection.getAruConnection();
            if (aruConn == null) {
                boolean bl = false;
                return bl;
            }
            URL url = new URL(cpuUrl + s_OiimARUConnectionLookup[whereIdx]);
            boolean isSecured = url.getProtocol().equalsIgnoreCase(HTTPS_PROT);
            if (isSecured) {
                try {
                    result = aruConn.getNewHTTPConnection(url).Get(url.getFile()).getInputStream();
                }
                catch (ModuleException m) {
                    HttpURLConnection connection = new HttpURLConnection(url);
                    aruConn.authentication(connection);
                    result = connection.getInputStream();
                }
            } else {
                HttpURLConnection connection = new HttpURLConnection(url);
                aruConn.authentication(connection);
                result = connection.getInputStream();
            }
            InputStreamReader isr = new InputStreamReader(result);
            BufferedReader br = new BufferedReader(isr);
            File outFile = new File(directory_path, s_aruDirectoryLookup[whereIdx]);
            fos = new FileWriter(outFile);
            BufferedWriter bw = new BufferedWriter(fos);
            String line = null;
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
        catch (Exception e) {
            if (debug) {
                OiiolTextLogger.appendException(e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (result != null) {
                result.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return true;
    }

    public static String getReadmeContents(OiimARUConnection aruConn, String urlString) throws IOException {
        URL url = new URL(urlString);
        InputStream result = null;
        boolean isSecured = url.getProtocol().equalsIgnoreCase(HTTPS_PROT);
        if (isSecured) {
            try {
                result = aruConn.getNewHTTPConnection(url).Get(url.getFile()).getInputStream();
            }
            catch (ModuleException m) {
                HttpURLConnection connection = new HttpURLConnection(url);
                aruConn.authentication(connection);
                result = connection.getInputStream();
            }
        } else {
            HttpURLConnection connection = new HttpURLConnection(url);
            aruConn.authentication(connection);
            result = connection.getInputStream();
        }
        if (result == null) {
            return "";
        }
        try {
            InputStreamReader isr = new InputStreamReader(result);
            BufferedReader br = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            String line = null;
            boolean first = true;
            while ((line = br.readLine()) != null) {
                if (line.toLowerCase().indexOf("charset=") >= 0) continue;
                sb.append(line);
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (IOException ioEx) {
            return "";
        }
    }

    public void authentication(HttpURLConnection urlCon) {
        urlCon.setRequestProperty("Authorization", this.m_encoding);
    }

    public static void authenticate(String metalinkUsername, String metalinkPassword, String url) throws OiimARUAuthException {
        try {
            URL authURL = new URL(url + s_OiimARUConnectionLookup[3]);
            HTTPConnection conn = OiimARUConnection.getNewHTTPConnection(authURL, metalinkUsername, metalinkPassword);
            CookieModule.discardAllCookies((Object)PATCH_CONTEXT);
            HTTPResponse response = conn.Get(authURL.getFile());
            int stsCode = response.getStatusCode();
            StringBuffer log = new StringBuffer();
            log.append("Validating MetaLink Credentials. ");
            log.append("MetalinkAuthorizationURL:").append(authURL).append(";");
            log.append("MetalinkUsername:").append(metalinkUsername).append(";");
            log.append("Status Code:").append(stsCode).append(";");
            if (debug) {
                OiiolTextLogger.appendText(log.toString());
            }
            if (stsCode != 200) {
                OiimARUConnection.checkStatusCodeAndThrowException(stsCode);
            }
        }
        catch (Throwable e) {
            OiimARUConnection.throwExceptionObject(e);
        }
    }

    public static void checkStatusCodeAndThrowException(int stsCode) throws OiimARUAuthException {
        switch (stsCode) {
            case 305: 
            case 407: {
                OiimARUConnection.throwExceptionObject(2, "NO_PROXY_SET");
            }
            case 400: {
                OiimARUConnection.throwExceptionObject(4, "MALFORMED_URL");
            }
            case 401: 
            case 550: {
                OiimARUConnection.throwExceptionObject(0, "ACCESS_DENIED");
            }
            case 403: {
                OiimARUConnection.throwExceptionObject(7, "CONNECTION_REFUSED");
            }
            case 301: 
            case 307: 
            case 308: 
            case 404: 
            case 410: {
                OiimARUConnection.throwExceptionObject(8, "URL_NOT_FOUND");
            }
            case 408: 
            case 598: 
            case 599: {
                OiimARUConnection.throwExceptionObject(9, "REQUEST_TIMEOUT");
            }
            case 500: {
                OiimARUConnection.throwExceptionObject(11, "SERVER_ERROR");
            }
            case 502: {
                OiimARUConnection.throwExceptionObject(12, "BAD_GATEWAY");
            }
            case 505: {
                OiimARUConnection.throwExceptionObject(13, "PROTOCOL_NOT_SUPPORTED");
            }
        }
        OiimARUConnection.throwExceptionObject(6, "NOT_ABLE_TO_CONNECT_TO_MOS");
    }

    protected static void throwExceptionObject(Throwable e) throws OiimARUAuthException {
        OiimARUAuthException ae = new OiimARUAuthException(e);
        if (debug) {
            if (e != null) {
                OiiolTextLogger.appendText("Exception in the connection");
                OiiolTextLogger.appendException(e);
            }
            OiiolTextLogger.appendText("MetaLink ERROR = " + ae.getErrorString());
        }
        throw ae;
    }

    public static void throwExceptionObject(int errorCode, String errorString) throws OiimARUAuthException {
        OiimARUConnection.throwExceptionObject(null, errorCode, errorString);
    }

    public static void throwExceptionObject(Throwable e, int errorCode, String errorString) throws OiimARUAuthException {
        OiimARUAuthException ae = new OiimARUAuthException();
        ae.setErrorCode(errorCode);
        if (debug) {
            if (e != null) {
                OiiolTextLogger.appendText("Exception in the connection");
                OiiolTextLogger.appendException(e);
            }
            OiiolTextLogger.appendText("MetaLink ERROR = " + errorString);
        }
        throw ae;
    }

    private static XMLDocument parseString(String xmlString) throws SAXException, IOException {
        XMLDocument theXMLDoc = null;
        DOMParser theParser = new DOMParser();
        ByteArrayInputStream theStream = new ByteArrayInputStream(xmlString.getBytes());
        theParser.parse((InputStream)theStream);
        theXMLDoc = theParser.getDocument();
        return theXMLDoc;
    }

    private static long parseLong(String longStr) {
        long longVal = -1L;
        try {
            if (longStr != null && longStr.trim().length() > 0) {
                longVal = Long.parseLong(longStr.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return longVal;
    }

    private static OiimARUPatchData getPatchDataFromXMLDoc(Node node) throws ParseException {
        HashMap<String, Node> hm = new HashMap<String, Node>();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            hm.put(child.getNodeName(), child);
        }
        String dateStr = OiimARUConnection.getFieldValue(hm, DATE_TAG);
        SimpleDateFormat df = new SimpleDateFormat(PATCH_DATE_FORMAT, Locale.US);
        Timestamp date = new Timestamp(df.parse(dateStr).getTime());
        long aruId = OiimARUConnection.parseLong(OiimARUConnection.getFieldValue(hm, "id"));
        String type = OiimARUConnection.getFieldValue(hm, "type");
        long product = OiimARUConnection.parseLong(OiimARUConnection.getFieldValue(hm, "product"));
        String status = OiimARUConnection.getFieldValue(hm, STATUS_TAG);
        String abs = OiimARUConnection.getFieldValue(hm, "abstract");
        String comments = OiimARUConnection.getFieldValue(hm, COMMENTS_TAG);
        long bugNo = OiimARUConnection.parseLong(OiimARUConnection.getFieldValue(hm, "bug"));
        long platform = OiimARUConnection.parseLong(OiimARUConnection.getFieldValue(hm, "platform"));
        long language = OiimARUConnection.parseLong(OiimARUConnection.getFieldValue(hm, "language"));
        String release = OiimARUConnection.getFieldValue(hm, "release");
        String automation = "C";
        String readmeUrl = OiimARUConnection.getFieldValue(hm, README_URL_TAG);
        String patchUrl = OiimARUConnection.getFieldValue(hm, PATCH_URL_TAG);
        long size = OiimARUConnection.parseLong(OiimARUConnection.getFieldValue(hm, SIZE_TAG));
        String manuallyPosted = "N";
        Timestamp lastReferenced = date;
        long fileLength = 0L;
        XMLElement tempNode = (XMLElement)hm.get(ADV_FIXESBUGS_TAG);
        OiimARUPatchData patchData = new OiimARUPatchData(aruId, status, type, bugNo, product, platform, language, release, abs, date, readmeUrl, patchUrl, comments, size, automation, manuallyPosted, lastReferenced, fileLength);
        return patchData;
    }

    private static String getFieldValue(HashMap hm, String fieldName) {
        Node tempNode = (Node)hm.get(fieldName);
        String retVal = "";
        if (tempNode != null && (tempNode = tempNode.getFirstChild()) != null) {
            retVal = tempNode.getNodeValue().trim();
        }
        return retVal;
    }

    private static String encodeAuthorization(String username, String password) {
        String authorization = username + ":" + password;
        BASE64Encoder enCoder = new BASE64Encoder();
        return "Basic " + enCoder.encode(authorization.getBytes());
    }

    public HTTPConnection getNewHTTPConnection(URL url) throws ProtocolNotSuppException {
        return OiimARUConnection.getNewHTTPConnection(url, this.m_user, this.m_passwd);
    }

    public static HTTPConnection getNewHTTPConnection(URL url, String user, String passwd) throws ProtocolNotSuppException {
        HTTPConnection conn = null;
        try {
            conn = new HTTPConnection(url);
            conn.setContext(PATCH_CONTEXT);
            conn.addBasicAuthorization(METALINK_REALM, user, passwd);
            OiiiPlaceHolderAuthenticate authInfo = OiiiPlaceHolderAuthenticate.getAuthObject(null);
            conn.setAllowUserInteraction(false);
            conn.setCurrentProxy(authInfo.getProxyHost(), authInfo.getProxyPort());
            String protocol = url.getProtocol();
            NVPair[] defHeaders = conn.getDefaultHeaders();
            int defaultHeadersLength = defHeaders == null ? 0 : defHeaders.length;
            NVPair[] newHeaders = new NVPair[defaultHeadersLength + 1];
            for (int nlen = 0; nlen < defaultHeadersLength; ++nlen) {
                newHeaders[nlen] = defHeaders[nlen];
            }
            String raw = user + ":" + passwd;
            String enc = new BASE64Encoder().encode(raw.getBytes());
            newHeaders[nlen] = new NVPair("Authorization", "Basic " + enc);
            conn.setDefaultHeaders(newHeaders);
            boolean isSecured = protocol.equalsIgnoreCase(HTTPS_PROT);
            if (isSecured) {
                SSLSocketFactory socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                conn.setSSLSocketFactory(socketFactory);
            }
        }
        catch (ProtocolNotSuppException ex) {
            OiiolTextLogger.appendErrorText("Protocol:" + url.getProtocol() + " not supported.");
            OiiolTextLogger.appendErrorText(ex.getMessage());
            if (debug) {
                ex.printStackTrace(System.err);
            }
            throw ex;
        }
        return conn;
    }

    public synchronized String startDownload(OiimARUConnection aruConn, String aruUrl, String aruPatchUrl, String destDir, OiimDownloadProgressStatusHolder dp) {
        String theFile = null;
        String fileName = null;
        InputStream is = null;
        try {
            String fullURL = aruUrl + aruPatchUrl;
            fileName = aruPatchUrl.substring(aruPatchUrl.lastIndexOf("=") + 1);
            theFile = destDir + File.separator + fileName;
            OiiolTextLogger.appendText("\n\nDownloading patch " + fileName + "...");
            File file = new File(theFile);
            URL url = new URL(URLDecoder.decode(fullURL, CHARACTER_ENCODING));
            HttpURLConnection urlConn = new HttpURLConnection(url);
            aruConn.authentication(urlConn);
            boolean isSecured = url.getProtocol().equalsIgnoreCase(HTTPS_PROT);
            if (isSecured) {
                HTTPConnection conn = this.getNewHTTPConnection(url);
                HTTPResponse response = conn.Get(url.getFile());
                is = response.getInputStream();
            } else {
                is = urlConn.getInputStream();
            }
            FileOutputStream os = new FileOutputStream(file);
            this.writeZip(is, os, dp);
            os.close();
            OiiolTextLogger.appendText(" Done.");
        }
        catch (IOException e) {
            OiiolTextLogger.appendText("\nFailed to download the patch : " + fileName);
            if (debug) {
                e.printStackTrace(System.err);
            }
            dp.setStatus(4);
        }
        catch (Exception e) {
            OiiolTextLogger.appendText("\nFailed to download the patch : " + fileName);
            if (debug) {
                e.printStackTrace(System.err);
            }
            dp.setStatus(4);
        }
        return theFile;
    }

    private void writeZip(InputStream is, OutputStream os, OiimDownloadProgressStatusHolder dp) throws IOException {
        byte[] tempbuf = new byte[100000];
        int bytesRead = 0;
        while ((bytesRead = is.read(tempbuf, 0, 100000)) != -1) {
            os.write(tempbuf, 0, bytesRead);
            dp.setBytesDownloaded(dp.getBytesDownloaded() + (long)bytesRead);
            dp.setPercentComplete(dp.getBytesDownloaded() * 100L / dp.getTotalSizeInBytes());
            dp.setStatus(1);
        }
        is.close();
    }

    private synchronized ArrayList unzip(String zipFileName, String toLocation) throws IOException {
        ZipEntry entry;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(zipFileName));
        OiixZipInputStream zin = new OiixZipInputStream((InputStream)in, zipFileName);
        HashMap externalAttrInfo = zin.getPermissionInfo();
        ArrayList<String> fileNames = new ArrayList<String>();
        String FileName = new File(zipFileName).getName();
        String BugNo = FileName.substring(FileName.indexOf("p") + 1, FileName.indexOf("_"));
        while ((entry = zin.getNextEntry()) != null) {
            int count;
            String extractPath = toLocation + File.separator + entry.getName();
            fileNames.add(extractPath);
            int permissionInfo = Integer.parseInt(externalAttrInfo.get(entry.getName()).toString());
            if (entry.isDirectory()) {
                File e = new File(extractPath);
                if (!e.exists()) {
                    e.mkdirs();
                }
                if (permissionInfo == 0 || OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) != -1) continue;
                try {
                    OiipuUnixOps.chmod(extractPath, permissionInfo);
                }
                catch (OiilNativeException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            File entryFile = new File(extractPath);
            if (entryFile.exists()) {
                entryFile.delete();
            }
            byte[] data = new byte[512];
            File dir = entryFile.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(extractPath);
            BufferedOutputStream dest = new BufferedOutputStream(fos, 512);
            while ((count = zin.read(data, 0, 512)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            if (permissionInfo == 0 || OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) != -1) continue;
            try {
                OiipuUnixOps.chmod(extractPath, permissionInfo);
            }
            catch (OiilNativeException e1) {
                e1.printStackTrace();
            }
        }
        ((InputStream)in).close();
        File zipFile = new File(zipFileName);
        if (zipFile.exists()) {
            zipFile.delete();
        }
        return fileNames;
    }

    public synchronized void unzipZipsInDir(File dir) {
        String[] fileList = dir.list();
        String fileName = null;
        for (int i = 0; i < fileList.length; ++i) {
            fileName = fileList[i];
            fileName = dir.getAbsolutePath() + File.separator + fileName;
            File fDir = new File(fileName);
            if (fDir.isDirectory()) {
                this.unzipZipsInDir(fDir);
            }
            if (!fDir.isFile() || !fileName.endsWith(".zip")) continue;
            try {
                OiiolTextLogger.appendText("\nUnzipping the file " + fileName + "...");
                this.unzip(fileName, dir.getAbsolutePath());
                OiiolTextLogger.appendText(" Done.");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static boolean downloadUpdates(ArrayList bids, OiimDownloadProgressStatusHolder dp) {
        return OiimARUConnection.downloadUpdates(bids, dp, "");
    }

    public static boolean downloadUpdates(ArrayList bids, OiimDownloadProgressStatusHolder dp, String destDir) {
        ArrayList<String> patchUrls = new ArrayList<String>();
        ArrayList downloadLocations = new ArrayList();
        long totalBytes = 0L;
        String LATEST_UPDATES = "LatestUpdates";
        String UPDATES_LOCATION = "Shiphome";
        String concatPath = OiixPathOps.concatPath(LATEST_UPDATES, UPDATES_LOCATION);
        File dest = new File(destDir = destDir != null && destDir.equals("") ? OiixPathOps.concatPath(System.getProperty("user.home"), concatPath) : OiixPathOps.concatPath(destDir, concatPath));
        if (!dest.exists()) {
            dest.mkdirs();
        }
        int size = bids == null ? 0 : bids.size();
        OiimARUConnection aruConn = null;
        try {
            aruConn = OiimARUConnection.getAruConnection();
        }
        catch (OiimARUAuthException e) {
            OiiolTextLogger.appendException(e);
            aruConn = null;
        }
        if (aruConn == null) {
            OiiolTextLogger.appendText("Couldnt establish connection with metalink");
            dp.setStatus(4);
            return false;
        }
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)bids.get(i);
            ArrayList patchDataList = OiimARUConnection.download(aruConn, bid);
            int size_patchData = patchDataList == null ? 0 : patchDataList.size();
            for (int j = 0; j < size_patchData; ++j) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                patchUrls.add(pd.getPatchUrl());
                totalBytes += pd.getSize();
            }
        }
        dp.setStatus(0);
        dp.setTotalSizeInBytes(totalBytes);
        if (patchUrls.size() == 0) {
            return false;
        }
        OiimDownloadThread dt = new OiimDownloadThread(aruConn, destDir, patchUrls, dp, bids);
        Thread t = new Thread(dt);
        t.start();
        m_threadList.put(dt, t);
        return true;
    }

    public static String getReadMeContents(OiiiPatchMetadata bid) throws IOException, OiimARUAuthException {
        String readMe = "";
        OiimARUConnection aruConn = OiimARUConnection.getAruConnection();
        ArrayList patchDataList = OiimARUConnection.download(aruConn, bid);
        if (patchDataList.size() > 0) {
            OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(0);
            readMe = OiimARUConnection.getReadmeContents(aruConn, aruConn.getaruUrl() + pd.getReadmeUrl());
        }
        return readMe;
    }

    public static boolean downloadCPUs(ArrayList bids, OiimDownloadProgressStatusHolder dp) {
        return OiimARUConnection.downloadCPUs(bids, dp, "");
    }

    public static boolean downloadCPUs(ArrayList bids, OiimDownloadProgressStatusHolder dp, String destDir) {
        ArrayList<String> patchUrls = new ArrayList<String>();
        ArrayList downloadLocations = new ArrayList();
        long totalBytes = 0L;
        String LATEST_UPDATES = "LatestUpdates";
        String CPU_LOCATION = "CPUs";
        String concatPath = OiixPathOps.concatPath(LATEST_UPDATES, CPU_LOCATION);
        File dest = new File(destDir = destDir != null && destDir.equals("") ? OiixPathOps.concatPath(System.getProperty("user.home"), concatPath) : OiixPathOps.concatPath(destDir, concatPath));
        if (!dest.exists()) {
            dest.mkdirs();
        }
        int size = bids == null ? 0 : bids.size();
        OiimARUConnection aruConn = null;
        try {
            aruConn = OiimARUConnection.getAruConnection();
        }
        catch (OiimARUAuthException e) {
            OiiolTextLogger.appendException(e);
            aruConn = null;
        }
        if (aruConn == null) {
            OiiolTextLogger.appendText("Couldnt establish connection with metalink");
            dp.setStatus(4);
            return false;
        }
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)bids.get(i);
            ArrayList patchDataList = OiimARUConnection.download(aruConn, bid);
            int size_patchData = patchDataList == null ? 0 : patchDataList.size();
            for (int j = 0; j < size_patchData; ++j) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                patchUrls.add(pd.getPatchUrl());
                totalBytes += pd.getSize();
            }
        }
        dp.setStatus(0);
        dp.setTotalSizeInBytes(totalBytes);
        if (patchUrls.size() == 0) {
            return false;
        }
        OiimDownloadThread dt = new OiimDownloadThread(aruConn, destDir, patchUrls, dp, bids);
        Thread t = new Thread(dt);
        t.start();
        m_threadList.put(dt, t);
        return true;
    }

    public static String getMetaDataXML(String location, int ID, String version, String destDir) {
        long totalBytes = 0L;
        OiimDownloadProgressStatusHolder dp = new OiimDownloadProgressStatusHolder();
        if (location.equalsIgnoreCase(S_METALINK_URL) || location.equalsIgnoreCase(S_METALINK_URL_HTTPS)) {
            OiiiPatchMetadata pm = new OiiiPatchMetadata(ID, -1, version);
            ArrayList<OiiiPatchMetadata> bids = new ArrayList<OiiiPatchMetadata>();
            bids.add(pm);
            if (destDir != null && destDir.equals("")) {
                OiiolTextLogger.appendText("download Location cannot be empty for metadata xml");
                return null;
            }
            File dest = new File(destDir);
            if (!dest.exists()) {
                dest.mkdirs();
            }
            OiimARUConnection aruConn = null;
            try {
                aruConn = OiimARUConnection.getAruConnection();
            }
            catch (OiimARUAuthException e) {
                OiiolTextLogger.appendException(e);
                aruConn = null;
            }
            if (aruConn == null) {
                OiiolTextLogger.appendText("Couldnt establish connection with metalink");
                return null;
            }
            ArrayList patchDataList = OiimARUConnection.download(aruConn, pm);
            ArrayList<String> patchUrls = new ArrayList<String>();
            if (patchDataList != null && patchDataList.size() > 0) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(0);
                String aruPatchUrl = pd.getPatchUrl();
                patchUrls.add(aruPatchUrl);
                totalBytes += pd.getSize();
            }
            if (patchUrls.size() == 0) {
                return null;
            }
            dp.setStatus(0);
            dp.setTotalSizeInBytes(totalBytes);
            OiimDownloadThread dt = new OiimDownloadThread(aruConn, destDir, patchUrls, dp, bids);
            Thread t = new Thread(dt);
            t.start();
            try {
                t.join();
            }
            catch (Exception e) {
                OiiolTextLogger.appendErrorText(e.getMessage());
            }
        }
        if (dp.getStatus() == 3L) {
            File f = new File(destDir + File.separator + ID);
            File[] listFiles = f.listFiles();
            for (int i = 0; i < listFiles.length; ++i) {
                String fileName = listFiles[i].getName();
                if (!listFiles[i].isFile() || !fileName.endsWith(".xml")) continue;
                return listFiles[i].getAbsolutePath();
            }
        }
        return null;
    }

    public static long getTotalPatchSize(ArrayList bids) throws OiimARUAuthException {
        long totalBytes = 0L;
        OiimARUConnection aruConn = null;
        try {
            aruConn = OiimARUConnection.getAruConnection();
        }
        catch (OiimARUAuthException e) {
            OiiolTextLogger.appendException(e);
            aruConn = null;
            throw e;
        }
        int size = bids == null ? 0 : bids.size();
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)bids.get(i);
            ArrayList patchDataList = OiimARUConnection.download(aruConn, bid);
            int size_patchData = patchDataList == null ? 0 : patchDataList.size();
            for (int j = 0; j < size_patchData; ++j) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                totalBytes += pd.getSize();
            }
        }
        return totalBytes;
    }

    public static boolean downloadOneOff(ArrayList bids, OiimDownloadProgressStatusHolder dp) {
        return OiimARUConnection.downloadOneOff(bids, dp, "");
    }

    public static boolean downloadOneOff(ArrayList bids, OiimDownloadProgressStatusHolder dp, String destDir) {
        ArrayList<String> patchUrls = new ArrayList<String>();
        long totalBytes = 0L;
        String LATEST_UPDATES = "LatestUpdates";
        String ONEOFF_LOCATION = "OneOffs";
        String concatPath = OiixPathOps.concatPath(LATEST_UPDATES, ONEOFF_LOCATION);
        File dest = new File(destDir = destDir != null && destDir.equals("") ? OiixPathOps.concatPath(System.getProperty("user.home"), concatPath) : OiixPathOps.concatPath(destDir, concatPath));
        if (!dest.exists()) {
            dest.mkdirs();
        }
        int size = bids == null ? 0 : bids.size();
        OiimARUConnection aruConn = null;
        try {
            aruConn = OiimARUConnection.getAruConnection();
        }
        catch (OiimARUAuthException e) {
            OiiolTextLogger.appendException(e);
            aruConn = null;
        }
        if (aruConn == null) {
            OiiolTextLogger.appendText("Couldnt establish connection with metalink");
            dp.setStatus(4);
            return false;
        }
        for (int i = 0; i < size; ++i) {
            OiiiPatchMetadata bid = (OiiiPatchMetadata)bids.get(i);
            ArrayList patchDataList = OiimARUConnection.download(aruConn, bid);
            int size_patchData = patchDataList == null ? 0 : patchDataList.size();
            for (int j = 0; j < size_patchData; ++j) {
                OiimARUPatchData pd = (OiimARUPatchData)patchDataList.get(j);
                patchUrls.add(pd.getPatchUrl());
                totalBytes += pd.getSize();
            }
        }
        dp.setStatus(0);
        dp.setTotalSizeInBytes(totalBytes);
        if (patchUrls.size() == 0) {
            return false;
        }
        OiimDownloadThread dt = new OiimDownloadThread(aruConn, destDir, patchUrls, dp, bids);
        Thread t = new Thread(dt);
        t.start();
        m_threadList.put(dt, t);
        return true;
    }

    public static String getDefaultProxy() {
        String retString;
        block7: {
            retString = null;
            int curPlat = OiixPlatform.getCurrentPlatform();
            int groupID = OiixPlatform.getPlatGroupIDFromCommonName("WINDOWS");
            boolean isWindows = OiixGeneralQueries.isPlatInGroup(groupID, curPlat);
            if (isWindows) {
                try {
                    String key = "HKEY_CURRENT_USER";
                    String subKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
                    String value = "ProxyEnable";
                    int retInt = OiixRegistryOps.RegGetNumValuew32(key, subKey, value);
                    if (retInt == 1) {
                        key = "HKEY_CURRENT_USER";
                        subKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
                        value = "ProxyServer";
                        retString = OiixRegistryOps.RegGetValue(key, subKey, value);
                        if (retString != null && (OiixFunctionOps.strContains(retString, "http=").booleanValue() || OiixFunctionOps.strContains(retString, "gopher=").booleanValue() || OiixFunctionOps.strContains(retString, "ftp=").booleanValue() || OiixFunctionOps.strContains(retString, "https=").booleanValue() || OiixFunctionOps.strContains(retString, "socks=").booleanValue())) {
                            String[] sl_proxyList = OiixFunctionOps.explodeString(retString, ";");
                            for (int index = 0; index <= sl_proxyList.length - 1; ++index) {
                                if (!OiixFunctionOps.strContains(sl_proxyList[index], "http=").booleanValue()) continue;
                                retString = OiixFunctionOps.substring(sl_proxyList[index], OiixFunctionOps.strLength("http="), OiixFunctionOps.strLength(sl_proxyList[index]));
                                return retString;
                            }
                            return retString;
                        }
                        return retString;
                    }
                    break block7;
                }
                catch (OiilNativeException ne) {
                    OiiolTextLogger.appendException(ne);
                    return retString;
                }
            }
            String val = OiixEnvironmentOps.getEnv(HTTP_PROXY_VAR);
            if (val.equals("")) {
                return null;
            }
        }
        return retString;
    }

    public static String[] getDefaultHostAndPort() {
        String ret = OiimARUConnection.getDefaultProxy();
        if (ret != null) {
            String[] host_port = OiixFunctionOps.explodeString(ret, ":");
            return host_port;
        }
        return new String[0];
    }

    public static OiimARUConnection getAruConnection() throws OiimARUAuthException {
        if (aruConnSingleton == null) {
            String[] s;
            System.setProperty(SYSTEM_PROTOCOL_HANDLER, HTTPCLIENT_PROTOCOL_HANDLER);
            OiiiPlaceHolderAuthenticate authInfo = OiiiPlaceHolderAuthenticate.getAuthObject(null);
            String METALINK_URL = authInfo.getMetalinkLocation();
            String METALINK_USERNAME = authInfo.getAuthenticateUser();
            String METALINK_PASSWORD = authInfo.getAuthenticatePassword();
            if (authInfo.getProxyHost() == null && (s = OiimARUConnection.getDefaultHostAndPort()).length > 0) {
                authInfo.setProxyHost(s[0]);
                String s_port = s.length >= 2 ? s[1] : DEFAULT_PROXY_PORT;
                authInfo.setProxyPort(Integer.parseInt(s_port));
            }
            OiimHTTPProxyUtil proxy = new OiimHTTPProxyUtil(authInfo.getProxyHost(), authInfo.getProxyPort(), authInfo.getProxyRealm(), authInfo.getProxyUser(), authInfo.getProxyPwd(), authInfo.getDontProxyFor());
            OiimHTTPProxyUtil.setProxyInfo(proxy);
            OiimARUConnection.authenticate(METALINK_USERNAME, METALINK_PASSWORD, METALINK_URL);
            aruConnSingleton = new OiimARUConnection(METALINK_URL, METALINK_USERNAME, METALINK_PASSWORD);
        }
        return aruConnSingleton;
    }

    public static void resetAruConnection() {
        aruConnSingleton = null;
        OiiiPlaceHolderAuthenticate.resetAuthObject();
    }

    public static ArrayList download(OiimARUConnection aruConn, OiiiPatchMetadata bid) {
        Object filename = null;
        ArrayList<OiimARUPatchData> patchList = new ArrayList<OiimARUPatchData>();
        try {
            ArrayList al = null;
            OiimARUPatchData pd2 = null;
            Object bugList = null;
            al = aruConn.getPatchData(bid.getPatchBugNumber(), bid.getApplicablePlatform(), -1, -1, bid.getType());
            if (al != null) {
                for (OiimARUPatchData pd2 : al) {
                    if (bid.getLanguage() != -1 && bid.getVersion().equalsIgnoreCase("-1") ? pd2.getLanguage() != (long)bid.getLanguage() : (bid.getLanguage() == -1 && !bid.getVersion().equalsIgnoreCase("-1") ? !pd2.getRelease().equalsIgnoreCase(bid.getVersion()) : bid.getLanguage() != -1 && !bid.getVersion().equalsIgnoreCase("-1") && (pd2.getLanguage() != (long)bid.getLanguage() || pd2.getRelease() != bid.getVersion()))) continue;
                    patchList.add(pd2);
                }
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendErrorText(e.getMessage());
        }
        return patchList;
    }

    public static void cancelAllDownloads() {
        for (OiimDownloadThread dt : m_threadList.keySet()) {
            Thread t = (Thread)m_threadList.get(dt);
            t.stop();
            dt.cleanUp();
        }
    }

    public String getaruUrl() {
        return this.m_aruUrl;
    }

    static {
        HTTPConnection.setDefaultTimeout((int)60000);
        HTTPConnection.setDefaultConnectionTimeout((int)60000);
        s_OiimARUConnectionLookup = new String[11];
        s_aruDirectoryLookup = new String[11];
        OiimARUConnection.s_OiimARUConnectionLookup[0] = "/ARULink/XMLAPI/query_patches";
        OiimARUConnection.s_OiimARUConnectionLookup[1] = "/ARULink/XMLAPI/download_patch";
        OiimARUConnection.s_OiimARUConnectionLookup[2] = "/ARULink/XMLAPI/download_readme";
        OiimARUConnection.s_OiimARUConnectionLookup[3] = "/ARULink/XMLAPI/download_seed_data?table=aru_products";
        OiimARUConnection.s_OiimARUConnectionLookup[4] = "/ARULink/XMLAPI/download_seed_data?table=aru_releases";
        OiimARUConnection.s_OiimARUConnectionLookup[5] = "/ARULink/XMLAPI/download_seed_data?table=aru_platforms";
        OiimARUConnection.s_OiimARUConnectionLookup[6] = "/ARULink/XMLAPI/download_seed_data?table=aru_languages";
        OiimARUConnection.s_OiimARUConnectionLookup[7] = "/ARULink/XMLAPI/download_seed_data?table=aru_product_groups";
        OiimARUConnection.s_OiimARUConnectionLookup[8] = "/ARULink/XMLAPI/download_seed_data?table=aru_product_releases";
        OiimARUConnection.s_OiimARUConnectionLookup[9] = "/ARULink/XMLAPI/download_seed_data?table=aru_component_releases ";
        OiimARUConnection.s_OiimARUConnectionLookup[10] = "/ARULink/XMLAPI/query_advisories";
        OiimARUConnection.s_aruDirectoryLookup[0] = "query_patches.xml";
        OiimARUConnection.s_aruDirectoryLookup[1] = "download_patch.xml";
        OiimARUConnection.s_aruDirectoryLookup[2] = "download_readme.xml";
        OiimARUConnection.s_aruDirectoryLookup[3] = "aru_products.xml";
        OiimARUConnection.s_aruDirectoryLookup[4] = "aru_releases.xml";
        OiimARUConnection.s_aruDirectoryLookup[5] = "aru_platforms.xml";
        OiimARUConnection.s_aruDirectoryLookup[6] = "aru_languages.xml";
        OiimARUConnection.s_aruDirectoryLookup[7] = "aru_product_groups.xml";
        OiimARUConnection.s_aruDirectoryLookup[8] = "aru_product_releases.xml";
        OiimARUConnection.s_aruDirectoryLookup[9] = "aru_component_releases.xml";
        OiimARUConnection.s_aruDirectoryLookup[10] = "query_advisories.xml";
        PATCH_CONTEXT = new String("context_patch");
        debug = true;
        aruConnSingleton = null;
        m_threadList = new HashMap();
    }
}

