/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiim;

import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;

public class OiimARUAuthException
extends Exception {
    public static final int ACCESS_DENIED = 0;
    public static final int INVALID_URL = 1;
    public static final int NO_PROXY_SET = 2;
    public static final int UNKNOWN_HOST = 3;
    public static final int MALFORMED_URL = 4;
    public static final int DWNLD_PATCH_ERR = 5;
    public static final int NOT_ABLE_TO_CONNECT_TO_MOS = 6;
    public static final int CONNECTION_REFUSED = 7;
    public static final int URL_NOT_FOUND = 8;
    public static final int REQUEST_TIMEOUT = 9;
    public static final int SERVER_ERROR = 11;
    public static final int BAD_GATEWAY = 12;
    public static final int PROTOCOL_NOT_SUPPORTED = 13;
    public static final int UNKNOWN_ERROR = 14;
    public static final int HTTP_PARSE_ERROR = 15;
    public static final int LOGIN_FAILURE = 16;
    public static final int INVALID_RESOURCE = 17;
    public static final int EOF_ERROR = 18;
    public static final int FILE_NOT_FOUND = 19;
    public static final int PROTOCOL_ERROR = 20;
    private int errorCode = 0;
    private String errorString;

    public OiimARUAuthException() {
    }

    public OiimARUAuthException(Throwable e) {
        this.calculateErrorCode(e);
    }

    private void calculateErrorCode(Throwable e) {
        if (e instanceof OiimARUAuthException) {
            this.setErrorCode(((OiimARUAuthException)e).getErrorCode());
            this.setErrorString(((OiimARUAuthException)e).getErrorString());
        } else if (e instanceof ConnectException) {
            this.setErrorCode(9);
            this.setErrorString("REQUEST_TIMEOUT");
        } else if (e instanceof ParseException) {
            this.setErrorCode(15);
            this.setErrorString("HTTP_PARSE_ERROR");
        } else if (e instanceof ModuleException) {
            this.setErrorCode(11);
            this.setErrorString("SERVER_ERROR");
        } else if (e instanceof ProtocolNotSuppException) {
            this.setErrorCode(13);
            this.setErrorString("PROTOCOL_NOT_SUPPORTED");
        } else if (e instanceof MalformedURLException) {
            this.setErrorCode(4);
            this.setErrorString("MALFORMED_URL");
        } else if (e instanceof EOFException) {
            this.setErrorCode(18);
            this.setErrorString("EOF_ERROR");
        } else if (e instanceof FileNotFoundException) {
            this.setErrorCode(19);
            this.setErrorString("FILE_NOT_FOUND");
        } else if (e instanceof ProtocolException) {
            this.setErrorCode(20);
            this.setErrorString("PROTOCOL_ERROR");
        } else if (e instanceof NoRouteToHostException) {
            this.setErrorCode(2);
            this.setErrorString("NO_PROXY_SET");
        } else if (e instanceof SocketException) {
            this.setErrorCode(6);
            this.setErrorString("NOT_ABLE_TO_CONNECT_TO_MOS");
        } else if (e instanceof UnknownHostException) {
            this.setErrorCode(8);
            this.setErrorString("URL_NOT_FOUND");
        } else if (e instanceof InterruptedIOException) {
            this.setErrorCode(9);
            this.setErrorString("REQUEST_TIMEOUT");
        } else if (e instanceof IOException) {
            this.setErrorCode(17);
            this.setErrorString("INVALID_RESOURCE");
        } else {
            this.setErrorCode(14);
            this.setErrorString("UNKNOWN_ERROR");
        }
    }

    public OiimARUAuthException(String s) {
        super(s);
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public String getErrorString() {
        return this.errorString;
    }
}

