/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OiilXMLHelper {
    public static final String LIBRARY = "LIBRARY";
    public static final String NAME = "NAME";
    public static final String FORMAT_VER_STRING = "XMLFORMAT_VER";
    public static final String FORMAT_VERSION = "1.0";
    public static final String TYPE = "TYPE";
    public static final String VER = "VER";
    public static final String REPL_VER = "REPL_VER";
    public static final String MIN_INST_VER = "MIN_INST_VER";
    public static final String PLATS = "PLATS";
    public static final String PLAT = "PLAT";
    public static final String PLAT_SPECIFIC = "PLAT_SPECIFIC";
    public static final String ACTION = "ACTION";
    public static final String QUERY = "QUERY";
    public static final String DIALOG = "DIALOG";
    public static final String EXT_NAME_ID = "EXT_NAME_ID";
    public static final String ARG = "ARGUMENT";
    public static final String DESC_ID = "DESC_ID";
    public static final String IMPLICIT = "IMPLICIT";
    public static final String OPTIONAL = "OPTIONAL";
    public static final String DEPR = "DEPR";
    public static final String DEPR_ID = "DEPR_ID";
    public static final String ENTRY_POINT = "ENTRY_POINT";
    public static final String VISIBLE = "VISIBLE";
    public static final String ARG_LIST = "ARGUMENT_LIST";
    public static final String EXC_LIST = "EXCEPTION_LIST";
    public static final String NATIVE_LIB = "NATIVE_LIBRARIES";
    public static final String LIB_CLASS = "LIBRARY_CLASS";
    public static final String SEV = "SEV";
    public static final String ID = "ID";
    public static final String GENERIC = "GENERIC";
    public static final String FILE = "FILE";
    public static final String EXC = "EXCEPTION";
    public static final String ALL_PLATS = "ALL_PLATFORMS";
    public static final String LIB_PLATS = "LIBRARY_PLATFORMS";
    public static final String INOUT = "IN-OUT";
    public static final String RETURN_TYPE = "RETURN_TYPE";
    public static final String STR_TRUE = "TRUE";
    public static final String STR_FALSE = "FALSE";
    public static final String EMPTY_STR = "";
    public static final String S_UNKNOWN_PLAT = "Error: Unknown Platform Common Name ";

    public static String strArrToStr(String[] arr) {
        String retStr = EMPTY_STR;
        if (arr == null) {
            return retStr;
        }
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            retStr = retStr + arr[i];
            if (i == n - 1) continue;
            retStr = retStr + ",";
        }
        return retStr;
    }

    public static String platArrToString(int[] arr) {
        String retStr = EMPTY_STR;
        if (arr == null) {
            return retStr;
        }
        int n = arr.length;
        for (int i = 0; i < n; ++i) {
            retStr = retStr + OiixPlatform.getPlatformCommonName(arr[i]);
            if (i == n - 1) continue;
            retStr = retStr + " ";
        }
        return retStr;
    }

    public static boolean arePlatsSame(int[] plat1, int[] plat2) {
        if (plat1 == null || plat2 == null) {
            return false;
        }
        if (plat1.length != plat2.length) {
            return false;
        }
        for (int i = 0; i < plat1.length; ++i) {
            boolean bFound = false;
            for (int j = 0; j < plat2.length; ++j) {
                if (plat1[i] != plat2[j]) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    public static Vector platCommonNames2IntVector(String s, String delim, Vector vErrs) {
        if (s == null || s.equals(ALL_PLATS)) {
            int[] iaPlats = OiixPlatform.getPlatforms();
            s = OiilXMLHelper.platArrToString(iaPlats);
        }
        StringTokenizer st = new StringTokenizer(s, delim);
        Vector retVect = new Vector();
        while (st.hasMoreTokens()) {
            String sCurToken = st.nextToken();
            int iCurPlat = OiixPlatform.getPlatformIDFromCommonName(sCurToken);
            if (iCurPlat == 0) {
                int iPG = OiixPlatform.getPlatGroupIDFromCommonName(sCurToken);
                if (iPG == 0) {
                    if (vErrs == null) continue;
                    vErrs.addElement("Error: Unknown Platform Common Name \"" + sCurToken + "\".");
                    continue;
                }
                Vector vPlatsInGroup = OiixPlatform.getPlatsInGroup(iPG);
                int nPlats = vPlatsInGroup.size();
                for (int i = 0; i < nPlats; ++i) {
                    Object oPlat = vPlatsInGroup.elementAt(i);
                    if (retVect.contains(oPlat)) continue;
                    retVect.addElement(oPlat);
                }
                continue;
            }
            retVect.addElement(new Integer(iCurPlat));
        }
        retVect.trimToSize();
        return retVect;
    }

    public static int[] platCommonNames2IntArray(String s, String delim, Vector vErrs) {
        Vector vc = OiilXMLHelper.platCommonNames2IntVector(s, delim, vErrs);
        int len = vc.size();
        int[] retArr = new int[len];
        for (int i = 0; i < len; ++i) {
            retArr[i] = (Integer)vc.elementAt(i);
        }
        return retArr;
    }

    static String[] string2StringArray(String sa) {
        StringTokenizer st = new StringTokenizer(sa, ",");
        int len = st.countTokens();
        String[] retArr = new String[len];
        int i = 0;
        while (st.hasMoreTokens()) {
            retArr[i++] = st.nextToken();
        }
        return retArr;
    }

    static int[] getPlatsIntersection(int[] libPlats, int[] argPlats) {
        int[] retValue = new int[Math.min(libPlats.length, argPlats.length)];
        int index = 0;
        block0: for (int i = 0; i < libPlats.length; ++i) {
            for (int j = 0; j < argPlats.length; ++j) {
                if (libPlats[i] == 0 || argPlats[j] == 0 || libPlats[i] != argPlats[j]) continue;
                retValue[index++] = libPlats[i];
                continue block0;
            }
        }
        return retValue;
    }

    public static BitSet getBitSetFromString(String sBitSet) {
        if (sBitSet == null || sBitSet.length() <= 2) {
            return new BitSet();
        }
        BitSet bs = new BitSet();
        if (sBitSet.startsWith("{")) {
            sBitSet = sBitSet.substring(1);
        }
        if (sBitSet.endsWith("}")) {
            sBitSet = sBitSet.substring(0, sBitSet.length() - 1);
        }
        int[] nSetBits = OiilXMLHelper.getIntArrFromString(sBitSet, ", ");
        BitSet retBS = new BitSet();
        for (int i = 0; i < nSetBits.length; ++i) {
            retBS.set(nSetBits[i]);
        }
        return retBS;
    }

    public static int[] getIntArrFromString(String sList, String delim) {
        if (sList != null) {
            StringTokenizer st = new StringTokenizer(sList, delim);
            int numTokens = st.countTokens();
            int[] retArr = new int[numTokens];
            int i = 0;
            while (st.hasMoreTokens()) {
                String sPlat = st.nextToken();
                try {
                    retArr[i++] = Integer.parseInt(sPlat);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return retArr;
        }
        return new int[0];
    }

    public static String platVect2String(Vector plats, String delim) {
        int i;
        if (plats == null || plats.size() == 0) {
            return ALL_PLATS;
        }
        int nSize = plats.size();
        if (nSize == OiixPlatform.getPlatforms().length) {
            int[] iaplats = new int[nSize];
            for (i = 0; i < nSize; ++i) {
                iaplats[i] = Integer.valueOf(plats.elementAt(i).toString());
            }
            if (OiilXMLHelper.arePlatsSame(iaplats, OiixPlatform.getPlatforms())) {
                return ALL_PLATS;
            }
        }
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < plats.size(); ++i) {
            if (i != 0) {
                sb.append(delim);
            }
            sb.append(OiixPlatform.getPlatformCommonName((Integer)plats.elementAt(i)));
        }
        return sb.toString();
    }
}

