/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiil;

import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiil.OiilWinActionInputs;
import oracle.sysman.oii.oiil.OiilWinActions;
import oracle.sysman.oii.oiip.oiipg.OiipgPlatformNotSupportedException;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiix.OiixFolderOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixRegistryOps;
import oracle.sysman.oii.oiix.OiixServiceOps;

public class OiilWinActionsInstall
extends OiilWinActions {
    public OiilWinActionsInstall() {
        this.m_bInstall = true;
        this.m_bCluster = false;
    }

    @Override
    protected void runRegAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        String sRoot = inputs.getRegRootValue();
        String sKey = inputs.getValueAsString("Key");
        if (sAction.equalsIgnoreCase("createKey")) {
            try {
                OiixRegistryOps.RegCreateKey(sRoot, sKey);
            }
            catch (OiilNativeException ne) {
                throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
            }
        }
        if (sAction.equalsIgnoreCase("setvalue")) {
            try {
                String sType = inputs.getValueAsString("Type");
                String sName = inputs.getValueAsString("Name");
                String sVal = inputs.getValueAsString("Value");
                String sUpdateType = inputs.getValueAsString("UpdateType");
                int nUpdateType = inputs.getValueAsInt("UpdateType");
                switch (OiilWinActionsInstall.getValueType(sType)) {
                    case 1: {
                        OiixRegistryOps.RegSetBinValue(sRoot, sKey, sName, sVal);
                        break;
                    }
                    case 2: {
                        OiixRegistryOps.RegSetNumValue(sRoot, sKey, sName, Integer.parseInt(sVal));
                        break;
                    }
                    case 3: {
                        OiixRegistryOps.RegSetValue(sRoot, sKey, sName, sVal, nUpdateType);
                        break;
                    }
                    case 4: {
                        String[] saVal = OiixFunctionOps.explodeString(OiilWinActionsInstall.removeBraces(sVal), ",");
                        OiixRegistryOps.RegSetStringArrayValue(sRoot, sKey, sName, saVal);
                        break;
                    }
                }
            }
            catch (OiilNativeException ne) {
                throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
            }
        }
    }

    @Override
    protected void runShortcutAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        if (sAction.equals("") || sAction.equalsIgnoreCase("create")) {
            this.createItem(inputs);
        } else if (sAction.equalsIgnoreCase("remove")) {
            this.removeItem(inputs);
        }
    }

    @Override
    protected void runServiceAction(OiilWinActionInputs inputs, OiisCompContext context) throws OiilActionException {
        String sAction = inputs.getValueAsString("Action");
        if (sAction.equalsIgnoreCase("create")) {
            this.createService(inputs);
        } else if (sAction.equalsIgnoreCase("remove")) {
            this.deleteService(inputs);
        } else if (sAction.equalsIgnoreCase("start")) {
            this.startService(inputs);
        } else if (sAction.equalsIgnoreCase("stop")) {
            this.stopService(inputs);
        }
    }

    private void createItem(OiilWinActionInputs inputs) throws OiilActionException {
        String sExeName = inputs.getValueAsNativePath("ExeName");
        String sWorkdir = inputs.getValueAsNativePath("WorkingDirectory");
        String sFolderName = inputs.getValueAsNativePath("FolderName");
        String sIconName = inputs.getValueAsNativePath("Icon");
        String sIconFileName = inputs.getValueAsNativePath("IconSrc");
        String sItemName = inputs.getValueAsString("ItemName");
        String sParamName = inputs.getValueAsString("Parameters");
        String sParamList = inputs.getValueAsString("ParametersList");
        String sStartupItem = inputs.getValueAsString("StartupItem");
        String sDesktopItem = inputs.getValueAsString("DesktopItem");
        int nIconIdx = inputs.getValueAsInt("IconIndex");
        int nCmdType = inputs.getValueAsInt("RunType");
        if (sParamName.indexOf(32) != -1) {
            sParamName = OiilWinActionsInstall.addQuotes(sParamName);
        }
        if (!sParamName.equals("")) {
            sParamName = sParamName + " " + OiilWinActionsInstall.removeBraces(sParamList.trim());
            sParamName = sParamName.trim();
        }
        if (sIconFileName.equals("")) {
            sIconFileName = sExeName;
        }
        try {
            OiixFolderOps.ntCreateItem(sExeName, sParamName, sFolderName, sItemName, sIconFileName, nIconIdx, sWorkdir, nCmdType);
            if (OiilWinActionsInstall.isTrue(sStartupItem)) {
                OiixFolderOps.ntCreateStartupItem(sExeName, sParamName, sFolderName, sItemName, sIconFileName, nIconIdx, sWorkdir, nCmdType);
            }
            if (OiilWinActionsInstall.isTrue(sDesktopItem)) {
                OiixFolderOps.ntCreateDesktopItem(sExeName, sParamName, sFolderName, sItemName, sIconFileName, nIconIdx, sWorkdir, nCmdType);
            }
        }
        catch (OiipgPlatformNotSupportedException oiipgPlatformNotSupportedException) {
        }
        catch (OiilNativeException ne) {
            throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
        }
    }

    public void removeItem(OiilWinActionInputs inputs) throws OiilActionException {
        String sFolderName = inputs.getValueAsNativePath("FolderName");
        String sItemName = inputs.getValueAsString("ItemName");
        String sStartupItem = inputs.getValueAsString("StartupItem");
        String sDesktopItem = inputs.getValueAsString("DesktopItem");
        try {
            OiixFolderOps.ntRemoveItem(sFolderName, sItemName);
            if (OiilWinActionsInstall.isTrue(sStartupItem)) {
                OiixFolderOps.ntRemoveStartupItem(sFolderName, sItemName);
            }
            if (OiilWinActionsInstall.isTrue(sDesktopItem)) {
                OiixFolderOps.ntRemoveDesktopItem(sFolderName, sItemName);
            }
        }
        catch (OiipgPlatformNotSupportedException oiipgPlatformNotSupportedException) {
        }
        catch (OiilNativeException ne) {
            throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
        }
    }

    private void createService(OiilWinActionInputs inputs) throws OiilActionException {
        String sExeName = inputs.getValueAsString("ExeName");
        String sServiceName = inputs.getValueAsString("ServiceName");
        String sDisplayName = inputs.getValueAsString("DisplayName");
        String sDepName = inputs.getValueAsString("DependencyNames");
        String sAccName = inputs.getValueAsString("AccountName");
        String sPassword = inputs.getValueAsString("Password");
        int nAccess = inputs.getValueAsInt("Access");
        int nType = inputs.getValueAsInt("Type");
        int nStartType = inputs.getValueAsInt("StartType");
        int nErrCtrl = inputs.getValueAsInt("ErrorControl");
        try {
            OiixServiceOps.ntCreateServiceAdvanced(sExeName, sServiceName, nAccess, nStartType, nType, nErrCtrl, sDepName, sDisplayName, sPassword, sDisplayName);
        }
        catch (OiipgPlatformNotSupportedException oiipgPlatformNotSupportedException) {
        }
        catch (OiilNativeException ne) {
            throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
        }
    }

    public void deleteService(OiilWinActionInputs inputs) throws OiilActionException {
        String sServiceName = inputs.getValueAsString("ServiceName");
        try {
            OiixServiceOps.ntDeleteService(sServiceName);
        }
        catch (OiipgPlatformNotSupportedException oiipgPlatformNotSupportedException) {
        }
        catch (OiilNativeException ne) {
            throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
        }
    }

    public void startService(OiilWinActionInputs inputs) throws OiilActionException {
        String sServiceName = inputs.getValueAsString("ServiceName");
        try {
            OiixServiceOps.ntStartService(sServiceName);
        }
        catch (OiipgPlatformNotSupportedException oiipgPlatformNotSupportedException) {
        }
        catch (OiilNativeException ne) {
            throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
        }
    }

    public void stopService(OiilWinActionInputs inputs) throws OiilActionException {
        String sServiceName = inputs.getValueAsString("ServiceName");
        try {
            OiixServiceOps.ntStopService(sServiceName);
        }
        catch (OiipgPlatformNotSupportedException oiipgPlatformNotSupportedException) {
        }
        catch (OiilNativeException ne) {
            throw new OiilActionException(inputs.getName() + "Exception", ne.getExceptionString());
        }
    }
}

